/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.web.filter;

import java.util.HashMap;
import java.util.Map;
import org.alinous.web.filter.FilterZone;

public class FilterConfig {
    private Map<String, FilterZone> zonesMap = new HashMap<String, FilterZone>();

    public void addFilterZone(FilterZone zone) {
        this.zonesMap.put(zone.getArea(), zone);
    }

    public boolean hasOutputFilter(String requestPath) {
        FilterZone zone = this.getZone(requestPath);
        if (zone == null) {
            return false;
        }
        return zone.getOutFilterClass() != null;
    }

    public boolean hasInputFilter(String requestPath) {
        FilterZone zone = this.getZone(requestPath);
        if (zone == null) {
            return false;
        }
        return zone.getInFilterClass() != null;
    }

    public FilterZone getZone(String requestPath) {
        FilterZone retZone = null;
        for (String area : this.zonesMap.keySet()) {
            FilterZone curZone = this.zonesMap.get(area);
            if (!requestPath.startsWith(curZone.getArea())) continue;
            if (retZone == null) {
                retZone = curZone;
                continue;
            }
            if (curZone.getArea().length() <= retZone.getArea().length()) continue;
            retZone = curZone;
        }
        return retZone;
    }
}

