/*
 * Decompiled with CFR 0.152.
 */
package org.alinous.web.filter;

import java.io.StringWriter;
import java.lang.reflect.Method;
import org.alinous.AlinousCore;
import org.alinous.web.filter.FilterZone;
import org.alinous.web.filter.IHttpWrapper;

public class WebFilterManager {
    private AlinousCore core;

    public WebFilterManager(AlinousCore core) {
        this.core = core;
    }

    public boolean hasOutputFilter(String requestPath) {
        return this.core.getConfig().getFilterConfig().hasOutputFilter(requestPath);
    }

    public boolean hasInputFilter(String requestPath) {
        return this.core.getConfig().getFilterConfig().hasInputFilter(requestPath);
    }

    public void doOutputFilter(IHttpWrapper wr, String requestPath, StringWriter stringWriter) throws Throwable {
        FilterZone zone = this.core.getConfig().getFilterConfig().getZone(requestPath);
        Class<?> clazz = this.core.getJavaConnector().loadClass(zone.getOutFilterClass());
        Class<?> wrapClass = this.core.getJavaConnector().loadClass("org.alinous.web.filter.HttpWrapperEx");
        Object filterObj = clazz.newInstance();
        Object wrapObj = wrapClass.newInstance();
        Method m = wrapClass.getMethod("setWrapper", Object.class);
        m.invoke(wrapObj, wr);
        m = clazz.getMethod("textContentOutput", wrapClass, String.class);
        m.invoke(filterObj, wrapObj, stringWriter.getBuffer().toString());
    }

    public String doInputFilter(IHttpWrapper wr, String requestPath, String inString) throws Throwable {
        FilterZone zone = this.core.getConfig().getFilterConfig().getZone(requestPath);
        Class<?> clazz = this.core.getJavaConnector().loadClass(zone.getInFilterClass());
        Class<?> wrapClass = this.core.getJavaConnector().loadClass("org.alinous.web.filter.HttpWrapperEx");
        Object filterObj = clazz.newInstance();
        Object wrapObj = wrapClass.newInstance();
        Method m = wrapClass.getMethod("setWrapper", Object.class);
        m.invoke(wrapObj, wr);
        m = clazz.getMethod("filter", wrapClass, String.class);
        return (String)m.invoke(filterObj, wrapObj, inString);
    }
}

