/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.BorrowPolicy;
import org.apache.commons.pool.composite.CompositeKeyedObjectPool;
import org.apache.commons.pool.composite.CompositeObjectPoolFactory;
import org.apache.commons.pool.composite.ExhaustionPolicy;
import org.apache.commons.pool.composite.KeyedPoolableObjectFactoryAdapter;
import org.apache.commons.pool.composite.LimitPolicy;
import org.apache.commons.pool.composite.TrackingPolicy;

public final class CompositeKeyedObjectPoolFactory
implements KeyedObjectPoolFactory,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4099516083825584165L;
    private final CompositeObjectPoolFactory factory;

    public CompositeKeyedObjectPoolFactory(KeyedPoolableObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("keyed poolable object factory must not be null.");
        }
        this.factory = new CompositeObjectPoolFactory(new KeyedPoolableObjectFactoryAdapter(factory));
    }

    public CompositeKeyedObjectPoolFactory(PoolableObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("poolable object factory must not be null.");
        }
        this.factory = new CompositeObjectPoolFactory(factory);
    }

    public CompositeKeyedObjectPoolFactory(CompositeObjectPoolFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("composite object pool factory must not be null.");
        }
        try {
            this.factory = (CompositeObjectPoolFactory)factory.clone();
        }
        catch (CloneNotSupportedException cnse) {
            IllegalArgumentException iae = new IllegalArgumentException("factory must support cloning.");
            iae.initCause(cnse);
            throw iae;
        }
    }

    public KeyedObjectPool createPool() {
        try {
            return new CompositeKeyedObjectPool((ObjectPoolFactory)this.factory.clone());
        }
        catch (CloneNotSupportedException cnse) {
            IllegalStateException ise = new IllegalStateException("backing object pool factory doesn't support cloning.");
            ise.initCause(cnse);
            throw ise;
        }
    }

    public static KeyedObjectPool createPool(ObjectPoolFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("object pool factory must not be null.");
        }
        return new CompositeKeyedObjectPool(factory);
    }

    public KeyedPoolableObjectFactory getKeyedFactory() {
        PoolableObjectFactory pof = this.factory.getFactory();
        if (pof instanceof KeyedPoolableObjectFactoryAdapter) {
            return ((KeyedPoolableObjectFactoryAdapter)pof).getDelegate();
        }
        return null;
    }

    public void setKeyedFactory(KeyedPoolableObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("keyed object factory must not be null.");
        }
        this.setFactory(new KeyedPoolableObjectFactoryAdapter(factory));
    }

    public PoolableObjectFactory getFactory() {
        PoolableObjectFactory pof = this.factory.getFactory();
        if (pof instanceof KeyedPoolableObjectFactoryAdapter) {
            return null;
        }
        return pof;
    }

    public void setFactory(PoolableObjectFactory factory) throws IllegalArgumentException {
        if (factory == null) {
            throw new IllegalArgumentException("poolable object factory must not be null.");
        }
        this.factory.setFactory(factory);
    }

    public BorrowPolicy getBorrowPolicy() {
        return this.factory.getBorrowPolicy();
    }

    public void setBorrowPolicy(BorrowPolicy borrowPolicy) throws IllegalArgumentException {
        this.factory.setBorrowPolicy(borrowPolicy);
    }

    public ExhaustionPolicy getExhaustionPolicy() {
        return this.factory.getExhaustionPolicy();
    }

    public void setExhaustionPolicy(ExhaustionPolicy exhaustionPolicy) throws IllegalArgumentException {
        this.factory.setExhaustionPolicy(exhaustionPolicy);
    }

    public int getMaxIdlePerKey() {
        return this.factory.getMaxIdle();
    }

    public void setMaxIdlePerKey(int maxIdle) {
        this.factory.setMaxIdle(maxIdle);
    }

    public int getMaxActivePerKey() {
        return this.factory.getMaxActive();
    }

    public void setMaxActivePerKey(int maxActive) {
        this.factory.setMaxActive(maxActive);
    }

    public LimitPolicy getLimitPolicy() {
        return this.factory.getLimitPolicy();
    }

    public void setLimitPolicy(LimitPolicy limitPolicy) throws IllegalArgumentException {
        this.factory.setLimitPolicy(limitPolicy);
    }

    public int getMaxWaitMillis() {
        return this.factory.getMaxWaitMillis();
    }

    public void setMaxWaitMillis(int maxWaitMillis) {
        this.factory.setMaxWaitMillis(maxWaitMillis);
    }

    public TrackingPolicy getTrackingPolicy() {
        return this.factory.getTrackingPolicy();
    }

    public void setTrackingPolicy(TrackingPolicy trackingPolicy) throws IllegalArgumentException {
        this.factory.setTrackingPolicy(trackingPolicy);
    }

    public boolean isValidateOnReturn() {
        return this.factory.isValidateOnReturn();
    }

    public void setValidateOnReturn(boolean validateOnReturn) {
        this.factory.setValidateOnReturn(validateOnReturn);
    }

    public long getEvictIdleMillis() {
        return this.factory.getEvictIdleMillis();
    }

    public void setEvictIdleMillis(long evictIdleMillis) {
        this.factory.setEvictIdleMillis(evictIdleMillis);
    }

    public long getEvictInvalidFrequencyMillis() {
        return this.factory.getEvictInvalidFrequencyMillis();
    }

    public void setEvictInvalidFrequencyMillis(long evictInvalidFrequencyMillis) {
        this.factory.setEvictInvalidFrequencyMillis(evictInvalidFrequencyMillis);
    }

    public String toString() {
        return "CompositeKeyedObjectPoolFactory{factory=" + this.factory + '}';
    }

    public Object clone() throws CloneNotSupportedException {
        if (!this.getClass().equals(CompositeKeyedObjectPoolFactory.class)) {
            throw new CloneNotSupportedException("Subclasses must not call super.clone()");
        }
        return new CompositeKeyedObjectPoolFactory(this.factory);
    }
}

