/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import org.apache.commons.pool.composite.AbstractManager;
import org.apache.commons.pool.composite.CompositeObjectPool;
import org.apache.commons.pool.composite.Manager;

abstract class DelegateManager
extends AbstractManager
implements Serializable {
    private static final long serialVersionUID = -8516695099130531284L;
    private final Manager delegate;

    protected DelegateManager(Manager delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null.");
        }
        this.delegate = delegate;
    }

    public void setCompositeObjectPool(CompositeObjectPool objectPool) {
        super.setCompositeObjectPool(objectPool);
        this.delegate.setCompositeObjectPool(objectPool);
    }

    public Object nextFromPool() throws Exception {
        return this.delegate.nextFromPool();
    }

    public void returnToPool(Object obj) {
        this.delegate.returnToPool(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

