/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import java.util.TimerTask;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.EvictorLender;
import org.apache.commons.pool.composite.Lender;

final class InvalidEvictorLender
extends EvictorLender
implements Serializable {
    private static final long serialVersionUID = -3200445766813431919L;
    private long validationFrequencyMillis = 600000L;

    InvalidEvictorLender(Lender delegate) throws IllegalArgumentException {
        super(delegate);
    }

    protected EvictorLender.EvictorReference createReference(Object obj) {
        return new InvalidEvictorReference(obj);
    }

    public long getValidationFrequencyMillis() {
        return this.validationFrequencyMillis;
    }

    public void setValidationFrequencyMillis(long validationFrequencyMillis) throws IllegalArgumentException {
        if (validationFrequencyMillis < 0L) {
            throw new IllegalArgumentException("validationFrequencyMillis must not be negative. was: " + validationFrequencyMillis);
        }
        this.validationFrequencyMillis = validationFrequencyMillis;
    }

    public String toString() {
        return "InvalidEvictor{validationFrequencyMillis=" + this.validationFrequencyMillis + ", delegate=" + super.toString() + '}';
    }

    private class InvalidEvictorReference
    implements EvictorLender.EvictorReference {
        private Object referant;
        private final TimerTask task;

        InvalidEvictorReference(Object referant) {
            this.referant = referant;
            this.task = new InvalidEvictorTask();
            InvalidEvictorLender.this.getTimer().schedule(this.task, InvalidEvictorLender.this.validationFrequencyMillis, InvalidEvictorLender.this.validationFrequencyMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get() {
            InvalidEvictorReference invalidEvictorReference = this;
            synchronized (invalidEvictorReference) {
                return this.referant;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            InvalidEvictorReference invalidEvictorReference = this;
            synchronized (invalidEvictorReference) {
                this.task.cancel();
                if (this.referant instanceof EvictorLender.EvictorReference) {
                    ((EvictorLender.EvictorReference)this.referant).clear();
                }
                this.referant = null;
            }
        }

        private class InvalidEvictorTask
        extends TimerTask {
            private InvalidEvictorTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (InvalidEvictorReference.this.referant == null) {
                    this.cancel();
                    return;
                }
                PoolableObjectFactory factory = InvalidEvictorLender.this.getObjectPool().getFactory();
                InvalidEvictorReference invalidEvictorReference = InvalidEvictorReference.this;
                synchronized (invalidEvictorReference) {
                    Object r = InvalidEvictorReference.this.referant;
                    while (r instanceof Lender.LenderReference) {
                        r = ((Lender.LenderReference)r).get();
                    }
                    if (r == null) {
                        InvalidEvictorReference.this.clear();
                        return;
                    }
                    try {
                        factory.activateObject(r);
                        if (factory.validateObject(r)) {
                            factory.passivateObject(r);
                        } else {
                            factory.destroyObject(r);
                            InvalidEvictorReference.this.clear();
                        }
                    }
                    catch (Exception e) {
                        InvalidEvictorReference.this.clear();
                    }
                }
            }
        }
    }
}

