/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.composite;

import java.io.Serializable;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.composite.CompositeKeyedObjectPool;

final class KeyedPoolableObjectFactoryAdapter
implements PoolableObjectFactory,
Serializable {
    private static final long serialVersionUID = 8664321206626066192L;
    private final KeyedPoolableObjectFactory delegate;
    private transient ThreadLocal keys;

    KeyedPoolableObjectFactoryAdapter(KeyedPoolableObjectFactory delegate) {
        this.delegate = delegate;
    }

    public void setCompositeKeyedObjectPool(CompositeKeyedObjectPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException("pool must not be null.");
        }
        if (pool.getKeys() == null) {
            throw new IllegalArgumentException("pool's keys must not be null.");
        }
        this.keys = pool.getKeys();
    }

    public Object makeObject() throws Exception {
        return this.delegate.makeObject(this.keys.get());
    }

    public void destroyObject(Object obj) throws Exception {
        this.delegate.destroyObject(this.keys.get(), obj);
    }

    public boolean validateObject(Object obj) {
        return this.delegate.validateObject(this.keys.get(), obj);
    }

    public void activateObject(Object obj) throws Exception {
        this.delegate.activateObject(this.keys.get(), obj);
    }

    public void passivateObject(Object obj) throws Exception {
        this.delegate.passivateObject(this.keys.get(), obj);
    }

    KeyedPoolableObjectFactory getDelegate() {
        return this.delegate;
    }
}

