// AdhocEventSink.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "AdhocEventSink.h"
using Alpha::Ambient::CAdhocEventSink;


// CAdhocEventSink class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAdhocEventSink::CAdhocEventSink(IConnectionPoint* pConnectionPoint, const IID& iid, const wstring& strPrefix)
		: m_pConnectionPoint(pConnectionPoint), m_iid(iid), m_pTopLevelObject(0), m_strPrefix(strPrefix) {
	assert(m_pConnectionPoint != 0);
	assert(!strPrefix.empty());
	m_pConnectionPoint->AddRef();
}

///	fXgN^
CAdhocEventSink::~CAdhocEventSink() {
	m_pConnectionPoint->Release();
	if(m_pTopLevelObject != 0)
		m_pTopLevelObject->Release();
}

///	ڑ|CgԂ
void CAdhocEventSink::GetConnectionPoint(IConnectionPoint** ppConnectionPoint) const {
	assert(ppConnectionPoint != 0);
	*ppConnectionPoint = m_pConnectionPoint;
	(*ppConnectionPoint)->AddRef();
}

///	NbL[Ԃ
DWORD CAdhocEventSink::GetCookie() const {
	return m_dwCookie;
}

///	@see	IDispatch::GetIDsOfNames
STDMETHODIMP CAdhocEventSink::GetIDsOfNames(REFIID riid,
		OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId) {
	assert(riid == IID_NULL);
	VERIFY_POINTER(rgDispId);

	if(m_pTopLevelObject == 0)	// XNvgIuWFNg܂͂ĂȂ
		return DISP_E_MEMBERNOTFOUND;

	// CxgɐړtĈϏ
	OLECHAR**	rgszHandlerNames = new OLECHAR*[cNames];
	for(unsigned int iName = 0; iName < cNames; ++iName) {
		rgszHandlerNames[iName] = new OLECHAR[m_strPrefix.length() + wcslen(rgszNames[iName]) + 1];
		wcscpy(rgszHandlerNames[iName], m_strPrefix.c_str());
		wcscat(rgszHandlerNames[iName], rgszNames[iName]);
	}
	HRESULT	hr = m_pTopLevelObject->GetIDsOfNames(riid, rgszHandlerNames, cNames, lcid, rgDispId);

	// n
	for(unsigned int iName = 0; iName < cNames; ++iName)
		delete[] rgszHandlerNames[iName];
	delete[] rgszHandlerNames;

	return hr;
}

///	@see	IDispatch::GetTypeInfo
STDMETHODIMP CAdhocEventSink::GetTypeInfo(UINT iTInfo, LCID lcid, ITypeInfo** ppTInfo) {
	VERIFY_POINTER(ppTInfo);
	*ppTInfo = 0;
	return TYPE_E_ELEMENTNOTFOUND;
}

///	@see	IDispatch::GetTypeInfoCount
STDMETHODIMP CAdhocEventSink::GetTypeInfoCount(UINT* pctinfo) {
	VERIFY_POINTER(pctinfo);
	*pctinfo = 0;
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAdhocEventSink::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(m_pTopLevelObject == 0)
		return DISP_E_MEMBERNOTFOUND;
	return m_pTopLevelObject->Invoke(dispidMember, riid,
			lcid, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
}

///	@see	IUnknown::QueryInterface
STDMETHODIMP CAdhocEventSink::QueryInterface(REFIID riid, void** ppvObject) {
	VERIFY_POINTER(ppvObject);

	if(riid == m_iid || riid == IID_IDispatch || riid == IID_IUnknown)
		*ppvObject = static_cast<IDispatch*>(this);
	else
		return (*ppvObject = 0), E_NOINTERFACE;
	reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();

	return S_OK;
}

///	NbL[̐ݒ
void CAdhocEventSink::SetCookie(DWORD dwCookie) {
	m_dwCookie = dwCookie;
}

///	XNvgIuWFNg̐ݒ
void CAdhocEventSink::SetScriptObject(IDispatch* pScriptObject) {
	assert(pScriptObject != 0 && m_pTopLevelObject == 0);
	m_pTopLevelObject = pScriptObject;
}