// Alpha.cpp : AvP[Vp̃Gg |Cg̒`
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "Alpha.h"
#include "CommandManager.h"
#include "EventHandlerScript.h"
#include "AboutDlg.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"
#include "BookmarkDlg.h"
#include "CodePagesDlg.h"
#include "FilePropertyDlg.h"
#include "FileOperationDlg.h"
#include "ExecuteCommandDlg.h"
//#include "DebugDlg.h"
#include "SelectLanguageDlg.h"
#include "ConfirmUnsavedDocumentDlg.h"
#include "NewFileFormatDlg.h"
#include "..\Manah\WaitCursor.h"
#include "..\Manah\DC.h"
#include "..\Manah\GDIObject.h"
#include <algorithm>
#include <fstream>
#include <dlgs.h>
//#include "Msxml3.tlh"	// MSXML2::IXMLDOMDocument
using namespace Alpha;
using namespace Ascension;
using namespace Manah::Windows::GDI;
using namespace Manah::Text;


// O[o֐
/////////////////////////////////////////////////////////////////////////////

///	Gg|Cg
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	OSVERSIONINFOA	osvi;

	// NT nׂ
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFOA);
	::GetVersionExA(&osvi);
	if(!toBoolean(osvi.dwPlatformId & VER_PLATFORM_WIN32_NT)) {
		if(::GetUserDefaultLangID() == 0x0411)
			::MessageBoxA(0, "gp̃o[W OS ł Alpha s邱Ƃ͂ł܂B", "Alpha", MB_ICONHAND);
		else
			::MessageBoxA(0, "This application runs under WinNT platform only.", "Alpha", MB_ICONHAND);
		return -1;
	}

	CAlphaApp*	pApp = new CAlphaApp();

	// ȒPȑdN}~
	HWND	hExistWnd = ::FindWindowW(L"Alpha", 0);
	if(!toBoolean(::IsWindow(hExistWnd))) {	// B Alpha vZX
		INITCOMMONCONTROLSEX	iccex;

		::OleInitialize(0);	// STA ɓ + T[rX̏
		ZeroMemory(&iccex, sizeof(INITCOMMONCONTROLSEX));
		iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
		iccex.dwICC = ICC_BAR_CLASSES | ICC_COOL_CLASSES
			| ICC_LISTVIEW_CLASSES | ICC_TAB_CLASSES | ICC_UPDOWN_CLASS;
		::InitCommonControlsEx(&iccex);
		pApp->InitApplication(hInstance);
		pApp->InitInstance();
		pApp->Run();
		::OleUninitialize();
	} else {	// ̃vZXɃR}hCn
		COPYDATASTRUCT	cd = {0,
			(wcslen(::GetCommandLineW()) + 1) * sizeof(wchar_t), ::GetCommandLineW()};
		::SendMessageW(hExistWnd, WM_COPYDATA, 0, reinterpret_cast<LPARAM>(&cd));
		::Sleep(300);
		::SetForegroundWindow(hExistWnd);
	}

	delete pApp;

	return 0;
}


// CDocumentTypeManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocumentTypeManager::CDocumentTypeManager() {
	TDocumentType	type;

	wcscpy(type.wszFileSpec, L"");
	type.strName = L"default";
	type.bPrivate = false;
	m_vecDocTypes.push_back(type);
}

/**
 *	^Cv̒ǉ
 *	@param type	o^镶^Cv
 */
void CDocumentTypeManager::Add(const TDocumentType& type) throw(invalid_argument) {
	if(type.strName.empty())
		throw invalid_argument("Document type name can not be empty.");
	else if(wcslen(type.wszFileSpec) == 0)
		throw invalid_argument("File name specification can not be empty.");
	m_vecDocTypes.push_back(type);
}

/**
 *	w肵O̕^Cv̔ԍԂ
 *	@param strName	^Cv
 *	@return			ԍBȂꍇ0
 */
size_t CDocumentTypeManager::Find(const wstring& strName) const {
	for(size_t i = 1; i < m_vecDocTypes.size(); ++i) {
		if(m_vecDocTypes[i].strName == strName)
			return i;
	}
	return 0;
}

/**
 *	wʒu̕^CvԂ
 *	@param iType	ʒu
 *	@return			^Cv
 */
const TDocumentType& CDocumentTypeManager::GetAt(size_t iType) const throw(out_of_range) {
	try {
		return m_vecDocTypes.at(iType);
	} catch(...) {
		throw out_of_range("Specified index is invalid.");
	}
}

/**
 *	gqɓK镶^CvԂ
 *	@param strFileName	t@C
 *	@return				^CvBK镶^CvȂꍇ0Ԗ () Ԃ
 */
const TDocumentType& CDocumentTypeManager::GetByFileName(const wstring& strFileName) const {
	if(strFileName.empty())
		return m_vecDocTypes[0];
	for(size_t i = 1; i < m_vecDocTypes.size(); ++i) {
		if(toBoolean(::PathMatchSpecW(strFileName.c_str(), m_vecDocTypes[i].wszFileSpec)))
			return m_vecDocTypes[i];
	}
	return m_vecDocTypes[0];
}

///	o^Ă镶^Cv̑Ԃ
size_t CDocumentTypeManager::GetCount() const {
	return m_vecDocTypes.size();
}

///	o^Ă镶Sč폜
void CDocumentTypeManager::RemoveAll() {
	m_vecDocTypes.clear();
	CDocumentTypeManager();
}


// CAlphaApp class implementation
/////////////////////////////////////////////////////////////////////////////

CAlphaApp* CAlphaApp::m_pInstance = 0;

///	RXgN^
CAlphaApp::CAlphaApp()
		: m_pMenu(0), m_pFileOpeMenu(0), m_pNewDocTypeMenu(0), m_pAppDocTypeMenu(0),
		m_iActiveTab(-1), m_iLastActiveTab(0), m_bSizingOutputWnd(false),
		m_pEventHandlerScript(0), /*m_pActiveDebugger(0),*/ m_pDebuggingEditor(0),
		m_pMRUManager(0), m_pScriptMacroManager(0), m_pApplication(0), m_pDocuments(0) {
	assert(CAlphaApp::m_pInstance == 0);
	CAlphaApp::m_pInstance = this;
	m_pNewDocTypeMenu = new CMenu();
	m_pCommandManager = new CCommandManager(*this);
	m_pScriptMacroManager = new CScriptMacroManager(*this);
	m_pdlgSearch = new CFindDlg(*this);
	m_pdlgGotoLine = new CGotoLineDlg(*this);
	m_pdlgBookmark = new CBookmarkDlg(*this);
/*	m_pdlgDebugBreakPoints = new CDebugBreakPointsDlg;
	m_pdlgDebugCallStack = new CDebugCallStackDlg;
	m_pdlgDebugImmediate = new CDebugImmediateDlg;
	m_pdlgDebugRunningDocuments = new CDebugRunningDocumentsDlg;
	m_pdlgDebugThreads = new CDebugThreadsDlg;
	m_pdlgDebugVariables = new CDebugVariablesDlg;*/
}

///	fXgN^
CAlphaApp::~CAlphaApp() {
	::DestroyAcceleratorTable(m_hAcceleratorTable);
//	delete m_pMenu;
//	delete m_pFileOpeMenu;
	delete m_pNewDocTypeMenu;
	delete m_pAppDocTypeMenu;
	delete m_pEventHandlerScript;
	delete m_pCommandManager;
	delete m_pScriptMacroManager;
	delete m_pdlgSearch;
	delete m_pdlgGotoLine;
	delete m_pdlgBookmark;
/*	delete m_pdlgDebugBreakPoints;
	delete m_pdlgDebugCallStack;
	delete m_pdlgDebugImmediate;
	delete m_pdlgDebugRunningDocuments;
	delete m_pdlgDebugThreads;
	delete m_pdlgDebugVariables;*/
	if(m_pApplication != 0)
		m_pApplication->Release();
	if(m_pDocuments != 0)
		m_pDocuments->Release();
	CAlphaApp::m_pInstance = 0;
}

/**
 *	w肵r[ɃhLg^CvKp
 *	@param iTab			^u
 *	@param strTypeName	Kp镶^CvB󕶎w肷Ɗgqɍ̂Kp
 */
void CAlphaApp::ApplyDocumentType(unsigned int iTab, const wstring& strTypeName /* = L"" */) {
	AssertValid();

	Manah::Windows::CWaitCursor	wc;
	CAlphaEditController*		pEditor = m_vecDocuments[iTab]->GetTextEditor();

	if(pEditor == 0)
		return;

	// CxgnhĂяo
	CAlphaView*		pView = pEditor->GetPrimaryView();
	const wstring	strDocTypeName = strTypeName.empty() ?
		m_oDocTypeManager.GetByFileName(pView->GetDocument()->GetTitle()).strName : strTypeName;

	if(strDocTypeName.empty()
			|| strDocTypeName != pView->GetDocument()->m_strDocType) {
		DISPPARAMS		params;

		pView->Freeze();
		pView->GetLexer()->Freeze();
		pView->GetLexer()->Reset();
		params.cArgs = 2;
		params.cNamedArgs = 0;
		params.rgvarg = new VARIANTARG[2];
		params.rgdispidNamedArgs = 0;
		params.rgvarg[1].vt = VT_BSTR;
		params.rgvarg[1].bstrVal = ::SysAllocString(strDocTypeName.c_str());
		params.rgvarg[0].vt = VT_DISPATCH;
		pEditor->GetAutomation(IID_ITextProcessor, &params.rgvarg[0].pdispVal);
		m_pEventHandlerScript->Invoke(OLESTR("OnApplyDocumentType"), &params);
		::SysFreeString(params.rgvarg[1].bstrVal);
		params.rgvarg[0].pdispVal->Release();
		delete[] params.rgvarg;
		pView->GetLexer()->Unfreeze();
		pView->GetDocument()->m_strDocType = strDocTypeName;
		pView->Unfreeze();
	}
	UpdateStatusBar();
}

LRESULT CALLBACK CAlphaApp::AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	if(CAlphaApp::m_pInstance != 0)
		return CAlphaApp::m_pInstance->DispatchEvent(hWnd, message, wParam, lParam);
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

LRESULT	CAlphaApp::DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_ACTIVATE:
//		if(wParam != WA_INACTIVE && !m_vecDocuments.empty() && m_iActiveTab != -1)
//			::SetFocus(GetActiveTab()->GetWindow());
		return 0L;
//	case WM_ACTIVATEAPP:
//		if(toBoolean(wParam) && m_pMainWindow != 0)
//			m_pMainWindow->SetFocus();
//		return 0L;
	case WM_COMMAND:
		return OnCommand(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
	case WM_CLOSE:
		if(!OnClose())
			return 0;
		break;
	case WM_COPYDATA:
		OnCopyData(reinterpret_cast<HWND>(wParam), reinterpret_cast<PCOPYDATASTRUCT>(lParam));
		break;
	case WM_CREATE:
		break;
	case WM_CREATENEWTAB:
		OnFileNew(wParam);
		return true;
	case WM_DESTROY:
		OnDestroy();
		break;
	case WM_DRAWITEM:
		OnDrawItem(wParam, reinterpret_cast<LPDRAWITEMSTRUCT>(lParam));
		break;
	case WM_DROPFILES:
		OnDropFiles(reinterpret_cast<HDROP>(wParam));
		break;
	case WM_ENTERMENULOOP:
		OnEnterMenuLoop(toBoolean(wParam));
		break;
	case WM_ENDSCRIPTMACRO:
		GetActiveTab()->RefreshWindow();
		break;
	case WM_EVENTHANDLER:
		m_pEventHandlerScript->Invoke(
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->first,
			reinterpret_cast<pair<const OLECHAR*, DISPPARAMS*>*>(lParam)->second);
	case WM_EXITMENULOOP:
		OnExitMenuLoop(toBoolean(wParam));
		break;
	case WM_INITMENU:
		OnInitMenu(reinterpret_cast<HMENU>(wParam));
		break;
	case WM_INITMENUPOPUP:
		OnInitMenuPopup(reinterpret_cast<HMENU>(wParam), LOWORD(lParam), toBoolean(HIWORD(lParam)));
		break;
//	case WM_KILLFOCUS:
//		// r[ɓ]
//		if(!m_vecDocuments.empty())
//			return ::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
//		return 0L;
	case WM_MEASUREITEM:
		OnMeasureItem(wParam, reinterpret_cast<LPMEASUREITEMSTRUCT>(lParam));
		break;
	case WM_MENUCHAR: {
		CMenu*	pActivePopup = new CMenu(reinterpret_cast<HMENU>(lParam));
		LRESULT	res = OnMenuChar(LOWORD(wParam), HIWORD(wParam), pActivePopup);
//		res = pActivePopup->ExecuteMenuChar(LOWORD(wParam), HIWORD(wParam));
		delete pActivePopup;
		return res;
	}
	case WM_MENUSELECT:
		OnMenuSelect(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HMENU>(lParam));
		break;
	case WM_MOUSEMOVE: {
		POINT	pt = {LOWORD(lParam), HIWORD(lParam)};
		OnMouseMove(wParam, pt);
		return 0L;
	}
	case WM_NOTIFY:
		OnNotify(wParam, reinterpret_cast<LPNMHDR>(lParam));
		break;
	case WM_SETCURSOR:
		if(OnSetCursor(reinterpret_cast<HWND>(wParam),
				static_cast<UINT>(LOWORD(lParam)), static_cast<UINT>(HIWORD(lParam))))
			return false;
		break;
	case WM_SETFOCUS:
		// m_iActiveView 悤ƂĂr[w\
		if(!m_vecDocuments.empty() && m_iActiveTab != -1
				&& reinterpret_cast<HWND>(wParam) != GetActiveTab()->GetWindow())
			::SendMessage(GetActiveTab()->GetWindow(), message, wParam, lParam);
		return 0L;
	case WM_SIZE:
		OnSize(wParam, LOWORD(lParam), HIWORD(lParam));
		break;
	case WM_SYSCHAR:
		if(toBoolean(::GetKeyState(VK_CONTROL) & 0x8000) || toBoolean(::GetKeyState(VK_SHIFT) & 0x8000)) {
			MSG	msg;
			msg.hwnd = m_pMainWindow->m_hWnd;
			msg.lParam = lParam;
			msg.message = WM_SYSCHAR;
			msg.wParam = wParam;
			::TranslateAccelerator(m_pMainWindow->m_hWnd, m_hAcceleratorTable, &msg);
			return 0L;
		}
		break;
	case WM_TIMER:
		OnTimer(wParam);
		break;
	}
	return ::DefWindowProc(hWnd, message, wParam, lParam);
}

/**
 *	݃ANeBuȃ^uւ̃|C^Ԃ
 *	@see	GetActiveDocument, GetActiveTabIndex
 */
IAlphaTab* CAlphaApp::GetActiveTab() const {
	AssertValid();
	return !m_vecDocuments.empty() ? m_vecDocuments[m_iActiveTab] : 0;
}

///	݃ANeBuȃr[̃CfbNXԂ
unsigned int CAlphaApp::GetActiveTabIndex() const {
	AssertValid();
	return m_iActiveTab;
}

/**
 *	I[g[VpC^[tFCXIuWFNgԂ
 *	@param ppApplication	[out] AvP[V (KvȂ null ł悢)
 *	@param ppDocuments		[out] RNV (KvȂ null ł悢)
 */
HRESULT CAlphaApp::GetAutomation(
		Alpha::Ambient::CApplication** ppApplication, Alpha::Ambient::CDocuments** ppDocuments) const {
	AssertValid();

	CAlphaApp*	pThis = const_cast<CAlphaApp*>(this);

	if(ppApplication != 0)	*ppApplication = 0;
	if(ppDocuments != 0)	*ppDocuments = 0;

	if(ppApplication != 0) {
		if(m_pApplication == 0) {
			pThis->m_pApplication = new Alpha::Ambient::CApplication(*pThis);
			if(m_pApplication == 0)
				return E_OUTOFMEMORY;
			pThis->m_pApplication->AddRef();
		}
		*ppApplication = m_pApplication;
		(*ppApplication)->AddRef();
	}
	if(ppDocuments != 0) {
		if(m_pDocuments == 0) {
			pThis->m_pDocuments = new Alpha::Ambient::CDocuments(*pThis);
			if(m_pDocuments == 0)
				return E_OUTOFMEMORY;
			pThis->m_pDocuments->AddRef();
		}
		*ppDocuments = m_pDocuments;
		(*ppDocuments)->AddRef();
	}
	return S_OK;
}

/**
 *	R[hy[W̖OԂBR[hy[WȂ null
 *	@param cp	R[hy[W
 */
const wchar_t* CAlphaApp::GetCodePageName(CodePage cp) {
	switch(cp) {
	case 37:	return L"č/Ji_ (IBM EBCDIC)";
	case 437:	return L"č (OEM)";
	case 500:	return L"C^[iVi (IBM EBCDIC)";
	case 708:	return L"ArA (ASMO)";
	case 709:	return L"ArA (ASMO 449+, BCON V4)";	// [*]
	case 710:	return L"ArA (Transparent Arabic)";	// [*]
	case 720:	return L"ArA (Transparent ASMO)";
	case 737:	return L"MV (437G, OEM)";
	case 775:	return L"og (OEM)";
	case 850:	return L"ꃉe I (OEM)";
	case 852:	return L"e II (OEM)";
	case 855:	return L"L (OEM)";
	case 857:	return L"gR (OEM)";
	case 858:	return L"ꃉe I + [bp (OEM)";
	case 860:	return L"|gK (OEM)";
	case 861:	return L"ACXh (OEM)";
	case 862:	return L"wuC (OEM)";
	case 863:	return L"Ji_/tX (OEM)";
	case 864:	return L"ArA (OEM)";
	case 865:	return L"k (OEM)";
	case 866:	return L"VA (OEM)";
	case 869:	return L"MV (OEM)";
	case 870:	return L"}`K/ROECE (e-2, IBM EBCDIC)";
	case 874:	return L"^C (ANSI/OEM)";
	case 875:	return L"_ MV (IBM EBCDIC)";
	case 932:	return L"{ (Vtg JIS, ANSI/OEM)";
	case 936:	return L"ȑ̎ (GBK, ANSI/OEM)";
	case 949:	return L"؍ (ANSI/OEM)";
	case 950:	return L"ɑ̎ (Big5, ANSI/OEM)";
	case 1026:	return L"gR (IBM EBCDIC)";
	case 1047:	return L"e-1/Open System (IBM EBCDIC)";
	case 1140:	return L"č/Ji_ (37 + [, IBM EBCDIC)";
	case 1141:	return L"hCc (20273 + [, IBM EBCDIC)";
	case 1142:	return L"f}[N/mEF[ (20277 + [, IBM EBCDIC)";
	case 1143:	return L"tBh/XEF[f (20278 + [, IBM EBCDIC)";
	case 1144:	return L"C^A (20280 + [, IBM EBCDIC)";
	case 1145:	return L"e AJ/XyC (20284 + [, IBM EBCDIC)";
	case 1146:	return L"p (20285 + [, IBM EBCDIC)";
	case 1147:	return L"tX (20297 + [, IBM EBCDIC)";
	case 1148:	return L"C^[iVi (500 + [, IBM EBCDIC)";
	case 1149:	return L"ACXh (20871 + [, IBM EBCDIC)";
	case 1200:	return L"Unicode (UTF-16)";
	case 1201:	return L"Unicode (UTF-16 big endian)";
	case 1250:	return L"[bp (ANSI)";
	case 1251:	return L"L (ANSI)";
	case 1252:	return L"e I (ANSI)";
	case 1253:	return L"MV (ANSI)";
	case 1254:	return L"gR (ANSI)";
	case 1255:	return L"wuC (ANSI)";
	case 1256:	return L"ArA (ANSI)";
	case 1257:	return L"og (ANSI)";
	case 1258:	return L"xgi (ANSI/OEM)";
	case 1361:	return L"؍ (Johab)";
	case 10000:	return L"[} (Macintosh)";
	case 10001:	return L"{ (Macintosh)";
	case 10002:	return L"ɑ̎ (Big5, Macintosh)";
	case 10003:	return L"؍ (Macintosh)";
	case 10004:	return L"ArA (Macintosh)";
	case 10005:	return L"wuC (Macintosh)";
	case 10006:	return L"MV I (Macintosh)";
	case 10007:	return L"L (Macintosh)";
	case 10008:	return L"ȑ̎ (GB2312, Macintosh)";
	case 10010:	return L"[}jA (Macintosh)";
	case 10017:	return L"ENCi (Macintosh)";
	case 10021:	return L"^C (Macintosh)";
	case 10029:	return L"e II (Macintosh)";
	case 10079:	return L"ACXh (Macintosh)";
	case 10081:	return L"gR (Macintosh)";
	case 10082:	return L"NA`A (Macintosh)";
	case 12000:	return L"Unicode (UTF-32)";
	case 12001:	return L"Unicode (UTF-32 big endian)";
	case 20000:	return L"p (CNS)";
	case 20001:	return L"p (TCA)";
	case 20002:	return L"p (Eten)";
	case 20003:	return L"p (IBM5550)";
	case 20004:	return L"p (TeleText)";
	case 20005:	return L"p (Wang)";
	case 20105:	return L"IRV C^[iVi At@xbg No.5 (IA5)";
	case 20106:	return L"hCc (IA5)";
	case 20107:	return L"XEF[f (IA5)";
	case 20108:	return L"mEF[ (IA5)";
	case 20127:	return L"US-ASCII";
	case 20261:	return L"T.61";
	case 20269:	return L"Non-Spacing Accent (ISO 6937)";
	case 20273:	return L"hCc (IBM EBCDIC)";
	case 20277:	return L"f}[N/mEF[ (IBM EBCDIC)";
	case 20278:	return L"tBh/XEF[f (IBM EBCDIC)";
	case 20280:	return L"C^A (IBM EBCDIC)";
	case 20284:	return L"e AJ/XyC (IBM EBCDIC)";
	case 20285:	return L"p (IBM EBCDIC)";
	case 20290:	return L"{ (J^Jig, IBM EBCDIC)";
	case 20297:	return L"tX (IBM EBCDIC)";
	case 20420:	return L"ArA (IBM EBCDIC)";
	case 20423:	return L"MV (IBM EBCDIC)";
	case 20424:	return L"wuC (IBM EBCDIC)";
	case 20833:	return L"؍g (IBM EBCDIC)";
	case 20838:	return L"^C (IBM EBCDIC)";
	case 20866:	return L"VA (KOI8)";
	case 20871:	return L"ACXh (IBM EBCDIC)";
	case 20880:	return L"L (VA, IBM EBCDIC)";
	case 20905:	return L"gR (IBM EBCDIC)";
	case 20924:	return L"e-1/Open System (1047 + [, IBM EBCDIC)";
	case 20932:	return L"{ (JIS X 0208-1990 & 0212-1990)";
	case 20936:	return L"ȑ̎ (GB2312)";
	case 21025:	return L"L (ZrAAuKA, IBM EBCDIC)";
	case 21027:	return L"Ext Alpha Lowercase";
	case 21866:	return L"ENCi (KOI8-U)";
	case 28591:	return L"e I (ISO 8859-1)";
	case 28592:	return L"[bp (ISO 8859-2)";
	case 28593:	return L"e 3 (ISO 8859-3)";
	case 28594:	return L"og (ISO 8859-4)";
	case 28595:	return L"L (ISO 8859-5)";
	case 28596:	return L"ArA (ISO 8859-6)";
	case 28597:	return L"MV (ISO 8859-7)";
	case 28598:	return L"wuC (o, ISO 8859-8)";
	case 28599:	return L"e 5 (ISO 8859-9)";
	case 28605:	return L"e 9 (ISO 8859-15)";
	case 29001:	return L"[bp 3";	// [*]
	case 38598:	return L"wuC (_, ISO 8859-8)";
	case 50001:	return L"";	// [*]
	case 50220:	return L"{ (pJ^JiȂ, ISO-2022)";
	case 50221:	return L"{ (pJ^Ji, ISO-2022)";
	case 50222:	return L"{ (JIS X 0201-1989, ISO-2022)";
	case 50225:	return L"؍ (ISO-2022)";
	case 50227:	return L"ȑ̎ (ISO-2022)";
	case 50229:	return L"ɑ̎ (ISO-2022)";
	case 50930:	return L"{ (J^Jig)";	// [*]
	case 50931:	return L"{ + č/Ji_";	// [*]
	case 50932:	return L"{ ()";	// [*]
	case 50933:	return L"؍ + ؍g";	// [*]
	case 50935:	return L"ȑ̎ + ȑ̎g";	// [*]
	case 50936:	return L"ȑ̎";	// [*]
	case 50937:	return L"ɑ̎ + č/Ji_";	// [*]
	case 50939:	return L"{ + {ꃉeg";	// [*]
	case 50949:	return L"؍ ()";	// [*]
	case 51932:	return L"{ (EUC)";	// [*]
	case 51936:	return L"ȑ̎ (EUC)";	// [*]
	case 51949:	return L"؍ (EUC)";
	case 51950:	return L"ɑ̎ (EUC)";	// [*]
	case 52936:	return L"ȑ̎ (HZ-GB2312)";
	case 54936:	return L"ȑ̎ (GB18030)";	// [WinXP ̂]
	case 57002:	return L"foiK (ISCII)";
	case 57003:	return L"xK (ISCII)";
	case 57004:	return L"^~[ (ISCII)";
	case 57005:	return L"eO (ISCII)";
	case 57006:	return L"AbT (ISCII)";
	case 57007:	return L"I[ (ISCII)";
	case 57008:	return L"Ji (ISCII)";
	case 57009:	return L"} (ISCII)";
	case 57010:	return L"OW[g (ISCII)";
	case 57011:	return L"OL[ (ISCII)";
	case 65000:	return L"Unicode (UTF-7)";
	case 65001:	return L"Unicode (UTF-8)";
	case 70000:	return L" (VXě)";
	case 70001:	return L" ([Ǔ)";
	case 70010:	return L"Unicode ()";
	case 70011:	return L"Unicode (UTF-5)";
	case 70020:	return L"AjA ()";
	case 70021:	return L"AjA (ARMSCII-7)";
	case 70022:	return L"AjA (ARMSCII-8)";
	case 70023:	return L"AjA (ARMSCII-8A)";
	case 70030:	return L"xgi ()";
	case 70031:	return L"xgi (TCVN)";
	case 70032:	return L"xgi (VISCII)";
	case 70033:	return L"xgi (VPN)";
	case 70040:	return L"{ (JIS X 0208-1998 & 0212-1998)";
	case 70041:	return L"{ (JIS X 0208-1998 & 0213-2004)";
	case 70042:	return L"{ (Vtg JIS X0212)";
	case 70043:	return L"{ (Vtg JIS X0213)";
	case 70044:	return L"{ (EUC X0212)";
	case 70045:	return L"{ (EUC X0213)";
	default:	return 0;
	}
}

/**
 *	R}h̃j[LvVԂ
 *	@param id	R}h ID
 */
const wchar_t* CAlphaApp::GetMenuLabel(CommandId id) const {

	static wchar_t	wsz[200];
	wchar_t*		psz = 0;

	if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {
		if(m_pScriptMacroManager->GetCount() != 0) { 
			wcscpy(wsz, m_pScriptMacroManager->GetName(id - CMD_EDIT_PLUGINLIST_START).c_str());
			wcscat(wsz, L"\t");
			wcscat(wsz, m_oKeyboardMap.GetKeyString(id).c_str());
		} else
			wcscpy(wsz, LoadString(MSG_FAILEDTOLOAD).c_str());
		return wsz;
	} else if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {
		swprintf(wsz, L"&%x  %s",
			id - CMD_FILE_MRULIST_START, m_pMRUManager->GetFilePathAt(id - CMD_FILE_MRULIST_START).c_str());
		return wsz;
	}
	LoadString(id, wsz, 100);
	psz = wcschr(wsz, L'\n');
	if(psz != 0)
		*psz = 0;
	wcscat(wsz, L"\t");
	wcscat(wsz, m_oKeyboardMap.GetKeyString(id).c_str());
	return wsz;
}

///	@see	CWinApp::GetModelessDialogList
void CAlphaApp::GetModelessDialogList(list<HWND>& listDlgs) const {
	listDlgs.clear();

	// [hX_CAO炱ɒǉ
	listDlgs.push_back(m_pdlgSearch->m_hWnd);
	listDlgs.push_back(m_pdlgBookmark->m_hWnd);
	listDlgs.push_back(m_pdlgGotoLine->m_hWnd);
/*	listDlgs.push_back(m_pdlgDebugCallStack->m_hWnd);
	listDlgs.push_back(m_pdlgDebugImmediate->m_hWnd);
	listDlgs.push_back(m_pdlgDebugRunningDocuments->m_hWnd);
	listDlgs.push_back(m_pdlgDebugThreads->m_hWnd);
	listDlgs.push_back(m_pdlgDebugVariables->m_hWnd);*/
}

/**
 *	^u擾
 *	@param iTab	^uԍ
 *	@return		^u
 *	@throw		<var>iTab</var> ȂƂX[
 */
IAlphaTab* CAlphaApp::GetTab(unsigned int iTab) const throw(out_of_range) {
	AssertValid();

	try {
		return m_vecDocuments.at(iTab);
	} catch(out_of_range& /* e */) {
		throw out_of_range("First argument is invalid as tab index.");
	}
}

///	JĂhLg̐Ԃ
unsigned int CAlphaApp::GetTabCount() const {
	AssertValid();
	return m_vecDocuments.size();
}

/**
 *	t@CĴɎsƂ̏
 *	@param ss	G[e
 *	@return		ʓIɃG[łꍇ (CAlphaApp::OpenFile ̖߂lƓ)
 */
bool CAlphaApp::HandleFileOpenError(Ascension::StreamStatus ss) {
	AssertValid();

	const IAlphaTab*	pActiveTab = GetActiveTab();
	assert(pActiveTab != 0);

	if(ss == SS_OK) {
		ModifyTabIcons();
		return true;
	} else if(ss == SS_READ_READONLY) {
		MessageBox(MSG_OPENEDASREADONLY,
			MB_ICONEXCLAMATION, CMessageArguments() % pActiveTab->GetFilePath());
		ModifyTabIcons();
		return true;
	} else if(ss == SS_READ_UNKNOWNCHARCODE) {
		MessageBox(MSG_FAILEDTODETECTCODEPAGE,
			MB_ICONEXCLAMATION, CMessageArguments() % pActiveTab->GetFilePath());
		ModifyTabIcons();
		return true;
	} else if(ss == SS_READ_ILLEGALCHAR) {
		MessageBox(MSG_FOUNDILLEGALCHARACTER,
			MB_ICONEXCLAMATION, CMessageArguments() % pActiveTab->GetFilePath());
		ModifyTabIcons();
		return true;
	} else {
		DWORD	dwMesId;
		switch(ss) {
		case SS_ACCESSDENIED:			dwMesId = MSG_FILEACCESSDENIED;	break;
		case SS_ILLEGALCODEPAGE:		dwMesId = MSG_ILLEGALCODEPAGE;	break;
		case SS_UNKNOWNERROR:			dwMesId = MSG_UNKNOWNERROR;		break;
		case SS_READ_HUGEFILE:			dwMesId = MSG_TOOLARGEFILE;		break;
		case SS_READ_NOEXISTS:			dwMesId = MSG_FILENOTFOUND;		break;
		case SS_READ_CANNOTRESOLVELINK:	dwMesId = MSG_FAILEDTORESOLVESHORTCUT;	break;
		}
		MessageBox(dwMesId, MB_ICONHAND, CMessageArguments() % pActiveTab->GetFilePath());
		OnFileClose(false);
		return false;
	}
}

///	@see	CWinApp::InitApplication
bool CAlphaApp::InitApplication(HINSTANCE hInstance) {
	AssertValid();

	WNDCLASSEX wcProg;

	wcProg.cbSize			= sizeof(WNDCLASSEX);
	wcProg.style			= CS_DBLCLKS/* CS_HREDRAW | CS_VREDRAW*/;
	wcProg.lpfnWndProc		= reinterpret_cast<WNDPROC>(CAlphaApp::AppWndProc);
	wcProg.cbClsExtra		= 0;
	wcProg.cbWndExtra		= 0;
	wcProg.hInstance		= hInstance;
	wcProg.hIcon			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	wcProg.hIconSm			= ::LoadIcon(hInstance, MAKEINTRESOURCE(IDR_ICONS));
	wcProg.hCursor			= ::LoadCursor(0, IDC_ARROW);
	wcProg.hbrBackground	= ::GetSysColorBrush(COLOR_BTNFACE);
	wcProg.lpszClassName	= L"Alpha";
	wcProg.lpszMenuName		= MAKEINTRESOURCE(IDR_MENU);

	return toBoolean(::RegisterClassEx(&wcProg));
}

/**
 *	CX^X̏
 *	@see	CWinApp::InitInstance
 */
bool CAlphaApp::InitInstance() {
	AssertValid();

	static CWindow	wndApp;
	RECT			rect;

	wndApp.Create(false, L"Alpha", L"", /*WS_VISIBLE |*/ WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		reinterpret_cast<HWND>(::GetModuleHandle(0)), 0, 0);

	if(!wndApp.IsWindow())
		return false;
	m_pMainWindow = &wndApp;

	// ʐݒ̓ǂݍ
	LoadINISettings();

	// XNvgɂݒ
	wchar_t									wszScriptName[MAX_PATH];
	wchar_t*								pwszFileName = 0;
	CComPtr<Alpha::Ambient::CApplication>	pApplication;

	GetAutomation(&pApplication, 0);
	::GetModuleFileNameW(0, wszScriptName, MAX_PATH);
	pwszFileName = ::PathFindFileNameW(wszScriptName);
	wcscpy(pwszFileName, IDS_MACRO_DIRECTORY_NAME IDS_EVENTSCRIPTFILENAME);
	m_pEventHandlerScript = new CEventHandlerScript(m_pMainWindow->m_hWnd, *this);
	m_pEventHandlerScript->LoadScript(wszScriptName);

	// MRU Xg̍쐬
	m_pMRUManager = new CMRUManager(GetProfileInt(L"File", L"mruLimit", 8), CMD_FILE_MRULIST_START, true);
	unsigned int	iMRU = 0;
	wchar_t			szKeyName[12];
	wstring			strFilePath;
	stack<wstring>	stkNames;
	while(true) {
		swprintf(szKeyName, L"strPath(%u)", iMRU);
		strFilePath = GetProfileString(L"MRU", szKeyName, L"");
		if(strFilePath.empty())
			break;
		stkNames.push(strFilePath);
		++iMRU;
	}
	while(!stkNames.empty()) {
		m_pMRUManager->Add(stkNames.top());
		stkNames.pop();
	}

	// vOC̃[h
	OnEditReloadPlugin();

	// o[̍쐬
	REBARINFO				rbi = {sizeof(REBARINFO), 0, 0};
	INITCOMMONCONTROLSEX	icex = {sizeof(INITCOMMONCONTROLSEX), ICC_COOL_CLASSES};
	::InitCommonControlsEx(&icex);
	m_hRebar = ::CreateWindowExW(WS_EX_TOOLWINDOW, REBARCLASSNAME, 0,
		WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | WS_CLIPCHILDREN
		| RBS_BANDBORDERS | RBS_VARHEIGHT | CCS_NODIVIDER,
		0, 0, 0, 0, wndApp, 0, m_hInstance, 0L);
	::SendMessageW(m_hRebar, RB_SETBARINFO, 0, reinterpret_cast<LPARAM>(&rbi));

	// c[o[̍쐬
	SetupToolbar();

	// Xe[^Xo[̍쐬
	m_hStatusBar = ::CreateWindowW(STATUSCLASSNAMEW, 0,
		WS_CHILD | WS_VISIBLE | CCS_BOTTOM | CCS_NODIVIDER | SBARS_SIZEGRIP | SBT_TOOLTIPS,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		m_pMainWindow->m_hWnd, reinterpret_cast<HMENU>(IDC_STATUSBAR), m_hInstance, 0L);
//	::SendMessage(m_hStatusBar, SB_SETMINHEIGHT, 4, 0L);

	// ^u̍쐬
	SIZE				sizePad = {3, 3};
	NONCLIENTMETRICSW	ncm;
	ncm.cbSize = sizeof(NONCLIENTMETRICSW);
	::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
	ncm.lfStatusFont.lfHeight = 11;
	ncm.lfStatusFont.lfWidth = 0;
	m_hTabFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
	::SetRect(&rect, 0, 2, 600, 400);
	m_wndTab.Create(m_pMainWindow->m_hWnd, rect, IDC_TAB_VIEWS);
	m_wndTab.SetFont(m_hTabFont, false);
	::SendMessage(m_hStatusBar, WM_SETFONT, reinterpret_cast<WPARAM>(m_hTabFont), 0L);

	// AEgvbgEBhE̍쐬
	m_wndOutput.Create(m_pMainWindow);
	m_wndOutput.WriteLine(OTT_GENERAL, IDS_APPFULLVERSION);

	// c[_CAO̍쐬
	m_pdlgSearch->Create(m_hInstance, IDD_DLG_SEARCH, m_pMainWindow->m_hWnd);
	m_pdlgSearch->DoModeless(false);
	m_pdlgGotoLine->Create(m_hInstance, IDD_DLG_GOTOLINE, m_pMainWindow->m_hWnd);
	m_pdlgBookmark->Create(m_hInstance, IDD_DLG_BOOKMARKS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugBreakPoints->Create(m_hInstance, IDD_DLG_DEBUGBREAKPOINTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugCallStack->Create(m_hInstance, IDD_DLG_DEBUGCALLSTACK, m_pMainWindow->m_hWnd);
//	m_pdlgDebugImmediate->Create(m_hInstance, IDD_DLG_DEBUGIMMEDIATE, m_pMainWindow->m_hWnd);
//	m_pdlgDebugRunningDocuments->Create(m_hInstance, IDD_DLG_DEBUGACTIVEDOCUMENTS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugThreads->Create(m_hInstance, IDD_DLG_DEBUGTHREADS, m_pMainWindow->m_hWnd);
//	m_pdlgDebugVariables->Create(m_hInstance, IDD_DLG_DEBUGVARIABLES, m_pMainWindow->m_hWnd);

	// ̑̏
	wndApp.DragAcceptFiles(true);
	wndApp.SetTimer(ID_TIMER_QUERYCOMMAND, 200, 0);

	wndApp.SetWindowPos(0, 0, 0, 760, 560, SWP_NOMOVE | SWP_NOZORDER);
	wndApp.CenterWindow();

	// R}hC̉
	vector<wstring>	vecArguments;
	GetCommandLineArguments(vecArguments);

	// OnApplicationInitialized Cxg
	DISPPARAMS		params;
	VARIANTARG		arg0;

	arg0.vt = VT_DISPATCH;
	arg0.pdispVal = new Ambient::CArguments(vecArguments);
	arg0.pdispVal->AddRef();
	params.cArgs = 1;
	params.rgvarg = &arg0;
	params.cNamedArgs = 0;
	params.rgdispidNamedArgs = 0;
	m_pEventHandlerScript->Invoke(
		OLESTR("OnApplicationInitialized"), &params);
	arg0.pdispVal->Release();

	// ̃r[̍쐬
	OnFileNew(::GetACP());

	SetupMenus();
	if(!toBoolean(GetProfileInt(L"View", L"visibleToolbar", true)))
		::ShowWindow(m_hRebar, SW_HIDE);
	if(!toBoolean(GetProfileInt(L"View", L"visibleStatusBar", true)))
		::ShowWindow(m_hStatusBar, SW_HIDE);
	if(!toBoolean(GetProfileInt(L"View", L"visibleTabBar", true)))
		m_wndTab.ShowWindow(SW_HIDE);
	wndApp.ShowWindow(SW_SHOW);

	// R}hC^ꂽt@CJ
	ParseCommandLine(vecArguments);

	return true;
}

///	INI t@Cݒǂݍ
void CAlphaApp::LoadINISettings() {
	AssertValid();

	// \Ɋւݒ
	if(!GetProfileStruct(L"View", L"oFont.pLogfont", &m_lfCommonFont, sizeof(LOGFONTW))) {
		ZeroMemory(&m_lfCommonFont, sizeof(LOGFONTW));
		m_lfCommonFont.lfCharSet = ANSI_CHARSET;
		m_lfCommonFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
		m_lfCommonFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		m_lfCommonFont.lfQuality = DEFAULT_QUALITY;
		m_lfCommonFont.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
		wcscpy(m_lfCommonFont.lfFaceName, L"FixedSys");
	}
	m_nOutputWndHeight = 0;//GetProfileInt(L"View", L"nOutputWindowHeight", 98);


	// ̗
	wchar_t	wszKeyName[30];
	wstring	strValue;
	list<wstring>	listFindWhats, listReplacesWiths;
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listFindWhats.push_back(strValue);
	}
	for(unsigned short iText = 0; iText < 16; ++iText) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iText);
		strValue = GetProfileString(L"Find", wszKeyName);
		if(strValue.empty())
			break;
		listReplacesWiths.push_back(strValue);
	}
	m_pdlgSearch->ClearHistory(false);
	m_pdlgSearch->ClearHistory(true);
	m_pdlgSearch->SetHistory(listFindWhats, listReplacesWiths);

	m_bShowMessageBoxOnFind = toBoolean(GetProfileInt(L"Find", L"bShowMessageBox", 1));
	m_bInitializeFindTextFromEditor = toBoolean(GetProfileInt(L"Find", L"bInitializeFromEditor", 1));
}

/**
 *	bZ[We[u̕bZ[W{bNXɕ\
 *	@param dwID		bZ[Wʎq
 *	@param nType	_CAÕ^Cv (::MessageBox Ɠ)
 *	@param args		bZ[Ẅ
 *	@return			[U̕ԓ (::MessageBox Ɠ)
 */
int CAlphaApp::MessageBox(DWORD dwID, UINT nType, CMessageArguments& args /* = CMessageArguments() */) {
	AssertValid();
	assert(m_pMainWindow != 0);
	return m_pMainWindow->MessageBox(LoadString(dwID, args).c_str(), IDS_APPNAME, nType);
}

///	^ũACRXV
void CAlphaApp::ModifyTabIcons() {
	SHFILEINFOW	sfi;
	TCITEMW		item;

	m_oTabIconsImageList.DeleteImageList();
	m_oTabIconsImageList.Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, m_vecDocuments.size());
	item.mask = TCIF_IMAGE;

	for(item.iImage = 0; item.iImage < static_cast<int>(m_vecDocuments.size()); ++item.iImage) {
		::SHGetFileInfoW(GetTab(item.iImage)->GetFilePath().c_str(),
			0, &sfi, sizeof(SHFILEINFOW), SHGFI_ICON | SHGFI_SMALLICON);
		m_oTabIconsImageList.Add(sfi.hIcon);
		m_wndTab.SetItem(item.iImage, &item);
	}
	m_wndTab.SetImageList(&m_oTabIconsImageList);
}

///	[t@CJ] _CAÕtbNvVW
UINT CALLBACK CAlphaApp::OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	static HWND		hCharCodeCombo, hCharCodeStatic;
	static HWND		hBreakCodeCombo, hBreakCodeStatic;
	unsigned int	iCharCode;
	int				iBreakCode;

	switch(message) {
	case WM_INITDIALOG: {
		LPOPENFILENAMEW	lpOFN = reinterpret_cast<LPOPENFILENAMEW>(lParam);
		set<CodePage>	setCodePages;

		hCharCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_CHARCODE);
		hCharCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_1);
		hBreakCodeCombo = ::GetDlgItem(hWnd, IDC_COMBO_BREAKCODE);
		hBreakCodeStatic = ::GetDlgItem(hWnd, IDC_STATIC_2);
		CEncoder::EnumCodePages(setCodePages);
		for(set<CodePage>::const_iterator it = setCodePages.begin(); it != setCodePages.end(); ++it) {
			if(::IsWindow(hBreakCodeCombo) && CEncoder::IsCodePageForAutoDetection(*it))
				continue;
			const wchar_t*	pwszCPName = CAlphaApp::GetCodePageName(*it);
			if(pwszCPName == 0)
				continue;
			iCharCode = ::SendMessageW(hCharCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszCPName));
			::SendMessageW(hCharCodeCombo, CB_SETITEMDATA, iCharCode, *it);
		}
		const UINT	cCharCode = ::SendMessageW(hCharCodeCombo, CB_GETCOUNT, 0, 0L);
		::SendMessageW(hCharCodeCombo, CB_SETCURSEL, 0, 0L);
		for(iCharCode = 0; iCharCode < cCharCode; ++iCharCode) {
			if((lpOFN->lCustData & 0x00FFFFFF) == ::SendMessage(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L)) {
				::SendMessageW(hCharCodeCombo, CB_SETCURSEL, iCharCode, 0L);
				break;
			}
		}
		if(::IsWindow(hBreakCodeCombo)) {
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(L"ꂵȂ"));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_CRLF));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_LF));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_CR));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_NEL));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_LS));
			::SendMessageW(hBreakCodeCombo, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(IDS_BREAK_PS));
			switch(lpOFN->lCustData >> 24) {
			case BT_AUTO:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 0, 0L);	break;
			case BT_CRLF:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 1, 0L);	break;
			case BT_LF:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 2, 0L);	break;
			case BT_CR:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 3, 0L);	break;
			case BT_NEL:	::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 4, 0L);	break;
			case BT_LS:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 5, 0L);	break;
			case BT_PS:		::SendMessageW(hBreakCodeCombo, CB_SETCURSEL, 6, 0L);	break;
			}
		}
	}
		break;
	case WM_NOTIFY: {
		if(reinterpret_cast<LPNMHDR>(lParam)->code == CDN_FILEOK) {
			LPOFNOTIFYW	lpOFNOIFY = reinterpret_cast<LPOFNOTIFYW>(lParam);

			iCharCode = ::SendMessageW(hCharCodeCombo, CB_GETCURSEL, 0, 0L);
			lpOFNOIFY->lpOFN->lCustData = ::SendMessageW(hCharCodeCombo, CB_GETITEMDATA, iCharCode, 0L);
			if(::IsWindow(hBreakCodeCombo)) {
				iBreakCode = ::SendMessageW(hBreakCodeCombo, CB_GETCURSEL, 0, 0L);
				switch(iBreakCode) {
				case 0:	lpOFNOIFY->lpOFN->lCustData |= BT_AUTO << 24;	break;
				case 1:	lpOFNOIFY->lpOFN->lCustData |= BT_CRLF << 24;	break;
				case 2:	lpOFNOIFY->lpOFN->lCustData |= BT_LF << 24;		break;
				case 3:	lpOFNOIFY->lpOFN->lCustData |= BT_CR << 24;		break;
				case 4:	lpOFNOIFY->lpOFN->lCustData |= BT_NEL << 24;	break;
				case 5:	lpOFNOIFY->lpOFN->lCustData |= BT_LS << 24;		break;
				case 6:	lpOFNOIFY->lpOFN->lCustData |= BT_PS << 24;		break;
				}
			}
		}
	}
		break;
	case WM_SIZE:
		// Rg[̈ʒuTCYς...
		break;
	}

	return 0L;
}

/**
 *	t@CeLXgGfB^ŐVr[ɊJÃr[ANeBuɂB
 *	܂AgqɉăhLg^CvKpB̃\bh̓t@CI[v
 *	ʂ_CAO\邱Ƃ
 *	@param strPathName	t@C̃pX
 *	@param nCodePage	t@C̃R[hy[WBȗƎ
 *	@param strDocType	Kp镶^CvBȗ󕶎̏ꍇ͊gq画
 *	@param bAddToMRU	Jt@Cŋߎgt@Cɒǉ邩
 *	@return				t@CJƂł true
 */
bool CAlphaApp::OpenFile(const wstring& strPathName,
		UINT nCodePage /* = EXTCP_AUTOSELECT */, const wstring& strDocType /* = L"" */, bool bAddToMRU /* = true */) {
	AssertValid();

	// (eLXgGfB^) ɊJĂ邩ׂ
	for(size_t iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
		IAlphaTab*	pTab = GetTab(iTab);
		if(CAlphaEditController* pEditor = pTab->GetTextEditor()) {
			if(::StrCmpIW(pEditor->GetFilePath().c_str(), strPathName.c_str()) == 0) {	// ł͕sS
				SetActiveTab(iTab);
				return true;
			}
		}
	}

	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();
	if(pActiveEditor == 0)
		return false;
	CAlphaDoc*				pActiveDoc = pActiveEditor->GetDocument();
	StreamStatus			ss;
	wstring					strErrorMessage;
	Ascension::FileOpenMode	fom;

	// bN
	switch(GetProfileInt(L"File", L"shareMode", 0)) {
	case 0:	fom = Ascension::FOM_DENYNONE;	break;
	case 1:	fom = Ascension::FOM_DENYWRITE;	break;
	case 2:	fom = Ascension::FOM_DENYREAD;	break;
	}

	if(pActiveDoc->IsModified()
			|| !pActiveDoc->GetPathName().empty()) {	// V^uŊJ
		OnFileNew(nCodePage);
		pActiveDoc = GetActiveTab()->GetTextEditor()->GetDocument();
	} else if(pActiveDoc->GetController()->IsSplit())	// ̃^ugꍇ͑I
		pActiveDoc->GetController()->SplitView(0);

	if(!CEncoder::IsCodePageForAutoDetection(nCodePage)) {
		try {
			pActiveDoc->SetCodePage(nCodePage);
		} catch(invalid_argument& /* e */) {
			if(IDNO == MessageBox(MSG_ILLEGALCODEPAGE, MB_YESNO | MB_ICONEXCLAMATION))
				return false;
			nCodePage = ::GetACP();
			pActiveDoc->SetCodePage(nCodePage);
		}
	}
	m_pMainWindow->LockWindowUpdate();

	// ^Cv̓Kp
	pActiveDoc->SetPathName(strPathName);
	pActiveDoc->SetTitle(::PathFindFileNameW(strPathName.c_str()));
	ApplyDocumentType(m_iActiveTab, strDocType);

	// ł̂Ńt@CJ
	ss = pActiveDoc->LoadDocument(strPathName, fom, nCodePage);
	UpdateStatusBar();
	m_pMainWindow->UnlockWindowUpdate();
	m_pMainWindow->ShowWindow(m_pMainWindow->IsWindowVisible() ? SW_SHOW : SW_RESTORE);

	if(HandleFileOpenError(ss)) {
		if(bAddToMRU)
			m_pMRUManager->Add(pActiveDoc->GetPathName());
		return true;
	}
	return false;
}

/**
 *	R}hC͂ĎsBȈ͖
 *	@param vecArgs	eR}hCIvVBCWinApp::GetCommandLineArguments ̏o͂g
 *	@see			CWinApp::GetCommandLineArguments
 */
void CAlphaApp::ParseCommandLine(const vector<wstring>& vecArgs) {
	AssertValid();

	list<wstring>	listPaths;	// t@CpX̃Xg
	CodePage		nCodePage = CPEX_AUTODETECT_USERLANG;
	wstring			strDocType;
	unsigned long	iLine = 0;
	unsigned long	iChar = 0;
	bool			bReadOnly = false;

	for(vector<wstring>::size_type i = 0; i < vecArgs.size(); ++i) {
		const wstring& strArgument = vecArgs[i];
		if(strArgument.empty())
			continue;
		if(strArgument[0] == L'-') {	// IvV
			if(strArgument == L"-r")
				bReadOnly = true;
			else if(strArgument.substr(1, 2) == L"c:")
				nCodePage = wcstoul(strArgument.substr(3).c_str(), 0, 0);
			else if(strArgument.substr(1, 5) == L"type:")
				strDocType = strArgument.substr(6);
			else if(strArgument.substr(1, 5) == L"line:")
				iLine = wcstoul(strArgument.substr(6).c_str(), 0, 0);
			else if(strArgument.substr(1, 5) == L"char:")
				iChar = wcstoul(strArgument.substr(6).c_str(), 0, 0);
		} else	// t@CpX
			listPaths.push_back(strArgument);
	}

	// ԂɃt@CJ
	for(list<wstring>::const_iterator it = listPaths.begin(); it != listPaths.end(); ++it) {
		if(OpenFile(*it, nCodePage, strDocType))
			if(iLine != 0 || iChar != 0)
				GetActiveTab()->GetTextEditor()->GetActiveView()->SetSelWithoutSelection(iLine, iChar);
	}
}

/**
 *	w肵r[\AtH[JX킹BɃANeBułΉȂ
 *	@param iView	ANeBuɂr[̃CfbNX
 */
void CAlphaApp::SetActiveTab(unsigned int iView) throw(out_of_range) {
	AssertValid();
	if(iView >= m_vecDocuments.size())
		throw out_of_range("Specified tab is not found!");
	if(iView == m_iActiveTab)
		return;

	RECT	rect;
	HWND	hWnd;

	m_iLastActiveTab = m_iActiveTab;
	m_vecDocuments[iView]->OnActivateTab(true);
	if(m_vecDocuments.size() > 1 && m_vecDocuments.size() > m_iActiveTab)	// ANeBur[\ɂ
		m_vecDocuments[m_iActiveTab]->OnActivateTab(false);
	m_iActiveTab = iView;
	m_wndTab.SetCurSel(m_iActiveTab);
	UpdateTitleBar();
	m_pMainWindow->GetClientRect(&rect);
	OnSize(SIZE_RESTORED, rect.right - rect.left, rect.bottom - rect.top);
	hWnd = GetActiveTab()->GetWindow();
	if(::IsWindow(hWnd))
		::SetFocus(hWnd);
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();
}

/**
 *	L[ () 蓖
 *	@param strSchemeName	gpL[{[h}bvXL[̖OB
 *	󕶎w肷ƃAvP[VɌѕtĂL[蓖ăIuWFNgANZ[^e[uč\z
 */
void CAlphaApp::LoadKeyBinds(const wstring& strSchemeName) {
	AssertValid();

	if(!strSchemeName.empty()) {
		wchar_t	wszPathName[MAX_PATH];
		::GetModuleFileNameW(0, wszPathName, MAX_PATH);
		wcscpy(::PathFindFileNameW(wszPathName), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
		if(wcslen(wszPathName) + strSchemeName.length() + 4 >= MAX_PATH)
			return;
		wcscat(wszPathName, strSchemeName.c_str());
		wcscat(wszPathName, L".akm");
		m_oKeyboardMap.Load(wszPathName);
	}

	// ANZ[^e[u̍č\z
	::DestroyAcceleratorTable(m_hAcceleratorTable);
	m_hAcceleratorTable = m_oKeyboardMap.CreateAcceleratorTable();

	// j[̍č\z
	if(m_pMenu != 0)
		SetupMenus();
}

///	j[̏
void CAlphaApp::SetupMenus() {
	AssertValid();

	if(m_pMenu != 0) {
		while(true) {
			const UINT	cItems = m_pMenu->GetItemCount();
			if(cItems == 0 || cItems == -1)
				break;
			m_pMenu->RemoveMenuItem(0, false);
		}
		delete m_pMenu;
	}
	m_pMenu = new CMenu(m_pMainWindow->GetMenu());
	m_pMenu->DeleteMenuItem(0, false);	// _~[ (Ӗ̂͏̂)

	// j[o[
	m_pMenu->AppendMenuItem(CMD_FILE_TOP, MFT_STRING, LoadString(CMD_FILE_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_EDIT_TOP, MFT_STRING, LoadString(CMD_EDIT_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_SEARCH_TOP, MFT_STRING, LoadString(CMD_SEARCH_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_VIEW_TOP, MFT_STRING, LoadString(CMD_VIEW_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_MACRO_TOP, MFT_STRING, LoadString(CMD_MACRO_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_TOOL_TOP, MFT_STRING, LoadString(CMD_TOOL_TOP).c_str());
	m_pMenu->AppendMenuItem(CMD_HELP_TOP, MFT_STRING, LoadString(CMD_HELP_TOP).c_str());

	// [t@C]
	CMenu* pFileMenu = new CMenu();
	pFileMenu->AppendMenuItem(CMD_FILE_NEW, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_NEWWITHFORMAT, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MF_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPEN, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_REOPENWITHCODEPAGE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_MRU, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEAS, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SAVEALL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_SENDMAIL, MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFileMenu->AppendMenuItem(CMD_FILE_EXIT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(pFileMenu, CMD_FILE_TOP, true, true);

	// [t@C]-[t@C]
	delete m_pFileOpeMenu;
	m_pFileOpeMenu = new CMenu();
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_RENAME, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_COPY, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_MOVE, MFT_OWNERDRAW);
	m_pFileOpeMenu->AppendMenuItem(CMD_FILE_DELETE, MFT_OWNERDRAW);
	pFileMenu->SetChildPopup(m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	// [ҏW]
	CMenu* pEditMenu = new CMenu();
	pEditMenu->AppendMenuItem(CMD_EDIT_UNDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_REDO, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_CUT, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_COPY, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_PASTEFROMCLIPBOARDRING, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_DELETE, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_SELECTALL, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_ADVANCED, MFT_OWNERDRAW);
	pEditMenu->AppendMenuItem(CMD_EDIT_OPENCANDIDATEWINDOW, MF_OWNERDRAW);
	m_pMenu->SetChildPopup(pEditMenu, CMD_EDIT_TOP, true, true);

	// [ҏW]-[xȑ]
	CMenu* pAdvEditMenu = new CMenu();
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CHARTOCODEPOINT, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_CODEPOINTTOCHAR, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTGRAVE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTACUTE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCIRCUMFLEX, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTTILDE, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTDIAERESIS, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTCEDILLA, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUPER, MFT_OWNERDRAW);
	pAdvEditMenu->AppendMenuItem(CMD_EDIT_MAKENEXTSUB, MFT_OWNERDRAW);
	pEditMenu->SetChildPopup(pAdvEditMenu, CMD_EDIT_ADVANCED, true, true);

	// []
	CMenu* pFindMenu = new CMenu();
	pFindMenu->AppendMenuItem(CMD_SEARCH_FIND, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDNEXT, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_FINDPREV, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCH, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_INCREMENTALSEARCHR, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_REVOKEMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOLINE, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_TOGGLEBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_NEXTBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_PREVBOOKMARK, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_CLEARBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_MANAGEBOOKMARKS, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_GOTOMATCHBRACKET, MFT_OWNERDRAW);
	pFindMenu->AppendMenuItem(CMD_SEARCH_EXTENDTOMATCHBRACKET, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(pFindMenu, CMD_SEARCH_TOP, true, true);

	// [\]
	CMenu*	pViewMenu = new CMenu();
	pViewMenu->AppendMenuItem(CMD_VIEW_TOOLBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_STATUSBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_TABBAR, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_NEXTTAB, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_PREVTAB, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_SPLIT, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPNO, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYSPECIFIEDWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(CMD_VIEW_WRAPBYWINDOWWIDTH, MFT_OWNERDRAW, MFS_GRAYED);
	pViewMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_TOPMOSTALWAYS, MFT_OWNERDRAW);
	pViewMenu->AppendMenuItem(CMD_VIEW_REFRESH, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(pViewMenu, CMD_VIEW_TOP, true, true);

	// [}N]
	CMenu*	pMacroMenu = new CMenu();
	pMacroMenu->AppendMenuItem(CMD_MACRO_RECORD, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PLAY, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_STOP, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_ABORT, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_PAUSERESTART, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SAVEAS, MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pMacroMenu->AppendMenuItem(CMD_MACRO_SCRIPTS, MFT_OWNERDRAW);
/*	pDebugMenu->AppendMenuItem(CMD_DEBUG_INSERTBREAKPOINT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_INSERTBREAKPOINT));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_BREAKPOINTS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_BREAKPOINTS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_ACTIVEDOCUMENTS, MF_OWNERDRAW | MF_GRAYED, GetMenuLabel(CMD_DEBUG_ACTIVEDOCUMENTS));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_START, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_START));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_RESTART, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_RESTART));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STOP, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STOP));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPINTO, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPINTO));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOVER, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOVER));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_STEPOUT, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_STEPOUT));
	pDebugMenu->AppendMenuItem(0, MF_SEPARATOR, 0);
	pDebugMenu->AppendMenuItem(CMD_DEBUG_CALLSTACK, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_CALLSTACK));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_VARIABLES, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_VARIABLES));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_IMMEDIATE, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_IMMEDIATE));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_THREADS, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_THREADS));
	pDebugMenu->AppendMenuItem(CMD_DEBUG_EXCEPTION, MF_OWNERDRAW, GetMenuLabel(CMD_DEBUG_EXCEPTION));
*/	m_pMenu->SetChildPopup(pMacroMenu, CMD_MACRO_TOP, true, true);

	// [}N]-[vOC] (b)
	CMenu*	pPluginMenu = new CMenu();
//	pPluginMenu->AppendMenuItem(CMD_EDIT_RELOADPLUGIN, MF_OWNERDRAW, GetMenuLabel(CMD_EDIT_RELOADPLUGIN));
//	pPluginMenu->AppendMenuItem(0, MFT_SEPARATOR, 0);
	const size_t	cPlugins = m_pScriptMacroManager->GetCount();
	if(cPlugins != 0) {
		for(size_t iPlugin = 0; iPlugin < cPlugins; ++iPlugin)
			pPluginMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START + iPlugin, MFT_OWNERDRAW);
	} else
		pPluginMenu->AppendMenuItem(CMD_EDIT_PLUGINLIST_START, MFT_OWNERDRAW, MF_GRAYED | MF_DISABLED);
	pMacroMenu->SetChildPopup(pPluginMenu, 7, true, false);

	// [c[]
	CMenu* pToolMenu = new CMenu();
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTE, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_EXECUTECOMMAND, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_APPDOCTYPES, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_DOCTYPEOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_COMMONOPTION, MFT_OWNERDRAW);
	pToolMenu->AppendMenuItem(CMD_TOOL_FONT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(pToolMenu, CMD_TOOL_TOP, true, true);
	delete m_pAppDocTypeMenu;
	m_pAppDocTypeMenu = new CMenu();	// [Kp^Cv]
	pToolMenu->SetChildPopup(m_pAppDocTypeMenu, CMD_TOOL_APPDOCTYPES, false, true);

	// [wv]
	CMenu* pHelpMenu = new CMenu();
	pHelpMenu->AppendMenuItem(CMD_HELP_ABOUT, MFT_OWNERDRAW);
	m_pMenu->SetChildPopup(pHelpMenu, CMD_HELP_TOP, true, true);

	// ^u
	CMenu*	pTabMenu = new CMenu();
	pTabMenu->AppendMenuItem(CMD_FILE_CLOSE, MFT_OWNERDRAW);
	pTabMenu->AppendMenuItem(CMD_FILE_CLOSEOTHERS, MFT_OWNERDRAW);
	pTabMenu->AppendMenuItem(0, MFT_SEPARATOR | MFT_OWNERDRAW);
	pTabMenu->AppendMenuItem(CMD_FILE_PROPERTY, MFT_OWNERDRAW);
	pTabMenu->AppendMenuItem(CMD_FILE_OPERATE, MFT_OWNERDRAW);
	pTabMenu->SetDefaultMenuItem(CMD_FILE_CLOSE);
	m_wndTab.SetContextMenu(pTabMenu);
	pTabMenu->SetChildPopup(m_pFileOpeMenu, CMD_FILE_OPERATE, false, true);

	m_pMainWindow->DrawMenuBar();
}

///	c[o[̏
void CAlphaApp::SetupToolbar() {
	AssertValid();

	CommandId*		pCommands;	// c[o[ɏ悹{^ɑΉR}h
	size_t			cButtons;	// {^
	list<wstring>	listButtons;

	// ݒǂݍ
	GetProfileList(L"ToolbarButtons", L"standard", listButtons, L"");

	if(!listButtons.empty()) {	// Ggꍇ
		list<wstring>::const_iterator	it;
		size_t							i = 0;

		cButtons = listButtons.size();
		pCommands = new CommandId[cButtons];
		for(i = 0, it = listButtons.begin(); it != listButtons.end(); ++i, ++it)
			pCommands[i] = static_cast<CommandId>(wcstoul(it->c_str(), 0, 10));
	} else {	// ftHg̐ݒg
		cButtons = 16;
		pCommands = new CommandId[cButtons];
		pCommands[0] = CMD_FILE_NEW;
		pCommands[1] = CMD_FILE_OPEN;
		pCommands[2] = CMD_FILE_SAVE;
		pCommands[3] = CMD_FILE_SAVEAS;
		pCommands[4] = CMD_FILE_SAVEALL;
		pCommands[5] = 0;
		pCommands[6] = CMD_EDIT_CUT;
		pCommands[7] = CMD_EDIT_COPY;
		pCommands[8] = CMD_EDIT_PASTE;
		pCommands[9] = 0;
		pCommands[10] = CMD_EDIT_UNDO;
		pCommands[11] = CMD_EDIT_REDO;
		pCommands[12] = 0;
		pCommands[13] = CMD_SEARCH_FIND;
		pCommands[14] = CMD_SEARCH_FINDNEXT;
		pCommands[15] = CMD_SEARCH_FINDPREV;
	}

	// C[WXg쐬
	wchar_t		wszIconDir[MAX_PATH];

	::GetModuleFileNameW(0, wszIconDir, MAX_PATH);
	::PathFindFileNameW(wszIconDir)[0] = 0;
	wcscat(wszIconDir, IDS_ICON_DIRECTORY_NAME);
	m_pCommandManager->CreateImageList(wszIconDir);

	// {^
	TBBUTTON*	pButtons = new TBBUTTON[cButtons];
	bool		bHasDropArrow;
	for(size_t i = 0; i < cButtons; ++i) {
		bHasDropArrow = pCommands[i] == CMD_FILE_NEW || pCommands[i] == CMD_FILE_OPEN;
		ZeroMemory(pButtons + i, sizeof(TBBUTTON));
		pButtons[i].fsState = TBSTATE_ENABLED;
		if(pCommands[i] == 0)
			pButtons[i].fsStyle = BTNS_SEP;
		else {
			size_t	iIcon = m_pCommandManager->GetIconIndex(pCommands[i]);

			if(bHasDropArrow)
				pButtons[i].fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON | BTNS_DROPDOWN;
			else if(iIcon == -1)
				pButtons[i].fsStyle = BTNS_AUTOSIZE | BTNS_BUTTON;
			else
				pButtons[i].fsStyle = BTNS_BUTTON;
			if(iIcon != -1 && !bHasDropArrow)
				pButtons[i].iBitmap = iIcon;
			else {
				const wstring	strCaption = m_pCommandManager->GetCaption(pCommands[i]);
				wchar_t*		pwszCaption = new wchar_t[strCaption.length() + 1];
				wcscpy(pwszCaption, strCaption.c_str());
				pButtons[i].iString = reinterpret_cast<INT_PTR>(pwszCaption);
				pButtons[i].iBitmap = bHasDropArrow ? iIcon : I_IMAGENONE;
			}
		}
		pButtons[i].idCommand = pCommands[i];
	}

	REBARBANDINFOW	rbbi;

	if(::IsWindow(m_hToolbar)) {
		::SendMessage(m_hRebar, RB_DELETEBAND, 0, 0L);
		::DestroyWindow(m_hToolbar);
	}
	if(::IsWindow(m_hDebugBar)) {
		::SendMessage(m_hRebar, RB_DELETEBAND, 0, 0L);
		::DestroyWindow(m_hDebugBar);
	}

	m_hToolbar = ::CreateToolbarEx(m_hRebar,
		WS_CHILD | WS_VISIBLE | CCS_NODIVIDER | CCS_NORESIZE | CCS_TOP
		| TBSTYLE_FLAT | TBSTYLE_LIST | TBSTYLE_TOOLTIPS,
		IDC_TOOLBAR, cButtons, m_hInstance, 0, pButtons, cButtons, 0, 0, 0, 0, sizeof(TBBUTTON));
	::SendMessage(m_hToolbar, TB_SETIMAGELIST,
		0, reinterpret_cast<LPARAM>(m_pCommandManager->GetImageList(true)));
	::SendMessage(m_hToolbar, TB_SETDISABLEDIMAGELIST,
		0, reinterpret_cast<LPARAM>(m_pCommandManager->GetImageList(false)));
	::SendMessage(m_hToolbar, TB_SETEXTENDEDSTYLE, 0, TBSTYLE_EX_DRAWDDARROWS);

	for(size_t i = 0; i < cButtons; ++i) {
		delete[] reinterpret_cast<wchar_t*>(pButtons[i].iString);
		if(pButtons[i].fsStyle != BTNS_SEP
				&& pButtons[i].iBitmap != I_IMAGENONE
				&& pButtons[i].idCommand != CMD_FILE_NEW
				&& pButtons[i].idCommand != CMD_FILE_OPEN) {	// ACRt{^̕ŌŒ肷
			TBBUTTONINFOW	tbi;

			tbi.cbSize = sizeof(TBBUTTONINFOW);
			tbi.dwMask = TBIF_SIZE;
			tbi.cx = 22;
			::SendMessageW(m_hToolbar, TB_SETBUTTONINFOW,
				pButtons[i].idCommand, reinterpret_cast<LPARAM>(&tbi));
		}
	}
	delete[] pCommands;
	delete[] pButtons;

	// o[ɏ悹
	ZeroMemory(&rbbi, sizeof(REBARBANDINFOW));
	rbbi.cbSize = sizeof(REBARBANDINFOW);
	rbbi.fMask = RBBIM_CHILD | RBBIM_CHILDSIZE | RBBIM_IDEALSIZE | RBBIM_STYLE;
	rbbi.fStyle = /*RBBS_CHILDEDGE |*/ RBBS_GRIPPERALWAYS | RBBS_USECHEVRON;
	rbbi.hwndChild = m_hToolbar;
	rbbi.cxMinChild = 0;
	rbbi.cyMinChild = 23;
	rbbi.cxIdeal = 440;
	::SendMessageW(m_hRebar, RB_INSERTBANDW, 0, reinterpret_cast<LPARAM>(&rbbi));
}

///	Xe[^Xo[̍XV
void CAlphaApp::UpdateStatusBar() {
	AssertValid();

	IAlphaTab*					pActiveTab = GetActiveTab();
	const CAlphaEditController*	pActiveEditor = pActiveTab->GetTextEditor();
	const CAlphaDoc*			pActiveDoc = 0;

	if(!toBoolean(::IsWindow(m_hStatusBar)))
		return;
	if(pActiveEditor == 0) {
		::SendMessage(m_hStatusBar, SB_SIMPLE, true, 0L);
		return;
	} else {
		::SendMessage(m_hStatusBar, SB_SIMPLE, false, 0L);
		pActiveDoc = pActiveEditor->GetDocument();
	}

	// Xe[^Xo[̃yC͍
	// ėpA݈ʒuAhLg^Cv̖OAR[hAfobOԁAL[}NԁAҏW[hA_~[
	// UpdateStatusBar Q
	int					arrParts[8];
	RECT				rect;
	HDC					hDC = ::GetDC(m_hStatusBar);
	HFONT				hOldFont = reinterpret_cast<HFONT>(::SelectObject(hDC, m_hTabFont));
	const CAlphaView*	pView = pActiveEditor->GetActiveView();
	CCharPos		pos1, pos2;
	const wchar_t*	pwszPosition = pView->GetCurrentPositionString();
	const wchar_t*	pwszDocType = pActiveDoc->m_strDocType.c_str();
	const wchar_t*	pwszCharCode = CAlphaApp::GetCodePageName(pView->GetDocument()->GetCodePage());
	const wstring	strKeymacroRec = (CEditView::GetViewKeyMacroRecording() == pView) ? LoadString(MSG_MACRORECORDING) : L"";
	const wstring	strDebugging = (false/*m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging()*/) ? LoadString(MSG_DEBUGGING) : L"";
	const wstring	strOvertype = LoadString(pView->IsOvertypeMode() ? MSG_OVERTYPEMODE : MSG_INSERTMODE);

	// eyC̕߂
	::GetWindowRect(m_hStatusBar, &rect);
	arrParts[7] = rect.right - rect.left;
	arrParts[6] = arrParts[7] - (m_pMainWindow->IsZoomed() ? 0 : (rect.bottom - rect.top - 4));
	::DrawTextW(hDC, strOvertype.c_str(), -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[5] = arrParts[6] - rect.right + rect.left - 8;
	::DrawTextW(hDC, strDebugging.c_str(), -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[4] = arrParts[5] - rect.right + rect.left - 8;
	::DrawTextW(hDC, strKeymacroRec.c_str(), -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[3] = arrParts[4] - rect.right + rect.left - 8;
	::DrawTextW(hDC, pwszCharCode, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[2] = arrParts[3] - rect.right + rect.left - 12;
	::DrawTextW(hDC, pwszDocType, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[1] = arrParts[2] - rect.right + rect.left - 10;
	::DrawTextW(hDC, pwszPosition, -1, &rect, DT_CALCRECT | DT_SINGLELINE);
	arrParts[0] = arrParts[1] - rect.right + rect.left - 6;
	::SendMessage(m_hStatusBar, SB_SETPARTS, 7, reinterpret_cast<LPARAM>(arrParts));

	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(IDS_DEFAULTSTATUSTEXT));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 1, reinterpret_cast<LPARAM>(pwszPosition));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 2, reinterpret_cast<LPARAM>(pwszDocType));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 3, reinterpret_cast<LPARAM>(pwszCharCode));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 4, reinterpret_cast<LPARAM>(strKeymacroRec.c_str()));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 5, reinterpret_cast<LPARAM>(strDebugging.c_str()));
	::SendMessageW(m_hStatusBar, SB_SETTEXTW, 6, reinterpret_cast<LPARAM>(strOvertype.c_str()));

	::SelectObject(hDC, hOldFont);
	::ReleaseDC(m_hStatusBar, hDC);
}

///	^Cgo[ƃ^uLvV̍XV
void CAlphaApp::UpdateTitleBar() {
	AssertValid();

	static wstring	strTitleCache;

	if(!m_pMainWindow->IsWindow()
			|| !m_wndTab.IsWindow())
		return;

	IAlphaTab*	pActiveTab = GetActiveTab();
	TCITEMW		item;
	wstring		strTitle = pActiveTab->GetTabTitle();

	if(strTitle == strTitleCache)
		return;
	strTitleCache = strTitle;

	// ^u
	wostringstream	ssCaption;
	item.mask = TCIF_TEXT;
	for(size_t i = 0; strTitle[i] != 0; ++i) {
		if(strTitle[i] == L'&')
			ssCaption << L"&&";
		else
			ssCaption << strTitle[i];
	}
	const wstring	strCaption = ssCaption.str();
	item.pszText = const_cast<wchar_t*>(strCaption.c_str());
	m_wndTab.SetItem(m_iActiveTab, &item);

	// ^Cgo[
	strTitle += L" - " IDS_APPFULLVERSION;
	m_pMainWindow->SetWindowText(strTitle.c_str());
}

///	vOC () [h
void CAlphaApp::OnEditReloadPlugin() {
	wchar_t	wszPluginPath[MAX_PATH];

	wcscpy(wszPluginPath, m_szModulePath);
	wcscpy(::PathFindFileNameW(wszPluginPath), IDS_MACRO_DIRECTORY_NAME L"macros.xml");
	try {
		m_pScriptMacroManager->Load(wszPluginPath);
	} catch(CScriptMacroManager::EFailedToParseXml& /* e */) {
		// }l[W_CAOo...
	}
}

/**
 *	ANeBuȃ^u폜
 *	@return	{Ƀ^u폜Ƃ true
 */
bool CAlphaApp::OnFileClose(bool bConfirm /* = true */) {
	IAlphaTab*				pActiveTab = GetActiveTab();
	CAlphaEditController*	pActiveEditor = pActiveTab->GetTextEditor();
	CAlphaDoc*				pActiveDoc = 0;

	if(bConfirm && pActiveEditor != 0) {
		wstring		strPrompt;
		int			nAnswer;

		pActiveDoc = pActiveEditor->GetDocument();

		// fobO~̊mF
/*		if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
			nAnswer = MessageBox(MSG_DEBUG_DOCUMENTISDEBUGGING, MB_YESNO | MB_ICONQUESTION);
			if(nAnswer == IDNO)
				return false;
			m_pActiveDebugger->Abort();
		}
*/
		// ۑ̊mF
		if(pActiveDoc->IsModified()) {
			nAnswer = MessageBox(MSG_FILEISDIRTY,
						MB_YESNOCANCEL | MB_ICONQUESTION,
						CMessageArguments() % pActiveDoc->GetTitle().c_str());
			if(nAnswer == IDCANCEL)
				return false;
			else if(nAnswer == IDYES) {
				if(!OnFileSave())
					return false;
			}
		}
	}

	// mFȂƂ̂
/*	if(m_pDebuggingEditor != 0 && pActiveEditor == m_pDebuggingEditor) {
		if(m_pActiveDebugger != 0 && m_pActiveDebugger->IsDebugging())
			m_pActiveDebugger->Abort();
	}*/

	pActiveTab->DeleteInstance();
	m_vecDocuments.erase(m_vecDocuments.begin() + m_iActiveTab);
	m_wndTab.DeleteItem(m_iActiveTab);

	// ʂ̃r[ANeBuɂ
	m_iActiveTab = -1;	// SetActiveTab ɋ₳Ȃ
	if(m_vecDocuments.empty())
		OnFileNew(::GetACP());
	else if(m_iActiveTab == 0)
		SetActiveTab(0);
	else
		SetActiveTab(std::min(m_iLastActiveTab, m_vecDocuments.size() - 1));

	return true;
}

/**
 *	SāA͔ANeBuȑSẴ^u폜
 *	@param bExceptCurrent	݂̃^ucꍇ true
 *	@return					^u̍폜1[UɋۂȂ true
 */
bool CAlphaApp::OnFileCloseAll(bool bExceptCurrent) {
	// TODO: eLXgGfB^ȊO^uɊ܂܂悤ɂȂC
	CConfirmUnsavedDocumentDlg	oDlg;
	const unsigned int			iCurrent = GetActiveTabIndex();

	// ۑ̕Kv̖hLgS
	for(size_t iDoc = m_vecDocuments.size(); iDoc != 0; --iDoc) {
		if(bExceptCurrent && iDoc - 1 == iCurrent)
			continue;
		if(CAlphaEditController* pEditor = GetTab(iDoc - 1)->GetTextEditor()) {
			if(!pEditor->GetDocument()->IsModified()) {
				SetActiveTab(iDoc - 1);
				OnFileClose(false);
			}
		}
	}

	// ۑ̃t@CΏI
	if(m_vecDocuments.size() == 1) {
		const CAlphaEditController*	pEditor = m_vecDocuments[0]->GetTextEditor();
		if(bExceptCurrent || pEditor == 0 || !pEditor->GetDocument()->IsModified())
			return true;
	}

	// ۑ̃t@C1Ȃʏ̊mF_CAOoďI
	if(m_vecDocuments.size() - (bExceptCurrent ? 1 : 0) == 1) {
		unsigned int	iDirtyDoc;

		if(!bExceptCurrent)
			iDirtyDoc = 0;
		else
			iDirtyDoc = (iCurrent == 0) ? 1 : 0;
		if(GetTab(iDirtyDoc)->GetTextEditor() != 0
				&& GetTab(iDirtyDoc)->GetTextEditor()->GetDocument()->IsModified()) {
			if(bExceptCurrent)
				SetActiveTab(iDirtyDoc);
			return OnFileClose();
		}
	}

	// ̃t@Cۑ邩ǂmF_CAOo
	for(unsigned int iDoc = 0; iDoc < m_vecDocuments.size(); ++iDoc) {
		if(bExceptCurrent && iDoc == iCurrent)
			continue;
		if(CAlphaEditController* pEditor = GetTab(iDoc)->GetTextEditor()) {
			TDirtyFile	tf;
			tf.iTab = iDoc;
			tf.strFileName = pEditor->GetDocument()->GetTitle();
			tf.bSave = true;
			oDlg.m_vecFiles.push_back(tf);
		}
	}
	oDlg.Create(m_hInstance, IDD_DLG_CONFIRMUNSAVEDDOCUMENTS, m_pMainWindow->m_hWnd);
	if(IDOK != oDlg.DoModal())
		return false;

	// ۑ
	for(vector<TDirtyFile>::reverse_iterator it = oDlg.m_vecFiles.rbegin(); it != oDlg.m_vecFiles.rend(); ++it) {
		SetActiveTab(it->iTab);
		if(it->bSave) {
			if(!OnFileSave())
				return false;
		}
		if(!OnFileClose(false))
			return false;
	}

	return true;
}

/**
 *	V^u쐬
 *	@param nCodePage	R[hy[W
 */
void CAlphaApp::OnFileNew(UINT nCodePage) {
	if(::GetCurrentThreadId() != ::GetWindowThreadProcessId(m_pMainWindow->m_hWnd, 0)) {
		// EBhE̍쐬CXbhɈϏ
		m_pMainWindow->SendMessage(WM_CREATENEWTAB, nCodePage);
		return;
	}

	RECT					rect = {0, 0, 0, 0};
	CAlphaEditController*	pEditor = new CAlphaEditController();
	bool					bSucceededToCreate;
	static bool				bLoadedKeyMacro = false;

	pEditor->SetSplitterWidth(3);
	bSucceededToCreate = pEditor->Create(m_pMainWindow->m_hWnd,
		&rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, 0,
		WS_CHILD | WS_CLIPSIBLINGS | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	if(!bLoadedKeyMacro) {
		pEditor->GetPrimaryView()->CmdKeymacroLoad(IDS_KEYMACROFILENAME);
		bLoadedKeyMacro = true;
	}

	if(!CEncoder::IsCodePageForAutoDetection(nCodePage)) {
		try {
			pEditor->GetDocument()->SetCodePage(nCodePage);
		} catch(invalid_argument&) {
			pEditor->GetDocument()->SetCodePage(::GetACP());
		}
	}

	m_wndTab.InsertItem(m_vecDocuments.size(), IDS_UNTITLED);
	pEditor->GetPrimaryView()->AddEventListener(this);
	pEditor->GetDocument()->AddEventListener(this);
	pEditor->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);
	m_vecDocuments.push_back(pEditor);
	SetActiveTab(m_vecDocuments.size() - 1);
	ApplyDocumentType(m_iActiveTab, L"");
	ModifyTabIcons();
}

///	[w肵ĐVK] _CAOJ
void CAlphaApp::OnFileNewWithFormat() {
	RECT					rect = {0, 0, 0, 0};
	CAlphaEditController*	pEditor = 0;
	CNewFileFormatDlg		dlg;
	bool					bSucceededToCreate;

	dlg.Create(m_hInstance, IDD_DLG_FILENEWWITHFORMAT, m_pMainWindow->m_hWnd);
	dlg.m_nCodePage = ::GetACP();	// INI ɊYڂ邪
	dlg.m_breakType = BT_CRLF;		// ͖
	dlg.m_iDocumentType = 0;
	dlg.m_listDocumentTypes.clear();
	for(size_t i = 0; i < m_oDocTypeManager.GetCount(); ++i)
		dlg.m_listDocumentTypes.push_back(m_oDocTypeManager.GetAt(i).strName);

	if(dlg.DoModal() != IDOK)
		return;

	pEditor = new CAlphaEditController();
	bSucceededToCreate = pEditor->Create(m_pMainWindow->m_hWnd,
		&rect, WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS | WS_VISIBLE, 0,
		WS_CHILD | WS_CLIPCHILDREN | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL, WS_EX_STATICEDGE);
	assert(bSucceededToCreate);
	pEditor->GetDocument()->SetCodePage(dlg.m_nCodePage);
	pEditor->GetDocument()->SetBreakType(dlg.m_breakType);

	// ^CvȊO͌ OnFileNew Ɠ...
	m_wndTab.InsertItem(m_vecDocuments.size(), IDS_UNTITLED);
	pEditor->GetPrimaryView()->AddEventListener(this);
	pEditor->GetDocument()->AddEventListener(this);
	pEditor->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, false);
	pEditor->GetDocument()->SetTitle(IDS_UNTITLED);
	m_vecDocuments.push_back(pEditor);
	SetActiveTab(m_vecDocuments.size() - 1);
	ApplyDocumentType(m_iActiveTab, m_oDocTypeManager.GetAt(dlg.m_iDocumentType).strName);
	ModifyTabIcons();
}

///	t@CJ
bool CAlphaApp::OnFileOpen() {
	OPENFILENAMEW	ofn;
	wchar_t			wszFilter[300];
	wstring			strFilter = GetProfileString(L"File", L"filter", LoadString(MSG_DEFAULTFILEFILTER).c_str());
	wchar_t			wszFileName[MAX_PATH + 1] = L"";
	wstring			strErrorMessage;

	// tB^𐮌`
	wstring::size_type	iFound = 0;
	while(true) {
		iFound = strFilter.find(L':', iFound + 1);
		if(iFound == wstring::npos)
			break;
		strFilter[iFound] = L'\0';
	}
	strFilter.copy(wszFilter, strFilter.length());
	wszFilter[strFilter.length()] = L'\0';
	wszFilter[strFilter.length() + 1] = L'\0';

	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_pMainWindow->m_hWnd;
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = wszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST/* | OFN_SHOWHELP*/;
	ofn.lCustData = CPEX_AUTODETECT_USERLANG | 0;
	ofn.lpfnHook = CAlphaApp::OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_OPENFILE);

	if(!::GetOpenFileNameW(&ofn))
		return false;
	return OpenFile(ofn.lpstrFile, ofn.lCustData & 0x00FFFFFF);
}

/**
 *	[t@C]_CAO̕\
 *	@param id	R}h ID
 */
void CAlphaApp::OnFileOperation(UINT id) {
	assert(id >= CMD_FILE_RENAME && id <= CMD_FILE_DELETE);

	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*		pActiveDoc = pActiveEditor->GetDocument();
	OperationStatus	ops = OPS_OK;

	if(id != CMD_FILE_DELETE) {
		CFileOperationDlg	dlg(id, pActiveDoc->GetPathName());
		dlg.Create(m_hInstance, IDD_DLG_FILEOPERATION, m_pMainWindow->m_hWnd);
		if(dlg.DoModal() == IDOK) {
			switch(id) {
			case CMD_FILE_COPY:
				ops = pActiveDoc->CopyCurrentFile(dlg.m_strFilePath.c_str());
				break;
			case CMD_FILE_MOVE:
			case CMD_FILE_RENAME:
				ops = pActiveDoc->MoveCurrentFile(dlg.m_strFilePath.c_str());
				break;
			}
		}
	} else {
		ops = pActiveDoc->DeleteCurrentFile();
		if(ops == OPS_OK)
			OnFileClose();
	}

	// ^Cgo[ƃ^uXV
	UpdateTitleBar();

	// G[bZ[W̐
	switch(ops) {
	case OPS_OK:
	case OPS_ABORTED:
		return;
	case OPS_ALREADYEXISTS:
		MessageBox(MSG_FAILEDTOOPERATEFILE, MB_ICONEXCLAMATION);
		break;
	case OPS_OPENEDASREADONLY:
		MessageBox(MSG_REOPENEDASREADONLY, MB_ICONEXCLAMATION);
		break;
	case OPS_CANNOTOPEN:
		// ...
		break;
	case OPS_UNKNOWNERROR:
		// ...
//		::FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS, 0, ::GetLastError(),
//			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), wszError + wcslen(wszError), 200, 0);
		break;
	}
}

///	[vpeB] _CAO̕\
void CAlphaApp::OnFileProperty() {
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*			pActiveDoc = pActiveEditor->GetDocument();
	CFilePropertyDlg	dlg;

	if(pActiveDoc == 0) {
		::MessageBeep(MB_OK);
		return;
	}

	dlg.m_pDocument = pActiveDoc;
	dlg.m_strDocTypeName = pActiveDoc->m_strDocType;
	dlg.Create(m_hInstance, IDD_DLG_FILEPROPERTY, m_pMainWindow->m_hWnd);
	dlg.DoModal();
}

///	݊JĂt@CۑɕAJ
void CAlphaApp::OnFileReopen() {
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*		pActiveDoc = pActiveEditor->GetDocument();
	const wstring	strPathName = pActiveDoc->GetPathName();

	if(strPathName.empty())
		return;

	if(!pActiveDoc->IsModified()
			|| IDYES == MessageBox(MSG_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION)) {
		pActiveEditor->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			strPathName, pActiveDoc->GetShareMode(), pActiveDoc->GetCodePage());
		UpdateStatusBar();
		HandleFileOpenError(ss);
	}
}

///	݊JĂt@CۑɕAR[hy[Ww肵ĊJ
void CAlphaApp::OnFileReopenWithCodepage() {
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	CAlphaDoc*	pActiveDoc = pActiveEditor->GetDocument();

	if(pActiveDoc->GetPathName().empty())
		return;
	if(pActiveDoc->IsModified() &&
			IDNO == MessageBox(MSG_ASKREOPENINDIRTY, MB_YESNO | MB_ICONQUESTION))
		return;

	CCodePagesDlg	dlg;

	dlg.Create(m_hInstance, IDD_DLG_CODEPAGES, m_pMainWindow->m_hWnd);
	dlg.m_nCodePage = pActiveDoc->GetCodePage();
	if(dlg.DoModal() == IDOK) {
		pActiveEditor->SplitView(0);
		Ascension::StreamStatus	ss = pActiveDoc->LoadDocument(
			pActiveDoc->GetPathName(), pActiveDoc->GetShareMode(), dlg.m_nCodePage);
		UpdateStatusBar();
		HandleFileOpenError(ss);
	}
}

/**
 *	t@C㏑ۑBt@C݂ȂƂ CAlphaApp::OnFileSaveAs Ăяo
 *	@param iTab			^uԍB-1ƃANeBuȃ^u
 *	@return				 (ۑKvꍇ true)
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSave(unsigned int iTab /* = -1 */) throw(out_of_range) {
	IAlphaTab*		pTab = 0;
	CAlphaDoc*		pDocument = 0;
	StreamStatus	ss;
	UINT			nCurrentCP;
	bool			bWriteBOM = false;

	if(iTab == -1)
		iTab = GetActiveTabIndex();
	try {
		pTab = GetTab(iTab);
	} catch(out_of_range&) {
		throw;
	}
	if(pTab->GetTextEditor() == 0)
		return false;
	pDocument = pTab->GetTextEditor()->GetDocument();
	if(!pDocument->GetPathName().empty() && !pDocument->IsModified())
		return true;

	// t@C݂邩
	if(!::PathFileExistsW(pDocument->GetPathName().c_str()))
		return OnFileSaveAs(iTab);

	nCurrentCP = pDocument->GetCodePage();
	switch(nCurrentCP) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16bE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	do {
		ss = pDocument->SaveDocument(pDocument->GetPathName(), sdo, BT_AUTO, nCurrentCP);
		if(ss == SS_OK)
			m_pMRUManager->Add(pDocument->GetPathName());
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			const wstring	strPrompt = LoadString(
				MSG_FILECONTAINSILLEGALCHARS, CMessageArguments() % pDocument->GetPathName());
			if(IDYES == m_pMainWindow->MessageBox(
					strPrompt.c_str(), IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	if(iTab != GetActiveTabIndex()) {	// ANeBułȂ^uۑ
		wstring	strTitle = pTab->GetTabTitle();
		TCITEMW	item;
		item.mask = TCIF_TEXT;
		item.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_wndTab.SetItem(iTab, &item);
	}

	return true;
}

/**
 *	t@CSĕۑ
 *	@return	rŒfȂ true
 */
bool CAlphaApp::OnFileSaveAll() {
	for(unsigned int iDoc = 0; iDoc < m_vecDocuments.size(); ++iDoc) {	// SẴhLgۑ
		if(!OnFileSave(iDoc))
			return false;
	}
	return true;
}

/**
 *	t@Cw肵Oŕۑ
 *	@param iTab			^uԍB-1ƃANeBuȃ^u
 *	@return				
 *	@throw out_of_range	<var>iTab</var> ȂƂX[
 */
bool CAlphaApp::OnFileSaveAs(unsigned int iTab /* = -1 */) throw(out_of_range) {
	IAlphaTab*		pTab = 0;
	CAlphaDoc*		pDocument = 0;
	StreamStatus	ss;
	OPENFILENAMEW	ofn;
	wchar_t			wszFilter[] = IDS_FILEFILTERW;
	wchar_t			wszFileName[MAX_PATH + 1] = L"";
	BreakType		bc = BT_AUTO;						// sR[h
	bool			bWriteBOM = false;

	if(iTab == -1)
		iTab = GetActiveTabIndex();
	try {
		pTab = GetTab(iTab);
	} catch(out_of_range&) {
		throw;
	}
	if(pTab->GetTextEditor() == 0)
		return false;
	pDocument = pTab->GetTextEditor()->GetDocument();

	if(!pDocument->GetPathName().empty())
		wcscpy(wszFileName, pDocument->GetPathName().c_str());

	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = m_pMainWindow->m_hWnd;
	ofn.hInstance = m_hInstance;
	ofn.lpstrFilter = wszFilter;
	ofn.lpstrFile = wszFileName;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_ENABLETEMPLATE
		| OFN_EXPLORER | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT /* | OFN_SHOWHELP*/;
	ofn.lCustData = pDocument->GetCodePage() | (bc << 24);
	ofn.lpfnHook = CAlphaApp::OFNHookProc;
	ofn.lpTemplateName = MAKEINTRESOURCE(IDD_DLG_SAVEFILE);

	if(!::GetSaveFileNameW(&ofn))
		return false;

	switch(ofn.lCustData & 0x00FFFFFF) {
	case CP_UTF8:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
		break;
	case CPEX_UNICODE_UTF16LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
		break;
	case CPEX_UNICODE_UTF16BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16BE", 1));
		break;
	case CPEX_UNICODE_UTF32LE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
		break;
	case CPEX_UNICODE_UTF32BE:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
		break;
	case 50227:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
		break;
	case 50225:
		bWriteBOM = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
		break;
	}

	SaveDocumentOption	sdo = bWriteBOM ? SDO_WRITE_BOM : 0;
	const wstring		strDocType = pDocument->m_strDocType;
	do {
		ss = pDocument->SaveDocument(ofn.lpstrFile, sdo,
				static_cast<BreakType>(ofn.lCustData >> 24), ofn.lCustData & 0x00FFFFFF);
		if(ss == SS_OK)
			m_pMRUManager->Add(ofn.lpstrFile);
		else if(ss == SS_WRITE_CONTAININVALIDCHAR) {
			const wstring	strPrompt = LoadString(
								MSG_FILECONTAINSILLEGALCHARS, CMessageArguments() % ofn.lpstrFile);
			if(IDYES == m_pMainWindow->MessageBox(
					strPrompt.c_str(), IDS_APPNAME, MB_YESNO | MB_ICONEXCLAMATION)) {
				sdo |= SDO_IGNORE_NOFITCHARS;
				continue;
			}
			return false;
		}
	} while(false);

	const TDocumentType&	type = m_oDocTypeManager.GetByFileName(pDocument->GetTitle());
	if(type.strName != m_oDocTypeManager.GetAt(m_oDocTypeManager.Find(strDocType)).strName)
		ApplyDocumentType(GetActiveTabIndex(), type.strName);
	if(iTab != GetActiveTabIndex()) {	// ANeBułȂ^uۑ
		wstring	strTitle = pTab->GetTabTitle();
		TCITEMW	item;
		item.mask = TCIF_TEXT;
		item.pszText = const_cast<wchar_t*>(strTitle.c_str());
		m_wndTab.SetItem(iTab, &item);
	}
	ModifyTabIcons();
	UpdateStatusBar();
	if(m_pdlgBookmark->IsWindow())
		m_pdlgBookmark->UpdateList();

	return true;
}

///	[ׂă}[N]
void CAlphaApp::OnFindBookmarkAll() {
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();
	SearchFlag				sfFlags = 0;
	unsigned long			cFound;

	if(pActiveEditor == 0)
		return;
	CAlphaView*	pView = pActiveEditor->GetPrimaryView();

	try {
		m_pdlgSearch->UpdateOptions();
		pView->SetSearchText(m_pdlgSearch->GetFindText());
		cFound = pView->BookmarkAll();
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
		return;
	} catch(ERegExpPatternIsInvalid& e) {
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, CMessageArguments() % e.what());
		return;
	}
	if(cFound != 0)
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
}

///	[ƒu] _CAO̕\/\
void CAlphaApp::OnFindFind() {
	if(GetActiveTab()->GetTextEditor() == 0)
		return;

	const CAlphaView*	pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();

	if(!m_pdlgSearch->IsWindowVisible()) {
		CCharPos	pos1, pos2;

		pActiveView->GetSel(pos1, pos2);
		if(pos1 == pos2)
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, pActiveView->GetNearestWordFromCaret().c_str());
		else if(pos1.m_iLine != pos2.m_iLine)
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, L"");
		else
			m_pdlgSearch->SetDlgItemText(IDC_COMBO_FINDWHAT, pActiveView->GetSelection().c_str());
		m_pdlgSearch->ShowWindow(SW_SHOW);
	} else
		m_pdlgSearch->ShowWindow(SW_HIDE);
}

/**
 *	݂̌ɏ]ĎA͑O̕B
 *	̃\bh̓qbgIԂɂB
 *	܂A_CAO\ł@\
 *	@param bPrevious	true ɂƑO
 *	@param bNotice		true ɂƌsƂɃvvg\
 */
void CAlphaApp::OnFindFindNext(bool bPrevious /* = false */, bool bNotice /* = true */) {
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;
	CAlphaView*	pView = pActiveEditor->GetActiveView();
	SearchFlag	flags = pView->GetSearchFlags();

	if(bPrevious)
		flags |= SF_BACKWARD;
	pView->SetSearchFlags(flags);
	pView->SetSearchText(m_pdlgSearch->GetFindText());

	try {
		// try ubNƂȂ񂩒xȂ
		if(pView->FindNext())
			m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
		else if(bNotice && m_bShowMessageBoxOnFind)
			MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		if(bNotice)
			MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
		return;
	} catch(ERegExpPatternIsInvalid& e) {
		if(bNotice)
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, CMessageArguments() % e.what());
		return;
	}
	if(m_pdlgSearch->IsWindowVisible()) {
		if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
			m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	AEgC͂s_CAO\B
 *	݂̃hLg^CvɌꂪݒ肳ĂȂꍇ̓G[bZ[Wo
 */
void CAlphaApp::OnFindParseOutline() {
/*	CAlphaDoc*		pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	const wstring&	strLanguage = m_vecDocumentTypes[pActiveDoc->m_iDocType].strLanguageForOutlineParsing;

	if(m_dlgOutline.IsWindow()) {	// _CAOJĂΕ邾
		m_dlgOutline.EndDialog(IDCANCEL);
		return;
	}

	if(strLanguage == L"JScript")
		m_dlgOutline.m_oplLanguage = OPL_JSCRIPT;
	else if(strLanguage == L"VBScript")
		m_dlgOutline.m_oplLanguage = OPL_VBSCRIPT;
	else {
		wchar_t	wszMessage[256];
		LoadString(116, wszMessage, 256);
		m_pMainWindow->MessageBox(wszMessage, IDS_APPNAME, MB_ICONEXCLAMATION);
		return;
	}

	m_dlgOutline.Create(m_hInstance, IDD_DLG_OUTLINE, m_pMainWindow->m_hWnd);
	m_dlgOutline.Parse(pActiveDoc);*/
}

/**
 *	݈ʒuȍ~̌SĒuB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAll() {
	if(GetActiveTab()->GetTextEditor() == 0)
		return;

	unsigned int	cReplaced;
	CAlphaDoc*		pActiveDoc = GetActiveTab()->GetTextEditor()->GetDocument();
	CAlphaView*		pActiveView = pActiveDoc->GetController()->GetActiveView();

	try {
		m_pdlgSearch->UpdateOptions();
		pActiveView->SetSearchText(m_pdlgSearch->GetFindText());
		cReplaced = pActiveView->ReplaceAll(m_pdlgSearch->GetReplaceText());
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
		return;
	} catch(ERegExpPatternIsInvalid& e) {
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, CMessageArguments() % e.what());
		return;
	}

	// ʂ̏o
	if(m_bShowMessageBoxOnFind) {
		if(cReplaced != 0)
			MessageBox(MSG_REPLACESUCCEEDED, MB_ICONINFORMATION, CMessageArguments() % cReplaced);
		else
			MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
	}

	if(cReplaced != 0) {	// ɒǉ
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetFindText(), false);
		m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
	}
	if(m_pdlgSearch->IsWindow()) {
		if(m_pdlgSearch->IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [ׂĒu_CAO]
			m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

/**
 *	݂̑I͈͂łΒusB
 *	uA͑I͈͂Ŗꍇ͎̌IԂɂB
 *	̃\bh͒u_CAO\ł@\
 */
void CAlphaApp::OnFindReplaceAndNext() {
	if(GetActiveTab()->GetTextEditor() == 0)
		return;

	CAlphaView*	pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();

	try {
		m_pdlgSearch->UpdateOptions();
		pActiveView->SetSearchText(m_pdlgSearch->GetFindText());
		if(pActiveView->ReplaceAndFindNext(m_pdlgSearch->GetReplaceText()))	// u
			m_pdlgSearch->AddToHistory(m_pdlgSearch->GetReplaceText(), true);
		else if(m_bShowMessageBoxOnFind)
			MessageBox(MSG_TEXTNOTFOUND, MB_ICONINFORMATION);
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		MessageBox(MSG_FAILEDTOLOADREGEXPENGINE, MB_ICONEXCLAMATION);
		return;
	} catch(ERegExpPatternIsInvalid& e) {
			MessageBox(MSG_REGEXPPATTERNSYNTAXERROR, MB_ICONEXCLAMATION, CMessageArguments() % e.what());
		return;
	}

	if(m_pdlgSearch->IsWindowVisible()) {
//		if(m_dlgFind.IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [_CAO]
//			m_pMainWindow->SendMessage(WM_COMMAND, CMD_SEARCH_FIND);
//		else
			::SetFocus(m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT));
	}
}

///	[ubN}[N̐ݒ/]
void CAlphaApp::OnFindToggleBookmark() {
	CCharPos				posBegin, posEnd;
	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		CAlphaView*	pActiveView = pActiveEditor->GetPrimaryView();
		pActiveView->GetSel(posBegin, posEnd);
		pActiveView->ToggleBookmark(posEnd.m_iLine);
	}
}

///	[o[W] _CAO̕\
void CAlphaApp::OnHelpAbout() {
	CAboutDlg	oDlg;
	oDlg.Create(m_hInstance, IDD_DLG_ABOUT, m_pMainWindow->m_hWnd);
	oDlg.DoModal();
}

///	@see	IEditViewEventListener::OnIncrementalSearchEvent
void CAlphaApp::OnIncrementalSearchEvent(IncrementalSearchEvent event, const char_t* pwsz) {
	if(event == ISE_ABORTED || event == ISE_COMPLETED)
		::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(L""));
	else if(event == ISE_STARTED) {
		/* Ȃ */
	} else if(event == ISE_STRING_CHANGED || event == ISE_STRING_NOT_FOUND) {
		const CAlphaView*				pView = GetActiveTab()->GetTextEditor()->GetActiveView();
		const IncrementalSearchState	state = pView->GetIncrementalSearchState();

		if(event == ISE_STRING_CHANGED && pwsz[0] == 0)
			::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS,
				reinterpret_cast<LPARAM>(LoadString((state == ISS_FORWARD) ?
				MSG_ISEARCHTEXTISEMPTY : MSG_RISEARCHTEXTISEMPTY).c_str()));
		else {
			UINT	msg;

			if(event == ISE_STRING_CHANGED)
				msg = (state == ISS_FORWARD) ? MSG_ISEARCHPROMPT : MSG_RISEARCHPROMPT;
			else
				msg = (state == ISS_FORWARD) ? MSG_ISEARCHNOTFOUNDPROMPT : MSG_RISEARCHNOTFOUNDPROMPT;

			string_t	strPrompt = LoadString(msg, CMessageArguments() % pwsz);
			length_t	iTab = 0;
			while(string_t::npos != (iTab = strPrompt.find(L'\t', iTab))) {
				strPrompt[iTab] = L' ';
				++iTab;
			}
			::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(strPrompt.c_str()));
		}
	}
}

///	@see	IEditViewEventListener::OnInvokeUriLink
void CAlphaApp::OnInvokeUriLink(const char_t* pwszUri) {
	::ShellExecuteW(0, 0, pwszUri, 0, 0, SW_SHOWNORMAL);
}

///	[ʐݒ] _CAO̕\
void CAlphaApp::OnToolCommonOption() {
/*	CCommonOptionSheet	oSheet(L"ʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CFileOptionDlg		oFileOptionPG;
	CEditOptionDlg		oEditOptionPG;
	CFindOptionDlg		oFindOptionPG;
	CViewOptionDlg		oViewOptionPG;
	CStyleOptionDlg		oStyleOptionPG;
	CKeyBindsOptionDlg	oKeyBindsOptionPG(this, &m_oKeyboardMap);
	CCodePageOptionDlg	oCodePagesOptionPG;
	CScriptOptionDlg	oScriptOptionPG(&m_oScriptLanguages);

	// [t@C] ^u
	oFileOptionPG.m_nShareMode = GetProfileInt(L"File", L"shareMode", 1);
	oFileOptionPG.m_bWriteBOMAsUTF8 = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF8", 0));
	oFileOptionPG.m_bWriteBOMAsUTF16LE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF16BE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF16BE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32LE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32LE", 1));
	oFileOptionPG.m_bWriteBOMAsUTF32BE = toBoolean(GetProfileInt(L"File", L"writeBomAsUTF32BE", 1));
	oFileOptionPG.m_bWriteBOMAsISO2022CN = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022CN", 0));
	oFileOptionPG.m_bWriteBOMAsISO2022KR = toBoolean(GetProfileInt(L"File", L"writeBomAsISO2022KR", 0));
	oFileOptionPG.m_bUseSystemACP = toBoolean(GetProfileInt(L"File", L"bUseSystemCP", 1));
	oFileOptionPG.m_nCustomCP = GetProfileInt(L"File", L"nCustomCP", 65001);
	oFileOptionPG.m_breakType = static_cast<BreakType>(GetProfileInt(L"File", L"nBreakType", BT_CRLF));
	oFileOptionPG.m_bAutoSave = toBoolean(GetProfileInt(L"File", L"bUseAutoSave", 0));
	oFileOptionPG.m_nInterval = GetProfileInt(L"File", L"nAutoSaveInterval", 300);
	oFileOptionPG.m_nMRULimit = GetProfileInt(L"File", L"mruLimit", 8);
	oFileOptionPG.m_bSendAsAttachment = toBoolean(GetProfileInt(L"File", L"sendMailAsAttachment", 1));
	oFileOptionPG.Construct(IDD_DLGPAGE_OPTION_FILE, L"t@C");
	oSheet.AddPage(&oFileOptionPG);

	// [ҏW] ^u
	oEditOptionPG.m_bCancelAfterCopy = m_bCancelSelAfterCopy;
	oEditOptionPG.m_bUseCurrentBreak = toBoolean(GetProfileInt(L"Edit", L"bUseCurrentBreakAsCopy", 0));
	oEditOptionPG.m_bLimitUndoHistory = toBoolean(GetProfileInt(L"Edit", L"bLimitUndoHistoryLength", 0));
	oEditOptionPG.m_bConcatSuccessiveChars = toBoolean(GetProfileInt(L"Edit", L"bConcatSuccessiveChars", 1));
	oEditOptionPG.m_nUndoLimit = GetProfileInt(L"Edit", L"nUndoLimit", 100);
	oEditOptionPG.Construct(IDD_DLGPAGE_OPTION_EDIT, L"ҏW");
	oSheet.AddPage(&oEditOptionPG);

	// [] ^u
	oFindOptionPG.m_bShowMessageBox = m_bShowMessageBoxOnFind;
	oFindOptionPG.m_bInitializeFromEditor = m_bInitializeFindTextFromEditor;
	oFindOptionPG.Construct(IDD_DLGPAGE_OPTION_FIND, L"");
	oSheet.AddPage(&oFindOptionPG);

	// [\] ^u
	oViewOptionPG.m_bVisibleToolbar = toBoolean(::IsWindowVisible(m_hRebar));
	oViewOptionPG.m_bVisibleStatusBar = toBoolean(::IsWindowVisible(m_hStatusBar));
	oViewOptionPG.m_nLeftMargin = m_nLeftMargin;
	oViewOptionPG.m_nTopMargin = m_nTopMargin;
	oViewOptionPG.m_nStartupWindowPos = GetProfileInt(L"View", L"nStartupWindowPos", 0);
	if(!GetProfileStruct(L"View", L"rectSpecified", &oViewOptionPG.m_rectSpecifiedWindow, sizeof(RECT)))
		::SetRect(&oViewOptionPG.m_rectSpecifiedWindow, 0, 0, 760, 480);
	oViewOptionPG.Construct(IDD_DLGPAGE_OPTION_VIEW, L"\");
	oSheet.AddPage(&oViewOptionPG);

	// [X^C] ^u
	oStyleOptionPG.m_vecDocStyles = m_vecDocStyleTypes;
	oStyleOptionPG.Construct(IDD_DLGPAGE_OPTION_STYLE, L"X^C");
	oSheet.AddPage(&oStyleOptionPG);

	// [L[蓖] ^u
	oKeyBindsOptionPG.Construct(IDD_DLGPAGE_OPTION_KEYBINDS, L"L[蓖");
	oSheet.AddPage(&oKeyBindsOptionPG);

	// [R[hy[W]
	oCodePagesOptionPG.Construct(IDD_DLGPAGE_OPTION_CODEPAGE, L"R[hy[W");
	oSheet.AddPage(&oCodePagesOptionPG);

	// [XNvg] ^u
	oScriptOptionPG.Construct(IDD_DLGPAGE_OPTION_SCRIPT, L"XNvg");
	oSheet.AddPage(&oScriptOptionPG);

	if(oSheet.DoModal() == IDOK) {	// ݒ INI t@Cɕۑ
		WriteProfileInt(L"File", L"shareMode", oFileOptionPG.m_nShareMode);
		WriteProfileInt(L"File", L"bUseAutoSave", oFileOptionPG.m_bAutoSave);
		WriteProfileInt(L"File", L"nAutoSaveInterval", oFileOptionPG.m_nInterval);
		WriteProfileInt(L"File", L"writeBomAsUTF8", oFileOptionPG.m_bWriteBOMAsUTF8 ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF16LE", oFileOptionPG.m_bWriteBOMAsUTF16LE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF16BE", oFileOptionPG.m_bWriteBOMAsUTF16BE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF32LE", oFileOptionPG.m_bWriteBOMAsUTF32LE ? 1 : 0);
		WriteProfileInt(L"File", L"writeBomAsUTF32BE", oFileOptionPG.m_bWriteBOMAsUTF32BE ? 1 : 0);
		WriteProfileInt(L"File", L"mruLimit", oFileOptionPG.m_nMRULimit);
		WriteProfileInt(L"File", L"sendMailAsAttachment", oFileOptionPG.m_bSendAsAttachment ? 1 : 0);

		WriteProfileInt(L"Edit", L"bCancelSelectionAfterCopy", oEditOptionPG.m_bCancelAfterCopy);

		WriteProfileInt(L"View", L"nLeftMargin", oViewOptionPG.m_nLeftMargin);
		WriteProfileInt(L"View", L"nTopMargin", oViewOptionPG.m_nTopMargin);
		WriteProfileInt(L"View", L"bVisibleToolbar", oViewOptionPG.m_bVisibleToolbar);
		WriteProfileInt(L"View", L"bVisibleStatusBar", oViewOptionPG.m_bVisibleStatusBar);

		WriteProfileInt(L"Find", L"bShowMessageBox", oFindOptionPG.m_bShowMessageBox ? 1 : 0);
		WriteProfileInt(L"Find", L"bInitializeFromEditor", oFindOptionPG.m_bInitializeFromEditor ? 1 : 0);

		if(oFileOptionPG.m_bClearedMRU)
			m_pMRUManager->Clear();

		LoadINISettings();	// INI t@C̐ݒAvP[Vɔf
	}*/
}

///	[c[]-[fobO]-[u[N|Cg̊Ǘ]
void CAlphaApp::OnToolDebugBreakPoints() {
/*	BreakPointList							listBreakPoints;
	list<TAppDefinedLine>					listLineAttrs;
	list<TAppDefinedLine>::const_iterator	it;

	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		// AvP[Vsu[N|Cgɕϊ
		CAlphaView*		pActiveView = pActiveEditor->GetPrimaryView();
		TBreakPointInfo	bpi;

		pActiveView->GetAllLineParams(listLineAttrs);
		for(it = listLineAttrs.begin(); it != listLineAttrs.end(); ++it) {
			if(it->dwParam & LA_BREAKPOINT_ENABLED)
				bpi.bEnabled = true;
			else if(it->dwParam & LA_BREAKPOINT_DISABLED)
				bpi.bEnabled = false;
			else
				continue;
			bpi.iLine = it->iLine;
			listBreakPoints.push_back(bpi);
		}

		m_pdlgDebugBreakPoints->m_listBreakPoints = listBreakPoints;
		if(IDOK == m_pdlgDebugBreakPoints->DoModal()) {
			// u[N|Cgݒ肵
			unsigned long	cLines = pActiveView->GetDocument()->GetLineCount();

			for(unsigned long iLine = 0; iLine < cLines; ++iLine)	// xSĉ
				pActiveView->SetLineParam(iLine, LA_NONE, LA_BREAKPOINT_MASK);
			for(BreakPointList::const_iterator it
					= m_pdlgDebugBreakPoints->m_listBreakPoints.begin();
					it != m_pdlgDebugBreakPoints->m_listBreakPoints.end(); ++it)	// ݒ肷
				pActiveView->SetLineParam(it->iLine, it->bEnabled ?
					LA_BREAKPOINT_ENABLED : LA_BREAKPOINT_DISABLED, LA_BREAKPOINT_MASK);
		}
	}*/
}


///	[c[]-[fobO]-[R[X^bN]
void CAlphaApp::OnToolDebugCallStack() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugCallStack->IsWindow()) {
			m_pdlgDebugCallStack->DoModeless();
			m_pdlgDebugCallStack->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[C~fBGCg]
void CAlphaApp::OnToolDebugImmediate() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugImmediate->IsWindow()) {
			m_pdlgDebugImmediate->DoModeless();
			m_pdlgDebugImmediate->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[u[N|Cg̑}//폜]
void CAlphaApp::OnToolDebugInsertBreakPoint() {
/*	if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
		CCharPos	posBegin, posEnd;
		CAlphaView*	pView = pActiveEditor->GetPrimaryView();
		DWORD		dwLineAttr;

		pView->GetSel(posBegin, posEnd);
		dwLineAttr= pView->GetLineParam(posEnd.m_iLine);
		if(toBoolean(dwLineAttr & LA_BREAKPOINT_ENABLED)) {	// L -> 
			dwLineAttr &= ~LA_BREAKPOINT_ENABLED;
			dwLineAttr |= LA_BREAKPOINT_DISABLED;
		} else if(toBoolean(dwLineAttr & LA_BREAKPOINT_DISABLED))	//  -> 폜
			dwLineAttr &= ~LA_BREAKPOINT_DISABLED;
		else	//  -> L
			dwLineAttr |= LA_BREAKPOINT_ENABLED;
		pView->SetLineParam(posEnd.m_iLine, dwLineAttr);
	}*/
}

///	[c[]-[fobO]-[Jn]
void CAlphaApp::OnToolDebugStart() {
/*	if(GetActiveTab()->GetTextEditor() == 0)
		return;
	if(m_pActiveDebugger != 0) {	// fobOłΑs
		m_pActiveDebugger->Continue();
		return;
	}

	Alpha::BreakPointList	listBreakPoints;
	list<TAppDefinedLine>	listLines;
	CAlphaDoc*				pActiveDoc = GetActiveTab()->GetTextEditor()->GetDocument();
	Alpha::TBreakPointInfo	bpi;
	wstring					strLanguageName = m_oScriptLanguages.LanguageNameFromExtension(pActiveDoc->GetExtensionName());

	// GWŶꍇ̓_CAOŐu
	if(strLanguageName.empty()) {
		CSelectLanguageDlg	oDlg;

		oDlg.m_setLanguages = m_oScriptLanguages.GetLanguages();
		oDlg.Create(m_hInstance, IDD_DLG_SELECTLANGUAGE, m_pMainWindow->m_hWnd);
		if(IDOK != oDlg.DoModal())
			return;
		strLanguageName = oDlg.m_strSelection;
	}

	// fobOT|[gĂȂꍇɑs邩q˂
	if(!CScriptLanguageManager::QueryDebuggable(strLanguageName)
			&& IDNO == MessageBox(MSG_DEBUG_ENGINENOTSUPPORTDEBUGGING, MB_YESNO | MB_ICONQUESTION))
		return;

	m_pDebuggingEditor = GetActiveTab()->GetTextEditor();
	m_pDebuggingEditor->GetPrimaryView()->GetAllLineParams(listLines);
	for(list<TAppDefinedLine>::const_iterator it = listLines.begin(); it != listLines.end(); ++it) {
		if(it->dwParam & LA_BREAKPOINT_ENABLED)
			bpi.bEnabled = true;
		else if(it->dwParam & LA_BREAKPOINT_DISABLED)
			bpi.bEnabled = false;
		else
			continue;
		bpi.iLine = it->iLine;
		listBreakPoints.push_back(bpi);
	}

	m_pActiveDebugger = new CAlphaApplicationDebugger(m_pMainWindow->m_hWnd, listBreakPoints);
	m_pActiveDebugger->AddRef();
	m_pActiveDebugger->SetEventListener(static_cast<IAlphaApplicationDebuggerEventListener*>(this));
	m_pActiveDebugger->StartDebugging(pActiveDoc, strLanguageName);*/
}

///	[c[]-[fobO]-[Xbh]
void CAlphaApp::OnToolDebugThreads() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugThreads->IsWindow()) {
			CComPtr<IRemoteDebugApplication>	pApplication;
			m_pActiveDebugger->GetDebuggingApplication(&pApplication);
			m_pdlgDebugThreads->DoModeless();
			m_pdlgDebugThreads->Update(pApplication);
		} else
			m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}*/
}

///	[c[]-[fobO]-[ϐ]
void CAlphaApp::OnToolDebugVariables() {
/*	if(m_pActiveDebugger != 0) {
		if(!m_pdlgDebugVariables->IsWindow()) {
			m_pdlgDebugVariables->DoModeless();
			m_pdlgDebugVariables->Update(m_pActiveDebugger);
		} else
			m_pdlgDebugVariables->SendMessage(WM_CLOSE);
	}*/
}

///	[^Cvʐݒ] _CAO̕\
void CAlphaApp::OnToolDocTypeOption() {
/*	CAlphaDoc*					pActiveDoc = GetActiveDocument();
	if(pActiveDoc == 0)
		return;
	CPropertySheet		oSheet(L"^Cvʐݒ(܂܂)", m_pMainWindow->m_hWnd);
	CDocTypeOptionDlg	oDocTypeOptionPG;

	oDocTypeOptionPG.m_vecDocTypes = m_vecDocumentTypes;
	oDocTypeOptionPG.m_iActiveType = 0;
	oDocTypeOptionPG.Construct(IDD_DLGPAGE_DOCTYPEOPTION, L"C\ƃCAEg");
	oSheet.AddPage(&oDocTypeOptionPG);

	if(oSheet.DoModal()) {
	}*/
}

///	[s]
void CAlphaApp::OnToolExecute() {
	IAlphaTab*			pActiveTab = GetActiveTab();
	const CAlphaDoc*	pActiveDoc = pActiveTab->GetTextEditor()->GetDocument();

	if(pActiveDoc == 0)
		return;

	wstring	strCommand = m_oDocTypeManager.GetAt(m_oDocTypeManager.Find(pActiveDoc->m_strDocType)).strCommand;
	if(strCommand.empty()) {	// pXݒ肳ĂȂ
		MessageBox(MSG_EXENOTREGISTERED, MB_ICONEXCLAMATION, CMessageArguments() % pActiveDoc->m_strDocType);
		return;
	}

	size_t				i = 0;
	bool				bSucceeded;
	STARTUPINFOW		si;
	PROCESS_INFORMATION	pi;

	// '$F' WJ
	while(wstring::npos != (i = strCommand.find(L"$F", i))) {
		strCommand.replace(i, 2, L"\"" + pActiveDoc->GetPathName() + L"\"");
		i += pActiveDoc->GetPathName().length() + 2;
	}
	ZeroMemory(&si, sizeof(STARTUPINFOW));
	si.cb = sizeof(STARTUPINFOW);
	bSucceeded = toBoolean(::CreateProcessW(0,
		const_cast<wchar_t*>(strCommand.c_str()), 0, 0, false, NORMAL_PRIORITY_CLASS, 0, 0, &si, &pi));
	if(!bSucceeded)
		MessageBox(MSG_FAILEDTORUNEXE, MB_ICONEXCLAMATION);
}

///	[R}h̎s]
void CAlphaApp::OnToolExecuteCommand() {
	CExecuteCommandDlg	dlg(this);

	dlg.m_bHijackConsole = toBoolean(GetProfileInt(L"CommandExecuting", L"bHijackConsole", 1));
	dlg.m_bUseUnicode = toBoolean(GetProfileInt(L"CommandExecuting", L"bUseUnicode", 0));
	dlg.Create(m_hInstance, IDD_DLG_EXECUTECOMMAND, m_pMainWindow->m_hWnd);
	dlg.DoModal();
}

///	[tHg] _CAO̕\
void CAlphaApp::OnToolFont() {
	CHOOSEFONT				cf;
	CAlphaEditController*	pActiveEditor = GetActiveTab()->GetTextEditor();

	if(pActiveEditor == 0)
		return;

	ZeroMemory(&cf, sizeof(CHOOSEFONT));
	cf.lStructSize = sizeof(CHOOSEFONT);
	cf.hwndOwner = m_pMainWindow->m_hWnd;
	cf.lpLogFont = &m_lfCommonFont;
	cf.Flags = CF_INITTOLOGFONTSTRUCT | CF_NOVERTFONTS | CF_SCREENFONTS;
	cf.hInstance = m_hInstance;

	if(::ChooseFont(&cf) != TRUE)
		return;

	// SẴr[̃tHgXV
	CAlphaView*	pView = 0;
	for(unsigned int i = 0; i < m_vecDocuments.size(); ++i) {
		if(CAlphaEditController* pEditor = m_vecDocuments[i]->GetTextEditor())
			pEditor->GetPrimaryView()->ModifyFontInfo(m_lfCommonFont, true);
	}

	// INI t@Cɕۑ
	WriteProfileStruct(L"View", L"oFont.pLogfont", &m_lfCommonFont, sizeof(LOGFONT));

	//  <-> ϕŕ\LςKv
	UpdateStatusBar();
}

///	@see	IEditViewEventListener::OnChangedAbbreviationExpansionReadyState
void CAlphaApp::OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) {
	if(bReady) {
		if(const CAlphaEditController* pEditor = GetActiveTab()->GetTextEditor()) {
			if(!strAbbrev.empty()) {
				const wstring	str = LoadString(MSG_INDICATECANEXPANDABBREV,
					CMessageArguments() % strAbbrev % CEditView::ExpandAbbreviation(strAbbrev));
				::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(str.c_str()));
			}
		}
	} else
		::SendMessageW(m_hStatusBar, SB_SETTEXTW, 0 | SBT_NOBORDERS, reinterpret_cast<LPARAM>(IDS_DEFAULTSTATUSTEXT));
}

///	@see	IClipboardRingEventListener::OnClipboardRingChanged
void CAlphaApp::OnClipboardRingChanged() {
}

///	@see	IClipboardRingEventListener::OnClipboardRingDeniedAdding
void CAlphaApp::OnClipboardRingDeniedAdding() {
}

///	@see	WM_CLOSE
bool CAlphaApp::OnClose() {
	DISPPARAMS	params = {0, 0, 0, 0};
	m_pEventHandlerScript->Invoke(OLESTR("OnApplicationTerminating"), &params);
	if(OnFileCloseAll(false))
		return m_wndTab.DestroyWindow(), true;
	return false;
}

///	@see	CWindow::OnCommand
bool CAlphaApp::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	m_pCommandManager->ExecuteCommand(static_cast<CommandId>(wID), true);

/*	case CMD_DEBUG_START:	// [fobO]-[Jn/s]
		OnToolDebugStart();
		break;
	case CMD_DEBUG_STOP:	// [fobO]-[~]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->Abort();
		break;
	case CMD_DEBUG_STEPOVER:	// [fobO]-[XebvI[o[]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOver();
		break;
	case CMD_DEBUG_STEPINTO:	// [fobO]-[XebvC]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepInto();
		break;
	case CMD_DEBUG_STEPOUT:	// [fobO]-[XebvAEg]
		if(m_pActiveDebugger != 0)
			m_pActiveDebugger->StepOut();
		break;
	case CMD_DEBUG_INSERTBREAKPOINT:	// [fobO]-[u[N|Cg̑}/폜]
		OnToolDebugInsertBreakPoint();
		break;
	case CMD_DEBUG_BREAKPOINTS:		// [fobO]-[u[N|Cg̊Ǘ]
		OnToolDebugBreakPoints();
		break;
	case CMD_DEBUG_ACTIVEDOCUMENTS:	// [fobO]-[s̃hLg]
		if(m_pdlgDebugRunningDocuments->IsWindowVisible())
			m_pdlgDebugRunningDocuments->SendMessage(WM_CLOSE);
		else
			m_pdlgDebugRunningDocuments->DoModeless();
		break;
	case CMD_DEBUG_CALLSTACK:	// [fobO]-[Ăяo]
		OnToolDebugCallStack();
		break;
	case CMD_DEBUG_IMMEDIATE:	// [fobO]-[C~fBGCg]
		OnToolDebugImmediate();
		break;
	case CMD_DEBUG_THREADS:	// [fobO]-[Xbh]
		OnToolDebugThreads();
		break;
	case CMD_DEBUG_VARIABLES:	// [fobO]-[ϐ]
		OnToolDebugVariables();
		break;*/

	return true;
}

///	@see	WM_COPYDATA
void CAlphaApp::OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds) {
	vector<wstring>	vecArguments;
	GetCommandLineArguments(static_cast<wchar_t*>(pcds->lpData), vecArguments);
	vecArguments.erase(vecArguments.begin());
	ParseCommandLine(vecArguments);
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugEnd
/*void CAlphaApp::OnDebugEnd() {
	if(m_pActiveDebugger != 0) {
		m_pActiveDebugger->Release();
		m_pActiveDebugger = 0;
		m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(-1);
		m_pDebuggingEditor->GetDocument()->SetReadOnly(false);
		m_pDebuggingEditor = 0;
		m_wndOutput.WriteLine(OTT_DEBUG, L"fobOI܂ ----------------\r\n");

		// fobO_CAOЕt
		if(m_pdlgDebugCallStack->IsWindow())	m_pdlgDebugCallStack->SendMessage(WM_CLOSE);
		if(m_pdlgDebugImmediate->IsWindow())	m_pdlgDebugImmediate->SendMessage(WM_CLOSE);
		if(m_pdlgDebugVariables->IsWindow())	m_pdlgDebugVariables->SendMessage(WM_CLOSE);
		if(m_pdlgDebugThreads->IsWindow())		m_pdlgDebugThreads->SendMessage(WM_CLOSE);
	}
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugIllegalStatus
void CAlphaApp::OnDebugIllegalStatus(DebugStatus ds) {
	wstring	strPrompt;

	switch(ds) {
	case DS_OK:
		return;
	case DS_FAILEDTOGETPDM:
		MessageBox(MSG_DEBUG_FAILEDTOGETPDM, MB_ICONEXCLAMATION);
		break;
	case DS_UNKNOWNSCRIPTLANGUAGE:
		MessageBox(MSG_DEBUG_INVALIDLANGUAGENAME, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTPARSER:
		MessageBox(MSG_DEBUG_ENGINENOTSUPPORTPARSING, MB_ICONEXCLAMATION);
		break;
	case DS_ENGINENOTSUPPORTDEBUGGING:
		return;
//		strPrompt = IDS_SENOTSUPPORTDEBUG;
//		break;
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStart
void CAlphaApp::OnDebugStart() {
	m_pDebuggingEditor->GetDocument()->SetReadOnly(true);
	m_wndOutput.Clear(OTT_DEBUG);
	m_wndOutput.WriteLine(OTT_DEBUG, L"fobOJn܂ ----------------");
	UpdateStatusBar();
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStepTo
void CAlphaApp::OnDebugStepTo(unsigned long iLine) {
	if(m_pDebuggingEditor == 0)
		return;
	m_pDebuggingEditor->GetActiveView()->SetSelWithoutSelection(iLine, 0);
	m_pDebuggingEditor->GetPrimaryView()->SetAppDefinedLine(iLine);

	// fobO_CAO̍XV
	if(m_pdlgDebugCallStack->IsWindow())
		m_pdlgDebugCallStack->Update(m_pActiveDebugger);
	if(m_pdlgDebugVariables->IsWindow())
		m_pdlgDebugVariables->Update(m_pActiveDebugger);
	if(m_pdlgDebugThreads->IsWindow()) {
		CComPtr<IRemoteDebugApplication>	pApplication;
		m_pActiveDebugger->GetDebuggingApplication(&pApplication);
		m_pdlgDebugThreads->Update(pApplication);
	}

	// fobÕhLgANeBuɂ
	if(GetActiveTab()->GetTextEditor() != m_pDebuggingEditor) {
		for(unsigned int iTab = 0; iTab < m_vecDocuments.size(); ++iTab) {
			if(CAlphaEditController* pEditor = m_vecDocuments[iTab]->GetTextEditor()) {
				if(pEditor == m_pDebuggingEditor) {
					SetActiveTab(iTab);
					break;
				}
			}
		}
	}
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopAtBreakPoint
void CAlphaApp::OnDebugStopAtBreakPoint(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"u[N|CgŒ~܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}

///	@see	IAlphaApplicationDebuggerEventListener::OnDebugStopByError
void CAlphaApp::OnDebugStopByError(unsigned long iLine) {
	wostringstream	output;

	OnDebugStepTo(iLine);
	output << L"^CG[܂ [s:" << iLine << L"]";
	m_wndOutput.WriteLine(OTT_DEBUG, output.str());
}*/

///	@see	CWindow::OnDestroy
void CAlphaApp::OnDestroy() {
	// nȂ (CAlphaApp::OnClose Q)
	m_pMainWindow->KillTimer(ID_TIMER_QUERYCOMMAND);

	wchar_t			wszKeyName[30];
	unsigned short	iItem;

	// EBhËʒuƃTCY̕ۑ
	RECT	rect;
	m_pMainWindow->GetWindowRect(&rect);
	WriteProfileStruct(L"View", L"rectLastWindowPos", &rect, sizeof(RECT));

	// MRU Xg̕ۑ
	for(iItem = 0; ; ++iItem) {
		swprintf(wszKeyName, L"strPath(%d)", iItem);
		if(iItem == m_pMRUManager->GetCount()) {
			WriteProfileString(L"MRU", wszKeyName, L"");
			break;
		} else
			WriteProfileString(L"MRU", wszKeyName, m_pMRUManager->GetFilePathAt(iItem).c_str());
	}

	// 񗚗̕ۑ
	list<wstring>					listFindWhat, listReplaceWith;
	list<wstring>::const_iterator	it;
	m_pdlgSearch->GetHistory(listFindWhat, listReplaceWith);
	for(iItem = 0, it = listFindWhat.begin(); it != listFindWhat.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strFindWhat(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");
	for(iItem = 0, it = listReplaceWith.begin(); it != listReplaceWith.end(); ++iItem, ++it) {
		swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
		WriteProfileString(L"Find", wszKeyName, it->c_str());
	}
	swprintf(wszKeyName, L"strReplaceWith(%u)", iItem);
	WriteProfileString(L"Find", wszKeyName, L"");

	delete m_pMenu;
	delete m_pMRUManager;
	::DestroyWindow(m_hToolbar);
	::DestroyWindow(m_hStatusBar);
	::DeleteObject(m_hTabFont);

	// r[SĔj
	for(unsigned int i = m_vecDocuments.size(); i != 0; --i)
		m_vecDocuments[i - 1]->DeleteInstance();

//	m_wndTab.SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(m_wndprocTab));

	::PostQuitMessage(0);
}

///	@see	IEditDocEventListener::OnDocumentModified
void CAlphaApp::OnDocumentModified() {
	UpdateTitleBar();
}

///	@see	IEditDocEventListener::OnDocumentOverwrittenByOtherProcess
void CAlphaApp::OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument) {
	if(IDYES == MessageBox(MSG_FILEHASBEENMODIFIEDBYOTHER,
			MB_YESNO | MB_ICONQUESTION, CMessageArguments() % pDocument->GetPathName())) {
		size_t	i = 0;
		while(true) {
			if(i == m_vecDocuments.size())
				return;	// ...
			if(m_vecDocuments[i] == reinterpret_cast<CAlphaEditController*>(pDocument->GetController()))
				break;
			++i;
		}
		SetActiveTab(i);
		OnFileReopen();
	}
}

///	@see	IEditViewEventListener::OnDrawIndicatorMargin
void CAlphaApp::OnDrawIndicatorMargin(length_t iLine,
		CMinimalDC& oDC, const RECT& rectMargin,
		bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) {
	CPen	oPen;
	CBrush	oBrush;
	HPEN	hOldPen;
	HBRUSH	hOldBrush;
	int		nMinWidth = min(rectMargin.right - rectMargin.left, rectMargin.bottom - rectMargin.top);

	nMinWidth -= (nMinWidth + 1) % 2;	// ~ȂȂ悤ɓK...

	if(toBoolean(dwParam & LA_BREAKPOINT_ENABLED)) {	// Lȃu[N|Cg
		RECT	rectCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		oPen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		oBrush.CreateSolidBrush(RGB(0x80, 0x00, 0x00));
		hOldPen = oDC.SelectObject(oPen);
		hOldBrush = oDC.SelectObject(oBrush);
		::OffsetRect(&rectCircle,
			rectMargin.left + (rectMargin.right - rectMargin.left) / 2 - nMinWidth / 2,
			rectMargin.top + (rectMargin.bottom - rectMargin.top) / 2 - nMinWidth / 2);
		oDC.Ellipse(&rectCircle);
		oDC.SelectObject(hOldPen);
		oDC.SelectObject(hOldBrush);
	} else if(toBoolean(dwParam & LA_BREAKPOINT_DISABLED)) {	// ȃu[N|Cg
		RECT	rectCircle = {0, 0, nMinWidth - 2, nMinWidth - 2};
		oPen.CreatePen(PS_SOLID, 1, RGB(0x80, 0x00, 0x00));
		oBrush.CreateSolidBrush(RGB(0xFF, 0xF9, 0xF9));
		hOldPen = oDC.SelectObject(oPen);
		hOldBrush = oDC.SelectObject(oBrush);
		::OffsetRect(&rectCircle,
			rectMargin.left + (rectMargin.right - rectMargin.left) / 2 - nMinWidth / 2,
			rectMargin.top + (rectMargin.bottom - rectMargin.top) / 2 - nMinWidth / 2);
		oDC.Ellipse(&rectCircle);
		oDC.SelectObject(hOldPen);
		oDC.SelectObject(hOldBrush);
	}
	if(bSingleEmphasis) {	// fobOg[Xs
		// TODO: fobOg[Xs̖`
	}
}

///	@see	WM_DRAWITEM
void CAlphaApp::OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem) {
	CMinimalDC	oDC;
	const RECT&	rectItem = lpDrawItem->rcItem;
	RECT		rectCaption;
	HPEN		hOldPen, hPen;
	HBRUSH		hOldBrush, hBrush;
	wchar_t*	pszCaption = 0;
	wchar_t*	pszAccel = 0;	// ANZ[^At@C

	oDC.Attach(lpDrawItem->hDC);

	if(lpDrawItem->CtlType == ODT_MENU) {	// j[̕`
		const COLORREF	clrHighlight = ::GetSysColor(COLOR_HIGHLIGHT);
		const COLORREF	clrHighlightBack = RGB(GetRValue(clrHighlight) / 3 + 170,
										GetGValue(clrHighlight) / 3 + 170, GetBValue(clrHighlight) / 3 + 170);
		const COLORREF	clrHighlightIconBack = RGB((GetRValue(clrHighlightBack) + 0xFF) / 2,
										(GetGValue(clrHighlightBack) + 0xFF) / 2, (GetBValue(clrHighlightBack) + 0xFF) / 2);
		// wi̕`
		if(toBoolean(lpDrawItem->itemState & ODS_SELECTED)) {
			hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
			hBrush = ::CreateSolidBrush(clrHighlightBack);
			hOldPen = oDC.SelectObject(hPen);
			hOldBrush = oDC.SelectObject(hBrush);
			oDC.Rectangle(&rectItem);
			oDC.SelectObject(hOldPen);
			oDC.SelectObject(hOldBrush);
			::DeleteObject(hPen);
			::DeleteObject(hBrush);
		} else {
			oDC.FillSolidRect(&rectItem, ::GetSysColor(COLOR_MENU));
//			oDC.FillSolidRect(rectItem.left, rectItem.top,
//				rectItem.bottom - rectItem.top, rectItem.bottom - rectItem.top,
//				::GetSysColor(COLOR_3DFACE));
		}

		if(lpDrawItem->itemID >= CMD_FILE_MRULIST_START
				&& lpDrawItem->itemID < CMD_FILE_MRULIST_END) {	// MRU Xg
			const wchar_t*	pwszFilePath = GetMenuLabel(lpDrawItem->itemID);
			wostringstream	ssFilePath;

			// '&' ̏
			for(size_t i = 0; pwszFilePath[i] != 0; ++i) {
				if(pwszFilePath[i] == L'&' && i != 0)
					ssFilePath << L"&&";
				else
					ssFilePath << pwszFilePath[i];
			}
			const wstring	strFilePath = ssFilePath.str();
			pszCaption = const_cast<wchar_t*>(strFilePath.c_str());
			pszAccel = ::PathFindFileNameW(pszCaption);
			rectCaption = rectItem;
			rectCaption.left += 14;
			rectCaption.right -= 14;
			oDC.SetBkMode(TRANSPARENT);

			// pX̕`
			if(pszCaption != pszAccel) {
				oDC.SetTextColor(toBoolean(lpDrawItem->itemState & ODS_SELECTED) ?
					::GetSysColor(COLOR_MENUTEXT) : ::GetSysColor(COLOR_INACTIVECAPTION));
				oDC.DrawText(pszCaption, pszAccel - pszCaption, &rectCaption, DT_SINGLELINE | DT_VCENTER);
				oDC.DrawText(pszCaption,
					pszAccel - pszCaption, &rectCaption, DT_CALCRECT | DT_SINGLELINE | DT_VCENTER);
				rectCaption.left = rectCaption.right;
				rectCaption.right = rectItem.right;
				rectCaption.top = rectItem.top;
				rectCaption.bottom = rectItem.bottom;
			}

			// t@C̕`
			oDC.SetTextColor(toBoolean(lpDrawItem->itemState & ODS_SELECTED) ?
				::GetSysColor(COLOR_MENUTEXT) : ::GetSysColor(COLOR_ACTIVECAPTION));
			oDC.DrawText(pszAccel, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
		} else {
			// ACR̕`
			HIMAGELIST	hIconsEnabled = m_pCommandManager->GetImageList(true);
			HIMAGELIST	hIconsDisabled = m_pCommandManager->GetImageList(false);
			size_t		iIcon = m_pCommandManager->GetIconIndex(lpDrawItem->itemID);
			RECT		rectIcon;
			rectIcon.left = rectItem.left + (rectItem.bottom - rectItem.top - 16) / 2 - 1;
			rectIcon.top = rectItem.top + (rectItem.bottom - rectItem.top - 16) / 2 - 1;
			rectIcon.right = rectIcon.left + 18;
			rectIcon.bottom = rectIcon.top + 18;
			if(hIconsEnabled != 0 && iIcon != -1) {	// ACRpłꍇ
				if(toBoolean(lpDrawItem->itemState & ODS_CHECKED)) {	// `FbN
					hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
					hBrush = ::CreateSolidBrush(clrHighlightIconBack);
					hOldPen = oDC.SelectObject(hPen);
					hOldBrush = oDC.SelectObject(hBrush);
					oDC.Rectangle(&rectIcon);
					oDC.SelectObject(hOldPen);
					oDC.SelectObject(hOldBrush);
					::DeleteObject(hPen);
					::DeleteObject(hBrush);
				}
				::InflateRect(&rectIcon, -1, -1);
				if(toBoolean(lpDrawItem->itemState & ODS_DISABLED))	// 
					::ImageList_Draw(hIconsDisabled, iIcon, oDC.GetSafeHdc(), rectIcon.left, rectIcon.top, ILD_NORMAL);
//				else if(toBoolean(lpDrawItem->itemState & ODS_SELECTED))	// I
//					::ImageList_Draw(hIconsEnabled, iIcon, oDC.GetSafeHdc(), rectIcon.left, rectIcon.top, ILD_FOCUS);
				else	// L
					::ImageList_Draw(hIconsEnabled, iIcon, oDC.GetSafeHdc(), rectIcon.left, rectIcon.top, ILD_NORMAL);
				::InflateRect(&rectIcon, 1, 1);
			} else if(toBoolean(lpDrawItem->itemState & ODS_CHECKED)) {
				const int	nCheckBoxWidth = rectItem.bottom - rectItem.top;
				hPen = ::CreatePen(PS_SOLID, 1, clrHighlight);
				hBrush = ::CreateSolidBrush(clrHighlightIconBack);
				hOldPen = oDC.SelectObject(hPen);
				hOldBrush = oDC.SelectObject(hBrush);
				oDC.Rectangle(rectItem.left + 1, rectItem.top + 1,
					rectItem.left + rectItem.bottom - rectItem.top - 1, rectItem.bottom - 1);
				oDC.SelectObject(hOldPen);
				oDC.SelectObject(hOldBrush);
				::DeleteObject(hPen);
				::DeleteObject(hBrush);
				hPen = ::CreatePen(PS_SOLID, 1, RGB(0x00, 0x00, 0x00));	// v񂩂?
				hOldPen = oDC.SelectObject(hPen);
				oDC.MoveTo(rectItem.left + nCheckBoxWidth / 2 - 3, rectItem.top + nCheckBoxWidth / 2 - 1);	// `FbN}[N
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 - 1, rectItem.top + nCheckBoxWidth / 2 + 1);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 + 4, rectItem.top + nCheckBoxWidth / 2 - 4);
				oDC.MoveTo(rectItem.left + nCheckBoxWidth / 2 - 3, rectItem.top + nCheckBoxWidth / 2 + 0);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 - 1, rectItem.top + nCheckBoxWidth / 2 + 2);
				oDC.LineTo(rectItem.left + nCheckBoxWidth / 2 + 4, rectItem.top + nCheckBoxWidth / 2 - 3);
				oDC.SelectObject(hOldPen);
				::DeleteObject(hPen);
			}

			if(lpDrawItem->itemID == 0	// ؂̕`
					&& (lpDrawItem->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpDrawItem->itemData)) == 0)) {
				HPEN	hOldPen = oDC.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DSHADOW)));

				oDC.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 1);
				oDC.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 1);
				::DeleteObject(oDC.SelectObject(hOldPen));
				oDC.SelectObject(::CreatePen(PS_SOLID, 1, ::GetSysColor(COLOR_3DHIGHLIGHT)));
				oDC.MoveTo(lpDrawItem->rcItem.left + 1, lpDrawItem->rcItem.top + 2);
				oDC.LineTo(lpDrawItem->rcItem.right - 1, lpDrawItem->rcItem.top + 2);
				::DeleteObject(oDC.SelectObject(hOldPen));
			} else {	// LvV̕`
				oDC.SetBkMode(TRANSPARENT);
				rectCaption = lpDrawItem->rcItem;
		//		if(reinterpret_cast<HMENU>(lpDrawItem->hwndItem) != m_pMenu->GetSafeHmenu()) {
					COLORREF	clrCaption = ::GetSysColor(
						toBoolean(lpDrawItem->itemState & ODS_DISABLED) ? COLOR_GRAYTEXT : COLOR_MENUTEXT);
					const wchar_t*	pwszOrgCaption = (lpDrawItem->itemData == 0) ?
						GetMenuLabel(lpDrawItem->itemID) : reinterpret_cast<const wchar_t*>(lpDrawItem->itemData);
					if(lpDrawItem->itemID != 0
							&& m_pCommandManager->GetLastCommand() == lpDrawItem->itemID)
						clrCaption = RGB(GetRValue(clrCaption),
							(GetGValue(clrCaption) + 0xFF) / 2, GetBValue(clrCaption));
					oDC.SetTextColor(clrCaption);
					rectCaption.left = rectIcon.right + 6;
					rectCaption.right -= 6;
					pszCaption = new wchar_t[wcslen(pwszOrgCaption) + 1];
					wcscpy(pszCaption, pwszOrgCaption);
					pszAccel = wcschr(pszCaption, L'\t');
					if(pszAccel != 0) {
						*pszAccel = 0;
						oDC.DrawText(pszCaption, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
						oDC.DrawText(pszAccel + 1, -1, &rectCaption, DT_RIGHT | DT_SINGLELINE | DT_VCENTER);
					} else
						oDC.DrawText(pszCaption, -1, &rectCaption, DT_SINGLELINE | DT_VCENTER);
					delete[] pszCaption;
		//		} else {	// j[o[̏ꍇ
		//			if(lpDrawItem->itemState & ODS_SELECTED || lpDrawItem->itemState & ODS_HOTLIGHT) {
		//				oDC.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_HIGHLIGHT));
		//				oDC.SetTextColor(::GetSysColor(COLOR_HIGHLIGHTTEXT));
		//			} else {
		//				oDC.FillSolidRect(&rectCaption, ::GetSysColor(COLOR_BTNFACE));
		//				oDC.SetTextColor(::GetSysColor(COLOR_MENUTEXT));
		//			}
		//			oDC.DrawText(reinterpret_cast<const wchar_t*>(lpDrawItem->itemData),
		//				-1, &rectCaption, DT_CENTER | DT_VCENTER | DT_SINGLELINE);
		//		}
			}
		}
	}
	oDC.Detach();
}

///	@see	WM_DROPFILES
void CAlphaApp::OnDropFiles(HDROP hDrop) {
	const unsigned int	cFiles = ::DragQueryFileW(hDrop, 0xFFFFFFFF, 0, 0);
	wchar_t				wszFilePath[MAX_PATH];

	for(unsigned int iFile = 0; iFile < cFiles; ++iFile) {
		::DragQueryFileW(hDrop, iFile, wszFilePath, MAX_PATH);
		OpenFile(wszFilePath);
	}
	::DragFinish(hDrop);

	HWND hWnd = GetActiveTab()->GetWindow();
	if(::IsWindow(hWnd))
		::SetFocus(hWnd);
}

///	@see	WM_ENTERMENULOOP
void CAlphaApp::OnEnterMenuLoop(bool bIsTrackPopup) {
	::SendMessage(m_hStatusBar, SB_SIMPLE, true, 0L);
}

///	@see	WM_EXITMENULOOP
void CAlphaApp::OnExitMenuLoop(bool bIsTrackPopup) {
	::SendMessage(m_hStatusBar, SB_SIMPLE, false, 0L);
}

///	@see	WM_INITMENU
void CAlphaApp::OnInitMenu(HMENU hMenu) {
	CMenu*			pMenu = 0;
	unsigned int	cItems;
	CommandId		id;

	// j[ACe̗L//`FbN

	// ͑1Kŵ
	for(unsigned int j = 0; j < m_pMenu->GetItemCount(); ++j) {
		pMenu = m_pMenu->GetSubMenu(j);
		cItems = pMenu->GetItemCount();
		for(unsigned int i = 0; i < cItems; ++i) {
			id = pMenu->GetMenuItemID(i);
			pMenu->EnableMenuItem(id, m_pCommandManager->IsEnabled(id, true));
			pMenu->CheckMenuItem(id, m_pCommandManager->IsChecked(id));
		}
	}

	// [ŋߎgt@C]
//	pMenu = m_pMenu->GetSubMenu(0);
//	pMenu->SetChildPopup(m_pMRUManager->GetPopupMenu(), CMD_FILE_MRU, false, true);
//	const DWORD	dw = ::GetLastError();

	// ^uj[
	m_wndTab.GetContextMenu()->EnableMenuItem(CMD_FILE_CLOSEOTHERS, m_vecDocuments.size() > 1);

	// t@C
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_RENAME, m_pCommandManager->IsEnabled(CMD_FILE_RENAME, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_COPY, m_pCommandManager->IsEnabled(CMD_FILE_COPY, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_MOVE, m_pCommandManager->IsEnabled(CMD_FILE_MOVE, true));
	m_pFileOpeMenu->EnableMenuItem(CMD_FILE_DELETE, m_pCommandManager->IsEnabled(CMD_FILE_DELETE, true));
}

///	@see	WM_INITMENUPOPUP
void CAlphaApp::OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu) {
	// Kp^Cv
	if(m_pAppDocTypeMenu->GetSafeHmenu() == hMenu) {
		const bool	bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		while(m_pAppDocTypeMenu->GetItemCount() > 0)	// ׂč폜
			m_pAppDocTypeMenu->DeleteMenuItem(0, false);
		if(CAlphaEditController* pActiveEditor = GetActiveTab()->GetTextEditor()) {
			for(size_t i = 0; i < m_oDocTypeManager.GetCount(); ++i) {
				const TDocumentType&	type = m_oDocTypeManager.GetAt(i);
				if(type.bPrivate && !bCtrlPressed)
					continue;
				m_pAppDocTypeMenu->AppendMenuItem(
					CMD_TOOL_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
			}
			m_pAppDocTypeMenu->CheckMenuItem(
				CMD_TOOL_DOCTYPELIST_START + m_oDocTypeManager.Find(pActiveEditor->GetDocument()->m_strDocType));
		}
	}
}

///	@see	WM_MEASUREITEM
void CAlphaApp::OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI) {
	HDC					hDC;
	NONCLIENTMETRICSW	ncm;
	RECT				rect;
	HFONT				hMenuFont, hOldFont;

	// j[
	if(lpMI->CtlType == ODT_MENU) {
		if(lpMI->itemID == 0	// ؂
				&& (lpMI->itemData == 0 || wcslen(reinterpret_cast<wchar_t*>(lpMI->itemData)) == 0)) {
			lpMI->itemHeight = 4;
			lpMI->itemWidth = 30;	// ̒l͑gȂ
		} else {
			// j[̃tHg擾
			ncm.cbSize = sizeof(NONCLIENTMETRICSW);
			::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
			if(lpMI->itemID == CMD_FILE_CLOSE)	// 
				ncm.lfMenuFont.lfWeight = FW_BOLD;
			hMenuFont = ::CreateFontIndirectW(&ncm.lfMenuFont);

			hDC = m_pMainWindow->GetDC();
			hOldFont = static_cast<HFONT>(::SelectObject(hDC, hMenuFont));
			::DrawTextW(hDC, lpMI->itemData == 0 ?
				GetMenuLabel(lpMI->itemID) : reinterpret_cast<wchar_t*>(lpMI->itemData),
				-1, &rect, DT_CALCRECT | DT_NOPREFIX | DT_SINGLELINE);
			::SelectObject(hDC, hOldFont);
			m_pMainWindow->ReleaseDC(hDC);
			::DeleteObject(hMenuFont);

			if(lpMI->itemID == 0)	// |bvAbv̏ꍇA̕𑫂
				rect.right += 24;
			if(lpMI->itemID > COMMAND_END) {
				lpMI->itemHeight = rect.bottom - rect.top + 4;
				lpMI->itemWidth = rect.right - rect.left + 28;
			} else {
				lpMI->itemHeight = (rect.bottom - rect.top < 20) ? 20 : rect.bottom - rect.top;
				lpMI->itemWidth = rect.right - rect.left + ((lpMI->itemID >= COMMAND_START) ? 24 : 0);
			}
		}
	}
}

///	@see	WM_MENUCHAR
LRESULT CAlphaApp::OnMenuChar(wchar_t ch, UINT nFlags, CMenu* pMenu) {
	const UINT		cItems = pMenu->GetItemCount();
	MENUITEMINFOW	mii;

	ZeroMemory(&mii, sizeof(MENUITEMINFOW));
	mii.cbSize = sizeof(MENUITEMINFOW);
	mii.fMask = MIIM_FTYPE | MIIM_ID;

	if(ch >= L'a' && ch <= L'z')	// 啶ɂ
		ch -= 0x20;
	for(UINT iItem = 0; iItem < cItems; ++iItem) {
		pMenu->GetMenuItemInfo(iItem, &mii, false);
		if(mii.wID != 0 && !toBoolean(mii.fType & MFT_SEPARATOR)) {
			const wchar_t*	pwszAccel = wcschr(GetMenuLabel(mii.wID), L'&');
			if(pwszAccel != 0) {
				if(pwszAccel[1] == ch)
					return (iItem | 0x00020000);
			}
		}
	}
	return MNC_IGNORE;
}

///	@see	WM_MENUSELECT
void CAlphaApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu) {
	wchar_t	wszPrompt[200] = L"";
	WPARAM	wParam = 0 | SBT_NOBORDERS;

	// Vv[h ( ON 낤...)
	if(toBoolean(::SendMessageW(m_hStatusBar, SB_ISSIMPLE, 0, 0L)))
		wParam |= SB_SIMPLEID;

	// IڂɑΉXe[^Xo[ɕ\
	if(nItemID >= CMD_EDIT_PLUGINLIST_START && nItemID < CMD_EDIT_PLUGINLIST_END) {
		::SendMessageW(m_hStatusBar, SB_SETTEXTW, wParam, (m_pScriptMacroManager->GetCount() != 0) ?
			reinterpret_cast<LPARAM>(m_pScriptMacroManager->GetDescription(nItemID - CMD_EDIT_PLUGINLIST_START).c_str())
			: reinterpret_cast<LPARAM>(L""));
	} else {
		if(!toBoolean(nFlags & MF_POPUP) && !toBoolean(nFlags & MFT_SEPARATOR))
			LoadString(nItemID, wszPrompt, 200);
		::SendMessageW(m_hStatusBar, SB_SETTEXTW, wParam,
			reinterpret_cast<LPARAM>((*wszPrompt != 0) ? wcschr(wszPrompt, L'\n') + 1 : L""));
	}
}

///	@see	WM_MOUSEMOVE
void CAlphaApp::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_bSizingOutputWnd) {	// o̓EBhE̍ύX
	} 
}

///	@see	IEditViewEventListener::OnMoveCaret
void CAlphaApp::OnMoveCaret(const CCharPos& pos) {
	UpdateStatusBar();
}

///	@see	IEditViewEventListener::OnMoveCursor
void CAlphaApp::OnMoveCursor(const POINT& pt) {
	m_pMainWindow->SetTimer(ID_TIMER_MOUSEMOVE, 1200, 0);
}

///	@see	CWindow::OnNotify
bool CAlphaApp::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	switch(lpNMHDR->code) {
	case RBN_HEIGHTCHANGE:	// o[̍ς
		OnSize(0, -1, -1);
		return true;
	case RBN_CHEVRONPUSHED:	// c[o[̃VFuꂽ
		OnRebarChevronPushed(reinterpret_cast<LPNMREBARCHEVRON>(lpNMHDR));
		return true;
	case TBN_DROPDOWN: {	// c[o[̃hbv_E
		RECT		rect;
		POINT		pt;
		const bool	bCtrlPressed = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);

		::SendMessage(m_hToolbar, TB_GETRECT,
			reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem, reinterpret_cast<LPARAM>(&rect));
		pt.x = rect.left;
		pt.y = rect.bottom;
		m_pMainWindow->ClientToScreen(&pt);
		switch(reinterpret_cast<LPNMTOOLBAR>(lpNMHDR)->iItem) {
		case CMD_FILE_NEW:
			while(m_pNewDocTypeMenu->GetItemCount() > 0)	// ׂč폜
				m_pNewDocTypeMenu->DeleteMenuItem(0, false);
			for(size_t i = 0; i < m_oDocTypeManager.GetCount(); ++i) {
				const TDocumentType&	type = m_oDocTypeManager.GetAt(i);
				if(type.bPrivate && !bCtrlPressed)
					continue;
				m_pNewDocTypeMenu->AppendMenuItem(
					CMD_FILE_DOCTYPELIST_START + i, MFT_OWNERDRAW, type.strName.c_str());
			}
			m_pNewDocTypeMenu->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->m_hWnd);
			return true;
		case CMD_FILE_OPEN:
			m_pMRUManager->GetPopupMenu()->TrackPopupMenu(TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, m_pMainWindow->m_hWnd);
			return true;
		}
		break;
	}
	case TCN_GETOBJECT:	// Ӗ
		if(idCtrl == IDC_TAB_VIEWS) {
			LPNMOBJECTNOTIFY	lpNMObject = reinterpret_cast<LPNMOBJECTNOTIFY>(lpNMHDR);
			if(*lpNMObject->piid == IID_IDropTarget) {
				lpNMObject->hResult = m_wndTab.QueryInterface(*lpNMObject->piid, &lpNMObject->pObject);
				return true;
			}
		}
		break;
	case TCN_SELCHANGE:	// ANeBuȃ^uύXꂽ
		if(idCtrl == IDC_TAB_VIEWS) {
			SetActiveTab(m_wndTab.GetCurSel());
			return true;
		}
		break;
	case TTN_GETDISPINFO:	// ^ũc[`bv
		if(idCtrl == IDC_TAB_VIEWS) {
			reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR)->lpszText =
				const_cast<wchar_t*>(GetActiveTab()->GetDescription().c_str());
			return true;
		} else {
			LPNMTTDISPINFOW	lpNMTTDI = reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR);
			wchar_t			wszCommandCaption[200];
			wchar_t*		psz = 0;
			wstring			strKey;

			lpNMTTDI->hinst = m_hInstance;
			LoadString(lpNMTTDI->hdr.idFrom, wszCommandCaption, 200);
			psz = wcschr(wszCommandCaption, L'(');
			if(psz != 0)
				*psz = 0;
			strKey = m_oKeyboardMap.GetKeyString(lpNMTTDI->hdr.idFrom);
			if(!strKey.empty()) {
				wcscat(wszCommandCaption, L" (");
				wcscat(wszCommandCaption, strKey.c_str());
				wcscat(wszCommandCaption, L")");
			}
			lpNMTTDI->lpszText = wszCommandCaption;
			return true;
		}
		break;
//	case TBN_HOTITEMCHANGE:
//		lpNMTHI = reinterpret_cast<LPNMTBHOTITEM>(lpNMHDR);
//		if(0 != LoadString(lpNMTHI->idNew, wszCommandCaption, 200)) {
//			psz = wcschr(wszCommandCaption, L'\n');
//			if(psz != 0)
//				::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(psz + 1));
//		} else
//			::SendMessage(m_hStatusBar, SB_SETTEXT, 0 | SBT_NOBORDERS | SBT_OWNERDRAW, reinterpret_cast<LPARAM>(L""));
//		break;
	}
	return false;
}

///	@see	IEditView::OnQueryLineColor
void CAlphaApp::OnQueryLineColor(length_t, bool bBookmarked,
		DWORD dwParam, bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) {
	if(bSingleEmphasis)
		clrBack = RGB(0xFF, 0xFF, 0xCC);
	else if(dwParam & LA_BREAKPOINT_ENABLED)
		clrBack = RGB(0xFF, 0xEE, 0xEE);
	else if(bBookmarked)
		clrBack = RGB(0xF0, 0xF0, 0xFF);
}

///	RBN_CHEVRONPUSHED ̏
void CAlphaApp::OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron) {
	assert(lpNMRebarChevron != 0);

	REBARBANDINFOW	rbi;

	// c[o[𓾂
	ZeroMemory(&rbi, sizeof(REBARBANDINFOW));
	rbi.cbSize = sizeof(REBARBANDINFOW);
	rbi.fMask = RBBIM_CHILD;
	::SendMessage(m_hRebar, RB_GETBANDINFOW, lpNMRebarChevron->uBand, reinterpret_cast<LPARAM>(&rbi));
	const long	cButtons = ::SendMessage(rbi.hwndChild, TB_BUTTONCOUNT, 0, 0L);

	// \̃{^܂Ői
	long	iButton;
	RECT	rectButton;
	for(iButton = 0; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETITEMRECT, iButton, reinterpret_cast<LPARAM>(&rectButton));
		if(rectButton.right > lpNMRebarChevron->rc.left)
			break;
	}

	// \̃{^j[ڂɕϊ
	HMENU			hPopupMenu = ::CreatePopupMenu();
	TBBUTTONINFOW	tbbi;
	MENUITEMINFOW	item;
	POINT			pt = {lpNMRebarChevron->rc.left, lpNMRebarChevron->rc.bottom};

	ZeroMemory(&tbbi, sizeof(TBBUTTONINFOW));
	tbbi.cbSize = sizeof(TBBUTTONINFOW);
	tbbi.dwMask = TBIF_BYINDEX | TBIF_COMMAND | TBIF_STYLE;
	ZeroMemory(&item, sizeof(MENUITEMINFOW));
	item.cbSize = sizeof(MENUITEMINFOW);
	item.fMask = MIIM_DATA | MIIM_FTYPE | MIIM_ID | MIIM_STATE;
	for(; iButton < cButtons; ++iButton) {
		::SendMessage(rbi.hwndChild, TB_GETBUTTONINFOW, iButton, reinterpret_cast<LPARAM>(&tbbi));
		if(toBoolean(tbbi.fsStyle & TBSTYLE_SEP))
			::AppendMenu(hPopupMenu, MFT_OWNERDRAW | MFT_SEPARATOR, 0, 0);
		else {
			item.fType = MFT_OWNERDRAW;
			item.fState = m_pCommandManager->IsEnabled(tbbi.idCommand, true) ? MFS_ENABLED : MFS_DISABLED;
			item.fState |= (m_pCommandManager->IsChecked(tbbi.idCommand)) ? MFS_CHECKED : 0;
			item.wID = tbbi.idCommand;
			item.dwItemData = 0/*reinterpret_cast<DWORD>(GetMenuLabel(tbbi.idCommand))*/;
			::InsertMenuItemW(hPopupMenu, ::GetMenuItemCount(hPopupMenu), true, &item);
		}
	}
	::ClientToScreen(m_hRebar, &pt);
	::TrackPopupMenu(hPopupMenu, TPM_LEFTALIGN | TPM_TOPALIGN, pt.x, pt.y, 0, m_pMainWindow->m_hWnd, 0);
	::DestroyMenu(hPopupMenu);
}

///	@see	CWindow::OnSetCursor
bool CAlphaApp::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;		// J[\ʒu
	RECT	rectClient, rectStatusBar;

	m_pMainWindow->GetClientRect(&rectClient);
	if(::IsWindowVisible(m_hStatusBar))	::GetWindowRect(m_hStatusBar, &rectStatusBar);
	else								::SetRect(&rectStatusBar, 0, 0, 0, 0);
	::GetCursorPos(&pt);
	m_pMainWindow->ScreenToClient(&pt);

	if(pt.y >= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top) - 3
			&& pt.y <= rectClient.bottom - m_nOutputWndHeight - (rectStatusBar.bottom - rectStatusBar.top)) {
		::SetCursor(::LoadCursor(0, IDC_SIZENS));
		return true;
	}

	return false;
}

/**
 *	@see			CWindow::OnSize
 *	@param nType	CWindow::OnSize Q
 *	@param cx, cy	-1ɂƂ̃\bh݂͌̃EBhETCYgB
 *					̃\bhs̏PɎgpꍇɂĂяoƂł
 */
void CAlphaApp::OnSize(UINT nType, int cx, int cy) {
	RECT	rectTab, rectRebar, rectStatusBar, rectEditor;

	if(cx == -1 && cy == -1) {
		RECT	rect;
		m_pMainWindow->GetClientRect(&rect);
		cx = rect.right - rect.left;
		cy = rect.bottom - rect.top;
	}

	if(::IsWindowVisible(m_hStatusBar)) {
		::SendMessage(m_hStatusBar, WM_SIZE, cx, cy);
		::GetWindowRect(m_hStatusBar, &rectStatusBar);
		UpdateStatusBar();
	} else
		::SetRect(&rectStatusBar, 0, 0, 0, 0);

	if(::IsWindowVisible(m_hRebar)) {
		::SendMessage(m_hRebar, WM_SIZE, cx, cy);
		::GetWindowRect(m_hRebar, &rectRebar);
		::SendMessage(m_hToolbar, WM_SIZE, cx, rectRebar.bottom - rectRebar.top - 2);
	} else
		::SetRect(&rectRebar, 0, 0, 0, 0);

	if(m_wndTab.IsWindowVisible()) {
		m_wndTab.GetItemRect(0, &rectTab);
		m_wndTab.MoveWindow(0, rectRebar.bottom - rectRebar.top + 1,
			cx + 2, rectTab.bottom - rectTab.top + 5, true);
	} else
		rectTab.top = rectTab.bottom = rectRebar.bottom;

	rectEditor.left =  0;
	rectEditor.top = rectRebar.bottom - rectRebar.top
		+ rectTab.bottom - rectTab.top + (m_wndTab.IsWindowVisible() ? 5 : 0);
	rectEditor.right = cx;
	rectEditor.bottom = cy
		- (::IsWindowVisible(m_hStatusBar) ? rectStatusBar.bottom - rectStatusBar.top : 0);
//	if(m_wndOutput.IsWindow() && m_wndOutput.IsWindowVisible())
//		rectEditor.bottom -= m_nOutputWndHeight;
	if(!m_vecDocuments.empty() && m_iActiveTab < m_vecDocuments.size()) {	// [
		HWND	hwndTab = GetActiveTab()->GetWindow();
		if(::IsWindow(hwndTab))
			::MoveWindow(hwndTab, rectEditor.left, rectEditor.top,
				rectEditor.right - rectEditor.left, rectEditor.bottom - rectEditor.top, true);
	}

//	if(m_wndOutput.IsWindow()) {
//		m_wndOutput.MoveWindow(0, rectEditor.bottom + 2, cx, m_nOutputWndHeight);
//		m_wndOutput.ShowWindow(SW_SHOW);
//	}
}

///	@see	WM_TIMER
void CAlphaApp::OnTimer(UINT nIDTimer) {
	if(nIDTimer == ID_TIMER_QUERYCOMMAND && !m_vecDocuments.empty()) {	// c[o[ACe̗L/
		const size_t	cButtons = ::SendMessage(m_hToolbar, TB_BUTTONCOUNT, 0, 0L);
		TBBUTTON		tb;

		for(size_t iButton = 0; iButton < cButtons; ++iButton) {
			::SendMessage(m_hToolbar, TB_GETBUTTON, iButton, reinterpret_cast<LPARAM>(&tb));
			::SendMessage(m_hToolbar, TB_CHECKBUTTON, tb.idCommand, m_pCommandManager->IsChecked(tb.idCommand));
			::SendMessage(m_hToolbar, TB_ENABLEBUTTON, tb.idCommand, m_pCommandManager->IsEnabled(tb.idCommand, true));
		}
	} else if(nIDTimer == ID_TIMER_MOUSEMOVE) {	// qg\
/*		if(GetActiveTab()->GetTextEditor() != 0
				&& m_pActiveDebugger != 0
				&& m_pActiveDebugger->IsDebugging()) {
			CAlphaView*			pActiveView = GetActiveTab()->GetTextEditor()->GetActiveView();
			DebugPropertyInfo	dpi;
			POINT				pt, ptView;
			wstring				strExpression;
			wostringstream		ssResult;

			::GetCursorPos(&pt);
			ptView = pt;
			pActiveView->ScreenToClient(&ptView);
			strExpression = (pActiveView->HasSelection() && pActiveView->IsOverSelection(ptView)) ?
				pActiveView->GetSelection() : pActiveView->GetNearestWordFromCursor();
			dpi.m_dwValidFields = DBGPROP_INFO_NAME | DBGPROP_INFO_TYPE | DBGPROP_INFO_VALUE;
			if(!strExpression.empty()
						&& SUCCEEDED(m_pActiveDebugger->EvaluateExpression(strExpression, 10, true, &dpi))) {
				if(dpi.m_bstrType != 0
						&& wcscmp(dpi.m_bstrType, L"Error") != 0	// VC6
						&& wcscmp(dpi.m_bstrType, L"G[") != 0)	// VC7
					ssResult << dpi.m_bstrName << L" = " << dpi.m_bstrValue;
				if(dpi.m_dwValidFields & DBGPROP_INFO_NAME)		::SysFreeString(dpi.m_bstrName);
				if(dpi.m_dwValidFields & DBGPROP_INFO_TYPE)		::SysFreeString(dpi.m_bstrType);
				if(dpi.m_dwValidFields & DBGPROP_INFO_VALUE)	::SysFreeString(dpi.m_bstrValue);
			}
		}
*/		m_pMainWindow->KillTimer(ID_TIMER_MOUSEMOVE);
	}
}

/* [EOF] */