// Alpha.h
// (c) 2003-2004 exeal

#ifndef _ALPHA_H_
#define _ALPHA_H_
#include "resource.h"
#include "..\Manah\WinApp.h"
#include "..\Manah\Menu.h"
#include "AlphaTabCtrl.h"
#include "AlphaEditController.h"
#include "AlphaView.h"
#include "Ambient.h"
#include "OutputWnd.h"
//#include "OutlineParserDlg.h"
#include "KeyboardMap.h"
#include "MRUManager.h"
#include "ScriptMacroManager.h"
//#include "AlphaApplicationDebugger.h"
#include <map>
#include <sstream>
using Manah::Text::CodePage;
using Manah::Text::CPEX_AUTODETECT_USERLANG;
using Manah::Windows::CWinApp;
using Manah::Windows::CMessageArguments;
using Manah::Windows::CImageList;
using Manah::Windows::GDI::CMinimalDC;


// Literals
/////////////////////////////////////////////////////////////////////////////

#define IDN_TOOLIMAGECOUNT	(32 * 7)

#define IDS_UNTITLED			L"Untitled"
#define IDS_DEFAULTSTATUSTEXT	L""
#define IDS_FILEFILTERW			L"ׂẴt@C\0*.*\0\0"
#define IDS_KEYMACROFILENAME	L"keymacro"
#define IDS_EVENTSCRIPTFILENAME	L"events.*"
#define IDS_MACRO_DIRECTORY_NAME			L"macros\\"
#define IDS_KEYBOARDSCHEME_DIRECTORY_NAME	L"keyboardSchemes\\"
#define IDS_ICON_DIRECTORY_NAME				L"icons\\"
#define IDS_BREAK_CR	L"CR (Macintosh)"
#define IDS_BREAK_LF	L"LF (Unix)"
#define IDS_BREAK_CRLF	L"CR+LF (Windows)"
#define IDS_BREAK_NEL	L"NEL (U+0085)"
#define IDS_BREAK_LS	L"LS (U+2028)"
#define IDS_BREAK_PS	L"PS (U+2029)"

// Timer ID
#define ID_TIMER_QUERYCOMMAND	1	// c[o[ACe̗L
#define ID_TIMER_MOUSEMOVE		2	// J[\~1bɔ (qg\ȂǂɎgp)

// message ID
#define WM_EVENTHANDLER		WM_APP + 1	// CXbhCxgnhXNvgĂяo
										// wParam => unused
										// lParam => std::pair<const OLECHAR*, DISPPARAMS*>*
										// lParam->first => Cxgnh
										// lParam->second => 
#define WM_CREATENEWTAB		WM_APP + 2	// OnFileNew() Ăяo
										// wParam => 
										// lParam => unused
#define WM_ENDSCRIPTMACRO	WM_APP + 3	// }NXNvgIɑĂ
										// wParam, lParam => unused


namespace Alpha {

// O錾
class CEventHandlerScript;
class CCommandManager;
class CFindDlg;
class CGotoLineDlg;
class CBookmarkDlg;
/*class CDebugBreakPointsDlg;
class CDebugCallStackDlg;
class CDebugImmediateDlg;
class CDebugRunningDocumentsDlg;
class CDebugThreadsDlg;
class CDebugVariablesDlg;*/

namespace Ambient {
	class CApplication;
	class CDocuments;
}


///	s̑BCEditView::SetLineParam Ŏg
enum LineAttribute {
	///	ɂȂ
	LA_NONE					= 0x00,
	/// Lȃu[N|Cg
	LA_BREAKPOINT_ENABLED	= 0x01,
	///	ȃu[N|Cg
	LA_BREAKPOINT_DISABLED	= 0x02,
	///	SetLineParam p}XN
	LA_BREAKPOINT_MASK		= 0x03,
};

///	^Cvƃt@C̑Ή
struct TDocumentType {
	wstring	strName;				///	^Cv
	wchar_t	wszFileSpec[MAX_PATH];	///	ChJ[hB MAX_PATH ȉłȂ΂ȂȂ
	wstring	strCommand;				///	[s] ŎsR}hB"$F" ݂̃t@C\
	bool	bPrivate;				///	Kp\XgB
};

typedef vector<TDocumentType>	DocTypeList;


// CDocumentTypeManager class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	^Cv̊Ǘ
 *
 *	ɊǗ镶^CvXgɂ̓CfbNXŃANZXB
 *	0Ԗڂ̕^Cv͍ŏo^Ă镶^CvŁA
 *	O͋󕶎Agq̃ftHg^CvłB
 *	̕^Cv RemoveAll gĂ폜Ȃ
 */
class CDocumentTypeManager {
	// RXgN^
public:
	CDocumentTypeManager();

	// \bh
public:
	void					Add(const TDocumentType& type) throw(invalid_argument);
	size_t					Find(const wstring& strName) const;
	const TDocumentType&	GetAt(size_t iType) const throw(out_of_range);
	const TDocumentType&	GetByFileName(const wstring& strFileName) const;
	size_t					GetCount() const;
	void					RemoveAll();

	// f[^o
private:
	vector<TDocumentType>	m_vecDocTypes;
};


// CAlphaApp class definition
/////////////////////////////////////////////////////////////////////////////

/// Alpha ̃AvP[VNX
class CAlphaApp :
		public CWinApp,
		public CEditViewEventAdapter,
		virtual public IEditDocEventListener,
		virtual public IClipboardRingEventListener/*,
		virtual public IAlphaApplicationDebuggerEventListener*/ {
	friend class CAlphaApplication;
	friend class CCommandManager;

	// f[^o
protected:
	/* CX^X */
	static CAlphaApp*	m_pInstance;	// 1̃CX^X

private:
	/* EBhE */
	CMenu*				m_pMenu;			// Cj[
	CMenu*				m_pFileOpeMenu;		// [t@C] |bvAbvj[
	CMenu*				m_pNewDocTypeMenu;	// VKhLg^Cv|bvAbvj[
	CMenu*				m_pAppDocTypeMenu;	// KphLg^Cv|bvAbvj[
	HWND				m_hRebar;			// o[
	HWND				m_hToolbar;			// c[o[
	HWND				m_hDebugBar;		// fobOo[
	HWND				m_hStatusBar;		// Xe[^Xo[
	CAlphaTabCtrl		m_wndTab;			// ^u
	unsigned int		m_iActiveTab;		// ANeBuȃ^u
	unsigned int		m_iLastActiveTab;	// OANeBu^u
	COutputWnd			m_wndOutput;		// [o] EBhE
	vector<IAlphaTab*>	m_vecDocuments;		// e^u
	CFindDlg*			m_pdlgSearch;		// [ƒu]_CAO
	CGotoLineDlg*		m_pdlgGotoLine;		// [wsֈړ]_CAO
	CBookmarkDlg*		m_pdlgBookmark;		// [ubN}[N]_CAO
//	COutlineParserDlg	m_dlgOutline;		// [AEgC]_CAO
	WNDPROC				m_wndprocTab;		// ^ǔ̃EBhEvVW
	int					m_nOutputWndHeight;	// o̓EBhE̍
	bool				m_bSizingOutputWnd;	// o̓EBhE̍ύX

	/* GDI IuWFNg */
	LOGFONTW	m_lfCommonFont;
	HFONT		m_hTabFont;						// ^uɎgptHg
	CImageList	m_oTabIconsImageList;			// ^uɎgpC[WXg

	/* @\ƃR}h */
	CEventHandlerScript*		m_pEventHandlerScript;	// event.* s錾GW
//	CAlphaApplicationDebugger*	m_pActiveDebugger;		// ANeBuȃfobK
	CAlphaEditController*		m_pDebuggingEditor;		// fobÕGfB^
	CCommandManager*			m_pCommandManager;		// R}h̊Ǘ
	CKeyboardMap				m_oKeyboardMap;			// gp̃L[{[h}bv
	CMRUManager*				m_pMRUManager;			// MRU Xg̊Ǘ
	CDocumentTypeManager		m_oDocTypeManager;		// ^Cv̊Ǘ
	CScriptMacroManager*		m_pScriptMacroManager;	// XNvg}N̊Ǘ
	bool						m_bCancelSelAfterCopy;	// Rs[sɑI邩

	/* fobO_CAO */
/*	CDebugBreakPointsDlg*		m_pdlgDebugBreakPoints;			// [u[N|Cg] _CAO
	CDebugCallStackDlg*			m_pdlgDebugCallStack;			// [Ăяo] _CAO
	CDebugImmediateDlg*			m_pdlgDebugImmediate;			// [C~fBGCg] _CAO
	CDebugRunningDocumentsDlg*	m_pdlgDebugRunningDocuments;	// [s̃hLg] _CAO
	CDebugThreadsDlg*			m_pdlgDebugThreads;				// [Xbh] _CAO
	CDebugVariablesDlg*			m_pdlgDebugVariables;			// [ϐ] _CAO
*/
	/* I[g[VpC^[tFCX */
	Alpha::Ambient::CApplication*	m_pApplication;
	Alpha::Ambient::CDocuments*		m_pDocuments;

	/* IvV */
	bool	m_bShowMessageBoxOnFind;			// ŃbZ[W{bNX\
	bool	m_bInitializeFindTextFromEditor;	// [ƒu] _CAOJƂ
												// eLXgGfB^珉

protected:
	/* EBhEvVW */
	static LRESULT CALLBACK AppWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// RXgN^
public:
	CAlphaApp();
	virtual ~CAlphaApp();

	// \bh
public:
	void					ApplyDocumentType(unsigned int iTab, const wstring& strTypeName = L"") throw(out_of_range);
	IAlphaTab*				GetActiveTab() const;
	unsigned int			GetActiveTabIndex() const;
	HRESULT					GetAutomation(
								Alpha::Ambient::CApplication** ppApplication,
								Alpha::Ambient::CDocuments** ppDocuments) const;
	static const wchar_t*	GetCodePageName(CodePage cp);
	const CCommandManager&	GetCommandManager() const;
	CDocumentTypeManager*	GetDocumentTypeManager() const;
	CKeyboardMap&			GetKeyboardMap() const;
	static CAlphaApp*		GetInstance();
	IAlphaTab*				GetTab(unsigned int iTab) const throw(out_of_range);
	unsigned int			GetTabCount() const;
	virtual bool			InitApplication(HINSTANCE hInstance);
	virtual bool			InitInstance();
	int						MessageBox(DWORD wID, UINT nType, CMessageArguments& args = CMessageArguments());
	bool					OpenFile(const wstring& strPathName, CodePage cp = CPEX_AUTODETECT_USERLANG,
								const wstring& strDocTypeName = L"", bool bAddToMRU = true);
	void					ParseCommandLine(const vector<wstring>& vecArgs);
	void					SetActiveTab(unsigned int iTab) throw(out_of_range);

	// ZbgAbv (INI t@CȂǂݒǂݍ)
	void	LoadINISettings();
	void	LoadKeyBinds(const wstring& strSchemeName);
	void	SetupMenus();
	void	SetupToolbar();

	// IEditViewEventListener C^[tFCX
	void	OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev);
	void	OnDrawIndicatorMargin(Ascension::length_t iLine, CMinimalDC& oDC,
				const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis);
	void	OnIncrementalSearchEvent(IncrementalSearchEvent event, const char_t* pwsz);
	void	OnInvokeUriLink(const char_t* pwszUri);
	void	OnMoveCaret(const CCharPos& pos);
	void	OnMoveCursor(const POINT& pt);
	void	OnQueryLineColor(Ascension::length_t iLine, bool bBookmarked, DWORD dwParam,
				bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack);

	// IEditDocEventListener C^[tFCX
	void	OnDocumentModified();
	void	OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument);

	// IClipboardRingEventListener C^[tFCX
	void	OnClipboardRingChanged();
	void	OnClipboardRingDeniedAdding();
/*
	// IAlphaApplicationDebuggerEventListener C^[tFCX
	void	OnDebugStart();
	void	OnDebugEnd();
	void	OnDebugStopAtBreakPoint(unsigned long iLine);
	void	OnDebugStopByError(unsigned long iLine);
	void	OnDebugStepTo(unsigned long iLine);
	void	OnDebugIllegalStatus(DebugStatus ds);
*/
protected:
	virtual LRESULT	DispatchEvent(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	void			GetModelessDialogList(list<HWND>& listDlgs) const;
	bool			HandleFileOpenError(Ascension::StreamStatus ss);
	void			ModifyTabIcons();
	void			UpdateStatusBar();
	void			UpdateTitleBar();

	// bZ[Wnh
protected:
	virtual bool	OnFileClose(bool bConfirm = true);
	virtual bool	OnFileCloseAll(bool bExceptCurrent);
	virtual void	OnFileNew(UINT nCodePage);
	virtual void	OnFileNewWithFormat();
	virtual bool	OnFileOpen();
	virtual void	OnFileReopen();
	virtual void	OnFileReopenWithCodepage();
	virtual bool	OnFileSave(unsigned int iTab = -1) throw(out_of_range);
	virtual bool	OnFileSaveAs(unsigned int iTab = -1) throw(out_of_range);
	virtual bool	OnFileSaveAll();
	virtual void	OnFileProperty();
	virtual void	OnFileOperation(UINT id);
	virtual void	OnEditReloadPlugin();
	virtual void	OnFindFind();
	virtual void	OnFindFindNext(bool bPrevious = false, bool bNotice = true);
	virtual void	OnFindBookmarkAll();
	virtual void	OnFindToggleBookmark();
	virtual void	OnFindReplaceAll();
	virtual void	OnFindReplaceAndNext();
	virtual void	OnFindParseOutline();
	virtual void	OnToolCommonOption();
	virtual void	OnToolDocTypeOption();
	virtual void	OnToolFont();
	virtual void	OnToolExecute();
	virtual void	OnToolExecuteCommand();
	virtual void	OnToolDebugStart();
	virtual void	OnToolDebugInsertBreakPoint();
	virtual void	OnToolDebugBreakPoints();
	virtual void	OnToolDebugCallStack();
	virtual void	OnToolDebugImmediate();
	virtual void	OnToolDebugVariables();
	virtual void	OnToolDebugThreads();
	virtual void	OnHelpAbout();

protected:
	virtual bool	OnClose();													// WM_CLOSE
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);		// WM_COMMAND
	virtual void	OnCopyData(HWND hWnd, PCOPYDATASTRUCT pcds);				// WM_COPYDATA
	virtual void	OnDestroy();												// WM_DESTROY
	virtual void	OnDrawItem(UINT idCtrl, LPDRAWITEMSTRUCT lpDrawItem);		// WM_DRAWITEM
	virtual void	OnDropFiles(HDROP hDrop);									// WM_DROPFILES
	virtual void	OnEnterMenuLoop(bool bIsTrackPopup);						// WM_ENTERMENULOOP
	virtual void	OnExitMenuLoop(bool bIsTrackPopup);							// WM_EXITMENULOOP
	virtual void	OnInitMenu(HMENU hMenu);									// WM_INITMENU
	virtual void	OnInitMenuPopup(HMENU hMenu, UINT nIndex, bool bSysMenu);	// WM_INITMENUPOPUP
	virtual void	OnMeasureItem(UINT idCtrl, LPMEASUREITEMSTRUCT lpMI);		// WM_MEASUREITEM
	virtual LRESULT	OnMenuChar(wchar_t ch, UINT nFlags, CMenu* pMenu);			// WM_MENUCHAR
	virtual void	OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);	// WM_MENUSELECT
	virtual void	OnMouseMove(UINT nFlags, POINT pt);							// WM_MOUSEMOVE
	virtual bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);						// WM_NOTIFY
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);		// WM_SETCURSOR
	virtual void	OnSize(UINT nType, int cx, int cy);							// WM_SIZE
	virtual void	OnTimer(UINT nIDTimer);										// WM_TIMER

protected:
	void	OnRebarChevronPushed(LPNMREBARCHEVRON lpNMRebarChevron);	// RBN_CHEVRONPUSHED

	// hLgAr[̕ύXĎ
protected:
	static void OnUpdateDocument();

	// [t@CJ] _CAOtbNvVW
protected:
	static UINT CALLBACK	OFNHookProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// J[eBeB
protected:
	const wchar_t*	GetMenuLabel(CommandId id) const;
	void			GetProfileList(const wchar_t* pwszSectionName,
						const wchar_t* pwszKeyName, list<wstring>& listItems, const wchar_t* pwszDefault = 0);
	void			GetProfileSet(const wchar_t* pwszSectionName,
						const wchar_t* pwszKeyName, set<wstring>& setItems, const wchar_t* pwszDefault = 0);
};


///	R}hǗIuWFNgԂ
inline const CCommandManager& CAlphaApp::GetCommandManager() const {
	AssertValid();
	return *m_pCommandManager;
}

///	^Cv}l[WA
inline CDocumentTypeManager* CAlphaApp::GetDocumentTypeManager() const {
	AssertValid();
	return &const_cast<CAlphaApp*>(this)->m_oDocTypeManager;
}

///	B̃AvP[VIuWFNgԂ
inline CAlphaApp* CAlphaApp::GetInstance() {
	return CAlphaApp::m_pInstance;
}

///	L[蓖ăIuWFNgԂ
inline CKeyboardMap& CAlphaApp::GetKeyboardMap() const {
	AssertValid();
	return const_cast<CAlphaApp*>(this)->m_oKeyboardMap;
}

/**
 *	INI 當񃊃Xgǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param listItems		[out] Xg
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void CAlphaApp::GetProfileList(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, list<wstring>& listItems, const wchar_t* pwszDefault /* = 0 */) {
	wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	wstring	strItem;

	listItems.clear();
	if(strList.empty())
		return;
	wistringstream	wis(strList);
	while(wis >> strItem)
		listItems.push_back(strItem);
}


/**
 *	INI 當̏Wǂݍ
 *	@param pwszSectionName	ZNV
 *	@param pwszKeyName		L[
 *	@param setItems			[out] W
 *	@param pwszDefault		[in] ݒ肪ȂƂɎgp镶
 */
inline void	CAlphaApp::GetProfileSet(const wchar_t* pwszSectionName,
		const wchar_t* pwszKeyName, set<wstring>& setItems, const wchar_t* pwszDefault /* = 0 */) {
	wstring	strList = GetProfileString(pwszSectionName, pwszKeyName, pwszDefault);
	wstring	strItem;

	setItems.clear();
	if(strList.empty())
		return;
	wistringstream	wis(strList);
	while(wis >> strItem)
		setItems.insert(strItem);
}

} /* namespace Alpha */

#endif /* _ALPHA_H_ */

/* [EOF] */