// AlphaEditController.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "AlphaEditController.h"
#include "AlphaView.h"
#include "Ambient.h"
#include "resource.h"

using Alpha::CAlphaEditController;
using Alpha::CAlphaDoc;
using Alpha::CAlphaView;
using namespace Manah::Windows;


// CAlphaEditController class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAlphaEditController::CAlphaEditController() : m_pAutomationProcessor(0), m_pAutomationSelection(0) {
}

///	fXgN^
CAlphaEditController::~CAlphaEditController() {
	if(m_pAutomationProcessor != 0)	m_pAutomationProcessor->Release();
	if(m_pAutomationSelection != 0)	m_pAutomationSelection->Release();
}

///	@see	CController::_NewDocumentInstance
CDocument* CAlphaEditController::_NewDocumentInstance() {
	return new CAlphaDoc(this);
}

///	@see	CController::_NewViewInstance
CView* CAlphaEditController::_NewViewInstance() {
	return new CAlphaView();
}

///	@see	CController::_NewViewInstance
CEditView* CAlphaEditController::_NewViewInstance(const CEditView& rhs) {
	return new CAlphaView(*static_cast<const CAlphaView*>(&rhs));	// _ELXggĂ
}

///	@see	IAlphaTab::DeleteInstance
void CAlphaEditController::DeleteInstance() {
//	GetDocument()->SetEventListener(0);	// r[̔j󒆂ɃNCAgɃR[obN\
	DestroyWindow();
	delete this;
}

/**
 *	r[̌JI[g[VIuWFNgԂ
 *	@param riid			IuWFNg IIDBIID_ITextProcessor AIID_ITextSelection ̂
 *	@param ppAutomation	[out] ߂l
 */
HRESULT CAlphaEditController::GetAutomation(REFIID riid, IDispatch** ppAutomation) const {
	AssertValid();
	assert(ppAutomation != 0);

	if(riid == IID_ITextProcessor) {
		if(m_pAutomationProcessor == 0) {
			m_pAutomationProcessor = new Ambient::CTextProcessor(*const_cast<CAlphaEditController*>(this));
			if(m_pAutomationProcessor == 0)
				return (*ppAutomation = 0), E_OUTOFMEMORY;
			m_pAutomationProcessor->AddRef();
		}
		*ppAutomation = m_pAutomationProcessor;
	} else if(riid == IID_ITextSelection) {
		if(m_pAutomationSelection == 0) {
			m_pAutomationSelection = new Ambient::CTextSelection(*const_cast<CAlphaEditController*>(this));
			if(m_pAutomationSelection == 0)
				return (*ppAutomation = 0), E_OUTOFMEMORY;
			m_pAutomationSelection->AddRef();
		}
		*ppAutomation = m_pAutomationSelection;
	} else
		return E_NOINTERFACE;
	(*ppAutomation)->AddRef();
	return S_OK;
}

///	@see	IAlphaTab::GetDescription
wstring CAlphaEditController::GetDescription() const {
	wstring	strDescription = GetDocument()->GetPathName();
	if(GetDocument()->IsModified())
		strDescription += L" *";
	return strDescription;
}

///	@see	IAlphaTab::GetTabTitle
wstring CAlphaEditController::GetTabTitle() const {
	const bool	bReadOnly = GetDocument()->IsReadOnly();
	const bool	bModified = GetDocument()->IsModified();

	if(bReadOnly || bModified) {
		wostringstream	ssTitle;
		wchar_t			wszReadOnlyTag[100];

		::LoadStringW(::GetModuleHandle(0), MSG_READONLYTITLE, wszReadOnlyTag, 100);
		ssTitle << GetDocument()->GetTitle() << L" ";
		if(bReadOnly)
			ssTitle << wszReadOnlyTag;
		if(bModified)
			ssTitle << L"*";
		return ssTitle.str();
	} else
		return GetDocument()->GetTitle();
}

///	@see	IAlphaTab::OnActivateTab
void CAlphaEditController::OnActivateTab(bool bActive) {
	ShowWindow(bActive ? SW_SHOW : SW_HIDE);
}

///	@see	IAlphaTab::RefreshWindow
void CAlphaEditController::RefreshWindow() {
	GetActiveView()->Freeze();
	GetActiveView()->Unfreeze();
}

/* [EOF] */