// AlphaEditController.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _ALPHA_EDIT_CONTROLLER_H_
#define _ALPHA_EDIT_CONTROLLER_H_

#include "Ascension\EditController.h"
#include "AlphaTab.h"


// CAlphaEditController class definition
/////////////////////////////////////////////////////////////////////////////

interface ITextProcessor;
interface ITextSelection;

namespace Alpha {

class CAlphaDoc;
class CAlphaView;

class CAlphaEditController :
		public Ascension::CEditController,
		virtual public IAlphaTab {
	// RXgN^
public:
	CAlphaEditController();
	~CAlphaEditController();

	// \bh
public:
	CAlphaView*	GetActiveView() const;
	HRESULT		GetAutomation(REFIID riid, IDispatch** ppAutomation) const;
	CAlphaDoc*	GetDocument() const;
	CAlphaView*	GetPrimaryView() const;
protected:
	virtual Manah::Windows::CDocument*	_NewDocumentInstance();
	virtual Manah::Windows::CView*		_NewViewInstance();
	virtual Ascension::CEditView*		_NewViewInstance(const Ascension::CEditView& rhs);

	// IAlphaTab C^[tFCX
public:
	void					DeleteInstance();
	wstring					GetDescription() const;
	wstring					GetFilePath() const;
	wstring					GetTabTitle() const;
	HWND					GetWindow() const;
	CAlphaEditController*	GetTextEditor();
	void					RefreshWindow();
	void					OnActivateTab(bool bActive);

	// f[^o
private:
	mutable ITextProcessor*	m_pAutomationProcessor;
	mutable ITextSelection*	m_pAutomationSelection;
};


// CAlphaEditController class inline implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CEditController::GetActiveView
inline CAlphaView* CAlphaEditController::GetActiveView() const {
	AssertValid();
//	using Ascension::CEditController;	// VC6
//	return reinterpret_cast<CAlphaView*>(this->CEditController::GetActiveView());
	return reinterpret_cast<CAlphaView*>(Ascension::CEditController::GetActiveView());
}

///	@see	CController::GetDocument
inline CAlphaDoc* CAlphaEditController::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CAlphaDoc*>(m_pDocument);
}

///	@see	IAlphaTab::GetFilePath
inline wstring CAlphaEditController::GetFilePath() const {
	AssertValid();
	return m_pDocument->GetPathName();
}

///	@see	CController::GetPrimaryView
inline CAlphaView* CAlphaEditController::GetPrimaryView() const {
	AssertValid();
//	using Ascension::CEditController;	// VC6
//	return reinterpret_cast<CAlphaView*>(this->CEditController::GetPrimaryView());
	return reinterpret_cast<CAlphaView*>(Ascension::CEditController::GetPrimaryView());
}

///	@see	IAlpha::GetTextEditor
inline CAlphaEditController* CAlphaEditController::GetTextEditor() {
	AssertValid();
	return this;
}

///	@see	IAlphaTab::GetWindow
inline HWND CAlphaEditController::GetWindow() const {
	AssertValid();
	return m_hWnd;
}

} // namespace Alpha


#endif /* _ALPHA_EDIT_CONTROLLER_H_ */

/* [EOF] */