// AlphaScriptHost.h
// (c) 2003-2004 exeal

#ifndef _ALPHA_SCRIPT_HOST_H_
#define _ALPHA_SCRIPT_HOST_H_

#include <activscp.h>	// IActiveScriptSite, IActiveScriptSiteWindow
#include <ocidl.h>		// IConnectionPoint, ...
#include "..\Armaiti\UnknownImpl.h"
#include <string>
#include <map>
#include <stack>
#include <stdexcept>
#ifdef IMPLEMENT_DEBUGGER_HOST
#include <activdbg.h>	// IActiveScriptSiteDebug
#endif /* IMPLEMENT_DEBUGGER_HOST */

// IInternetHostSecurityManager::GetSecurityId 3̌^̖
#if(_MSC_VER < 1300)	// -VC6
#define IIHSMGSI_3RD_PARAM_TYPE	DWORD
#else					// VC7-
#define IIHSMGSI_3RD_PARAM_TYPE	DWORD_PTR
#endif

namespace Alpha {

///	XNvgzXg̃ZLeBx
enum ScriptSiteSecurityLevel {
	SSSL_ALLOW,		///	
	SSSL_QUERYUSER,	///	[Uɖ₢킹
	SSSL_DISALLOW,	///	
};


/**
 *	@brief	XNvgzXg
 *
 *	̃XNvgzXg Alpha ̂߂ɍ쐬A
 *	̃AvP[Vɑgݍ߂悤ɂĂB
 *	[UC^[tFCX͓{ꂩp̂ꂩŁA
 *	[Ǔꎯʎq玩IɌ肳 (Iɒm肽ꍇ
 *	IActiveScriptSite::GetLCID gƂ悢)
 *
 *	fobK̃zXgƂĂĂ邪A܂SłȂ
 */
class CAlphaScriptHost :
		public Armaiti::IUnknownImpl<Armaiti::MultiThreadedRefCount>,
		virtual public IActiveScriptSite,
		virtual public IActiveScriptSiteWindow,
#ifdef IMPLEMENT_DEBUGGER_HOST
		virtual public IActiveScriptSiteDebug,
#endif /* IMPLEMENT_DEBUGGER_HOST */
		virtual public IServiceProvider,
		virtual public IInternetHostSecurityManager {
	// RXgN^
public:
	CAlphaScriptHost(HWND hWnd, IActiveScript* pScriptEngine, bool bIgnoreCaseOnPropertySearch);
	virtual ~CAlphaScriptHost();

	// \bh
public:
	void			AddTopLevelObject(const OLECHAR* pwszObjectName, IDispatch* pObject, DWORD dwItemTraits);
	void			AllowErrorReport(bool bAllow);
	HRESULT			ConnectObject(IDispatch* pObject, const OLECHAR* pwszPrefix);
	HRESULT			DisconnectObject(IDispatch* pObject);
	static void		FindScriptEngine(const wchar_t* pwszFileName, CLSID& clsid);
	bool			IsInteractive() const;
	void			GetScriptEngine(IActiveScript*& pScriptEngine) const;
	wstring			GetScriptPath() const;
	unsigned long	GetTimeout() const;
	void			SetInteractiveMode(bool bInteractive);
	void			SetScriptPath(const wchar_t* pwszScriptPath);
	void			SetSecurityLevel(bool bForSafeObject, ScriptSiteSecurityLevel nLevel);
	void			SetTimeout(unsigned long nMilliseconds) throw(std::logic_error);
	void			Sleep(unsigned long nMilliseconds);
private:
	HRESULT			InvokeScriptGlobalProcedure(const OLECHAR* pwszName, LCID lcid, DISPPARAMS* pParams);
	void			ReleaseTopLevelObjects(bool bAlsoRegistered);
	static unsigned int WINAPI	EventSinkThreadProc(void* p);

public:
	// IUnknown \bh
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IActiveScriptSite)
		IMPLEMENTS_INTERFACE(IActiveScriptSiteWindow)
#ifdef IMPLEMENT_DEBUGGER_HOST
		IMPLEMENTS_INTERFACE(IActiveScriptSiteDebug)
#endif /* IMPLEMENT_DEBUGGER_HOST */
		IMPLEMENTS_INTERFACE(IServiceProvider)
		IMPLEMENTS_INTERFACE(IInternetHostSecurityManager)
	END_INTERFACE_TABLE()

	// IActiveScriptSite \bh
	STDMETHODIMP	GetLCID(LCID* plcid);
	STDMETHODIMP	GetItemInfo(LPCOLESTR pstrName,
						DWORD dwReturnMask, IUnknown** ppiunkItem, ITypeInfo** ppti);
	STDMETHODIMP	GetDocVersionString(BSTR* pbstrVersion);
	STDMETHODIMP	OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo);
	STDMETHODIMP	OnStateChange(SCRIPTSTATE ssScriptState);
	STDMETHODIMP	OnScriptError(IActiveScriptError* pscripterror);
	STDMETHODIMP	OnEnterScript();
	STDMETHODIMP	OnLeaveScript();

	// IActiveScriptSiteWindow \bh
	STDMETHODIMP	GetWindow(HWND* phwnd);
	STDMETHODIMP	EnableModeless(BOOL fEnable);

#ifdef IMPLEMENT_DEBUGGER_HOST
	// IActiveScriptSiteDebug \bh
	STDMETHODIMP	GetDocumentContextFromPosition(DWORD dwSourceContext,
						ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc);
	STDMETHODIMP	GetApplication(IDebugApplication** ppda);
	STDMETHODIMP	GetRootApplicationNode(IDebugApplicationNode** ppdanRoot);
	STDMETHODIMP	OnScriptErrorDebug(IActiveScriptErrorDebug* pErrorDebug,
						BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing);
#endif /* IMPLEMENT_DEBUGGER_HOST */

	// IServiceProvider \bh
	STDMETHODIMP	QueryService(REFGUID guidService, REFIID riid, void** ppvObject);

	// IInternetHostSecurityManager \bh
	STDMETHODIMP	GetSecurityId(BYTE* pbSecurityId, DWORD* pcbSecurityId, IIHSMGSI_3RD_PARAM_TYPE dwReserved);
	STDMETHODIMP	ProcessUrlAction(DWORD dwAction, BYTE* pPolicy, DWORD cbPolicy,
						BYTE* pContext, DWORD cbContext, DWORD dwFlags, DWORD dwReserved);
	STDMETHODIMP	QueryCustomPolicy(REFGUID guidKey, BYTE** ppPolicy, DWORD* pcbPolicy,
						BYTE *pContext, DWORD cbContext, DWORD dwReserved);

private:
	///	CAlphaScriptHost::ConnectObject ACAlphaScriptHost::DisconnectObject
	///	̂ɎgAhzbNȃCxgVNIuWFNg
	class CAdhocEventSink :
			public Armaiti::IUnknownImpl<Armaiti::MultiThreadedRefCount>,
			virtual public IDispatch {
		// RXgN^
	public:
		CAdhocEventSink(const IID& iidEvent, CAlphaScriptHost* pScriptHost, const wstring& strPrefix);
		~CAdhocEventSink();

		// \bh
	public:
		HRESULT	Connect(IConnectionPoint* pConnectionPoint);
		HRESULT	Disconnect();

		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN()
		STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject);

		// IDispatch C^[tFCX
		STDMETHODIMP	GetTypeInfoCount(UINT* pcTypeInfo);
		STDMETHODIMP	GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo);
		STDMETHODIMP	GetIDsOfNames(REFIID riid,
							OLECHAR** rgszNames, unsigned int cNames, LCID lcid, DISPID* rgDispId);
		STDMETHODIMP	Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
							WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult,
							EXCEPINFO* pExcepInfo, unsigned int* puArgErr);

		// f[^o
	private:
		IConnectionPointContainer*	m_pConnectionPointContainer;	// ڑ|Cg (̃Rei)
		const IID			m_iidEvent;		// G~[gC^[tFCX IID
		CAlphaScriptHost*	m_pScriptHost;	// XNvgzXg
		const std::wstring	m_strPrefix;	// Cxgnh̐ړ
		DWORD				m_dwCookie;		// Advise Ɏ擾NbL[
		std::map<wstring, DISPID>	m_mapEvents;
		std::map<DISPID, wstring>	m_mapHandlers;
	};

	typedef std::map<IDispatch*, HANDLE>		EventSinkThreadMap;
	typedef std::map<std::wstring, IDispatch*>	MemberTable;

	struct TTopLevelObject {
		std::wstring	strObjectName;
		IDispatch*		pObject;
		DWORD			dwItemTraits;
	};

	// f[^o
public:
	static const wchar_t*		m_pwszName;			///	XNvgzXg̖O
	static const unsigned short	m_nMajorVersion;	///	W[o[W
	static const unsigned short	m_nMinorVersion;	///	}Ci[o[W
	static const unsigned short	m_nBuildVersion;	///	rhԍ
private:
	HWND							m_hOwnerWindow;			// zXgEBhE
	MemberTable						m_mapTopLevelObjects;	// gbvxIuWFNg
	std::stack<TTopLevelObject*>	m_stkWaitingObjects;	// gbvxƂĒǉ̂҂ĂIuWFNg
	IActiveScript*					m_pScriptEngine;		// XNvgGW (アQ)
	EventSinkThreadMap				m_mapEventSinkThreads;	// XNvgIuWFNg -> CxgVNXbh̃}bv
	ScriptSiteSecurityLevel			m_nSecurityLevelForSafeObject;
	ScriptSiteSecurityLevel			m_nSecurityLevelForUnsafeObject;
	mutable bool					m_bIsErrorReported;		// IsErrorReportedAtLastParse Q
	bool							m_bAllowedErrorReport;	// AllowErrorReport Q
	const bool						m_bIgnoreCase;			// vpeBTɑ啶ʂȂ
	wchar_t							m_wszScriptPath[MAX_PATH];
	bool							m_bEnteredScript;
	bool							m_bInteractive;			// Θb[h
	unsigned long					m_nTimeout;				// ^CAEg (~b)
};


///	񋓂̑Ȏ
class CEnumImpl : virtual public IDispatch, public Armaiti::IUnknownImpl<Armaiti::MultiThreadedRefCount> {
	// RXgN^
public:
	CEnumImpl(bool bIgnoreCaseOnPropertySearch);

	// \bh
public:
	void	AddProperty(const OLECHAR* pwszName, long value) throw(std::invalid_argument);

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDispatch)
	END_INTERFACE_TABLE()

	// IDispatch C^[tFCX
	STDMETHODIMP	GetTypeInfoCount(UINT* pcTypeInfo);
	STDMETHODIMP	GetTypeInfo(UINT iTypeInfo, LCID lcid, ITypeInfo** ppTypeInfo);
	STDMETHODIMP	GetIDsOfNames(REFIID riid, LPOLESTR* rgszNames, UINT cNames, LCID lcid, DISPID* rgDispId);
	STDMETHODIMP	Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
						DISPPARAMS *pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, UINT* puArgErr);

	// f[^o
private:
	typedef std::map<std::wstring, DISPID>	NameToIdTable;
	typedef std::map<DISPID, long>			IdToValueTable;
	NameToIdTable	m_mapNameTable;
	IdToValueTable	m_mapIdTable;
	const bool		m_bIgnoreCase;
};


// CAlphaScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

///	XNvgG[Ƀ_CAOoǂݒ肷
inline void CAlphaScriptHost::AllowErrorReport(bool bAllow) {
	m_bAllowedErrorReport = bAllow;
}

///	@see	IActiveScriptSiteWindow::EnableModeless
inline STDMETHODIMP CAlphaScriptHost::EnableModeless(BOOL fEnable) {
	return E_NOTIMPL;
}

#ifdef IMPLEMENT_DEBUGGER_HOST
///	@see	IActiveScriptSiteDebug::GetApplication
inline STDMETHODIMP CAlphaScriptHost::GetApplication(IDebugApplication** ppda) {
	VERIFY_POINTER(ppda);
	if(m_pDebugApplication == 0)
		return E_UNEXPECTED;
	m_pDebugApplication->QueryInterface(IID_IDebugApplication, reinterpret_cast<void**>(ppda));
	return S_OK;
}

///	@see	IActiveScriptSiteDebug::GetDocumentContextFromPosition
inline STDMETHODIMP CAlphaScriptHost::GetDocumentContextFromPosition(
		DWORD dwSourceContext, ULONG uCharacterOffset, ULONG uNumChars, IDebugDocumentContext** ppsc) {
	return E_NOTIMPL;
}
#endif /* IMPLEMENT_DEBUGGER_HOST */

///	@see	IActiveScriptSite::GetDocVersionString
inline STDMETHODIMP CAlphaScriptHost::GetDocVersionString(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = 0;
	return E_NOTIMPL;
}

///	@see	IActiveScriptSite::GetLCID
inline STDMETHODIMP CAlphaScriptHost::GetLCID(LCID* plcid) {
	VERIFY_POINTER(plcid);
	*plcid = MAKELCID((::GetUserDefaultLangID() == 0x0411) ? 0x0411 : 0x0409, SORT_DEFAULT);
	return S_OK;
}

#ifdef IMPLEMENT_DEBUGGER_HOST
///	@see	IActiveScriptSiteDebug::GetRootApplicationNode
inline STDMETHODIMP CAlphaScriptHost::GetRootApplicationNode(IDebugApplicationNode** ppdanRoot) {
	VERIFY_POINTER(ppdanRoot);
	*ppdanRoot = 0;
	return E_NOTIMPL;
}
#endif /* IMPLEMENT_DEBUGGER_HOST */

///	XNvgGWԂ
inline void CAlphaScriptHost::GetScriptEngine(IActiveScript*& pScriptEngine) const {
	pScriptEngine = m_pScriptEngine;
	pScriptEngine->AddRef();
}

///	XNvg̃pXԂ
inline wstring CAlphaScriptHost::GetScriptPath() const {
	return m_wszScriptPath;
}

///	@see	IInternetHostSecurityManager::GetSecurityId
inline STDMETHODIMP CAlphaScriptHost::GetSecurityId(
		BYTE* pbSecurityId, DWORD* pcbSecurityId, IIHSMGSI_3RD_PARAM_TYPE dwReserved) {
	pbSecurityId = 0;
	pcbSecurityId = 0;
	if(dwReserved != 0)
		return E_INVALIDARG;
	return E_NOTIMPL;
}

///	^CAEgԂ
inline unsigned long CAlphaScriptHost::GetTimeout() const {
	return m_nTimeout;
}

///	@see	IActiveScriptSiteWindow::GetWindow
inline STDMETHODIMP CAlphaScriptHost::GetWindow(HWND* phwnd) {
	VERIFY_POINTER(phwnd);
	*phwnd = m_hOwnerWindow;
	return S_OK;
}

///	Θb[hԂ
inline bool CAlphaScriptHost::IsInteractive() const {
	return m_bInteractive;
}

///	@see	IActiveScriptSite::OnLeaveScript
inline STDMETHODIMP CAlphaScriptHost::OnLeaveScript() {
	m_bEnteredScript = false;
	ReleaseTopLevelObjects(false);
	return S_OK;
}

#ifdef IMPLEMENT_DEBUGGER_HOST
///	@see	IActiveScriptSiteDebug::OnScriptErrorDebug
template<typename MatchCase, class RefCountPolicy>
inline STDMETHODIMP CAlphaScriptHost<MatchCase, RefCountPolicy>::OnScriptErrorDebug(
		IActiveScriptErrorDebug* pErrorDebug, BOOL* pfEnterDebugger, BOOL* pfCallOnScriptErrorWhenContinuing) {
	::MessageBoxW(0, L"G[!", L"w", 0);
	return S_OK;
}
#endif /* IMPLEMENT_DEBUGGER_HOST */

///	@see	IActiveScriptSite::OnScriptTerminate
inline STDMETHODIMP CAlphaScriptHost::OnScriptTerminate(const VARIANT* pvarResult, const EXCEPINFO* pexcepinfo) {
	return S_OK;
}

///	@see	IActiveScriptSite::OnStateChange
inline STDMETHODIMP CAlphaScriptHost::OnStateChange(SCRIPTSTATE ssScriptState) {
	return S_OK;
}

///	@see	IServiceProvider::QueryService
inline STDMETHODIMP CAlphaScriptHost::QueryService(REFGUID guidService, REFIID riid, void** ppvObject) {
	VERIFY_POINTER(ppvObject);

	if(guidService == SID_SInternetHostSecurityManager)
		return QueryInterface(riid, ppvObject);
	*ppvObject = 0;
	return E_NOINTERFACE /* SVC_E_UNKNOWNSERVICE */;
}

///	Θb[h̐ݒ
inline void CAlphaScriptHost::SetInteractiveMode(bool bInteractive) {
	m_bInteractive = bInteractive;
}

///	sXNvgpX̐ݒ (qgƂĎgp)
inline void CAlphaScriptHost::SetScriptPath(const wchar_t* pwszScriptPath) {
	assert(pwszScriptPath != 0);
	wcscpy(m_wszScriptPath, pwszScriptPath);
}

/**
 *	ActiveX IuWFNg쐬ɑ΂ZLeBx̐ݒ
 *	@param bForSafeObject	Sƃ}[NĂIuWFNgɂĐݒ肷ꍇ
 *							trueB}[NĂȂIuWFNg̏ꍇ false
 *	@param nLevel			ZLeBx
 */
inline void CAlphaScriptHost::SetSecurityLevel(bool bForSafeObject, ScriptSiteSecurityLevel nLevel) {
	if(bForSafeObject)	m_nSecurityLevelForSafeObject = nLevel;
	else				m_nSecurityLevelForUnsafeObject = nLevel;
}

/**
 *	^CAEg̐ݒ
 *	@param nMilliseconds	^CAEg (~b)B0Ɩ
 *	@throw std::logic_error	XNvg̎sɐݒ肵悤ƂƃX[
 */
inline void CAlphaScriptHost::SetTimeout(unsigned long nMilliseconds) throw(std::logic_error) {
	if(m_pScriptEngine != 0) {
		SCRIPTSTATE	ss;
		m_pScriptEngine->GetScriptState(&ss);
		if(ss == SCRIPTSTATE_INITIALIZED || ss == SCRIPTSTATE_STARTED || ss == SCRIPTSTATE_CONNECTED)
			throw std::logic_error("Script is already running.");
	}
	m_nTimeout = nMilliseconds;
}

} // namespace Alpha

#endif /* _ALPHA_SCRIPT_HOST_H_ */

/* [EOF] */