// Ambient.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "Ambient.h"
#include "AmbientIdl_i.c"	// IID, LIBID
#include "AlphaScriptHost.h"
#include "AlphaView.h"
#include "CommandManager.h"
#include "Ascension\EditPoint.h"
#include <limits>
#include "..\Armaiti\OleTypeWrapper.h"
#include <objsafe.h>

#pragma warning(disable : 4390)	// u䂪̕܂B...v

using namespace Alpha;
using namespace Alpha::Ambient;


// IDispatch::Invoke Ɏg}NA֐A
/////////////////////////////////////////////////////////////////////////////

// ̐`FbNAȂ DISP_E_BADPARAMCOUNT ԂƂ
#define VERIFY_ARGUMENTS_COUNT(c)	\
	if(pDispParams->cArgs != (c))	\
		return DISP_E_BADPARAMCOUNT

// ߂ľ^ type ɐݒ肷
// ([Jϐ pVarResult 邱ƂO)
#define COERCE_RETURN(type)	\
	if(pVarResult != 0)		\
		pVarResult->vt = type

// iArg Ԗڂ̌^ type ɕϊBϊłȂ΃G[R[hԂƂ
// ([Jϐ pDispParams AwFlags Ahr ApuArgErr Aargs[] 邱ƂO)
#define COERCE_ARGUMENT_AT(iArg, type)										\
	do {																	\
		if(type == VT_VARIANT) {											\
			if(pDispParams->rgvarg[iArg].vt == (VT_VARIANT | VT_BYREF))		\
				args[iArg] = *pDispParams->rgvarg[iArg].pvarVal;			\
			else															\
				args[iArg] = pDispParams->rgvarg[iArg];						\
			hr = (args[iArg].vt != VT_ERROR) ? S_OK : args[iArg].scode;		\
		} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT) && iArg == 0)	\
			hr = ::DispGetParam(pDispParams,								\
					DISPID_PROPERTYPUT, type,								\
					&args[iArg], puArgErr);									\
		else																\
			hr = ::DispGetParam(pDispParams,								\
					pDispParams->cArgs - iArg - 1, type,					\
					&args[iArg], puArgErr);									\
		if(FAILED(hr))														\
			return hr;														\
	} while(false)

// _Xbhx̃G[ pExcepInfo ɃZbgA
// DISP_E_EXCEPTION ԂB
// (ʎq pException Ahr Lł邱ƂO)
#define RETURN_WITH_EXCEPTION()										\
	do {															\
		IErrorInfo*	pErrorInfo = 0;									\
		assert(SUCCEEDED(::GetErrorInfo(0, &pErrorInfo)));			\
		pExcepInfo->wCode = 0;										\
		pExcepInfo->scode = hr;										\
		pErrorInfo->GetSource(&pExcepInfo->bstrSource);				\
		pErrorInfo->GetDescription(&pExcepInfo->bstrDescription);	\
		pErrorInfo->GetHelpFile(&pExcepInfo->bstrHelpFile);			\
		pErrorInfo->GetHelpContext(&pExcepInfo->dwHelpContext);		\
		pExcepInfo->pvReserved = 0;									\
		pExcepInfo->pfnDeferredFillIn = 0;							\
		::SetErrorInfo(0, pErrorInfo);								\
		pErrorInfo->Release();										\
		return DISP_E_EXCEPTION;									\
	} while(false)

// CTextPoint ̊̃\bhɎgp
#define GENERATE_CHARPOS_FROM_TEXTPOINT()			\
	CComPtr<ITextPoint>	pTextPoint;					\
	long				iLine, iChar;				\
	var = varOther;									\
	if(FAILED(var.pdispVal->QueryInterface(			\
			IID_ITextPoint,							\
			reinterpret_cast<void**>(&pTextPoint))))\
		return DISP_E_TYPEMISMATCH;					\
	pTextPoint->get_Line(&iLine);					\
	pTextPoint->get_Char(&iChar);					\
	CCharPos	pos = CCharPos(iLine, iChar);

namespace {
	// 󔒂ŋ؂ăXgɂ
	template <class T>
	inline void SplitBySpace(const wchar_t* pwsz, T& dest) {
		assert(pwsz != 0);

		const wchar_t*	pwszSpace;
		const wchar_t*	pwszLast = pwsz;
		while(true) {
			pwszSpace = wcschr(pwszLast, L' ');
			if(pwszSpace != 0) {
				dest.push_back(wstring(pwszLast, pwszSpace - pwszLast));
				pwszLast = pwszSpace + 1;
			} else {
				dest.push_back(wstring(pwszLast));
				break;
			}
		}
	}
}


// CDispatchEnumerator class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param parrObjects	ɂȂRNV
 *	@param cObjects		<var>parrObjects</var> ̃TCY
 */
CDispatchEnumerator::CDispatchEnumerator(IDispatch** parrObjects, size_t cObjects) {
	if(cObjects != 0) {
		assert(parrObjects);
		m_listObjects.assign(parrObjects, parrObjects + cObjects);
		for(size_t i = 0; i < cObjects; ++i)
			parrObjects[i]->AddRef();
	}
	Reset();
}

///	fXgN^
CDispatchEnumerator::~CDispatchEnumerator() {
	for(m_it = m_listObjects.begin(); m_it != m_listObjects.end(); ++m_it)
		(*m_it)->Release();
}

///	@see	IEnumVARIANT::Clone
STDMETHODIMP CDispatchEnumerator::Clone(IEnumVARIANT** ppEnum) {
	return E_NOTIMPL;
}

///	@see	IEnumVARIANT::Next
STDMETHODIMP CDispatchEnumerator::Next(ULONG celt, VARIANT* rgVar, ULONG* pCeltFetched) {
	if(celt > 1 && pCeltFetched == 0)
		return E_INVALIDARG;

	ULONG	cFetched = 0;
	while(cFetched < celt && m_it != m_listObjects.end()) {
		rgVar[cFetched].vt = VT_DISPATCH;
		rgVar[cFetched].pdispVal = *m_it;
		rgVar[cFetched].pdispVal->AddRef();
		++cFetched;
		++m_it;
	}
	if(pCeltFetched != 0)
		*pCeltFetched = cFetched;

	return (cFetched == celt) ? S_OK : S_FALSE;
}

///	@see	IEnumVARIANT::Reset
STDMETHODIMP CDispatchEnumerator::Reset() {
	m_it = m_listObjects.begin();
	return S_OK;
}

///	@see	IEnumVARIANT::Skip
STDMETHODIMP CDispatchEnumerator::Skip(ULONG celt) {
	while(celt != 0 && m_it != m_listObjects.end())
		--celt, ++m_it;
	return (celt == 0) ? S_OK : S_FALSE;
}


// CApplication class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CApplication::CApplication(Alpha::CAlphaApp& app,
		const vector<wstring>* pvecArguments /* = 0 */) : m_app(app) {
}

///	fXgN^
CApplication::~CApplication() {
}

///	@see	IApplication::ClearOutput
STDMETHODIMP CApplication::ClearOutput() {
//	m_pApp->m_wndOutput.Clear(OTT_GENERAL, false);
	return S_OK;
}

///	@see	IApplication::get_Active
STDMETHODIMP CApplication::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	*pbActive = m_app.GetMainWindow()->m_hWnd == CWindow::GetActiveWindow()->m_hWnd;
	return S_OK;
}

///	@see	IApplication::get_ActiveDocument
STDMETHODIMP CApplication::get_ActiveDocument(IDocument** ppActiveDocument) {
	VERIFY_POINTER(ppActiveDocument);

	if(CAlphaEditController* pEditor = m_app.GetActiveTab()->GetTextEditor()) {
		*ppActiveDocument = new CTextDocument(m_app, *pEditor->GetDocument());
		if(*ppActiveDocument == 0)
			return E_OUTOFMEMORY;
		(*ppActiveDocument)->AddRef();
		return S_OK;
	} else {
		*ppActiveDocument = 0;
		return E_UNEXPECTED;
	}
}

///	@see	IApplication::get_Configurations
STDMETHODIMP CApplication::get_Configurations(IConfigurations** ppConfigurations) {
	VERIFY_POINTER(ppConfigurations);

	*ppConfigurations = new CConfigurations(m_app);
	if(*ppConfigurations == 0)
		return E_OUTOFMEMORY;
	(*ppConfigurations)->AddRef();
	return S_OK;
}

///	@see	IApplication::get_CurrentDirectory
STDMETHODIMP CApplication::get_CurrentDirectory(BSTR* pbstrDirectory) {
	VERIFY_POINTER(pbstrDirectory);
	OLECHAR	wszPath[MAX_PATH];
	::GetCurrentDirectoryW(MAX_PATH, wszPath);
	*pbstrDirectory = ::SysAllocString(wszPath);
	return S_OK;
}
/*
///	@see	IApplication::get_Debugger
STDMETHODIMP CApplication::get_Debugger(IDebugger** ppDebugger) {
	VERIFY_POINTER(ppDebugger);
	*ppDebugger = 0;
	return E_NOTIMPL;
}*/

///	@see	IApplication::get_Documents
STDMETHODIMP CApplication::get_Documents(IDocuments** ppDocuments) {
	VERIFY_POINTER(ppDocuments);

	CDocuments*	pDocuments;
	m_app.GetAutomation(0, &pDocuments);
	*ppDocuments = pDocuments;
	return S_OK;
}

///	@see	IApplication::get_FullName
STDMETHODIMP CApplication::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszFileName[MAX_PATH];

	::GetModuleFileName(0, wszFileName, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszFileName);
	return S_OK;
}

///	@see	IApplication::get_Height
STDMETHODIMP CApplication::get_Height(long* pnHeight) {
	VERIFY_POINTER(pnHeight);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	*pnHeight = rect.bottom - rect.top;
	return S_OK;
}

///	@see	IApplication::get_Left
STDMETHODIMP CApplication::get_Left(long* pnLeft) {
	VERIFY_POINTER(pnLeft);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	*pnLeft = rect.left;
	return S_OK;
}

///	@see	IApplication::get_Name
STDMETHODIMP CApplication::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(IDS_APPNAME OLESTR(" ") IDS_APPVERSION OLESTR(" ") IDS_APPVERSIONINFO);
	return S_OK;
}

///	@see	IApplication::get_Top
STDMETHODIMP CApplication::get_Top(long* pnTop) {
	VERIFY_POINTER(pnTop);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	*pnTop = rect.top;
	return S_OK;
}

///	@see	IApplication::get_Version
STDMETHODIMP CApplication::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);
	*pbstrVersion = ::SysAllocString(IDS_APPVERSION);
	return S_OK;
}

///	@see	IApplication::get_Visible
STDMETHODIMP CApplication::get_Visible(VARIANT_BOOL* pbVisible) {
	VERIFY_POINTER(pbVisible);
	*pbVisible = m_app.GetMainWindow()->IsWindowVisible();
	return S_OK;
}

///	@see	IApplication::get_Width
STDMETHODIMP CApplication::get_Width(long* pnWidth) {
	VERIFY_POINTER(pnWidth);

	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	*pnWidth = rect.right - rect.left;
	return S_OK;
}

///	@see	IApplication::get_WindowState
STDMETHODIMP CApplication::get_WindowState(AmbientWindowState* pWindowState) {
	VERIFY_POINTER(pWindowState);

	if(m_app.GetMainWindow()->IsIconic())		*pWindowState = AWS_MINIMIZED;
	else if(m_app.GetMainWindow()->IsZoomed())	*pWindowState = AWS_MAXIMIZED;
	else										*pWindowState = AWS_NORMAL;
	return S_OK;
}

///	@see	IApplication::GetCommandById
STDMETHODIMP CApplication::GetCommandById(long nCommandId, ICommand** ppCommand) {
	if(ppCommand != 0) {
		*ppCommand = new CAutomationCommand(m_app, static_cast<CommandId>(nCommandId));
		if(*ppCommand == 0)
			return E_OUTOFMEMORY;
		(*ppCommand)->AddRef();
	}
	return S_OK;
}

///	O[oȗ񋓂ԂB|C^͌Ăяo Release 
void CApplication::GetEnumerations(set<pair<wstring, CEnumImpl*> >& enums) {
#define PROP(name, value)	p->AddProperty(OLESTR(name), (value))

	CEnumImpl*	p = new CEnumImpl(true);
	p->AddRef();
	PROP("MAXIMIZED",	0x00);
	PROP("MINIMIZED",	0x01);
	PROP("NORMAL",		0x02);
	enums.insert(make_pair(OLESTR("WindowsState"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("DENY_NONE",	0x00);
	PROP("DENY_WRITE",	0x01);
	PROP("DENY_READ",	0x02);
	enums.insert(make_pair(OLESTR("FileShareMode"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("AUTO",	0x00);
	PROP("LF",		0x01);
	PROP("CR",		0x02);
	PROP("CRLF",	0x03);
	PROP("NEL",		0x04);
	PROP("LS",		0x05);
	PROP("PS",		0x06);
	enums.insert(make_pair(OLESTR("BreakType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("UPPERCASE_ASCII",			0x00);
	PROP("UPPERCASE_SIMPLE",		0x01);
	PROP("UPPERCASE_FULL",			0x02);
	PROP("LOWERCASE_ASCII",			0x03);
	PROP("LOWERCASE_SIMPLE",		0x04);
	PROP("LOWERCASE_FULL",			0x05);
	PROP("CAPITALIZE_ASCII",		0x06);
	PROP("CAPITALIZE_SIMPLE",		0x07);
	PROP("CAPITALIZE_FULL",			0x08);
	PROP("HIRAGANA",				0x09);
	PROP("KATAKANA",				0x0A);
	PROP("SIMPLIFIED_CHINESE",		0x0B);
	PROP("TRADITIONAL_CHINESE",		0x0C);
	PROP("FULLWIDTH",				0x0D);
	PROP("HALFWIDTH",				0x0F);
	PROP("ARABICDIGIT",				0x10);
	PROP("REMOVE_NONSPACE",			0x11);
	PROP("REMOVE_ARABIC_KASHIDA",	0x12);
	PROP("COMPOSE",					0x13);
	PROP("DECOMPOSE",				0x14);
	enums.insert(make_pair(OLESTR("ConvertType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("UTF16",	0x00);
	PROP("UTF32",	0x01);
	PROP("CLUSTER",	0x02);
	PROP("DEFAULT",	0x03);
	enums.insert(make_pair(OLESTR("CharCountBehavior"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("MATCH_CASE",				0x00);
	PROP("IGNORE_ASCII_ALPHABETS",	0x01);
	PROP("UNICODE_SIMPLE",			0x02);
	PROP("UNICODE_FULL",			0x03);
	enums.insert(make_pair(OLESTR("CaseFoldingType"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("DEFAULT",			0x00);
	PROP("CPP",				0x01);
	PROP("PERL",			0x02);
	PROP("RUBY",			0x03);
	PROP("VBSCRIPT",		0x04);
	PROP("JAVASCRIPT_1_5",	0x05);
	PROP("JAVASCRIPT_2_0",	0x06);
	enums.insert(make_pair(OLESTR("NumberFormat"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",				0x00);
	PROP("ONLY_START_OF_LINE",	0x01);
	PROP("ONLY_HEAD_OF_LINE",	0x02);
	enums.insert(make_pair(OLESTR("AnnotationRestriction"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",	0x00);
	PROP("SOLID",	0x01);
	PROP("DASHED",	0x02);
	PROP("DOTTED",	0x03);
	enums.insert(make_pair(OLESTR("LineNumberBorderStyle"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NOWRAP",				0x00);
	PROP("BY_SPECIFIED_WIDTH",	0x01);
	PROP("BY_WINDOW_WIDTH",		0x02);
	enums.insert(make_pair(OLESTR("WrapMode"), p));

	p = new CEnumImpl(true);
	p->AddRef();
	PROP("NONE",					0x00);
	PROP("UNDERLINE_SOLID",			0x01);
	PROP("UNDERLINE_BOLD",			0x02);
	PROP("UNDERLINE_DASHED",		0x03);
	PROP("UNDERLINE_BOLD_DASHED",	0x04);
	PROP("UNDERLINE_DOTTED",		0x05);
	PROP("UNDERLINE_BOLD_DOTTED",	0x06);
	PROP("UNDERLINE_WAVED",			0x07);
	PROP("BORDER_SOLID",			0x08);
	PROP("BORDER_DASHED",			0x09);
	PROP("BORDER_DOTTED",			0x0A);
	enums.insert(make_pair(OLESTR("BorderType"), p));
#undef PROP
}

///	@see	IDispatch::Invoke
STDMETHODIMP CApplication::Invoke(DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*	pArray = 0;
	BSTR*		arrBstrArgs = 0;
	CComVariant	args[2];
	IDocuments*	pDocuments = 0;

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Active(&pVarResult->boolVal);
		case DISPID_APPLICATION_ACTIVEDOCUMENT:
			pVarResult->vt = VT_DISPATCH;
			return get_ActiveDocument(reinterpret_cast<IDocument**>(&pVarResult->pdispVal));
		case DISPID_APPLICATION_CONFIGURATIONS:
			pVarResult->vt = VT_DISPATCH;
			return get_Configurations(reinterpret_cast<IConfigurations**>(&pVarResult->pdispVal));
		case DISPID_APPLICATION_CURRENTDIRECTORY:
			pVarResult->vt = VT_BSTR;
			return get_CurrentDirectory(&pVarResult->bstrVal);
		case DISPID_APPLICATION_DOCUMENTS:
			pVarResult->vt = VT_DISPATCH;
			hr = get_Documents(&pDocuments);
			if(SUCCEEDED(hr) && pDispParams->cArgs != 0)	// "Ambient.Documents(i)" ̂悤ȏꍇ
				return pDocuments->Invoke(DISPID_VALUE, IID_NULL,
					LOCALE_USER_DEFAULT, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
			else {
				pVarResult->pdispVal = pDocuments;
				return hr;
			}
		case DISPID_APPLICATION_FULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_FullName(&pVarResult->bstrVal);
		case DISPID_APPLICATION_HEIGHT:
			pVarResult->vt = VT_I4;
			return get_Height(&pVarResult->lVal);
		case DISPID_APPLICATION_LEFT:
			pVarResult->vt = VT_I4;
			return get_Left(&pVarResult->lVal);
		case DISPID_APPLICATION_NAME:
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		case DISPID_APPLICATION_TOP:
			pVarResult->vt = VT_I4;
			return get_Top(&pVarResult->lVal);
		case DISPID_APPLICATION_VERSION:
			pVarResult->vt = VT_BSTR;
			return get_Version(&pVarResult->bstrVal);
		case DISPID_APPLICATION_VISIBLE:
			pVarResult->vt = VT_BOOL;
			return get_Visible(&pVarResult->boolVal);
		case DISPID_APPLICATION_WIDTH:
			pVarResult->vt = VT_I4;
			return get_Width(&pVarResult->lVal);
		case DISPID_APPLICATION_WINDOWSTATE:
			pVarResult->vt = VT_I2;
			return get_WindowState(reinterpret_cast<AmbientWindowState*>(&pVarResult->iVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_APPLICATION_ACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Active(args[0].boolVal);
		case DISPID_APPLICATION_CURRENTDIRECTORY:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_CurrentDirectory(args[0].bstrVal);
		case DISPID_APPLICATION_HEIGHT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Height(args[0].lVal);
		case DISPID_APPLICATION_LEFT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Left(args[0].lVal);
		case DISPID_APPLICATION_TOP:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Top(args[0].lVal);
		case DISPID_APPLICATION_VISIBLE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Visible(args[0].boolVal);
		case DISPID_APPLICATION_WIDTH:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Width(args[0].lVal);
		case DISPID_APPLICATION_WINDOWSTATE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_WindowState(static_cast<AmbientWindowState>(args[0].iVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF) {	// Zb^
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_APPLICATION_CLEAROUTPUT:
			VERIFY_ARGUMENTS_COUNT(0);
			return ClearOutput();
		case DISPID_APPLICATION_GETCOMMANDBYID:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			return GetCommandById(args[0].lVal,
				(pVarResult != 0) ? reinterpret_cast<ICommand**>(&pVarResult->pdispVal) : 0);
		case DISPID_APPLICATION_QUIT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Quit(args[0].iVal);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_APPLICATION_WRITETOOUTPUT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return WriteToOutput(args[1].bstrVal, args[0].boolVal);
		case DISPID_APPLICATION_WRITELINETOOUTPUT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return WriteLineToOutput(args[1].bstrVal, args[0].boolVal);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

void CApplication::_CallHook(DISPID idHook, const DISPPARAMS* pArguments) {
/*	if(m_pHook == 0)
		return;

	CComPtr<IDispatchEx>	px;
	DISPPARAMS				params = {0, 0, 0, 0};
	EXCEPINFO				exception;
	HRESULT					hr;

	if(S_OK == m_pHook->QueryInterface(IID_IDispatchEx, reinterpret_cast<void**>(&px))) {
		VARIANTARG	arg;
		DISPID		id = DISPID_THIS;

		params.cArgs = params.cNamedArgs = 1;
		arg.vt = VT_DISPATCH;
		hr = QueryInterface(IID_IDispatch, reinterpret_cast<void**>(&arg.pdispVal));
		params.rgdispidNamedArgs = &id;
		hr = px->InvokeEx(DISPID_VALUE, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, 0);
	} else {
		unsigned int	iArgErr;
		hr = m_pHook->Invoke(DISPID_VALUE, IID_NULL,
			LOCALE_USER_DEFAULT, DISPATCH_METHOD, &params, 0, &exception, &iArgErr);
	}*/
}

///	@see	IApplication::put_Active
STDMETHODIMP CApplication::put_Active(VARIANT_BOOL bActive) {
	if(bActive)
		m_app.GetMainWindow()->SetActiveWindow();
	else
		::SetActiveWindow(::GetDesktopWindow());
	return S_OK;
}

///	@see	IApplication::put_CurrentDirectory
STDMETHODIMP CApplication::put_CurrentDirectory(BSTR bstrDirectory) {
	::SetCurrentDirectoryW((bstrDirectory != 0) ? bstrDirectory : L"");
	return S_OK;
}

///	@see	IApplication::put_Height
STDMETHODIMP CApplication::put_Height(long nHeight) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	m_app.GetMainWindow()->SetWindowPos(0, 0, 0,
		rect.right - rect.left, nHeight, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Left
STDMETHODIMP CApplication::put_Left(long nLeft) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	m_app.GetMainWindow()->SetWindowPos(0, nLeft, rect.top,
		0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Top
STDMETHODIMP CApplication::put_Top(long nTop) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	m_app.GetMainWindow()->SetWindowPos(0, rect.left, nTop,
		0, 0, SWP_NOSIZE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_Visible
STDMETHODIMP CApplication::put_Visible(VARIANT_BOOL bVisible) {
	m_app.GetMainWindow()->ShowWindow(bVisible ? SW_SHOW : SW_HIDE);
	return S_OK;
}

///	@see	IApplication::put_Width
STDMETHODIMP CApplication::put_Width(long nWidth) {
	RECT	rect;
	m_app.GetMainWindow()->GetWindowRect(&rect);
	m_app.GetMainWindow()->SetWindowPos(0, 0, 0,
		nWidth, rect.bottom - rect.top, SWP_NOMOVE | SWP_NOZORDER);
	return S_OK;
}

///	@see	IApplication::put_WindowState
STDMETHODIMP CApplication::put_WindowState(AmbientWindowState windowState) {
	switch(windowState) {
	case AWS_MINIMIZED:
		m_app.GetMainWindow()->ShowWindow(SW_MINIMIZE);
		break;
	case AWS_MAXIMIZED:
		m_app.GetMainWindow()->ShowWindow(SW_MAXIMIZE);
		break;
	case AWS_NORMAL:
		m_app.GetMainWindow()->ShowWindow(SW_RESTORE);
		break;
	default:
		return E_INVALIDARG;
		break;
	}
	return S_OK;
}

///	@see	IApplication::Quit
STDMETHODIMP CApplication::Quit(short nErrorCode) {
	m_app.GetMainWindow()->SendMessage(WM_CLOSE);
	return S_OK;
}

///	@see	IApplication::WriteToOutput
STDMETHODIMP CApplication::WriteToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.Write(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}

///	@see	IApplication::WriteLineToOutput
STDMETHODIMP CApplication::WriteLineToOutput(BSTR bstrOutput, VARIANT_BOOL bActivate) {
//	m_app.m_wndOutput.WriteLine(OTT_GENERAL, bstrOutput, toBoolean(bActivate));
	return S_OK;
}


// CDocuments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDocuments::CDocuments(Alpha::CAlphaApp& app) : m_app(app) {
}

///	@see	IDocuments::AddNew
STDMETHODIMP CDocuments::AddNew() {
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_NEW);
	return S_OK;
}

///	@see	IDocuments::CloseAll
STDMETHODIMP CDocuments::CloseAll() {
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_CLOSEALL);
	return S_OK;
}

///	@see	IDocuments::get__NewEnum
STDMETHODIMP CDocuments::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);

	size_t		cDocuments = m_app.GetTabCount();
	IDispatch**	arrDocuments = new IDispatch*[cDocuments];

	try {
		for(size_t i = 0; i < cDocuments; ++i) {
			if(CAlphaEditController* pEditor = m_app.GetTab(i)->GetTextEditor()) {
				IDocument*	pDocument = 0;
				pEditor->GetDocument()->GetAutomation(m_app, &pDocument);
				arrDocuments[i] = pDocument;
			} else
				arrDocuments[i] = 0;
		}
	} catch(out_of_range& /* e */) {
		delete[] arrDocuments;
		*ppEnum = 0;
		return E_FAIL;
	}
	*ppEnum = new CDispatchEnumerator(arrDocuments, cDocuments);
	(*ppEnum)->AddRef();
	delete[] arrDocuments;

	return S_OK;
}

///	@see	IDocuments::get_Count
STDMETHODIMP CDocuments::get_Count(long* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_app.GetTabCount();
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CDocuments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_NEWENUM:
			pVarResult->vt = VT_UNKNOWN;
			return get__NewEnum(&pVarResult->punkVal);
		case DISPID_DOCUMENTS_COUNT:
			pVarResult->vt = VT_I4;
			return get_Count(&pVarResult->lVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENTS_ADDNEW:
			VERIFY_ARGUMENTS_COUNT(0);
			return AddNew();
		case DISPID_DOCUMENTS_CLOSEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return CloseAll();
		case DISPID_DOCUMENTS_ITEM:
//		case 0:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			COERCE_RETURN(VT_DISPATCH);
			hr = Item(args[0].lVal, (pVarResult != 0) ?
					reinterpret_cast<IDocument**>(&pVarResult->pdispVal) : 0);
			return hr;
		case DISPID_DOCUMENTS_OPEN:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Open(args[1].bstrVal, static_cast<AmbientFileShareMode>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return Open(args[2].bstrVal,
					static_cast<AmbientFileShareMode>(args[1].iVal), args[0].lVal);
			} else if(pDispParams->cArgs == 4) {
				COERCE_ARGUMENT_AT(3, VT_BSTR);
				COERCE_ARGUMENT_AT(2, VT_I2);
				COERCE_ARGUMENT_AT(1, VT_I4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Open(args[3].bstrVal,
					static_cast<AmbientFileShareMode>(args[2].iVal), args[1].lVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENTS_SAVEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return SaveAll();
		}
	}

	return hr;
}

///	@see	IDocuments::Item
STDMETHODIMP CDocuments::Item(long iDocument, IDocument** ppDocument) {
	VERIFY_POINTER(ppDocument);
	try {
		if(CAlphaEditController* pEditor = m_app.GetTab(iDocument)->GetTextEditor())
			pEditor->GetDocument()->GetAutomation(m_app, ppDocument);
		else {
			*ppDocument = 0;
			return E_UNEXPECTED;
		}
	} catch(out_of_range& /* e */) {
		*ppDocument = 0;
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocuments::Open
STDMETHODIMP CDocuments::Open(BSTR bstrPathName,
		AmbientFileShareMode nShareMode, long nCodePage /* = 0 */, VARIANT_BOOL bAddToMRU /* = true */) {
	if(bstrPathName == 0)
		return E_INVALIDARG;
	CComCriticalSection<>	cs;
	cs.Lock();
	m_app.OpenFile(bstrPathName, (nCodePage != 0) ? nCodePage : ::GetACP(), L"", toBoolean(bAddToMRU));
	cs.Unlock();
	return S_OK;
}

///	@see	IDocuments::SaveAll
STDMETHODIMP CDocuments::SaveAll() {
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, CMD_FILE_SAVEALL);
	return S_OK;
}


// CTextDocument class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextDocument::CTextDocument(
		CAlphaApp& app, CAlphaDoc& document) : m_app(app), m_document(document) {
}

///	@see	IDocument::ClearUndoBuffer
STDMETHODIMP CTextDocument::ClearUndoBuffer() {
	m_document.ClearUndoBuffer();
	return S_OK;
}

///	@see	IDocument::Close
STDMETHODIMP CTextDocument::Close(VARIANT_BOOL bConfirm /* = VARIANT_TRUE */) {
	m_app.SetActiveTab(FindDocument());
	m_app.GetMainWindow()->SendMessage(WM_COMMAND, MAKEWPARAM(CMD_FILE_CLOSE, !bConfirm));
	return S_OK;
}

/**
 *	AvP[VIuWFNg (CAlphaApp) 玩̃^uԍT
 *	@return	^uԍ
 */
unsigned int CTextDocument::FindDocument() const {
	for(unsigned int iTab = 0; iTab < m_app.GetTabCount(); ++iTab) {
		if(m_app.GetTab(iTab)->GetTextEditor() == m_document.GetController())
			return iTab;
	}
	assert(false);	//tȂ͖͂
	return -1;
}

///	@see	IDocument::get_Active
STDMETHODIMP CTextDocument::get_Active(VARIANT_BOOL* pbActive) {
	VERIFY_POINTER(pbActive);
	if(CAlphaEditController* pEditor = m_app.GetActiveTab()->GetTextEditor())
		*pbActive = toVariantBoolean(pEditor->GetDocument() == &m_document);
	else
		*pbActive = VARIANT_FALSE;
	return S_OK;
}

///	@see	IDocument::get_BreakType
STDMETHODIMP CTextDocument::get_BreakType(AmbientBreakType* pBreakType) {
	VERIFY_POINTER(pBreakType);
	*pBreakType = static_cast<AmbientBreakType>(m_document.GetBreakType());
	return S_OK;
}

///	@see	IDocument::get_CodePage
STDMETHODIMP CTextDocument::get_CodePage(long* pnCodePage) {
	VERIFY_POINTER(pnCodePage);
	*pnCodePage = m_document.GetCodePage();
	return S_OK;
}

///	@see	ITextDocument::get_EndPoint
STDMETHODIMP CTextDocument::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);

	CEditPoint*	pEndPoint = m_document.GetController()->GetActiveView()->CreateEditPoint();

	pEndPoint->MoveToEndOfDocument();
	*ppEndPoint = new CTextPoint(*pEndPoint, false);
	(*ppEndPoint)->AddRef();
	return S_OK;
}

///	@see	IDocument::get_FileName
STDMETHODIMP CTextDocument::get_FileName(BSTR* pbstrFileName) {
	VERIFY_POINTER(pbstrFileName);
	*pbstrFileName = ::SysAllocString(m_document.GetTitle().c_str());
	return S_OK;
}

///	@see	IDocument::get_FilePath
STDMETHODIMP CTextDocument::get_FilePath(BSTR* pbstrFilePath) {
	VERIFY_POINTER(pbstrFilePath);
	*pbstrFilePath = ::SysAllocString(m_document.GetPathName().c_str());
	return S_OK;
}

///	@see	IDocument::get_Modified
STDMETHODIMP CTextDocument::get_Modified(VARIANT_BOOL* pbModified) {
	VERIFY_POINTER(pbModified);
	*pbModified = m_document.IsModified();
	return S_OK;
}

///	@see	IDocument::get_ReadOnly
STDMETHODIMP CTextDocument::get_ReadOnly(VARIANT_BOOL* pbReadOnly) {
	VERIFY_POINTER(pbReadOnly);
	*pbReadOnly = m_document.IsReadOnly();
	return S_OK;
}

///	@see	ITextDocument::get_StartPoint
STDMETHODIMP CTextDocument::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
	*ppStartPoint = new CTextPoint(
		*m_document.GetController()->GetActiveView()->CreateEditPoint(), false);
	(*ppStartPoint)->AddRef();
	return S_OK;
}

///	@see	ITextDocument::get_TextProcessor
STDMETHODIMP CTextDocument::get_TextProcessor(ITextProcessor** ppTextProcessor) {
	VERIFY_POINTER(ppTextProcessor);
	*ppTextProcessor = new CTextProcessor(*m_document.GetController());
	(*ppTextProcessor)->AddRef();
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextDocument::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Active(&pVarResult->boolVal);
		case DISPID_DOCUMENT_BREAKTYPE:
			pVarResult->vt = VT_I2;
			return get_BreakType(reinterpret_cast<AmbientBreakType*>(&pVarResult->iVal));
		case DISPID_DOCUMENT_CODEPAGE:
			pVarResult->vt = VT_I4;
			return get_CodePage(&pVarResult->lVal);
		case DISPID_TEXTDOCUMENT_ENDPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_EndPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_DOCUMENT_FILENAME:
			pVarResult->vt = VT_BSTR;
			return get_FileName(&pVarResult->bstrVal);
		case DISPID_DOCUMENT_FILEPATH:
			pVarResult->vt = VT_BSTR;
			return get_FilePath(&pVarResult->bstrVal);
		case DISPID_DOCUMENT_MODIFIED:
			pVarResult->vt = VT_BOOL;
			return get_Modified(&pVarResult->boolVal);
		case DISPID_DOCUMENT_READONLY:
			pVarResult->vt = VT_BOOL;
			return get_ReadOnly(&pVarResult->boolVal);
		case DISPID_TEXTDOCUMENT_STARTPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_StartPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTDOCUMENT_TEXTPROCESSOR:
			pVarResult->vt = VT_DISPATCH;
			return get_TextProcessor(reinterpret_cast<ITextProcessor**>(&pVarResult->pdispVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_DOCUMENT_ACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Active(args[0].boolVal);
		case DISPID_DOCUMENT_BREAKTYPE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_BreakType(static_cast<AmbientBreakType>(args[0].iVal));
		case DISPID_DOCUMENT_CODEPAGE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_CodePage(args[0].lVal);
		case DISPID_DOCUMENT_MODIFIED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Modified(args[0].boolVal);
		case DISPID_DOCUMENT_READONLY:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ReadOnly(args[0].boolVal);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_DOCUMENT_CLEARUNDOBUFFER:
			VERIFY_ARGUMENTS_COUNT(0);
			return ClearUndoBuffer();
		case DISPID_DOCUMENT_CLOSE:
			if(pDispParams->cArgs == 0)
				return Close();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Close(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_REDO:
			VERIFY_ARGUMENTS_COUNT(0);
			return Redo();
		case DISPID_DOCUMENT_SAVE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Save(args[0].bstrVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Save(args[1].bstrVal, static_cast<AmbientBreakType>(args[0].iVal));
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_I2);
				COERCE_ARGUMENT_AT(0, VT_UI2);
				return Save(args[2].bstrVal,
					static_cast<AmbientBreakType>(args[1].iVal), args[0].uiVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_DOCUMENT_UNDO:
			VERIFY_ARGUMENTS_COUNT(0);
			return Undo();
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IDocument::put_Active
STDMETHODIMP CTextDocument::put_Active(VARIANT_BOOL bActive) {
	m_app.SetActiveTab(FindDocument());
	return S_OK;
}

///	@see	IDocument::put_BreakType
STDMETHODIMP CTextDocument::put_BreakType(AmbientBreakType breakType) {
	try {
		m_document.SetBreakType(static_cast<BreakType>(breakType));
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocument::put_CodePage
STDMETHODIMP CTextDocument::put_CodePage(long nCodePage) {
	try {
		m_document.SetCodePage(nCodePage);
	} catch(invalid_argument& /* e */) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IDocument::put_Modified
STDMETHODIMP CTextDocument::put_Modified(VARIANT_BOOL bModified) {
	m_document.SetModified(toBoolean(bModified));
	return S_OK;
}

///	@see	IDocument::put_ReadOnly
STDMETHODIMP CTextDocument::put_ReadOnly(VARIANT_BOOL bReadOnly) {
	m_document.SetReadOnly(toBoolean(bReadOnly));
	return S_OK;
}

///	@see	IDocument::Redo
STDMETHODIMP CTextDocument::Redo() {
	m_document.Redo();
	return S_OK;
}

///	@see	IDocument::Save
STDMETHODIMP CTextDocument::Save(
		BSTR bstrFileName, AmbientBreakType breakType /* = ABT_AUTO */, long nCodePage /* = 0 */) {
	if(bstrFileName == 0)
		return E_INVALIDARG;
	if(SS_OK == m_document.SaveDocument(bstrFileName,
						SDO_IGNORE_NOFITCHARS,
						static_cast<BreakType>(breakType), nCodePage))
		return S_OK;
	return S_FALSE;
}

///	@see	IDocument::Undo
STDMETHODIMP CTextDocument::Undo() {
	m_document.Undo();
	return S_OK;
}


// CTextProcessor class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextProcessor::CTextProcessor(CAlphaEditController& editor) : m_editor(editor) {
}

///	@see	ITextProcessor::BackSpace
STDMETHODIMP CTextProcessor::BackSpace() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_BACKSPACE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::BeginEditCollection
STDMETHODIMP CTextProcessor::BeginEditCollection() {
	m_editor.GetDocument()->BeginEditCollection();
	return S_OK;
}

///	@see	ITextProcessor::CreateEditPoint
STDMETHODIMP CTextProcessor::CreateEditPoint(ITextPoint* pTextPoint, IEditPoint** ppEditPoint) {
	if(ppEditPoint != 0) {
		if(pTextPoint == 0)
			return E_INVALIDARG;

		long	iLine, iChar;

		*ppEditPoint = new CTextPoint(*m_editor.GetActiveView()->CreateEditPoint(), true);
		(*ppEditPoint)->AddRef();
		pTextPoint->get_Line(&iLine);
		pTextPoint->get_Char(&iChar);
		(*ppEditPoint)->MoveTo(iLine, iChar);
	}
	return S_OK;
}

///	@see	ITextProcessor::Delete
STDMETHODIMP CTextProcessor::Delete() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_DELETE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::EndEditCollection
STDMETHODIMP CTextProcessor::EndEditCollection() {
	m_editor.GetDocument()->EndEditCollection();
	return S_OK;
}

///	@see	ITextProcessor::FindText
STDMETHODIMP CTextProcessor::FindText(
		BSTR bstrFindWhat, AmbientFindTextFlags ftf, VARIANT_BOOL* pbFound) {
	if(bstrFindWhat == 0)
		return E_INVALIDARG;

	CAlphaView&	view = *m_editor.GetActiveView();

	view.SetSearchFlags(ftf);
	view.SetSearchText(bstrFindWhat);
	bool	bFound = view.FindNext();
	if(pbFound != 0)
		*pbFound = toVariantBoolean(bFound);
	return S_OK;
}

///	@see	ITextProcessor::get_ClipboardRing
STDMETHODIMP CTextProcessor::get_ClipboardRing(IClipboardRing** ppClipboardRing) {
	VERIFY_POINTER(ppClipboardRing);
	*ppClipboardRing = new CAutomationClipboardRing(CEditView::GetClipboardRing());
	if(*ppClipboardRing == 0)
		return E_OUTOFMEMORY;
	(*ppClipboardRing)->AddRef();
	return S_OK;
}

///	@see	ITextProcessor::get_Lexer
STDMETHODIMP CTextProcessor::get_Lexer(ILexer** ppLexer) {
	VERIFY_POINTER(ppLexer);
	*ppLexer = new CAutomationLexer(*m_editor.GetActiveView()->GetLexer());
	if(*ppLexer == 0)
		return E_OUTOFMEMORY;
	(*ppLexer)->AddRef();
	return S_OK;
}

///	@see	ITextProcessor::get_OvertypeMode
STDMETHODIMP CTextProcessor::get_OvertypeMode(VARIANT_BOOL* pbOvertypeMode) {
	VERIFY_POINTER(pbOvertypeMode);
	*pbOvertypeMode = toVariantBoolean(m_editor.GetActiveView()->IsOvertypeMode());
	return S_OK;
}

///	@see	ITextProcessor::get_Preferences
STDMETHODIMP CTextProcessor::get_Preferences(IEditorPreferences** ppPreferences) {
	VERIFY_POINTER(ppPreferences);

	*ppPreferences = new CEditorPreferences(*m_editor.GetActiveView());
	if(*ppPreferences == 0)
		return E_OUTOFMEMORY;
	(*ppPreferences)->AddRef();
	return S_OK;
}

///	@see	ITextProcessor::get_Selection
STDMETHODIMP CTextProcessor::get_Selection(ITextSelection** ppSelection) {
	VERIFY_POINTER(ppSelection);
	return m_editor.GetAutomation(IID_ITextSelection, reinterpret_cast<IDispatch**>(ppSelection));
}

///	@see	ITextProcessor::get_TextSearcher
STDMETHODIMP CTextProcessor::get_TextSearcher(ITextSearcher** ppTextSearcher) {
	VERIFY_POINTER(ppTextSearcher);
	*ppTextSearcher = new CAutomationTextSearcher(m_editor);
	if(*ppTextSearcher == 0)
		return E_OUTOFMEMORY;
	(*ppTextSearcher)->AddRef();
	return S_OK;
}

///	@see	ITextProcessor::Indent
STDMETHODIMP CTextProcessor::Indent() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABINDENT, false);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextProcessor::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_CLIPBOARDRING:
			pVarResult->vt = VT_DISPATCH;
			return get_ClipboardRing(reinterpret_cast<IClipboardRing**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_LEXER:
			pVarResult->vt = VT_DISPATCH;
			return get_Lexer(reinterpret_cast<ILexer**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_OVERTYPEMODE:
			pVarResult->vt = VT_BOOL;
			return get_OvertypeMode(&pVarResult->boolVal);
		case DISPID_TEXTPROCESSOR_PREFERENCES:
			pVarResult->vt = VT_DISPATCH;
			return get_Preferences(reinterpret_cast<IEditorPreferences**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_SELECTION:
			pVarResult->vt = VT_DISPATCH;
			return get_Selection(reinterpret_cast<ITextSelection**>(&pVarResult->pdispVal));
		case DISPID_TEXTPROCESSOR_TEXTSEARCHER:
			pVarResult->vt = VT_DISPATCH;
			return get_TextSearcher(reinterpret_cast<ITextSearcher**>(&pVarResult->pdispVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_OVERTYPEMODE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_OvertypeMode(args[0].boolVal);
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPROCESSOR_BACKSPACE:
			VERIFY_ARGUMENTS_COUNT(0);
			return BackSpace();
		case DISPID_TEXTPROCESSOR_BEGINEDITCOLLECTION:
			VERIFY_ARGUMENTS_COUNT(0);
			return BeginEditCollection();
		case DISPID_TEXTPROCESSOR_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint(
				reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPROCESSOR_DELETE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Delete();
		case DISPID_TEXTPROCESSOR_ENDEDITCOLLECTION:
			VERIFY_ARGUMENTS_COUNT(0);
			return EndEditCollection();
		case DISPID_TEXTPROCESSOR_FINDTEXT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_I2);
			COERCE_RETURN(VT_BOOL);
			return FindText(args[1].bstrVal,
				static_cast<AmbientFindTextFlags>(args[0].iVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPROCESSOR_INDENT:
			VERIFY_ARGUMENTS_COUNT(0);
			return Indent();
		case DISPID_TEXTPROCESSOR_NEWLINE:
			VERIFY_ARGUMENTS_COUNT(0);
			return NewLine();
		case DISPID_TEXTPROCESSOR_PASTE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Paste();
		case DISPID_TEXTPROCESSOR_PASTEFROMCLIPBOARDRING:
			VERIFY_ARGUMENTS_COUNT(0);
			return PasteFromClipboardRing();
		case DISPID_TEXTPROCESSOR_UNINDENT:
			VERIFY_ARGUMENTS_COUNT(0);
			return Unindent();
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	ITextProcessor::NewLine
STDMETHODIMP CTextProcessor::NewLine() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_BREAK, 0L);
	return S_OK;
}

///	@see	ITextProcessor::Paste
STDMETHODIMP CTextProcessor::Paste() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTE, 0L);
	return S_OK;
}

///	@see	ITextProcessor::PasteFromClipboardRing
STDMETHODIMP CTextProcessor::PasteFromClipboardRing() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTEFROMCLIPBOARDRING, 0L);
	return S_OK;
}

///	@see	ITextProcessor::put_OvertypeMode
STDMETHODIMP CTextProcessor::put_OvertypeMode(VARIANT_BOOL bOvertypeMode) {
	m_editor.GetActiveView()->SetOvertypeMode(toBoolean(bOvertypeMode));
	return S_OK;
}

///	@see	ITextProcessor::Unindent
STDMETHODIMP CTextProcessor::Unindent() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABINDENT, true);
	return S_OK;
}


// CTextSelection class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextSelection::CTextSelection(CAlphaEditController& editor) : m_editor(editor) {
}

///	@see	ITextSelection::Cancel
STDMETHODIMP CTextSelection::Cancel() {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_CANCELSELECTION);
	return S_OK;
}

///	@see	ITextSelection::CharNext
STDMETHODIMP CTextSelection::CharNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharPrev(bExtend, -cOffset);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_CHARNEXTEXTEND : CMDID_MOVE_CHARNEXT, cOffset);
	return S_OK;
}

///	@see	ITextSelection::CharPrev
STDMETHODIMP CTextSelection::CharPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cOffset /* = 1 */) {
	if(cOffset < 0)
		return CharNext(bExtend, -cOffset);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_CHARPREVEXTEND : CMDID_MOVE_CHARPREV, cOffset);
	return S_OK;
}

///	@see	ITextSelection::Convert
STDMETHODIMP CTextSelection::Convert(AmbientConvertType ct) {
	return E_NOTIMPL;
}

///	@see	ITextSelection::Copy
STDMETHODIMP CTextSelection::Copy(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_COPY, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

///	@see	ITextSelection::Cut
STDMETHODIMP CTextSelection::Cut(VARIANT_BOOL bAlsoSendToClipboardRing /* = VARIANT_TRUE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_CUT, toBoolean(bAlsoSendToClipboardRing));
	return S_OK;
}

///	@see	ITextSelection::get_ActiveEndGreater
STDMETHODIMP CTextSelection::get_ActiveEndGreater(VARIANT_BOOL* pbActiveEndGreater) {
	VERIFY_POINTER(pbActiveEndGreater);
	CCharPos	posBegin, posEnd;
	m_editor.GetActiveView()->GetSel(posBegin, posEnd);
	*pbActiveEndGreater = toVariantBoolean(posBegin < posEnd);
	return S_OK;
}

///	@see	ITextSelection::get_ActivePoint
STDMETHODIMP CTextSelection::get_ActivePoint(ITextPoint** ppActivePoint) {
	VERIFY_POINTER(ppActivePoint);

	CEditPoint*	pActivePoint = m_editor.GetActiveView()->CreateEditPoint();

	pActivePoint->MoveToPoint(m_editor.GetActiveView()->GetActivePoint());
	*ppActivePoint = new CTextPoint(*pActivePoint, false);
	(*ppActivePoint)->AddRef();
	return S_OK;
}

///	@see	ITextSelection::get_AnchorPoint
STDMETHODIMP CTextSelection::get_AnchorPoint(ITextPoint** ppAnchorPoint) {
	VERIFY_POINTER(ppAnchorPoint);

	CEditPoint*	pAnchorPoint = m_editor.GetActiveView()->CreateEditPoint();

	pAnchorPoint->MoveToPoint(m_editor.GetActiveView()->GetActivePoint());
	*ppAnchorPoint = new CTextPoint(*pAnchorPoint, false);
	(*ppAnchorPoint)->AddRef();
	return S_OK;
}

///	@see	ITextSelection::get_BottomPoint
STDMETHODIMP CTextSelection::get_BottomPoint(ITextPoint** ppBottomPoint) {
	VERIFY_POINTER(ppBottomPoint);

	CEditPoint*	pBottomPoint = m_editor.GetActiveView()->CreateEditPoint();
	CCharPos	posAnchor, posActive;

	m_editor.GetActiveView()->GetSel(posAnchor, posActive);
	pBottomPoint->MoveToPoint(max(posAnchor, posActive));
	*ppBottomPoint = new CTextPoint(*pBottomPoint, false);
	(*ppBottomPoint)->AddRef();
	return S_OK;
}

///	@see	ITextSelection::get_Empty
STDMETHODIMP CTextSelection::get_Empty(VARIANT_BOOL* pbEmpty) {
	VERIFY_POINTER(pbEmpty);
	*pbEmpty = toVariantBoolean(!m_editor.GetActiveView()->HasSelection());
	return S_OK;
}

///	@see	ITextSelection::get_Text
STDMETHODIMP CTextSelection::get_Text(BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	*pbstrText = ::SysAllocString(m_editor.GetActiveView()->GetSelection().c_str());
	return S_OK;
}

///	@see	ITextSelection::get_TextRanges
STDMETHODIMP CTextSelection::get_TextRanges(ITextRanges** ppTextRanges) {
	VERIFY_POINTER(ppTextRanges);
	*ppTextRanges = 0;
	return E_NOTIMPL;
}

///	@see	ITextSelection::get_TopPoint
STDMETHODIMP CTextSelection::get_TopPoint(ITextPoint** ppTopPoint) {
	VERIFY_POINTER(ppTopPoint);

	CEditPoint*	pTopPoint = m_editor.GetActiveView()->CreateEditPoint();
	CCharPos	posAnchor, posActive;

	m_editor.GetActiveView()->GetSel(posAnchor, posActive);
	pTopPoint->MoveToPoint(min(posAnchor, posActive));
	*ppTopPoint = new CTextPoint(*pTopPoint, false);
	(*ppTopPoint)->AddRef();
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTextSelection::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_ACTIVEENDGREATER:
			pVarResult->vt = VT_BOOL;
			return get_ActiveEndGreater(&pVarResult->boolVal);
		case DISPID_TEXTSELECTION_ACTIVEPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_ActivePoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_ANCHORPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_AnchorPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_BOTTOMPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_BottomPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_EMPTY:
			pVarResult->vt = VT_BOOL;
			return get_Empty(&pVarResult->boolVal);
		case DISPID_TEXTSELECTION_TEXT:
			pVarResult->vt = VT_BSTR;
			return get_Text(&pVarResult->bstrVal);
		case DISPID_TEXTSELECTION_TEXTRANGES:
			pVarResult->vt = VT_DISPATCH;
			return get_TextRanges(reinterpret_cast<ITextRanges**>(&pVarResult->pdispVal));
		case DISPID_TEXTSELECTION_TOPPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_TopPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSELECTION_CANCEL:
			VERIFY_ARGUMENTS_COUNT(0);
			return Cancel();
		case DISPID_TEXTSELECTION_CHARNEXT:
			if(pDispParams->cArgs == 0)
				return CharNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CHARPREV:
			if(pDispParams->cArgs == 0)
				return CharPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return CharPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return CharPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CONVERT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return Convert(static_cast<AmbientConvertType>(args[0].iVal));
		case DISPID_TEXTSELECTION_COPY:
			if(pDispParams->cArgs == 0)
				return Copy();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Copy(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_CUT:
			if(pDispParams->cArgs == 0)
				return Cut();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return Cut(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEDOWN:
			if(pDispParams->cArgs == 0)
				return LineDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_LINEUP:
			if(pDispParams->cArgs == 0)
				return LineUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return LineUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return LineUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETO:
			if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_UI4);
				return MoveTo(args[1].ulVal, args[0].ulVal);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_UI4);
				COERCE_ARGUMENT_AT(1, VT_UI4);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveTo(args[2].ulVal, args[1].ulVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return MoveToEndOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToEndOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOENDOFLINE:
			if(pDispParams->cArgs == 0)
				return MoveToEndOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToEndOfLine(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETONEXTBOOKMARK:
			if(pDispParams->cArgs == 0)
				return MoveToNextBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToNextBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOPREVIOUSBOOKMARK:
			if(pDispParams->cArgs == 0)
				return MoveToPreviousBookmark();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToPreviousBookmark(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFDOCUMENT:
			if(pDispParams->cArgs == 0)
				return MoveToStartOfDocument();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfDocument(args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_MOVETOSTARTOFLINE:
			if(pDispParams->cArgs == 0)
				return MoveToStartOfLine();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfLine(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return MoveToStartOfLine(args[1].boolVal, args[0].boolVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEDOWN:
			if(pDispParams->cArgs == 0)
				return PageDown();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageDown(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageDown(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PAGEUP:
			if(pDispParams->cArgs == 0)
				return PageUp();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return PageUp(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return PageUp(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_PASTE:
			VERIFY_ARGUMENTS_COUNT(0);
			return Paste();
		case DISPID_TEXTSELECTION_PASTEFROMCLIPBOARDRING:
			VERIFY_ARGUMENTS_COUNT(0);
			return PasteFromClipboardRing();
		case DISPID_TEXTSELECTION_REPLACE:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return Replace(args[0].bstrVal);
			} else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				return Replace(args[1].bstrVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_SELECTALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return SelectAll();
		case DISPID_TEXTSELECTION_SELECTLINE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_UI4);
			return SelectLine(args[0].ulVal);
		case DISPID_TEXTSELECTION_SWAPANCHOR:
			VERIFY_ARGUMENTS_COUNT(0);
			return SwapAnchor();
		case DISPID_TEXTSELECTION_WORDENDNEXT:
			if(pDispParams->cArgs == 0)
				return WordEndNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDENDPREV:
			if(pDispParams->cArgs == 0)
				return WordEndPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordEndPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordEndPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDNEXT:
			if(pDispParams->cArgs == 0)
				return WordNext();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordNext(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordNext(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_TEXTSELECTION_WORDPREV:
			if(pDispParams->cArgs == 0)
				return WordPrev();
			else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return WordPrev(args[0].boolVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BOOL);
				COERCE_ARGUMENT_AT(0, VT_I4);
				return WordPrev(args[1].boolVal, args[0].lVal);
			} else
				return DISP_E_BADPARAMCOUNT;
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	ITextSelection::LineDown
STDMETHODIMP CTextSelection::LineDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineUp(bExtend, -cLines);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEDOWNEXTEND : CMDID_MOVE_LINEDOWN, cLines);
	return S_OK;
}

///	@see	ITextSelection::LineUp
STDMETHODIMP CTextSelection::LineUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cLines /* = 1 */) {
	if(cLines < 0)
		return LineDown(bExtend, -cLines);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEUPEXTEND : CMDID_MOVE_LINEUP, cLines);
	return S_OK;
}

///	@see	ITextSelection::MoveTo
STDMETHODIMP CTextSelection::MoveTo(
		long iLine, long iChar, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	if(bExtend) {
		CCharPos	posBegin, posEnd;
		m_editor.GetActiveView()->GetSel(posBegin, posEnd);
		m_editor.GetActiveView()->SetSel(posBegin, CCharPos(iLine, iChar));
	} else
		m_editor.GetActiveView()->SetSelWithoutSelection(iLine, iChar);
	return S_OK;
}

///	@see	ITextSelection::MoveToEndOfDocument
STDMETHODIMP CTextSelection::MoveToEndOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_ENDEXTEND : CMDID_MOVE_END);
	return S_OK;
}

///	@see	ITextSelection::MoveToEndOfLine
STDMETHODIMP CTextSelection::MoveToEndOfLine(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEENDEXTEND : CMDID_MOVE_LINEEND);
	return S_OK;
}

///	@see	ITextSelection::MoveToNextBookmark
STDMETHODIMP CTextSelection::MoveToNextBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_BOOKMARKNEXT);
	return S_OK;
}

///	@see	ITextSelection::MoveToPreviousBookmark
STDMETHODIMP CTextSelection::MoveToPreviousBookmark(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_BOOKMARKPREV);
	return S_OK;
}

///	@see	ITextSelection::MoveToStartOfDocument
STDMETHODIMP CTextSelection::MoveToStartOfDocument(VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_HOMEEXTEND : CMDID_MOVE_HOME);
	return S_OK;
}

///	@see	ITextSelection::MoveToStartOfLine
STDMETHODIMP CTextSelection::MoveToStartOfLine(
		VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */, VARIANT_BOOL bExtend /* = VARIANT_FALSE */) {
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_LINEHOMEEXTEND : CMDID_MOVE_LINEHOME, bToFirstText);
	return S_OK;
}

///	@see	ITextSelection::PageDown
STDMETHODIMP CTextSelection::PageDown(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageUp(bExtend, cPages);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_PAGEDOWNEXTEND : CMDID_MOVE_PAGEDOWN, cPages);
	return S_OK;
}

///	@see	ITextSelection::PageUp
STDMETHODIMP CTextSelection::PageUp(VARIANT_BOOL bExtend /* VARIANT_FALSE */, long cPages /* = 1 */) {
	if(cPages < 0)
		return PageDown(bExtend, cPages);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_PAGEUPEXTEND : CMDID_MOVE_PAGEUP, cPages);
	return S_OK;
}

///	@see	ITextSelection::Paste
STDMETHODIMP CTextSelection::Paste() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTE);
	return S_OK;
}

///	@see	ITextSelection::PasteFromClipboardRing
STDMETHODIMP CTextSelection::PasteFromClipboardRing() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_PASTEFROMCLIPBOARDRING);
	return S_OK;
}

///	@see	ITextSelection::Replace
STDMETHODIMP CTextSelection::Replace(BSTR bstrText) {
	m_editor.GetActiveView()->ReplaceSel((bstrText != 0) ? bstrText : L"");
	return S_OK;
}

///	@see	ITextSelection::SelectAll
STDMETHODIMP CTextSelection::SelectAll() {
	m_editor.GetActiveView()->ExecCommand(CMDID_MOVE_SELECTALL);
	return S_OK;
}

///	@see	ITextSelection::SelectLine
STDMETHODIMP CTextSelection::SelectLine(long iLine) {
	m_editor.GetActiveView()->SetSel(CCharPos(iLine, 0), CCharPos(iLine, -1));
	return S_OK;
}

///	@see	ITextSelection::SwapAnchor
STDMETHODIMP CTextSelection::SwapAnchor() {
	CCharPos	posBegin, posEnd;
	m_editor.GetActiveView()->GetSel(posBegin, posEnd);
	m_editor.GetActiveView()->SetSel(posEnd, posBegin);
	return S_OK;
}

///	@see	ITextSelection::Tabify
STDMETHODIMP CTextSelection::Tabify() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_TABIFY);
	return S_OK;
}

///	@see	ITextSelection::Untabify
STDMETHODIMP CTextSelection::Untabify() {
	m_editor.GetActiveView()->ExecCommand(CMDID_EDIT_UNTABIFY);
	return S_OK;
}

///	@see	ITextSelection::WordEndNext
STDMETHODIMP CTextSelection::WordEndNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndPrev(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDENDNEXTEXTEND : CMDID_MOVE_WORDENDNEXT, cWords);
	return S_OK;
}

///	@see	ITextSelection::WordEndPrev
STDMETHODIMP CTextSelection::WordEndPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordEndNext(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDENDPREVEXTEND : CMDID_MOVE_WORDENDPREV, cWords);
	return S_OK;
}

///	@see	ITextSelection::WordNext
STDMETHODIMP CTextSelection::WordNext(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordPrev(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDNEXTEXTEND : CMDID_MOVE_WORDNEXT, cWords);
	return S_OK;
}

///	@see	ITextSelection::WordPrev
STDMETHODIMP CTextSelection::WordPrev(VARIANT_BOOL bExtend /* = VARIANT_FALSE */, long cWords /* = 1 */) {
	if(cWords < 0)
		return WordNext(bExtend, -cWords);
	m_editor.GetActiveView()->ExecCommand(bExtend ? CMDID_MOVE_WORDPREVEXTEND : CMDID_MOVE_WORDPREV, cWords);
	return S_OK;
}


// CTextPoint class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param pos			ɂȂҏW_B̕ҏW_̓fXgN^Ŕj󂷂
 *	@param bIsEditPoint	IEditPoint ̏ꍇ trueBITextPoint ̏ꍇ false
 */
CTextPoint::CTextPoint(CEditPoint& pos, bool bIsEditPoint) : m_pos(pos), m_bIsEditPoint(bIsEditPoint) {
}

///	fXgN^
CTextPoint::~CTextPoint() {
	delete &m_pos;
}

///	@see	ITextPoint::CharNext
STDMETHODIMP CTextPoint::CharNext(long cch /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.CharNext(cch);
	return S_OK;
}

///	@see	ITextPoint::CharRight
STDMETHODIMP CTextPoint::CharPrev(long cch /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.CharPrev(cch);
	return S_OK;
}

///	@see	IEditPoint::Convert
STDMETHODIMP CTextPoint::Convert(AmbientConvertType ct, VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Convert(CCharPos(iLine, iChar), static_cast<RangeConvertType>(ct));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Convert(var.lVal, static_cast<RangeConvertType>(ct));
	else
		return hr;
	return S_OK;
}

///	@see	ITextPoint::Copy
STDMETHODIMP CTextPoint::Copy(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Copy(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Copy(var.lVal);
	else
		return hr;
	return S_OK;
}

///	@see	ITextPoint::CreateEditPoint
STDMETHODIMP CTextPoint::CreateEditPoint(IEditPoint** ppEditPoint) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(ppEditPoint != 0) {
		*ppEditPoint = new CTextPoint(*m_pos.GetView()->CreateEditPoint(), true);
		(*ppEditPoint)->AddRef();
		(*ppEditPoint)->MoveTo(m_pos.GetLineNumber(), m_pos.GetCharNumber());
	}
	return S_OK;
}

///	@see	IEditPoint::Cut
STDMETHODIMP CTextPoint::Cut(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Cut(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Cut(var.lVal);
	else
		return hr;
	return S_OK;
}

///	@see	IEditPoint::Delete
STDMETHODIMP CTextPoint::Delete(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Delete(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Delete(var.lVal);
	else
		return hr;
	return S_OK;
}

///	@see	IEditPoint:DestructiveInsert
STDMETHODIMP CTextPoint::DestructiveInsert(BSTR bstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.DestructiveInsert(bstrText);
	return S_OK;
}

///	@see	ITextPoint::EnsureCentered
STDMETHODIMP CTextPoint::EnsureCentered(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.EnsureCentered(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.EnsureCentered(var.lVal);
	} else
		return hr;
	return S_OK;
}

///	@see	ITextPoint::EnsureVisible
STDMETHODIMP CTextPoint::EnsureVisible(VARIANT varOther, VARIANT_BOOL* pbInEditorRect) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;
	HRESULT	hr;

	::VariantInit(&var);

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		*pbInEditorRect = m_pos.EnsureVisible(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4))) {
		if(pbInEditorRect != 0)
			*pbInEditorRect = m_pos.EnsureVisible(var.lVal);
	} else
		return hr;
	return S_OK;
}

///	@see	ITextPoint::EqualTo
STDMETHODIMP CTextPoint::EqualTo(ITextPoint* pTextPoint, VARIANT_BOOL* pbEqual) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbEqual != 0) {
		long	iLine, iChar;

		pTextPoint->get_Line(&iLine);
		pTextPoint->get_Char(&iChar);
		*pbEqual = toVariantBoolean(
			m_pos.GetLineNumber() == iLine && m_pos.GetCharNumber() == iChar);
	}
	return S_OK;
}

///	@see	ITextPoint::get_AbsoluteCharOffset
STDMETHODIMP CTextPoint::get_AbsoluteCharOffset(long* pnAbsoluteCharOffset) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnAbsoluteCharOffset);
	*pnAbsoluteCharOffset = m_pos.GetAbsoluteCharOffset();
	return S_OK;
}

///	@see	ITextPoint::get_AtEndOfDocument
STDMETHODIMP CTextPoint::get_AtEndOfDocument(VARIANT_BOOL* pbAtEndOfDocument) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfDocument);
	*pbAtEndOfDocument = toVariantBoolean(m_pos.IsEndOfDocument());
	return S_OK;
}

///	@see	ITextPoint::get_AtEndOfLine
STDMETHODIMP CTextPoint::get_AtEndOfLine(VARIANT_BOOL* pbAtEndOfLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtEndOfLine);
	*pbAtEndOfLine = toVariantBoolean(m_pos.IsEndOfLine());
	return S_OK;
}

///	@see	ITextPoint::get_AtStartOfDocument
STDMETHODIMP CTextPoint::get_AtStartOfDocument(VARIANT_BOOL* pbAtStartOfDocument) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfDocument);
	*pbAtStartOfDocument = toVariantBoolean(m_pos.IsStartOfDocument());
	return S_OK;
}

///	@see	ITextPoint::get_AtStartOfLine
STDMETHODIMP CTextPoint::get_AtStartOfLine(VARIANT_BOOL* pbAtStartOfLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pbAtStartOfLine);
	*pbAtStartOfLine = toVariantBoolean(m_pos.IsStartOfLine());
	return S_OK;
}

///	@see	ITextPoint::get_Char
STDMETHODIMP CTextPoint::get_Char(long* pnChar) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnChar);
	*pnChar = m_pos.GetCharNumber();
	return S_OK;
}

///	@see	IEditPoint::get_CharCountBehavior
STDMETHODIMP CTextPoint::get_CharCountBehavior(AmbientCharCountBehavior* pCharCountBehavior) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pCharCountBehavior);
	*pCharCountBehavior = static_cast<AmbientCharCountBehavior>(m_pos.GetUnitBehavior());
	return S_OK;
}

///	@see	ITextPoint::get_Column
STDMETHODIMP CTextPoint::get_Column(long* pnColumn) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnColumn);
	*pnColumn = m_pos.GetColumnNumber();
	return S_OK;
}

///	@see	ITextPoint::get_Line
STDMETHODIMP CTextPoint::get_Line(long* pnLine) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLine);
	*pnLine = m_pos.GetLineNumber();
	return S_OK;
}

///	@see	ITextPoint::get_LineLength
STDMETHODIMP CTextPoint::get_LineLength(long* pnLineLength) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	VERIFY_POINTER(pnLineLength);
	*pnLineLength = m_pos.GetLineLength();
	return S_OK;
}

///	@see	IEditPoint::put_CharCountBehavior
STDMETHODIMP CTextPoint::put_CharCountBehavior(AmbientCharCountBehavior charCountBehavior) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.SetUnitBehavior(static_cast<UnitBehavior>(charCountBehavior));
	return S_OK;
}

///	@see	IEditPoint::GetText
STDMETHODIMP CTextPoint::GetText(VARIANT varOther, BSTR* pbstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pbstrText != 0) {
		CComVariant	var;
		HRESULT		hr;

		::VariantInit(&var);

		if(varOther.vt == VT_DISPATCH) {
			GENERATE_CHARPOS_FROM_TEXTPOINT();
			*pbstrText = ::SysAllocString(m_pos.GetText(CCharPos(iLine, iChar)).c_str());
		} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
			*pbstrText = ::SysAllocString(m_pos.GetText(var.lVal).c_str());
		else
			return hr;
	}
	return S_OK;
}

///	@see	ITextPoint::GreaterThan
STDMETHODIMP CTextPoint::GreaterThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbGreater) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbGreater != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() > iLine)
			*pbGreater = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() < iLine)
			*pbGreater = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbGreater = toVariantBoolean(m_pos.GetCharNumber() > iChar);
		}
	}
	return S_OK;
}

///	@see	IEditPoint::Indent
STDMETHODIMP CTextPoint::Indent(VARIANT varOther, short nLevel /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

///	@see	IEditPoint::Insert
STDMETHODIMP CTextPoint::Insert(BSTR bstrText) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.Insert(bstrText);
	return S_OK;
}

///	@see	ITextPoint::Invoke
STDMETHODIMP CTextPoint::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	bool			bCreatedResult = false;
	CComVariant		args[2];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTPOINT_ABSOLUTECHAROFFSET:
			pVarResult->vt = VT_I4;
			return get_AbsoluteCharOffset(&pVarResult->lVal);
		case DISPID_TEXTPOINT_ATENDOFDOCUMENT:
			pVarResult->vt = VT_BOOL;
			return get_AtEndOfDocument(&pVarResult->boolVal);
		case DISPID_TEXTPOINT_ATENDOFLINE:
			pVarResult->vt = VT_BOOL;
			return get_AtEndOfLine(&pVarResult->boolVal);
		case DISPID_TEXTPOINT_ATSTARTOFDOCUMENT:
			pVarResult->vt = VT_BOOL;
			return get_AtStartOfDocument(&pVarResult->boolVal);
		case DISPID_TEXTPOINT_ATSTARTOFLINE:
			pVarResult->vt = VT_BOOL;
			return get_AtStartOfLine(&pVarResult->boolVal);
		case DISPID_TEXTPOINT_CHAR:
			pVarResult->vt = VT_I4;
			return get_Char(&pVarResult->lVal);
		case DISPID_TEXTPOINT_COLUMN:
			pVarResult->vt = VT_I4;
			return get_Column(&pVarResult->lVal);
		case DISPID_TEXTPOINT_LINE:
			pVarResult->vt = VT_I4;
			return get_Line(&pVarResult->lVal);
		case DISPID_TEXTPOINT_LINELENGTH:
			pVarResult->vt = VT_I4;
			return get_LineLength(&pVarResult->lVal);
		default:
			if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTBEHAVIOR) {
				pVarResult->vt = VT_INT;
				return get_CharCountBehavior(reinterpret_cast<AmbientCharCountBehavior*>(&pVarResult->intVal));
			}
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		if(m_bIsEditPoint && dispidMember == DISPID_EDITPOINT_CHARCOUNTBEHAVIOR) {
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_CharCountBehavior(static_cast<AmbientCharCountBehavior>(args[0].intVal));
		}
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTPOINT_CREATEEDITPOINT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_DISPATCH);
			return CreateEditPoint((pVarResult != 0) ?
				reinterpret_cast<IEditPoint**>(&pVarResult->pdispVal) : 0);
		case DISPID_TEXTPOINT_ENSURECENTERED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_VARIANT);
			COERCE_RETURN(VT_BOOL);
			return EnsureCentered(args[0], (pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_ENSUREVISIBLE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_VARIANT);
			COERCE_RETURN(VT_BOOL);
			return EnsureVisible(args[0], (pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_EQUALTO:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return EqualTo(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_GREATERTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return GreaterThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		case DISPID_TEXTPOINT_LESSTHAN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			COERCE_RETURN(VT_BOOL);
			return LessThan(reinterpret_cast<ITextPoint*>(args[0].pdispVal),
				(pVarResult != 0) ? &pVarResult->boolVal : 0);
		default:
			if(m_bIsEditPoint) {
				switch(dispidMember) {
				case DISPID_EDITPOINT_CHARNEXT:
					if(pDispParams->cArgs == 0)
						return CharNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return CharNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CHARPREV:
					if(pDispParams->cArgs == 0)
						return CharPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return CharPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_CONVERT:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I2);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Convert(
						static_cast<AmbientConvertType>(args[1].iVal), args[0]);
				case DISPID_EDITPOINT_COPY:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Copy(args[0]);
				case DISPID_EDITPOINT_CUT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Cut(args[0]);
				case DISPID_EDITPOINT_DELETE:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Delete(args[0]);
				case DISPID_EDITPOINT_DESTRUCTIVEINSERT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_BSTR);
					return DestructiveInsert(args[0].bstrVal);
				case DISPID_EDITPOINT_GETTEXT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					COERCE_RETURN(VT_BSTR);
					return GetText(args[0], (pVarResult != 0) ? &pVarResult->bstrVal : 0);
				case DISPID_EDITPOINT_INDENT:
					if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Indent(args[0]);
					} else if(pDispParams->cArgs == 2) {
						COERCE_ARGUMENT_AT(1, VT_VARIANT);
						COERCE_ARGUMENT_AT(0, VT_I2);
						return Indent(args[1], args[0].iVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_INSERT:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_BSTR);
					return Insert(args[0].bstrVal);
				case DISPID_EDITPOINT_LINEDOWN:
					if(pDispParams->cArgs == 0)
						return LineDown();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return LineDown(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_LINEUP:
					if(pDispParams->cArgs == 0)
						return LineUp();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return LineUp(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_MOVETO:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_I4);
					COERCE_ARGUMENT_AT(0, VT_I4);
					return MoveTo(args[1].lVal, args[0].lVal);
				case DISPID_EDITPOINT_MOVETOABSOLUTEOFFSET:
					VERIFY_ARGUMENTS_COUNT(1);
					COERCE_ARGUMENT_AT(0, VT_I4);
					return MoveToAbsoluteOffset(args[0].lVal);
				case DISPID_EDITPOINT_MOVETOENDOFDOCUMENT:
					VERIFY_ARGUMENTS_COUNT(0);
					return MoveToEndOfDocument();
				case DISPID_EDITPOINT_MOVETOENDOFLINE:
					VERIFY_ARGUMENTS_COUNT(0);
					return MoveToEndOfLine();
				case DISPID_EDITPOINT_MOVETONEXTBOOKMARK:
					VERIFY_ARGUMENTS_COUNT(0);
					return MoveToNextBookmark();
				case DISPID_EDITPOINT_MOVETOPREVIOUSBOOKMARK:
					VERIFY_ARGUMENTS_COUNT(0);
					return MoveToPreviousBookmark();
				case DISPID_EDITPOINT_MOVETOSTARTOFDOCUMENT:
					VERIFY_ARGUMENTS_COUNT(0);
					return MoveToStartOfDocument();
				case DISPID_EDITPOINT_MOVETOSTARTOFLINE:
					if(pDispParams->cArgs == 0)
						return MoveToStartOfLine();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_BOOL);
						return MoveToStartOfLine(args[0].boolVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_NEWLINE:
					VERIFY_ARGUMENTS_COUNT(0);
					return NewLine();
				case DISPID_EDITPOINT_PAGEDOWN:
					if(pDispParams->cArgs == 0)
						return PageDown();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return PageDown(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PAGEUP:
					if(pDispParams->cArgs == 0)
						return PageUp();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return PageUp(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_PASTE:
					if(pDispParams->cArgs == 0) {
						args[0] = 0;
						return Paste(args[0]);
					} else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Paste(args[0]);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_REPLACE:
					VERIFY_ARGUMENTS_COUNT(2);
					COERCE_ARGUMENT_AT(1, VT_BSTR);
					COERCE_ARGUMENT_AT(0, VT_VARIANT);
					return Replace(args[1].bstrVal, args[0]);
				case DISPID_EDITPOINT_UNINDENT:
					if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_VARIANT);
						return Unindent(args[0]);
					} else if(pDispParams->cArgs == 2) {
						COERCE_ARGUMENT_AT(1, VT_VARIANT);
						COERCE_ARGUMENT_AT(0, VT_I2);
						return Unindent(args[1], args[0].iVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDNEXT:
					if(pDispParams->cArgs == 0)
						return WordEndNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordEndNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDENDPREV:
					if(pDispParams->cArgs == 0)
						return WordEndPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordEndPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDNEXT:
					if(pDispParams->cArgs == 0)
						return WordNext();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordNext(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				case DISPID_EDITPOINT_WORDPREV:
					if(pDispParams->cArgs == 0)
						return WordPrev();
					else if(pDispParams->cArgs == 1) {
						COERCE_ARGUMENT_AT(0, VT_I4);
						return WordPrev(args[0].lVal);
					} else
						return DISP_E_BADPARAMCOUNT;
				}
			}
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	ITextPoint::LessThan
STDMETHODIMP CTextPoint::LessThan(ITextPoint* pTextPoint, VARIANT_BOOL* pbLess) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	if(pTextPoint == 0)
		return E_INVALIDARG;
	if(pbLess != 0) {
		unsigned long	iLine, iChar;

		pTextPoint->get_Line(reinterpret_cast<long*>(&iLine));
		if(m_pos.GetLineNumber() < iLine)
			*pbLess = VARIANT_TRUE;
		else if(m_pos.GetLineNumber() > iLine)
			*pbLess = VARIANT_FALSE;
		else {
			pTextPoint->get_Char(reinterpret_cast<long*>(&iChar));
			*pbLess = toVariantBoolean(m_pos.GetCharNumber() < iChar);
		}
	}
	return S_OK;
}

///	@see	ITextPoint::LineDown
STDMETHODIMP CTextPoint::LineDown(long cLines /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.LineDown(cLines);
	return S_OK;
}

///	@see	ITextPoint::LineUp
STDMETHODIMP CTextPoint::LineUp(long cLines /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.LineUp(cLines);
	return S_OK;
}

///	@see	ITextPoint::MoveTo
STDMETHODIMP CTextPoint::MoveTo(long iLine, long iChar) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToPoint(CCharPos(iLine, iChar));
	return S_OK;
}

///	@see	ITextPoint::MoveToAbsoluteOffset
STDMETHODIMP CTextPoint::MoveToAbsoluteOffset(long nOffset) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToAbsoluteCharOffset(nOffset);
	return S_OK;
}

///	@see	ITextPoint::MoveToEndOfDocument
STDMETHODIMP CTextPoint::MoveToEndOfDocument() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToEndOfDocument();
	return S_OK;
}

///	@see	ITextPoint::MoveToEndOfLine
STDMETHODIMP CTextPoint::MoveToEndOfLine() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToEndOfLine();
	return S_OK;
}

///	@see	ITextPoint::MoveToNextBookmark
STDMETHODIMP CTextPoint::MoveToNextBookmark() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToNextBookmark();
	return S_OK;
}

///	@see	ITextPoint::MoveToPreviousBookmark
STDMETHODIMP CTextPoint::MoveToPreviousBookmark() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToPrevBookmark();
	return S_OK;
}

///	@see	ITextPoint::MoveToStartOfDocument
STDMETHODIMP CTextPoint::MoveToStartOfDocument() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToStartOfDocument();
	return S_OK;
}

///	@see	ITextPoint::MoveToStartOfLine
STDMETHODIMP CTextPoint::MoveToStartOfLine(VARIANT_BOOL bToFirstText /* = VARIANT_FALSE */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.MoveToStartOfLine(toBoolean(bToFirstText));
	return S_OK;
}

///	@see	IEditPoint::NewLine
STDMETHODIMP CTextPoint::NewLine() {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.NewLine();
	return S_OK;
}

///	@see	ITextPoint::PageDown
STDMETHODIMP CTextPoint::PageDown(long cPages /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.PageDown(cPages);
	return S_OK;
}

///	@see	ITextPoint::PageUp
STDMETHODIMP CTextPoint::PageUp(long cPages /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.PageUp(cPages);
	return S_OK;
}

///	@see	IEditPoint::Paste
STDMETHODIMP CTextPoint::Paste(VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	CComVariant	var;
	HRESULT		hr;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.Paste(CCharPos(iLine, iChar));
	} else if(SUCCEEDED(hr = ::VariantChangeType(&var, &varOther, 0, VT_I4)))
		m_pos.Paste(var.lVal);
	else
		return hr;
	return S_OK;
}

///	@see	IEditPoint::Replace
STDMETHODIMP CTextPoint::Replace(BSTR bstrText, VARIANT varOther) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	HRESULT	hr;

	m_pos.GetView()->GetDocument()->BeginEditCollection();
	if(FAILED(hr = Delete(varOther))
			|| FAILED(hr = Insert(bstrText))) {
		m_pos.GetView()->GetDocument()->EndEditCollection();
		return hr;
	}
	m_pos.GetView()->GetDocument()->EndEditCollection();
	return S_OK;
}

///	@see	IEditPoint::Unindent
STDMETHODIMP CTextPoint::Unindent(VARIANT varOther, short nLevel /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;

	VARIANT	var;

	if(varOther.vt == VT_DISPATCH) {
		GENERATE_CHARPOS_FROM_TEXTPOINT();
		m_pos.TabIndent(CCharPos(iLine, iChar), -nLevel);
	} else
		return DISP_E_TYPEMISMATCH;
	return S_OK;
}

///	@see	ITextPoint::WordEndNext
STDMETHODIMP CTextPoint::WordEndNext(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordEndNext(cWords);
	return S_OK;
}

///	@see	ITextPoint::WordEndPrev
STDMETHODIMP CTextPoint::WordEndPrev(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordEndPrev(cWords);
	return S_OK;
}

///	@see	ITextPoint::WordNext
STDMETHODIMP CTextPoint::WordNext(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordNext(cWords);
	return S_OK;
}

///	@see	ITextPoint::WordPrev
STDMETHODIMP CTextPoint::WordPrev(long cWords /* = 1 */) {
	if(!m_pos.IsAvailable())
		return E_UNEXPECTED;
	m_pos.WordPrev(cWords);
	return S_OK;
}


// CTextRange class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CTextRange::CTextRange(CEditPoint& pos1, CEditPoint& pos2) : m_pos1(pos1), m_pos2(pos2) {
}

///	@see	ITextRange::get_EndPoint
STDMETHODIMP CTextRange::get_EndPoint(ITextPoint** ppEndPoint) {
	VERIFY_POINTER(ppEndPoint);
//	*ppEndPoint = new CTextPoint(m_app, m_pRange->GetEndPoint());
//	(*ppEndPoint)->AddRef();
	return E_NOTIMPL;
}

///	@see	ITextRange::get_StartPoint
STDMETHODIMP CTextRange::get_StartPoint(ITextPoint** ppStartPoint) {
	VERIFY_POINTER(ppStartPoint);
//	*ppStartPoint = new CTextPoint(m_app, m_pRange->GetStartPoint());
//	(*ppStartPoint)->AddRef();
	return E_NOTIMPL;
}

///	@see	ITextRange::Invoke
STDMETHODIMP CTextRange::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTRANGE_ENDPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_EndPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		case DISPID_TEXTRANGE_STARTPOINT:
			pVarResult->vt = VT_DISPATCH;
			return get_StartPoint(reinterpret_cast<ITextPoint**>(&pVarResult->pdispVal));
		}
	}
	return DISP_E_MEMBERNOTFOUND;
}


// CAutomationLexer class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param impl	Ϗ
 */
CAutomationLexer::CAutomationLexer(CLexer& impl) : m_impl(impl) {
}

///	@see	ILexer::AddKeywords
STDMETHODIMP CAutomationLexer::AddKeywords(BSTR bstrKeywords, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrKeywords == 0)
		return E_INVALIDARG;

	set<string_t>	setKeywords;
	wchar_t*		pCurrent = bstrKeywords;
	wchar_t*		pNext;

	while(*pCurrent != 0) {
		if(*pCurrent == L' ') {
			++pCurrent;
			continue;
		}
		pNext = wcschr(pCurrent, L' ');
		if(pNext != 0) {
			setKeywords.insert(string_t(pCurrent, pNext - pCurrent));
			pCurrent = pNext + 1;
		} else {
			setKeywords.insert(string_t(pCurrent));
			break;
		}
	}
	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddKeywords(setKeywords);
	else
		m_impl.AddKeywords(setKeywords);
	return S_OK;
}

///	@see	ILexer::AddMultilineAnnotation
STDMETHODIMP CAutomationLexer::AddMultilineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, AmbientAnnotationRestriction ar, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrStartDelimiter == 0 || bstrEndDelimiter == 0)
		return E_INVALIDARG;

	if(pnIdentifier != 0)
		*pnIdentifier = m_impl.AddMultilineAnnotation(bstrStartDelimiter,
							bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	else
		m_impl.AddMultilineAnnotation(bstrStartDelimiter,
			bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	return S_OK;
}

///	@see	ILexer::AddSinglelineAnnotation
STDMETHODIMP CAutomationLexer::AddSinglelineAnnotation(BSTR bstrStartDelimiter,
		BSTR bstrEndDelimiter, AmbientAnnotationRestriction ar, long* pnIdentifier) {
	if(pnIdentifier != 0)
		*pnIdentifier = 0;
	if(bstrStartDelimiter == 0)
		return E_INVALIDARG;

	if(bstrEndDelimiter == 0) {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<AnnotationRestriction>(ar));
		else
			m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, static_cast<AnnotationRestriction>(ar));
	} else {
		if(pnIdentifier != 0)
			*pnIdentifier = m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
		else
			m_impl.AddSinglelineAnnotation(
				bstrStartDelimiter, bstrEndDelimiter, static_cast<AnnotationRestriction>(ar));
	}
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationLexer::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	bool		bCreatedResult = false;
	CComVariant	args[3];

	if(wFlags & DISPATCH_PROPERTYGET)	// Qb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_LEXER_FREEZED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Freezed(args[0].boolVal);
		case DISPID_LEXER_IGNORECASE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_IgnoreCase(args[0].boolVal);
		case DISPID_LEXER_NUMBERFORMAT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_NumberFormat(static_cast<AmbientNumberFormat>(args[0].intVal));
		case DISPID_LEXER_TOKENENABLED:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_TokenEnabled(args[1].bstrVal, args[0].boolVal);
		case DISPID_LEXER_UNICODEALPHABETSENABLED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_UnicodeAlphabetsEnabled(args[0].boolVal);
		case DISPID_LEXER_UNICODEWHITESPACESENABLED:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_UnicodeWhiteSpacesEnabled(args[0].boolVal);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_LEXER_ADDKEYWORDS:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			COERCE_RETURN(VT_I4);
			return AddKeywords(args[0].bstrVal, (pVarResult != 0) ? &pVarResult->lVal : 0);
		case DISPID_LEXER_ADDMULTILINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<AmbientAnnotationRestriction>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddMultilineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_ADDSINGLELINEANNOTATION:
			if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_INT);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[2].bstrVal, args[1].bstrVal,
					static_cast<AmbientAnnotationRestriction>(args[0].intVal),
					(pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[1].bstrVal, args[0].bstrVal,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				COERCE_RETURN(VT_I4);
				return AddSinglelineAnnotation(
					args[0].bstrVal, 0,
					AAR_NONE, (pVarResult != 0) ? &pVarResult->lVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_LEXER_REMOVEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return RemoveAll();
		case DISPID_LEXER_REMOVEIDENTIFIEDTOKEN:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return RemoveIdentifiedToken(args[0].lVal);
		case DISPID_LEXER_SETADDITIONALALPHABETS:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return SetAdditionalAlphabets(args[0].bstrVal);
		case DISPID_LEXER_SETBRACKETS:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return SetBrackets(args[0].bstrVal);
		case DISPID_LEXER_SETOPERATORS:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return SetOperators(args[0].bstrVal);
		}
		return DISP_E_MEMBERNOTFOUND;
	}

	return hr;
}

///	@see	ILexer::put_Freezed
STDMETHODIMP CAutomationLexer::put_Freezed(VARIANT_BOOL bFreeze) {
	if(toBoolean(bFreeze))
		m_impl.Freeze();
	else
		m_impl.Unfreeze();
	return S_OK;
}

///	@see	ILexer::put_IgnoreCase
STDMETHODIMP CAutomationLexer::put_IgnoreCase(VARIANT_BOOL bIgnoreCase) {
	m_impl.IgnoreCase(toBoolean(bIgnoreCase));
	return S_OK;
}

///	@see	ILexer::put_NumberFormat
STDMETHODIMP CAutomationLexer::put_NumberFormat(AmbientNumberFormat numberFormat) {
	try {
		if(numberFormat != ANF_DEFAULT)
			return E_NOTIMPL;
		m_impl.SetNumberFormat(static_cast<NumberFormat>(numberFormat));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::put_TokenEnabled
STDMETHODIMP CAutomationLexer::put_TokenEnabled(BSTR bstrTokenName, VARIANT_BOOL bEnabled) {
	if(bstrTokenName == 0)
		return E_INVALIDARG;
	if(wcscmp(bstrTokenName, L"whiteSpace") == 0)
		m_impl.EnableToken(TT_WHITESPACE, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"tab") == 0)
		m_impl.EnableToken(TT_TAB, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"keyword") == 0)
		m_impl.EnableToken(TT_KEYWORD, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"annotation") == 0)
		m_impl.EnableToken(TT_ANNOTATION, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"operator") == 0)
		m_impl.EnableToken(TT_OPERATOR, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"identifier") == 0)
		m_impl.EnableToken(TT_IDENTIFIER, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"numeral") == 0)
		m_impl.EnableToken(TT_NUMERAL, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"number") == 0)
		m_impl.EnableToken(TT_NUMBER, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"singleQuotation") == 0)
		m_impl.EnableToken(TT_SINGLEQUOTATION, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"doubleQuotation") == 0)
		m_impl.EnableToken(TT_DOUBLEQUOTATION, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"otherQuotation") == 0)
		m_impl.EnableToken(TT_OTHERQUOTATION, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"asciiControl") == 0)
		m_impl.EnableToken(TT_ASCII_CONTROL, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"unicodeControl") == 0)
		m_impl.EnableToken(TT_UNICODE_CONTROL, toBoolean(bEnabled));
	else if(wcscmp(bstrTokenName, L"unspecified") == 0)
		m_impl.EnableToken(TT_UNSPECIFIED, toBoolean(bEnabled));
	else
		return E_INVALIDARG;
	return S_OK;
}

///	@see	ILexer::put_UnicodeAlphabetsEnabled
STDMETHODIMP CAutomationLexer::put_UnicodeAlphabetsEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeAlphabets(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::put_UnicodeWhiteSpacesEnabled
STDMETHODIMP CAutomationLexer::put_UnicodeWhiteSpacesEnabled(VARIANT_BOOL bEnabled) {
	m_impl.EnableUnicodeWhiteSpaces(toBoolean(bEnabled));
	return S_OK;
}

///	@see	ILexer::RemoveAll
STDMETHODIMP CAutomationLexer::RemoveAll() {
	m_impl.RemoveAll();
	return S_OK;
}

///	@see	ILexer::RemoveIdentifiedToken
STDMETHODIMP CAutomationLexer::RemoveIdentifiedToken(long nIdentifier) {
	try {
		m_impl.RemoveIdentifiedToken(static_cast<TokenCookie>(nIdentifier));
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetAdditionalAlphabets
STDMETHODIMP CAutomationLexer::SetAdditionalAlphabets(BSTR bstrAlphabets) {
	if(bstrAlphabets != 0)
		m_impl.SetAdditionalAlphabets(bstrAlphabets, wcslen(bstrAlphabets));
	else
		m_impl.SetAdditionalAlphabets(L"", 0);
	return S_OK;
}

///	@see	ILexer::SetBrackets
STDMETHODIMP CAutomationLexer::SetBrackets(BSTR bstrOpeners) {
	try {
		m_impl.SetBrackets((bstrOpeners != 0) ? bstrOpeners : L"");
	} catch(invalid_argument&) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	ILexer::SetOperators
STDMETHODIMP CAutomationLexer::SetOperators(BSTR bstrOperators) {
	set<string_t>	setOperators;

	if(bstrOperators != 0) {
		wchar_t*	pCurrent = bstrOperators;
		wchar_t*	pNext;

		while(true) {
			pNext = wcschr(pCurrent, L' ');
			if(pNext != 0) {
				setOperators.insert(string_t(pCurrent, pNext - pCurrent));
				pCurrent = pNext + 1;
			} else {
				setOperators.insert(string_t(pCurrent));
				break;
			}
		}
	}
	m_impl.SetOperators(setOperators);
	return S_OK;
}


// CEditorPreferences class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param view	r[
 */
CEditorPreferences::CEditorPreferences(CEditView& view) : m_view(view) {
}

///	@see	IEditorPreferences::get_TokenDecoration
STDMETHODIMP CEditorPreferences::get_TokenDecoration(BSTR bstrTokenTypeName, ITokenDecoration** ppTokenDecoration) {
	VERIFY_POINTER(ppTokenDecoration);
	if(bstrTokenTypeName == 0)
		return E_INVALIDARG;
	if(wcscmp(bstrTokenTypeName, L"whiteSpace") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_WHITESPACE);
	else if(wcscmp(bstrTokenTypeName, L"tab") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_TAB);
	else if(wcscmp(bstrTokenTypeName, L"operator") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OPERATOR);
	else if(wcscmp(bstrTokenTypeName, L"identifier") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_IDENTIFIER);
	else if(wcscmp(bstrTokenTypeName, L"numeral") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMERAL);
	else if(wcscmp(bstrTokenTypeName, L"number") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_NUMBER);
	else if(wcscmp(bstrTokenTypeName, L"singleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_SINGLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"doubleQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_DOUBLEQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"otherQuotation") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_OTHERQUOTATION);
	else if(wcscmp(bstrTokenTypeName, L"asciiControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_ASCII_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unicodeControl") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNICODE_CONTROL);
	else if(wcscmp(bstrTokenTypeName, L"unspecified") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, TT_UNSPECIFIED);
	else if(wcscmp(bstrTokenTypeName, L"normal") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_NORMAL);
	else if(wcscmp(bstrTokenTypeName, L"selection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"inactiveSelection") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INACTIVE_SELECTION);
	else if(wcscmp(bstrTokenTypeName, L"indicatorMargin") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_INDICATOR_MARGIN);
	else if(wcscmp(bstrTokenTypeName, L"lineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"emphaticLineNumber") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_EMPHATIC_LINENUMBER);
	else if(wcscmp(bstrTokenTypeName, L"matchBrackets") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCH_BRACKETS);
	else if(wcscmp(bstrTokenTypeName, L"endOfLine") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_LINE);
	else if(wcscmp(bstrTokenTypeName, L"endOfFile") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_END_OF_FILE);
	else if(wcscmp(bstrTokenTypeName, L"link") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_LINK);
	else if(wcscmp(bstrTokenTypeName, L"matchText") == 0)
		*ppTokenDecoration = new CTokenDecoration(m_view, ETT_MATCHTEXT);
	else {	// L[[hƃRgɂ̓NbL[lKv
		if(wcslen(bstrTokenTypeName) >= 9 && wcsncmp(bstrTokenTypeName, L"keyword_", 8) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_KEYWORD, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 8, 0, 10)));
		else if(wcslen(bstrTokenTypeName) >= 12 && wcsncmp(bstrTokenTypeName, L"annotation_", 11) == 0)
			*ppTokenDecoration = new CTokenDecoration(m_view,
				TT_ANNOTATION, static_cast<TokenCookie>(wcstol(bstrTokenTypeName + 11, 0, 10)));
		else {
			*ppTokenDecoration = 0;
			return E_INVALIDARG;
		}

	}
	(*ppTokenDecoration)->AddRef();

	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CEditorPreferences::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_TOKENDECORATION:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_DISPATCH;
			return get_TokenDecoration(args[0].bstrVal, reinterpret_cast<ITokenDecoration**>(&pVarResult->pdispVal));
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {
		VERIFY_ARGUMENTS_COUNT(1);
		switch(dispidMember) {
		case DISPID_EDITORPREFERENCES_CHARSPAN:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_CharSpan(args[0].iVal);
		case DISPID_EDITORPREFERENCES_CLOSEBOLDCHARS:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_CloseBoldChars(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_ENDOFFILELABEL:
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_EndOfFileLabel(args[0].bstrVal);
		case DISPID_EDITORPREFERENCES_IDEOGRAPHICSPACEALTERNATIVECHAR:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_IdeographicSpaceAlternativeChar(args[0].iVal);
		case DISPID_EDITORPREFERENCES_LEFTMARGIN:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_LeftMargin(args[0].iVal);
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERSTYLE:
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_LineNumberBorderStyle(static_cast<AmbientLineNumberBorderStyle>(args[0].intVal));
		case DISPID_EDITORPREFERENCES_LINENUMBERBORDERWIDTH:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_LineNumberBorderWidth(args[0].iVal);
		case DISPID_EDITORPREFERENCES_LINESPAN:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_LineSpan(args[0].iVal);
		case DISPID_EDITORPREFERENCES_RESETDIRECTIONBYTOKENS:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ResetDirectionByTokens(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_RIGHTTOLEFTREADING:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_RightToLeftReading(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SELECTENDOFLINE:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_SelectEndOfLine(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWCURRENTUNDERLINE:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowCurrentUnderline(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWENDOFFILE:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowEndOfFile(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWENDOFLINE:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowEndOfLine(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWHANDONLINK:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowHandOnLink(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWHINTONLINK:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowHintOnLink(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWINDICATORMARGIN:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowIndicatorMargin(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWLINENUMBER:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowLineNumber(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWUNICODEDIRECTIONFORMATTER:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowUnicodeDirectionFormatter(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_SHOWWHITESPACEALTERNATIVE:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ShowWhiteSpaceAlternative(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_STARTCHARNUMBER:
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_StartCharNumber(args[0].lVal);
		case DISPID_EDITORPREFERENCES_STARTLINENUMBER:
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_StartLineNumber(args[0].lVal);
		case DISPID_EDITORPREFERENCES_TABALTERNATIVECHAR:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_TabAlternativeChar(args[0].iVal);
		case DISPID_EDITORPREFERENCES_TABWIDTH:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_TabWidth(args[0].iVal);
		case DISPID_EDITORPREFERENCES_THINCARET:
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ThinCaret(args[0].boolVal);
		case DISPID_EDITORPREFERENCES_TOPMARGIN:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_TopMargin(args[0].iVal);
		case DISPID_EDITORPREFERENCES_WHITESPACEALTERNATIVECHAR:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_WhiteSpaceAlternativeChar(args[0].iVal);
		case DISPID_EDITORPREFERENCES_WRAPMODE:
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_WrapMode(static_cast<AmbientWrapMode>(args[0].intVal));
		case DISPID_EDITORPREFERENCES_WRAPWIDTH:
			COERCE_ARGUMENT_AT(0, VT_I2);
			return put_WrapWidth(args[0].iVal);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		if(dispidMember == DISPID_EDITORPREFERENCES_RESET) {
			VERIFY_ARGUMENTS_COUNT(0);
			return Reset();
		}
	}

	return hr;
}

///	@see	IEditorPreferences::put_CharSpan
STDMETHODIMP CEditorPreferences::put_CharSpan(short nCharSpan) {
	if(nCharSpan < 0)
		return E_INVALIDARG;

	unsigned int	nLineSpan;
	m_view.GetCharSpaces(&nLineSpan, 0);
	m_view.SetCharSpaces(nLineSpan, nCharSpan);
	return S_OK;
}

///	@see	IEditorPreferences::put_CloseBoldChars
STDMETHODIMP CEditorPreferences::put_CloseBoldChars(VARIANT_BOOL bCloseBoldChars) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_MAKECLOSEBOLDCHARS;
	evo.evoMiscellaneous |= toBoolean(bCloseBoldChars) ? EVO_MAKECLOSEBOLDCHARS : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_EndOfFileLabel
STDMETHODIMP CEditorPreferences::put_EndOfFileLabel(BSTR bstrEndOfFileLabel) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.strEndOfFile = (bstrEndOfFileLabel != 0) ? bstrEndOfFileLabel : L"";
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_IdeographicSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::put_IdeographicSpaceAlternativeChar(short cp) {
	if(cp < 0)
		return E_INVALIDARG;

	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.chIdeographicSpaceAlternative = cp;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_LeftMargin
STDMETHODIMP CEditorPreferences::put_LeftMargin(short nLeftMargin) {
	if(nLeftMargin < 0)
		return E_INVALIDARG;

	unsigned int	nTopMargin;
	m_view.GetMargins(0, &nTopMargin);
	m_view.SetMargins(nLeftMargin, nTopMargin);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderStyle
STDMETHODIMP CEditorPreferences::put_LineNumberBorderStyle(AmbientLineNumberBorderStyle style) {
	TLineNumberLayout	lnl;

	m_view.GetLineNumberLayout(lnl);
	lnl.borderStyle = static_cast<TLineNumberLayout::BorderStyle>(style);
	m_view.SetLineNumberLayout(lnl);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineNumberBorderWidth
STDMETHODIMP CEditorPreferences::put_LineNumberBorderWidth(short nWidth) {
	TLineNumberLayout	lnl;

	m_view.GetLineNumberLayout(lnl);
	lnl.nBorderWidth = nWidth;
	m_view.SetLineNumberLayout(lnl);
	return S_OK;
}

///	@see	IEditorPreferences::put_LineSpan
STDMETHODIMP CEditorPreferences::put_LineSpan(short nLineSpan) {
	if(nLineSpan < 0)
		return E_INVALIDARG;

	unsigned int	nCharSpan;
	m_view.GetCharSpaces(0, &nCharSpan);
	m_view.SetCharSpaces(nLineSpan, nCharSpan);
	return S_OK;
}

///	@see	IEditorPreferences::put_ResetDirectionByTokens
STDMETHODIMP CEditorPreferences::put_ResetDirectionByTokens(VARIANT_BOOL bResetDirByTokens) {
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::put_RightToLeftReading
STDMETHODIMP CEditorPreferences::put_RightToLeftReading(VARIANT_BOOL bRightToLeft) {
	m_view.SetTextDirection(toBoolean(bRightToLeft));
	return S_OK;
}

///	@see	IEditorPreferences::put_SelectEndOfLine
STDMETHODIMP CEditorPreferences::put_SelectEndOfLine(VARIANT_BOOL bSelectEndOfLine) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_PAINTBREAKCONTINUINGSEL;
	evo.evoMiscellaneous |= toBoolean(bSelectEndOfLine) ? EVO_PAINTBREAKCONTINUINGSEL : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowCurrentUnderline
STDMETHODIMP CEditorPreferences::put_ShowCurrentUnderline(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_CURRENTUNDERLINE;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_CURRENTUNDERLINE : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowEndOfFile
STDMETHODIMP CEditorPreferences::put_ShowEndOfFile(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_EOFMARK;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_EOFMARK : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowEndOfLine
STDMETHODIMP CEditorPreferences::put_ShowEndOfLine(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_BREAKARROWS;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_BREAKARROWS : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowHandOnLink
STDMETHODIMP CEditorPreferences::put_ShowHandOnLink(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_HANDONLINK;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_HANDONLINK : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowHintOnLink
STDMETHODIMP CEditorPreferences::put_ShowHintOnLink(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_HINTONLINK;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_HINTONLINK : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowIndicatorMargin
STDMETHODIMP CEditorPreferences::put_ShowIndicatorMargin(VARIANT_BOOL bShow) {
	TLineNumberLayout	lnl;

	m_view.GetLineNumberLayout(lnl);
	lnl.bShowIndicatorMargin = toBoolean(bShow);
	m_view.SetLineNumberLayout(lnl);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowLineNumber
STDMETHODIMP CEditorPreferences::put_ShowLineNumber(VARIANT_BOOL bShow) {
	TLineNumberLayout	lnl;

	m_view.GetLineNumberLayout(lnl);
	lnl.bShowLineNumbers = toBoolean(bShow);
	m_view.SetLineNumberLayout(lnl);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowUnicodeDirectionFormatter
STDMETHODIMP CEditorPreferences::put_ShowUnicodeDirectionFormatter(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_UNICODECTRLCHARS;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_UNICODECTRLCHARS : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_ShowWhiteSpaceAlternative
STDMETHODIMP CEditorPreferences::put_ShowWhiteSpaceAlternative(VARIANT_BOOL bShow) {
	TEditViewOption	evo;

	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_SHOW_WHITESPACE;
	evo.evoMiscellaneous |= toBoolean(bShow) ? EVO_SHOW_WHITESPACE : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_StartCharNumber
STDMETHODIMP CEditorPreferences::put_StartCharNumber(long nStartCharNumber) {
	if(nStartCharNumber < 0)
		return E_INVALIDARG;

	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.iStartChar = nStartCharNumber;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_StartLineNumber
STDMETHODIMP CEditorPreferences::put_StartLineNumber(long nStartLineNumber) {
	if(nStartLineNumber < 0)
		return E_INVALIDARG;

	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.iStartLine = nStartLineNumber;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_TabAlternativeChar
STDMETHODIMP CEditorPreferences::put_TabAlternativeChar(short cp) {
	if(cp < 0)
		return E_INVALIDARG;

	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.chTabAlternative = cp;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_TabWidth
STDMETHODIMP CEditorPreferences::put_TabWidth(short nTabWidth) {
	if(nTabWidth < 0)
		return E_INVALIDARG;
	m_view.SetTabWidth(nTabWidth);
	return S_OK;
}

///	@see	IEditorPreferences::put_ThinCaret
STDMETHODIMP CEditorPreferences::put_ThinCaret(VARIANT_BOOL bThinCaret) {
	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.evoMiscellaneous &= ~EVO_USE_THINCARET;
	evo.evoMiscellaneous |= toBoolean(bThinCaret) ? EVO_USE_THINCARET : 0;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_TopMargin
STDMETHODIMP CEditorPreferences::put_TopMargin(short nTopMargin) {
	if(nTopMargin < 0)
		return E_INVALIDARG;

	unsigned int	nLeftMargin;
	m_view.GetMargins(&nLeftMargin, 0);
	m_view.SetMargins(nLeftMargin, nTopMargin);
	return S_OK;
}

///	@see	IEditorPreferences::put_WhiteSpaceAlternativeChar
STDMETHODIMP CEditorPreferences::put_WhiteSpaceAlternativeChar(short cp) {
	if(cp < 0)
		return E_INVALIDARG;

	TEditViewOption	evo;
	m_view.GetOption(evo);
	evo.chWhitespaceAlternative = cp;
	m_view.SetOption(evo);
	return S_OK;
}

///	@see	IEditorPreferences::put_WrapMode
STDMETHODIMP CEditorPreferences::put_WrapMode(AmbientWrapMode wrapMode) {
//	m_view.SetWrapMode(static_cast<WrapMode>(wrapMode));
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::put_WrapWidth
STDMETHODIMP CEditorPreferences::put_WrapWidth(short nWrapWidth) {
//	m_view.SetWrapWidth(nWrapWidth);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	IEditorPreferences::Reset
STDMETHODIMP CEditorPreferences::Reset() {
	TEditViewOption	evo;
	TTextFoundation	tf;

	m_view.SetCharSpaces(0, 0);
	m_view.SetMargins(5, 1);
	m_view.SetTabWidth(4);
	m_view.SetLineNumberLayout(TLineNumberLayout());
	m_view.GetOption(evo);
	evo.chIdeographicSpaceAlternative = L'\x25A1';
	evo.chTabAlternative = L'^';
	evo.chWhitespaceAlternative = L'_';
	evo.iStartChar = evo.iStartLine = 1;
	evo.strEndOfFile = L"[EOF]";
	evo.evoMiscellaneous = EVO_USE_OLEDRAGDROP | EVO_ACCEPTABLECARETBYMOUSE
							| EVO_RESETDIRECTIONBYTOKEN | EVO_SHOW_HINTONLINK;
	m_view.SetOption(evo);
	for(int type = TT_WHITESPACE; type < ETT_COUNT; ++type) {
		if(type != TT_KEYWORD && type != TT_ANNOTATION)
			m_view.SetTextFoundation(type, NullCookie, tf);
	}

	return S_OK;
}


// CTokenDecoration class implementation
/////////////////////////////////////////////////////////////////////////////

namespace {	// Win32 API ƃXNvgnŐF̕\
	inline long WinRGBToScriptRGB(COLORREF clr) {
		return (clr == -1) ? -1 : (GetBValue(clr) | (GetGValue(clr) << 8) | (GetRValue(clr) << 16));
	}
	inline COLORREF ScriptRGBToWinRGB(long clr) {
		return (clr == -1) ? -1 : RGB((clr & 0xFF0000) >> 16, (clr & 0x00FF00) >> 8, clr & 0x0000FF);
	}
}

// CEditView::GetTextFoundation ͗O𓊂̂łňꊇ
#define GET_TF()															\
	TTextFoundation	_tf;													\
	try {																	\
		_tf = m_view.GetTextFoundation(m_nTokenType, m_nTokenCookie, true);	\
	} catch(invalid_argument&) {											\
		return E_UNEXPECTED;												\
	}

/**
 *	RXgN^
 *	@param view			r[
 *	@param nTokenType	g[N̎
 *	@param nTokenCookie	g[ÑNbL[l
 */
CTokenDecoration::CTokenDecoration(CEditView& view, int nTokenType, TokenCookie nTokenCookie)
		: m_view(view), m_nTokenType(nTokenType), m_nTokenCookie(nTokenCookie) {
}

///	@see	ITokenDecoration::get_BackgroundColor
STDMETHODIMP CTokenDecoration::get_BackgroundColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.bgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_BoldFont
STDMETHODIMP CTokenDecoration::get_BoldFont(VARIANT_BOOL* pbBold) {
	VERIFY_POINTER(pbBold);
	GET_TF();
	*pbBold = toVariantBoolean(_tf.bold);
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderColor
STDMETHODIMP CTokenDecoration::get_BorderColor(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = _tf.borderColor;
	return S_OK;
}

///	@see	ITokenDecoration::get_BorderStyle
STDMETHODIMP CTokenDecoration::get_BorderStyle(AmbientBorderType* pBorderType) {
	VERIFY_POINTER(pBorderType);
	GET_TF();
	*pBorderType = static_cast<AmbientBorderType>(_tf.border);
	return S_OK;
}

///	@see	ITokenDecoration::get_Color
STDMETHODIMP CTokenDecoration::get_Color(long* pnColor) {
	VERIFY_POINTER(pnColor);
	GET_TF();
	*pnColor = WinRGBToScriptRGB(_tf.fgColor);
	return S_OK;
}

///	@see	ITokenDecoration::get_ItalicFont
STDMETHODIMP CTokenDecoration::get_ItalicFont(VARIANT_BOOL* pbItalic) {
	VERIFY_POINTER(pbItalic);
	GET_TF();
	*pbItalic = toVariantBoolean(_tf.italic);
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CTokenDecoration::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:
			pVarResult->vt = VT_I4;
			return get_BackgroundColor(&pVarResult->lVal);
		case DISPID_TOKENDECORATION_BOLDFONT:
			pVarResult->vt = VT_BOOL;
			return get_BoldFont(&pVarResult->boolVal);
		case DISPID_TOKENDECORATION_COLOR:
			pVarResult->vt = VT_I4;
			return get_Color(&pVarResult->lVal);
		case DISPID_TOKENDECORATION_ITALICFONT:
			pVarResult->vt = VT_BOOL;
			return get_ItalicFont(&pVarResult->boolVal);
		case DISPID_TOKENDECORATION_BORDERSTYLE:
			pVarResult->vt = VT_INT;
			return get_BorderStyle(reinterpret_cast<AmbientBorderType*>(&pVarResult->intVal));
		case DISPID_TOKENDECORATION_BORDERCOLOR:
			pVarResult->vt = VT_I4;
			return get_BorderColor(&pVarResult->lVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_TOKENDECORATION_BACKGROUNDCOLOR:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_BackgroundColor(args[0].lVal);
		case DISPID_TOKENDECORATION_BOLDFONT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_BoldFont(args[0].boolVal);
		case DISPID_TOKENDECORATION_COLOR:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_Color(args[0].lVal);
		case DISPID_TOKENDECORATION_ITALICFONT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_ItalicFont(args[0].boolVal);
		case DISPID_TOKENDECORATION_BORDERSTYLE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_BorderStyle(static_cast<AmbientBorderType>(args[0].intVal));
		case DISPID_TOKENDECORATION_BORDERCOLOR:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return put_BorderColor(args[0].lVal);
		}
	}
	return hr;
}

///	@see	ITokenDecoration::put_BackgroundColor
STDMETHODIMP CTokenDecoration::put_BackgroundColor(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.bgColor) {
		_tf.bgColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BoldFont
STDMETHODIMP CTokenDecoration::put_BoldFont(VARIANT_BOOL bBold) {
	GET_TF();
	if(_tf.bold != toBoolean(bBold)) {
		_tf.bold = toBoolean(bBold);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderColor
STDMETHODIMP CTokenDecoration::put_BorderColor(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.borderColor) {
		_tf.borderColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_BorderStyle
STDMETHODIMP CTokenDecoration::put_BorderStyle(AmbientBorderType borderType) {
	GET_TF();
	if(_tf.border != static_cast<BorderType>(borderType)) {
		_tf.border = static_cast<BorderType>(borderType);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_Color
STDMETHODIMP CTokenDecoration::put_Color(long nColor) {
	GET_TF();
	const COLORREF	clr = ScriptRGBToWinRGB(nColor);

	if(clr != _tf.fgColor) {
		_tf.fgColor = clr;
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

///	@see	ITokenDecoration::put_ItalicFont
STDMETHODIMP CTokenDecoration::put_ItalicFont(VARIANT_BOOL bItalic) {
	GET_TF();
	if(_tf.italic != toBoolean(bItalic)) {
		_tf.italic = toBoolean(bItalic);
		m_view.SetTextFoundation(m_nTokenType, m_nTokenCookie, _tf);
	}
	return S_OK;
}

#undef GET_TF


// CAutomationTextSearcher class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutomationTextSearcher::CAutomationTextSearcher(CAlphaEditController& editor) : m_editor(editor) {
}

///	@see	ITextSearcher::BookmarkAll
STDMETHODIMP CAutomationTextSearcher::BookmarkAll(long* pcFound) {
	VERIFY_POINTER(pcFound);
	*pcFound = m_editor.GetActiveView()->BookmarkAll();
	return S_OK;
}

///	@see	ITextSearcher::FindNext
STDMETHODIMP CAutomationTextSearcher::FindNext(VARIANT_BOOL* pbFound) {
	VERIFY_POINTER(pbFound);
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();
	flags &= ~SF_BACKWARD;
	m_editor.GetActiveView()->SetSearchFlags(flags);
	*pbFound = toVariantBoolean(m_editor.GetActiveView()->FindNext());
	return S_OK;
}

///	@see	ITextSearcher::FindPrev
STDMETHODIMP CAutomationTextSearcher::FindPrev(VARIANT_BOOL* pbFound) {
	VERIFY_POINTER(pbFound);
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();
	flags |= SF_BACKWARD;
	m_editor.GetActiveView()->SetSearchFlags(flags);
	*pbFound = toVariantBoolean(m_editor.GetActiveView()->FindNext());
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreCase
STDMETHODIMP CAutomationTextSearcher::get_IgnoreCase(AmbientCaseFoldingType* pCaseFoldingType) {
	VERIFY_POINTER(pCaseFoldingType);
	const SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();

	switch(flags & SF_MATCHCASE_MASK) {
	case SF_MATCH_CASE:			*pCaseFoldingType = ACFT_MATCH_CASE;				break;
	case SF_IGNORE_CASE_ASCII:	*pCaseFoldingType = ACFT_IGNORE_ASCII_ALPHABETS;	break;
	case SF_IGNORE_CASE_SIMPLE:	*pCaseFoldingType = ACFT_UNICODE_SIMPLE;			break;
	case SF_IGNORE_CASE_FULL:	*pCaseFoldingType = ACFT_UNICODE_FULL;				break;
	}
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreControls
STDMETHODIMP CAutomationTextSearcher::get_IgnoreControls(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_CONTROLS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreDiacritics
STDMETHODIMP CAutomationTextSearcher::get_IgnoreDiacritics(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_DIACRITICS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreDigitScript
STDMETHODIMP CAutomationTextSearcher::get_IgnoreDigitScript(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_DIGITTYPE);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreKashida
STDMETHODIMP CAutomationTextSearcher::get_IgnoreKashida(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_KASHIDA);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnorePunctuations
STDMETHODIMP CAutomationTextSearcher::get_IgnorePunctuations(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_PUNCTUATIONS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreSymbols
STDMETHODIMP CAutomationTextSearcher::get_IgnoreSymbols(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_SYMBOLS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreVowels
STDMETHODIMP CAutomationTextSearcher::get_IgnoreVowels(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_VOWELS);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreWhitespaces
STDMETHODIMP CAutomationTextSearcher::get_IgnoreWhitespaces(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_WHITESPACES);
	return S_OK;
}

///	@see	ITextSearcher::get_IgnoreWidth
STDMETHODIMP CAutomationTextSearcher::get_IgnoreWidth(VARIANT_BOOL* pbIgnore) {
	VERIFY_POINTER(pbIgnore);
	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_IGNORE_WIDTH);
	return S_OK;
}

///	@see	ITextSearcher::get_OnlyIdentifier
STDMETHODIMP CAutomationTextSearcher::get_OnlyIdentifiers(VARIANT_BOOL* pbOnlyIdentifiers) {
	VERIFY_POINTER(pbOnlyIdentifiers);
//	*pbIgnore = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_ONLYIDENTIFIERS);
//	return S_OK;
	return E_NOTIMPL;
}

///	@see	ITextSearcher::get_UseRegularExpression
STDMETHODIMP CAutomationTextSearcher::get_UseRegularExpression(VARIANT_BOOL* pbUseRegExp) {
	VERIFY_POINTER(pbUseRegExp);
	*pbUseRegExp = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_REGEXP);
	return S_OK;
}

///	@see	ITextSearcher::get_WholeWord
STDMETHODIMP CAutomationTextSearcher::get_WholeWord(VARIANT_BOOL* pbWholeWord) {
	VERIFY_POINTER(pbWholeWord);
	*pbWholeWord = toVariantBoolean(m_editor.GetActiveView()->GetSearchFlags() & SF_WHOLEWORD);
	return S_OK;
}

///	@see	ITextSearcher::Invoke
STDMETHODIMP CAutomationTextSearcher::Invoke(DISPID dispidMember, REFIID riid, LCID lcid,
		WORD wFlags, DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	bool			bCreatedResult = false;
	CComVariant		args[1];

#define IMPLEMENT_BOOLEAN_GETTER(name)	\
	pVarResult->vt = VT_BOOL;			\
	return get_##name(&pVarResult->boolVal);

#define IMPLEMENT_BOOLEAN_PUTTER(name)	\
	VERIFY_ARGUMENTS_COUNT(1);			\
	COERCE_ARGUMENT_AT(0, VT_BOOL);		\
	return put_##name(args[0].boolVal);

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_IGNORECASE:
			pVarResult->vt = VT_INT;
			return get_IgnoreCase(reinterpret_cast<AmbientCaseFoldingType*>(&pVarResult->intVal));
		case DISPID_TEXTSEARCHER_IGNORECONTROLS:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreControls);
		case DISPID_TEXTSEARCHER_IGNOREDIACRITICS:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreDiacritics);
		case DISPID_TEXTSEARCHER_IGNOREDIGITSCRIPT:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreDigitScript);
		case DISPID_TEXTSEARCHER_IGNOREKASHIDA:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreKashida);
		case DISPID_TEXTSEARCHER_IGNOREPUNCTUATIONS:
			IMPLEMENT_BOOLEAN_GETTER(IgnorePunctuations);
		case DISPID_TEXTSEARCHER_IGNORESYMBOLS:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreSymbols);
		case DISPID_TEXTSEARCHER_IGNOREVOWELS:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreVowels);
		case DISPID_TEXTSEARCHER_IGNOREWHITESPACES:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreWhitespaces);
		case DISPID_TEXTSEARCHER_IGNOREWIDTH:
			IMPLEMENT_BOOLEAN_GETTER(IgnoreWidth);
		case DISPID_TEXTSEARCHER_ONLYIDENTIFIERS:
			IMPLEMENT_BOOLEAN_GETTER(OnlyIdentifiers);
		case DISPID_TEXTSEARCHER_USEREGULAREXPRESSION:
			IMPLEMENT_BOOLEAN_GETTER(UseRegularExpression);
		case DISPID_TEXTSEARCHER_WHOLEWORD:
			IMPLEMENT_BOOLEAN_GETTER(WholeWord);
		}
	} else if(toBoolean(wFlags & DISPATCH_PROPERTYPUT)) {	// vb^
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_FINDWHAT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_FindWhat(args[0].bstrVal);
		case DISPID_TEXTSEARCHER_IGNORECASE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_INT);
			return put_IgnoreCase(static_cast<AmbientCaseFoldingType>(args[0].intVal));
		case DISPID_TEXTSEARCHER_IGNORECONTROLS:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreControls);
		case DISPID_TEXTSEARCHER_IGNOREDIACRITICS:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreDiacritics);
		case DISPID_TEXTSEARCHER_IGNOREDIGITSCRIPT:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreDigitScript);
		case DISPID_TEXTSEARCHER_IGNOREKASHIDA:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreKashida);
		case DISPID_TEXTSEARCHER_IGNOREPUNCTUATIONS:
			IMPLEMENT_BOOLEAN_PUTTER(IgnorePunctuations);
		case DISPID_TEXTSEARCHER_IGNORESYMBOLS:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreSymbols);
		case DISPID_TEXTSEARCHER_IGNOREVOWELS:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreVowels);
		case DISPID_TEXTSEARCHER_IGNOREWHITESPACES:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreWhitespaces);
		case DISPID_TEXTSEARCHER_IGNOREWIDTH:
			IMPLEMENT_BOOLEAN_PUTTER(IgnoreWidth);
		case DISPID_TEXTSEARCHER_ONLYIDENTIFIERS:
			IMPLEMENT_BOOLEAN_PUTTER(OnlyIdentifiers);
		case DISPID_TEXTSEARCHER_USEREGULAREXPRESSION:
			IMPLEMENT_BOOLEAN_PUTTER(UseRegularExpression);
		case DISPID_TEXTSEARCHER_WHOLEWORD:
			IMPLEMENT_BOOLEAN_PUTTER(WholeWord);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_TEXTSEARCHER_BOOKMARKALL:
			VERIFY_ARGUMENTS_COUNT(0);
			pVarResult->vt = VT_I4;
			return BookmarkAll(&pVarResult->lVal);
		case DISPID_TEXTSEARCHER_FINDNEXT:
			VERIFY_ARGUMENTS_COUNT(0);
			pVarResult->vt = VT_BOOL;
			return FindNext(&pVarResult->boolVal);
		case DISPID_TEXTSEARCHER_FINDPREV:
			VERIFY_ARGUMENTS_COUNT(0);
			pVarResult->vt = VT_BOOL;
			return FindPrev(&pVarResult->boolVal);
		case DISPID_TEXTSEARCHER_REPLACEANDNEXT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_BOOL;
			return ReplaceAndNext(args[0].bstrVal, &pVarResult->boolVal);
		case DISPID_TEXTSEARCHER_REPLACEANDPREV:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_BOOL;
			return ReplaceAndPrev(args[0].bstrVal, &pVarResult->boolVal);
		}
	}
	return hr;

#undef IMPLEMENT_BOOLEAN_GETTER
#undef IMPLEMENT_BOOLEAN_PUTTER
}

///	@see	ITextSearcher::put_FindWhat
STDMETHODIMP CAutomationTextSearcher::put_FindWhat(BSTR bstrFindWhat) {
	if(bstrFindWhat == 0)
		return E_INVALIDARG;
	m_editor.GetActiveView()->SetSearchText(bstrFindWhat);
	return S_OK;
}

///	@see	ITextSearcher::put_IgnoreCase
STDMETHODIMP CAutomationTextSearcher::put_IgnoreCase(AmbientCaseFoldingType caseFoldingType) {
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();

	flags &= ~ SF_MATCHCASE_MASK;
	switch(caseFoldingType) {
	case ACFT_MATCH_CASE:				flags |= SF_MATCH_CASE;			break;
	case ACFT_IGNORE_ASCII_ALPHABETS:	flags |= SF_IGNORE_CASE_ASCII;	break;
	case ACFT_UNICODE_SIMPLE:			flags |= SF_IGNORE_CASE_SIMPLE;	break;
	case ACFT_UNICODE_FULL:				flags |= SF_IGNORE_CASE_FULL;	break;
	default:							return E_INVALIDARG;
	}
	m_editor.GetActiveView()->SetSearchFlags(flags);
	return S_OK;
}

#define SET_SEARCH_OPTION_(bit, value)								\
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();	\
	flags &= ~(bit);												\
	if(toBoolean(value))											\
		flags |= (bit);												\
	m_editor.GetActiveView()->SetSearchFlags(flags);				\
	return S_OK;

#define SET_SEARCH_OPTION(bit)	SET_SEARCH_OPTION_(bit, bIgnore)

///	@see	ITextSearcher::put_IgnoreControls
STDMETHODIMP CAutomationTextSearcher::put_IgnoreControls(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_CONTROLS);
}

///	@see	ITextSearcher::put_IgnoreDiacritics
STDMETHODIMP CAutomationTextSearcher::put_IgnoreDiacritics(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_DIACRITICS);
}

///	@see	ITextSearcher::put_IgnoreDigitScript
STDMETHODIMP CAutomationTextSearcher::put_IgnoreDigitScript(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_DIGITTYPE);
}

///	@see	ITextSearcher::put_IgnoreKashida
STDMETHODIMP CAutomationTextSearcher::put_IgnoreKashida(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_KASHIDA);
}

///	@see	ITextSearcher::put_IgnorePunctuations
STDMETHODIMP CAutomationTextSearcher::put_IgnorePunctuations(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_PUNCTUATIONS);
}

///	@see	ITextSearcher::put_IgnoreSymbols
STDMETHODIMP CAutomationTextSearcher::put_IgnoreSymbols(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_SYMBOLS);
}

///	@see	ITextSearcher::put_IgnoreVowels
STDMETHODIMP CAutomationTextSearcher::put_IgnoreVowels(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_VOWELS);
}

///	@see	ITextSearcher::put_IgnoreWhitespaces
STDMETHODIMP CAutomationTextSearcher::put_IgnoreWhitespaces(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_WHITESPACES);
}

///	@see	ITextSearcher::put_IgnoreWidth
STDMETHODIMP CAutomationTextSearcher::put_IgnoreWidth(VARIANT_BOOL bIgnore) {
	SET_SEARCH_OPTION(SF_IGNORE_WIDTH);
}

///	@see	ITextSearcher::put_OnlyIdentifiers
STDMETHODIMP CAutomationTextSearcher::put_OnlyIdentifiers(VARIANT_BOOL bOnlyIdentifiers) {
///	SET_SEARCH_OPTION_(SF_ONLYIDENTIFIERS, bOnlyIdentifiers);
	return E_NOTIMPL;
}

///	@see	ITextSearcher::put_UseRegularExpression
STDMETHODIMP CAutomationTextSearcher::put_UseRegularExpression(VARIANT_BOOL bUseRegExp) {
	SET_SEARCH_OPTION_(SF_REGEXP, bUseRegExp);
}

///	@see	ITextSearcher::put_WholeWord
STDMETHODIMP CAutomationTextSearcher::put_WholeWord(VARIANT_BOOL bWholeWord) {
	SET_SEARCH_OPTION_(SF_WHOLEWORD, bWholeWord);
}

///	@see	ITextSearcher::ReplaceAndNext
STDMETHODIMP CAutomationTextSearcher::ReplaceAndNext(BSTR bstrReplaceWith, VARIANT_BOOL* pbFound) {
	VERIFY_POINTER(pbFound);
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();
	flags &= ~SF_BACKWARD;
	m_editor.GetActiveView()->SetSearchFlags(flags);
	return toVariantBoolean(m_editor.GetActiveView()->ReplaceAndFindNext(SAFE_BSTR(bstrReplaceWith)));
}

///	@see	ITextSearcher::ReplaceAndPrev
STDMETHODIMP CAutomationTextSearcher::ReplaceAndPrev(BSTR bstrReplaceWith, VARIANT_BOOL* pbFound) {
	VERIFY_POINTER(pbFound);
	SearchFlag	flags = m_editor.GetActiveView()->GetSearchFlags();
	flags |= SF_BACKWARD;
	m_editor.GetActiveView()->SetSearchFlags(flags);
	return toVariantBoolean(m_editor.GetActiveView()->ReplaceAndFindNext(SAFE_BSTR(bstrReplaceWith)));
}

#undef SET_SEARCH_OPTION


// CConfigurations class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CConfigurations::CConfigurations(CAlphaApp& app) : m_app(app) {
}

///	@see	IConfigurations::AddDocumentType
STDMETHODIMP CConfigurations::AddDocumentType(BSTR bstrName, BSTR bstrFileSpec,
		BSTR bstrCommand /* = 0 */, VARIANT_BOOL bPrivate /* = VARIANT_FALSE */) {
	if(bstrName == 0 || bstrFileSpec == 0 || wcslen(bstrFileSpec) >= MAX_PATH)
		return E_INVALIDARG;

	TDocumentType	type;

	type.strName = bstrName;
	wcscpy(type.wszFileSpec, bstrFileSpec);
	type.strCommand = (bstrCommand != 0) ? bstrCommand : L"";
	type.bPrivate = toBoolean(bPrivate);
	m_app.GetDocumentTypeManager()->Add(type);
	return S_OK;
}

///	@see	IConfigurations::Apply
STDMETHODIMP CConfigurations::Apply() {
	m_app.LoadKeyBinds(L"");
	return S_OK;
}

///	@see	IConfigurations::get__NewEnum
STDMETHODIMP CConfigurations::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IConfigurations::get_KeyboardScheme
STDMETHODIMP CConfigurations::get_KeyboardSchemes(BSTR bstrScopeName, IKeyboardScheme** ppKeyboardScheme) {
	VERIFY_POINTER(ppKeyboardScheme);
	if(bstrScopeName == 0)
		return E_INVALIDARG;
	else if(wcscmp(bstrScopeName, L"basic") != 0)	// ̂Ƃ1
		return E_INVALIDARG;

	*ppKeyboardScheme = new CKeyboardScheme(m_app.GetKeyboardMap());
	if(*ppKeyboardScheme == 0)
		return E_OUTOFMEMORY;
	(*ppKeyboardScheme)->AddRef();
	return S_OK;
}

///	@see	IConfigurations::get_Property
STDMETHODIMP CConfigurations::get_Property(BSTR bstrName, BSTR* pbstrValue) {
	VERIFY_POINTER(pbstrValue);
	if(bstrName == 0)
		return E_INVALIDARG;
	*pbstrValue = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CConfigurations::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[4];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_NEWENUM:
			pVarResult->vt = VT_UNKNOWN;
			return get__NewEnum(&pVarResult->punkVal);
		case DISPID_CONFIGURATIONS_KEYBOARDSCHEMES:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_DISPATCH;
			return get_KeyboardSchemes(args[0].bstrVal,
				reinterpret_cast<IKeyboardScheme**>(&pVarResult->pdispVal));
		case DISPID_CONFIGURATIONS_PROPERTY:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			pVarResult->vt = VT_BSTR;
			return get_Property(args[0].bstrVal, &pVarResult->bstrVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		if(dispidMember == DISPID_CONFIGURATIONS_PROPERTY) {
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return put_Property(args[1].bstrVal, args[0].bstrVal);
		}
	}
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_CONFIGURATIONS_ADDDOCUMENTTYPE:
			if(pDispParams->cArgs == 4) {
				COERCE_ARGUMENT_AT(3, VT_BSTR);
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BOOL);
				return AddDocumentType(args[3].bstrVal, args[2].bstrVal, args[1].bstrVal, args[0].boolVal);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return AddDocumentType(args[2].bstrVal, args[1].bstrVal, args[0].bstrVal);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				return AddDocumentType(args[1].bstrVal, args[0].bstrVal);
			}
				return DISP_E_BADPARAMCOUNT;
		case DISPID_CONFIGURATIONS_APPLY:
			VERIFY_ARGUMENTS_COUNT(0);
			return Apply();
		case DISPID_CONFIGURATIONS_REMOVEALLDOCUMENTTYPES:
			VERIFY_ARGUMENTS_COUNT(0);
			return RemoveAllDocumentTypes();
		}
	}
	return hr;
}

///	@see	IConfigurations::put_Property
STDMETHODIMP CConfigurations::put_Property(BSTR bstrName, BSTR bstrValue) {
	if(bstrName == 0)
		return E_INVALIDARG;

	m_mapModifiedProperties[bstrName] = (bstrValue != 0) ? bstrValue : L"";
	return S_OK;
}

///	@see	IConfigurations::RemoveAllDocumentTypes
STDMETHODIMP CConfigurations::RemoveAllDocumentTypes() {
	m_app.GetDocumentTypeManager()->RemoveAll();
	return S_OK;
}


// CKeyboardScheme class implementation
/////////////////////////////////////////////////////////////////////////////

map<wstring, VirtualKey> CKeyboardScheme::m_mapKeyValues;

///	RXgN^
CKeyboardScheme::CKeyboardScheme(CKeyboardMap& impl) : m_impl(impl) {
}

///	@see	IKeyboardScheme::Assign
STDMETHODIMP CKeyboardScheme::Assign(BSTR bstrKeyCombination, long nCommandId) {
	if(bstrKeyCombination == 0 || wcslen(bstrKeyCombination) > 29)
		return E_INVALIDARG;

	if(CKeyboardScheme::m_mapKeyValues.empty()) {
		wchar_t	wsz[4] = {0, 0, 0, 0};
		CKeyboardScheme::m_mapKeyValues[L"bs"] = VK_BACK;
		CKeyboardScheme::m_mapKeyValues[L"backspace"] = VK_BACK;
		CKeyboardScheme::m_mapKeyValues[L"tab"] = VK_TAB;
		CKeyboardScheme::m_mapKeyValues[L"del"] = VK_CLEAR;
		CKeyboardScheme::m_mapKeyValues[L"delete"] = VK_CLEAR;
		CKeyboardScheme::m_mapKeyValues[L"enter"] = VK_RETURN;
		CKeyboardScheme::m_mapKeyValues[L"esc"] = VK_ESCAPE;
		CKeyboardScheme::m_mapKeyValues[L"escape"] = VK_ESCAPE;
		CKeyboardScheme::m_mapKeyValues[L"sp"] = VK_SPACE;
		CKeyboardScheme::m_mapKeyValues[L"space"] = VK_SPACE;
		CKeyboardScheme::m_mapKeyValues[L"pgup"] = VK_PRIOR;
		CKeyboardScheme::m_mapKeyValues[L"pageup"] = VK_PRIOR;
		CKeyboardScheme::m_mapKeyValues[L"pgdn"] = VK_NEXT;
		CKeyboardScheme::m_mapKeyValues[L"pagedown"] = VK_NEXT;
		CKeyboardScheme::m_mapKeyValues[L"end"] = VK_END;
		CKeyboardScheme::m_mapKeyValues[L"home"] = VK_HOME;
		CKeyboardScheme::m_mapKeyValues[L"left"] = VK_LEFT;
		CKeyboardScheme::m_mapKeyValues[L"up"] = VK_UP;
		CKeyboardScheme::m_mapKeyValues[L"right"] = VK_RIGHT;
		CKeyboardScheme::m_mapKeyValues[L"down"] = VK_DOWN;
		CKeyboardScheme::m_mapKeyValues[L"ins"] = VK_INSERT;
		CKeyboardScheme::m_mapKeyValues[L"insert"] = VK_INSERT;
		for(size_t i = 0; i < 10; ++i) {
			wsz[0] = L'0' + i;
			CKeyboardScheme::m_mapKeyValues[wsz] = '0' + i;
		}
		for(size_t i = 0; i < 26; ++i) {
			wsz[0] = L'a' + i;
			CKeyboardScheme::m_mapKeyValues[wsz] = 'A' + i;
		}
		wsz[0] = L'f';
		for(size_t i = 0; i < 10; ++i) {
			wsz[1] = L'0' + i + 1;
			CKeyboardScheme::m_mapKeyValues[wsz] = VK_F1 + i;
		}
		wsz[1] = L'1';
		for(size_t i = 0; i < 10; ++i) {
			wsz[2] = L'0' + i + 1;
			CKeyboardScheme::m_mapKeyValues[wsz] = VK_F10 + i;
		}
		wsz[1] = L'2';
		for(size_t i = 0; i < 4; ++i) {
			wsz[2] = L'0' + i + 1;
			CKeyboardScheme::m_mapKeyValues[wsz] = VK_F20 + i;
		}
		CKeyboardScheme::m_mapKeyValues[L";"] = VK_OEM_1;
		CKeyboardScheme::m_mapKeyValues[L":"] = VK_OEM_PLUS;
		CKeyboardScheme::m_mapKeyValues[L","] = VK_OEM_COMMA;
		CKeyboardScheme::m_mapKeyValues[L"-"] = VK_OEM_MINUS;
		CKeyboardScheme::m_mapKeyValues[L"."] = VK_OEM_PERIOD;
		CKeyboardScheme::m_mapKeyValues[L"/"] = VK_OEM_2;
		CKeyboardScheme::m_mapKeyValues[L"@"] = VK_OEM_3;
		CKeyboardScheme::m_mapKeyValues[L"["] = VK_OEM_4;
		CKeyboardScheme::m_mapKeyValues[L"\\"] = VK_OEM_5;
		CKeyboardScheme::m_mapKeyValues[L"]"] = VK_OEM_6;
		CKeyboardScheme::m_mapKeyValues[L"^"] = VK_OEM_7;
	}

	wchar_t		wszKeys[30];
	KeyModifier	modifiers = 0;
	wchar_t*	pwszMainKey = 0;
	wchar_t*	pwszPlus = wszKeys;
	wchar_t*	pwszLast = wszKeys;

	wcscpy(wszKeys, bstrKeyCombination);
	::CharLowerBuffW(wszKeys, wcslen(wszKeys));

	// ͂ŏCL[ƃCL[o
	while(true) {
		pwszPlus = wcschr(pwszLast, L'+');
		if(pwszPlus == 0) {
			pwszMainKey = pwszLast;
			break;
		} else if(pwszPlus == wszKeys) {
			if(wcslen(wszKeys) == 1) {
				pwszMainKey = L"+";
				break;
			}
			return E_INVALIDARG;	// 擪 + 
		}
		if(pwszPlus - pwszLast == 3 && wcsncmp(pwszLast, L"alt", 3) == 0)
			modifiers |= KM_ALT;
		else if(pwszPlus - pwszLast == 4 && wcsncmp(pwszLast, L"ctrl", 4) == 0)
			modifiers |= KM_CTRL;
		else if(pwszPlus - pwszLast == 5 && wcsncmp(pwszLast, L"shift", 4) == 0)
			modifiers |= KM_SHIFT;
		else
			return E_INVALIDARG;	// ȏCL[
		pwszLast = pwszPlus + 1;
	}
	if(pwszMainKey == 0)
		return E_INVALIDARG;	// C̃L[

	// CL[zL[R[hɕϊ
	map<wstring, VirtualKey>::const_iterator	it = CKeyboardScheme::m_mapKeyValues.find(pwszMainKey);
	if(it == CKeyboardScheme::m_mapKeyValues.end())
		return E_INVALIDARG;	// CL[Ȃ

	try {
		m_impl.SetOneCommand(it->second, modifiers, static_cast<CommandId>(nCommandId));
	} catch(out_of_range) {
		return E_FAIL;	// Ǝv
	}
	return S_OK;
}

///	@see	IKeyboardScheme::CopyAllMaps
STDMETHODIMP CKeyboardScheme::CopyAllMaps() {
	return E_NOTIMPL;
}

///	@see	IKeyboardScheme::get_Name
STDMETHODIMP CKeyboardScheme::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);
	*pbstrName = ::SysAllocString(m_strSchemeName.c_str());
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CKeyboardScheme::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[2];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {
		if(dispidMember == DISPID_KEYBOARDSCHEME_NAME) {
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {
		switch(dispidMember) {
		case DISPID_KEYBOARDSCHEME_ASSIGN:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return Assign(args[1].bstrVal, args[0].lVal);
		case DISPID_KEYBOARDSCHEME_COPYALLMAPS:
			VERIFY_ARGUMENTS_COUNT(0);
			return CopyAllMaps();
		case DISPID_KEYBOARDSCHEME_LOAD:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return Load(args[0].bstrVal);
		case DISPID_KEYBOARDSCHEME_SAVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return Save(args[0].bstrVal);
		}
	}
	return hr;
}

///	@see	IKeyboardScheme::Load
STDMETHODIMP CKeyboardScheme::Load(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + wcslen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Load(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}

///	@see	IKeyboardScheme::Save
STDMETHODIMP CKeyboardScheme::Save(BSTR bstrSchemeName) {
	if(bstrSchemeName == 0)
		return E_INVALIDARG;

	wchar_t	wszPath[MAX_PATH];

	::GetModuleFileName(0, wszPath, MAX_PATH);
	wcscpy(::PathFindFileNameW(wszPath), IDS_KEYBOARDSCHEME_DIRECTORY_NAME);
	if(wcslen(wszPath) + wcslen(bstrSchemeName) + 4 >= MAX_PATH)
		return E_INVALIDARG;
	wcscat(wszPath, bstrSchemeName);
	wcscat(wszPath, L".akm");
	if(m_impl.Save(wszPath)) {
		m_strSchemeName = bstrSchemeName;
		return S_OK;
	}
	return E_FAIL;
}


// CAutomationCommand class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[VIuWFNg
 *	@param id	R}hʎq
 */
CAutomationCommand::CAutomationCommand(CAlphaApp& app, CommandId id) : m_app(app), m_id(id) {
}

///	@see	ICommand::Execute
STDMETHODIMP CAutomationCommand::Execute() {
	const_cast<CCommandManager&>(m_app.GetCommandManager()).ExecuteCommand(m_id, false);	// Y
	return S_OK;
}

///	@see	ICommand::get_Checked
STDMETHODIMP CAutomationCommand::get_Checked(VARIANT_BOOL* pbChecked) {
	VERIFY_POINTER(pbChecked);
	*pbChecked = toVariantBoolean(m_app.GetCommandManager().IsChecked(m_id));
	return S_OK;
}

///	@see	ICommand::get_Description
STDMETHODIMP CAutomationCommand::get_Description(BSTR* pbstrDescription) {
	VERIFY_POINTER(pbstrDescription);
	*pbstrDescription = ::SysAllocString(m_app.GetCommandManager().GetDescription(m_id).c_str());
	return S_OK;
}

///	@see	ICommand::get_Enabled
STDMETHODIMP CAutomationCommand::get_Enabled(VARIANT_BOOL* pbEnabled) {
	VERIFY_POINTER(pbEnabled);
	*pbEnabled = toVariantBoolean(m_app.GetCommandManager().IsEnabled(m_id, false));
	return S_OK;
}

///	@see	ICommand::get_KeyCombination
STDMETHODIMP CAutomationCommand::get_KeyCombination(BSTR* pbstrKeys) {
	VERIFY_POINTER(pbstrKeys);
	*pbstrKeys = ::SysAllocString(m_app.GetKeyboardMap().GetKeyString(m_id).c_str());
	return S_OK;
}

///	@see	ICommand::get_Name
STDMETHODIMP CAutomationCommand::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wstring	strName = m_app.GetCommandManager().GetCaption(m_id);
	size_t	i = strName.find(L'(');

	if(i != wstring::npos) {
		strName = strName.substr(0, i);
		i = strName.find(L'&');
		if(i != wstring::npos)
			strName.erase(i, 1);
	}
	*pbstrName = ::SysAllocString(strName.c_str());
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationCommand::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
//	CComVariant		args[3];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_COMMAND_CHECKED:
			pVarResult->vt = VT_BOOL;
			return get_Checked(&pVarResult->boolVal);
		case DISPID_COMMAND_DESCRIPTION:
			pVarResult->vt = VT_BSTR;
			return get_Description(&pVarResult->bstrVal);
		case DISPID_COMMAND_ENABLED:
			pVarResult->vt = VT_BOOL;
			return get_Enabled(&pVarResult->boolVal);
		case DISPID_COMMAND_KEYCOMBINATION:
			pVarResult->vt = VT_BSTR;
			return get_KeyCombination(&pVarResult->bstrVal);
		case DISPID_COMMAND_NAME:
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		if(dispidMember == DISPID_COMMAND_EXECUTE) {
			VERIFY_ARGUMENTS_COUNT(0);
			return Execute();
		}
	}
	return hr;
}


// CAutomationClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutomationClipboardRing::CAutomationClipboardRing(CClipboardRing& impl) : m_impl(impl) {
}

///	@see	IClipboardRing::Add
STDMETHODIMP CAutomationClipboardRing::Add(BSTR bstrText) {
	if(bstrText == 0)
		return E_INVALIDARG;
	m_impl.Add(bstrText, false);
	return S_OK;
}

///	@see	IClipboardRing::Delete
STDMETHODIMP CAutomationClipboardRing::Delete(short nIndex) {
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;
	try {
		m_impl.Delete(static_cast<unsigned char>(nIndex));
	} catch(...) {
		return E_INVALIDARG;
	}
	return S_OK;
}

///	@see	IClipboardRing::DeleteAll
STDMETHODIMP CAutomationClipboardRing::DeleteAll() {
	m_impl.DeleteAll();
	return S_OK;
}

///	@see	IClipboardRing::get_Count
STDMETHODIMP CAutomationClipboardRing::get_Count(short* pnCount) {
	VERIFY_POINTER(pnCount);
	*pnCount = m_impl.GetCount();
	return S_OK;
}

///	@see	IClipboardRing::get_Text
STDMETHODIMP CAutomationClipboardRing::get_Text(short nIndex, BSTR* pbstrText) {
	VERIFY_POINTER(pbstrText);
	if(nIndex < 0 || nIndex > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;

	wstring	str;
	bool	b;

	try {
		m_impl.GetText(static_cast<unsigned char>(nIndex), str, b);
	} catch(...) {
		return E_INVALIDARG;
	}
	*pbstrText = ::SysAllocString(str.c_str());
	return S_OK;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CAutomationClipboardRing::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	CComVariant		args[1];

	if(toBoolean(wFlags & DISPATCH_PROPERTYGET)) {	// Qb^
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_COUNT:
			COERCE_RETURN(VT_I2);
			return get_Count(&pVarResult->iVal);
		case DISPID_CLIPBOARDRING_TEXT:
			COERCE_RETURN(VT_BSTR);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return get_Text(args[0].iVal, &pVarResult->bstrVal);
		}
	}
	if(toBoolean(wFlags & DISPATCH_METHOD)) {	// \bh
		switch(dispidMember) {
		case DISPID_CLIPBOARDRING_ADD:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return Add(args[0].bstrVal);
		case DISPID_CLIPBOARDRING_DELETE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return Delete(args[0].iVal);
		case DISPID_CLIPBOARDRING_DELETEALL:
			VERIFY_ARGUMENTS_COUNT(0);
			return DeleteAll();
		case DISPID_CLIPBOARDRING_LIMITCOUNT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I2);
			return LimitCount(args[0].iVal);
		}
	}
	return hr;
}

///	@see	IClipboardRing::LimitCount
STDMETHODIMP CAutomationClipboardRing::LimitCount(short nLimit) {
	if(nLimit < 0 || nLimit > numeric_limits<unsigned char>::max())
		return E_INVALIDARG;
	m_impl.LimitCount(static_cast<unsigned char>(nLimit));
	return S_OK;
}


// CScriptHost class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CScriptHost::CScriptHost(CAlphaScriptHost* pImpl) : m_pImpl(pImpl) {
	assert(m_pImpl != 0);
	m_pImpl->AddRef();
}

///	fXgN^
CScriptHost::~CScriptHost() {
	m_pImpl->Release();
}

///	@see	IScriptHost::ConnectObject
STDMETHODIMP CScriptHost::ConnectObject(IDispatch* pObject, BSTR bstrPrefix) {
	VERIFY_POINTER(pObject);
	if(bstrPrefix == 0)
		return E_INVALIDARG;

	try {
		HRESULT	hr;
		if(FAILED(hr = m_pImpl->ConnectObject(pObject, bstrPrefix)))
			throw CComException(hr, IID_IScriptHost,
				OLESTR("Alpha.Ambient.CScriptHost.ConnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::CreateObject
STDMETHODIMP CScriptHost::CreateObject(
		BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;
	*ppObject = 0;
	if(bstrProgId == 0)
		return E_INVALIDARG;

	CLSID	clsidObject;
	HRESULT	hr;

	try {
		if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsidObject)))
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.CreateObject"));
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsidObject)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.CreateObject"));
		}
		if(FAILED(hr = ::CoCreateInstance(clsidObject, 0,
				CLSCTX_ALL, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.CreateObject"));
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsidObject)) {
		(*ppObject)->Release();
		*ppObject = 0;
		return 0x800A01AD;
	}
	return (bstrPrefix == 0) ? S_OK : ConnectObject(*ppObject, bstrPrefix);
}

///	@see	IScriptHost::DisconnectObject
STDMETHODIMP CScriptHost::DisconnectObject(IDispatch* pObject) {
	VERIFY_POINTER(pObject);

	try {
		HRESULT	hr;
		if(FAILED(hr = m_pImpl->DisconnectObject(pObject)))
			throw CComException(hr, IID_IScriptHost,
				OLESTR("Alpha.Ambient.CScriptHost.DisconnectObject"));
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return e.GetSCode();
	}
	return S_OK;
}

///	@see	IScriptHost::Echo
STDMETHODIMP CScriptHost::Echo(SAFEARRAY* parr) {
	if(parr == 0 || parr->cDims != 1)
		return E_INVALIDARG;
	if(!m_pImpl->IsInteractive())
		return S_OK;

	wstring	strText;
	long	nUBound;
	BSTR*	pbstrArgs = reinterpret_cast<BSTR*>(parr->pvData);
	HWND	hWnd;

	::SafeArrayGetUBound(parr, 1, &nUBound);
	for(long i = 0; i <= nUBound; ++i) {
		strText += (pbstrArgs[i] != 0) ? pbstrArgs[i] : L"";
		if(i != nUBound)
			strText += L" ";
	}
	m_pImpl->GetWindow(&hWnd);
	::MessageBoxW(hWnd, strText.c_str(), CAlphaScriptHost::m_pwszName, 0);
	return S_OK;
}

///	@see	IScriptHost::get_Arguments
STDMETHODIMP CScriptHost::get_Arguments(IArguments** ppArguments) {
	VERIFY_POINTER(ppArguments);

	vector<wstring>	vecArgs;
	*ppArguments = new CArguments(vecArgs);
	if(*ppArguments == 0)
		return E_OUTOFMEMORY;
	(*ppArguments)->AddRef();
	return S_OK;
}

///	@see	IScriptHost::get_BuildVersion
STDMETHODIMP CScriptHost::get_BuildVersion(short* pnBuildVersion) {
	VERIFY_POINTER(pnBuildVersion);
	*pnBuildVersion = CAlphaScriptHost::m_nBuildVersion;
	return S_OK;
}

///	@see	IScriptHost::get_FullName
STDMETHODIMP CScriptHost::get_FullName(BSTR* pbstrFullName) {
	VERIFY_POINTER(pbstrFullName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrFullName = ::SysAllocString(wszPath);
	return S_OK;
}

///	@see	IScriptHost::get_Interactive
STDMETHODIMP CScriptHost::get_Interactive(VARIANT_BOOL* pbInteractive) {
	VERIFY_POINTER(pbInteractive);
	*pbInteractive = toVariantBoolean(m_pImpl->IsInteractive());
	return S_OK;
}

///	@see	IScriptHost::get_Name
STDMETHODIMP CScriptHost::get_Name(BSTR* pbstrName) {
	VERIFY_POINTER(pbstrName);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrName = ::SysAllocString(::PathFindFileNameW(wszPath));
	return S_OK;
}

///	@see	IScriptHost::get_Path
STDMETHODIMP CScriptHost::get_Path(BSTR* pbstrPath) {
	VERIFY_POINTER(pbstrPath);

	wchar_t	wszPath[MAX_PATH];
	::GetModuleFileNameW(0, wszPath, MAX_PATH);
	*pbstrPath = ::SysAllocStringLen(wszPath, wszPath - ::PathFindFileNameW(wszPath) - 1);
	return S_OK;
}

///	@see	IScriptHost::get_ScriptFullName
STDMETHODIMP CScriptHost::get_ScriptFullName(BSTR* pbstrScriptFullName) {
	VERIFY_POINTER(pbstrScriptFullName);
	*pbstrScriptFullName = ::SysAllocString(m_pImpl->GetScriptPath().c_str());
	return S_OK;
}

///	@see	IScriptHost::get_ScriptName
STDMETHODIMP CScriptHost::get_ScriptName(BSTR* pbstrScriptName) {
	VERIFY_POINTER(pbstrScriptName);
	*pbstrScriptName = ::SysAllocString(::PathFindFileNameW(m_pImpl->GetScriptPath().c_str()));
	return S_OK;
}

///	@see	IScriptHost::get_StdErr
STDMETHODIMP CScriptHost::get_StdErr(IDispatch** ppStdErr) {
	VERIFY_POINTER(ppStdErr);
	*ppStdErr = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdIn
STDMETHODIMP CScriptHost::get_StdIn(IDispatch** ppStdIn) {
	VERIFY_POINTER(ppStdIn);
	*ppStdIn = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_StdOut
STDMETHODIMP CScriptHost::get_StdOut(IDispatch** ppStdOut) {
	VERIFY_POINTER(ppStdOut);
	*ppStdOut = 0;
	return E_NOTIMPL;
}

///	@see	IScriptHost::get_Timeout
STDMETHODIMP CScriptHost::get_Timeout(long* pnMilliseconds) {
	VERIFY_POINTER(pnMilliseconds);
	*pnMilliseconds = static_cast<long>(m_pImpl->GetTimeout());
	return S_OK;
}

///	@see	IScriptHost::get_Version
STDMETHODIMP CScriptHost::get_Version(BSTR* pbstrVersion) {
	VERIFY_POINTER(pbstrVersion);

	wchar_t	wszVersion[10];
	swprintf(wszVersion, L"%u.%u",
		CAlphaScriptHost::m_nMajorVersion, CAlphaScriptHost::m_nMinorVersion);
	*pbstrVersion = ::SysAllocString(wszVersion);
	return S_OK;
}

///	@see	IScriptHost::GetObject
STDMETHODIMP CScriptHost::GetObject(
		BSTR bstrPathName, BSTR bstrProgId, BSTR bstrPrefix, IDispatch** ppObject) {
	if(ppObject == 0)
		return S_OK;

	HRESULT	hr = S_OK;
	CLSID	clsid = CLSID_NULL;

	*ppObject = 0;
	try {
		if(bstrProgId != 0) {
			if(FAILED(hr = ::CLSIDFromProgID(bstrProgId, &clsid)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.GetObject"));
		}
		if(URLPOLICY_ALLOW != VerifyCreationObject(clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		e.ThrowLogicalThreadError();
		return hr;
	}

	try {
		if(bstrProgId == 0) {
			if(FAILED(hr = ::CoGetObject(bstrPathName, 0, IID_IDispatch, reinterpret_cast<void**>(ppObject))))
				throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.GetObject"));
		} else {	// GetInstanceFromFile g
			MULTI_QI	mq = {&IID_IDispatch, 0, 0};

			if(FAILED(hr = ::CoGetInstanceFromFile(0, &clsid, 0,
					CLSCTX_ALL, STGM_READWRITE, bstrPathName, 1, &mq)))
				throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.GetObject"));
			hr = mq.pItf->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(ppObject));
		}
		if(URLPOLICY_ALLOW != VerifyRunningObject(*ppObject, clsid)) {
			hr = 0x800A01AD;
			throw CComException(hr, IID_IScriptHost, OLESTR("Alpha.Ambient.CScriptHost.GetObject"));
		}
	} catch(CComException& e) {
		*ppObject = 0;
		e.ThrowLogicalThreadError();
		return hr;
	}
	return hr;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CScriptHost::Invoke(
		DISPID dispidMember, REFIID riid, LCID lcid, WORD wFlags,
		DISPPARAMS* pDispParams, VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT			hr = DISP_E_MEMBERNOTFOUND;
	SAFEARRAY*		pArray = 0;
	BSTR*			arrBstrArgs = 0;
	unsigned int	iArgs;
	bool			bCreatedResult = false;
	CComVariant		args[3];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_ARGUMENTS:
			pVarResult->vt = VT_DISPATCH;
			return get_Arguments(reinterpret_cast<IArguments**>(&pVarResult->pdispVal));
		case DISPID_SCRIPTHOST_BUILDVERSION:
			pVarResult->vt = VT_I2;
			return get_BuildVersion(&pVarResult->iVal);
		case DISPID_SCRIPTHOST_FULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_FullName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_INTERACTIVE:
			pVarResult->vt = VT_BOOL;
			return get_Interactive(&pVarResult->boolVal);
		case DISPID_SCRIPTHOST_NAME:
			pVarResult->vt = VT_BSTR;
			return get_Name(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_SCRIPTFULLNAME:
			pVarResult->vt = VT_BSTR;
			return get_ScriptFullName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_SCRIPTNAME:
			pVarResult->vt = VT_BSTR;
			return get_ScriptName(&pVarResult->bstrVal);
		case DISPID_SCRIPTHOST_STDERR:
			pVarResult->vt = VT_DISPATCH;
			return get_StdErr(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_STDIN:
			pVarResult->vt = VT_DISPATCH;
			return get_StdIn(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_STDOUT:
			pVarResult->vt = VT_DISPATCH;
			return get_StdOut(&pVarResult->pdispVal);
		case DISPID_SCRIPTHOST_TIMEOUT:
			pVarResult->vt = VT_I4;
			return get_Timeout(&pVarResult->lVal);
		case DISPID_SCRIPTHOST_VERSION:
			pVarResult->vt = VT_BSTR;
			return get_Version(&pVarResult->bstrVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT) {	// vb^
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_INTERACTIVE:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_BOOL);
			return put_Interactive(args[0].boolVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
			;
	if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_SCRIPTHOST_CONNECTOBJECT:
			VERIFY_ARGUMENTS_COUNT(2);
			COERCE_ARGUMENT_AT(1, VT_DISPATCH);
			COERCE_ARGUMENT_AT(0, VT_BSTR);
			return ConnectObject(args[1].pdispVal, args[0].bstrVal);
		case DISPID_SCRIPTHOST_CREATEOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[0].bstrVal, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = CreateObject(args[1].bstrVal, args[0].bstrVal,
						(pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return S_OK;
		case DISPID_SCRIPTHOST_DISCONNECTOBJECT:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_DISPATCH);
			return DisconnectObject(args[0].pdispVal);
		case DISPID_SCRIPTHOST_ECHO:
			if(pDispParams->cArgs == 1 && pDispParams->rgvarg[0].vt == VT_SAFEARRAY)
				return Echo(pDispParams->rgvarg[0].parray);
			else {
				pArray = ::SafeArrayCreateVector(VT_BSTR, 0, pDispParams->cArgs);
				::SafeArrayAccessData(pArray, reinterpret_cast<void**>(&arrBstrArgs));
				for(iArgs = 0; iArgs < pDispParams->cArgs; ++iArgs) {
					hr = ::DispGetParam(pDispParams, iArgs, VT_BSTR, &args[0], puArgErr);
					if(FAILED(hr)) {
						::SafeArrayUnaccessData(pArray);
						::SafeArrayDestroy(pArray);
						return hr;
					}
					arrBstrArgs[iArgs] = ::SysAllocString(args[0].bstrVal);
				}
				::SafeArrayUnaccessData(pArray);
				hr = Echo(pArray);
				::SafeArrayDestroy(pArray);
				return hr;
			}
		case DISPID_SCRIPTHOST_GETOBJECT:
			COERCE_RETURN(VT_DISPATCH);
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[0].bstrVal, 0, 0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 2) {
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[1].bstrVal, args[0].bstrVal,
						0, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else if(pDispParams->cArgs == 3) {
				COERCE_ARGUMENT_AT(2, VT_BSTR);
				COERCE_ARGUMENT_AT(1, VT_BSTR);
				COERCE_ARGUMENT_AT(0, VT_BSTR);
				hr = GetObject(args[2].bstrVal, args[1].bstrVal,
						args[0].bstrVal, (pVarResult != 0) ? &pVarResult->pdispVal : 0);
			} else
				return DISP_E_BADPARAMCOUNT;
			if(FAILED(hr))
				RETURN_WITH_EXCEPTION();
			return hr;
		case DISPID_SCRIPTHOST_QUIT:
			if(pDispParams->cArgs == 1) {
				COERCE_ARGUMENT_AT(0, VT_I2);
				return Quit(args[0].iVal);
			} else if(pDispParams->cArgs == 0)
				return Quit();
			else
				return DISP_E_BADPARAMCOUNT;
		case DISPID_SCRIPTHOST_SLEEP:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			return Sleep(args[0].lVal);
		default:
			return DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IScriptHost::put_Interactive
STDMETHODIMP CScriptHost::put_Interactive(VARIANT_BOOL bInteractive) {
	m_pImpl->SetInteractiveMode(toBoolean(bInteractive));
	return S_OK;
}

///	@see	IScriptHost::Quit
STDMETHODIMP CScriptHost::Quit(short nExitCode /* = 0 */) {
	IActiveScript*	pScriptEngine = 0;
	EXCEPINFO		ei;

	m_pImpl->GetScriptEngine(pScriptEngine);
	ZeroMemory(&ei, sizeof(EXCEPINFO));
	HRESULT	hr = pScriptEngine->InterruptScriptThread(SCRIPTTHREADID_ALL, &ei, 0);
	pScriptEngine->Release();
	return hr;
}

///	@see	IScriptHost::Sleep
STDMETHODIMP CScriptHost::Sleep(long nMilliseconds) {
	if(nMilliseconds < 0)
		return E_INVALIDARG;
	m_pImpl->Sleep(static_cast<unsigned long>(nMilliseconds));
	return S_OK;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param clsid	쐬悤ƂĂIuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyCreationObject(CLSID& clsid) {
	IActiveScript*			pScriptEngine = 0;
	CComPtr<IObjectSafety>	pObjectSafety;
	DWORD					dwSupportedOpts, dwEnabledOpts;

	m_pImpl->GetScriptEngine(pScriptEngine);
	if(FAILED(pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety)))) {
		pScriptEngine->Release();
		return URLPOLICY_DISALLOW;
	}
	pScriptEngine->Release();
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pImpl->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD	dwPolicy;
		if(FAILED(pSecurityManager->ProcessUrlAction(URLACTION_ACTIVEX_RUN,
				reinterpret_cast<BYTE*>(&dwPolicy), sizeof(DWORD),
				reinterpret_cast<BYTE*>(&clsid), sizeof(CLSID), 0, 0)))
			return URLPOLICY_DISALLOW;
		return dwPolicy;
	} else
		return toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW : URLPOLICY_ALLOW;
}

/**
 *	ActiveX IuWFNg̍쐬\zXgɖ₢킹
 *	@param pUnk		IuWFNg
 *	@param clsid	IuWFNg CLSID
 *	@return			|V[
 */
DWORD CScriptHost::VerifyRunningObject(IUnknown* pUnk, CLSID& clsid) {
/*	CComPtr<IActiveScriptSite>	pScriptHost;
	CComPtr<IObjectSafety>		pObjectSafety;
	DWORD						dwSupportedOpts, dwEnabledOpts;

	if(FAILED(m_pScriptEngine->QueryInterface(IID_IObjectSafety, reinterpret_cast<void**>(&pObjectSafety))))
		return URLPOLICY_DISALLOW;
	if(FAILED(pObjectSafety->GetInterfaceSafetyOptions(IID_IActiveScript, &dwSupportedOpts, &dwEnabledOpts)))
		return URLPOLICY_DISALLOW;
	if(toBoolean(dwEnabledOpts & INTERFACE_USES_SECURITY_MANAGER)) {
		CComPtr<IServiceProvider>				pServiceProvider;
		CComPtr<IInternetHostSecurityManager>	pSecurityManager;

		if(FAILED(m_pScriptEngine->GetScriptSite(IID_IActiveScriptSite, reinterpret_cast<void**>(&pScriptHost))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pScriptHost->QueryInterface(IID_IServiceProvider, reinterpret_cast<void**>(&pServiceProvider))))
			return URLPOLICY_DISALLOW;
		if(FAILED(pServiceProvider->QueryService(SID_SInternetHostSecurityManager,
				IID_IInternetHostSecurityManager, reinterpret_cast<void**>(&pSecurityManager))))
			return URLPOLICY_DISALLOW;

		DWORD			dwPolicy, cbPolicy;
		DWORD*			pdwPolicy;
		CONFIRMSAFETY	cs = {clsid, pUnk, 0};

		cs.pUnk->AddRef();
		if(FAILED(pSecurityManager->QueryCustomPolicy(GUID_CUSTOM_CONFIRMOBJECTSAFETY,
				reinterpret_cast<BYTE**>(&pdwPolicy), &cbPolicy,
				reinterpret_cast<BYTE*>(&cs), sizeof(CONFIRMSAFETY), 0)))
			return URLPOLICY_DISALLOW;
		dwPolicy = URLPOLICY_DISALLOW;
		if (pdwPolicy != 0) {
			if (sizeof(DWORD) <= cbPolicy)
			dwPolicy = *pdwPolicy;
			::CoTaskMemFree(pdwPolicy);
		}
		return dwPolicy;
	} else*/
		return /*toBoolean(dwEnabledOpts & INTERFACESAFE_FOR_UNTRUSTED_CALLER) ? URLPOLICY_DISALLOW :*/ URLPOLICY_ALLOW;
}


// CArguments class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CArguments::CArguments(const vector<wstring>& vecArgs) : m_vecArgs(vecArgs) {
}

///	@see	IArguments::Count
STDMETHODIMP CArguments::Count(long* pcArgs) {
	if(pcArgs != 0)
		*pcArgs = m_vecArgs.size();
	return S_OK;
}

///	@see	IArguments::get__NewEnum
STDMETHODIMP CArguments::get__NewEnum(IUnknown** ppEnum) {
	VERIFY_POINTER(ppEnum);
	*ppEnum = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Item
STDMETHODIMP CArguments::get_Item(long nIndex, BSTR* pbstrArgs) {
	VERIFY_POINTER(pbstrArgs);

	if(nIndex < 0 || nIndex >= static_cast<long>(m_vecArgs.size()))
		return 0x800A0009;
	*pbstrArgs = ::SysAllocString(m_vecArgs[nIndex].c_str());
	return S_OK;
}

///	@see	IArguments::get_Length
STDMETHODIMP CArguments::get_Length(long* pcArgs) {
	VERIFY_POINTER(pcArgs);
	*pcArgs = m_vecArgs.size();
	return S_OK;
}

///	@see	IArguments::get_Named
STDMETHODIMP CArguments::get_Named(IDispatch** ppNamed) {
	*ppNamed = 0;
	return E_NOTIMPL;
}

///	@see	IArguments::get_Unamed
STDMETHODIMP CArguments::get_Unnamed(IDispatch** ppUnnamed) {
	*ppUnnamed = 0;
	return E_NOTIMPL;
}

///	@see	IDispatch::Invoke
STDMETHODIMP CArguments::Invoke(DISPID dispidMember,
		REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS* pDispParams,
		VARIANT* pVarResult, EXCEPINFO* pExcepInfo, unsigned int* puArgErr) {
	if(riid != IID_NULL)
		return DISP_E_UNKNOWNINTERFACE;

	HRESULT		hr = DISP_E_MEMBERNOTFOUND;
	CComVariant	args[1];

	if(wFlags & DISPATCH_PROPERTYGET) {	// Qb^
		switch(dispidMember) {
		case DISPID_DOCUMENTS_NEWENUM:
			pVarResult->vt = VT_UNKNOWN;
			return get__NewEnum(&pVarResult->punkVal);
		case DISPID_ARGUMENTS_ITEM:
			VERIFY_ARGUMENTS_COUNT(1);
			COERCE_ARGUMENT_AT(0, VT_I4);
			pVarResult->vt = VT_BSTR;
			return get_Item(args[0].lVal, &pVarResult->bstrVal);
		case DISPID_ARGUMENTS_LENGTH:
			pVarResult->vt = VT_I4;
			return get_Length(&pVarResult->lVal);
		case DISPID_ARGUMENTS_NAMED:
			pVarResult->vt = VT_DISPATCH;
			return get_Named(&pVarResult->pdispVal);
		case DISPID_ARGUMENTS_UNNAMED:
			pVarResult->vt = VT_DISPATCH;
			return get_Unnamed(&pVarResult->pdispVal);
		}
	} else if(wFlags & DISPATCH_PROPERTYPUT)	// vb^
		;
	else if(wFlags & DISPATCH_PROPERTYPUTREF)	// Zb^
		;
	else if(wFlags & DISPATCH_METHOD) {	// \bh
		switch(dispidMember) {
		case DISPID_ARGUMENTS_COUNT:
			VERIFY_ARGUMENTS_COUNT(0);
			COERCE_RETURN(VT_I4);
			return Count(&pVarResult->lVal);
		case DISPID_ARGUMENTS_SHOWUSAGE:
			VERIFY_ARGUMENTS_COUNT(0);
			return ShowUsage();
		default:
			DISP_E_MEMBERNOTFOUND;
		}
	}

	return hr;
}

///	@see	IArguments::ShowUsage
STDMETHODIMP CArguments::ShowUsage() {
	return E_NOTIMPL;
}


#undef VERIFY_ARGUMENTS_COUNT
#undef COERCE_ARGUMENT_AT

#pragma warning(default : 4390)

/* [EOF] */