// AscensionCommon.h
// (c) 2004 exeal

#ifndef _ASCENSION_COMMON_H_
#define _ASCENSION_COMMON_H_

///	ǐՒ Unicode ̃o[W
#define ASCENSION_UNICODE_VERSION	0x0400	// 4.0

#include <string>
#include <sstream>
#include "..\..\Manah\Text.h"	// {ꕶR[hϊƂTQ[gƂ

#ifdef _DEBUG
#include "..\..\Manah\Timer.h"
using Manah::Windows::dout;
using Manah::Windows::CTimer;
#endif /* _DEBUG */

namespace Ascension {

namespace Private {

// ^ signed ɂ邾
template<typename T>
class ToSigned {
private:
	template<typename U>	struct _ToSigned;
	template<>	struct _ToSigned<unsigned char>		{typedef char	Result;};
	template<>	struct _ToSigned<unsigned short>	{typedef short	Result;};
	template<>	struct _ToSigned<unsigned int>		{typedef int	Result;};
	template<>	struct _ToSigned<unsigned long>		{typedef long	Result;};
	template<>	struct _ToSigned<unsigned _int64>	{typedef _int64	Result;};
public:
	typedef typename _ToSigned<T>::Result	Result;
};

} // namespace Private

// ^`BWin32 API  wchar_t ł͂Ȃ WCHAR gƂB
// Ƃ͂ۂɂ wcs*** ĝ WCHAR == wchar_t łȂƍ̂
// (X OLECHAR == wchar_t łȂƂ܂)
typedef WCHAR											char_t;
typedef std::basic_string<char_t>						string_t;
typedef string_t::size_type								length_t;
typedef Private::ToSigned<length_t>::Result				signed_length_t;
typedef std::basic_stringstream<string_t::value_type>	stringstream_t;
typedef std::basic_istringstream<string_t::value_type>	istringstream_t;
typedef std::basic_ostringstream<string_t::value_type>	ostringstream_t;

// O錾
class CEditDoc;
class CEditView;

///	sƕʒui[
class CCharPos {
	// f[^o
public:
	std::size_t	m_iLine;	/// s
	std::size_t	m_iChar;	/// ʒu

	// RXgN^
public:
	///	RXgN^
	explicit CCharPos(std::size_t iLine = 0,
			std::size_t iChar = 0) : m_iLine(iLine), m_iChar(iChar) {
	}

	// Zq
public:
	bool operator ==(const CCharPos& pos) const {
		return (m_iLine == pos.m_iLine && m_iChar == pos.m_iChar);
	}
	bool operator !=(const CCharPos& pos) const {
		return (m_iLine != pos.m_iLine || m_iChar != pos.m_iChar);
	}
	bool operator <(const CCharPos& pos) const {
		return (m_iLine < pos.m_iLine
				|| (m_iLine == pos.m_iLine && m_iChar < pos.m_iChar));
	}
	bool operator <=(const CCharPos& pos) const {
		return (*this < pos || *this == pos);
	}
	bool operator >(const CCharPos& pos) const {
		return (m_iLine > pos.m_iLine
				|| (m_iLine == pos.m_iLine && m_iChar > pos.m_iChar));
	}
	bool operator >=(const CCharPos& pos) const {
		return (*this > pos || *this == pos);
	}
};

/// ̐ΒlԂ֐
template<typename T>
T dif(T i0, T i1) {
	return (i0 > i1) ? i0 - i1 : i1 - i0;
}

}

#endif /* _ASCENSION_COMMON_H_ */

/* [EOF] */