// AutoCompleteWnd.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "AutoCompleteWnd.h"
#include "EditView.h"	// CEditView
#include "EditPoint.h"

using namespace Ascension;
using namespace std;


// CAutoCompleteWnd class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CAutoCompleteWnd::CAutoCompleteWnd(CEditView* pView) : m_pView(pView), m_hFont(0) {
	assert(m_pView != 0);
}

///	⊮
void CAutoCompleteWnd::Complete() {
	AssertValid();

	const int	iSel = GetCurSel();

	if(iSel != LB_ERR) {
		CEditDoc*		pDoc = m_pView->GetDocument();
		char_t*			pwszItem = new char_t[GetTextLen(iSel) + 1];
		const string_t	strLeftWord = m_pView->GetPrecedingWord(250);

		GetText(iSel, pwszItem);
		if(*m_pView->m_pAnchorPoint < *m_pView->m_pActivePoint)
			m_pView->m_pAnchorPoint->CharPrev(strLeftWord.length());
		else
			m_pView->m_pActivePoint->CharPrev(strLeftWord.length());
		pDoc->EndEditCollection();
		pDoc->BeginEditCollection();
		pDoc->DeleteText(m_pView, *m_pView->m_pAnchorPoint, *m_pView->m_pActivePoint);
		pDoc->InsertText(m_pView, *m_pView->m_pActivePoint, pwszItem);
		pDoc->EndEditCollection();

		delete[] pwszItem;
	}
	ShowWindow(SW_HIDE);
}

/**
 *	EBhE쐬
 *	@return	
 */
bool CAutoCompleteWnd::Create() {
	AssertValid();

	RECT	rect = {0, 0, 0, 0};
	// using Manah::Windows::Controls::CListBox;	// VC6
	// if(this->CListBox::CreateEx(true,
	if(Manah::Windows::Controls::CListBox::CreateEx(true,
			WS_EX_DLGMODALFRAME | WS_EX_NOPARENTNOTIFY,
			WS_POPUP | WS_TABSTOP | WS_VSCROLL | LBS_NOTIFY | LBS_SORT,
			rect, m_pView->m_hWnd, 0)) {
		NONCLIENTMETRICSW	ncm;
		ncm.cbSize = sizeof(NONCLIENTMETRICSW);
		::SystemParametersInfo(SPI_GETNONCLIENTMETRICS, ncm.cbSize, &ncm, 0);
		m_hFont = ::CreateFontIndirectW(&ncm.lfStatusFont);
		SetFont(m_hFont);
		return true;
	}
	return false;
}

///	@see	CListBox::DispatchEvent
LRESULT CAutoCompleteWnd::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_CHAR:
		if(wParam == 0x0008 ||	// BkSp P\̓GfB^ɑł
				m_pView->GetLexer()->IsIdentifierContinueCodePoint(wParam))
			m_pView->ExecCommand(CMDID_EDIT_CHAR, wParam);
		else {	// ȊȌꍇ͓͕⊮sA󎚉\ȕ̓GfB^ɑł
			Complete();
			if(toBoolean(iswprint(wParam)))
				m_pView->SendMessage(WM_CHAR, wParam, lParam);
		}
		return true;
	case WM_DESTROY:
		::DeleteObject(m_hFont);
		break;
	case WM_KEYDOWN:
		switch(wParam) {
		case VK_LBUTTON:	// Xgr[̊̑
		case VK_UP:
		case VK_DOWN:
		case VK_NEXT:
		case VK_PRIOR:
			break;
		case VK_DELETE:	// ⊮EBhEăGfB^̊̓
			ShowWindow(SW_HIDE);
			m_pView->SendMessage(WM_KEYDOWN, wParam, lParam);
			return true;
		case VK_ESCAPE:	// ⊮ɓ͌EBhE
			ShowWindow(SW_HIDE);
			return true;
		case VK_RETURN: {	// I΂̃eLXg}ĕBI΃r[ɑ
			const int	iSel = GetCurSel();
			if(iSel == LB_ERR) {
				m_pView->SendMessage(WM_KEYDOWN, VK_RETURN, lParam);
				ShowWindow(SW_HIDE);
			} else
				Complete();
			return true;
		}
		case VK_TAB:
		case VK_SPACE:
			Complete();
			m_pView->SendMessage(WM_KEYDOWN, wParam, lParam);
			return true;
		default:	// c̃L[͂͑Săr[ɑ
			m_pView->SendMessage(WM_KEYDOWN, wParam, lParam);
			return true;
		}
		break;
	case WM_KILLFOCUS:
		ShowWindow(SW_HIDE);
		break;
	case WM_LBUTTONDBLCLK:	// _uNbNł⊮
		Complete();
		return true;
	case WM_LBUTTONDOWN: {	// ŎȂȂ̂
			POINT		pt = {LOWORD(lParam), HIWORD(lParam)};
			bool		bOutside;
			const int	iSel = ItemFromPoint(pt, bOutside);
			if(!bOutside)
				SetCurSel(iSel);
		}
		return true;
	case WM_SHOWWINDOW:
		if(!wParam)
			ResetContent();
		break;
	}

	return CListBox::DispatchEvent(message, wParam, lParam);
}

///	͌⃊Xg̃Zbg
void CAutoCompleteWnd::SetCandidateWords(const set<string_t>& setWords) {
	AssertValidAsWindow();

	for(set<string_t>::const_iterator it = setWords.begin(); it != setWords.end(); ++it) {
		if(!it->empty())
			AddString(it->c_str());
	}
}

///	r[̏󋵂ɍ킹ăXg̑IXV
void CAutoCompleteWnd::UpdateListCursel() {
	AssertValidAsWindow();

	const string_t	strLeftWord = m_pView->GetPrecedingWord(250);

	if(!strLeftWord.empty()) {
		const int	iFound = FindString(-1, strLeftWord.c_str());
		SetCurSel((iFound != LB_ERR) ? iFound : -1);
		if(iFound != LB_ERR) {
			if(iFound != 0)	// ̂܂܂Ə񂾂IڂsɂȂ݂
				SetCurSel(iFound - 1);
			SetCurSel(iFound);
		}
	} else
		SetCurSel(-1);
}

/* [EOF] */