// EditController.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditController.h"
#include "EditView.h"
#include <algorithm>	// std::max, std::min

using namespace Ascension;
using namespace Manah::Windows;


// CEditController class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CEditController::CEditController() : m_p2ndView(0), m_iLastActive(0),
		m_nFirstViewHeight(0), m_nSplitRatio(0), m_nSplitterWidth(3), m_bMovingSplitter(false) {
}

///	fXgN^
CEditController::~CEditController() {
}

///	r[̃TCY𒲐߂
void CEditController::_AdjustView() {
	AssertValid();
	if(m_pView == 0 || !m_pView->IsWindow())
		return;

	RECT	rect;
	int		nPadding = GetPadding();

	GetClientRect(&rect);
	::InflateRect(&rect, -nPadding, -nPadding);
	if(m_p2ndView == 0 || !m_p2ndView->IsWindow())
		m_pView->MoveWindow(&rect, true);
	else {
		m_pView->MoveWindow(rect.left, rect.top,
			rect.right - rect.left, m_nFirstViewHeight, true);
		m_p2ndView->MoveWindow(rect.left,
			rect.top + m_nFirstViewHeight + m_nSplitterWidth,
			rect.right - rect.left,
			rect.bottom - rect.top - m_nFirstViewHeight - m_nSplitterWidth, true);
	}
}

///	@see	CController::_NewDocumentInstance
CDocument* CEditController::_NewDocumentInstance() {
	return new CEditDoc(this);
}

///	@see	CController::_NewViewInstance
CView* CEditController::_NewViewInstance() {
	return new CEditView();
}

///	@see	CController::_NewViewInstance
CEditView* CEditController::_NewViewInstance(const CEditView& rhs) {
	return new CEditView(rhs);
}

/**
 *	WM_SETFOCUS 󂯎r[ɂČĂяoB
 *	ŌɃtH[JXĂr[ʒm
 *	@param view	r[
 */
void CEditController::_OnViewGetFocus(const CEditView& view) {
	if(&view == m_pView)			m_iLastActive = 0;
	else if(&view == m_p2ndView)	m_iLastActive = 1;
	else							assert(false);	// ̃NXł̓r[2܂
}

///	ANeBuȃr[Ԃ
CEditView* CEditController::GetActiveView() const {
	if(m_p2ndView == 0)
		const_cast<CEditController*>(this)->m_iLastActive = 0;
	return (m_iLastActive == 0) ? reinterpret_cast<CEditView*>(m_pView) : m_p2ndView;
}

/**
 *	ꂽr[Ԃ̋ݒ肷
 *	@param nWidth	V
 */
void CEditController::SetSplitterWidth(int nWidth) {
	assert(nWidth >= 0);
	m_nSplitterWidth = nWidth;
	_AdjustView();
}

/**
 *	r[cɕB̒l傫肷ꍇ͕̓LZB
 *	̃\bh̓r[3ȏɂ͕Ȃ
 *	@param nFirstViewHeight	ŏ̃r[̍Bȗ2
 */
void CEditController::SplitView(int nFirstViewHeight /* = -1 */) {
	RECT	rect;

	GetClientRect(&rect);
	if(rect.bottom - rect.top < 10)	// Ŝ̗̈悪Ƃ͉Ȃ
		return;
	if(nFirstViewHeight == -1)	// ̈ʒuvZ
		nFirstViewHeight = (rect.bottom - rect.top) / 2;
	if(nFirstViewHeight < 10) {	// 1Ԗڂ̃r[ȂƂ
		if(m_p2ndView != 0) {	// ĂΉ
			GetDocument()->RemoveView(m_p2ndView);
			delete m_p2ndView;
			m_p2ndView = 0;
			m_nFirstViewHeight = 0;
			m_pView->SetFocus();
			m_pView->MoveWindow(&rect);
		}
		_AdjustView();
		return;
	}
	m_nFirstViewHeight = nFirstViewHeight;
	m_nSplitRatio = static_cast<double>(rect.bottom - rect.top) / m_nFirstViewHeight;
	if(m_p2ndView == 0) {	// Vꍇ
		RECT		rect_ = rect;
//		LOGFONTW	lf;

		rect_.top = rect.top + m_nFirstViewHeight + m_nSplitterWidth;
		m_p2ndView = _NewViewInstance(*static_cast<CEditView*>(m_pView));	// _ELXggĂ
		m_pDocument->AddView(m_p2ndView);
		m_p2ndView->Create(m_hWnd, &rect_,
			m_pView->GetStyle(), m_pView->GetExStyle());
//		::GetObject(m_pView->GetFont(), sizeof(LOGFONTW), &lf);
//		m_p2ndView->ModifyFontInfo(lf);
		m_p2ndView->SetFocus();
		m_p2ndView->SetScrollPos(SB_VERT, GetPrimaryView()->m_ptScroll.y, false);
		m_p2ndView->OnVScroll(SB_THUMBTRACK, 0, 0);
	}
	_AdjustView();
}

///	@see	CWindow::OnCommand
bool CEditController::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	::SendMessageW(::GetParent(m_hWnd), WM_COMMAND,
		MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
	return false;
}

///	@see	CWindow::OnLButtonDblClk
void CEditController::OnLButtonDblClk(UINT nFlags, POINT pt) {
	pt.y -= GetPadding();
	if(IsSplit()
			&& pt.y >= m_nFirstViewHeight
			&& pt.y <= m_nFirstViewHeight + m_nSplitterWidth)
		SplitView(0);	// 
}

///	@see	CWindow::OnLButtonDown
void CEditController::OnLButtonDown(UINT nFlags, POINT pt) {
	pt.y -= GetPadding();
	if(pt.y >= m_nFirstViewHeight
			&& pt.y <= m_nFirstViewHeight + m_nSplitterWidth) {
		m_bMovingSplitter = true;	// ʒuύXJn
		SetCapture();
	}
}

///	@see	CWindow::OnLButtonUp
void CEditController::OnLButtonUp(UINT nFlags, POINT pt) {
	if(m_bMovingSplitter) {
		m_bMovingSplitter = false;	// ʒuύXI
		ReleaseCapture();
		SplitView(m_nFirstViewHeight);
	}
}

///	@see	CWindow::OnMouseMove
void CEditController::OnMouseMove(UINT nFlags, POINT pt) {
	if(m_bMovingSplitter) {	// ʒuύX
		int		nNewFirstViewHeight = static_cast<short>(pt.y) - GetPadding();
		RECT	rectPane;
		int		nArrowHeight = ::GetSystemMetrics(SM_CYVSCROLL);
		int		nHScrollHeight = ::GetSystemMetrics(SM_CYHSCROLL);

		GetClientRect(&rectPane);
		int	nFirstViewMaxHeight = rectPane.bottom - rectPane.top
				- GetPadding() * 2 - m_nSplitterWidth - nArrowHeight * 2 - nHScrollHeight;
		nNewFirstViewHeight = std::max(nNewFirstViewHeight, 2);
		nNewFirstViewHeight = std::min(nNewFirstViewHeight, nFirstViewMaxHeight);
		if(nNewFirstViewHeight != m_nFirstViewHeight) {
			m_nFirstViewHeight = nNewFirstViewHeight;
			_AdjustView();
		}
	}
}

///	@see	CWindow::OnSetCursor
bool CEditController::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	POINT	pt;

	::GetCursorPos(&pt);
	ScreenToClient(&pt);
	pt.y -= GetPadding();
	if(pt.y >= m_nFirstViewHeight
			&& pt.y <= m_nFirstViewHeight + m_nSplitterWidth) {
		::SetCursor(::LoadCursor(0, IDC_SIZENS));
		return true;
	}
	return false;
}

///	@see	CWindow::OnSetFocus
void CEditController::OnSetFocus(HWND hwndOld) {
	GetActiveView()->SetFocus();
}

///	@see	CWindow::OnSize
void CEditController::OnSize(UINT nType, int cx, int cy) {
	if(m_nFirstViewHeight != 0) {
		RECT	rect;
		GetClientRect(&rect);
		m_nFirstViewHeight = static_cast<int>((rect.bottom - rect.top) / m_nSplitRatio);
	}
	_AdjustView();
}

/* [EOF] */