// EditDoc.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditDoc.h"
#include <MAPI.h>	// MAPISendMail
#include "..\..\Manah\WaitCursor.h"
#include "..\..\Armaiti\ComGeneric.h"
#include <algorithm>	// std::for_each

using namespace Ascension;
using Ascension::CEditDoc::CUndoManager;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Windows::IO;
using namespace Manah::Text;
using namespace Armaiti;
using namespace std;


// CInsertOperation class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CInsertOperation::CInsertOperation(const CCharPos& pos,
		const string_t& strText) : m_bType(true), m_pos(pos), m_strText(strText) {
}

///	폜͏ɌłȂ
void CInsertOperation::Concat(COperationUnit* pOperationUnit) {
	AssertValid();
	assert(pOperationUnit != 0);
	pOperationUnit->Push(this);
}

///	}̍Đ
void CInsertOperation::Execute(CEditDoc* pDoc) {
	AssertValid();

	VIEW_POSITION	pos = pDoc->GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = pDoc->GetNextView(pos))) {
		if(::GetFocus() == pView->m_hWnd)
			break;
	}
	pDoc->InsertText(pView, m_pos, m_strText);
}


// CDeleteOperation class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CDeleteOperation::CDeleteOperation(const CCharPos& posBegin,
		const CCharPos& posEnd) : m_bType(false), m_posBegin(posBegin), m_posEnd(posEnd) {
}

///	̑w肳ꂽPʂɌ
void CDeleteOperation::Concat(COperationUnit* pOperationUnit) {
	AssertValid();
	assert(pOperationUnit != 0);
	IOperation*	pLastOpe = pOperationUnit->Top();

	if(!static_cast<CDeleteOperation*>(pLastOpe)->m_bType) {	// O͑}
		CDeleteOperation*	pPrevOperation = static_cast<CDeleteOperation*>(pLastOpe);
		if(m_posBegin.m_iLine != pPrevOperation->m_posEnd.m_iLine
				|| m_posBegin.m_iChar != pPrevOperation->m_posEnd.m_iChar)
			pOperationUnit->Push(this);
		else
			pPrevOperation->m_posEnd = m_posEnd;	// Ō̑Pʂ̍Ō̑Ɍ (폜͈͂g)
	} else	// O͍폜
		pOperationUnit->Push(this);	// Ō̑Pʂɒǉ
}

///	폜̍Đ
void CDeleteOperation::Execute(CEditDoc* pDoc) {
	AssertValid();

	VIEW_POSITION	pos = pDoc->GetFirstViewPosition();
	CView*			pView;

	while(0 != (pView = pDoc->GetNextView(pos))) {
		if(::GetFocus() == pView->m_hWnd)
			break;
	}
	pDoc->DeleteText(pView, m_posBegin, m_posEnd);
}


// COperationUnit class implementation
/////////////////////////////////////////////////////////////////////////////

/// fXgN^
COperationUnit::~COperationUnit() {
	while(!m_stkOpes.empty()) {
		delete m_stkOpes.top();
		m_stkOpes.pop();
	}
}

/**
 *	Pʂ̎sB\bhďoケ̃IuWFNg͖ɂȂ
 *	@param pDoc	ΏۃhLg
 */
void COperationUnit::Execute(CEditDoc* pDoc) {
	AssertValid();
	while(!m_stkOpes.empty()) {	// SĂ̑s
		m_stkOpes.top()->Execute(pDoc);
		delete m_stkOpes.top();
		m_stkOpes.pop();
	}
}

///	1̑|bv
IOperation* COperationUnit::Pop() {
	AssertValid();
	IOperation*	p = m_stkOpes.top();
	m_stkOpes.pop();
	return p;
}

///	1̑vbV
void COperationUnit::Push(IOperation* pOperation) {
	AssertValid();
	if(m_stkOpes.size() != 0
			&& !static_cast<CDeleteOperation*>(pOperation)->m_bType
			&& !static_cast<CDeleteOperation*>(m_stkOpes.top())->m_bType) {
		CDeleteOperation*	pNewOp = static_cast<CDeleteOperation*>(pOperation);
		CDeleteOperation*	pLastOp = static_cast<CDeleteOperation*>(m_stkOpes.top());
		if(pNewOp->m_posBegin.m_iLine == pLastOp->m_posEnd.m_iLine
				&& pNewOp->m_posBegin.m_iChar == pLastOp->m_posEnd.m_iChar) {
			pLastOp->m_posEnd = pNewOp->m_posEnd;
			delete pNewOp;
			return;
		}
	}
	m_stkOpes.push(pOperation);
}

///	擪̑擾
IOperation* COperationUnit::Top() const {
	AssertValid();
	return m_stkOpes.top();
}


// CUndoManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CUndoManager::CUndoManager(CEditDoc* pDoc)
	: m_pDoc(pDoc), m_bVirtual(false), m_pVirtualUnit(0), m_pLastUnit(0), m_pSavedOperation(0) {
}

///	fXgN^
CUndoManager::~CUndoManager() {
	Clear();
}

///	AhD/hDX^bNɂ
void CUndoManager::Clear() {
	m_pLastUnit = 0;
	m_pSavedOperation = 0;
	while(!m_stkUndo.empty()) {
		delete m_stkUndo.top();
		m_stkUndo.pop();
	}
	while(!m_stkRedo.empty()) {
		delete m_stkRedo.top();
		m_stkRedo.pop();
	}
}

///	hD\ȉ񐔂Ԃ
size_t CUndoManager::GetRedoBufferLength() const {
	return m_stkRedo.size();
}

///	AhD\ȉ񐔂Ԃ
size_t CUndoManager::GetUndoBufferLength() const {
	return m_stkUndo.size();
}

///	Oۑ瑀삪ǉA폜ꂽԂ
bool CUndoManager::IsModifiedSinceLastSave() const {
	if(m_stkUndo.empty())
		return m_pSavedOperation != 0;
	return m_pSavedOperation != m_stkUndo.top()->Top();
}

///	ۑꂽƂʒm
void CUndoManager::OnSave() {
	m_pSavedOperation = !m_stkUndo.empty() ? m_stkUndo.top()->Top() : 0;
}

/**
 *	1̑AhDX^bNɒǉ
 *	@param pOperation	ǉ鑀
 *	@param bConcatPrev	Ȏƌ邩ǂ
 */
void CUndoManager::PushUndoBuffer(IOperation* pOperation, bool bConcatPrev) {
	// hDX^bNɂ
	if(!m_bVirtual) {
		while(!m_stkRedo.empty()) {
			delete m_stkRedo.top();
			m_stkRedo.pop();
		}
	}

	if(m_bVirtual) {	// z쎞̓X^bNւ̒ǉx
		if(m_pVirtualUnit == 0)	// 
			m_pVirtualUnit = new COperationUnit();
		m_pVirtualUnit->Push(pOperation);
	} else if(bConcatPrev && m_pLastUnit) {	// Ō̑PʂɌ
		assert(m_pLastUnit != 0);
		m_pLastUnit->Push(pOperation);
	} else {
		COperationUnit*	pUnit = new COperationUnit();
		pUnit->Push(pOperation);
		m_stkUndo.push(pUnit);
		m_pLastUnit = pUnit;
	}
}

///	hD1s
void CUndoManager::Redo() {
	if(m_stkRedo.empty())
		return;

	COperationUnit*	pUnit = m_stkRedo.top();
	m_stkRedo.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_pDoc);
	m_stkUndo.push(m_pVirtualUnit);	// zPʂAhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}

///	AhD1s
void CUndoManager::Undo() {
	if(m_stkUndo.empty())
		return;

	COperationUnit*	pUnit = m_stkUndo.top();
	m_stkUndo.pop();
	m_bVirtual = true;				// zJn
	pUnit->Execute(m_pDoc);
	m_stkRedo.push(m_pVirtualUnit);	// zPʂhDX^bNֈڂ
	m_pVirtualUnit = m_pLastUnit = 0;
	m_bVirtual = false;				// zI
	delete pUnit;
}


// CEditDoc class implementation
/////////////////////////////////////////////////////////////////////////////

const char_t CEditDoc::m_wszBreakChars[6] = {		// U+0085 Ƀeg VC6 ŃG[ɂȂ
	0x000A, 0x000D, 0x0085, 0x2028, 0x2029, 0x0000	// (C99 ł 0x00A0 ȉ̕ \uxxxx `Ŏw肷邱Ƃ
};													// oȂ炵 C++ Ƃ̊֘A͕s)

map<UINT, CEditDoc*> CEditDoc::m_mapDocuments;

///	RXgN^
CEditDoc::CEditDoc(Ascension::CEditController* pController /* = 0 */) :
		CDocument((CController*)pController), m_bIgnoreViews(false), m_bReadOnly(false),
			m_fomMode(FOM_DENYNONE), m_nCodePage(::GetACP()), m_breakType(BT_CRLF), m_ugsGroupingState(UGS_NONE),
		m_bOnceUndoBufferCleared(false), m_bVirtualOperating(false),
		m_itCache_(m_listLines.end()), m_itCache(m_listLines.end()) {
	m_listLines.push_back(CEditDocLine());
	m_pUndoManager = new CUndoManager(this);
	m_nTimerId = ::SetTimer(0, 0, 1000, CEditDoc::TimerProc);
	CEditDoc::m_mapDocuments[m_nTimerId] = this;
}

///	fXgN^
CEditDoc::~CEditDoc() {
	CloseDocument();
	delete m_pUndoManager;
	::KillTimer(0, m_nTimerId);
	CEditDoc::m_mapDocuments.erase(m_nTimerId);
}

///	t@C̍ŏIXV`FbN
void CEditDoc::CheckFileLastWriteTime() {
	AssertValid();

	static bool	bChecking = false;

	if(m_strPathName.empty() || bChecking)
		return;
	bChecking = true;

	HANDLE				hFind;
	WIN32_FIND_DATAW	wfd;

	hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind == INVALID_HANDLE_VALUE) {
		return;
		bChecking = false;
	}
	if(::CompareFileTime(&m_lastWriteTime, &wfd.ftLastWriteTime) == -1) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		for(set<IEditDocEventListener*>::iterator it
				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
			(*it)->OnDocumentOverwrittenByOtherProcess(this);
		// ʒmɃt@CXV邩Ȃ̂ŁA1xŐṼf[^
		::FindClose(hFind);
		hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
		m_lastWriteTime = wfd.ftLastWriteTime;
	}
	::FindClose(hFind);
	bChecking = false;
}

/**
 *	݊JĂt@CRs[
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::CopyCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(toBoolean(::PathFileExistsW(pwszDestination)))
		return OPS_ALREADYEXISTS;

	OperationStatus	ops = OPS_OK;
	UINT			nReopenMode = CFile::modeNoTruncate;

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:		nReopenMode |= CFile::modeRead | CFile::shareDenyWrite;		break;
		case FOM_DENYREAD:		nReopenMode |= CFile::modeReadWrite | CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:	nReopenMode |= CFile::modeRead | CFile::shareDenyNone;		break;
	}

	m_oFile.Close();
	if(!::CopyFileW(m_strPathName.c_str(), pwszDestination, true))
		ops = OPS_UNKNOWNERROR;

	// t@CJ
	if(m_bReadOnly) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false))
			m_fomMode = FOM_ASREADONLY;
		else
			return OPS_CANNOTOPEN;
	} else if(!m_oFile.Open(m_strPathName, nReopenMode, false)) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fomMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	݊JĂt@CݔɈړB
 *	̃\bhsƃt@C͕
 *	@return	
 */
OperationStatus CEditDoc::DeleteCurrentFile() {
	AssertValid();

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	OperationStatus	ops = OPS_OK;
	unsigned int	nShareMode = 0;
	wchar_t			wszPath[MAX_PATH];
	SHFILEOPSTRUCTW	shfos = {::GetDesktopWindow(), FO_DELETE, wszPath, 0, FOF_ALLOWUNDO, 0, 0, 0};

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:	nShareMode = CFile::shareDenyWrite;	break;
		case FOM_DENYREAD:	nShareMode = CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:nShareMode = CFile::shareDenyNone;	break;
	}

	wcscpy(wszPath, m_strPathName.c_str());
	*(wszPath + wcslen(wszPath) + 1) = 0;

	m_oFile.Close();
	::SHFileOperationW(&shfos);
	if(toBoolean(::PathFileExistsW(wszPath))) {	// s (SHFileExistsW ̖߂l͂ǂMpł)
		if(shfos.fAnyOperationsAborted)
			ops = OPS_ABORTED;

		// t@CJ
		if(!m_oFile.Open(m_strPathName, nShareMode | CFile::modeReadWrite | CFile::modeNoTruncate, false)) {
			if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
				m_fomMode = FOM_ASREADONLY;
				if(!m_bReadOnly) {
					ops = OPS_OPENEDASREADONLY;
					m_bReadOnly = true;
				}
			} else
				ops = OPS_CANNOTOPEN;
		}
	}

	return ops;
}

/**
 *	hLgeLXg̎w͈͂폜B
 *	̃\bh posBegin  posEnd ̓Lbguׂ
 *	UpdateAllViews Ăяȏ3ɁAłȂ2ɓnB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	hLgɏvr[
 *	@param posBegin	폜Jn_
 *	@param posEnd	폜I_
 *	@return			IɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::DeleteText(CObject* pSender,
		const CCharPos& posBegin, const CCharPos& posEnd) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	const CCharPos&	posABegin = min(posBegin, posEnd);	// n_
	const CCharPos&	posAEnd = max(posBegin, posEnd);	// I_
	string_t		strDeleted;							// 폜 (sɂȂƂ݂͌̉s})

	if(posBegin.m_iLine == posEnd.m_iLine) {	// Ώۂ1sȓ
		const CEditDocLine*	pLine = GetLineInfo(posEnd.m_iLine);
		string_t&			strLine = const_cast<string_t&>(GetLine(posEnd.m_iLine));

		++const_cast<CEditDocLine*>(pLine)->m_cOperationHistory;
		strDeleted = strLine.substr(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar, posAEnd.m_iChar - posABegin.m_iChar);
	} else {							// Ώۂs
		string_t&	strLine = const_cast<string_t&>(GetLine(posABegin.m_iLine));
		string_t	strTail;
		strDeleted = strLine.substr(posABegin.m_iChar);
		strLine.erase(posABegin.m_iChar);

		// 폜镔ۑ폜
		CEditDocLineList::iterator	it = GetInternalLineIterator(posABegin.m_iLine), itNext;
		CEditDocLineList::iterator	itFirstLine = it;
		BreakType					btLastLine;
		strDeleted += CEditDoc::GetBreakString(it->m_breakType);
		itNext = ++it;
		for(length_t iLine = posABegin.m_iLine + 1; iLine < posAEnd.m_iLine + 1; ++iLine) {
			strDeleted +=
				((iLine != posAEnd.m_iLine) ? it->m_strLine : it->m_strLine.substr(0, posAEnd.m_iChar));
			if(iLine != posAEnd.m_iLine)
				strDeleted += GetBreakString(it->m_breakType);
			++itNext;
			assert(itNext != 0);
			if(iLine == posAEnd.m_iLine) {	// 폜Is
				strTail = it->m_strLine.substr(posAEnd.m_iChar);
				btLastLine = it->m_breakType;
			}
			m_listLines.erase(it);
			it = itNext;
		}

		// 폜̑Oq
		itFirstLine->m_breakType = btLastLine;
		++itFirstLine->m_cOperationHistory;
		if(!strTail.empty())
			strLine += strTail;
	}

	m_itCache_ = m_listLines.end();	// ŃLbV𖳌ɂĂ
	m_itCache = m_listLines.end();

	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(new CInsertOperation(
		posABegin, strDeleted), m_ugsGroupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_ugsGroupingState == UGS_WAITFORFIRSTEDIT)
		m_ugsGroupingState = UGS_WAITFORCONTINUEEDIT;

	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_oUpdateInfo.usSummary = US_OPERATION_DELETE;
		m_oUpdateInfo.posBegin = posABegin;
		m_oUpdateInfo.posEnd = posAEnd;
		m_oUpdateInfo.posResult = posABegin;
		UpdateAllViews(pSender, 0, this);
	}
	for_each(m_setEventListeners.begin(),
		m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return posABegin;
}

/**
 *	Ss (hLgS) 擾
 *	@param strText	i[
 */
void CEditDoc::GetAllLines(string_t& strText) const {
	AssertValid();
	LineIterator	it;
	length_t		cchAllLines = 0;

	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		cchAllLines += it->m_strLine.length() + CEditDoc::GetBreakString(it->m_breakType).length();
	strText.reserve(cchAllLines);
	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		strText += it->m_strLine + CEditDoc::GetBreakString(it->m_breakType);
}

///	hLg̕ҏW̕ԂBsɂ݂͌̉sR[hgp
length_t CEditDoc::GetDocumentLength() const {
	AssertValid();

	length_t		cch = 0;
	LineIterator	it;
	int				cchBreak = (m_breakType == BT_CRLF) ? 2 : 1;

	for(it = m_listLines.begin(); it != m_listLines.end(); ++it)
		cch += it->m_strLine.length() + cchBreak;
	cch -= cchBreak;

	return cch;
}

///	ҏW\ȓpsCe[^̎擾
CEditDocLineList::iterator CEditDoc::GetInternalLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	CEditDocLineList&			refList = const_cast<CEditDoc*>(this)->m_listLines;
	length_t					i, cch = m_listLines.size();
	CEditDocLineList::iterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache_ == refList.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = refList.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = refList.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache_, iLine))
			for(i = 0, it = refList.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache_, iLine))
			for(i = cch, it = refList.end(); i > iLine; --i, --it);
		else if(m_iLineCache_ < iLine)
			for(i = m_iLineCache_, it = m_itCache_; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache_, it = m_itCache_; i > iLine; --i, --it);
	}

	m_iLineCache_ = iLine;
	m_itCache_ = it;
	return it;
}

/**
 *	ws牽ڂԂ
 *	@param iLine			ׂs
 *	@param bIncludeBreak	s𕶎ƂĐ邩ǂ
 *	@throw out_of_range		<var>iLine</var> ȂꍇX[
 */
length_t CEditDoc::GetLineIndex(length_t iLine, bool bIncludeBreak) const throw(out_of_range) {
	AssertValid();

	if(iLine >= m_listLines.size())
		throw out_of_range("Specified line not found.");

	length_t							iOffset = 0;
	list<CEditDocLine>::const_iterator	it = m_listLines.begin();
	for(length_t i = 0; i < iLine; ++it, ++i) {
		iOffset += it->m_strLine.length();
		iOffset += bIncludeBreak ? CEditDoc::GetBreakString(it->m_breakType).length() : 0;
	}
	return iOffset;
}

///	sCe[^̎擾
LineIterator CEditDoc::GetLineIterator(length_t iLine) const throw(out_of_range) {
	AssertValid();

	length_t		i, cch = m_listLines.size();
	LineIterator	it;

	if(iLine >= cch)
		throw out_of_range("First argument is greater than list ubound.");

	if(m_itCache == m_listLines.end()) {	// LbVgȂꍇ
		if(iLine <= cch / 2)
			for(i = 0, it = m_listLines.begin(); i < iLine; ++i, ++it);
		else
			for(i = cch, it = m_listLines.end(); i > iLine; --i, --it);
	} else {
		if(iLine < dif(m_iLineCache, iLine))
			for(i = 0, it = m_listLines.begin(); i < iLine; ++i, ++it);
		else if(cch - iLine < dif(m_iLineCache, iLine))
			for(i = cch, it = m_listLines.end(); i > iLine; --i, --it);
		else if(m_iLineCache < iLine)
			for(i = m_iLineCache, it = m_itCache; i < iLine; ++i, ++it);
		else
			for(i = m_iLineCache, it = m_itCache; i > iLine; --i, --it);
	}

	m_iLineCache = iLine;
	m_itCache = it;
	return it;
}

///	hLg
void CEditDoc::InitiateDocument() {
	AssertValid();

	m_listLines.clear();
	m_listLines.push_back(CEditDocLine());
	m_itCache_ = m_listLines.end();
	m_itCache = m_listLines.end();
	m_bModified = false;
	ClearUndoBuffer();
	m_ugsGroupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;

	for_each(m_setEventListeners.begin(),
		m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
}

/**
 *	wʒuɃeLXg}B
 *	̃\bh͑}eLXg̏I[ʒuԂB
 *	܂AI[ʒu͂̃\bh UpdateAllViews \bhĂяȏ2A3ɂgpB
 *	̃\bhĂяoƍXVtOZbgB
 *	pSender ͂̃\bhĂяor[ null ł悢B
 *	̃r[ OnUpdate ͌ĂяoȂ
 *	@param pSender	̏vr[
 *	@param pos		}ʒu
 *	@param strText	}镶
 *	@return			ɃLbguʒu
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
CCharPos CEditDoc::InsertText(CObject* pSender,
		const CCharPos& pos, const string_t& strText) throw(EDocumentIsReadOnly) {
	AssertValid();

	if(m_bReadOnly)
		throw EDocumentIsReadOnly();

	length_t			iLast = strText.find_first_of(CEditDoc::m_wszBreakChars);
	length_t			iNext;
	CCharPos			posResult;
	const CEditDocLine*	pLastLine = GetLineInfo(pos.m_iLine);
	string_t&			strLine = const_cast<wstring&>(pLastLine->m_strLine);

	if(iLast == wstring::npos) {	// ͂ɉsꍇ
		strLine.insert(pos.m_iChar, strText);
		++const_cast<CEditDocLine*>(pLastLine)->m_cOperationHistory;
		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = pos.m_iChar + strText.length();
	} else {	// ͂ɉsꍇ
		length_t		iLine = pos.m_iLine;
		CEditDocLineList::iterator	it = GetInternalLineIterator(pos.m_iLine);
		string_t		strInsert = strText + it->m_strLine.substr(pos.m_iChar);
		BreakType		bt;
		BreakType		btFirstLine = it->m_breakType;	// 擪s̉s (}Ԍɕt)

		posResult.m_iLine = pos.m_iLine;
		posResult.m_iChar = strText.length() - strText.find_last_of(CEditDoc::m_wszBreakChars) - 1;

		// 擪s̒u
		strLine.replace(pos.m_iChar, strLine.length() - pos.m_iChar, strInsert.substr(0, iLast));
		if(strInsert[iLast] == L'\r' && iLast + 1 != strInsert.length() && strInsert[iLast + 1] == L'\n') {
			iLast += 2;
			it->m_breakType = BT_CRLF;
		} else {
			switch(strInsert[iLast]) {
			case L'\n':		it->m_breakType = BT_LF;	break;
			case L'\r':		it->m_breakType = BT_CR;	break;
			case 0x0085:	it->m_breakType = BT_NEL;	break;
			case L'\x2028':	it->m_breakType = BT_LS;	break;
			case L'\x2029':	it->m_breakType = BT_PS;	break;
			}
			++iLast;
		}
		++it->m_cOperationHistory;
		++iLine;
		++it;
		++posResult.m_iLine;

		while(true) {	// sƂɍs؂
			iNext = strInsert.find_first_of(CEditDoc::m_wszBreakChars, iLast);
			if(iNext != wstring::npos) {
				if(strInsert[iNext] == L'\r' && iNext + 1 != strInsert.length() && strInsert[iNext + 1] == L'\n') {
					iNext += 2;
					bt = BT_CRLF;
				} else {
					switch(strInsert[iNext]) {
					case L'\n':		bt = BT_LF;	break;
					case L'\r':		bt = BT_CR;	break;
					case 0x0085:	bt = BT_NEL;break;
					case L'\x2028':	bt = BT_LS;	break;
					case L'\x2029':	bt = BT_PS;	break;
					}
					++iNext;
				}
				// s쐬A}
				it = m_listLines.insert(it,
					CEditDocLine(strInsert.substr(iLast, iNext - iLast - ((bt == BT_CRLF) ? 2 : 1)), bt, true));
				++it;
				++iLine;
				++posResult.m_iLine;
				iLast = iNext;
			} else {	// ̍sōŌ
				m_listLines.insert(it,
					CEditDocLine(strInsert.substr(iLast), btFirstLine, true));
				break;
			}
		}

		m_itCache_ = m_listLines.end();	// ŃLbV𖳌ɂĂ
		m_itCache = m_listLines.end();
	}

	m_bModified = true;
	m_pUndoManager->PushUndoBuffer(new CDeleteOperation(
		pos, posResult), m_ugsGroupingState == UGS_WAITFORCONTINUEEDIT);
	if(m_ugsGroupingState == UGS_WAITFORFIRSTEDIT)
		m_ugsGroupingState = UGS_WAITFORCONTINUEEDIT;

	for_each(m_setEventListeners.begin(),
		m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	if(!m_bIgnoreViews) {
		// Ō̍XVXV
		m_oUpdateInfo.usSummary = US_OPERATION_INSERT;
		m_oUpdateInfo.posBegin = pos;
		m_oUpdateInfo.posEnd = pos;
		m_oUpdateInfo.posResult = posResult;
		UpdateAllViews(pSender, 0, this);
	}

	return posResult;
}

/**
 *	hLgǂݍ
 *	@param strPathName	t@CpX
 *	@param fom			r[hȂ
 *	@param cp			R[hy[W (ȗƎ)
 *	@return				
 */
StreamStatus CEditDoc::LoadDocument(const wstring& strPathName,
		FileOpenMode fom, CodePage cp /* = CPEX_LOCALE_AUTODETECT */) {
//	CTimer tm(L"LoadDocument");	// 2.86s / 1MB
	AssertValid();

	if(!CEncoder::IsValidCodePage(cp))
		return SS_ILLEGALCODEPAGE;

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;
	wchar_t			wszPathName[MAX_PATH];
	HGLOBAL			hGlobal = 0, hGlobal2 = 0;
	char*			pszBuffer = 0;		// obt@
	char_t*			pwszBuffer = 0;
	char_t*			pwszFirstBreak = 0;	// ŏɌꂽs
	DWORD			dwFileSize;			// t@CTCY
	DWORD			dwRead;				// ۂɓǂݎf[^
	CCharPos		posLast(0, 0);		// ɕǉʒu

	// V[gJbg̉
	const wchar_t*	pwszExtension = ::PathFindExtensionW(strPathName.c_str());
	if(wcslen(pwszExtension) != 0 && (
			(::StrCmpIW(pwszExtension + 1, L"lnk") == 0)
			/*|| (::StrCmpIW(pwszExtension + 1, L"url") == 0)*/)) {
		CComPtr<IShellLink>		pShellLink;
		CComPtr<IPersistFile>	pFile;

		if(FAILED(pShellLink.CreateInstance(CLSID_ShellLink)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->QueryInterface(IID_IPersistFile, reinterpret_cast<void**>(&pFile))))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pFile->Load(strPathName.c_str(), STGM_READ)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->Resolve(0, SLR_ANY_MATCH | SLR_NO_UI)))
			return SS_READ_CANNOTRESOLVELINK;
		if(FAILED(pShellLink->GetPath(wszPathName, MAX_PATH, 0, 0)))
			return SS_READ_CANNOTRESOLVELINK;
	} else
		wcscpy(wszPathName, strPathName.c_str());

	try {
		m_oFile.Close();
		m_bReadOnly = false;
		m_fomMode = fom;
		if(fom == FOM_ASREADONLY) {
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		} else if(!m_oFile.Open(wszPathName, CFile::modeReadWrite | CFile::shareDenyNone, false)) {
			ss = SS_READ_READONLY;
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
			m_bReadOnly = true;
		}
		m_oFile.GetFileTime(0, 0, &m_lastWriteTime);
		dwFileSize = m_oFile.GetFileSize(0);	// 4GB ̃XNvgȂ񂩖낤
		hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, dwFileSize);
		pszBuffer = static_cast<char*>(::GlobalLock(hGlobal));

		if(dwFileSize != 0)
			dwRead = m_oFile.Read(pszBuffer, dwFileSize);
	} catch(CFileException&) {
		if(pszBuffer != 0)
			::GlobalUnlock(hGlobal);
		if(hGlobal != 0)
			::GlobalFree(hGlobal);
		return SS_READ_NOEXISTS;
	}

	m_oFile.Close();

	// R[hϊ
	if(dwFileSize != 0) {
		cp = CEncoder::DetectCodePage(pszBuffer, std::min(dwRead, 4UL * 1024), cp);	// xƐM̃g[h͂

		CEncoder*				pEncoder = CEncoder::Create(cp);
		assert(pEncoder != 0);
		std::size_t				cchDest = 1 * dwRead;
		const ByteOrderMark*	pBom = pEncoder->GetByteOrderMark();

		hGlobal2 = ::GlobalAlloc(GMEM_MOVEABLE, (cchDest + 1) * sizeof(char_t));
		pwszBuffer = static_cast<wchar_t*>(::GlobalLock(hGlobal2));
		if(pBom->cBytes != 0 && dwRead >= pBom->cBytes && strncmp(pszBuffer, pBom->pszBOM, pBom->cBytes) == 0)
			cchDest = pEncoder->ConvertToUnicode(pwszBuffer, cchDest, pszBuffer + pBom->cBytes, dwRead - pBom->cBytes);
		else
			cchDest = pEncoder->ConvertToUnicode(pwszBuffer, cchDest, pszBuffer, dwRead);
		delete pEncoder;
		*(pwszBuffer + cchDest) = 0;

		// sƂɋ؂AXgɒǉĂ
		length_t	iNext, iLast = 0;
		char_t*		pwszBreak;
		BreakType	bt;
		m_listLines.clear();
		while(true) {
			pwszBreak = wcspbrk(pwszBuffer + iLast, CEditDoc::m_wszBreakChars);
			if(pwszBreak != 0) {
				iNext = pwszBreak - pwszBuffer;
				// s̔
				switch(*pwszBreak) {
				case L'\n':	bt = BT_LF;	break;
				case L'\r':
					bt = (iNext + 1 < dwRead && *(pwszBreak + 1) == L'\n') ? BT_CRLF : BT_CR;
					break;
				case 0x0085:	bt = BT_NEL;break;
				case L'\x2028':	bt = BT_LS;	break;
				case L'\x2029':	bt = BT_PS;	break;
				}
				m_listLines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, iNext - iLast), bt));
				iLast = iNext + ((bt != BT_CRLF) ? 1 : 2);
			} else {	// ŏIs
				m_listLines.push_back(CEditDocLine(wstring(pwszBuffer + iLast, cchDest - iLast)));
				break;
			}
		}
	} else {	// ̃t@C
		cp = ::GetACP();
		m_listLines.clear();
		m_listLines.push_back(CEditDocLine());
		InsertText(0, CCharPos(0, 0), L"");
		m_listLines.begin()->m_cOperationHistory = 0;
	}

	m_itCache_ = m_listLines.end();
	m_itCache = m_listLines.end();

	// sR[h̔ (_ł͍ŏɌꂽ̂g)
	if(dwFileSize != 0) {
		pwszFirstBreak = wcspbrk(pwszBuffer, CEditDoc::m_wszBreakChars);
		if(pwszFirstBreak == 0)
			m_breakType = BT_CRLF;
		else if(*pwszFirstBreak == L'\n')
			m_breakType = BT_LF;
		else if(*pwszFirstBreak == L'\r')
			m_breakType = (*(pwszFirstBreak + 1) == L'\n') ? BT_CRLF : BT_CR;
		else if(*pwszFirstBreak == 0x0085)
			m_breakType = BT_NEL;
		else if(*pwszFirstBreak == L'\x2028')
			m_breakType = BT_LS;
		else if(*pwszFirstBreak == L'\x2029')
			m_breakType = BT_PS;
	} else
		m_breakType = BT_CRLF;

	::GlobalUnlock(hGlobal2);
	::GlobalFree(hGlobal2);
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	// t@C̃bN
	try {
		if(fom == FOM_DENYNONE || fom == FOM_ASREADONLY)
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyNone);
		else if(fom == FOM_DENYWRITE)
			m_oFile.Open(wszPathName, CFile::modeRead | CFile::shareDenyWrite);
		else	/* if(fom == FOM_DENYREAD) */
			m_oFile.Open(wszPathName,
				CFile::modeRead | CFile::modeWrite | CFile::shareDenyRead | CFile::shareDenyWrite);
	} catch(CFileException&) {
		ss = SS_LOCKDENIED;
	}

	m_nCodePage = cp;
	ClearUndoBuffer();
	m_bModified = false;
	m_ugsGroupingState = UGS_NONE;
	m_bOnceUndoBufferCleared = false;
	m_strPathName = wszPathName;
	m_strTitle = ::PathFindFileNameW(wszPathName);

	SetupAllViews();	// r[ɒʒm

	for_each(m_setEventListeners.begin(),
		m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();

	return ss;
}

/**
 *	݂̊JĂt@Cw肵@ŃbNBǂݎp͖
 *	@param fom	r[hBFOM_DENYWRITE AFOM_DENYREAD ̂ݗL
 *	@return		bNɐ true
 *	@see		CEditDoc::UnlockCurrentFile
 */
bool CEditDoc::LockCurrentFile(FileOpenMode fom) {
	AssertValid();

	if(fom != FOM_DENYWRITE && fom != FOM_DENYREAD)
		return false;
	if(m_strPathName.empty() || m_bReadOnly)
		return false;

	m_oFile.Close();
	if(m_oFile.Open(m_strPathName, CFile::modeReadWrite | ((fom == FOM_DENYWRITE) ?
			CFile::shareDenyWrite : CFile::shareDenyRead), false)) {
		m_fomMode = fom;
		return true;
	} else
		return false;
}

/**
 *	݊JĂt@Cړ
 *	@param pwszDestination	Rs[̃pX
 *	@return					
 */
OperationStatus CEditDoc::MoveCurrentFile(const wchar_t* pwszDestination) {
	AssertValid();
	assert(pwszDestination != 0);

	if(m_strPathName.empty())
		return OPS_HASNOINSTANCE;
	if(::PathFileExistsW(pwszDestination))
		return OPS_ALREADYEXISTS;
	if(m_bReadOnly)
		return OPS_MODEISREADONLY;

	OperationStatus	ops = OPS_OK;
	UINT			nReopenMode = CFile::modeNoTruncate;

	switch(static_cast<int>(m_fomMode)) {
		case FOM_DENYWRITE:		nReopenMode |= CFile::modeRead | CFile::shareDenyWrite;		break;
		case FOM_DENYREAD:		nReopenMode |= CFile::modeReadWrite | CFile::shareDenyRead;	break;
		case FOM_DENYNONE:
		case FOM_ASREADONLY:	nReopenMode |= CFile::modeRead | CFile::shareDenyNone;		break;
	}

	m_oFile.Close();
	if(!::MoveFileW(m_strPathName.c_str(), pwszDestination))
		ops = OPS_UNKNOWNERROR;
	else {
		m_strPathName = pwszDestination;
		m_strTitle = ::PathFindFileNameW(pwszDestination);
	}
	// bN悤Ƃ
	if(!m_oFile.Open(m_strPathName, nReopenMode, false)) {
		if(m_oFile.Open(m_strPathName.c_str(), CFile::modeRead | CFile::modeNoTruncate, false)) {
			m_fomMode = FOM_ASREADONLY;
			if(!m_bReadOnly) {
				ops = OPS_OPENEDASREADONLY;
				m_bReadOnly = true;
			}
		} else
			return OPS_CANNOTOPEN;
	}
	return ops;
}

/**
 *	hD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Redo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetRedoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_oUpdateInfo.usSummary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Redo();
	EndEditCollection();
	m_oUpdateInfo.usSummary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		m_bModified = false;
		for_each(m_setEventListeners.begin(),
			m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
}

/**
 *	hLg̕ۑ
 *	@param strPathName		t@C̃pX
 *	@param sdo				IvV
 *	@param bt				ꂷsR[h
 *	@param cp				R[hy[WBȗƌ݂̃R[hy[Wgp
 *	@return					݌ʁB SS_OK
 */
StreamStatus CEditDoc::SaveDocument(const wstring& strPathName,
		SaveDocumentOption sdo, BreakType bt, UINT cp /* = EXCP_AUTODETECT */) {
	AssertValid();

	// R[hy[WCXg[Ă邩
	if(!CEncoder::IsValidCodePage(cp))
		return SS_ILLEGALCODEPAGE;
	if(CEncoder::IsCodePageForAutoDetection(cp))	// ݂̃R[hy[Wg
		cp = m_nCodePage;

	// ϊR[hy[Wŕ\łȂ邩
/*	if(!toBoolean(sdo & SDO_IGNORE_NOFITCHARS)
			&& cp != EXTCP_UTF16LE
			&& cp != EXTCP_UTF16BE
			&& cp != EXTCP_UTF32LE
			&& cp != EXTCP_UTF32BE
			&& cp != EXTCP_UTF5
			&& cp != 50221) {
		BOOL	bUsedDefaultChar = FALSE;
		wstring	strText;
		GetAllLines(strText);
		::WideCharToMultiByte(nCodePage, 0, strText.c_str(), strText.length(), 0, 0, 0, &bUsedDefaultChar);
		if(toBoolean(bUsedDefaultChar))
			return SS_WRITE_CONTAININVALIDCHAR;
	}*/

	CWaitCursor		wc;
	StreamStatus	ss = SS_OK;

	// fobO͏ɃobNAbv (㏑̏ꍇ̂)
#ifdef _DEBUG
	if(toBoolean(::PathFileExistsW(strPathName.c_str()))) {
		wchar_t	wszBackupPath[MAX_PATH + 1];
		SHFILEOPSTRUCTW	shfos = {
			0, FO_DELETE, wszBackupPath, 0, FOF_ALLOWUNDO | FOF_NOCONFIRMATION | FOF_SILENT, false, 0
		};
		wcscpy(wszBackupPath, strPathName.c_str());
		wcscat(wszBackupPath, L".bak");
		*(wszBackupPath + wcslen(wszBackupPath) + 1) = 0;
		::CopyFileW(strPathName.c_str(), wszBackupPath, false);
		::SHFileOperationW(&shfos);	// ݔɎĂ
	}
#endif

	// Vt@CJ
	try {
		if(m_oFile.IsOpened())
			m_oFile.Close();
		m_oFile.Open(strPathName, CFile::modeReadWrite | CFile::shareDenyWrite | CFile::modeCreate);
	} catch(CFileException&) {	// ߂Ȃꍇ͈ȑÕt@CJȂ
		m_oFile.Open(m_strPathName, (m_bReadOnly ? CFile::modeRead : CFile::modeReadWrite)
			| CFile::shareDenyWrite | CFile::modeCreate | CFile::modeNoTruncate);
		return SS_UNKNOWNERROR;
	}

	CEncoder*	pEncoder = CEncoder::Create(cp);
	HGLOBAL		hGlobal = 0;
	char*		pszBuffer = 0;

	assert(pEncoder != 0);

	// BOM
	if(toBoolean(sdo & SDO_WRITE_BOM)) {
		const ByteOrderMark*	pBom = pEncoder->GetByteOrderMark();
		if(pBom->cBytes > 0)
			m_oFile.Write(pBom->pszBOM, pBom->cBytes);
	}

	// sR[ȟ
	if(bt != BT_AUTO)
		m_breakType = bt;

	// 1sϊĂ珑
	CEditDocLineList::iterator	it = m_listLines.begin();
	length_t					cLine = GetLineCount();	// s
	length_t					cchLine;				// R[hϊO̒
	length_t					len;					// R[hϊ̒
	wstring						strLine;				// 1s

	for(length_t iLine = 0; iLine < cLine; ++iLine, ++it) {
		it->m_cOperationHistory = 0;	// 엚
		if(bt != BT_AUTO)
			it->m_breakType = bt;		// sR[h㏑
		strLine = it->m_strLine;
		if(iLine != cLine - 1)
			strLine += GetBreakString(it->m_breakType);

		// R[h̕ϊ
		cchLine = GetLineLength(iLine);
		if(iLine == cLine - 1) {	// ŏIs
			if(cchLine == 0)
				break;
		} else
			cchLine += (((bt == BT_AUTO) ? it->m_breakType : m_breakType) == BT_CRLF) ? 2 : 1;

		const std::size_t	cBytes = pEncoder->GetMaxCharacterLength() * cchLine;

		hGlobal = ::GlobalAlloc(GHND, cBytes);
		pszBuffer = static_cast<char*>(::GlobalLock(hGlobal));
		len = pEncoder->ConvertFromUnicode(pszBuffer, cBytes, strLine.c_str(), cchLine);
		m_oFile.Write(pszBuffer, len);
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
	}
	delete pEncoder;

	m_oFile.Close();

	// t@C̃bN
	try {
		if(m_fomMode == FOM_DENYWRITE || m_fomMode == FOM_DENYREAD) {
			if(!LockCurrentFile(m_fomMode))
				ss = SS_LOCKDENIED;
		}
	} catch(CFileException&) {
		ss = SS_LOCKDENIED;
	}

	m_pUndoManager->OnSave();
	m_bModified = false;
	m_bReadOnly = false;
	m_breakType = (bt != BT_AUTO) ? bt : m_breakType;
	m_nCodePage = cp;
	m_strPathName = strPathName;
	m_strTitle = m_strPathName.substr(m_strPathName.rfind(L'\\') + 1);

	// ŏIXV̍XV
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind = ::FindFirstFileW(m_strPathName.c_str(), &wfd);
	if(hFind != INVALID_HANDLE_VALUE) {
		m_lastWriteTime = wfd.ftLastWriteTime;
		::FindClose(hFind);
	}

	// r[ɒʒm
	m_oUpdateInfo.usSummary = US_SAVEDOCUMENT;
	UpdateAllViews(this, 0, this);

	for_each(m_setEventListeners.begin(),
		m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//	for(set<IEditDocEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnDocumentModified();
	return ss;
}

/**
 *	݂̃t@C[֑M
 *	@param bAsAttachment	Ytt@CƂđM邩ǂBYtt@Cɂꍇ
 *							݂̕ύX͔fȂB{ƂđMꍇ݂͌̃hLggp
 *	@param bShowDialog		[UI_CAO\邩ǂ
 *	@return					
 */
bool CEditDoc::SendCurrentFile(bool bAsAttachment, bool bShowDialog /* = true */) {
	AssertValid();

	if(bAsAttachment && m_strPathName.empty())
		return false;

	HINSTANCE		hInstance;
	MAPISENDMAIL*	lpfnMAPISendMail;
	MapiMessage		msg;
	MapiFileDesc	fileDesc;
	char			szFilePath[MAX_PATH];
	char*			pszContent = 0;
	wchar_t*		pwszContent = 0;
	unsigned long	cchDocument;
	unsigned long	nErr;
	CWaitCursor		wc;
	
	hInstance = ::LoadLibraryA("MAPI32.DLL");
	if(hInstance == 0)
		return false;
	reinterpret_cast<FARPROC&>(lpfnMAPISendMail) = ::GetProcAddress(hInstance, "MAPISendMail");
	if(lpfnMAPISendMail == 0) {
		::FreeLibrary(hInstance);
		return false;
	}


	ZeroMemory(&msg, sizeof(MapiMessage));
	msg.flFlags = MAPI_RECEIPT_REQUESTED;

	if(bAsAttachment) {	// Ytt@CɂƂ
		setlocale(LC_CTYPE, "");
		int	cConverted = wcstombs(szFilePath, m_strPathName.c_str(), MAX_PATH);
		assert(cConverted != -1);
		*(szFilePath + cConverted) = 0;
		msg.nFileCount = 1;
		msg.lpFiles = &fileDesc;

		ZeroMemory(&fileDesc, sizeof(MapiFileDesc));
		fileDesc.lpszPathName = szFilePath;
		fileDesc.nPosition = static_cast<unsigned long>(-1);
	} else {	// {ƂđMƂ
		length_t		i = 0;
		length_t		iLine = 0;
		LineIterator	it;
		CEditDocLine	oLine;

		cchDocument = GetDocumentLength();
		pwszContent = new wchar_t[cchDocument + 1];

		for(it = m_listLines.begin(); ; ++it, ++iLine) {
			oLine = *it;
			wcsncpy(pwszContent + i, oLine.m_strLine.c_str(), oLine.m_strLine.length());
			i += oLine.m_strLine.length();
			if(iLine != m_listLines.size() - 1) {
				wcscpy(pwszContent + i, GetBreakString(oLine.m_breakType).c_str());
				i += GetBreakString(oLine.m_breakType).length();
			} else
				break;
		}
		*(pwszContent + cchDocument) = 0;

		// }`oCgɕϊ
		setlocale(LC_CTYPE, "");
		size_t	cchContent = wcstombs(0, pwszContent, 0);
		pszContent = new char[cchContent + 1];
		wcstombs(pszContent, pwszContent, cchContent);
		*(pszContent + cchContent) = 0;
		msg.lpszNoteText = pszContent;
		delete[] pwszContent;
		pwszContent = 0;
	}

	nErr = lpfnMAPISendMail(0, 0, &msg, MAPI_LOGON_UI | (bShowDialog ? MAPI_DIALOG : 0), 0);
	if(pszContent != 0) {
		delete[] pszContent;
		pszContent = 0;
	}
	::FreeLibrary(hInstance);

	if(nErr != SUCCESS_SUCCESS
			&& nErr != MAPI_USER_ABORT
			&& nErr != MAPI_E_LOGIN_FAILURE)
		return false;
	return true;
}

///	::SetTimer ̃R[obN֐B1000~bƂɌĂяoA
///	t@CvZXŕύXĂȂĎ
void CALLBACK CEditDoc::TimerProc(HWND hWnd, UINT nMsg, TIMERPROC_3RD_PARAM_TYPE idEvent, DWORD dwTime) {
	map<UINT, CEditDoc*>::iterator	it = CEditDoc::m_mapDocuments.find(idEvent);
	if(it != CEditDoc::m_mapDocuments.end())
		it->second->CheckFileLastWriteTime();
}

/**
 *	AhD̎s
 *	@throw EDocumentIsReadOnly	ǂݎp̂ƂX[
 */
void CEditDoc::Undo() throw(EDocumentIsReadOnly) {
	AssertValid();
	if(m_bReadOnly)
		throw EDocumentIsReadOnly();
	if(m_pUndoManager->GetUndoBufferLength() == 0)
		return;

	BeginEditCollection();
	m_oUpdateInfo.usSummary = US_BEGIN_UNDOGROUP;
	UpdateAllViews(this, 0, this);
	m_pUndoManager->Undo();
	EndEditCollection();
	m_oUpdateInfo.usSummary = US_END_UNDOGROUP;
	UpdateAllViews(this, 0, this);

	if(!m_pUndoManager->IsModifiedSinceLastSave()) {
		m_bModified = false;
		for_each(m_setEventListeners.begin(),
			m_setEventListeners.end(), mem_fun(IEditDocEventListener::OnDocumentModified));
//		for(set<IEditDocEventListener*>::iterator it
//				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//			(*it)->OnDocumentModified();
	}
}

/* [EOF] */