// EditDoc.h
// (c) 2003-2004 exeal

#ifndef _EDIT_DOC_H_
#define _EDIT_DOC_H_

#include <stack>
#include <map>
#include <set>
#include "AscensionCommon.h"
#include "..\..\Manah\SmallObject.h"
#include "..\..\Manah\DocumentView.h"
#include "..\..\Manah\Encoder.h"
#include "..\..\Manah\File.h"


namespace Ascension {

class CEditDoc;
class CEditController;

// SetTimer ̑4̖
#if(_MSC_VER < 1300)
#define TIMERPROC_3RD_PARAM_TYPE	UINT
#else
#define TIMERPROC_3RD_PARAM_TYPE	UINT_PTR
#endif


// COperation interface definition
/////////////////////////////////////////////////////////////////////////////

class COperationUnit;

/**
 *	炩̕ҏW
 *	@see	CDeleteOperation, CInsertOperation
 */
interface IOperation {
	///	fXgN^
	virtual ~IOperation() {}
	///  <var>pOperationUnit</var> Ɍ
	virtual void	Concat(COperationUnit* pOperationUnit) = 0;
	/// s
	virtual void	Execute(CEditDoc* pDoc) = 0;
};


// CInsertOperation class definition
/////////////////////////////////////////////////////////////////////////////

class CDeleteOperation;
class COperationUnit;

///	1̑}
class CInsertOperation : public IOperation, public Manah::Windows::CSmallObject<> {

	friend class CDeleteOperation;
	friend class COperationUnit;
	// f[^o
private:
	bool		m_bType;	// ̎ (true: }Afalse: 폜)
	CCharPos	m_pos;		// }ʒu
	string_t	m_strText;	// }

	// RXgN^
public:
	CInsertOperation(const CCharPos& pos, const string_t& strText);

	// \bh
public:
	virtual void	Concat(COperationUnit* pOperationUnit);
	virtual void	Execute(CEditDoc* pDoc);
};


// CInsertOperation class definition
/////////////////////////////////////////////////////////////////////////////

///	1̍폜
class CDeleteOperation : public IOperation, public Manah::Windows::CSmallObject<> {

	friend class CInsertOperation;
	friend class COperationUnit;

	// f[^o
private:
	bool		m_bType;	// ̎ (true: }Afalse: 폜)
	CCharPos	m_posBegin;	// 폜Jn_
	CCharPos	m_posEnd;	// 폜I_

	// RXgN^
public:
	CDeleteOperation(const CCharPos& posBegin, const CCharPos& posEnd);

	// \bh
public:
	virtual void	Concat(COperationUnit* pOperationUnit);
	virtual void	Execute(CEditDoc* pDoc);
};


// COpearionUnit class definition
/////////////////////////////////////////////////////////////////////////////

///	܂Ƃ߂ăAhD/hD\ȈȂ
class COperationUnit : public Manah::Windows::CSmallObject<> {
	// RXgN^
public:
	virtual ~COperationUnit();

	// \bh
public:
	void		Execute(CEditDoc* pDoc);
	IOperation*	Pop();
	void		Push(IOperation* pOperation);
	IOperation*	Top() const;

	// f[^o
private:
	std::stack<IOperation*>	m_stkOpes;	// ̒PʂɊ܂܂Ȃ
};


// CEditDoc class definition
/////////////////////////////////////////////////////////////////////////////

/// sR[h
enum BreakType {
	/// ϊAw薳Ȃ
	BT_AUTO,
	/// sBUnix W (Lf, U+000A)
	BT_LF,
	/// BMacintosh W (Cr, U+000D)
	BT_CR,
	/// +sBWindows W (CrLf, U+000D U+000A)
	BT_CRLF,
	///	Vs (U+0085)
	BT_NEL,
	/// s؂ (U+2028)
	BT_LS,
	/// i؂ (U+2029)
	BT_PS
};

///	t@C̃I[v[h
enum FileOpenMode {
	///	bNȂ
	FOM_DENYNONE,
	///	̏ݖړĨt@CI[v
	FOM_DENYWRITE,
	///	̓ǂݍݖړĨt@CI[v
	FOM_DENYREAD,
	///	ǂݎpƂĊJ (bN͖)
	FOM_ASREADONLY
};

/// LoadDocument ASaveDocument ŕԂl
enum StreamStatus {
	/// t@C͐Ƀ[h/Z[uꂽ
	SS_OK						= 0x00,
	/// t@C̓ǂݎ/݂ۂꂽ
	SS_ACCESSDENIED				= 0x01,
	/// t@C̃bNۂꂽ
	SS_LOCKDENIED				= 0x02,
	/// w肳ꂽR[hy[WȂ
	SS_ILLEGALCODEPAGE			= 0x03,
	///	s̃G[
	SS_UNKNOWNERROR				= 0x04,	
	/// t@Cւ̃ANZXĂ߂ɁAǂݎp[hŊJ
	SS_READ_READONLY			= 0x11,
	/// t@C̕R[h𔻕ʂłȂ
	SS_READ_UNKNOWNCHARCODE		= 0x12,
	/// t@Cɕsȕ܂܂ĂߊSɓǂݍ߂Ȃ
	SS_READ_ILLEGALCHAR			= 0x13,
	/// ǂݍރt@C傫
	SS_READ_HUGEFILE			= 0x14,
	/// w肳ꂽt@C݂Ȃ
	SS_READ_NOEXISTS			= 0x15,
	///	NłȂ
	SS_READ_CANNOTRESOLVELINK	= 0x16,
	/// L}̂ɏނ߂̗̈悪
	SS_WRITE_FULLDISK			= 0x21,
	/// ǂݎp[hA܂͓ǂݎp̃t@CɏƂ
	SS_WRITE_READONLY			= 0x22,
	///	ϊR[hy[WɑΉ镶
	SS_WRITE_CONTAININVALIDCHAR	= 0x23,
};

/// CopyCurrentFile ADeleteCurrentFile AMoveCurrentFile ŕԂl
enum OperationStatus {
	/// t@C͐ɏI
	OPS_OK,
	/// [U𒆒f (ݔֈړ ̂ݗL)
	OPS_ABORTED,
	/// ǂݎp[hŊJĂ̂ŏłȂ
	OPS_MODEISREADONLY,
	/// Rs[Aړɓ̃t@C݂,
	OPS_ALREADYEXISTS,
	/// t@CJƂɓǂݎpŊJ
	OPS_OPENEDASREADONLY,
	/// t@CĴɎs
	OPS_CANNOTOPEN,
	/// \bhsɃt@CJĂȂ
	OPS_HASNOINSTANCE,
	/// m̃G[ (G[bZ[W GetLastError 擾\)
	OPS_UNKNOWNERROR,
};

///	CEditView::OnUpdate ̍XV̎
enum UpdateSummary {
	///	}
	US_OPERATION_INSERT,
	///	폜
	US_OPERATION_DELETE,
	///	AhD/hD̊Jn
	US_BEGIN_UNDOGROUP,
	///	AhD/hD̏I
	US_END_UNDOGROUP,
	///	hLgۑ
	US_SAVEDOCUMENT,
};

///	CEditDoc::GetModification œXV
struct TUpdateInfo {
	///	UpdateSummary Q
	UpdateSummary	usSummary;
	///	ΏۊJnʒu
	CCharPos		posBegin;
	///	ΏۏIʒu (posBegin &lt;= posEnd)
	CCharPos		posEnd;
	///	I̐Lbgʒu
	CCharPos		posResult;
};

///	hLgǂݎp̂ƂҏW悤ƂƃX[
class EDocumentIsReadOnly : public std::logic_error {
public:
	EDocumentIsReadOnly()
			: std::logic_error("Document is readonly. Any edit process is denied.") {
	}
};

///	s̓e
class CEditDocLine : public Manah::Windows::CSmallObject<> {
	friend class CEditDoc;

	// f[^o
private:
	string_t		m_strLine;				// s
	BreakType		m_breakType;			// s̎
	unsigned long	m_cOperationHistory;	// AhDJE^ (0ŕύX̏)

	// RXgN^
public:
	explicit CEditDocLine(string_t& strLine = string_t(L""), BreakType breakType = BT_AUTO, bool bModified = false)
		: m_strLine(strLine), m_breakType(breakType), m_cOperationHistory(bModified ? 1 : 0) {
	}

	// \bh
public:
	const string_t&	GetLine() const {
		return m_strLine;
	}
	BreakType	GetBreakType() const {
		return m_breakType;
	}
	bool	IsModified() const {
		return m_cOperationHistory != 0;
	}
};

///	hLg̒ʒm󂯎Cxgnh
interface IEditDocEventListener {
	///	fXgN^
	virtual ~IEditDocEventListener() {
	}
	///	hLgύXꂽ
	virtual void	OnDocumentModified() = 0;
	/**
	 *	t@COvZXŕύXꂽ
	 *	@param pDocument	hLg
	 */
	virtual void	OnDocumentOverwrittenByOtherProcess(CEditDoc* pDocument) = 0;
};

typedef std::list<CEditDocLine>				CEditDocLineList;
typedef CEditDocLineList::const_iterator	LineIterator;

typedef unsigned short	SaveDocumentOption;
const SaveDocumentOption	SDO_WRITE_BOM			= 0x0001;	///	BOM 
const SaveDocumentOption	SDO_IGNORE_NOFITCHARS	= 0x0002;	///	ΉȂɑ΂Ċ̕ւ

/**
 *	@brief	Ascension eLXgGfB^̃hLg
 *
 *	SĂ̍s̓eA엚AR[hy[WAsR[hȂǂB
 *	t@Cs
 *
 *	<h3>AhDO[v̊TO</h3>
 *
 *	Ascension GfB^ɂ́Ȃ܂Ƃ߂ăAhD/hDł悤
 *	AhDO[vƂTOB^CsOɂA͂̈ꊇ
 *	쑤̎dłBCEditView ACEditPoint ͂Ƃɂ̑Ă邽߁A
 *	̃NXgăhLgҏWꍇA[U̓^CsOɂꊇ
 *	̂߂̃R[hKv͖
 *
 *	̑AhDO[vƂɂ͈Ȃ̑O
 *	CEditDoc::BeginEditCollection 1xĂяoBđ삪I
 *	CEditDoc::EndEditCollection Ăяo
 *
 *	@see	CEditView, CEditController, CEditPoint
 */
class CEditDoc : public Manah::Windows::CDocument {

	// CUndoManager class definition
	/////////////////////////////////////////////////////////////////////////

	///	AhDAhDǗ
	class CUndoManager /*: public Manah::CObject*/ {
		// RXgN^
	public:
		CUndoManager(CEditDoc* pDoc);
		virtual ~CUndoManager();

		// \bh
	public:
		void		Clear();						// obt@ɂ
		std::size_t	GetRedoBufferLength() const;	// hD\ȉ񐔂Ԃ
		std::size_t	GetUndoBufferLength() const;	// AhD\ȉ񐔂Ԃ
		bool		IsModifiedSinceLastSave() const;
		void		OnSave();
		void		PushUndoBuffer(					// AhDobt@ɑǉ
						IOperation* pOperation, bool bConcatPrev);
		void		Redo();							// hLgɃhDs
		void		Undo();							// hLgɃAhDs

		// f[^o
	private:
		CEditDoc*					m_pDoc;				// ΏۃhLg
		std::stack<COperationUnit*>	m_stkUndo;			// AhDX^bN
		std::stack<COperationUnit*>	m_stkRedo;			// hDX^bN
		bool						m_bVirtual;			// ẑƂ^
		COperationUnit*				m_pVirtualUnit;		// zǉ鑀P
		COperationUnit*				m_pLastUnit;		// ŌɒǉꂽP
		IOperation*					m_pSavedOperation;	// ۑɖɂȂĂ
	};

	///	AhDO[v̏
	enum UndoGroupingState {
		UGS_NONE,				///	O[sO͍sĂȂ
		UGS_WAITFORFIRSTEDIT,	///	O[sOJnҏW1xsĂȂ
		UGS_WAITFORCONTINUEEDIT	///	O[sOJn1xȏҏWsꂽ
	};

	// f[^o
public:
	static const char_t	m_wszBreakChars[6];		// s̏W
private:
	bool						m_bIgnoreViews;	// OnUpdate ĂяoKvƂ true (t@CǂݍݓrȂ)
	bool						m_bReadOnly;	// ǂݎp[h (ǂݍݎɐݒ肳s)
	FileOpenMode				m_fomMode;		// t@C̋L[h (FOM_ASREADONLY ͖Ӗ)
	Manah::Text::CodePage		m_nCodePage;	// R[hy[W
	BreakType					m_breakType;	// sR[h (L[{[h͂ɂsɎgp)
	CEditDocLineList			m_listLines;	// s
	Manah::Windows::IO::CFile	m_oFile;		// ݊JĂt@C
	CUndoManager*				m_pUndoManager;	// AhD/hD̊Ǘ
	TUpdateInfo					m_oUpdateInfo;	// Ō̍XV
	UndoGroupingState			m_ugsGroupingState;			// AhDO[v̎W
	bool						m_bOnceUndoBufferCleared;	// 1xȏAhDobt@NA

	bool						m_bVirtualOperating;	// AhD/hDɂ DeleteText AInsertText
														// \bhĂяôƂ true B
														// true ̊Ԃ͗\bhŃhDX^bNNAȂ

	std::set<IEditDocEventListener*>	m_setEventListeners;	// CxgXi
	FILETIME					m_lastWriteTime;	// t@C̍ŏIXV
	UINT						m_nTimerId;			// ^C} ID
	static std::map<UINT, CEditDoc*>	m_mapDocuments;	// ^C} ID -> hLg̃}bv

	mutable length_t							m_iLineCache_;	// GetInternalLineIterator LbVpf[^
	mutable CEditDocLineList::iterator			m_itCache_;
	mutable length_t							m_iLineCache;	// GetLineIterator LbVpf[^
	mutable CEditDocLineList::const_iterator	m_itCache;

	// RXgN^
public:
	CEditDoc(CEditController* pController = 0);
	virtual ~CEditDoc();

	// \bh
public:
	// CxgXi
	void	AddEventListener(IEditDocEventListener* pEventListener);
	void	RemoveEventListener(IEditDocEventListener* pEventListener);

	// hLgANZX
	void				ClearUndoBuffer();
	void				GetAllLines(std::wstring& strText) const;
	CEditController*	GetController() const;
	length_t			GetDocumentLength() const;
	const string_t&		GetLine(length_t iLine) const throw(std::out_of_range);
	length_t			GetLineCount() const;
	length_t			GetLineIndex(length_t iLine,
							bool bIncludeBreak) const throw(std::out_of_range);
	const CEditDocLine*	GetLineInfo(length_t iLine) const throw(std::out_of_range);
	LineIterator		GetLineIterator(length_t iLine) const throw(std::out_of_range);
	length_t			GetLineLength(length_t iLine) const throw(std::out_of_range);
	void				GetModification(TUpdateInfo& oUpdateInfo) const;
	FileOpenMode		GetShareMode() const;
	unsigned long		GetUndoHistoryLength(bool bRedo = false) const;
	void				InitiateDocument();
	bool				IsReadOnly() const;
	void				SetReadOnly(bool bReadOnly = true);

	// ҏW
	void		BeginEditCollection();
	CCharPos	DeleteText(Manah::CObject* pSender,
					const CCharPos& posBegin,
					const CCharPos& posEnd) throw(EDocumentIsReadOnly);
	void		EndEditCollection();
	CCharPos	InsertText(Manah::CObject* pSender,
					const CCharPos& pos,
					const string_t& strText) throw(EDocumentIsReadOnly);
	bool		IsCollectingEdit() const;
	void		Redo() throw(EDocumentIsReadOnly);
	void		Undo() throw(EDocumentIsReadOnly);

	// R[h
	static string_t			GetBreakString(BreakType bt);
	BreakType				GetBreakType() const;
	Manah::Text::CodePage	GetCodePage() const;
	void					SetBreakType(BreakType bt) throw(std::invalid_argument);
	void					SetCodePage(Manah::Text::CodePage cp) throw(std::invalid_argument);

	// t@C <-> hLg
	bool			CloseDocument();
	StreamStatus	LoadDocument(const std::wstring& strPathName,
						FileOpenMode fom, Manah::Text::CodePage cp = Manah::Text::CPEX_AUTODETECT_USERLANG);
	StreamStatus	SaveDocument(const std::wstring& strPathName, SaveDocumentOption sdo,
						BreakType bt, Manah::Text::CodePage cp = Manah::Text::CPEX_AUTODETECT);

	// ɊJĂt@Cɑ΂鏈
	OperationStatus	CopyCurrentFile(const wchar_t* pwszDestination);
	OperationStatus	DeleteCurrentFile() throw(EDocumentIsReadOnly);
	bool			LockCurrentFile(FileOpenMode fom);
	OperationStatus	MoveCurrentFile(const wchar_t* pwszDestination);
	bool			SendCurrentFile(bool bAsAttachment, bool bShowDialog = true);

protected:
	CEditDocLineList::iterator
		GetInternalLineIterator(length_t iLine) const throw(std::out_of_range);
	void	CheckFileLastWriteTime();
private:
	static void CALLBACK	TimerProc(HWND hWnd, UINT nMsg, TIMERPROC_3RD_PARAM_TYPE idEvent, DWORD dwTime);

public:
	virtual bool	OnNewDocument();
	virtual bool	OnOpenDocument(const std::wstring& strPathName);
	virtual bool	OnSaveDocument(const std::wstring& strPathName);
};


// CEditDoc class inline implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	CxgXi̒ǉ
 *	@param pEventListener	VCxgXi
 */
inline void CEditDoc::AddEventListener(IEditDocEventListener* pEventListener) {
	AssertValid();
	assert(pEventListener != 0);
	m_setEventListeners.insert(pEventListener);
}

///	AhDO[v̎WJnB
///	ݎWł΁AxIAVWJn
inline void CEditDoc::BeginEditCollection() {
	AssertValid();

	if(m_ugsGroupingState != UGS_NONE)
		EndEditCollection();
	m_ugsGroupingState = UGS_WAITFORFIRSTEDIT;
}

///	AhD/hDX^bNɂė
inline void CEditDoc::ClearUndoBuffer() {
	AssertValid();
	m_pUndoManager->Clear();
	m_bOnceUndoBufferCleared = true;
}

///	hLg OnCloseDocument Ă
inline bool CEditDoc::CloseDocument() {
	AssertValid();
	m_oFile.Close();
	InitiateDocument();
	OnCloseDocument();
	return true;
}

///	AhDO[v̎WI
inline void CEditDoc::EndEditCollection() {
	AssertValid();
	m_ugsGroupingState = UGS_NONE;
}

///	sR[h̉sԂ
inline string_t CEditDoc::GetBreakString(BreakType bt) {
	switch(bt) {
	case BT_AUTO:	return L"";
	case BT_LF:		return L"\n";
	case BT_CR:		return L"\r";
	case BT_CRLF:	return L"\r\n";
	case BT_NEL:	return wstring(1, 0x0085);	// VC6
	case BT_LS:		return L"\x2028";
	case BT_PS:		return L"\x2029";
	default:		assert(false);
	}
	return L"";	// ɂ͗Ȃ
}

///	ݎgpĂsR[h擾
inline BreakType CEditDoc::GetBreakType() const {
	AssertValid();
	return m_breakType;
}

///	ݎgpĂR[hy[W擾
inline UINT CEditDoc::GetCodePage() const {
	AssertValid();
	return m_nCodePage;
}

///	Rg[擾
inline CEditController* CEditDoc::GetController() const {
	AssertValid();
	return reinterpret_cast<CEditController*>(m_pController);
}

/**
 *	w肵s̃eLXg擾B
 *	s݂Ȃ <code>out_of_range</code> 𓊂
 */
inline const wstring& CEditDoc::GetLine(length_t iLine) const throw(std::out_of_range) {
	AssertValid();
	try {
		return GetLineInfo(iLine)->m_strLine;
	} catch(std::out_of_range& e) {
		throw e;
	}
}

///	s擾
inline length_t CEditDoc::GetLineCount() const {
	AssertValid();
	return m_listLines.size();
}

///	sꊇĎ擾
inline const CEditDocLine* CEditDoc::GetLineInfo(length_t iLine) const throw(std::out_of_range) {
	AssertValid();

	try {
		return &(*GetLineIterator(iLine));
	} catch(std::out_of_range& e) {
		throw e;
	}
}

///	w肵s̒擾Bs݂Ȃ <code>out_of_range</code> 𓊂
inline length_t CEditDoc::GetLineLength(length_t iLine) const throw(std::out_of_range) {
	AssertValid();
	try {
		return GetLine(iLine).length();
	} catch(std::out_of_range& e) {
		throw e;
	}
}

///	Ō̍XV擾
inline void CEditDoc::GetModification(TUpdateInfo& oUpdateInfo) const {
	AssertValid();
	oUpdateInfo = m_oUpdateInfo;
}

///	t@C̔r[h擾
inline FileOpenMode CEditDoc::GetShareMode() const {
	AssertValid();
	return m_fomMode;
}

///	AhDAhD\ȉ񐔂擾
inline unsigned long CEditDoc::GetUndoHistoryLength(bool bRedo /* = false */) const {
	AssertValid();
	return bRedo ? m_pUndoManager->GetRedoBufferLength()
		: m_pUndoManager->GetUndoBufferLength();
}

///	AhDO[v̎WԂ
inline bool CEditDoc::IsCollectingEdit() const {
	AssertValid();
	return m_ugsGroupingState != UGS_NONE;
}

///	ǂݎp[hǂԂ
inline bool CEditDoc::IsReadOnly() const {
	AssertValid();
	return m_bReadOnly;
}

/**
 *	CxgXi̍폜
 *	@param pEventListener	폜CxgXi
 */
inline void CEditDoc::RemoveEventListener(IEditDocEventListener* pEventListener) {
	AssertValid();
	assert(pEventListener != 0);
	m_setEventListeners.erase(pEventListener);
}

/**
 *	sR[h̐ݒ
 *	@param breakType		Vݒ肷sR[h
 *	@throw invalid_argument	sR[hȂƂX[
 */
inline void CEditDoc::SetBreakType(BreakType breakType) throw(std::invalid_argument) {
	AssertValid();
	switch(breakType) {
	case BT_LF:		case BT_CR:
	case BT_CRLF:	case BT_NEL:
	case BT_LS:		case BT_PS:
		m_breakType = breakType;
		break;
	default:
		throw std::invalid_argument("Specified break type is invalid.");
	}
}

/**
 *	R[hy[W̐ݒ
 *	@param cp				Vݒ肷R[hy[Wԍ
 *	@throw invalid_argument	R[hy[WpłȂƂX[
 */
inline void CEditDoc::SetCodePage(Manah::Text::CodePage cp) throw(std::invalid_argument) {
	AssertValid();
	if(!Manah::Text::CEncoder::IsValidCodePage(cp)
			|| Manah::Text::CEncoder::IsCodePageForAutoDetection(cp))
		throw std::invalid_argument("Specified code page is not available.");
	m_nCodePage = cp;
}

///	ǂݎp[h̐ݒ
inline void CEditDoc::SetReadOnly(bool bReadOnly /* = true */) {
	AssertValid();
	m_bReadOnly = bReadOnly;
	for(set<IEditDocEventListener*>::iterator it
			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
		(*it)->OnDocumentModified();
}

///	hLgV쐬ƂɌĂяo
inline bool CEditDoc::OnNewDocument() {
	return true;
}

///	hLgǂݍ݂̂߂Ƀt@CJƂɌĂяo
inline bool CEditDoc::OnOpenDocument(const std::wstring& strPathName) {
	return true;
}

///	hLgۑƂɌĂяo
inline bool CEditDoc::OnSaveDocument(const std::wstring& strPathName) {
	return true;
}

} // namespace Ascension


#endif /* _EDIT_DOC_H_ */

/* [EOF] */