// EditView.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "KeywordManager.h"
#include "EditController.h"
#include <limits>	// numeric_limit
#include <algorithm>
#include <zmouse.h>
#include "..\..\Manah\win_utils.h"
#include "..\..\Manah\WaitCursor.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Windows;
using namespace Manah::Text;
using namespace Armaiti;
using namespace std;
using Manah::Windows::GDI::CMinimalDC;
using Armaiti::OLE::CDraggingTextDataObject;


// GlobalElements definition
/////////////////////////////////////////////////////////////////////////////

///	̒r2֐BSetOperators Ŏgp
bool _CompareStringByLength(const string_t& str1, const string_t& str2) {
	return str1.length() > str2.length();
}


// TEditViewFoundationInfo struct implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CEditView::TEditViewFoundationInfo::TEditViewFoundationInfo() : bDrawCurrentUnderline(false),
		bDrawBreakArrow(false), bDrawEOF(false), bDrawSpaces(false),
		bIgnoreCaseOnHilite(false), bPaintBreakContinuingSelection(false),
		bDrawBoldCharsClosely(false),
		strEndOfFile(L"[EOF]"), chTab(L'^'), chIdeographicSpace(L'\x25A1'), chSpace(L'_') {
}

///	Rs[RXgN^
CEditView::TEditViewFoundationInfo::TEditViewFoundationInfo(
		const CEditView::TEditViewFoundationInfo& rhs) {
	bDrawCurrentUnderline = rhs.bDrawCurrentUnderline;
	bDrawBreakArrow = rhs.bDrawBreakArrow;
	bDrawEOF = rhs.bDrawEOF;
	bDrawSpaces = rhs.bDrawSpaces;
	bIgnoreCaseOnHilite = rhs.bIgnoreCaseOnHilite;
	bPaintBreakContinuingSelection = rhs.bPaintBreakContinuingSelection;
	chTab = rhs.chTab;
	chSpace = rhs.chSpace;
	chIdeographicSpace = rhs.chIdeographicSpace;
	strEndOfFile = rhs.strEndOfFile;
}

///	fXgN^
CEditView::TEditViewFoundationInfo::~TEditViewFoundationInfo() {
}


// CClipboardRing class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CClipboardRing::CClipboardRing() : m_nLimit(16), m_nMaxByte(100 * 1024), m_iActive(static_cast<size_type>(-1)) {
}

/**
 *	VeLXgǉB𒴂ꍇ͌Â̂폜
 *	@param strText	VeLXgB1ȏ
 *	@param bBox		`f[^
 */
void CClipboardRing::Add(const string_t& strText, bool bBox) {
	AssertValid();
	assert(!strText.empty());

	if(strText.length() * sizeof(char_t) > m_nMaxByte) {
		for_each(m_setEventListeners.begin(), m_setEventListeners.end(),
			mem_fun(&IClipboardRingEventListener::OnClipboardRingDeniedAdding));
//		for(set<IClipboardRingEventListener*>::iterator it
//				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//			(*it)->OnClipboardRingDeniedAdding();
		return;
	}

	TClipText	ct;
	ct.strText = strText;
	ct.bBox = bBox;
	m_listDatas.push_front(ct);
	if(m_listDatas.size() > m_nLimit)
		m_listDatas.pop_back();
	m_iActive = 0;
	for_each(m_setEventListeners.begin(), m_setEventListeners.end(),
		mem_fun(&IClipboardRingEventListener::OnClipboardRingChanged));
//	for(set<IClipboardRingEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

/**
 *	CxgXi̒ǉ
 *	@param pEventListener	VCxgXi
 */
void CClipboardRing::AddEventListener(IClipboardRingEventListener* pEventListener) {
	AssertValid();
	assert(pEventListener != 0);
	m_setEventListeners.insert(pEventListener);
}

/**
 *	w肵eLXg폜
 *	@param iText		폜eLXg̈ʒu
 *	@throw out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::Delete(size_type iText) throw(out_of_range) {
	AssertValid();
	if(iText >= m_listDatas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::iterator	it = m_listDatas.begin();
	for(size_type i = 0; i < iText; ++i, ++it);
	m_listDatas.erase(it);
	if(iText == m_listDatas.size() && iText == m_iActive)
		--m_iActive;

	for_each(m_setEventListeners.begin(), m_setEventListeners.end(),
		mem_fun(&IClipboardRingEventListener::OnClipboardRingChanged));
//	for(set<IClipboardRingEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

///	SẴeLXg폜
void CClipboardRing::DeleteAll() {
	AssertValid();
	m_listDatas.clear();
	for_each(m_setEventListeners.begin(), m_setEventListeners.end(),
		mem_fun(&IClipboardRingEventListener::OnClipboardRingChanged));
//	for(set<IClipboardRingEventListener*>::iterator it
//			= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//		(*it)->OnClipboardRingChanged();
}

///	ANeBuȃeLXg̈ʒuԂ
///	(eLXg1ꍇÃ\bh͈Ӗ̂lԂȂ)
CClipboardRing::size_type CClipboardRing::GetActiveItem() const {
	AssertValid();
	return m_iActive;
}

///	eLXg̑Ԃ
CClipboardRing::size_type CClipboardRing::GetCount() const {
	AssertValid();
	return m_listDatas.size();
}

/**
 *	w肵ʒũeLXgԂ
 *	@param iText		擾eLXg̈ʒu
 *	@param strText		eLXg
 *	@param bBox			`f[^
 *	@throw out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::GetText(CClipboardRing::size_type iText, string_t& strText, bool& bBox) const throw(out_of_range) {
	AssertValid();
	if(iText >= m_listDatas.size())
		throw out_of_range("Specified index is out of range.");

	list<TClipText>::const_iterator	it = m_listDatas.begin();
	for(size_type i = 0; i < iText; ++i, ++it);

	strText = it->strText;
	bBox = it->bBox;
}

/**
 *	eLXg̏ݒ肷Bꂽ͍폜
 *	@param nLimit	VlB0ȊO
 */
void CClipboardRing::LimitCount(CClipboardRing::size_type nLimit) {
	AssertValid();
	assert(nLimit > 0);

	m_nLimit = nLimit;
	if(m_listDatas.size() > m_nLimit) {
		m_listDatas.resize(m_nLimit);
		for_each(m_setEventListeners.begin(), m_setEventListeners.end(),
			mem_fun(&IClipboardRingEventListener::OnClipboardRingChanged));
//		for(set<IClipboardRingEventListener*>::iterator it
//				= m_setEventListeners.begin(); it != m_setEventListeners.end(); ++it)
//			(*it)->OnClipboardRingChanged();
	}
}

/**
 *	ANeBuȃeLXg̐ݒ
 *	@param iText		ANeBuɂeLXg̈ʒu
 *	@throw out_of_range	<var>iText</var> L͈͊ÔƂX[
 */
void CClipboardRing::SetActiveItem(CClipboardRing::size_type iText) throw(out_of_range) {
	AssertValid();
	if(iText >= m_listDatas.size())
		throw out_of_range("Specified index is out of range.");
	m_iActive = iText;
}


// CEditView class implementation
/////////////////////////////////////////////////////////////////////////////

// ÓIo
bool					CEditView::m_bRegistered = false;
CClipboardRing			CEditView::m_oClipboardRing;
CTextSearcher			CEditView::m_oTextSearcher;
map<string_t, string_t>	CEditView::m_mapAbbreviations;
length_t				CEditView::m_cchMaxAbbreviation = 0;

/// RXgN^
CEditView::CEditView() : m_hContextMenu(0), m_pwszTipText(0),
		m_pEventListeners(new set<IEditViewEventListener*>),
		m_pTokenFoundations(new TTokenFoundations),
		m_bActiveIMEComposition(false),
		m_ldmLeftDown(LDM_NONE), m_nccNextCharConvert(NCC_NONE),
		m_nFreezeCount(0), m_iFirstVisibleLine(0) {
	m_pBoundarySearcher = new CBoundarySearcher(*this);
	m_pOriginalView = this;	// C4345 (VC7)
	m_pAnchorPoint = new CVisibleEditPoint(this);
	m_pActivePoint = new CVisibleEditPoint(this);
	m_pDragging = new Armaiti::OLE::CDraggingTextDataObject(this);
	m_pDragging->AddRef();
	m_pLineLayoutManager = new CLineLayoutManager(this);
	m_pKeyMacroPlayer = CKeyMacroPlayer::Create();
	m_pwndAutoComplete = new CAutoCompleteWnd(this);

	m_ptScroll.x = 0;
	m_ptScroll.y = 0;
	m_eoLast.type = EOT_NONE;
}

///	Rs[RXgN^
CEditView::CEditView(const CEditView& rhs) : CView(rhs), IUnknownImpl<NoRefCount>(),
		m_hContextMenu(0), m_pwszTipText(0), m_pEventListeners(rhs.m_pEventListeners),
		m_foundationInfo(rhs.m_foundationInfo) {
	// 񋤗Lo͎ō쐬BLo̓Rs[
	m_pBoundarySearcher = new CBoundarySearcher(*this);
	m_pDragging = new CDraggingTextDataObject(this);
	m_pDragging->AddRef();
	m_pKeyMacroPlayer = rhs.m_pKeyMacroPlayer;
	m_pwndAutoComplete = new CAutoCompleteWnd(this);
	m_pTokenFoundations = rhs.m_pTokenFoundations;

	m_pOriginalView = &const_cast<CEditView&>(rhs);
	m_pOriginalView->m_setClones.insert(this);

	m_layoutInfo = rhs.m_layoutInfo;
	m_pLineLayoutManager = rhs.m_pLineLayoutManager;
	m_modeState = rhs.m_modeState;
	m_AutoComplete = rhs.m_AutoComplete;

	m_bActiveIMEComposition = false;
	m_ldmLeftDown = LDM_NONE;
	m_nccNextCharConvert = NCC_NONE;
	m_nFreezeCount = 0;

	m_pAnchorPoint = new CVisibleEditPoint(*rhs.m_pAnchorPoint);
	m_pActivePoint = new CVisibleEditPoint(*rhs.m_pActivePoint);
	m_pAnchorPoint->m_pView = this;
	m_pActivePoint->m_pView = this;
	m_ptScroll = rhs.m_ptScroll;
	m_iFirstVisibleLine = rhs.m_iFirstVisibleLine;

	LOGFONTW	lf;
	::GetObject(rhs.m_gdiObjects.hNormalFont, sizeof(LOGFONTW), &lf);
	m_gdiObjects.hNormalFont = ::CreateFontIndirectW(&lf);
	::GetObject(rhs.m_gdiObjects.hBoldFont, sizeof(LOGFONTW), &lf);
	m_gdiObjects.hBoldFont = ::CreateFontIndirectW(&lf);
	::GetObject(rhs.m_gdiObjects.hItalicFont, sizeof(LOGFONTW), &lf);
	m_gdiObjects.hItalicFont = ::CreateFontIndirectW(&lf);
	::GetObject(rhs.m_gdiObjects.hBoldItalicFont, sizeof(LOGFONTW), &lf);
	m_gdiObjects.hBoldItalicFont = ::CreateFontIndirectW(&lf);
}

/// fXgN^
CEditView::~CEditView() {
	// 񋤗Lf[^
	delete[] m_pwszTipText;
	delete m_pBoundarySearcher;
	m_pDragging->Release();
	m_pwndAutoComplete->DestroyWindow();
	delete m_pwndAutoComplete;
	delete m_pAnchorPoint;
	delete m_pActivePoint;

	// L
	if(m_pOriginalView == this) {	// 
		if(m_setClones.empty()) {	// Ō
			// ŋLf[^j
			::DestroyMenu(::GetSubMenu(m_hContextMenu, 12));
			::DestroyMenu(::GetSubMenu(m_hContextMenu, 13));
			::DestroyMenu(m_hContextMenu);
			delete m_pEventListeners;
			delete m_pTokenFoundations;
			delete m_pLineLayoutManager;
		} else {	// ̕܂cĂ
			CEditView*	pAlphaClone = *m_setClones.begin();	// V
			pAlphaClone->m_pOriginalView = pAlphaClone;
			pAlphaClone->m_setClones = m_setClones;
			for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
				(*it)->m_pOriginalView = pAlphaClone;
		}
	} else	// IWiɎSʒm
		m_pOriginalView->m_setClones.erase(
			m_pOriginalView->m_setClones.find(this));
}

///	`IJn
void CEditView::BeginBoxSelect() {
	AssertValidAsWindow();

	m_modeState.selectionTraits = ST_RECTANGLE;
	m_layoutInfo.iBoxSelectionAnchorLine = DisplayLineFromLogicalLine(m_pAnchorPoint->m_iLine);
	m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
	m_layoutInfo.xBoxSelectionAnchor = PosFromChar(*m_pAnchorPoint).x - m_layoutInfo.nLeftTabWidth;
	m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x - m_layoutInfo.nLeftTabWidth;
	InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
}

/**
 *	Ń}b`SĂ̍sɃubN}[Nݒ肷
 *	@return	ubN}[Nݒ肵s
 */
unsigned long CEditView::BookmarkAll() {
	AssertValid();

	const CEditDoc*	pDocument = GetDocument();
	const length_t	cLines = GetDocument()->GetLineCount();
	unsigned long	cBookmarked = 0;
	length_t		iFound, cchFound;	// ǂݎ̂

	try {
		for(length_t iLine = 0; iLine < cLines; ++iLine) {
			if(CEditView::m_oTextSearcher.Search(
					pDocument->GetLine(iLine), 0, iFound, cchFound, *m_pBoundarySearcher)) {
				m_pLineLayoutManager->GetLine(iLine)->SetBookmark(true);
				if(m_pOriginalView == this) {
					for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
						(*it)->m_pLineLayoutManager->GetLine(iLine)->SetBookmark(true);
				}
				++cBookmarked;
			}
		}
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		throw;
	} catch(ERegExpPatternIsInvalid& /* e */) {
		throw;
	}

	if(IsWindowVisible())
		InvalidateRect(0, false);
	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->InvalidateRect(0, false);
	}

	return cBookmarked;
}

/**
 *	w肵z|CgɒB̂ɍs̖ɒǉKv̂󔒕ԂB
 *	󔒂͐^uƔp󔒂gpB
 *	s̏I[łɉz|Cg𒴂Ăꍇ͋󕶎ԂB
 *	`\tt[J[\̎Ɏgp
 *	@param iLine	sԍ (\s)
 *	@param xVirtual	r[ x W
 *	@return			Kvȋ󔒕
 */
string_t CEditView::CalculateSpacesReachingVirtualPoint(length_t iLine, unsigned long xVirtual) const {
	AssertValidAsWindow();

	unsigned long	x = PosFromChar(CCharPos(iLine, GetDocument()->GetLineLength(iLine))).x;

	// ]ČvZ
	xVirtual -= m_layoutInfo.nLeftMargin;
	x -= m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;

	if(x >= xVirtual)	// łɒĂ -> I
		return L"";

	stringstream_t	ssSpaces;
	HFONT			hOldFont = const_cast<CEditView*>(this)->m_gdiObjects.oMemDC.SelectObject(m_gdiObjects.hNormalFont);
	long			nSpacePixel = m_gdiObjects.oMemDC.GetTextExtent(L" ", 1).cx;

	const_cast<CEditView*>(this)->m_gdiObjects.oMemDC.SelectObject(hOldFont);

	while(true) {	// xVirtual 𒴂܂Ő^utĂ
		unsigned long	xNextTab = GetNextTabStop(x, m_modeState.bRtlReading);

		if(xNextTab >= xVirtual)
			break;
		ssSpaces << L'\t';
		x = xNextTab;
	}
	while(x + nSpacePixel <= xVirtual) {	// xVirtual 𒴂܂ŔpXy[XtĂ
		ssSpaces << L' ';
		x += nSpacePixel;
	}

	return ssSpaces.str();
}

/**
 *	wsɂr[ x Wɂ镶擾
 *	@param iLine			s
 *	@param x				r[ x W
 *	@param bIgnoreExtender	Lbg󂯎Ȃ𖳎
 *	@param pbTruncated		x ̈ʒuɕꍇ true
 *	@return					
 */
length_t CEditView::CharFromPixel(length_t iLine,
		unsigned long x, bool bIgnoreExtender, bool* pbTruncated /* = 0 */) const {
	assert(iLine < GetDocument()->GetLineCount());

	const CLineLayout*	pLineInfo = m_pLineLayoutManager->GetLine(iLine);
	const string_t&		strLine = GetDocument()->GetLine(iLine);
	const char_t*		pwszLine = strLine.c_str();
	const length_t		cchLine = strLine.length();

	if(pbTruncated != 0)
		*pbTruncated = false;

	// ł߂_T (x@)
	length_t	iNearest = 0;										// ܂łōł߂ʒu
	int			nNearestDistance = std::numeric_limits<int>::max();	// ̋
	for(length_t iChar = 0; iChar <= cchLine; ++iChar) {
		if(iChar != 0 && iChar != cchLine) {
			// ʃTQ[g͖
			if(IsUTF16LowSurrogate(strLine[iChar])
					&& IsUTF16HighSurrogate(strLine[iChar - 1]))
				continue;

			// Lbg󂯎Ȃ𖳎ꍇ
			if(bIgnoreExtender) {
				CodePoint	nCodePoint = (iChar >= cchLine - 1) ? pwszLine[iChar]
					: DecodeUTF16SurrogatePairToCodePoint(pwszLine + iChar, cchLine - iChar);
				if(!m_pBoundarySearcher->IsFirstCharacterOfCluster(nCodePoint))
					continue;
			}
		}

		const int	nPos = pLineInfo->GetCaretPosition(iChar);
		if(nPos + m_layoutInfo.nLeftMargin == x)	// SɈv̂ΏI
			return iChar;
		if(dif(static_cast<int>(x), static_cast<int>(nPos + m_layoutInfo.nLeftMargin)) < nNearestDistance) {
			iNearest = iChar;
			nNearestDistance = dif(static_cast<int>(x), static_cast<int>(nPos + m_layoutInfo.nLeftMargin));
		}
	}
	return iNearest;
}

/**
 *	NCAgWł߂sƕʒu (_l) 擾
 *	@param pt				NCAgW
 *	@param bIgnoreExtender	Lbg󂯎Ȃ𖳎B
 *							TQ[g͏ɍl
 *	@param pbTruncated		<var>pt</var> LȈʒuɐ؂l߂ꂽꍇ
 *							true (null w肷Ɩ)
 *	@return					ł߂ʒu
 */
CCharPos CEditView::CharFromPos(const POINT& pt,
		bool bIgnoreExtender, bool* pbTruncated /* = 0 */) const {
	AssertValidAsWindow();

	CCharPos		pos;
	const char_t*	pszLine = 0;
	const length_t	cLines = GetDocument()->GetLineCount();

	if(pbTruncated != 0)
		*pbTruncated = false;

	// s̊m
	if(pt.y <= static_cast<long>(m_layoutInfo.nTopMargin)
			&& (m_layoutInfo.nTopMargin - pt.y) / m_layoutInfo.nLineHeight > m_ptScroll.y * m_layoutInfo.nVScrollRatio) {
		pos.m_iLine = 0;
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else {
		pos.m_iLine = static_cast<long>(pt.y - m_layoutInfo.nTopMargin) / static_cast<long>(m_layoutInfo.nLineHeight)
						+ m_ptScroll.y * m_layoutInfo.nVScrollRatio;
		if(pt.y < static_cast<long>(m_layoutInfo.nTopMargin) && pos.m_iLine > 0)
			pos.m_iLine -= 1;
	}
/*	if(pos.m_iLine < m_ptScroll.y * m_layoutInfo.nVScrollRatio) {
		pos.m_iLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio;
		if(pbTruncated != 0)
			*pbTruncated = true;
	} else if(pos.m_iLine >= m_ptScroll.y * m_layoutInfo.nVScrollRatio + GetVisibleLineCount()) {
		pos.m_iLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio + GetVisibleLineCount() - 1;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}
*/	if(pos.m_iLine >= cLines) {
		pos.m_iLine = cLines - 1;
		if(pbTruncated != 0)
			*pbTruncated = true;
	}

	// ̊m
	if(pt.x > static_cast<long>(m_layoutInfo.nLeftMargin + m_layoutInfo.nLeftTabWidth)) {	// сA]E
			pos.m_iChar = CharFromPixel(pos.m_iLine,
							m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() + pt.x - m_layoutInfo.nLeftTabWidth,
							bIgnoreExtender, (pbTruncated != 0 && *pbTruncated) ? 0 : pbTruncated);
	} else {
		pos.m_iChar = CharFromPixel(pos.m_iLine, m_ptScroll.x * m_layoutInfo.nHScrollRatio, bIgnoreExtender, 0);
		if(pbTruncated != 0)
			*pbTruncated = true;
	}

	return LogicalCharFromDisplayChar(pos);
}

///	wʒuRgptłΐ^Ԃ
///	TODO: TT_OTHERQUOTATION Ή
bool CEditView::CharIsInCommentOrQuotation(const CCharPos& pos) const {
	AssertValid();

	// g[N1݂Ȃsł͒߂̂ݒׂďI
	if(GetDocument()->GetLineLength(pos.m_iLine) == 0)
		return m_pLineLayoutManager->GetLine(pos.m_iLine)->GetMultilineCommentStatus(false) != NullCookie;

	const length_t			cchLine = GetDocument()->GetLineLength(pos.m_iLine);
	const CLineLayout*		pLine = m_pLineLayoutManager->GetLine(pos.m_iLine);
	CTokenLayout** const	ppTokens = pLine->GetTokenList();
	int						type;

	// pos s̏ꍇ
	type = ppTokens[pLine->GetTokenCount() - 1]->GetType();
	if(type == TT_ANNOTATION) {
		return true;	// 肠
//		if(pos.m_iChar == GetDocument()->GetLineLength(pos.m_iLine))
//			return pLine->GetMultilineCommentStatus(true) != NullCookie;
	} else if(type == TT_DOUBLEQUOTATION || type == TT_SINGLEQUOTATION) {
		const string_t&	strLine = GetDocument()->GetLine(pos.m_iLine);
		if(pos.m_iChar == strLine.length()) {
			if(cchLine - ppTokens[pLine->GetTokenCount() - 1]->GetIndex() == 1)
				return true;
			return (type == TT_DOUBLEQUOTATION
					&& strLine[pos.m_iChar - 1] == L'\"'
					&& strLine[pos.m_iChar - 2] == L'\\')
				|| (type == TT_SINGLEQUOTATION
					&& strLine[pos.m_iChar - 1] == L'\''
					&& strLine[pos.m_iChar - 2] == L'\\');
		}
	}

	for(size_t iToken = 0; iToken < pLine->GetTokenCount(); ++iToken) {
		const CTokenLayout*	pToken = ppTokens[iToken];

		if(pos.m_iChar > pToken->GetIndex()) {
			const length_t	iNext = (iToken < pLine->GetTokenCount() - 1) ?
										ppTokens[iToken + 1]->GetIndex() : cchLine;
			if(pos.m_iChar < iNext) {
				type = pToken->GetType();
				return type == TT_ANNOTATION
					|| type == TT_DOUBLEQUOTATION
					|| type == TT_SINGLEQUOTATION;
			}
		}
	}
	return false;
}

///	ANeBu|Cg̕ʂł΋\B
///	̃\bh͑Ίʂ̌Aĕ`AO܂ŋ\ĂΊʂ̖ȂǑSčs
void CEditView::CheckMatchBrackets() {
	AssertValidAsWindow();
	
	if(m_pTokenFoundations->arrEnabled[ETT_MATCH_BRACKETS]
			&& !HasSelection()
			&& !CharIsInCommentOrQuotation(*m_pActivePoint)) {
		const CCharPos	posLast0 = m_layoutInfo.posHilightedBrackets[0];
		const CCharPos	posLast1 = m_layoutInfo.posHilightedBrackets[1];

		// () ΊʂT
		CCharPos	posBracket;
		bool		bFound;
		if(bFound = FindBracket(*m_pActivePoint, posBracket, true)) {
			m_layoutInfo.posHilightedBrackets[0] = *m_pActivePoint;
			m_layoutInfo.posHilightedBrackets[1] = posBracket;
		} else if(m_pActivePoint->m_iChar != 0	// 1Oׂ
				&& (bFound = FindBracket(CCharPos(m_pActivePoint->m_iLine,
				m_pActivePoint->m_iChar - 1), posBracket, true))) {
			m_layoutInfo.posHilightedBrackets[0] = CCharPos(m_pActivePoint->m_iLine, m_pActivePoint->m_iChar - 1);
			m_layoutInfo.posHilightedBrackets[1] = posBracket;
		}
		if(bFound) {	// ꍇ
			InvalidateLine(m_layoutInfo.posHilightedBrackets[0].m_iLine);
			if(!IsFreezed())
				UpdateWindow();
			if(m_layoutInfo.posHilightedBrackets[0].m_iLine != m_layoutInfo.posHilightedBrackets[1].m_iLine) {
				InvalidateLine(m_layoutInfo.posHilightedBrackets[1].m_iLine);
				if(!IsFreezed())
					UpdateWindow();
			}
			if(posLast0 != CCharPos(-1, -1)
					&& posLast0.m_iLine != m_layoutInfo.posHilightedBrackets[0].m_iLine
					&& posLast0.m_iLine != m_layoutInfo.posHilightedBrackets[1].m_iLine) {
				InvalidateLine(posLast0.m_iLine);
				if(!IsFreezed())
					UpdateWindow();
			}
			if(posLast1 != CCharPos(-1, -1)
					&& posLast1.m_iLine != m_layoutInfo.posHilightedBrackets[0].m_iLine
					&& posLast1.m_iLine != m_layoutInfo.posHilightedBrackets[1].m_iLine
					&& posLast1.m_iLine != posLast0.m_iLine)
				InvalidateLine(posLast1.m_iLine);
		} else if(posLast0 != CCharPos(-1, -1)) {	// Ȃꍇ -> O񕪂
			m_layoutInfo.posHilightedBrackets[0]
				= m_layoutInfo.posHilightedBrackets[1]
				= CCharPos(-1, -1);
			InvalidateLine(posLast0.m_iLine);
			if(!IsFreezed())
				UpdateWindow();
			if(posLast0.m_iLine != posLast1.m_iLine)
				InvalidateLine(posLast1.m_iLine);
		}
	} else if(m_layoutInfo.posHilightedBrackets[0] != CCharPos(-1, -1)) {	// O񕪂邾
		const length_t	iLastLine0 = m_layoutInfo.posHilightedBrackets[0].m_iLine;
		const length_t	iLastLine1 = m_layoutInfo.posHilightedBrackets[1].m_iLine;

		m_layoutInfo.posHilightedBrackets[0]
			= m_layoutInfo.posHilightedBrackets[1]
			= CCharPos(-1, -1);
		InvalidateLine(iLastLine0);
		if(!IsFreezed())
			UpdateWindow();
		if(iLastLine0 != iLastLine1)
			InvalidateLine(iLastLine1);
	}
}

///	uubN}[NNAv̎sP
void CEditView::ClearBookmarks() {
	AssertValid();

	length_t	cLines = GetDocument()->GetLineCount();
	for(length_t iLine = 0; iLine < cLines; ++iLine)
		m_pLineLayoutManager->GetLine(iLine)->SetBookmark(false);
	if(IsWindowVisible())
		InvalidateRect(0, false);
}

/**
 *	ʒu瑊ԍ擾
 *	@param pos	ʒu
 *	@return		ԍ
 */
length_t CEditView::ColumnFromChar(const CCharPos& pos) const {
	AssertValid();

	const CEditDoc*		pDocument = GetDocument();
	const length_t	iLine = std::min(pos.m_iLine, pDocument->GetLineCount() - 1);
	const length_t	iChar = std::min<length_t>(pos.m_iChar, pDocument->GetLineLength(iLine));

	return m_pLineLayoutManager->GetLine(iLine)->GetCaretPosition(iChar) / GetAvgCharWidth();
}

/**
 *	\Rg̔rɎgpB
 *	r[̐ݒɂ茟͕ς
 *	@param psz1, psz2	r
 *	@param cch			r
 *	@return				rʁB<var>psz1</var> &gt; <var>psz2</var> ł+1A
 *						<var>psz1</var> = <var>psz2</var> ł0A
 *						ȊȌꍇ-1
 */
int CEditView::CompareString(
		const char_t* psz1, const char_t* psz2, length_t cch) const {
	AssertValid();

	int	n = m_foundationInfo.bIgnoreCaseOnHilite ?
				::StrCmpNIW(psz1, psz2, cch) : wcsncmp(psz1, psz2, cch);
	if(n > 0)		return 1;
	else if(n == 0)	return 0;
	else			return -1;
}

/**
 *	ϊBANZgt͂ƂȂǂɎg
 *	@param wch	ϊ镶
 *	@param ncc	ϊ̎
 */
char_t CEditView::ConvertCharacter(char_t wch, NextCharConvert ncc) {
#define MAP_CH(x, y)	case (x): return (y)

	if(ncc == NCC_NONE)
		return wch;
	else if(ncc == NCC_GRAVE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C0);	MAP_CH(0x0061, 0x00E0);	// A
		MAP_CH(0x0045, 0x00C8);	MAP_CH(0x0065, 0x00E8);	// E
		MAP_CH(0x0049, 0x00CC);	MAP_CH(0x0069, 0x00EC);	// I
		MAP_CH(0x004F, 0x00D2);	MAP_CH(0x006F, 0x00F2);	// O
		MAP_CH(0x0055, 0x00D9);	MAP_CH(0x0075, 0x00F9);	// U
		MAP_CH(0x00DC, 0x01DB);	MAP_CH(0x00FC, 0x01DC);	// U With Diaeresis
		MAP_CH(0x004E, 0x01F8);	MAP_CH(0x006E, 0x01F9);	// N
		MAP_CH(0x0415, 0x0400);	MAP_CH(0x0435, 0x0450);	// Cyrillic Ie
		MAP_CH(0x0418, 0x040D);	MAP_CH(0x0438, 0x045D);	// Cyrillic I
		MAP_CH(0x0112, 0x1E14);	MAP_CH(0x0113, 0x1E15);	// E With Macron
		MAP_CH(0x014C, 0x1E50);	MAP_CH(0x014D, 0x1E51);	// O With Macron
		MAP_CH(0x0057, 0x1E80);	MAP_CH(0x0077, 0x1E81);	// W
		MAP_CH(0x00C2, 0x1EA6);	MAP_CH(0x00E2, 0x1EA7);	// A With Circumflex
		MAP_CH(0x0102, 0x1EB0);	MAP_CH(0x0103, 0x1EB1);	// A With Breve
		MAP_CH(0x00CA, 0x1EC0);	MAP_CH(0x00EA, 0x1EC1);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED2);	MAP_CH(0x00F4, 0x1ED3);	// O With Circumflex
		MAP_CH(0x01A0, 0x1EDC);	MAP_CH(0x01A1, 0x1EDD);	// O With Horn
		MAP_CH(0x01AF, 0x1EEA);	MAP_CH(0x01B0, 0x1EEB);	// U With Horn
		MAP_CH(0x0059, 0x1EF2);	MAP_CH(0x0079, 0x1EF3);	// Y
		}
	} else if(ncc == NCC_ACUTE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C1);	MAP_CH(0x0061, 0x00E1);	// A
		MAP_CH(0x0045, 0x00C9);	MAP_CH(0x0065, 0x00E9);	// E
		MAP_CH(0x0049, 0x00CD);	MAP_CH(0x0069, 0x00ED);	// I
		MAP_CH(0x004F, 0x00D3);	MAP_CH(0x006F, 0x00F3);	// O
		MAP_CH(0x0055, 0x00DA);	MAP_CH(0x0075, 0x00FA);	// U
		MAP_CH(0x0059, 0x00DD);	MAP_CH(0x0079, 0x00FD);	// Y
		MAP_CH(0x0043, 0x0106);	MAP_CH(0x0063, 0x0107);	// C
		MAP_CH(0x004C, 0x0139);	MAP_CH(0x006C, 0x013A);	// L
		MAP_CH(0x004E, 0x0143);	MAP_CH(0x006E, 0x0144);	// N
		MAP_CH(0x0052, 0x0154);	MAP_CH(0x0072, 0x0155);	// R
		MAP_CH(0x0053, 0x015A);	MAP_CH(0x0073, 0x015B);	// S
		MAP_CH(0x005A, 0x0179);	MAP_CH(0x007A, 0x017A);	// Z
		MAP_CH(0x00DC, 0x01D7);	MAP_CH(0x00FC, 0x01D8);	// U With Diaeresis
		MAP_CH(0x0047, 0x01F4);	MAP_CH(0x0067, 0x01F5);	// G
		MAP_CH(0x00C5, 0x01FA);	MAP_CH(0x00E5, 0x01FB);	// A With Ring Above
		MAP_CH(0x00C6, 0x01FC);	MAP_CH(0x00E6, 0x01FD);	// Ae
		MAP_CH(0x00D8, 0x01FE);	MAP_CH(0x00F8, 0x01FF);	// O With Stroke
		MAP_CH(0x03D2, 0x03D3);	// Greek Upsilon With Hook Symbol
		MAP_CH(0x00C7, 0x1E08);	MAP_CH(0x00E7, 0x1E09);	// C With Cedilla
		MAP_CH(0x0112, 0x1E16);	MAP_CH(0x0113, 0x1E17);	// E With Macron
		MAP_CH(0x00CF, 0x1E2E);	MAP_CH(0x00EF, 0x1E2F);	// I With Diaeresis
		MAP_CH(0x004B, 0x1E30);	MAP_CH(0x006B, 0x1E31);	// K
		MAP_CH(0x004D, 0x1E3E);	MAP_CH(0x006D, 0x1E3F);	// M
		MAP_CH(0x00D5, 0x1E4C);	MAP_CH(0x00F5, 0x1E4D);	// O With Tilde
		MAP_CH(0x014C, 0x1E52);	MAP_CH(0x014D, 0x1E53);	// O With Macron
		MAP_CH(0x0050, 0x1E54);	MAP_CH(0x0070, 0x1E55);	// P
		MAP_CH(0x1E60, 0x1E64);	MAP_CH(0x1E61, 0x1E65);	// S With Dot Above
		MAP_CH(0x0168, 0x1E78);	MAP_CH(0x0169, 0x1E79);	// U With Tilde
		MAP_CH(0x0057, 0x1E82);	MAP_CH(0x0077, 0x1E83);	// W
		MAP_CH(0x00C2, 0x1EA4);	MAP_CH(0x00E2, 0x1EA5);	// A With Circumflex
		MAP_CH(0x0102, 0x1EAE);	MAP_CH(0x0103, 0x1EAF);	// A With Breve
		MAP_CH(0x00CA, 0x1EBE);	MAP_CH(0x00EA, 0x1EBF);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED0);	MAP_CH(0x00F4, 0x1ED1);	// O With Circumflex
		MAP_CH(0x01A0, 0x1EDA);	MAP_CH(0x01A1, 0x1EDB);	// O With Horn
		MAP_CH(0x01AF, 0x1EE8);	MAP_CH(0x01B0, 0x1EE9);	// U With Horn
		}
	} else if(ncc == NCC_CIRCUMFLEX) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C2);	MAP_CH(0x0061, 0x00E2);	// A
		MAP_CH(0x0045, 0x00CA);	MAP_CH(0x0065, 0x00EA);	// E
		MAP_CH(0x0049, 0x00CE);	MAP_CH(0x0069, 0x00EE);	// I
		MAP_CH(0x004F, 0x00D4);	MAP_CH(0x006F, 0x00F4);	// O
		MAP_CH(0x0055, 0x00DB); MAP_CH(0x0075, 0x00FB);	// U
		MAP_CH(0x0043, 0x0108);	MAP_CH(0x0063, 0x0109);	// C
		MAP_CH(0x0047, 0x011C);	MAP_CH(0x0067, 0x011D);	// G
		MAP_CH(0x0048, 0x0124);	MAP_CH(0x0068, 0x0125);	// H
		MAP_CH(0x004A, 0x0134);	MAP_CH(0x006A, 0x0135);	// J
		MAP_CH(0x0053, 0x015C);	MAP_CH(0x0073, 0x015D);	// S
		MAP_CH(0x0057, 0x0174);	MAP_CH(0x0077, 0x0175);	// W
		MAP_CH(0x0059, 0x0176);	MAP_CH(0x0079, 0x0177);	// Y
		MAP_CH(0x005A, 0x1E90);	MAP_CH(0x007A, 0x1E91);	// Z
		MAP_CH(0x00C1, 0x1EA4);	MAP_CH(0x00E1, 0x1EA5);	// A With Acute
		MAP_CH(0x00C0, 0x1EA6);	MAP_CH(0x00E0, 0x1EA7);	// A With Grave
		MAP_CH(0x1EA2, 0x1EA8);	MAP_CH(0x1EA3, 0x1EA9);	// A With Hook Above
		MAP_CH(0x00C3, 0x1EAA);	MAP_CH(0x00E3, 0x1EAB);	// A With Tilde
		MAP_CH(0x1EA0, 0x1EAC);	MAP_CH(0x1EA1, 0x1EAD);	// A With Dot Below
		MAP_CH(0x00C9, 0x1EBE);	MAP_CH(0x00E9, 0x1EBF);	// E With Acute
		MAP_CH(0x00C8, 0x1EC0);	MAP_CH(0x00E8, 0x1EC1);	// E With Grave
		MAP_CH(0x1EBA, 0x1EC2);	MAP_CH(0x1EBB, 0x1EC3);	// E With Hook Above
		MAP_CH(0x1EBC, 0x1EC4);	MAP_CH(0x1EBD, 0x1EC5);	// E With Tilde
		MAP_CH(0x1EB8, 0x1EC6);	MAP_CH(0x1EB9, 0x1EC7);	// E With Dot Below
		MAP_CH(0x00D3, 0x1ED0);	MAP_CH(0x00F3, 0x1ED1);	// O With Acute
		MAP_CH(0x00D2, 0x1ED2);	MAP_CH(0x00F2, 0x1ED3);	// O With Grave
		MAP_CH(0x1ECE, 0x1ED4);	MAP_CH(0x1ECF, 0x1ED5);	// O With Hook Above
		MAP_CH(0x00D5, 0x1ED6);	MAP_CH(0x00F5, 0x1ED7);	// O With Tilde
		MAP_CH(0x1ECC, 0x1ED8);	MAP_CH(0x1ECD, 0x1ED9);	// O With Dot Below
		}
	} else if(ncc == NCC_TILDE) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C3);	MAP_CH(0x0061, 0x00E3);	// A
		MAP_CH(0x004E, 0x00D1);	MAP_CH(0x006E, 0x00F1);	// N
		MAP_CH(0x004F, 0x00D5);	MAP_CH(0x006F, 0x00F5);	// O
		MAP_CH(0x0049, 0x0128);	MAP_CH(0x0069, 0x0129);	// I
		MAP_CH(0x0055, 0x0168);	MAP_CH(0x0075, 0x0169);	// U
		MAP_CH(0x014C, 0x022C);	MAP_CH(0x014D, 0x022D);	// O With Macron
		MAP_CH(0x00D3, 0x1E4C);	MAP_CH(0x00F3, 0x1E4D);	// O With Acute
		MAP_CH(0x00D6, 0x1E4E);	MAP_CH(0x00F6, 0x1E4F);	// O With Diaeresis
		MAP_CH(0x00DA, 0x1E78);	MAP_CH(0x00FA, 0x1E79);	// U With Acute
		MAP_CH(0x0056, 0x1E7C);	MAP_CH(0x0076, 0x1E7D);	// V
		MAP_CH(0x00C2, 0x1EAA);	MAP_CH(0x00E2, 0x1EAB);	// A With Circumflex
		MAP_CH(0x0102, 0x1EB4);	MAP_CH(0x0103, 0x1EB5);	// A With Breve
		MAP_CH(0x0045, 0x1EBC);	MAP_CH(0x0065, 0x1EBD);	// E
		MAP_CH(0x00CA, 0x1EC4);	MAP_CH(0x00EA, 0x1EC5);	// E With Circumflex
		MAP_CH(0x00D4, 0x1ED6);	MAP_CH(0x00F4, 0x1ED7);	// O With Circumflex
		MAP_CH(0x01A0, 0x1EE0);	MAP_CH(0x01A1, 0x1EE1);	// O With Horn
		MAP_CH(0x01AF, 0x1EEE);	MAP_CH(0x01B0, 0x1EEF);	// U With Horn
		MAP_CH(0x0059, 0x1EF8);	MAP_CH(0x0079, 0x1EF9);	// Y
		}
	} else if(ncc == NCC_DIAERESIS) {
		switch(wch) {
		MAP_CH(0x0041, 0x00C4);	MAP_CH(0x0061, 0x00E4);	// A
		MAP_CH(0x0045, 0x00CB);	MAP_CH(0x0065, 0x00EB);	// E
		MAP_CH(0x0049, 0x00CF);	MAP_CH(0x0069, 0x00EF);	// I
		MAP_CH(0x004F, 0x00D6);	MAP_CH(0x006F, 0x00F6);	// O
		MAP_CH(0x0055, 0x00DC);	MAP_CH(0x0075, 0x00FC);	// U
		MAP_CH(0x0059, 0x0178);	MAP_CH(0x0079, 0x00FF);	// Y
//		MAP_CH(0x016A, 0x01D5);	MAP_CH(0x016B, 0x01D6);	// U With Macron
		MAP_CH(0x00DA, 0x01D7);	MAP_CH(0x00FA, 0x01D8);	// U With Acute
		MAP_CH(0x01D3, 0x01D9);	MAP_CH(0x01D4, 0x01DA);	// U With Caron
		MAP_CH(0x00D9, 0x01DB);	MAP_CH(0x00F9, 0x01DC);	// U With Grave
		MAP_CH(0x0100, 0x01DE);	MAP_CH(0x0101, 0x01DF);	// A With Macron
		MAP_CH(0x014C, 0x022A);	MAP_CH(0x014D, 0x022B);	// O With Macron
		MAP_CH(0x03D2, 0x03D4);	// Greek Upsilon With Hook Symbol
		MAP_CH(0x0410, 0x04D2);	MAP_CH(0x0430, 0x04D3);	// Cyrillic A
		MAP_CH(0x04D8, 0x04DA);	MAP_CH(0x04D9, 0x04DB);	// Cyrillic Schwa
		MAP_CH(0x0416, 0x04DC);	MAP_CH(0x0436, 0x04DD);	// Cyrillic Zhe
		MAP_CH(0x0417, 0x04DE);	MAP_CH(0x0437, 0x04DF);	// Cyrillic Ze
		MAP_CH(0x0418, 0x04E4);	MAP_CH(0x0438, 0x04E5);	// Cyrillic I
		MAP_CH(0x041E, 0x04E6);	MAP_CH(0x043E, 0x04E7);	// Cyrillic O
		MAP_CH(0x04E8, 0x04EA);	MAP_CH(0x04E9, 0x04EB);	// Cyrillic Barred O
		MAP_CH(0x042D, 0x04EC);	MAP_CH(0x044D, 0x04ED);	// Cyrillic E
		MAP_CH(0x0423, 0x04F0);	MAP_CH(0x0443, 0x04F1);	// Cyrillic U
		MAP_CH(0x0427, 0x04F4);	MAP_CH(0x0447, 0x04F5);	// Cyrillic Che
		MAP_CH(0x042B, 0x04F8);	MAP_CH(0x044B, 0x04F9);	// Cyrillic Yeru
		MAP_CH(0x0048, 0x1E26);	MAP_CH(0x0068, 0x1E27);	// H
		MAP_CH(0x00CD, 0x1E2E);	MAP_CH(0x00ED, 0x1E2F);	// I With Acute
		MAP_CH(0x00D5, 0x1E4E); MAP_CH(0x00F5, 0x1E4F);	// O With Tilde
		MAP_CH(0x016A, 0x1E7A);	MAP_CH(0x016B, 0x1E7B);	// U With Macron
		MAP_CH(0x0057, 0x1E84);	MAP_CH(0x0077, 0x1E85);	// W
		MAP_CH(0x0058, 0x1E8C);	MAP_CH(0x0078, 0x1E8D);	// X
		MAP_CH(0x0074, 0x1E97);	// Small T
		}
	} else if(ncc == NCC_CEDILLA) {
		switch(wch) {
		MAP_CH(0x0043, 0x00C7);	MAP_CH(0x0063, 0x00E7);	// C
		MAP_CH(0x0047, 0x0122);	MAP_CH(0x0067, 0x0123);	// G
		MAP_CH(0x004B, 0x0136);	MAP_CH(0x006B, 0x0137);	// K
		MAP_CH(0x004C, 0x013B);	MAP_CH(0x006C, 0x013C);	// L
		MAP_CH(0x004E, 0x0145);	MAP_CH(0x006E, 0x0146);	// N
		MAP_CH(0x0052, 0x0156);	MAP_CH(0x0072, 0x0157);	// R
		MAP_CH(0x0053, 0x015E);	MAP_CH(0x0073, 0x015F);	// S
		MAP_CH(0x0054, 0x0162);	MAP_CH(0x0074, 0x0163);	// T
		MAP_CH(0x0045, 0x0228);	MAP_CH(0x0065, 0x0229);	// E
		MAP_CH(0x00C7, 0x1E08);	MAP_CH(0x00E7, 0x1E09);	// C With Acute
		MAP_CH(0x0044, 0x1E10);	MAP_CH(0x0064, 0x1E11);	// D
		MAP_CH(0x0114, 0x1E1C);	MAP_CH(0x0115, 0x1E1D);	// E With Breve
		MAP_CH(0x0048, 0x1E28);	MAP_CH(0x0068, 0x1E29);	// H
		}
	} else if(ncc == NCC_SUPERSCRIPT) {
		switch(wch) {
			/* super scripts */
		MAP_CH(0x0030, 0x2070);	// 0
		MAP_CH(0x0069, 0x2071);	// i
		MAP_CH(0x0031, 0x00B9);	// 1
		MAP_CH(0x0032, 0x00B2);	MAP_CH(0x0033, 0x00B3);	// 2, 3
		MAP_CH(0x0034, 0x2074);	MAP_CH(0x0035, 0x2075);	// 4, 5
		MAP_CH(0x0036, 0x2076);	MAP_CH(0x0037, 0x2077);	// 6, 7
		MAP_CH(0x0038, 0x2078);	MAP_CH(0x0039, 0x2079);	// 8, 9
		MAP_CH(0x002B, 0x207A);	MAP_CH(0x2212, 0x207B);	// +, -
		MAP_CH(0x003D, 0x207C);	// =
		MAP_CH(0x0028, 0x207D);	MAP_CH(0x0029, 0x207E);	// (, )
		MAP_CH(0x006E, 0x207F);	// n
			/* ordinal indicators  */
//		MAP_CH(0x0061, 0x00AA);	// Feminine Ordinal Indicator
//		MAP_CH(0x006F, 0x00BA);	// Masculine Ordinal Indicator
			/* modifier letters */
		MAP_CH(0x0068, 0x02B0);	MAP_CH(0x0266, 0x02B1);	// h, h With Hook
		MAP_CH(0x006A, 0x02B2);	MAP_CH(0x0072, 0x02B3);	// j, r
		MAP_CH(0x0279, 0x02B4);	MAP_CH(0x027B, 0x02B5);	// Turned r, Turned r With Hook
		MAP_CH(0x0281, 0x02B6);	MAP_CH(0x0077, 0x02B7);	// Inverted R, w
		MAP_CH(0x0079, 0x02B8);	MAP_CH(0x0263, 0x02E0);	// y, Small Gamma
		MAP_CH(0x006C, 0x02E1);	MAP_CH(0x0073, 0x02E2);	// l, s
		MAP_CH(0x0078, 0x02E3);	MAP_CH(0x0295, 0x02E4);	// x, Small Reversed Glottal Stop
		MAP_CH(0x0041, 0x1D2C);	MAP_CH(0x00C6, 0x1D2D);	// A, AE
		MAP_CH(0x0042, 0x1D2E);	MAP_CH(0x0044, 0x1D30);	// B, D
		MAP_CH(0x0045, 0x1D31);	MAP_CH(0x0047, 0x1D33);	// E, G
		MAP_CH(0x0048, 0x1D34);	MAP_CH(0x0049, 0x1D35);	// H, I
		MAP_CH(0x004A, 0x1D36);	MAP_CH(0x004B, 0x1D37);	// J, K
		MAP_CH(0x004C, 0x1D38);	MAP_CH(0x004D, 0x1D39);	// L, M
		MAP_CH(0x004E, 0x1D3A);	MAP_CH(0x004F, 0x1D3C);	// N, O
		MAP_CH(0x0222, 0x1D3D);	MAP_CH(0x0050, 0x1D3E);	// OU, P
		MAP_CH(0x0052, 0x1D3F);	MAP_CH(0x0054, 0x1D40);	// R, T
		MAP_CH(0x0055, 0x1D41);	MAP_CH(0x0057, 0x1D42);	// U, W
		MAP_CH(0x0061, 0x1D43);	MAP_CH(0x0250, 0x1D44);	// a, turned a
		MAP_CH(0x0251, 0x1D45);	MAP_CH(0x1D02, 0x1D46);	// alpha, turned ae
		MAP_CH(0x0062, 0x1D47);	MAP_CH(0x0064, 0x1D48);	// b, d
		MAP_CH(0x0065, 0x1D49);	MAP_CH(0x0259, 0x1D4A);	// e, schwa
		MAP_CH(0x025B, 0x1D4B);	MAP_CH(0x025C, 0x1D4C);	// open e, turned open e
		MAP_CH(0x0067, 0x1D4D);	MAP_CH(0x006B, 0x1D4E);	// g, k
		MAP_CH(0x006D, 0x1D50);	MAP_CH(0x014B, 0x1D51);	// m, eng
		MAP_CH(0x006F, 0x1D52);	MAP_CH(0x0254, 0x1D53);	// o, open o
		MAP_CH(0x1D16, 0x1D54);	MAP_CH(0x1D17, 0x1D55);	// top half o, bottom half o
		MAP_CH(0x0070, 0x1D56);	MAP_CH(0x0074, 0x1D57);	// p, t
		MAP_CH(0x0075, 0x1D58);	MAP_CH(0x1D1D, 0x1D59);	// u, sideways u
		MAP_CH(0x026F, 0x1D5A);	MAP_CH(0x0076, 0x1D5B);	// turned m, v
		MAP_CH(0x1D25, 0x1D5C);	MAP_CH(0x03B2, 0x1D5D);	// ain, beta
		MAP_CH(0x03B3, 0x1D5E);	MAP_CH(0x03B4, 0x1D5F);	// greek gamma, delta
		MAP_CH(0x03C6, 0x1D60);	MAP_CH(0x03C7, 0x1D61);	// greek phi, chi
			/* ideographic annotations */
		MAP_CH(0x4E00, 0x3192);	MAP_CH(0x4E8C, 0x3193);	// , 
		MAP_CH(0x4E09, 0x3194);	MAP_CH(0x56DB, 0x3195);	// O, l
		MAP_CH(0x4E0A, 0x3196);	MAP_CH(0x4E2D, 0x3197);	// , 
		MAP_CH(0x4E0B, 0x3198);	MAP_CH(0x7532, 0x3199);	// , b
		MAP_CH(0x4E59, 0x319A);	MAP_CH(0x4E19, 0x319B);	// , 
		MAP_CH(0x4E01, 0x319B);	MAP_CH(0x5929, 0x319D);	// , V
		MAP_CH(0x5730, 0x319E);	MAP_CH(0x4EBA, 0x319F);	// n, l
		}
	} else if(ncc == NCC_SUBSCRIPT) {
		switch(wch) {
			/* subscripts */
		MAP_CH(0x0069, 0x1D62);	MAP_CH(0x0072, 0x1D63);	// i, r
		MAP_CH(0x0075, 0x1D64);	MAP_CH(0x0076, 0x1D65);	// u, v
		MAP_CH(0x03B2, 0x1D66);	MAP_CH(0x03B3, 0x1D67);	// beta, gamma
		MAP_CH(0x03C1, 0x1D68);	MAP_CH(0x03C6, 0x1D69);	// rho, phi
		MAP_CH(0x03C7, 0x1D6A);	// chi
		MAP_CH(0x0030, 0x2080);	MAP_CH(0x0031, 0x2081);	// 0, 1
		MAP_CH(0x0032, 0x2082);	MAP_CH(0x0033, 0x2083);	// 2, 3
		MAP_CH(0x0034, 0x2084);	MAP_CH(0x0035, 0x2085);	// 4, 5
		MAP_CH(0x0036, 0x2086);	MAP_CH(0x0037, 0x2087);	// 6, 7
		MAP_CH(0x0038, 0x2088);	MAP_CH(0x0039, 0x2089);	// 8, 9
		MAP_CH(0x002B, 0x208A);	MAP_CH(0x2212, 0x208B);	// +, -
		MAP_CH(0x003D, 0x208C);	// =
		MAP_CH(0x0028, 0x208D);	MAP_CH(0x0029, 0x208E);	// (, )
		}
	} else
		assert(false);
	return wch;
#undef MAP_CH
}

/**
 *	EBhE̍쐬
 *	@param hwndParent	eEBhE
 *	@param pRect		쐬EBhE̋`
 *	@param dwStyle		EBhEX^C
 *	@param dwExStyle	gEBhEX^C
 *	@return				EBhE쐬 true
 */
bool CEditView::Create(HWND hwndParent, const RECT* pRect, DWORD dwStyle, DWORD dwExStyle) throw(runtime_error) {
	AssertValid();

	if(!CEditView::RegisterWindowClass())
		throw runtime_error("Failed to register window class!");
	if(IsWindow())
		return false;

	bool	bVisible = toBoolean(dwStyle & WS_VISIBLE);
	dwStyle &= ~WS_VISIBLE;
	m_hWnd = ::CreateWindowExW(dwExStyle,
		WC_ASCENSIONVIEW, L"", dwStyle,
		0, 0, 0, 0, hwndParent, 0, ::GetModuleHandle(0), reinterpret_cast<void*>(this));
	if(m_hWnd == 0)
		return false;
	InitializeWindow(m_pOriginalView != this);

	// ʒu߂ƕ\
	MoveWindow(pRect, false);
	if(bVisible)
		ShowWindow(SW_SHOW);

	return true;
}

/**
 *	ҏW|Cg쐬
 *	@return	ҏW|CgBĂяoō폜
 */
CEditPoint* CEditView::CreateEditPoint() {
	AssertValid();

	CEditPoint*	ppt = new CEditPoint(this);
	ppt->m_bOwnedByView = true;
	m_setEditPoints.insert(ppt);
	return ppt;
}

/**
 *	@brief	I͈͂폜
 *
 *	̃\bh̓AhDO[v쐬ȂB
 *	݁A`I̓eȒPɍ폜ł̂͂̃\bh
 *
 *	@see	InsertText, ReplaceSel
 */
void CEditView::DeleteSel() {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	if(!HasSelection())	// IȂΉȂ
		return;

	CEditDoc*	pDoc = GetDocument();

	if(!toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {
		m_pActivePoint->MoveToPoint(pDoc->DeleteText(this, *m_pAnchorPoint, *m_pActivePoint));
		m_pAnchorPoint->MoveToPoint(*m_pActivePoint);
	} else {
		length_t	iTopLine = GetSelTopPoint().m_iLine;
		length_t	iBottomLine = GetSelBottomPoint().m_iLine;
		CCharPos	posResult;

		Freeze();
		pDoc->BeginEditCollection();
		m_modeState.selectionTraits = ST_NORMAL;
		for(length_t iLine = iTopLine; iLine <= iBottomLine; ++iLine)
			posResult = pDoc->DeleteText(this,
				CCharPos(iLine, CharFromPixel(iLine, min(m_layoutInfo.xBoxSelectionAnchor,
					m_layoutInfo.xBoxSelectionActive), !m_modeState.bCaretExtenderByMouse)),
				CCharPos(iLine, CharFromPixel(iLine, max(m_layoutInfo.xBoxSelectionAnchor,
					m_layoutInfo.xBoxSelectionActive), !m_modeState.bCaretExtenderByMouse)));
		SetSelWithoutSelection(posResult);
		Unfreeze();
		pDoc->EndEditCollection();
	}
	m_nccNextCharConvert = NCC_NONE;	// ɖ߂

	if(m_pKeyMacroPlayer->GetState() != KMS_PLAYING) {
		for(set<IEditViewEventListener*>::iterator it
				= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
			(*it)->OnMoveCaret(*m_pActivePoint);
	}
}

/// @see CWindow::DispatchEvent
LRESULT CEditView::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
	case WM_CHAR:
		OnChar(wParam, lParam);
		return 0L;
	case WM_CLEAR:
		ExecCommand(CMDID_EDIT_DELETE, 0L);
		return 0L;
	case WM_COPY:
		ExecCommand(CMDID_EDIT_COPY, 0L);
		return 0L;
	case WM_CUT:
		ExecCommand(CMDID_EDIT_CUT, 0L);
		return 0L;
	case WM_ERASEBKGND:
		InvalidateRect(0, false);
		return true;
	case WM_GETFONT:
		return reinterpret_cast<LRESULT>(m_gdiObjects.hNormalFont);
	case WM_GETTEXT: {
		string_t	strText;
		GetDocument()->GetAllLines(strText);
		return reinterpret_cast<LRESULT>(strText.c_str());
	}
	case WM_GETTEXTLENGTH: {
		string_t	strText;
		GetDocument()->GetAllLines(strText);
		return strText.length();
	}
	case WM_HSCROLL:
		OnHScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	case WM_IME_COMPOSITION:
		if(OnImeComposition(wParam, lParam))
			return false;
		break;
	case WM_IME_ENDCOMPOSITION:
		OnImeEndComposition();
		break;
	case WM_IME_REQUEST:
		if(wParam == IMR_RECONVERTSTRING) {	// L[{[hɂĕϊ
			ExecCommand(CMDID_EDIT_RECOMPOSESELECTION, 0L);
			return 0;
		}
		break;
	case WM_IME_STARTCOMPOSITION:
		OnImeStartComposition();
		break;
	case WM_KEYDOWN:
		OnKeyDown(wParam, lParam);
//		GetParent()->SendMessage(WM_KEYDOWN, wParam, lParam);
		return 0L;
	case WM_MOUSEWHEEL: {
		POINT	pt = {LOWORD(lParam), LOWORD(lParam)};
		OnMouseWheel(LOWORD(wParam), HIWORD(wParam), pt);
		return 0L;
	}
	case WM_PASTE:
		ExecCommand(CMDID_EDIT_PASTE, 0L);
		return 0L;
	case WM_RBUTTONDOWN: {
		POINT	pt = {LOWORD(lParam), LOWORD(lParam)};
		OnRButtonDown(wParam, pt);
		return 0L;
	}
	case WM_SETTEXT:
		ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		ReplaceSel(reinterpret_cast<const wchar_t*>(lParam));
		return 0L;
	case WM_SYSCOLORCHANGE:
#ifdef WM_THEMECHANGED
	case WM_THEMECHANGED:
#endif
		OnSysColorChange();
		return 0L;
	case WM_UNDO:
		ExecCommand(CMDID_EDIT_UNDO, 0L);
		return 0L;
	case WM_VSCROLL:
		OnVScroll(LOWORD(wParam), HIWORD(wParam), reinterpret_cast<HWND>(lParam));
		return 0L;
	}

	return CView::DispatchEvent(message, wParam, lParam);
}

/**
 *	_ʒu\ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posLogical	ϊ_ʒu
 *	@return				ϊꂽ\ʒu (łȂo-1)
 */
CCharPos CEditView::DisplayCharFromLogicalChar(const CCharPos& posLogical) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return posLogical;
/*
	CCharPos			posDisplay(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(length_t iTotalLogicalLine = 0;
			iTotalLogicalLine < posLogical.iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return CCharPos(-1, -1);
		posDisplay.iLine += pInfo->GetWrappedPoints().size() + 1;
	}

	// ̊m
	vector<length_t>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();

	// ̍sɂ͐܂Ԃ͖ or 擪s
	if(cOffsets == 0 || posLogical.iChar < pInfo->m_vecWrappedOffsets[0]) {
		posDisplay.iChar = posLogical.iChar;
		return posDisplay;
	}
	
	for(vector<length_t>::size_type iOffset = cOffsets - 1; iOffset < cOffsets; ++iOffset) {
		if(pInfo->m_vecWrappedOffsets[iOffset] <= posLogical.iChar) {
			posDisplay.iChar = posLogical.iChar - pInfo->m_vecWrappedOffsets[iOffset];
			posDisplay.iLine += iOffset;
			return posDisplay;
		}
	}

	return CCharPos(-1, -1);*/
}

/**
 *	_s\sɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param iLine	ϊ_s
 *	@return			ϊꂽ\s (ϊɎsꍇ-1)
 */
length_t CEditView::DisplayLineFromLogicalLine(length_t iLine) const {
	AssertValid();

	assert(iLine < GetDocument()->GetLineCount());
//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return iLine;
/*
	length_t			iDisplay = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	assert(pInfo != 0);

	// \s̐擪s܂ňړ
	for(length_t iTotalLogicalLine = 0;
			iTotalLogicalLine < iLine; ++iTotalLogicalLine, pInfo = pInfo->m_pNext) {
		if(pInfo == 0)
			return -1;
		iDisplay += pInfo->m_vecWrappedOffsets.size() + 1;
	}
	return iDisplay;*/
}

/// @see IDropTarget::DragEnter
STDMETHODIMP CEditView::DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	FORMATETC	fe = {
		CF_TEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL
	};

	if(m_ldmLeftDown == LDM_NONE)
		m_ldmLeftDown = LDM_DRAGANDDROP;
	SetFocus();

	// hbOĂf[^Lǂׂ
	if(!GetDocument()->IsReadOnly()
			&& (m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| pDataObj->QueryGetData(&fe) == S_OK
			|| (fe.cfFormat = CF_UNICODETEXT, pDataObj->QueryGetData(&fe) == S_OK))) {
		SetTimer(TIMERID_DRAGSCROLL, 50, 0);
		return DragOver(grfKeyState, pt, pdwEffect);
	}
	m_ldmLeftDown = LDM_NONE;
	*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/// @see IDropTarget::DragLeave
STDMETHODIMP CEditView::DragLeave() {
	::SetFocus(0);
	KillTimer(TIMERID_DRAGSCROLL);
	if(m_ldmLeftDown != LDM_DRAGANDDROPSELF
			&& m_ldmLeftDown != LDM_DRAGANDDROPBOXSELF)
		m_ldmLeftDown = LDM_NONE;
	return S_OK;
}

/// @see IDropTarget::DragOver
STDMETHODIMP CEditView::DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	VERIFY_POINTER(pdwEffect);

	if(m_ldmLeftDown == LDM_DRAGANDDROP
			|| m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// hbv\ȏꍇȊO͉Ȃ
		POINT	ptCaret = {pt.x, pt.y};
		ScreenToClient(&ptCaret);
		SetCaretPos(PosFromChar(CharFromPos(ptCaret, !m_modeState.bCaretExtenderByMouse)));
		if(m_ldmLeftDown != LDM_DRAGANDDROP)
			*pdwEffect = (::GetKeyState(VK_CONTROL) & 0x8000) ? DROPEFFECT_COPY : DROPEFFECT_MOVE;
		else
			*pdwEffect = DROPEFFECT_COPY;
	} else
		*pdwEffect = DROPEFFECT_NONE;
	return S_OK;
}

/**
 *	eLXg̉͘g`悷 (W͑Săr[W)
 *	@param left, top, right, bottom	̋`
 *	@param bt						/g̎
 *	@param clr						/g̐F
 *	@see							BorderType
 */
void CEditView::DrawBorder(int left, int top, int right, int bottom, BorderType bt, COLORREF clr) {
	if(bt == BT_NONE
			|| left >= right
			|| right < static_cast<long>(m_layoutInfo.rectUpdate.left - m_layoutInfo.nLeftTabWidth)
			|| left > static_cast<long>(m_layoutInfo.rectUpdate.right - m_layoutInfo.nLeftTabWidth))
		return;

	HPEN		hPen, hOldPen;
	LOGBRUSH	lb;
	CMinimalDC&	oDC = m_gdiObjects.oMemDC;
	const long	xLeft = max<long>(left, m_layoutInfo.rectUpdate.left - m_layoutInfo.nLeftTabWidth);
	const long	xRight = min<long>(right, m_layoutInfo.rectUpdate.right - m_layoutInfo.nLeftTabWidth);

	if(bt != BT_UNDERLINE_WAVED) {
		if(bt == BT_UNDERLINE_SOLID || bt == BT_UNDERLINE_BOLD || bt == BT_BORDER_SOLID)
			hPen = ::CreatePen(PS_SOLID, 1, clr);
		else if(bt == BT_UNDERLINE_DASHED || bt == BT_UNDERLINE_BOLDDASHED || bt == BT_BORDER_DASHED) {
			lb.lbColor = clr;
			lb.lbStyle = BS_SOLID;
			hPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DASH,
				(bt != BT_UNDERLINE_BOLDDASHED) ? 1 : 2, &lb, 0, 0);
		} else if(bt == BT_UNDERLINE_DOTTED || bt == BT_UNDERLINE_BOLDDOTTED || bt == BT_BORDER_DOTTED) {
			lb.lbColor = clr;
			lb.lbStyle = BS_SOLID;
			hPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DOT,
				(bt != BT_UNDERLINE_BOLDDOTTED) ? 1 : 2, &lb, 0, 0);
		} else
			assert(false);
		hOldPen = oDC.SelectObject(hPen);
		if(bt < BT_UNDERLINE_WAVED) {	// 
			oDC.MoveTo(xLeft, bottom - 1);
			oDC.LineTo(xRight, bottom - 1);
		} else {	// g
			oDC.MoveTo(xLeft, top), oDC.LineTo(xRight, top);
			oDC.MoveTo(xLeft, bottom - 1), oDC.LineTo(xRight, bottom - 1);
			if(left == xLeft)
				oDC.MoveTo(xLeft, top), oDC.LineTo(xLeft, bottom);
			if(right == xRight)
				oDC.MoveTo(xRight - 1, top), oDC.LineTo(xRight - 1, bottom);
		}
		oDC.SelectObject(hOldPen);
	} else {	// g̉
		hPen = ::CreatePen(PS_SOLID, 1, clr);
		hOldPen = oDC.SelectObject(hPen);
		for(int i = 0; left + i * 2 <= xRight; ++i) {
			oDC.MoveTo(left + i * 2, bottom - ((i % 2 == 0) ? 1 : 2));
			oDC.LineTo(left + i * 2 + 2, bottom - ((i % 2 == 0) ? 1 : 2));
		}
		oDC.SelectObject(hOldPen);
	}
	::DeleteObject(hPen);
}

/**
 *	s}[N̕`
 *	@param x, y		`ʒu
 *	@param bt		`悷s
 *	@param clrBack	wiF
 *	@return			`敝
 */
inline int CEditView::DrawBreakMark(int x, int y, BreakType bt, COLORREF clrBack) {
	CMinimalDC&	oDC = m_gdiObjects.oMemDC;

	if(bt == BT_LF || bt == BT_CR || bt == BT_CRLF) {
		HPEN	hOldPen = oDC.SelectObject(m_gdiObjects.hLineBreakPen);
		int		cx = GetAvgCharWidth();
		int		cy = m_layoutInfo.nLineHeight;
		int		hx, hy;

		// ŏl̐ݒ
		cx = std::max(cx, 7);

		// wiFh
		oDC.FillSolidRect(x, y, cx, cy, clrBack);

		// ɑƕ`Ղ?
		cx -= (cx % 2 == 0) ? 1 : 0;
		cy -= (cy % 2 == 0) ? 1 : 0;

		// ̈ʒu
		hx = x + cx / 2;
		hy = y + cy / 2;

		if(bt == BT_LF) {	// E
			oDC.MoveTo(x + 1, hy);
			oDC.LineTo(x + cx, hy);
			oDC.MoveTo(hx + 1, hy - cx / 2 + 1);
			oDC.LineTo(x + cx, hy + 1);
			oDC.MoveTo(hx + 1, hy + cx / 2 - 1);
			oDC.LineTo(x + cx, hy - 1);
		} else if(bt == BT_CR) {	// 
			oDC.MoveTo(x + cx - 1, hy);
			oDC.LineTo(x, hy);
			oDC.MoveTo(hx - 0, hy - cx / 2 + 1);
			oDC.LineTo(x + 0, hy + 1);
			oDC.MoveTo(hx - 0, hy + cx / 2 - 1);
			oDC.LineTo(x + 0, hy - 1);
		} else {	// 
			oDC.MoveTo(hx, hy - cx / 2);
			oDC.LineTo(hx, hy + cx / 2 + 1);
			oDC.MoveTo(x + 1, hy + 1);
			oDC.LineTo(hx, hy + cx / 2);
			oDC.MoveTo(x + cx - 2, hy + 1);
			oDC.LineTo(hx, hy + cx / 2);
		}
		oDC.SelectObject(hOldPen);
		return cx;
	} else if(bt == BT_NEL || bt == BT_LS || bt == BT_PS) {
		// Unicode s͈ȉ̃R[h|Cg̃Otőւ
		//  NEL (U+0085: Next Line) -- U+21A9: Leftwards Arrow With Hook
		//  LS (U+2028: Line Separator) -- U+21B2: Downwards Arrow With Tip Leftwards
		//  PS (U+2029: Paragraph Separator) -- U+21B2 ̑
		// ̃Ot܂܂ȂtHgA
		// ̎̉sg[UȂΉtHgpӂł邾낤
		HFONT	hOldFont = oDC.SelectObject((bt != BT_PS) ?
							m_gdiObjects.hNormalFont : m_gdiObjects.hBoldFont);
		wchar_t	chBreakArrow = (bt == BT_NEL) ? L'\x21A9' : L'\x21B2';
		RECT	rect;
		int		nWidth;

		oDC.GetCharWidth(chBreakArrow, chBreakArrow, &nWidth);
		::SetRect(&rect, x, y, x + nWidth, y + m_layoutInfo.nLineHeight);
		oDC.SetTextColor(m_pTokenFoundations->tfs[ETT_END_OF_LINE].ptf->fgColor);
		oDC.SetBkColor(clrBack);
		oDC.SetBkMode(OPAQUE);
		oDC.ExtTextOut(x, y, ETO_OPAQUE, &rect, &chBreakArrow, 1, 0);
		oDC.SelectObject(hOldFont);

		return nWidth;
	} else
		assert(false);
	return 0;
}

/**
 *	т`
 *	@param iStart	Jns (\s)
 *	@param iEnd		Is (\s)
 */
void CEditView::DrawLeftTab(length_t iStart, length_t iEnd) {
	AssertValidAsWindow();

	HPEN		hOldPen;
	RECT		rectClient;
	CMinimalDC&	oDC = m_gdiObjects.oMemDC;
	int			yStart = m_layoutInfo.nTopMargin + (iStart - m_ptScroll.y) * m_layoutInfo.nLineHeight;

	if(iStart > iEnd)
		swap(iStart, iEnd);

	GetClientRect(&rectClient);

	// CWP[^}[W
	if(m_layoutInfo.lineNumberLayout.bShowIndicatorMargin) {
		const unsigned short	nIMWidth = m_layoutInfo.lineNumberLayout.nIMWidth;
		if(m_modeState.wpmWrapMode == WPM_NONE) {
			RECT				rectSolid = {rectClient.left, yStart,
									rectClient.left + nIMWidth,
									yStart + m_layoutInfo.nLineHeight};
			const CLineLayout*	pInfo = m_pLineLayoutManager->GetLine(iStart);

			// n (?) `
			hOldPen = oDC.SelectObject(m_gdiObjects.hLeftIndicatorPen);
			oDC.FillSolidRect(rectClient.left, rectClient.top,
				nIMWidth, rectClient.bottom - rectClient.top,
				GetTextFoundation(ETT_INDICATOR_MARGIN, NullCookie).bgColor);
			oDC.MoveTo(nIMWidth - 1, rectClient.top);
			oDC.LineTo(nIMWidth - 1, rectClient.bottom);

			for(length_t iLine = iStart; iLine <= iEnd; ++iLine) {
				pInfo = m_pLineLayoutManager->GetLine(iLine);
				for(set<IEditViewEventListener*>::iterator it
						= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
					(*it)->OnDrawIndicatorMargin(iLine, oDC,
						rectSolid, pInfo->IsBookmarked(), pInfo->GetUserDefinedValue(),
						pInfo == m_layoutInfo.pAppDefinedSingleLine);
				::OffsetRect(&rectSolid, 0, m_layoutInfo.nLineHeight);
			}
			oDC.SelectObject(hOldPen);
		}
		rectClient.left += nIMWidth;
	}

	// sԍ
	if(m_layoutInfo.lineNumberLayout.bShowLineNumbers) {
		char_t				wszLineNumber[32];
		RECT				rectLineNumber, rectLineNumberDraw;
		LineIterator		it = 0;
		HFONT				hOldFont = 0;
		EmphaticTextType	ttLine;	// `悷sʂ̍ss
		length_t			iLogicalStart, iDummy;

		oDC.SetTextCharacterExtra(0);	// sԍ\͕Ԋu̐ݒ𖳎
		GetDisplayLineOffsetIndex(iStart, iLogicalStart, iDummy);
		it = GetDocument()->GetLineIterator(iLogicalStart);
		rectLineNumber = rectClient;
		rectLineNumber.right = m_layoutInfo.nLeftTabWidth;
		rectLineNumberDraw.left = rectLineNumber.left;
		rectLineNumberDraw.right = rectLineNumber.right - 4;
		if(m_layoutInfo.lineNumberLayout.borderStyle != TLineNumberLayout::LNBS_NONE)
            rectLineNumberDraw.right -= m_layoutInfo.lineNumberLayout.nBorderWidth;
		hOldPen = oDC.SelectObject(m_gdiObjects.hLineNumberPen);
		oDC.SetBkMode(OPAQUE);
		oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
			rectLineNumber.right - rectLineNumber.left,
			rectClient.bottom - rectClient.top,
			GetTextFoundation(ETT_LINENUMBER, NullCookie).bgColor);

		if(m_modeState.wpmWrapMode == WPM_NONE) {
			TTextFoundation	tf;
			// 1s`
			for(length_t iLine = iStart; iLine <= iEnd; ++iLine, ++it) {
				swprintf(wszLineNumber, L"%lu", iLine + m_modeState.iStartLine);
				rectLineNumber.top = rectLineNumberDraw.top
					= (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight + m_layoutInfo.nTopMargin;
				rectLineNumber.bottom = rectLineNumberDraw.bottom
					= rectLineNumber.top + m_layoutInfo.nLineHeight;
				ttLine = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
				tf = GetTextFoundation(ttLine, NullCookie);

				// tHgȂǂ̑I
				oDC.SetTextColor(tf.fgColor);
				oDC.SetBkColor(tf.bgColor);
				hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttLine, NullCookie));
				oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
					rectLineNumber.right - rectLineNumber.left,
					m_layoutInfo.nLineHeight, tf.bgColor);
				oDC.DrawText(wszLineNumber, -1, &rectLineNumberDraw, DT_TOP | DT_RIGHT | DT_SINGLELINE);
				oDC.SelectObject(hOldFont);
			}
		} else {	// ܂Ԃlꍇ
			length_t		iLine = iStart;
			length_t		iLogicalLine;
			length_t		iOffset;
			CLineLayout*	pInfo = 0;
			TTextFoundation	tf;

			GetDisplayLineOffsetIndex(iStart * m_layoutInfo.nVScrollRatio, iLogicalLine, iOffset);
			pInfo = m_pLineLayoutManager->GetLine(iLogicalLine);
			while(iLine <= iEnd && pInfo != 0) {
				ttLine = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
				if(iOffset >= pInfo->GetWrappedPoints().size() + 1) {	// ̘_s֐i
					++iLogicalLine;
					++it;
					ttLine = it->IsModified() ? ETT_EMPHATIC_LINENUMBER : ETT_LINENUMBER;
					tf = GetTextFoundation(ttLine, NullCookie);
					iOffset = 0;
					pInfo = m_pLineLayoutManager->GetLine(iLogicalLine);
					continue;
				}
				if(iOffset == 0) {
					swprintf(wszLineNumber, L"%lu", iLogicalLine + m_modeState.iStartLine);
					rectLineNumber.top = rectLineNumberDraw.top
						= (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight + m_layoutInfo.nTopMargin;
					rectLineNumber.bottom = rectLineNumberDraw.bottom
						= rectLineNumber.top + m_layoutInfo.nLineHeight;

					// tHgȂǂ̑I
					oDC.SetTextColor(tf.fgColor);
					oDC.SetBkColor(tf.bgColor);
					hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttLine, NullCookie));
					oDC.FillSolidRect(rectLineNumber.left, rectLineNumber.top,
						rectLineNumber.right - rectLineNumber.left,
						m_layoutInfo.nLineHeight, tf.bgColor);
					oDC.DrawText(wszLineNumber, -1, &rectLineNumberDraw, DT_TOP | DT_RIGHT | DT_SINGLELINE);
					oDC.SelectObject(hOldFont);
				}
				++iLine;
				++iOffset;
			}
		}

		const int	xBorder = m_layoutInfo.nLeftTabWidth - m_layoutInfo.lineNumberLayout.nBorderWidth / 2 - 1;
		oDC.MoveTo(xBorder, rectClient.top);
		oDC.LineTo(xBorder, rectClient.bottom);
		oDC.SelectObject(hOldPen);
	}
}

/**
 *	_s1s`B` m_hMemDC ɑIĂrbg}bvɍs
 *	@param iLine		`悷_s
 *	@param y			y W (r[W)
 *	@param strLine		`e
 *	@param bt			̍s̉sR[h
 *	@param pLineInfo	`悷_s̃CAEg
 *	@return				`悵\s
 */
length_t CEditView::DrawLine(length_t iLine,
		int y, const string_t& strLine, BreakType bt, const CLineLayout* pLineInfo) {
	AssertValidAsWindow();
	
//	CTimer	tm(L"DrawLine");

	CTokenLayout** const	ppTokens = pLineInfo->GetTokenList();

	const char_t*	pwszLine = strLine.c_str();
	const length_t	cchLine = strLine.length();
	const long		xUpdateLeft = m_layoutInfo.rectUpdate.left - static_cast<long>(m_layoutInfo.nLeftTabWidth);
	const long		xUpdateRight = m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth);
	length_t		iSelBegin, iSelEnd;	// ̍sɂI͈
	register long	nXOffset;			// `ʒu
	RECT			rect;
	length_t		cDrawnLines = 0;	// ߂l
	CMinimalDC&		oDC = m_gdiObjects.oMemDC;
	const int		nScrollOffset = m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
	COLORREF		clrForeFixed = -1;	// OnQueryLineColor 瓾OiF
	COLORREF		clrBackFixed = -1;	// OnQueryLineColor 瓾wiF
	const COLORREF	clrSelectionFG =
		GetTextFoundation((::GetFocus() == m_hWnd) ? ETT_SELECTION : ETT_INACTIVE_SELECTION, NullCookie).fgColor;
	const COLORREF	clrSelectionBG =
		GetTextFoundation((::GetFocus() == m_hWnd) ? ETT_SELECTION : ETT_INACTIVE_SELECTION, NullCookie).bgColor;
	list<pair<length_t, length_t> >	listLinks;		// ÑXg
	list<pair<length_t, length_t> >	listMatches;	// ݂̌Ɉv镔̃Xg

	// I͈͂̌vZ
	if(!HasSelection())	// 
		iSelBegin = iSelEnd = -1;
	else if(!toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {	// `
		if(iLine == m_pAnchorPoint->m_iLine)
			iSelBegin = m_pAnchorPoint->m_iChar;
		else
			iSelBegin = (iLine < m_pAnchorPoint->m_iLine) ? -1 : 0;
		if(iLine == m_pActivePoint->m_iLine)
			iSelEnd = m_pActivePoint->m_iChar;
		else
			iSelEnd = (iLine < m_pActivePoint->m_iLine) ? -1 : 0;
	} else {	// `
		length_t	iTopLine = GetSelTopPoint().m_iLine;
		length_t	iBottomLine = GetSelBottomPoint().m_iLine;

		if(iLine >= iTopLine && iLine <= iBottomLine) {
			iSelBegin = CharFromPixel(iLine, m_layoutInfo.xBoxSelectionAnchor, !m_modeState.bCaretExtenderByMouse);
			iSelEnd = CharFromPixel(iLine, m_layoutInfo.xBoxSelectionActive, !m_modeState.bCaretExtenderByMouse);
		} else
			iSelBegin = iSelEnd = 0;
	}
	if(iSelBegin > iSelEnd)
		swap(iSelBegin, iSelEnd);

	// Ňo
	if(m_pTokenFoundations->arrEnabled[ETT_LINK]
			&& GetTextFoundation(ETT_LINK, NullCookie, true).border != BT_NONE) {
		length_t	cchLink;
		for(length_t i = 0; i < cchLine; ++i) {
			if((0 != (cchLink = IsUrlString(pwszLine + i, cchLine - i)))
					|| (0 != (cchLink = IsMailAddress(pwszLine + i, cchLine - i))))
				listLinks.push_back(pair<length_t, length_t>(i, i + cchLink));
		}
	}

	// v̌vZ
	if(m_modeState.bHighlightSearchText && m_pTokenFoundations->arrEnabled[ETT_MATCHTEXT]) {
//		length_t	i = 0;
//		length_t	iFound, cchFound;
//
//		while(CEditView::m_oTextSearcher.Search(strLine, i, iFound, cchFound, *m_pBoundarySearcher)) {
//			listMatches.push_back(pair<length_t, length_t>(iFound, iFound + cchFound));
//			i = iFound + cchFound;
//		}
	}

	// O
	oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan);
	GetClientRect(&rect);
	nXOffset = m_layoutInfo.nLeftMargin - nScrollOffset;
	for(set<IEditViewEventListener*>::iterator it
			= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnQueryLineColor(iLine, pLineInfo->IsBookmarked(),
			pLineInfo->GetUserDefinedValue(), pLineInfo == m_layoutInfo.pAppDefinedSingleLine, clrForeFixed, clrBackFixed);

	length_t	iChar = 0;	// ʒu
	length_t	cchToken;	// ̒
	int			ttCurrent;	// `悷镶̎
	TokenCookie	nCookie;	// L[[hRg̏ꍇ̂̎
	size_t		iToken = 0;
	while(iToken < pLineInfo->GetTokenCount() && nXOffset <= xUpdateRight) {
		const CTokenLayout*	pToken = ppTokens[iToken];

		nXOffset = pToken->GetLeftEdge() + m_layoutInfo.nLeftMargin - nScrollOffset;

		// `KvȔ͈͂܂œǂݔ΂
		if(nXOffset + static_cast<long>(pToken->GetTextWidth()) < xUpdateLeft) {
			nXOffset += pToken->GetTextWidth();
			++iToken;
			continue;
		}

		iChar = pToken->GetIndex();
		ttCurrent = pToken->GetType();
		nCookie = pToken->GetCookie();
		cchToken = (iToken < pLineInfo->GetTokenCount() - 1) ?
			ppTokens[iToken + 1]->GetIndex() - pToken->GetIndex() : cchLine - pToken->GetIndex();

		// \銇
		if(cchToken == 1
				&& m_pTokenFoundations->arrEnabled[ETT_MATCH_BRACKETS]
				&& ((iLine == m_layoutInfo.posHilightedBrackets[0].m_iLine
				&& iChar == m_layoutInfo.posHilightedBrackets[0].m_iChar)
				|| (iLine == m_layoutInfo.posHilightedBrackets[1].m_iLine
				&& iChar == m_layoutInfo.posHilightedBrackets[1].m_iChar)))
			ttCurrent = ETT_MATCH_BRACKETS;

		// `
		TTextFoundation&	tf = GetTextFoundation(ttCurrent, nCookie);
		HFONT				hOldFont = oDC.SelectObject(GetFontForRenderingToken(ttCurrent, nCookie));
		bool				bOverflow = false;			// ܂ԂNꍇ true
//		length_t			cchDisplay = cchToken;		// 1x̕`ŏo͂镶
//		const length_t		iCharTokenStart = iChar;	// ܂Ԃ擪s̈ʒu
//		unsigned long		cxToken;					// DrawText ADrawSpace ̖߂l

		if(m_pTokenFoundations->arrEnabled[ttCurrent]
				&& tf.bold && m_foundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan - 1);
//		do {	// ̕`悪I܂ŕ\si߂
			// ܂Ԃl
//			if(m_modeState.wpmWrapMode != WPM_NONE) {
//				if(cDrawnLines < pLineInfo->m_vecWrappedOffsets.size()
//						&& iCharTokenStart + cchToken >= pLineInfo->m_vecWrappedOffsets[cDrawnLines]) {
//					bOverflow = true;
//					cchDisplay = pLineInfo->m_vecWrappedOffsets[cDrawnLines] - iChar;
//				} else if(bOverflow) {
//					bOverflow = false;
//					cchDisplay = cchToken - (iChar - iCharTokenStart);
//				}
//			}

			// g[N̕`
			RECT							rect;
			const DirectionList*			pDirs = pToken->GetDirectionList();
			DirectionList::const_iterator	itDirs;
			bool							bRtlReading = false;
			CLexer*							pLexer = m_pLineLayoutManager->GetLexer();

			if(pDirs != 0)
				itDirs = pDirs->begin();
			rect.top = y;
			rect.bottom = y + m_layoutInfo.nLineHeight;
			while(iChar < pToken->GetIndex() + cchToken) {
				bool		bInSelection = iChar >= iSelBegin && iChar < iSelEnd;
				length_t	iNextDirChange = -1;

				if(pDirs != 0) {
					if(++itDirs != pDirs->end())
						iNextDirChange = pToken->GetIndex() + itDirs->iStartChar;
					while(itDirs != pDirs->end() && pToken->GetIndex() + itDirs->iStartChar <= iChar)
						++itDirs;
					bRtlReading = (--itDirs)->bRightToLeft;
				} else
					bRtlReading = false;
				if(pwszLine[iChar] == L'\t') {	// ^u1
					rect.left = pLineInfo->GetCaretPosition(iChar) + m_layoutInfo.nLeftMargin - nScrollOffset;
					rect.right = GetNextTabStop(rect.left - m_layoutInfo.nLeftMargin
									+ nScrollOffset, false) + m_layoutInfo.nLeftMargin - nScrollOffset;

					if(!bRtlReading && iNextDirChange == -1) {	// LTR ̏ꍇ̓XLbvł邩
						if(rect.right < xUpdateLeft) {
							++iChar; continue;
						} else if(rect.left > xUpdateRight) {
							iChar = pToken->GetIndex() + cchToken; continue;
						}
					}

					oDC.SetTextColor(bInSelection ? clrSelectionFG :
						((clrForeFixed == -1) ? GetTextFoundation(TT_TAB, NullCookie).fgColor : clrForeFixed));
					oDC.SetBkColor(bInSelection ? clrSelectionBG :
						((clrBackFixed == -1) ? GetTextFoundation(ttCurrent, nCookie).bgColor : clrBackFixed));
					oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect,
						&m_foundationInfo.chTab, (bInSelection || !m_foundationInfo.bDrawSpaces) ? 0 : 1, 0);
					++iChar;
				} else if(pLexer->IsWhiteSpace(pwszLine + iChar, 1, false) > 0) {	// 󔒗ޕ1
					oDC.SetBkColor(bInSelection ? clrSelectionBG :
						((clrBackFixed == -1) ? GetTextFoundation(ttCurrent, nCookie).bgColor : clrBackFixed));

					char_t	chAlternative;	// փOt
					if(!m_foundationInfo.bDrawSpaces)
						chAlternative = L' ';
					else if(pwszLine[iChar] == L'\x3000') {	// Ideographic Space
						chAlternative = m_foundationInfo.chIdeographicSpace;
						oDC.SetTextColor(GetTextFoundation(TT_WHITESPACE, NullCookie).fgColor);
					} else if(pwszLine[iChar] == L'\x1680') {	// Ogham Space Mark
						chAlternative = L'\x1680';
						oDC.SetTextColor(bInSelection ? clrSelectionFG :
							((clrForeFixed == -1) ? GetTextFoundation(TT_WHITESPACE, NullCookie).fgColor : clrForeFixed));
					} else {
						chAlternative = m_foundationInfo.chSpace;
						oDC.SetTextColor(GetTextFoundation(TT_WHITESPACE, NullCookie).fgColor);
					}

					const int	nPos = pLineInfo->GetCharacterLeadPosition(
										*pToken, iChar - pToken->GetIndex());
					if(bRtlReading) {	// RTL
						if(/*iNextDirChange > iChar + 1
								&&*/ iChar + 1 < pToken->GetIndex() + cchToken)	// Młl
							rect.left = pLineInfo->GetCaretPosition(iChar + 1)
											+ m_layoutInfo.nLeftMargin - nScrollOffset;
						else
							rect.left = nPos - oDC.GetTextExtent(pwszLine + iChar, 1).cx
											+ m_layoutInfo.nLeftMargin - nScrollOffset;
						if(iChar > pToken->GetIndex() + itDirs->iStartChar)	// Młl
							rect.right = pLineInfo->GetCaretPosition(iChar) - nScrollOffset + m_layoutInfo.nLeftMargin;
						else
							rect.right = nPos - nScrollOffset + m_layoutInfo.nLeftMargin;
						oDC.ExtTextOut(rect.left, y, ETO_CLIPPED | ETO_OPAQUE | ETO_RTLREADING, &rect,
							&chAlternative, (bInSelection || !m_foundationInfo.bDrawSpaces) ? 0 : 1, 0);
					} else {	// LTR
						rect.left = nPos + m_layoutInfo.nLeftMargin - nScrollOffset;
						if(iNextDirChange == -1) {
							rect.right = pLineInfo->GetCaretPosition(iChar + 1)
											+ m_layoutInfo.nLeftMargin - nScrollOffset;
							if(rect.right < xUpdateLeft) {
								++iChar; continue;
							} else if(rect.left > xUpdateRight) {
								iChar = pToken->GetIndex() + cchToken; continue;
							}
						} else
							rect.right = rect.left + oDC.GetTextExtent(pwszLine + iChar, 1).cx;
						oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect,
							&chAlternative, (bInSelection || !m_foundationInfo.bDrawSpaces) ? 0 : 1, 0);
					}
					++iChar;
				} else {	// ̑͑̕I̒[A̕ύX܂ł܂Ƃ߂ĕ`
					length_t	cchDraw = 1;

					while(iChar - pToken->GetIndex() + cchDraw < cchToken) {
						if(toBoolean(pLexer->IsWhiteSpace(pwszLine + iChar + cchDraw, 1, true) != 0))	// 󔒗ޕ͈ꏏɕ`悵Ȃ
							break;
						if(iSelBegin == iChar + cchDraw || iSelEnd == iChar + cchDraw)	// I̒[ŃXgbv
							break;
						if(iChar + cchDraw >= iNextDirChange)	// ςXgbv
							break;
						++cchDraw;
					}
					oDC.SetTextColor(bInSelection ?
						clrSelectionFG : ((clrForeFixed == -1) ? tf.fgColor : clrForeFixed));
					oDC.SetBkColor(bInSelection ?
						clrSelectionBG : ((clrBackFixed == -1) ? tf.bgColor : clrBackFixed));

					// ``̍vZ -> E -> `
					const int	nPos = pLineInfo->GetCharacterLeadPosition(
										*pToken, iChar - pToken->GetIndex());
					if(bRtlReading) {	// RTL
//						if(iNextDirChange > iChar + cchDraw + 1
//								&& iChar + cchDraw < itTokens->GetIndex() + cchToken)	// Młl
//							rect.left = pLineInfo->GetCaretPosition(iChar + cchDraw + 1)
//											+ m_layoutInfo.nLeftMargin - nScrollOffset;
//						else
							rect.left = nPos - oDC.GetTextExtent(pwszLine + iChar, cchDraw).cx
											+ m_layoutInfo.nLeftMargin - nScrollOffset;
						rect.right = nPos + m_layoutInfo.nLeftMargin - nScrollOffset /*+ 1*/;
						oDC.ExtTextOut(rect.left, y, ETO_CLIPPED | ETO_OPAQUE | ETO_RTLREADING, &rect, pwszLine + iChar, cchDraw, 0);
					} else {	// LTR
						bool	bOverRightEdge = false;
						if(iNextDirChange == -1) {
							// `Jnʒu
							while(cchDraw != 0 && pLineInfo->GetCaretPosition(iChar + 1)
									+ static_cast<long>(m_layoutInfo.nLeftMargin) - nScrollOffset < xUpdateLeft)
								++iChar, --cchDraw;
							rect.left = pLineInfo->GetCaretPosition(iChar) + m_layoutInfo.nLeftMargin - nScrollOffset;

							// `Iʒu
							while(cchDraw != 0 && pLineInfo->GetCaretPosition(iChar)
									+ static_cast<long>(m_layoutInfo.nLeftMargin) - nScrollOffset > xUpdateRight) {
								--cchDraw;
								bOverRightEdge = true;
							}
							rect.right = pLineInfo->GetCaretPosition(iChar + cchDraw)
											+ m_layoutInfo.nLeftMargin - nScrollOffset;
						} else {
							rect.left = nPos + m_layoutInfo.nLeftMargin - nScrollOffset;
							rect.right = rect.left + oDC.GetTextExtent(pwszLine + iChar, cchDraw).cx;
						}
						if(cchDraw != 0)
							oDC.ExtTextOut(rect.left, y, ETO_OPAQUE, &rect, pwszLine + iChar, cchDraw, 0);
						if(bOverRightEdge)	// `悪KvȔ͈͂𒴂獡ŏI
							break;
					}
					iChar += cchDraw;
				}
			}

			// /g
			nXOffset += pToken->GetTextWidth();
			if(tf.border != BT_NONE)
				DrawBorder(pToken->GetLeftEdge() + m_layoutInfo.nLeftMargin - nScrollOffset, y,
					pToken->GetLeftEdge() + pToken->GetTextWidth() + m_layoutInfo.nLeftMargin - nScrollOffset,
					y + m_layoutInfo.nCharHeight, tf.border, tf.borderColor);

//			iChar += cchDisplay;

//			if(bOverflow) {	// ̕\sɐi
				// TODO: ]hԂR[h...
//				++cDrawnLines;
//				nXOffset = m_layoutInfo.nLeftMargin
//							- GetAvgCharWidth() * m_ptScroll.x * m_layoutInfo.nHScrollRatio;
//				listLinks.clear();
//			}
//		} while(bOverflow);

		if(m_pTokenFoundations->arrEnabled[ttCurrent]
				&& tf.bold && m_foundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_layoutInfo.nCharSpan);
		++iToken;
		oDC.SelectObject(hOldFont);
	}

	// N̋\
	const TTextFoundation	tfLink = GetTextFoundation(ETT_LINK, NullCookie);
	for(list<pair<length_t, length_t> >::const_iterator it
			= listLinks.begin(); it != listLinks.end(); ++it) {
		DrawBorder(PosFromChar(CCharPos(iLine, it->first)).x - m_layoutInfo.nLeftTabWidth,
			y, PosFromChar(CCharPos(iLine, it->second)).x - m_layoutInfo.nLeftTabWidth,
			y + m_layoutInfo.nCharHeight, tfLink.border, tfLink.borderColor);
	}

	// I}[N̕`
	if(nXOffset <= m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
		if(iLine == GetDocument()->GetLineCount() - 1) {	// 
			if(m_foundationInfo.bDrawEOF) {	// [EOF] }[N
				RECT				rect;
				HFONT				hOldFont;
				TTextFoundation&	tf = GetTextFoundation(ETT_END_OF_FILE, NullCookie);

				hOldFont = oDC.SelectObject(GetFontForRenderingToken(ETT_END_OF_FILE, NullCookie));
				rect.left = nXOffset;
				rect.top = y;
				rect.right = rect.left + oDC.GetTextExtent(
					m_foundationInfo.strEndOfFile.c_str(), m_foundationInfo.strEndOfFile.length()).cx;
				rect.bottom = rect.top + m_layoutInfo.nLineHeight;
				oDC.SetTextColor(tf.fgColor);
				oDC.SetBkColor(tf.bgColor);
				oDC.ExtTextOut(nXOffset, y, ETO_OPAQUE, &rect,
					m_foundationInfo.strEndOfFile.c_str(), m_foundationInfo.strEndOfFile.length(), 0);
				oDC.SelectObject(hOldFont);
				nXOffset += rect.right - rect.left;
			}
		} else if(m_foundationInfo.bDrawBreakArrow) {	// s}[N
			COLORREF	clrBreakBg;

			if(iSelBegin != -1 && iSelEnd == -1 && m_foundationInfo.bPaintBreakContinuingSelection)
				clrBreakBg = GetTextFoundation(
					(::GetFocus() == m_hWnd) ? ETT_SELECTION : ETT_INACTIVE_SELECTION, NullCookie).bgColor;
			else if(clrBackFixed != -1)
				clrBreakBg = clrBackFixed;
			else
				clrBreakBg = GetTextFoundation(ETT_NORMAL, NullCookie).bgColor;
			nXOffset += DrawBreakMark(nXOffset, y + cDrawnLines * m_layoutInfo.nLineHeight, bt, clrBreakBg);
		}
	}

	// E]̕`
	if(nXOffset <= m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth))
		oDC.FillSolidRect(nXOffset, y,
			m_layoutInfo.rectUpdate.right - static_cast<long>(m_layoutInfo.nLeftTabWidth) - nXOffset,
			m_layoutInfo.nLineHeight,
			(clrBackFixed == -1) ? GetTextFoundation(ETT_NORMAL, NullCookie).bgColor : clrBackFixed);

	// ]̕`
	if(m_layoutInfo.nLeftMargin != 0)
		oDC.FillSolidRect(0, y,
			m_layoutInfo.nLeftMargin /*- 1*/, m_layoutInfo.nLineHeight * (cDrawnLines + 1),
			GetTextFoundation(ETT_NORMAL, NullCookie).bgColor);

	return cDrawnLines + 1;
}

/// @see	IDropTarget::Drop
STDMETHODIMP CEditView::Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect) {
	if(pDataObj == 0)
		return E_INVALIDARG;
	VERIFY_POINTER(pdwEffect);

	if(m_ldmLeftDown == LDM_DRAGANDDROP) {	// vZX̃f[^
		char*		pszText = 0;
		char_t*		pwszText = 0;
		FORMATETC	fe = {CF_UNICODETEXT, 0, DVASPECT_CONTENT, -1, TYMED_HGLOBAL};
		STGMEDIUM	stm = {TYMED_HGLOBAL, 0};
		length_t	cch;
		POINT		ptCaret = {pt.x, pt.y};

		KillTimer(TIMERID_DRAGSCROLL);
		ScreenToClient(&ptCaret);
		CCharPos	pos = CharFromPos(ptCaret, !m_modeState.bCaretExtenderByMouse);
		SetSelWithoutSelection(pos);
		UINT		nBoxClipFormat = ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT);

		if(pDataObj->QueryGetData(&fe) == S_OK) {	// CF_UNICODETEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				cch = ::GlobalSize(stm.hGlobal) / sizeof(char_t);
				pwszText = reinterpret_cast<wchar_t*>(::GlobalLock(stm.hGlobal));
//				*(pwszText + cch) = 0;
				GetDocument()->EndEditCollection();
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					GetDocument()->BeginEditCollection();
					m_pActivePoint->InsertBox(pwszText);
					GetDocument()->EndEditCollection();
					BeginBoxSelect();
				} else
					m_pActivePoint->Insert(pwszText);
				Unfreeze();
				m_pActivePoint->EnsureVisible();
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
					// ::GlobalFree(stm.hGlobal);
				*pdwEffect = DROPEFFECT_COPY;
			}
		} else if(fe.cfFormat = CF_TEXT, pDataObj->QueryGetData(&fe) == S_OK) {	// CF_TEXT T|[g
			if(SUCCEEDED(pDataObj->GetData(&fe, &stm))) {
				cch = ::GlobalSize(stm.hGlobal) / sizeof(char);
				pszText = reinterpret_cast<char*>(::GlobalLock(stm.hGlobal));
//				*(pszText + cch) = 0;
				pwszText = new char_t[cch];
				::MultiByteToWideChar(CP_ACP, 0, pszText, -1, pwszText, cch);
				Freeze();
				if(fe.cfFormat = nBoxClipFormat, pDataObj->QueryGetData(&fe) == S_OK) {	// `hbv
					GetDocument()->BeginEditCollection();
					m_pActivePoint->InsertBox(pwszText);
					GetDocument()->EndEditCollection();
					BeginBoxSelect();
				} else
					m_pActivePoint->Insert(pwszText);
				Unfreeze();
				m_pActivePoint->EnsureVisible();
				delete[] pwszText;
				::GlobalUnlock(stm.hGlobal);
				if(stm.pUnkForRelease != 0)
					stm.pUnkForRelease->Release();
					// ::GlobalFree(stm.hGlobal);
				*pdwEffect = DROPEFFECT_COPY;
			}
		}
	} else if(m_ldmLeftDown == LDM_DRAGANDDROPSELF
			|| m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// vZX̃f[^ (pDataObj gȂȒPȏ)
		CEditDoc*	pDoc = GetDocument();
		string_t	strText = GetSelection();
		POINT		ptCaret = {pt.x, pt.y};

		ScreenToClient(&ptCaret);
		const CCharPos	pos = CharFromPos(ptCaret, !m_modeState.bCaretExtenderByMouse);

		// vZX̃f[^͑I͈͏Ƀhbvs
		if(IsOverSelection(ptCaret)) {
			*pdwEffect = DROPEFFECT_NONE;
			m_ldmLeftDown = LDM_NONE;
			SetSelWithoutSelection(pos);
			return S_OK;
		}

		pDoc->BeginEditCollection();
		Freeze();

		if(toBoolean(grfKeyState & MK_CONTROL)) {	// 
			InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
			m_pAnchorPoint->MoveToPoint(pos);
			m_pActivePoint->MoveToPoint(pos);
			if(m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {
				m_pActivePoint->InsertBox(strText);
				BeginBoxSelect();
			} else
				m_pActivePoint->Insert(strText);
			*pdwEffect = DROPEFFECT_COPY;
		} else if(m_ldmLeftDown == LDM_DRAGANDDROPBOXSELF) {	// `ړ
			CEditPoint*	pInsertPoint = CreateEditPoint();

			pInsertPoint->SynchronizeWithOtherEdit(true);
			*pInsertPoint = pos;
			DeleteSel();
			m_pAnchorPoint->m_iLine = m_pActivePoint->m_iLine = pInsertPoint->m_iLine;
			m_pAnchorPoint->m_iChar = m_pActivePoint->m_iChar = pInsertPoint->m_iChar;
			m_pActivePoint->InsertBox(strText);
			BeginBoxSelect();
			m_pActivePoint->Insert(L"");	// _~[
			delete pInsertPoint;
			*pdwEffect = DROPEFFECT_MOVE;
		} else {	// ړ
			CEditPoint*	pActivePointOrg = CreateEditPoint();
			CCharPos	posAnchorOrg = *m_pAnchorPoint;

			pActivePointOrg->SynchronizeWithOtherEdit(true);
			pActivePointOrg->m_iLine = m_pActivePoint->m_iLine;
			pActivePointOrg->m_iChar = m_pActivePoint->m_iChar;
			m_pAnchorPoint->MoveToPoint(pos);
			m_pActivePoint->MoveToPoint(pos);
			pActivePointOrg->Delete(posAnchorOrg);
			m_pActivePoint->Insert(strText);
			delete pActivePointOrg;
			*pdwEffect = DROPEFFECT_MOVE;
		}
		pDoc->EndEditCollection();
		Unfreeze();
		m_pActivePoint->EnsureVisible();
		m_eoLast.set(EOT_PASTE, *m_pActivePoint);
	}
	m_ldmLeftDown = LDM_NONE;
	return S_OK;
}

/**
 *	R}h̏
 *	@param cmd		sR}hʎq
 *	@param lParam	R}hˑ̃p[^
 */
void CEditView::ExecCommand(CommandIdentifier cmd, LPARAM lParam) {
	AssertValid();

	// L[}NɋL^
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING
			&& m_pKeyMacroPlayer->GetActiveView() == this) {
		TKeymacroCommand	kmc;
		kmc.cmd = cmd;
		kmc.lParam = lParam;
		m_pKeyMacroPlayer->AddCommand(kmc);
	}

	// CN^
	if(m_modeState.incrementalSearchState != ISS_NOTRUNNING) {
		if(cmd != CMDID_EDIT_BACKSPACE					// eLXg̖1폜
				&& cmd != CMDID_EDIT_BREAK				// I
				&& cmd != CMDID_EDIT_CHAR				// eLXg̖1ǉ
				&& cmd != CMDID_EDIT_DELETE				// eLXg폜
				&& cmd != CMDID_MOVE_CANCELSELECTION)	// 𒆎~
			CmdMoveIncrementalSearch(ISS_NOTRUNNING);
	}

	// Zk̓WJ҂
	if(m_modeState.bReadyToExpandAbbrev && cmd != CMDID_EDIT_BREAK && cmd != CMDID_EDIT_CHAR) {
		for(set<IEditViewEventListener*>::iterator it =
				m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it) {
			(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
		}
		m_modeState.bReadyToExpandAbbrev = false;
	}

	switch(cmd) {
		// ړƑI
	case CMDID_MOVE_BOOKMARKNEXT:		CmdMoveNextBookmark();				break;
	case CMDID_MOVE_BOOKMARKPREV:		CmdMovePrevBookmark();				break;
	case CMDID_MOVE_CANCELSELECTION:	CmdMoveCancelSelection();			break;
	case CMDID_MOVE_CHARNEXT:			CmdMoveCharNext(false, lParam);		break;
	case CMDID_MOVE_CHARNEXTEXTEND:		CmdMoveCharNext(true, lParam);		break;
	case CMDID_MOVE_CHARPREV:			CmdMoveCharPrev(false, lParam);		break;
	case CMDID_MOVE_CHARPREVEXTEND:		CmdMoveCharPrev(true, lParam);		break;
	case CMDID_MOVE_END:				CmdMoveEnd(false);					break;
	case CMDID_MOVE_ENDEXTEND:			CmdMoveEnd(true);					break;
	case CMDID_MOVE_HOME:				CmdMoveHome(false);					break;
	case CMDID_MOVE_HOMEEXTEND:			CmdMoveHome(true);					break;
	case CMDID_MOVE_INCREMENTALSEARCH:	CmdMoveIncrementalSearch(toBoolean(lParam) ? ISS_FORWARD : ISS_BACKWARD);	break;
	case CMDID_MOVE_LINEDOWN:			CmdMoveLineDown(false, lParam);		break;
	case CMDID_MOVE_LINEDOWNEXTEND:		CmdMoveLineDown(true, lParam);		break;
	case CMDID_MOVE_LINEEND:			CmdMoveLineEnd(false);				break;
	case CMDID_MOVE_LINEENDEXTEND:		CmdMoveLineEnd(true);				break;
	case CMDID_MOVE_LINEHOME:			CmdMoveLineHome(false);				break;
	case CMDID_MOVE_LINEHOMEEXTEND:		CmdMoveLineHome(true);				break;
	case CMDID_MOVE_LINEUP:				CmdMoveLineUp(false, lParam);		break;
	case CMDID_MOVE_LINEUPEXTEND:		CmdMoveLineUp(true, lParam);		break;
	case CMDID_MOVE_MATCHBRACKET:		CmdMoveMatchBracket(false);			break;
	case CMDID_MOVE_MATCHBRACKETEXTEND:	CmdMoveMatchBracket(true);			break;
	case CMDID_MOVE_PAGEDOWN:			CmdMovePageDown(false, lParam);		break;
	case CMDID_MOVE_PAGEDOWNEXTEND:		CmdMovePageDown(true, lParam);		break;
	case CMDID_MOVE_PAGEUP:				CmdMovePageUp(false, lParam);		break;
	case CMDID_MOVE_PAGEUPEXTEND:		CmdMovePageUp(true, lParam);		break;
	case CMDID_MOVE_ROWCHARNEXT:		CmdMoveRowCharNext();				break;
	case CMDID_MOVE_ROWCHARPREV:		CmdMoveRowCharPrev();				break;
	case CMDID_MOVE_ROWLINEDOWN:		CmdMoveRowLineDown();				break;
	case CMDID_MOVE_ROWLINEEND:			CmdMoveRowLineEnd();				break;
	case CMDID_MOVE_ROWLINEHOME:		CmdMoveRowLineHome();				break;
	case CMDID_MOVE_ROWLINEUP:			CmdMoveRowLineUp();					break;
	case CMDID_MOVE_ROWWORDENDNEXT:		CmdMoveRowWordEndNext();			break;
	case CMDID_MOVE_ROWWORDENDPREV:		CmdMoveRowWordEndPrev();			break;
	case CMDID_MOVE_ROWWORDNEXT:		CmdMoveRowWordNext();				break;
	case CMDID_MOVE_ROWWORDPREV:		CmdMoveRowWordPrev();				break;
	case CMDID_MOVE_SELECTALL:			CmdMoveSelectAll();					break;
	case CMDID_MOVE_SELECTCURRENTWORD:	CmdMoveSelectCurrentWord();			break;
	case CMDID_MOVE_WORDENDNEXT:		CmdMoveWordEndNext(false, lParam);	break;
	case CMDID_MOVE_WORDENDNEXTEXTEND:	CmdMoveWordEndNext(true, lParam);	break;
	case CMDID_MOVE_WORDENDPREV:		CmdMoveWordEndPrev(false, lParam);	break;
	case CMDID_MOVE_WORDENDPREVEXTEND:	CmdMoveWordEndPrev(true, lParam);	break;
	case CMDID_MOVE_WORDNEXT:			CmdMoveWordNext(false, lParam);		break;
	case CMDID_MOVE_WORDNEXTEXTEND:		CmdMoveWordNext(true, lParam);		break;
	case CMDID_MOVE_WORDPREV:			CmdMoveWordPrev(false, lParam);		break;
	case CMDID_MOVE_WORDPREVEXTEND:		CmdMoveWordPrev(true, lParam);		break;
		// ҏW
	case CMDID_EDIT_BACKSPACE:				CmdEditBackspace();							break;
	case CMDID_EDIT_BREAK:					CmdEditBreak();								break;
	case CMDID_EDIT_CHAR:					CmdEditChar(static_cast<CodePoint>(lParam));break;
	case CMDID_EDIT_CHARABOVELINE:			CmdEditCharAnotherLine(false);				break;
	case CMDID_EDIT_CHARBELOWLINE:			CmdEditCharAnotherLine(true);				break;
	case CMDID_EDIT_COPY:					CmdEditCopy(toBoolean(lParam));				break;
	case CMDID_EDIT_CUT:					CmdEditCut(toBoolean(lParam));				break;
	case CMDID_EDIT_DELETE:					CmdEditDelete();							break;
	case CMDID_EDIT_DELETELINE:				CmdEditDeleteLine();						break;
	case CMDID_EDIT_DELETETONEXTWORD:		CmdEditDeleteToNextWord();					break;
	case CMDID_EDIT_DELETETOPREVWORD:		CmdEditDeleteToPrevWord();					break;
	case CMDID_EDIT_INSERTPREVLINE:			CmdEditInsertPrevLine();					break;
	case CMDID_EDIT_MAKESELCAPITAL:			CmdEditConvertSel(SCT_CAPITALIZE);			break;
	case CMDID_EDIT_MAKESELLOWER:			CmdEditConvertSel(SCT_LOWERCASE);			break;
	case CMDID_EDIT_MAKESELUPPER:			CmdEditConvertSel(SCT_UPPERCASE);			break;
	case CMDID_EDIT_OPENCANDIDATEWINDOW:	CmdEditOpenCandidateWindow();				break;
	case CMDID_EDIT_PASTE:					CmdEditPaste();								break;
	case CMDID_EDIT_PASTEFROMCLIPBOARDRING:	CmdEditPasteFromClipboardRing();			break;
	case CMDID_EDIT_RECOMPOSESELECTION:		CmdEditRecomposeSelection();				break;
	case CMDID_EDIT_REDO:					CmdEditRedo();								break;
	case CMDID_EDIT_SETNEXTINPUTCONVERT:	CmdEditSetNextInputConvert(static_cast<NextCharConvert>(lParam));	break;
	case CMDID_EDIT_SPACEINDENT:			CmdEditSpaceIndent(false);					break;
	case CMDID_EDIT_SPACEUNINDENT:			CmdEditSpaceIndent(true);					break;
	case CMDID_EDIT_TABIFY:					CmdEditTabify(false);						break;
	case CMDID_EDIT_TABINDENT:				CmdEditTabIndent(false);					break;
	case CMDID_EDIT_TABUNINDENT:			CmdEditTabIndent(true);						break;
	case CMDID_EDIT_TEXT:					CmdEditText(reinterpret_cast<const wchar_t*>(lParam));	break;
	case CMDID_EDIT_CHARTOCODEPOINT:		CmdEditCharToCodePoint();					break;
	case CMDID_EDIT_CODEPOINTTOCHAR:		CmdEditCodePointToChar();					break;
	case CMDID_EDIT_TRANSPOSECHARS:			CmdEditTransposeChars();					break;
	case CMDID_EDIT_TRANSPOSELINES:			CmdEditTransposeLines();					break;
	case CMDID_EDIT_TRANSPOSEWORDS:			CmdEditTransposeWords();					break;
	case CMDID_EDIT_TOGGLEIMESTATUS:		CmdEditToggleIMEStatus();					break;
	case CMDID_EDIT_TOGGLEOVERTYPEMODE:		CmdEditToggleOvertypeMode();				break;
	case CMDID_EDIT_UNDO:					CmdEditUndo();								break;
	case CMDID_EDIT_UNTABIFY:				CmdEditTabify(true);						break;
		// XN[
	case CMDID_SCROLL_COLUMNNEXT:			CmdScrollColumnNext();			break;
	case CMDID_SCROLL_COLUMNPREV:			CmdScrollColumnPrev();			break;
	case CMDID_SCROLL_END:					CmdScrollEnd();					break;
	case CMDID_SCROLL_ENSURECARETCENTERED:	CmdScrollEnsureCaretCentered();	break;
	case CMDID_SCROLL_ENSURECARETVISIBLE:	CmdScrollEnsureCaretVisible();	break;
	case CMDID_SCROLL_HOME:					CmdScrollHome();				break;
	case CMDID_SCROLL_LINEDOWN:				CmdScrollLineDown();			break;
	case CMDID_SCROLL_LINEUP:				CmdScrollLineUp();				break;
	case CMDID_SCROLL_PAGEDOWN:				CmdScrollPageDown();			break;
	case CMDID_SCROLL_PAGEUP:				CmdScrollPageUp();				break;
	}
}

///	LbgO̒PZkƂēWJ
void CEditView::ExpandPrecedingWordAsAbbreviation() {
	if(!m_modeState.bReadyToExpandAbbrev)
		return;

	// [Shift] L[ĂƓWJ}~ł
	if(!toBoolean(::GetAsyncKeyState(VK_SHIFT) & 0x8000)) {
		const string_t	strAbbrev = GetPrecedingWord(CEditView::m_cchMaxAbbreviation);
		map<string_t, string_t>::const_iterator	it = CEditView::m_mapAbbreviations.find(strAbbrev);
		if(it != CEditView::m_mapAbbreviations.end()) {
			GetDocument()->BeginEditCollection();
			// ̃LXg͑S낤
			m_pActivePoint->Delete(-static_cast<signed_length_t>(strAbbrev.length()), UB_UTF16);
			m_pActivePoint->Insert(it->second);
			GetDocument()->EndEditCollection();
		}
	}
	m_modeState.bReadyToExpandAbbrev = false;
	for(set<IEditViewEventListener*>::iterator it =
			m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
}

/**
 *	@brief	ΊʂTB<var>pos</var> ɊʂΏ false Ԃ
 *
 *	̃\bh͒1̃g[NׂȂ
 *
 *	@param pos			ʂ̈ʒu
 *	@param posFound		Ίʂ̈ʒu
 *	@param bRequireBody	Ή銇ʑ΂̊ԂɁA
 *						󔒗ޕȊÕg[NꍇɌȂƂɂꍇ true
 *	@return				Ƃ^
 */
bool CEditView::FindBracket(const CCharPos& pos, CCharPos& posFound, bool bRequireBody) const {
	AssertValid();

	const string_t&	strCurrentLine = GetDocument()->GetLine(pos.m_iLine);
	length_t		cchLine = strCurrentLine.length();

	if(pos.m_iChar >= cchLine)
		return false;

	char_t	wchBrace = strCurrentLine.at(pos.m_iChar), wchMatch;	// ʂƑΊ
	bool	bBackward;												// ʂT

	if(!GetLexer()->GetBracketTraits(wchBrace, wchMatch, bBackward))
		return false;
	bBackward = !bBackward;

	const CEditDoc*		pDocument = GetDocument();
	length_t			iLine = pos.m_iLine;
	length_t			iChar = !bBackward ? pos.m_iChar + 1 : pos.m_iChar - 1;
	const CLineLayout*	pLineInfo = 0;
	const CTokenLayout*	pToken;
	unsigned long		nNest = 0;								// qx
	length_t			cSearchedLines = 0;						// s
	bool				bFoundRatherThanSpace = !bRequireBody;	// ʂƋ󔒗ޕȊÕg[N
																// xłǂݔ΂

	while(true) {	// _s[v
		const string_t&	strLine = pDocument->GetLine(iLine);
		cchLine = strLine.length();

		if(cchLine != 0) {
			pLineInfo = m_pLineLayoutManager->GetLine(iLine);

			CTokenLayout** const	ppTokens = pLineInfo->GetTokenList();
			size_t					iToken = !bBackward ? 0 : pLineInfo->GetTokenCount() - 1;
			if(cSearchedLines == 0) {
				for(iToken = 0; iToken < pLineInfo->GetTokenCount() - 1; ++iToken) {
					if(ppTokens[iToken]->GetIndex() == pos.m_iChar)
						break;
				}
			}

			while(true) {	// ʂT
				pToken = ppTokens[iToken];
				const length_t	cchToken = (iToken != pLineInfo->GetTokenCount() - 1) ?
									ppTokens[iToken + 1]->GetIndex() - ppTokens[iToken]->GetIndex()
									: cchLine - ppTokens[iToken]->GetIndex();
				if(cchToken == 1
						&& pToken->GetType() != TT_ANNOTATION
						&& pToken->GetType() != TT_DOUBLEQUOTATION
						&& pToken->GetType() != TT_SINGLEQUOTATION) {
					if(strLine[pToken->GetIndex()] == wchBrace)
						++nNest;
					else if(strLine[pToken->GetIndex()] == wchMatch && --nNest == 0) {
						if(bFoundRatherThanSpace) {
							posFound = CCharPos(iLine, pToken->GetIndex());
							return true;
						} else
							return false;
					} else if(pToken->GetType() != TT_TAB && pToken->GetType() != TT_WHITESPACE)
						bFoundRatherThanSpace = true;
				} else if(pToken->GetType() != TT_TAB && pToken->GetType() != TT_WHITESPACE)
					bFoundRatherThanSpace = true;
				if((!bBackward && iToken == pLineInfo->GetTokenCount() - 1)
						|| (bBackward && iToken == 0))
					break;
				iToken += !bBackward ? 1 : -1;
			}
		}

		if(++cSearchedLines >= m_modeState.cFindLimit)
			return false;
		if((bBackward && iLine == 0) || (!bBackward && iLine == pDocument->GetLineCount() - 1))
			return false;
		iLine += !bBackward ? 1 : -1;
	}

	return false;
}

/**
 *	݂̑I͈͏I_/n_當A
 *	IԂɂBȂΉȂB
 *	̐ۂɊւ炸AveLXg̋\LɂȂ
 *	@return	 true
 *	@throw EFailedToLoadRegExpEngine	K\ɃCupӂłȂꍇX[
 *	@throw ERegExpPatternIsInvalid		K\Ƀp^[Ȃ΃X[
 *	@see	CEditView::RevokeSearchMarks
 */
bool CEditView::FindNext() throw(EFailedToLoadRegExpEngine, ERegExpPatternIsInvalid) {
	AssertValidAsWindow();
	CWaitCursor();

	const SearchFlag	sfFlags = CEditView::m_oTextSearcher.GetFlags();
	const CEditDoc*		pDocument = GetDocument();
	CCharPos			posBegin = toBoolean(sfFlags & SF_BACKWARD) ?
									GetSelTopPoint() : GetSelBottomPoint();	// ŏ̍šJn_
	const length_t		iEndLine = toBoolean(sfFlags & SF_BACKWARD) ?
									0 : pDocument->GetLineCount() - 1;	// Is
	length_t			iFound, cchFound;

	for(length_t iLine = posBegin.m_iLine; ; iLine += (toBoolean(sfFlags & SF_BACKWARD) ? -1 : 1)) {
		if(iLine != posBegin.m_iLine)
			posBegin.m_iChar = toBoolean(sfFlags & SF_BACKWARD) ? -1 : 0;
		try {
			if(CEditView::m_oTextSearcher.Search(
					pDocument->GetLine(iLine), posBegin.m_iChar, iFound, cchFound, *m_pBoundarySearcher)) {
				SetSel(CCharPos(iLine, iFound), CCharPos(iLine, iFound + cchFound));
				return true;
			}
		} catch(EFailedToLoadRegExpEngine& /* e */) {
			throw;
		} catch(ERegExpPatternIsInvalid& /* e */) {
			throw;
		}
		if(iLine == iEndLine)
			break;
		posBegin.m_iChar = toBoolean(sfFlags & SF_BACKWARD) ? pDocument->GetLineLength(iLine - 1) : 0;
	}
	if(!m_modeState.bHighlightSearchText) {	// \L
		m_modeState.bHighlightSearchText = true;
		if(IsWindowVisible() && m_pTokenFoundations->arrEnabled[ETT_MATCHTEXT])
			InvalidateRect(0);
	}

	return false;
}

///	`̃t[Y
void CEditView::Freeze() {
	AssertValidAsWindow();

	++m_pOriginalView->m_nFreezeCount;
	for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
		++(*it)->m_nFreezeCount;
}

///	ANeBu|CgԂ
CCharPos CEditView::GetActivePoint() const {
	AssertValid();
	return *m_pActivePoint;
}

/**
 *	Ss̃AvP[V`lXgɂĎ擾
 *	@param listLines	XgBl0̍s͊O
 */
void CEditView::GetAllLineParams(list<TAppDefinedLine>& listLines) const {
	AssertValid();

	const length_t	cLines = GetDocument()->GetLineCount();
	TAppDefinedLine	line;

	listLines.clear();
	for(length_t iLine = 0; iLine < cLines; ++iLine) {
		DWORD	dwParam = m_pLineLayoutManager->GetLine(iLine)->GetUserDefinedValue();
		if(dwParam != 0) {
			line.iLine = iLine;
			line.dwParam = dwParam;
			listLines.push_back(line);
		}
	}
}

///	AJ[|CgԂ
CCharPos CEditView::GetAnchorPoint() const {
	AssertValid();
	return *m_pAnchorPoint;
}

/**
 *	ubN}[ÑXgԂ
 *	@param listLines	ubN}[NĂsԍ̃Xg
 */
void CEditView::GetBookmarkList(list<length_t>& listLines) const {
	AssertValid();

	length_t	cLines = GetDocument()->GetLineCount();

	listLines.clear();
	for(length_t iLine = 0; iLine < cLines; ++iLine) {
		if(m_pLineLayoutManager->GetLine(iLine)->IsBookmarked())
			listLines.push_back(iLine);
	}
}

///	\sԂ
length_t CEditView::GetDisplayLineCount() const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return GetDocument()->GetLineCount();
/*
	length_t			cDisplayLines = 0;
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
	while(pInfo != 0) {
		cDisplayLines += pInfo->m_vecWrappedOffsets.size() + 1;
		pInfo = pInfo->m_pNext;
	}
	return cDisplayLines;*/
}

/**
 *	\s_ŝǂ̃ItZbgɑ邩Ԃ
 *	@param iDisplayLine	\s
 *	@param iLogicalLine	_s (iDisplayLine ȏꍇ-1)
 *	@param iOffset		_sŉԖڂ̕\s (iDisplayLine ȏꍇ-1)
 */
void CEditView::GetDisplayLineOffsetIndex(
		length_t iDisplayLine, length_t& iLogicalLine, length_t& iOffset) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE) {
		iLogicalLine = iDisplayLine;
		iOffset = 0;
/*		return;
	} else {
		CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);
		length_t			iTotalDisplayLine = 0;

		iLogicalLine = 0;
		while(pInfo != 0) {
			if(iTotalDisplayLine + pInfo->m_vecWrappedOffsets.size() + 1 > iDisplayLine) {
				iOffset = iDisplayLine - iTotalDisplayLine;
				return;
			}
			iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
			pInfo = pInfo->m_pNext;
			++iLogicalLine;
		}
	}
	iLogicalLine = iOffset = -1;*/
}

/**
 *	hLgIuWFNg̎擾
 *	@return	hLgIuWFNg
 */
CEditDoc* CEditView::GetDocument() const {
	AssertValid();
	return reinterpret_cast<CEditDoc*>(m_pDocument);
}

/**
 *	w肵s̃AvP[V`l擾
 *	@param iLine	_s
 *	@return			s̃AvP[V`l (擾Ɏsꍇ0Ԃ)
 */
DWORD CEditView::GetLineParam(length_t iLine) const {
	AssertValid();

	CLineLayout*	pLineInfo = m_pLineLayoutManager->GetLine(iLine);
	return (pLineInfo != 0) ? pLineInfo->GetUserDefinedValue() : 0;
}

/**
 *	Lbgt߂ɂPԂB
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	PꂪȂꍇAIꍇ͋󕶎Ԃ
 *	@see	GetNearestWordFromCursor, GetPrecedingWord
 */
string_t CEditView::GetNearestWordFromCaret() const {
	AssertValid();

	if(HasSelection())
		return L"";

	CLexer*			pLexer = m_pLineLayoutManager->GetLexer();
	length_t		iStart, iEnd;
	const string_t&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
	const char_t*	pszLine = strLine.c_str();
	length_t		cchLine = strLine.length();
	CodePoint		nCodePoint;

	iStart = iEnd = m_pActivePoint->m_iChar;

	// Jnʒu𒲂ׂ
	while(iStart > 0) {
		if(IsUTF16LowSurrogate(pszLine[iStart - 1])
				&& iStart > 1
				&& IsUTF16HighSurrogate(pszLine[iStart - 2]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pszLine + iStart - 2, 2);
		else
			nCodePoint = pszLine[iStart - 1];
		if(pLexer->IsIdentifierContinueCodePoint(nCodePoint))
			iStart -= ((nCodePoint >= 0x010000) ? 2 : 1);
		else
			break;
	}

	// Iʒu𒲂ׂ
	while(true) {
		if(IsUTF16HighSurrogate(pszLine[iEnd])
				&& iEnd < cchLine - 1
				&& IsUTF16LowSurrogate(pszLine[iEnd + 1]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pszLine + iEnd, 2);
		else
			nCodePoint = pszLine[iEnd];
		if(pLexer->IsIdentifierContinueCodePoint(nCodePoint))
			iEnd += ((nCodePoint >= 0x010000) ? 2 : 1);
		else
			break;
	}

	return strLine.substr(iStart, iEnd - iStart);
}

/**
 *	J[\t߂ɂPԂB
 *	Ԃ镶ɂĂ CEditView::GetNearestWordFromCaret 
 *	@see	GetNearestWordFromCaret, GetPrecedingWord
 */
string_t CEditView::GetNearestWordFromCursor() const {
	AssertValidAsWindow();

	CCharPos	posAnchorOrg = *m_pAnchorPoint;
	CCharPos	posActiveOrg = *m_pActivePoint;
	CCharPos	posCursor;
	POINT		ptCursor;
	string_t	strWord;

	::GetCursorPos(&ptCursor);
	ScreenToClient(&ptCursor);
	posCursor = CharFromPos(ptCursor, false);
	const_cast<CEditView*>(this)->m_pAnchorPoint->MoveToPoint(posCursor);
	const_cast<CEditView*>(this)->m_pActivePoint->MoveToPoint(posCursor);
	strWord = GetNearestWordFromCaret();
	const_cast<CEditView*>(this)->m_pAnchorPoint->MoveToPoint(posAnchorOrg);
	const_cast<CEditView*>(this)->m_pActivePoint->MoveToPoint(posActiveOrg);

	return strWord;
}

/**
 *	Lbg̒OɂPԂB
 *	̃\bh͐ݒ肳Ă鎯ʎq̉e󂯁A
 *	Ԃ镶͎ʎq2ڈȍ~ƂėLȕ݂̂ȂB
 *	PꂪȂꍇAIꍇA
 *	͒Pꂪw肵ō𒴂ꍇ͋󕶎Ԃ
 *	@see	GetNearestWordFromCaret, GetNearestWordFromCursor
 */
string_t CEditView::GetPrecedingWord(length_t cchLimit) const {
	AssertValid();

	if(HasSelection() || m_pActivePoint->m_iChar == 0)
		return L"";
	length_t		iChar = m_pActivePoint->m_iChar;
	const string_t&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
	const char_t*	pwszLine = strLine.c_str();
	CodePoint		cp;
	const CLexer*	pLexer = m_pLineLayoutManager->GetLexer();

	while(iChar != 0) {
		if(m_pActivePoint->m_iChar - iChar + 1 > cchLimit)
			return L"";
		if(IsUTF16LowSurrogate(pwszLine[iChar - 1])
				&& iChar > 1
				&& IsUTF16HighSurrogate(pwszLine[iChar - 2]))
			cp = DecodeUTF16SurrogatePairToCodePoint(pwszLine + iChar - 2, 2);
		else
			cp = pwszLine[iChar - 1];
		if(pLexer->IsIdentifierContinueCodePoint(cp))
			iChar -= ((cp >= 0x010000) ? 2 : 1);
		else
			break;
	}
	return strLine.substr(iChar, m_pActivePoint->m_iChar - iChar);
}

/**
 *	I͈͂⌻݈ʒu̎擾
 *	@param posAnchor	IJnʒu
 *	@param posActive	IIʒu
 */
void CEditView::GetSel(CCharPos& posAnchor, CCharPos& posActive) const {
	AssertValid();
	posAnchor = *m_pAnchorPoint;
	posActive = *m_pActivePoint;
}

///	I͈̖͂Ԃ
const CVisibleEditPoint& CEditView::GetSelBottomPoint() const {
	AssertValid();
	return max(*m_pAnchorPoint, *m_pActivePoint);
}

///	I͈͂̐擪Ԃ
const CVisibleEditPoint& CEditView::GetSelTopPoint() const {
	AssertValid();
	return min(*m_pAnchorPoint, *m_pActivePoint);
}

/**
 *	I͈͂̎̕擾
 *	@return	I͈͂̕
 */
string_t CEditView::GetSelection() const {
	AssertValid();

	if(!HasSelection())
		return L"";

	wostringstream	ssSelection;
	CEditDoc*		pDoc = GetDocument();
	CCharPos		posTop = GetSelTopPoint();
	CCharPos		posBottom = GetSelBottomPoint();
	length_t		iLine = posTop.m_iLine;
	LineIterator	itLines;

	if(!toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {	// `IłȂꍇ
		if(posTop.m_iLine == posBottom.m_iLine)	// I1s̏ꍇ
			return pDoc->GetLine(posTop.m_iLine).substr(posTop.m_iChar, posBottom.m_iChar - posTop.m_iChar);
		else {								// I2sȏ̏ꍇ
			itLines = pDoc->GetLineIterator(iLine);
			while(true) {	// I𒆂̊es1̕ɂȂ
				if(iLine == posTop.m_iLine)		// IJns
					ssSelection << itLines->GetLine().substr(posTop.m_iChar);
				else if(iLine == posBottom.m_iLine) {	// IIs
					ssSelection << itLines->GetLine().substr(0, posBottom.m_iChar);
					break;
				} else
					ssSelection << pDoc->GetLine(iLine);
				ssSelection << CEditDoc::GetBreakString(itLines->GetBreakType());
				++iLine;
				++itLines;
			}
		}
	} else {	// `Ȉꍇ
		const unsigned long	xLeft = min(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive);
		const unsigned long	xRight = max(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive);
		length_t		iBegin;

		itLines = pDoc->GetLineIterator(iLine);
		while(true) {
			iBegin = CharFromPixel(iLine, xLeft, !m_modeState.bCaretExtenderByMouse);
			ssSelection << itLines->GetLine().substr(
				iBegin, CharFromPixel(iLine, xRight, !m_modeState.bCaretExtenderByMouse) - iBegin);
			ssSelection << CEditDoc::GetBreakString(itLines->GetBreakType());
			if(iLine == posBottom.m_iLine)
				break;
			++iLine;
			++itLines;
		}
	}

	return ssSelection.str();
}

///	@see	IDropSource::GiveFeedback
STDMETHODIMP CEditView::GiveFeedback(DWORD dwEffect) {
	AssertValid();
	return DRAGDROP_S_USEDEFAULTCURSORS;	// VXẽftHg̃J[\g 
}

/**
 *	w肵sɃubN}[Nݒ肳Ă邩ǂԂ
 *	@param iLine	ׂs
 */
bool CEditView::HasBookmarkAt(length_t iLine) const throw(out_of_range) {
	AssertValid();
	CLineLayout*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	return pInfo->IsBookmarked();
}

/**
 *	I͈͂邩ǂԂ
 *	@return	I͈͂Ȃ true
 */
bool CEditView::HasSelection() const {
	AssertValid();
	return *m_pAnchorPoint != *m_pActivePoint;
}

///	\̃c[`bv\ɂ
void CEditView::HideToolTip() {
	AssertValidAsWindow();

	if(m_pwszTipText == 0)
		m_pwszTipText = new char_t[1];
	wcscpy(m_pwszTipText, L"");
	KillTimer(TIMERID_CALLTIP);	// Ô...
	::SendMessageW(m_hwndToolTip, TTM_UPDATE, 0, 0L);
}

/**
 *	EBhȄ
 *	@param bCopyConstructing	r[Ăяoꍇ true
 */
void CEditView::InitializeWindow(bool bCopyConstructing) {
	AssertValidAsWindow();

	// WReLXgj[̍쐬BAscension ł
	// GUI ŃeLXggȂB{ȊOɂΉĂ݂
	// pȊOɖ|󂵂ĂlW (^^
	if(!bCopyConstructing) {
		MENUITEMINFOW	mii;
		HMENU			hSubMenu;
		const bool		bJapanese = ::GetUserDefaultLangID() == 0x0411;

		m_hContextMenu = ::CreatePopupMenu();
		ZeroMemory(&mii, sizeof(MENUITEMINFOW));
		mii.cbSize = sizeof(MENUITEMINFOW);
		mii.fMask = MIIM_FTYPE | MIIM_ID | MIIM_STRING;

		mii.wID = WM_UNDO, mii.dwTypeData = bJapanese ? L"ɖ߂(&U)" : L"&Undo";
		::InsertMenuItemW(m_hContextMenu, 0, true, &mii);
		mii.wID = WM_REDO, mii.dwTypeData = bJapanese ? L"蒼(&R)" : L"&Redo";
		::InsertMenuItemW(m_hContextMenu, 1, true, &mii);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_hContextMenu, 2, true, &mii);

		mii.fType = 0;
		mii.wID = WM_CUT, mii.dwTypeData = bJapanese ? L"؂(&T)" : L"Cu&t";
		::InsertMenuItemW(m_hContextMenu, 3, true, &mii);
		mii.wID = WM_COPY, mii.dwTypeData = bJapanese ? L"Rs[(&C)" : L"&Copy";
		::InsertMenuItemW(m_hContextMenu, 4, true, &mii);
		mii.wID = WM_PASTE, mii.dwTypeData = bJapanese ? L"\t(&P)" : L"&Paste";
		::InsertMenuItemW(m_hContextMenu, 5, true, &mii);
		mii.wID = WM_CLEAR, mii.dwTypeData = bJapanese ? L"폜(&D)" : L"&Delete";
		::InsertMenuItemW(m_hContextMenu, 6, true, &mii);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_hContextMenu, 7, true, &mii);

		mii.fType = 0;
		mii.wID = WM_SELECTALL, mii.dwTypeData = bJapanese ? L"ׂđI(&A)" : L"Select &All";
		::InsertMenuItemW(m_hContextMenu, 8, true, &mii);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(m_hContextMenu, 9, true, &mii);

		mii.fType = 0;
		mii.wID = ID_SHOWRTL, mii.dwTypeData = bJapanese ? L"E獶ɓǂ(&R)" : L"&Read right to left";
		::InsertMenuItemW(m_hContextMenu, 10, true, &mii);
		mii.wID = ID_SHOWUNICODECONTROLCHARS, mii.dwTypeData = bJapanese ? L"Unicode 䕶̕\(&S)" : L"&Show Unicode Controls";
		::InsertMenuItemW(m_hContextMenu, 11, true, &mii);
		mii.wID = 0, mii.dwTypeData = bJapanese ? L"Unicode 䕶̑}(&I)" : L"&Insert Unicode Controls";
		::InsertMenuItemW(m_hContextMenu, 12, true, &mii);
		mii.wID = 0, mii.dwTypeData = bJapanese ? L"Unicode 󔒕̑}(&W)" : L"Insert Unicode &Whitespace";
		::InsertMenuItemW(m_hContextMenu, 13, true, &mii);
		
		if(toBoolean(::ImmIsIME(::GetKeyboardLayout(::GetCurrentThreadId())))) {
			mii.fType = MFT_SEPARATOR;
			::InsertMenuItemW(m_hContextMenu, 14, true, &mii);
			mii.fType = 0;
			mii.wID = ID_TOGGLEIMESTATUS, mii.dwTypeData = bJapanese ? L"IME J(&O)" : L"&Open IME";
			::InsertMenuItemW(m_hContextMenu, 15, true, &mii);
			mii.wID = ID_RECOMPOSITIONIME, mii.dwTypeData = bJapanese ? L"ĕϊ(&R)" : L"&Recompose";
			::InsertMenuItemW(m_hContextMenu, 16, true, &mii);
		}

		// [Unicode 䕶̑}] ȉ
		hSubMenu = ::CreatePopupMenu();
		mii.wID = ID_INSERT_LRM, mii.dwTypeData = L"LRM\tLeft-To-Right Mark";
		::InsertMenuItemW(hSubMenu, 0, true, &mii);
		mii.wID = ID_INSERT_RLM, mii.dwTypeData = L"RLM\tRight-To-Left Mark";
		::InsertMenuItemW(hSubMenu, 1, true, &mii);
		mii.wID = ID_INSERT_ZWJ, mii.dwTypeData = L"ZWJ\tZero Width Joiner";
		::InsertMenuItemW(hSubMenu, 2, true, &mii);
		mii.wID = ID_INSERT_ZWNJ, mii.dwTypeData = L"ZWNJ\tZero Width Non-Joiner";
		::InsertMenuItemW(hSubMenu, 3, true, &mii);
		mii.wID = ID_INSERT_LRE, mii.dwTypeData = L"LRE\tLeft-To-Right Embedding";
		::InsertMenuItemW(hSubMenu, 4, true, &mii);
		mii.wID = ID_INSERT_RLE, mii.dwTypeData = L"RLE\tRight-To-Left Embedding";
		::InsertMenuItemW(hSubMenu, 5, true, &mii);
		mii.wID = ID_INSERT_LRO, mii.dwTypeData = L"LRO\tLeft-To-Right Override";
		::InsertMenuItemW(hSubMenu, 6, true, &mii);
		mii.wID = ID_INSERT_RLO, mii.dwTypeData = L"RLO\tRight-To-Left Override";
		::InsertMenuItemW(hSubMenu, 7, true, &mii);
		mii.wID = ID_INSERT_PDF, mii.dwTypeData = L"PDF\tPop Directional Formatting";
		::InsertMenuItemW(hSubMenu, 8, true, &mii);
		mii.wID = ID_INSERT_WJ, mii.dwTypeData = L"WJ\tWord Joiner";
		::InsertMenuItemW(hSubMenu, 9, true, &mii);
		mii.wID = ID_INSERT_U2061, mii.dwTypeData = L"U+2061\tFunction Application";
		::InsertMenuItemW(hSubMenu, 10, true, &mii);
		mii.wID = ID_INSERT_U2062, mii.dwTypeData = L"U+2062\tInvisible Times";
		::InsertMenuItemW(hSubMenu, 11, true, &mii);
		mii.wID = ID_INSERT_U2063, mii.dwTypeData = L"U+2063\tInvisible Separator";
		::InsertMenuItemW(hSubMenu, 12, true, &mii);
		mii.wID = ID_INSERT_RS, mii.dwTypeData = L"RS\tRecord Separator";
		::InsertMenuItemW(hSubMenu, 13, true, &mii);
		mii.wID = ID_INSERT_US, mii.dwTypeData = L"US\tUnit Separator";
		::InsertMenuItemW(hSubMenu, 14, true, &mii);
		mii.fMask = MIIM_SUBMENU;
		mii.hSubMenu = hSubMenu;
		::SetMenuItemInfo(m_hContextMenu, 12, true, &mii);

		// [Unicode 󔒕̑}] ȉ
		hSubMenu = ::CreatePopupMenu();
		mii.fMask = MIIM_FTYPE | MIIM_ID | MIIM_STRING;
		mii.wID = ID_INSERT_U0020, mii.dwTypeData = L"U+0020\tSpace";
		::InsertMenuItemW(hSubMenu, 0, true, &mii);
		mii.wID = ID_INSERT_NBSP, mii.dwTypeData = L"NBSP\tNo-Break Space";
		::InsertMenuItemW(hSubMenu, 1, true, &mii);
		mii.wID = ID_INSERT_U1680, mii.dwTypeData = L"U+1680\tOgham Space Mark";
		::InsertMenuItemW(hSubMenu, 2, true, &mii);
		mii.wID = ID_INSERT_MVS, mii.dwTypeData = L"MVS\tMongolian Vowel Separator";
		::InsertMenuItemW(hSubMenu, 3, true, &mii);
		mii.wID = ID_INSERT_U2000, mii.dwTypeData = L"U+2000\tEn Quad";
		::InsertMenuItemW(hSubMenu, 4, true, &mii);
		mii.wID = ID_INSERT_U2001, mii.dwTypeData = L"U+2001\tEm Quad";
		::InsertMenuItemW(hSubMenu, 5, true, &mii);
		mii.wID = ID_INSERT_U2002, mii.dwTypeData = L"U+2002\tEn Space";
		::InsertMenuItemW(hSubMenu, 6, true, &mii);
		mii.wID = ID_INSERT_U2003, mii.dwTypeData = L"U+2003\tEm Space";
		::InsertMenuItemW(hSubMenu, 7, true, &mii);
		mii.wID = ID_INSERT_U2004, mii.dwTypeData = L"U+2004\tThree-Per-Em Space";
		::InsertMenuItemW(hSubMenu, 8, true, &mii);
		mii.wID = ID_INSERT_U2005, mii.dwTypeData = L"U+2005\tFour-Per-Em Space";
		::InsertMenuItemW(hSubMenu, 9, true, &mii);
		mii.wID = ID_INSERT_U2006, mii.dwTypeData = L"U+2006\tSix-Per-Em Space";
		::InsertMenuItemW(hSubMenu, 10, true, &mii);
		mii.wID = ID_INSERT_U2007, mii.dwTypeData = L"U+2007\tFigure Space";
		::InsertMenuItemW(hSubMenu, 11, true, &mii);
		mii.wID = ID_INSERT_U2008, mii.dwTypeData = L"U+2008\tPunctuation Space";
		::InsertMenuItemW(hSubMenu, 12, true, &mii);
		mii.wID = ID_INSERT_U2009, mii.dwTypeData = L"U+2009\tThin Space";
		::InsertMenuItemW(hSubMenu, 13, true, &mii);
		mii.wID = ID_INSERT_U200A, mii.dwTypeData = L"U+200A\tHair Space";
		::InsertMenuItemW(hSubMenu, 14, true, &mii);
		mii.wID = ID_INSERT_ZWSP, mii.dwTypeData = L"ZWSP\tZero Width Space";
		::InsertMenuItemW(hSubMenu, 15, true, &mii);
		mii.wID = ID_INSERT_NNBSP, mii.dwTypeData = L"NNBSP\tNarrow No-Break Space";
		::InsertMenuItemW(hSubMenu, 16, true, &mii);
		mii.wID = ID_INSERT_MMSP, mii.dwTypeData = L"MMSP\tMedium Mathematical Space";
		::InsertMenuItemW(hSubMenu, 17, true, &mii);
		mii.wID = ID_INSERT_U3000, mii.dwTypeData = L"U+3000\tIdeographic Space";
		::InsertMenuItemW(hSubMenu, 18, true, &mii);
		mii.fType = MFT_SEPARATOR;
		::InsertMenuItemW(hSubMenu, 19, true, &mii);
		mii.fType = 0;
		mii.wID = ID_INSERT_NEL, mii.dwTypeData = L"NEL\tNext Line";
		::InsertMenuItemW(hSubMenu, 20, true, &mii);
		mii.wID = ID_INSERT_LS, mii.dwTypeData = L"LS\tLine Separator";
		::InsertMenuItemW(hSubMenu, 21, true, &mii);
		mii.wID = ID_INSERT_PS, mii.dwTypeData = L"PS\tParagraph Separator";
		::InsertMenuItemW(hSubMenu, 22, true, &mii);
		mii.fMask = MIIM_SUBMENU;
		mii.hSubMenu = hSubMenu;
		::SetMenuItemInfo(m_hContextMenu, 13, true, &mii);
	}

	// ݊foCXReLXg/ GDI IuWFNg̍쐬
	HDC	hDC = GetDC();
	m_gdiObjects.oMemDC.CreateCompatibleDC(hDC);
	ReleaseDC(hDC);
	UpdateGDIObjects();

	// c[`bv̍쐬
	m_hwndToolTip = ::CreateWindowExW(
		WS_EX_TOOLWINDOW | WS_EX_TOPMOST, TOOLTIPS_CLASSW, 0,
		WS_POPUP | TTS_ALWAYSTIP | TTS_NOPREFIX,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		m_hWnd, 0, reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE)), 0);
	if(m_hwndToolTip != 0) {
		TOOLINFOW	ti;
		RECT		rectMargins = {1, 1, 1, 1};

		ZeroMemory(&ti, sizeof(TOOLINFOW));
		ti.cbSize = sizeof(TOOLINFOW);
		ti.hinst = reinterpret_cast<HINSTANCE>(GetWindowLong(GWL_HINSTANCE));
		ti.hwnd = m_hWnd;
		ti.lpszText = LPSTR_TEXTCALLBACKW;
		ti.uFlags = TTF_SUBCLASS;
		ti.uId = 1;
		::SetRect(&ti.rect, 0, 0, 0, 0);
		::SendMessageW(m_hwndToolTip, TTM_ADDTOOL, 0, reinterpret_cast<LPARAM>(&ti));
		::SendMessageW(m_hwndToolTip, TTM_SETDELAYTIME, TTDT_AUTOPOP, 30000);	// 30bԕ\悤
//		::SendMessageW(m_hwndToolTip, TTM_SETDELAYTIME, TTDT_INITIAL, 1500);
		::SendMessageW(m_hwndToolTip, TTM_SETMARGIN, 0, reinterpret_cast<LPARAM>(&rectMargins));
		::SendMessageW(m_hwndToolTip, TTM_ACTIVATE, true, 0L);
	}

	// ͌EBhE̍쐬
	m_pwndAutoComplete->Create();
	
	// hbvΏۂɓo^
	RegisterDragDrop(this);

	// CAEg
	if(!bCopyConstructing) {
		// hLg΍s𓯊
		const LOGFONTW	lf = {
			0, 0, 0, 0, FW_NORMAL, false, false, false,
			ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
			FIXED_PITCH | FF_DONTCARE, L"FixedSys"
		};
		if(m_pDocument != 0)
			m_pLineLayoutManager->ReconstructAll();
		ModifyFontInfo(lf, false);
	}
}

/**
 *	݈ʒuɕ}BݑIĂu͍sȂ
 *	@param strText	}eLXg
 *	@see			DeleteSel, ReplaceSel, InsertBoxText
 */
void CEditView::InsertText(const string_t& strText) {
	AssertValidAsWindow();

	if(GetDocument()->IsReadOnly())
		return;
	m_modeState.selectionTraits = ST_NORMAL;
	GetDocument()->InsertText(this, *m_pActivePoint, strText);
	m_nccNextCharConvert = NCC_NONE;	// ɖ߂

	if(m_pKeyMacroPlayer->GetState() != KMS_PLAYING) {
		for(set<IEditViewEventListener*>::iterator it
				= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
			(*it)->OnMoveCaret(*m_pActivePoint);
	}
}

/**
 *	wԍs`𖳌
 *	@param iLine	_s
 */
void CEditView::InvalidateLine(length_t iLine) {
	InvalidateLines(iLine, iLine);
}

/**
 *	ws`𖳌Bsw͂_sB<var>iStart</var>
 *	 <var>iEnd</var> ̑召֌Wɐ͖
 *	@param iStart	Jns
 *	@param iEnd		Is
 */
void CEditView::InvalidateLines(length_t iStart, length_t iEnd) {
	AssertValidAsWindow();

	const length_t	cVisibleLines = GetVisibleLineCount();

	if(iStart > iEnd)
		std::swap(iStart, iEnd);
	if(iEnd > m_ptScroll.y + cVisibleLines)
		iEnd = m_ptScroll.y + cVisibleLines;

	if(IsFreezed()) {	// 
		for(length_t i = iStart; i <= iEnd; ++i)
			m_setInvalidLines.insert(i);
		return;
	}

	RECT			rectInvalid;
	length_t		iDisplayStart, iDisplayEnd;
	const length_t	cLines = GetDocument()->GetLineCount();

	// \sɕϊ
	if(iStart > iEnd)
		std::swap(iStart, iEnd);
	iDisplayStart = DisplayLineFromLogicalLine(min(iStart, cLines - 1));
	if(iStart >= cLines)
		iDisplayStart += iStart - cLines + 1;
	iDisplayEnd = DisplayLineFromLogicalLine(min(iEnd, cLines - 1));
	if(iEnd >= cLines)
		iDisplayEnd += iEnd - cLines + 1;
	GetClientRect(&rectInvalid);

	// [
	if(iDisplayStart > m_ptScroll.y + cVisibleLines)
		return;
	rectInvalid.top += m_layoutInfo.nTopMargin;
	if(static_cast<long>(iDisplayStart) > m_ptScroll.y)
		rectInvalid.top += (iDisplayStart - m_ptScroll.y) * m_layoutInfo.nLineHeight;

	// [
	rectInvalid.bottom = rectInvalid.top + (iDisplayEnd - iDisplayStart + 1) * m_layoutInfo.nLineHeight;

	InvalidateRect(&rectInvalid, false);
}

/**
 *	񂪃[AhX𒲂ׂ
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		񂪃[AhXł΂̒BȊȌꍇ0
 */
length_t CEditView::IsMailAddress(const char_t* psz, length_t cch) {
	// ̃\bh "/[\w\d][\w\d\.\-_]*@[\w\d\-_]+(\.[\w\d\-_]+)+/" ̂悤ȃp^[}b`s
#define IS_ALNUM(ch)					\
	(((ch) >= L'A' && (ch) <= L'Z')		\
	|| ((ch) >= L'a' && (ch) <= L'z')	\
	|| ((ch) >= L'0' && (ch) <= L'9'))
#define IS_ALNUMBAR(ch)	\
	(IS_ALNUM(ch) || ch == L'-' || ch == L'_')

	assert(psz != 0);

	if(cch < 5)
		return 0;

	// 1
	if(!IS_ALNUM(psz[0]))	return 0;

	// 2ڂ '@'
	length_t	i = 1;
	for(; i < cch - 3; ++i) {
		if(!IS_ALNUMBAR(psz[i]) && psz[i] != L'.')
			break;
	}
	if(psz[i] != L'@' || cch - i == 3)
		return 0;

	// '@' ̌
	const length_t	iAt = i;
	bool			bDotAppeared = false;
	for(i = iAt + 1; i < cch; ++i) {
		if(IS_ALNUMBAR(psz[i]))
			continue;
		else if(psz[i] == L'.') {
			if(psz[i - 1] == L'.')
				return 0;
			bDotAppeared = true;
		} else
			break;
	}
	return (bDotAppeared && (i - iAt > 2)) ? i : 0;
}

/**
 *	wʒuNƏdȂĂ邩ǂԂ
 *	@param pt	NCAgW
 *	@param pwsz	<var>pt</var> Nɂ΂̕
 *				([AhX̏ꍇ͎I "mailto:" 擪ɒǉ)B
 *				Ăяoō폜Ȃ΂ȂȂ
 *	@return		<var>pt</var> Nɂ true 
 */
bool CEditView::IsOverInvokableLink(const POINT& pt, char_t*& pwsz) const {
	// !̎͐܂Ԃ̂ƂlĂȂ!
	AssertValidAsWindow();

	bool			bTruncated;
	const CCharPos	pos = CharFromPos(pt, true, &bTruncated);	// J[\ʒuɍł߂ʒu

	if(bTruncated)	// wʒuɕ
		return false;

	const char_t*	pwszLine = GetDocument()->GetLine(pos.m_iLine).c_str();
	const length_t	cchLine = GetDocument()->GetLineLength(pos.m_iLine);
	length_t		iChar = (pos.m_iChar > 200) ? pos.m_iChar - 200 : 0;
	length_t		cch;	// IsMailAddress AIsUrlString Ō

	while(iChar <= pos.m_iChar) {
		if(iChar != 0) {
			const char_t	ch = pwszLine[iChar - 1];
			if((ch >= L'A' && ch <= L'Z')
					|| (ch >= L'a' && ch <= L'z')
					|| ch == L'_') {
				++iChar;
				continue;
			}
		}
		if(0 != (cch = CEditView::IsUrlString(pwszLine + iChar, cchLine - iChar))) {
			if(iChar + cch > pos.m_iChar) {	// J[\ʒuz
				pwsz = new char_t[cch + 1];
				wcsncpy(pwsz, pwszLine + iChar, cch);
				pwsz[cch] = 0;
				return true;
			}
			iChar += cch;	// ͂Ȃꍇ͑s
		} else if(0 != (cch = CEditView::IsMailAddress(pwszLine + iChar, cchLine - iChar))) {
			if(iChar + cch > pos.m_iChar) {	// J[\ʒuz
				pwsz = new char_t[cch + 7 + 1];
				wcsncpy(pwsz, L"mailto:", 7);
				wcsncpy(pwsz + 7, pwszLine + iChar, cch);
				pwsz[cch + 7] = 0;
				return true;
			}
			iChar += cch;	// ͂Ȃꍇ͑s
		} else
			++iChar;
	}
	pwsz = 0;
	return false;
}

/**
 *	wʒȗ݂I͈͂ƏdȂĂ邩ǂԂ
 *	@param pt	NCAgW
 *	@return		<var>pt</var> I͈͏ɂ true
 */
inline bool CEditView::IsOverSelection(const POINT& pt) const {
	AssertValidAsWindow();

	if(!HasSelection()
			|| pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin)
			|| pt.y < static_cast<long>(m_layoutInfo.nTopMargin))
		return false;

	RECT	rect;

	GetClientRect(&rect);
	if(pt.x > rect.right || pt.y > rect.bottom)
		return false;

	if(!toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {	// ʂ̑I
	//	bool		bTruncated;
		CCharPos	pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse/*, &bTruncated*/);
		return /*!bTruncated ||*/ (GetSelTopPoint() <= pos && GetSelBottomPoint() >= pos);
	} else {	// `Ȉꍇ
		unsigned long	xView = pt.x - m_layoutInfo.nLeftTabWidth +
			m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
		length_t		iDisplayLine = m_ptScroll.y * m_layoutInfo.nVScrollRatio
			+ (pt.y - m_layoutInfo.nTopMargin) / m_layoutInfo.nLineHeight;
		return xView >= min(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive)
			&& xView <= max(m_layoutInfo.xBoxSelectionAnchor, m_layoutInfo.xBoxSelectionActive)
			&& iDisplayLine >= min(m_layoutInfo.iBoxSelectionAnchorLine, m_layoutInfo.iBoxSelectionActiveLine)
			&& iDisplayLine <= max(m_layoutInfo.iBoxSelectionAnchorLine, m_layoutInfo.iBoxSelectionActiveLine);
	}
}

/**
 *	@brief	 URL ׂ
 *
 *	_ł͈ȉ̕ URL ̊JnƂ݂Ȃ:
 *	<ul>
 *		<li>file://</li><li>ftp://</li><li>gopher://</li><li>http://</li><li>https://</li>
 *		<li>mailto://</li><li>news://</li><li>nntp://</li><li>telnet://</li><li>wais://</li>
 *	</ul>
 *
 *	@param psz	ׂ镶
 *	@param cch	
 *	@return		 URL ̏ꍇ͂̒BȊȌꍇ0
 */
length_t CEditView::IsUrlString(const char_t* psz, length_t cch) {
	assert(psz != 0);

#define STARTS_WITH(remain_len, start_ch, remain)	\
	((cchUrl = remain_len) && psz[0] == start_ch && cch > cchUrl && wcsncmp(psz + 1, remain, cchUrl) == 0)

	static const bool	arrUrlChars[] = {	// URI \
		false,	false,	false,	false,	false,	false,	false,	false,	// 0x00
		false,	false,	false,	false,	false,	false,	false,	false,
		false,	false,	false,	false,	false,	false,	false,	false,	// 0x10
		false,	false,	false,	false,	false,	false,	false,	false,
		false,	true,	false,	true,	true,	true,	true,	false,	// 0x20
		false,	false,	false,	false,	true,	true,	true,	true,
		true,	true,	true,	true,	true,	true,	true,	true,	// 0x30
		true,	true,	true,	true,	false,	true,	false,	true,
		true,	true,	true,	true,	true,	true,	true,	true,	// 0x40
		true,	true,	true,	true,	true,	true,	true,	true,
		true,	true,	true,	true,	true,	true,	true,	true,	// 0x50
		true,	true,	true,	false,	true,	false,	false,	true,
		false,	true,	true,	true,	true,	true,	true,	true,	// 0x60
		true,	true,	true,	true,	true,	true,	true,	true,
		true,	true,	true,	true,	true,	true,	true,	true,	// 0x70
		true,	true,	true,	false,	false,	false,	true,	false
	};
	length_t	cchUrl;

	if(!arrUrlChars[static_cast<unsigned char>(psz[0])] || cch < 6)
		return 0;
	if(STARTS_WITH(6, L'f', L"ile://")
			|| STARTS_WITH(5, L'f', L"tp://")
			|| STARTS_WITH(8, L'g', L"opher://")
			|| STARTS_WITH(6, L'h', L"ttp://")
			|| STARTS_WITH(7, L'h', L"ttps://")
			|| STARTS_WITH(8, L'm', L"ailto://")
			|| STARTS_WITH(6, L'n', L"ews://")
			|| STARTS_WITH(6, L'n', L"ntp://")
			|| STARTS_WITH(8, L't', L"elnet://")
			|| STARTS_WITH(6, L'w', L"ais://")) {
		for(++cchUrl; cchUrl < cch; ++cchUrl) {
			if(psz[cchUrl] > 0x007F || !arrUrlChars[static_cast<unsigned char>(psz[cchUrl])])
				return cchUrl;
		}
		return cch;
	}
	return 0;

#undef STARTS_WITH
}

/**
 *	\ʒu_ʒuɕϊB܂ԂȂꍇ͂̂܂܂̒lԂ
 *	@param posDisplay	ϊ\ʒu
 *	@return				ϊꂽ_ʒu (łȂo-1)
 */
CCharPos CEditView::LogicalCharFromDisplayChar(const CCharPos& posDisplay) const {
	AssertValid();

//	if(m_modeState.wpmWrapMode == WPM_NONE)
		return posDisplay;
/*
	CCharPos			posLogical(0, 0);
	CLineLayoutInfo*	pInfo = m_pLineLayoutManager->GetLine(0);

	// s̊m
	length_t	iTotalDisplayLine = 0;
	while(true) {
		iTotalDisplayLine += pInfo->m_vecWrappedOffsets.size() + 1;
		if(iTotalDisplayLine > posDisplay.iLine)
			break;
		pInfo = pInfo->m_pNext;
		if(pInfo == 0)
			return CCharPos(-1, -1);
		++posLogical.iLine;
	}

	// ̊m
	vector<length_t>::size_type	cOffsets = pInfo->m_vecWrappedOffsets.size();
	if(cOffsets == 0)	// ̍sł͐܂Ԃ͋NĂȂ
		return CCharPos(posLogical.iLine, posDisplay.iChar);
	for(vector<length_t>::size_type iOffset = 0; iOffset < cOffsets; ++iOffset) {
		if(posLogical.iChar + pInfo->m_vecWrappedOffsets[iOffset] >= posDisplay.iChar) {
			posLogical.iChar += posDisplay.iChar - posLogical.iChar;
			return posLogical;
		}
		posLogical.iChar += pInfo->m_vecWrappedOffsets[iOffset];
	}

	return CCharPos(posLogical.iLine, -1);*/
}

/**
 *	LbguȂꏊɂLbg𐳂ʒuɂ炷B
 *	UTF-16 TQ[g╡̉ɎgB
 *	@param pwsz			
 *	@param cch			
 *	@param nCaretPos	Lbgʒu
 *	@param bBackward	Lbgǂɓ
 *	@return				ړ (wchar_t P)B͌
 */
int CEditView::MakeCaretPosValid(const char_t* pwsz,
		length_t cch, length_t nCaretPos, bool bBackward) {
	assert(pwsz != 0);

	// P[X
	if(nCaretPos == 0 || nCaretPos >= cch)
		return 0;

	int			nOffset = 0;
	CodePoint	nCodePoint;
	while(true) {
		if(IsUTF16LowSurrogate(pwsz[nCaretPos + nOffset])
				&& nCaretPos + nOffset > 0
				&& IsUTF16HighSurrogate(pwsz[nCaretPos + nOffset - 1]))
			nOffset += bBackward ? -1 : 1;
		if(IsUTF16HighSurrogate(pwsz[nCaretPos + nOffset])
				&& IsUTF16LowSurrogate(pwsz[nCaretPos + nOffset + 1]))
			nCodePoint = DecodeUTF16SurrogatePairToCodePoint(pwsz + nCaretPos + nOffset, 2);
		else
			nCodePoint = pwsz[nCaretPos + nOffset];
		if(CBoundarySearcher::IsFirstCharacterOfCluster(nCodePoint))
			break;
		// 炷
		nOffset += bBackward ? -1 : 1;
		if(nCaretPos + nOffset == 0 || nCaretPos + nOffset == cch)
			return nOffset;
	}
	return nOffset;
}

/**
 *	tHg̐ݒBs̍XV
 *	@param lf		tHg (X^Co͖)
 *	@param bRedraw	ĕ`悷邩
 */
void CEditView::ModifyFontInfo(const LOGFONTW& lf, bool bRedraw /* = true */) {
	AssertValidAsWindow();
	HDC			hDC;
	HFONT		hOldFont = 0;
	LOGFONTW	lf_ = lf;
	TEXTMETRICW	tm;

	// ÕtHg폜
	if(m_gdiObjects.hNormalFont != 0) {
		::DeleteObject(m_gdiObjects.hNormalFont);
		::DeleteObject(m_gdiObjects.hBoldFont);
		::DeleteObject(m_gdiObjects.hItalicFont);
		::DeleteObject(m_gdiObjects.hBoldItalicFont);
	}

	lf_.lfItalic = false;
	lf_.lfStrikeOut = false;
	lf_.lfUnderline = false;

	lf_.lfWeight = FW_NORMAL;
	m_gdiObjects.hNormalFont = ::CreateFontIndirectW(&lf_);

	lf_.lfWeight = FW_BOLD;
	m_gdiObjects.hBoldFont = ::CreateFontIndirectW(&lf_);

	lf_.lfItalic = true;
	m_gdiObjects.hBoldItalicFont = ::CreateFontIndirectW(&lf_);

	lf_.lfWeight = FW_NORMAL;
	m_gdiObjects.hItalicFont = ::CreateFontIndirectW(&lf_);

	// tHg̕ۑ
	hDC = GetDC();
	::SelectObject(hDC, m_gdiObjects.hNormalFont);
	::GetTextMetrics(hDC, &tm);
	const unsigned int	tmp = m_layoutInfo.nCharHeight;
	m_layoutInfo.nCharHeight = tm.tmHeight + 1;
	m_layoutInfo.nLineHeight += m_layoutInfo.nCharHeight - tmp;
	m_layoutInfo.nCharWidth = tm.tmAveCharWidth;
	ReleaseDC(hDC);

	RecalcLeftTabWidth();

	// CAEgXV
	m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s̍XV
	ModifyScrollInfo(true, true);
	m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->ModifyFontInfo(lf, bRedraw);
	}

	if(bRedraw) {
		RecreateCaret();
		InvalidateRect(0);	// <- ő啝s̒ŐV̂̂ɍXV邽߂ (sɂ
		UpdateWindow();		//		ParseLineCharacterPositions Ă)
		InvalidateRect(0);	// <- ۂɕ`悷邽߂
		UpdateWindow();
		ValidateCaretPos();
	}
}

/**
 *	AXN[o[̏XV
 *	@param bHorizontal	XN[o[XVꍇ true
 *	@param bVertical	XN[o[XVꍇ true
 */
void CEditView::ModifyScrollInfo(bool bHorizontal, bool bVertical) {
	AssertValidAsWindow();

	const CEditDoc*	pDoc = GetDocument();
	SCROLLINFO		si = {
		sizeof(SCROLLINFO), SIF_DISABLENOSCROLL | SIF_PAGE | SIF_RANGE, 0, 0, 0, 0, 0
	};
	const length_t	cLines = GetDisplayLineCount();

	// XN[o[
	if(bVertical) {
		m_layoutInfo.nVScrollRatio = cLines / std::numeric_limits<int>::max() + 1;
		si.nMax = cLines / m_layoutInfo.nVScrollRatio - 1;
		si.nPage = GetVisibleLineCount();
		if((si.nMax - si.nMin) * m_layoutInfo.nVScrollRatio <= si.nPage)	// XN[o[ȂOɏ[ɃXN[
			OnVScroll(SB_TOP, 0, 0);
		SetScrollInfo(SB_VERT, &si, true);
	}

	// XN[o[
	if(bHorizontal) {
		const unsigned long	nMaxPixelLength = (m_modeState.wpmWrapMode == WPM_NONE) ?
								m_pLineLayoutManager->GetMaxDisplayWidth() / GetAvgCharWidth() : 0;
		m_layoutInfo.nHScrollRatio = nMaxPixelLength / std::numeric_limits<int>::max() + 1;
		si.nMax = nMaxPixelLength / m_layoutInfo.nHScrollRatio;
		si.nPage = GetVisibleCharCount();
		if((si.nMax - si.nMin) * m_layoutInfo.nHScrollRatio <= si.nPage)	// XN[o[ȂOɍ[ɃXN[
			OnHScroll(SB_LEFT, 0, 0);
		SetScrollInfo(SB_HORZ, &si, true);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->ModifyScrollInfo(bHorizontal, bVertical);
	}
}

/**
 *	wʒũNCAgW擾
 *	@param col	_ʒu
 *	@return		NCAgW
 */
POINT CEditView::PosFromChar(const CCharPos& col) const {
	AssertValidAsWindow();
	POINT			pt;	// ߂l
	length_t		iLine = std::min(col.m_iLine, GetDocument()->GetLineCount() - 1);
	CLineLayout*	pLineInfo = m_pLineLayoutManager->GetLine(iLine);
	length_t		iStart = 0;

	// ܂Ԃlꍇ
	if(m_modeState.wpmWrapMode != WPM_NONE) {
		CCharPos					colDisplay = DisplayCharFromLogicalChar(col);
		WrappedOffsets::size_type	cWraps = pLineInfo->GetWrappedPoints().size();

		// y W̊m
		pt.y = m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * (colDisplay.m_iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio);
		if(cWraps != 0) {
			vector<length_t>::size_type	i;
			for(i = 0; i < cWraps && col.m_iChar > pLineInfo->GetWrappedPoints()[i]; ++i)
				pt.y += m_layoutInfo.nLineHeight;
			if(i == cWraps)
				--i;
			iStart = (i != 0) ? pLineInfo->GetWrappedPoints()[i - 1] : 0;
		}
		// x W̊m

	} else {
		// y W̊m
		pt.y = m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * (iLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio);

		// x W̊m
		pt.x = pLineInfo->GetCaretPosition(std::min(col.m_iChar, GetDocument()->GetLineLength(iLine)));
	}

	pt.x -= m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
	pt.x += m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;

	return pt;
}

///	@see	IDropSource::QueryContinueDrag
STDMETHODIMP CEditView::QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState) {
	AssertValid();

	if(fEscapePressed || toBoolean(grfKeyState & MK_RBUTTON))	// LZ
		return DRAGDROP_S_CANCEL;
	if(!toBoolean(grfKeyState & MK_LBUTTON))	// hbv
		return DRAGDROP_S_DROP;

	return S_OK;
}

/**
 *	т̕ČvZčXV
 *	ύX΃NCAg`XV̈ɒǉ
 *	@param cy	EBhȄcB-1łΌ݂̃EBhȄc
 */
void CEditView::RecalcLeftTabWidth(int cy /* = -1 */) {
	if(!IsWindow())
		return;

	int							nNewWidth = 0;	// V
	unsigned int				cMaxDigits;
	const TLineNumberLayout&	lnl = m_layoutInfo.lineNumberLayout;

	if(m_layoutInfo.lineNumberLayout.bShowLineNumbers) {
		HFONT	hOldFont = m_gdiObjects.oMemDC.SelectObject(m_gdiObjects.hNormalFont);
		m_gdiObjects.oMemDC.GetCharWidth(L'8', L'8', &nNewWidth);
		m_gdiObjects.oMemDC.SelectObject(hOldFont);
		cMaxDigits = GetLineNumberMaxDigit();
		nNewWidth *= (std::max<unsigned int>(cMaxDigits,
			m_layoutInfo.lineNumberLayout.cMinimumDigits) + 2);	// Œጅmۂ
		if(lnl.borderStyle != TLineNumberLayout::LNBS_NONE)
			nNewWidth += lnl.nBorderWidth;
	}
	if(m_layoutInfo.lineNumberLayout.bShowIndicatorMargin)
		nNewWidth += m_layoutInfo.lineNumberLayout.nIMWidth;
	if(cy != -1 || nNewWidth != m_layoutInfo.nLeftTabWidth) {
		RECT	rect;
		HDC		hDC = GetDC();

		GetClientRect(&rect);
		if(cy == -1)
			cy = rect.bottom - rect.top;
		if(cy == 0)
			return;	// ύXȂ
		m_layoutInfo.nLeftTabWidth = nNewWidth;
		::DeleteObject(m_gdiObjects.hMemLeftTabBMP);	// rbg}bṽTCYύX
		m_gdiObjects.hMemLeftTabBMP =
			::CreateCompatibleBitmap(hDC, m_layoutInfo.nLeftTabWidth, cy);
		ReleaseDC(hDC);
		InvalidateRect(0, false);
		ValidateCaretPos();
	}
}

/**
 *	r[̐ݒ񂩂Lbg쐬B
 *	r[tH[JXĂ΃Lbg͎Iɕ\
 */
void CEditView::RecreateCaret() {
	AssertValidAsWindow();

	int	nCaretWidth;
	
	::DestroyCaret();
	if(!m_modeState.bOvertype || HasSelection())
		nCaretWidth = m_layoutInfo.bThinCaret ? 1 : 2;
	else {	// ㏑[ĥƂ̓Lbg̕Ɠɂ
		const string_t&	strLine = GetDocument()->GetLine(m_pActivePoint->m_iLine);
		const char_t*	pwszLine = strLine.c_str();
		const length_t	cchLine = strLine.length();

		if(m_pActivePoint->m_iChar == cchLine)
			nCaretWidth = GetAvgCharWidth();
		else if(pwszLine[m_pActivePoint->m_iChar] == L'\t') {
			POINT	pt = PosFromChar(*m_pActivePoint);

			pt.x += m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
			pt.x -= m_layoutInfo.nLeftMargin + m_layoutInfo.nLeftTabWidth;
			nCaretWidth = GetNextTabStop(pt.x, false/*m_modeState.bRtlReading*/) - pt.x;
		} else {
			CMinimalDC&	oDC = m_gdiObjects.oMemDC;
			HFONT		hOldFont;
			CCharPos	pos = m_pBoundarySearcher->SearchFirstCharacterOfCluster(*m_pActivePoint, true);

			hOldFont = oDC.SelectObject(m_gdiObjects.hNormalFont);
			nCaretWidth = oDC.GetTextExtent(
				pwszLine + m_pActivePoint->m_iChar,
				pos.m_iChar - m_pActivePoint->m_iChar).cx;
			oDC.SelectObject(hOldFont);
		}
	}
	CreateSolidCaret(nCaretWidth, m_layoutInfo.nCharHeight);
	if(m_hWnd == ::GetFocus())
		ShowCaret();
}

/**
 *	Ascension EBhENXo^
 *	@return	
 */
bool CEditView::RegisterWindowClass() {
	// EBhENXo^ĂȂΓo^
	if(!CEditView::m_bRegistered) {
		WNDCLASSEXW	wc;

		wc.cbSize			= sizeof(WNDCLASSEX);
		wc.style			= CS_BYTEALIGNCLIENT | CS_BYTEALIGNWINDOW | CS_DBLCLKS;
		wc.lpfnWndProc		= reinterpret_cast<WNDPROC>(CEditView::WndProc);
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= sizeof(long);
		wc.hInstance		= ::GetModuleHandle(0);
		wc.hIcon			= 0;
		wc.hIconSm			= 0;
		wc.hCursor			= ::LoadCursor(0, IDC_IBEAM);
		wc.hbrBackground	= reinterpret_cast<HBRUSH>(::GetStockObject(WHITE_BRUSH));
		wc.lpszClassName	= WC_ASCENSIONVIEW;
		wc.lpszMenuName		= 0;

		if(!::RegisterClassExW(&wc))
			return false;
		CEditView::m_bRegistered = true;
	}
	return true;
}

/**
 *	w肵ҏW_ǗĂ郊XgOB̃\bh CEditPoint
 *	̃fXgN^ĂяoBNCAgĂяoKv͖
 *	@param pt	ҏW_
 */
void CEditView::ReleaseEditPoint(CEditPoint& pt) {
	AssertValid();

	set<CEditPoint*>::iterator	it = m_setEditPoints.find(&pt);
	if(it != m_setEditPoints.end())
		m_setEditPoints.erase(it);
}

/**
 *	SĒu
 *	@param strReplaceWith	u
 *	@return					ueLXg̐
 */
unsigned long CEditView::ReplaceAll(const string_t& strReplaceWith) {
	AssertValid();

	CEditDoc*		pDocument = GetDocument();
	CCharPos		posOrigin = *m_pActivePoint;
	const length_t	cLines = pDocument->GetLineCount();
	unsigned long	cReplaced = 0;
	length_t		iBegin, iFound, cchFound;

	pDocument->BeginEditCollection();
	try {
		for(length_t iLine = 0; iLine < cLines; ++iLine) {
			iBegin = 0;
			while(true) {
				if(!CEditView::m_oTextSearcher.Search(
						pDocument->GetLine(iLine), iBegin, iFound, cchFound, *m_pBoundarySearcher))
					break;
				pDocument->DeleteText(this, CCharPos(iLine, iFound), CCharPos(iLine, iFound + cchFound));
				pDocument->InsertText(this, CCharPos(iLine, iFound), strReplaceWith);
				iBegin = iFound + strReplaceWith.length();
				++cReplaced;
			}
		}
	} catch(EFailedToLoadRegExpEngine& /* e */) {
		throw;
	} catch(ERegExpPatternIsInvalid& /* e */) {
		throw;
	}
	pDocument->EndEditCollection();

	if(cReplaced != 0)
		SetSelWithoutSelection(posOrigin);

	return cReplaced;
}

/**
 *	I͈͂uāAɈv镶IB
 *	I͈͂̕񂪌ɈvȂꍇIꍇ͒u͍sȂ
 *	@param strReplaceWith	u
 *	@return					Ɉv镶񂪌 true
 */
bool CEditView::ReplaceAndFindNext(const string_t& strReplaceWith) {
	AssertValid();

	if(HasSelection() && !toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {
		// TODO: ueLXgɃ}b`邩ׂȂƑʖ
//		string_t	strSelection = GetSelection();
		ReplaceSel(strReplaceWith);
	}

	return FindNext();
}

/**
 *	I͈͂w蕶Œu
 *	@param strText		}eLXg
 *	@param bBoxPaste	`}̏ꍇ^
 *	@see				DeleteSel
 */
void CEditView::ReplaceSel(const string_t& strText, bool bBoxPaste /* = false */) {
	AssertValidAsWindow();

	if(HasSelection()) {
		Freeze();
		GetDocument()->BeginEditCollection();
		DeleteSel();
		if(bBoxPaste)
			m_pActivePoint->InsertBox(strText);
		else
			InsertText(strText);
		GetDocument()->EndEditCollection();
		Unfreeze();
	} else if(bBoxPaste)
		m_pActivePoint->InsertBox(strText);
	else
		InsertText(strText);
}

/**
 *	AvP[V`s̐ݒB̍s̓r[<strong>1</strong>݂Ȃ
 *	@param iLine	_sB-1w肷邩sԍȂΉ
 */
void CEditView::SetAppDefinedLine(length_t iLine) {
	AssertValid();
	CLineLayout*	pInfo = (iLine != -1) ? m_pLineLayoutManager->GetLine(iLine) : 0;

	m_layoutInfo.pAppDefinedSingleLine = pInfo;
	if(IsWindowVisible())
		InvalidateRect(0, false);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetAppDefinedLine(iLine);
	}
}

/**
 *	w肵sɃubN}[Nݒ/
 *	@param iLine		ݒ肷s
 *	@param bOn			ݒ莞 trueB false
 *	@throw out_of_range	<var>iLine</var> sԍƂĐȂꍇX[
 *	@see				CEditView::HasBookmarkAt, CEditView::ToggleBookmark
 */
void CEditView::SetBookmark(length_t iLine, bool bOn /* = true */) throw(out_of_range) {
	AssertValid();
	CLineLayout*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	pInfo->SetBookmark(bOn);

	if(IsWindowVisible())
		InvalidateLine(iLine);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			if((*it)->IsWindowVisible())
				(*it)->InvalidateLine(iLine);
	}
}

/**
 *	͌PꃊXg̐ݒ
 *	@param listWords	ݒ肷镶̃Xg
 */
void CEditView::SetCandidateWords(const set<string_t>& setWords) {
	AssertValid();

	m_pwndAutoComplete->SetCandidateWords(setWords);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetCandidateWords(setWords);
	}
}

/**
 *	sԁAԊu̐ݒ
 *	@param nLineSpan	s̊Ԋu
 *	@param nCharSpan	̊Ԋu
 */
void CEditView::SetCharSpaces(unsigned int nLineSpan, unsigned int nCharSpan) {
	AssertValid();

	m_layoutInfo.nLineHeight = m_layoutInfo.nCharHeight + nLineSpan;
	m_layoutInfo.nCharSpan = nCharSpan;
	if(IsWindow()) {
		if(m_modeState.wpmWrapMode != WPM_NONE)
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
		ModifyScrollInfo(true, true);
		InvalidateRect(0, true);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetCharSpaces(nLineSpan, nCharSpan);
	}
}

///	sԍ̕\@ݒ肷
void CEditView::SetLineNumberLayout(const TLineNumberLayout& layout) {
	AssertValid();

	m_layoutInfo.lineNumberLayout = layout;
	UpdateGDIObjects();
	if(IsWindowVisible())
		InvalidateRect(0);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetLineNumberLayout(layout);
	}
}

/**
 *	AvP[V`l̐ݒ
 *	@param iLine	ݒs
 *	@param dwParam	AvP[V`l
 *	@param dwMask	}XNlB̃rbgɂe
 */
void CEditView::SetLineParam(length_t iLine, DWORD dwParam, DWORD dwMask /* = 0xFFFFFFFF */) {
	AssertValid();

	CLineLayout*	pInfo = m_pLineLayoutManager->GetLine(iLine);
	if(pInfo != 0) {
		DWORD	dwParam_ = pInfo->GetUserDefinedValue();
		dwParam_ &= ~dwMask;
		dwParam_ |= (dwParam & dwMask);
		pInfo->SetUserDefinedValue(dwParam_);
		if(IsWindowVisible())
			InvalidateLines(iLine, iLine);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetLineParam(iLine, dwParam, dwMask);
	}
}

/**
 *	A̗]̐ݒ
 *	@param nLeft	]
 *	@param nTop		]
 */
void CEditView::SetMargins(unsigned int nLeft, unsigned int nTop) {
	AssertValid();

	m_layoutInfo.nLeftMargin = nLeft;
	m_layoutInfo.nTopMargin = nTop;
	RecalcLeftTabWidth();

	if(IsWindow()) {
		if(m_modeState.wpmWrapMode == WPM_WINDOW)
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
		ModifyScrollInfo(true, true);
		InvalidateRect(0, true);
		ValidateCaretPos();
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetMargins(nLeft, nTop);
	}
}

/**
 *	̑̐ݒ
 *	@param evo	ݒ
 */
void CEditView::SetOption(TEditViewOption& evo) {
	AssertValid();

	const EditViewOption&	misc = evo.evoMiscellaneous;

	m_layoutInfo.bThinCaret = toBoolean(misc & EVO_USE_THINCARET);
	m_modeState.bResetDirByToken = toBoolean(misc & EVO_RESETDIRECTIONBYTOKEN);
	m_modeState.bUseOLEDragDrop = toBoolean(misc & EVO_USE_OLEDRAGDROP);
	m_modeState.bCaretExtenderByMouse = toBoolean(misc & EVO_ACCEPTABLECARETBYMOUSE);
	m_modeState.bRClickToMoveCaret = toBoolean(misc & EVO_RIGHTCLICKTOMOVECARET);
	m_modeState.bShowHandOnLink = toBoolean(misc & EVO_SHOW_HANDONLINK);
	m_modeState.bShowHintOnLink = toBoolean(misc & EVO_SHOW_HINTONLINK);
	m_modeState.aitAutoIndentType = evo.aitAutoIndentType;
	m_modeState.iStartLine = evo.iStartLine;
	m_modeState.iStartChar = evo.iStartChar;
	m_modeState.cFindLimit = evo.cRecognizingLines;
	m_foundationInfo.bDrawBreakArrow = toBoolean(misc & EVO_SHOW_BREAKARROWS);
	m_foundationInfo.bDrawCurrentUnderline = toBoolean(misc & EVO_SHOW_CURRENTUNDERLINE);
	m_foundationInfo.bDrawEOF = toBoolean(misc & EVO_SHOW_EOFMARK);
	m_foundationInfo.bDrawSpaces = toBoolean(misc & EVO_SHOW_WHITESPACE);
	m_foundationInfo.bIgnoreCaseOnHilite = toBoolean(misc & EVO_IGNORECASE);
	m_foundationInfo.bPaintBreakContinuingSelection = toBoolean(misc & EVO_PAINTBREAKCONTINUINGSEL);
	m_foundationInfo.bDrawBoldCharsClosely = toBoolean(misc & EVO_MAKECLOSEBOLDCHARS);
	m_foundationInfo.chSpace = evo.chWhitespaceAlternative;
	m_foundationInfo.chIdeographicSpace = evo.chIdeographicSpaceAlternative;
	m_foundationInfo.chTab = evo.chTabAlternative;
	m_foundationInfo.strEndOfFile = evo.strEndOfFile;

	if(IsWindow()) {
		RecreateCaret();
		InvalidateRect(0, false);
	}

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			(*it)->SetOption(evo);
	}
}

/**
 *	㏑[h̐ݒ
 *	@param bOvertype	true: ㏑Afalse: }
 */
void CEditView::SetOvertypeMode(bool bOvertype /* = true */) {
	AssertValid();

	m_modeState.bOvertype = bOvertype;
	if(!m_modeState.bOvertype)
		RecreateCaret();
	ValidateCaretPos();
	if(IsWindow())
		SetFocus();
	for(set<IEditViewEventListener*>::iterator it
			= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnMoveCaret(*m_pActivePoint);
}

/**
 *	̐ݒ
 *	@param sfFlags	
 */
void CEditView::SetSearchFlags(SearchFlag sfFlags) {
	AssertValid();
	CEditView::m_oTextSearcher.SetFlags(sfFlags);
	if(IsWindowVisible()
			&& m_modeState.bHighlightSearchText
			&& m_pTokenFoundations->arrEnabled[ETT_MATCHTEXT])
		InvalidateRect(0);
}

/**
 *	̐ݒ
 *	@param strText	
 */
void CEditView::SetSearchText(const string_t& strText) {
	AssertValid();
	CEditView::m_oTextSearcher.SetText(strText);
	if(IsWindowVisible()
			&& m_modeState.bHighlightSearchText
			&& m_pTokenFoundations->arrEnabled[ETT_MATCHTEXT])
		InvalidateRect(0);
}

/**
 *	݈ʒuAI͈͂̐ݒ
 *	@param posAnchor	IJnʒu
 *	@param posActive	IIʒu
 *	@param bScroll		VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint		ĕ`悷邩ǂBfalse ɂĂXV̈vZ邪Lbg͈ړȂ
 */
void CEditView::SetSel(const CCharPos& posAnchor,
		const CCharPos& posActive, bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValidAsWindow();

	if(*m_pAnchorPoint != posAnchor || *m_pActivePoint != posActive) {
		const CEditDoc*	pDoc = GetDocument();
		const length_t	cLines = pDoc->GetLineCount();
		length_t		cchLine;
		const length_t	nOriginColumn[] = {m_pAnchorPoint->m_iChar, m_pActivePoint->m_iChar};	// ̗̈ʒu
		bool			bAnchorAndActiveIsSame = posAnchor == posActive;

		HideCaret();

		// ̈ʒuۑ
		CCharPos	posTopOrg = GetSelTopPoint();
		CCharPos	posBottomOrg = GetSelBottomPoint();

		// n_̍sƗ̒
		CCharPos	posAnchorOrg = *m_pAnchorPoint;
		m_pAnchorPoint->m_iLine = std::min(posAnchor.m_iLine, cLines - 1);
		cchLine = pDoc->GetLineLength(m_pAnchorPoint->m_iLine);
		m_pAnchorPoint->m_iChar = std::min(posAnchor.m_iChar, cchLine);
		if(!m_modeState.bCaretExtenderByMouse)
			m_pAnchorPoint->m_iChar += MakeCaretPosValid(
				pDoc->GetLine(m_pAnchorPoint->m_iLine).c_str(),
					cchLine, m_pAnchorPoint->m_iChar, posAnchor < posAnchorOrg);

		// I_̍sƗ̒
		if(bAnchorAndActiveIsSame)
			m_pActivePoint->MoveToPoint(*m_pAnchorPoint);
		else {
			CCharPos	posActiveOrg = *m_pActivePoint;
			m_pActivePoint->m_iLine = std::min(posActive.m_iLine, cLines - 1);
			cchLine = pDoc->GetLineLength(m_pActivePoint->m_iLine);
			m_pActivePoint->m_iChar = std::min(posActive.m_iChar, cchLine);
			if(!m_modeState.bCaretExtenderByMouse)
				m_pActivePoint->m_iChar += MakeCaretPosValid(
					pDoc->GetLine(m_pActivePoint->m_iLine).c_str(),
						cchLine, m_pActivePoint->m_iChar, posActive < posActiveOrg);
		}

		// Lbg/I͈͂̐ݒ
		if(bRepaint)
			ValidateCaretPos();
		ShowCaret();

		if(!toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {
			// XV
			if(posTopOrg == posBottomOrg) {	// XIꍇ
				if(HasSelection())	// I쐬
					InvalidateLines(
						min(GetSelTopPoint().m_iLine, posBottomOrg.m_iLine),
						max(GetSelBottomPoint().m_iLine, posBottomOrg.m_iLine));
				else {
					InvalidateLine(m_pActivePoint->m_iLine);
					UpdateWindow();
					InvalidateLine(posBottomOrg.m_iLine);
				}
			} else {	// XIꍇ
				if(!HasSelection())	// I
					InvalidateLines(
						(posTopOrg.m_iLine < m_pAnchorPoint->m_iLine) ? posTopOrg.m_iLine : m_pAnchorPoint->m_iLine,
						(posBottomOrg.m_iLine > m_pActivePoint->m_iLine) ? posBottomOrg.m_iLine : m_pActivePoint->m_iLine);
				else {	// I͈͂ύX
					const CCharPos&	posTop = GetSelTopPoint();
					const CCharPos&	posBottom = GetSelBottomPoint();
					if(posTop == posTopOrg)	// n_Œ
						InvalidateLines(posBottom.m_iLine, posBottomOrg.m_iLine);
					else if(posBottom == posBottomOrg)	// I_Œ
						InvalidateLines(posTop.m_iLine, posTopOrg.m_iLine);
					else	// ω
						InvalidateLines(min(posTop.m_iLine, posTopOrg.m_iLine), max(posBottom.m_iLine, posBottomOrg.m_iLine));
				}
			}
		} else {	// `I
			// XV
			const CCharPos&	posTop = GetSelTopPoint();
			const CCharPos&	posBottom = GetSelBottomPoint();

			m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
			m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x
				+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() - m_layoutInfo.nLeftTabWidth + 1;
			InvalidateLines(min(posTop, posTopOrg).m_iLine, max(posBottom, posBottomOrg).m_iLine);
		}

		if(bRepaint)
			UpdateWindow();
	}

	m_pAnchorPoint->MoveToPoint(*m_pAnchorPoint);
	m_pActivePoint->MoveToPoint(*m_pActivePoint);

	// Ίʂ̋\
	CheckMatchBrackets();

	// I͈͂LbgɂȂ悤ɃXN[
	if(bScroll)
		m_pActivePoint->EnsureVisible();

	// IME œ͒̏ꍇ͕ҏWEBhËʒuC
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();

	// CxgXiɒʒm (L[}NĐ͂ʒmȂ)
	if(bRepaint && (m_pKeyMacroPlayer->GetState() != KMS_PLAYING
			|| m_pKeyMacroPlayer->GetActiveView() != this)) {
		for(set<IEditViewEventListener*>::iterator it
				= m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
			(*it)->OnMoveCaret(*m_pActivePoint);
	}
}

/**
 *	Lbgʒu̐ݒ
 *	@param pos		ʒu
 *	@param bScroll	VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint	ĕ`悷邩ǂ
 */
void CEditView::SetSelWithoutSelection(const CCharPos& pos,
		bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValid();
	SetSel(pos, pos, bScroll, bRepaint);
}

/**
 *	Lbgʒu̐ݒ
 *	@param iLine, iChar	ʒu
 *	@param bScroll		VʒuʊÔƂɃXN[邩ǂ
 *	@param bRepaint		ĕ`悷邩ǂ
 */
void CEditView::SetSelWithoutSelection(unsigned int iLine, unsigned int iChar,
		bool bScroll /* = true */, bool bRepaint /* = true */) {
	AssertValid();
	SetSelWithoutSelection(CCharPos(iLine, iChar), bScroll, bRepaint);
}

///	^u̐ݒ
void CEditView::SetTabWidth(unsigned short nTabWidth) {
	AssertValid();

	if(nTabWidth != m_layoutInfo.nTabWidth) {
		m_layoutInfo.nTabWidth = nTabWidth;
		if(IsWindow()) {
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
			InvalidateRect(0);
		}
	}

	if(m_pOriginalView == this)
		for_each(m_setClones.begin(), m_setClones.end(),
			bind2nd(mem_fun(CEditView::SetTabWidth), nTabWidth));
//		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
//			(*it)->SetTabWidth(nTabWidth);
}

/**
 *	eLXg̕ݒ肷
 *	@param bRtlReading	E獶ɓǂޏꍇ
 */
void CEditView::SetTextDirection(bool bRtlReading) {
	AssertValid();

	if(m_modeState.bRtlReading != bRtlReading) {
		m_modeState.bRtlReading = bRtlReading;
		if(IsWindow()) {
			ModifyStyleEx(
				bRtlReading ? WS_EX_RIGHTSCROLLBAR : WS_EX_LEFTSCROLLBAR | WS_EX_RTLREADING,
				bRtlReading ? WS_EX_LEFTSCROLLBAR | WS_EX_RTLREADING : WS_EX_RIGHTSCROLLBAR);
			m_pLineLayoutManager->NotifyAll(LPL_FULL);
			InvalidateRect(0);
		}
	}

	if(m_pOriginalView == this)
		for_each(m_setClones.begin(), m_setClones.end(),
			bind2nd(mem_fun(CEditView::SetTextDirection), bRtlReading));
//		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
//			(*it)->SetTextDirection(bRtlReading);
}

/**
 *	C̐ݒ
 *	@param type				C̎
 *	@param nCookie			g[ÑNbL[l
 *	@param tf				CBOiFƔwiF-1w肷ƎIɌ肳Bʏ̃eLXgA
 *							Í͈AANeBuȑI͈͂̓VXe`FA
 *							CWP[^}[W 3D IuWFNgȂ͒ʏ̃eLXgƓɂȂ
 *	@throw invalid_argument	<var>type</var>  <var>nCookie</var> sȂƂX[
 *	@see					GetTextFoundation
 */
void CEditView::SetTextFoundation(int type, TokenCookie nCookie, const TTextFoundation& tf) throw(invalid_argument) {
	AssertValid();
	if(type < TT_WHITESPACE || type >= ETT_COUNT)
		throw invalid_argument("Specified type is invalid.");

	if(type != TT_KEYWORD && type != TT_ANNOTATION)
		*m_pTokenFoundations->tfs[type].ptf = tf;
	else {
		map<TokenCookie, TTextFoundation>::iterator	it;

		it = m_pTokenFoundations->tfs[type].pmapTfs->find(nCookie);
		if(it == m_pTokenFoundations->tfs[type].pmapTfs->end())
			throw invalid_argument("Specified token cookie is invalid");
		it->second = tf;
	}

	UpdateGDIObjects();
	if(IsWindow())
		InvalidateRect(0, false);

	try {
		if(m_pOriginalView == this) {
			for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
				(*it)->SetTextFoundation(type, nCookie, tf);
		}
	} catch(out_of_range& /* e */) {
		throw;
	}
}

///	܂Ԃ[h̐ݒ
void CEditView::SetWrapMode(WrapMode wpm) {
	AssertValidAsWindow();

	if(wpm == m_modeState.wpmWrapMode)
		return;

	WrapMode	wpmOrg = m_modeState.wpmWrapMode;	// ̒lۑ

	m_modeState.wpmWrapMode = wpm;
	m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s𒲐
	if(wpmOrg == WPM_NONE)
		OnVScroll(SB_SETPOS, DisplayCharFromLogicalChar(CCharPos(m_ptScroll.y * m_layoutInfo.nVScrollRatio, 0)).m_iLine, 0);
	else
		OnVScroll(SB_SETPOS, LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y * m_layoutInfo.nVScrollRatio, 0)).m_iLine, 0);
	m_pOriginalView->ModifyScrollInfo(true, true);
	InvalidateRect(0, false);
}

///	܂Ԃ̐ݒ
void CEditView::SetWrapWidth(int nWrapWidth) {
	AssertValid();

	m_modeState.nWrapWidth = nWrapWidth;
	if(IsWindow() && m_modeState.wpmWrapMode == WPM_SPECIFIED) {
		m_pLineLayoutManager->NotifyAll(LPL_FULL);
		m_pOriginalView->ModifyScrollInfo(true, true);
		InvalidateRect(0, false);
	}
}

/**
 *	J[\ʒuɃc[`bv\
 *	@param strText				\eLXgBCR+LF ŉsBNUL ͊܂߂Ȃ
 *	@param nTimeToWait			\܂ł̎ (~b)B-1ƃVXe
 *	@param nTimeRemainsVisible	\鎞 (~b)B-1ƃVXe
 */
void CEditView::ShowToolTip(const string_t& strText,
		unsigned long nTimeToWait /* = -1 */, unsigned long nTimeRemainsVisible /* = -1 */) {
	AssertValidAsWindow();

	delete[] m_pwszTipText;
	m_pwszTipText = new wchar_t[strText.length() + 1];
	HideToolTip();
	if(nTimeToWait == -1)
		nTimeToWait = ::GetDoubleClickTime();
	wcscpy(m_pwszTipText, strText.c_str());
	SetTimer(TIMERID_CALLTIP, nTimeToWait, 0);
}

/**
 *	!gp֎~! ݖ
 *	݃LbĝsX}[gCfgB
 *	̃\bh <var>ch</var> ̑}s (ۂɃX}[gCfgƂ̂)A
 *	̂Ƃɂ͑Ŝ̑삪 OCF_PREVENTALL ƂȂ悤ɏB
 *	݂̃\bh͈ꕔ̌łӖB
 *	̌ǉɂ̓|V[NXKvB
 *	X}[gCfg̋ ߂.txt ɂ܂Ƃ߂Ă
 *	@param ch	X}[gCfgs͕ (s L'\n' g)
 *	@return		X}[gCfgsǂ
 */
bool CEditView::SmartIndent(wchar_t ch) {
/*	AssertValidAsWindow();

	unsigned long	nNest = 1;	// ʂ̃lXgx

	if(ch == L'{' || ch == L'}') {	// '{' T
		if(m_posActive.iLine == 0)
			return false;
		if(-1 == FindBrace(m_posActive.iLine, L'{', nNest, m_posActive.iChar - 1)) {	// ݍsT
			for(length_t iLine = m_posActive.iLine - 1;	// skĒT
					m_posActive.iLine - iLine < m_modeState.cFindLimit; --iLine) {
				if(-1 != FindBrace(iLine, L'{', nNest))
					break;
				if(iLine == 0)
					break;
			}
			CEditDoc*		pDoc = GetDocument();
			const string_t&	strLine = pDoc->GetLine(iLine);
			length_t		cchIndent = IsWhiteSpace(strLine.c_str(), strLine.length(), true);
			string_t		strIndent = strLine.substr(0, cchIndent);

			strLine = pDoc->GetLine(m_posActive.iLine);
			length_t	cchIndentOld = IsWhiteSpace(strLine.c_str(), strLine.length(), true);
			if(ch == L'{') {
				strIndent.insert(0, L'\t');
				cchIndent += 1;
			}
			if(cchIndentOld != 0)
				pDoc->DeleteText(this,
					CCharPos(m_posActive.iLine, 0), CCharPos(m_posActive.iLine, cchIndentOld),
					static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			pDoc->InsertText(this, CCharPos(m_posActive.iLine, 0), strIndent,
				(cchIndentOld != 0) ? OCF_CONCATALL
				: static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, m_posActive.iChar + cchIndent - cchIndentOld);
			InsertText(string_t(&ch, 1),
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			return true;
		}
	} else if(ch == L'\n') {	// O̍s𒲂ׂ
		const string_t&	strPrevLine = GetDocument()->GetLine(m_posActive.iLine).substr(0, m_posActive.iChar);
		length_t		cchPrevLine = strPrevLine.length();
		const char_t*	pwszPrevLine = strPrevLine.c_str();
		length_t		iChar = 0;					// ݈ʒu
		MCommentType	mct = m_pLineLayoutManager->FindByLineNumber(m_posActive.iLine)->m_mctFromPrev;
		bool			bMCommentContinued = mct != MCT_NOTCOMMENT;
		unsigned long	nBraceLevel = 0;			// ʂ̓qx
		unsigned long	nParenLevel = 0;			// ۊʂ̓qx
		bool			bLastIsSemicolon = false;	// ŌɒׂZ~R
		length_t		cchToken;					// g[N̒
		
		// ʂĂ邩AŌ̕𒲂ׂ
		while(iChar < cchPrevLine) {
			if(iChar == 0 && mct == MCT_1) {
				cchToken = IsMComment1(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(iChar == 0 && mct == MCT_2) {
				cchToken = IsMComment2(pwszPrevLine, cchPrevLine, bMCommentContinued);
				if(bMCommentContinued)
					break;
				bLastIsSemicolon = false;
				iChar += cchToken;
			} else if(0 != IsSComment1(pwszPrevLine + iChar) || 0 != IsSComment2(pwszPrevLine + iChar))
				break;
			else if(0 != (cchToken = IsMComment1(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))
					|| 0 != (cchToken = IsMComment2(pwszPrevLine + iChar, cchPrevLine - iChar, bMCommentContinued))) {
				if(bMCommentContinued)
					break;
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsSingleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))
					|| 0 != (cchToken = IsDoubleQuotation(pwszPrevLine + iChar, cchPrevLine - iChar))) {
				iChar += cchToken;
				bLastIsSemicolon = false;
			} else if(0 != (cchToken = IsWhiteSpace(pwszPrevLine + iChar, cchPrevLine - iChar, true)))
				iChar += cchToken;
			else {	// ̑̕
				wchar_t	wch = *(pwszPrevLine + iChar);
				if(wch == L';')
					bLastIsSemicolon = true;
				else {
					bLastIsSemicolon = false;
					if(wch == L'{')								++nBraceLevel;
					else if(wch == L'(')						++nParenLevel;
					else if(wch == L'}' && nBraceLevel != 0)	--nBraceLevel;
					else if(wch == L')' && nParenLevel != 0)	--nParenLevel;
				}
				++iChar;
			}
		}

		// X}[gCfg邩?
		length_t	cchIndentOld = IsWhiteSpace(strPrevLine.c_str(), cchPrevLine, true);
		if((nBraceLevel != 0 || nParenLevel != 0)
				|| (!bLastIsSemicolon && cchIndentOld != 0)) {
			ReplaceSel(CEditDoc::m_arrBreakStrings[GetDocument()->GetBreakType()],
				static_cast<OperationConcatenationFlag>(OCF_PREVENTCONCATFORWARD | OCF_CONCATBACKWARD));

			length_t		iCharOrg = m_posActive.iChar;
			CEditDoc*		pDoc = GetDocument();
			const string_t&	strCurrentLine = pDoc->GetLine(m_posActive.iLine);
			length_t		cchIndent = IsWhiteSpace(strCurrentLine.c_str(), strCurrentLine.length(), true);
			string_t		strIndent = L"\t" + strPrevLine.substr(0, cchIndentOld);

			pDoc->DeleteText(this, m_posActive, CCharPos(m_posActive.iLine, cchIndent), OCF_CONCATALL);
			InsertText(strIndent,
				static_cast<OperationConcatenationFlag>(OCF_CONCATFORWARD | OCF_PREVENTCONCATBACKWARD));
			SetSelWithoutSelection(m_posActive.iLine, iCharOrg);
			return true;
		}
	}
*/
	return false;
}

/**
 *	w肵s̃ubN}[Nݒ/Bݒ肳ĂΉAĂΐݒ肷
 *	@param iLine		ݒ肷s
 *	@throw out_of_range	<var>iLine</var> sԍƂĐȂꍇX[
 *	@see				CEditView::SetBookmark
 */
void CEditView::ToggleBookmark(length_t iLine) throw(out_of_range) {
	AssertValid();
	CLineLayout*	pInfo = m_pLineLayoutManager->GetLine(iLine);

	if(pInfo == 0)
		throw out_of_range("First argument is invalid for line number.");
	pInfo->SetBookmark(!pInfo->IsBookmarked());
	if(IsWindowVisible())
		InvalidateLine(iLine);

	if(m_pOriginalView == this) {
		for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
			if((*it)->IsWindowVisible())
				(*it)->InvalidateLine(iLine);
	}
}

///	Unfreeze ̖{
void CEditView::_Unfreeze() {
	AssertValidAsWindow();

	length_t		iAnchor = -1;
	const length_t	cVisibleLines = GetVisibleLineCount();

	RecalcLeftTabWidth();
	for(unsigned long i = m_ptScroll.y; i <= m_ptScroll.y + cVisibleLines; ++i) {
		set<length_t>::iterator	it = m_setInvalidLines.find(i);

		if(it != m_setInvalidLines.end()) {
			m_setInvalidLines.erase(it);
			if(iAnchor == -1)
				iAnchor = i;
		} else if(iAnchor != -1) {
			InvalidateLines(iAnchor, i - 1);
			iAnchor = -1;
		}
	}
	if(iAnchor != -1)
		InvalidateLines(iAnchor, m_ptScroll.y + cVisibleLines);
	m_setInvalidLines.clear();
	ModifyScrollInfo(true, true);
	OnMoveCaret();
	UpdateWindow();
}

/**
 *	@brief	`̃t[Y
 *	̃\bh͓ OnMoveCaret Ăяo
 */
void CEditView::Unfreeze() {
	AssertValidAsWindow();

	if(m_pOriginalView->m_nFreezeCount > 0) {
		if(--m_pOriginalView->m_nFreezeCount == 0)
			m_pOriginalView->_Unfreeze();
	}
	for(set<CEditView*>::iterator it =
			m_pOriginalView->m_setClones.begin();
			it != m_pOriginalView->m_setClones.end(); ++it) {
		if((*it)->m_nFreezeCount > 0) {
			if(--(*it)->m_nFreezeCount == 0)
				(*it)->_Unfreeze();
		}
	}
}

///	݂̐ݒg GDI IuWFNgXV
void CEditView::UpdateGDIObjects() {

	::DeleteObject(m_gdiObjects.hUnderlinePen);
	::DeleteObject(m_gdiObjects.hIAUnderlinePen);
	::DeleteObject(m_gdiObjects.hLeftIndicatorPen);
	::DeleteObject(m_gdiObjects.hLineNumberPen);
	::DeleteObject(m_gdiObjects.hColumnPen);
	::DeleteObject(m_gdiObjects.hWhiteSpacePen);
	::DeleteObject(m_gdiObjects.hLineBreakPen);

	m_gdiObjects.hUnderlinePen = ::CreatePen(PS_SOLID, 1,
		(m_layoutInfo.clrUnderline != -1) ? m_layoutInfo.clrUnderline : ::GetSysColor(COLOR_HIGHLIGHT));
	m_gdiObjects.hIAUnderlinePen = ::CreatePen(PS_SOLID, 1,
		(m_layoutInfo.clrIAUnderline != -1) ? m_layoutInfo.clrIAUnderline : ::GetSysColor(COLOR_INACTIVECAPTION));
	m_gdiObjects.hLeftIndicatorPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(ETT_INDICATOR_MARGIN, NullCookie).fgColor);
	m_gdiObjects.hWhiteSpacePen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(TT_WHITESPACE, NullCookie).fgColor);
	m_gdiObjects.hLineBreakPen = ::CreatePen(PS_SOLID, 1, GetTextFoundation(ETT_END_OF_LINE, NullCookie).fgColor);

	// sԍ̋؂`y
	if(m_layoutInfo.lineNumberLayout.bShowLineNumbers) {
		if(m_layoutInfo.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_SOLID)	// 
			m_gdiObjects.hLineNumberPen = ::CreatePen(PS_SOLID,
				m_layoutInfo.lineNumberLayout.nBorderWidth, GetTextFoundation(ETT_LINENUMBER, NullCookie).fgColor);
		else {
			LOGBRUSH	lb;
			lb.lbColor = m_pTokenFoundations->tfs[ETT_LINENUMBER].ptf->fgColor;
			lb.lbStyle = BS_SOLID;
			if(m_layoutInfo.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DASHED)	// j
				m_gdiObjects.hLineNumberPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DASH | PS_ENDCAP_FLAT,
					m_layoutInfo.lineNumberLayout.nBorderWidth, &lb, 0, 0);
			else if(m_layoutInfo.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DASHED_ROUNDED)	// ۔j
				m_gdiObjects.hLineNumberPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DASH | PS_ENDCAP_ROUND,
					m_layoutInfo.lineNumberLayout.nBorderWidth, &lb, 0, 0);
			else if(m_layoutInfo.lineNumberLayout.borderStyle == TLineNumberLayout::LNBS_DOTTED)	// _
				m_gdiObjects.hLineNumberPen = ::ExtCreatePen(PS_GEOMETRIC | PS_DOT,
					m_layoutInfo.lineNumberLayout.nBorderWidth, &lb, 0, 0);
		}
	}
}

/**
 *	CN^̏ԂXV
 *	@param bTextIsShortened	eLXg (̕邩S폜̂߂) Zꂽ
 */
void CEditView::UpdateISearchState(bool bTextIsShortened) {
	if(m_modeState.incrementalSearchState == ISS_NOTRUNNING)
		return;

	const CEditDoc*	pDocument = GetDocument();
	const CCharPos&	posSearchBegin = bTextIsShortened ? m_modeState.posBeforeISearch : *m_pAnchorPoint;
	const length_t	cchSearchText = m_modeState.strISearchText.length();
	const length_t	cLines = GetDocument()->GetLineCount();
	length_t		iLine;
	bool			bFound = false;

	if(m_modeState.incrementalSearchState == ISS_FORWARD) {	// O
		for(iLine = posSearchBegin.m_iLine; iLine < cLines; ++iLine) {
			const string_t&	strLine = pDocument->GetLine(iLine);
			const length_t	iFound = strLine.find(m_modeState.strISearchText,
										(iLine != posSearchBegin.m_iLine) ? 0 : posSearchBegin.m_iChar);

			if(iFound != string_t::npos) {
				SetSel(CCharPos(iLine, iFound), CCharPos(iLine, iFound + cchSearchText));
				bFound = true;
				break;
			}
		}
	} else {	// 
		for(iLine = posSearchBegin.m_iLine; ; --iLine) {
			const string_t&	strLine = pDocument->GetLine(iLine);
			const length_t	iSearchBegin = (iLine != m_modeState.posBeforeISearch.m_iLine) ?
											strLine.length() : m_modeState.posBeforeISearch.m_iChar;

			if(iSearchBegin >= cchSearchText) {
				const length_t	iFound = strLine.rfind(m_modeState.strISearchText, iSearchBegin/* - cchSearchText*/);

				if(iFound != string_t::npos) {
					SetSel(CCharPos(iLine, iFound + cchSearchText), CCharPos(iLine, iFound));
					bFound = true;
					break;
				}
			}
			if(iLine == 0)
				break;
		}
	}

	// CxgXiɒʒm
	for(set<IEditViewEventListener*>::iterator it =
			m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnIncrementalSearchEvent(bFound ?
			ISE_STRING_CHANGED : ISE_STRING_NOT_FOUND, m_modeState.strISearchText.c_str());
}

///	݈ʒuƃXN[󋵁AtHgȂǂLbgK؂ȈʒuɈړ
void CEditView::ValidateCaretPos() {
	if(m_hWnd != ::GetFocus() || IsFreezed())
		return;
	if(m_modeState.bOvertype)
		RecreateCaret();

	POINT	pt = PosFromChar(*m_pActivePoint);

	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))	// LbguBv
		pt.x = -static_cast<long>(m_layoutInfo.nCharWidth);
	else if(pt.y < static_cast<long>(m_layoutInfo.nTopMargin))	// LbguBv
		pt.y = -static_cast<long>(m_layoutInfo.nLineHeight);
	if(!m_modeState.bOvertype || HasSelection())
		--pt.x;
	SetCaretPos(pt);
}

///	IME tH[𐳂ʒuɈړ
void CEditView::ValidateIMEWindowPos() {
	AssertValidAsWindow();
	if(!m_bActiveIMEComposition)
		return;

	COMPOSITIONFORM	cf;
	HIMC			hIMC = ::ImmGetContext(m_hWnd);

	if(hIMC != 0) {
		cf.dwStyle = CFS_POINT;
		cf.ptCurrentPos = PosFromChar(*m_pActivePoint);
	//	cf.ptCurrentPos.x -= 1;
		cf.ptCurrentPos.y -= 1;
		::ImmSetCompositionWindow(hIMC, &cf);
		::ImmReleaseContext(m_hWnd, hIMC);
	}
}

/**
 *	̃EBhENX̃vZX
 *	@param hWnd				EBhEnh
 *	@param message			bZ[W
 *	@param wParam, lParam	bZ[Wˑ
 *	@return					bZ[Wˑ
 */
LRESULT CALLBACK CEditView::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	CEditView*	pView = 0;
	if(message == WM_CREATE) {
		pView = reinterpret_cast<CEditView*>(reinterpret_cast<CREATESTRUCTW*>(lParam)->lpCreateParams);
		pView->m_hWnd = hWnd;
		pView->SetWindowLong(
			GWL_USERDATA, reinterpret_cast<long>(reinterpret_cast<CREATESTRUCTW*>(lParam)->lpCreateParams));
		return pView->DispatchEvent(message, wParam, lParam);
	} else {
		pView = reinterpret_cast<CEditView*>(::GetWindowLong(hWnd, GWL_USERDATA));
		return (pView != 0 && pView->m_hWnd == hWnd) ?
			pView->DispatchEvent(message, wParam, lParam) : ::DefWindowProc(hWnd, message, wParam, lParam);
	}
}

/* [EOF] */