// EditView.h
// (c) 2003-2004 exeal

#ifndef _EDIT_VIEW_H_
#define _EDIT_VIEW_H_

#include "EditDoc.h"
#include "..\..\Manah\DC.h"	// Manah::Windows::GDI::CMinimalDC
#include "..\..\Armaiti\DraggingTextDataObject.h"
#include "LineLayout.h"
#include "TextSearcher.h"
#include "KeyMacroPlayer.h"
#include "AutoCompleteWnd.h"
#include <set>
#include <algorithm>


#define WC_ASCENSIONVIEW			L"AscensionView"		// r[EBhENX
#define RECTANGLE_TEXT_CLIP_FORMAT	L"MSDEVColumnSelect"	// `f[^̃Nbv{[h`
#define SB_SETPOS					20						// XN[ʒuύX邽߂OnHScroll
															// AOnVScroll ĂяoƂɎgR[h


namespace Ascension {

class CEditView;
class CEditController;
class CLineLayoutInfo;
class CLineLayoutManager;
class CEditPoint;
class CVisibleEditPoint;
class CKeywordManager;
class CKeyMacroPlayer;
class CAutoCompleteWnd;


// Miscellaneous
/////////////////////////////////////////////////////////////////////////////

///	ReLXgj[Ȃǂ ID
enum {
	WM_REDO	= WM_APP + 1,		///	ɖ߂
	WM_SELECTALL,				///	SđI
	ID_SHOWUNICODECONTROLCHARS,	///	Unicode 䕶̕\
	ID_SHOWRTL,					///	E獶ɓǂ
	ID_TOGGLEIMESTATUS,			///	IME J/
	ID_RECOMPOSITIONIME,		///	ĕϊ

	ID_INSERT_LRM,		///	LRM (Left-to-right mark)
	ID_INSERT_RLM,		///	RLM (Right-to-left mark)
	ID_INSERT_ZWJ,		///	ZWJ (Zero width joiner)
	ID_INSERT_ZWNJ,		///	ZWNJ (Zero width non-joiner)
	ID_INSERT_LRE,		///	LRE (Left-to-right embedding)
	ID_INSERT_RLE,		///	RLE (Right-to-left embedding)
	ID_INSERT_LRO,		///	LRO (Left-to-right override)
	ID_INSERT_RLO,		///	RLO (Right-to-left override)
	ID_INSERT_PDF,		///	PDF (Pop directional formatting)
	ID_INSERT_WJ,		///	WJ (Word Joiner)
	ID_INSERT_U2061,	///	U+2061 (Function Application)
	ID_INSERT_U2062,	///	U+2062 (Invisible Times)
	ID_INSERT_U2063,	///	U+2063 (Invisible Separator)
/*	ID_INSERT_NADS,		///	NADS (National digit shapes)	<- 񐄏vf炵
	ID_INSERT_NODS,		///	NODS (Nominal digit shapes)
	ID_INSERT_ASS,		///	ASS (Activate symmetric swapping)
	ID_INSERT_ISS,		///	ISS (Inhibit symmetric swapping)
	ID_INSERT_AAFS,		///	AAFS (Activate Arabic form shaping)
	ID_INSERT_IAFS,		///	IAFS (Inhibit Arabic form shaping)
*/	ID_INSERT_RS,		///	RS (Record Separator)
	ID_INSERT_US,		///	US (Unit Separator)

	ID_INSERT_U0020,	///	U+0020 (Space)
	ID_INSERT_NBSP,		///	NBSP (No-Break Space)
	ID_INSERT_U1680,	///	U+1680 (Ogham Space Mark)
	ID_INSERT_MVS,		///	MVS (Mongolian Vowel Separator)
	ID_INSERT_U2000,	///	U+2000 (En Quad)
	ID_INSERT_U2001,	///	U+2001 (Em Quad)
	ID_INSERT_U2002,	///	U+2002 (En Space)
	ID_INSERT_U2003,	///	U+2003 (Em Space)
	ID_INSERT_U2004,	///	U+2004 (Three-Per-Em Space)
	ID_INSERT_U2005,	///	U+2005 (Four-Per-Em Space)
	ID_INSERT_U2006,	///	U+2006 (Six-Per-Em Space)
	ID_INSERT_U2007,	///	U+2007 (Figure Space)
	ID_INSERT_U2008,	///	U+2008 (Punctuation Space)
	ID_INSERT_U2009,	///	U+2009 (Thin Space)
	ID_INSERT_U200A,	///	U+200A (Hair Space)
	ID_INSERT_ZWSP,		///	ZWSP (Zero Width Space)
	ID_INSERT_NNBSP,	///	NNSBP (Narrwow No-Break Space)
	ID_INSERT_MMSP,		///	MMSP (Medium Mathematical Space)
	ID_INSERT_U3000,	///	U+3000 (Ideographic Space)
	ID_INSERT_NEL,		///	NEL (Next Line)
	ID_INSERT_LS,		///	LS (Line Separator)
	ID_INSERT_PS,		///	PS (Paragraph Separator)
};

// ^C} ID
///	}EXhbOőI͈͂ύX
const UINT	TIMERID_EXPANDSELECTION		= 0;
///	}EXhbOőIsύX
const UINT	TIMERID_EXPANDLINESELECTION	= 1;
///	OLE hbO
const UINT	TIMERID_DRAGSCROLL			= 2;
///	c[`bv̑҂
const UINT	TIMERID_CALLTIP				= 3;
///	ss
const UINT	TIMERID_LINEPARSE			= 4;

/**
 *	@brief	R}h̎
 *
 *	R}h̓GfB^̂鑀̒PʁBNCAg͂̃R}hŝ
 *	CEditView::ExecCommand gB܂AGfB^ł̓R}hPʂŃAhDA
 *	hDAL[}NL^/Đ/ۑsBeR}h̎ CEditView::CmdXXXX sB
 *	el̐̊ʓ̓R}ḧƂ̌^
 */
enum CommandIdentifier {
	///	I͈͂1O̕폜
	CMDID_EDIT_BACKSPACE,
	///	݂̉sR[hŉs
	CMDID_EDIT_BREAK,
	/// ̓ (̃R[h|Cg : unsigned long)
	CMDID_EDIT_CHAR,
	///	1̍s̓ʒu̕
	CMDID_EDIT_CHARABOVELINE,
	///	1̍s̓ʒu̕
	CMDID_EDIT_CHARBELOWLINE,
	///	R[h|Cg𕶎ɕϊ
	CMDID_EDIT_CHARTOCODEPOINT,
	///	R[h|Cgɕϊ
	CMDID_EDIT_CODEPOINTTOCHAR,
	///	Rs[ (Nbv{[hOɂ邩 : bool)
	CMDID_EDIT_COPY,
	///	؂ (Nbv{[hOɂ邩 : bool)
	CMDID_EDIT_CUT,
	///	I͈͂1̕폜
	CMDID_EDIT_DELETE,
	///	ݍs폜
	CMDID_EDIT_DELETELINE,
	///	̒P̐擪܂ō폜
	CMDID_EDIT_DELETETONEXTWORD,
	///	O̒P̐擪܂ō폜
	CMDID_EDIT_DELETETOPREVWORD,
	///	1s}
	CMDID_EDIT_INSERTPREVLINE,
	///	I͈͂Ls^CY
	CMDID_EDIT_MAKESELCAPITAL,
	///	I͈͂ɕϊ
	CMDID_EDIT_MAKESELLOWER,
	///	I͈͂啶ɕϊ
	CMDID_EDIT_MAKESELUPPER,
	///	P͌
	CMDID_EDIT_OPENCANDIDATEWINDOW,
	///	\t
	CMDID_EDIT_PASTE,
	///	Nbv{[hO\t
	CMDID_EDIT_PASTEFROMCLIPBOARDRING,
	///	ĕϊ
	CMDID_EDIT_RECOMPOSESELECTION,
	///	蒼
	CMDID_EDIT_REDO,
	/// ͕̓ ###  (ϊ̎ : NextCharConvert)
	CMDID_EDIT_SETNEXTINPUTCONVERT,
	/// Xy[XCfg (Cfgx : unsigned short)
	CMDID_EDIT_SPACEINDENT,
	/// Xy[XtCfg (Cfgx : unsigned short)
	CMDID_EDIT_SPACEUNINDENT,
	///	I͈͂̋󔒂^uɕϊ
	CMDID_EDIT_TABIFY,
	/// ^uCfg (Cfgx : unsigned short)
	CMDID_EDIT_TABINDENT,
	/// ^utCfg (Cfgx : unsigned short)
	CMDID_EDIT_TABUNINDENT,
	///	̓ ( : wchar_t*)
	CMDID_EDIT_TEXT,
	///	IME J/IME 
	CMDID_EDIT_TOGGLEIMESTATUS,
	///	}/㏑[h̕ύX
	CMDID_EDIT_TOGGLEOVERTYPEMODE,
	///	̓ւ
	CMDID_EDIT_TRANSPOSECHARS,
	///	s̓ւ
	CMDID_EDIT_TRANSPOSELINES,
	///	P̓ւ
	CMDID_EDIT_TRANSPOSEWORDS,
	///	ɖ߂
	CMDID_EDIT_UNDO,
	///	I͈͂̃^u󔒂ɕϊ
	CMDID_EDIT_UNTABIFY,

	///	̃ubN}[N
	CMDID_MOVE_BOOKMARKNEXT,
	///	ÕubN}[N
	CMDID_MOVE_BOOKMARKPREV,
	///	I
	CMDID_MOVE_CANCELSELECTION,
	///	w蕶Ɉړ (ړ : unsigned long)
	CMDID_MOVE_CHARNEXT,
	///	w蕶܂őI (g : unsigned long)
	CMDID_MOVE_CHARNEXTEXTEND,
	///	w蕶OɈړ (ړ : unsigned long)
	CMDID_MOVE_CHARPREV,
	///	w蕶O܂őI (g : unsigned long)
	CMDID_MOVE_CHARPREVEXTEND,
	///	Ɉړ
	CMDID_MOVE_END,
	///	܂őI
	CMDID_MOVE_ENDEXTEND,
	///	Ɉړ
	CMDID_MOVE_HOME,
	///	܂őI
	CMDID_MOVE_HOMEEXTEND,
	///	CN^ (OȂ trueAȂ false : bool)
	CMDID_MOVE_INCREMENTALSEARCH,
	/// wsɈړ (ړs : unsigned long)
	CMDID_MOVE_LINEDOWN,
	///	ws܂őI (gs : unsigned long)
	CMDID_MOVE_LINEDOWNEXTEND,
	///	sɈړ
	CMDID_MOVE_LINEEND,
	///	s܂őI
	CMDID_MOVE_LINEENDEXTEND,
	///	sɈړ
	CMDID_MOVE_LINEHOME,
	///	s܂őI
	CMDID_MOVE_LINEHOMEEXTEND,
	/// wsɈړ (ړs : unsigned long)
	CMDID_MOVE_LINEUP,
	///	ws܂őI (gs : unsigned long)
	CMDID_MOVE_LINEUPEXTEND,
	///	ΊʂɈړ
	CMDID_MOVE_MATCHBRACKET,
	///	Ίʂ܂ňړ
	CMDID_MOVE_MATCHBRACKETEXTEND,
	///	wy[WɈړ (ړy[W : unsigned long)
	CMDID_MOVE_PAGEDOWN,
	///	wy[W܂őI (gy[W : unsigned long)
	CMDID_MOVE_PAGEDOWNEXTEND,
	///	wy[WɈړ (ړy[W : unsigned long)
	CMDID_MOVE_PAGEUP,
	///	wy[W܂őI (gy[W : unsigned long)
	CMDID_MOVE_PAGEUPEXTEND,
	///	̕܂őIgA`IJn
	CMDID_MOVE_ROWCHARNEXT,
	///	O̕܂őIgA`IJn
	CMDID_MOVE_ROWCHARPREV,
	///	̍s܂őIgA`IJn
	CMDID_MOVE_ROWLINEDOWN,
	///	s܂őIgA`IJn
	CMDID_MOVE_ROWLINEEND,
	///	s܂őIgA`IJn
	CMDID_MOVE_ROWLINEHOME,
	///	̍s܂őIgA`IJn
	CMDID_MOVE_ROWLINEUP,
	///	̒P̏I[܂őIgA`IJn
	CMDID_MOVE_ROWWORDENDNEXT,
	///	O̒P̏I[܂őIgA`IJn
	CMDID_MOVE_ROWWORDENDPREV,
	///	̒P̐擪܂őIgA`IJn
	CMDID_MOVE_ROWWORDNEXT,
	///	O̒P̐擪܂őIgA`IJn
	CMDID_MOVE_ROWWORDPREV,
	///	SđI
	CMDID_MOVE_SELECTALL,
	///	݂̒PI
	CMDID_MOVE_SELECTCURRENTWORD,
	///	̒P̏I[Ɉړ (ړꐔ : unsigned long)
	CMDID_MOVE_WORDENDNEXT,
	///	̒P̏I[܂őI (gꐔ : unsigned long)
	CMDID_MOVE_WORDENDNEXTEXTEND,
	///	O̒P̏I[Ɉړ (ړꐔ : unsigned long)
	CMDID_MOVE_WORDENDPREV,
	///	O̒P̏I[܂őI (gꐔ : unsigned long)
	CMDID_MOVE_WORDENDPREVEXTEND,
	///	̒P̐擪Ɉړ (ړꐔ : unsigned long)
	CMDID_MOVE_WORDNEXT,
	///	̒P̐擪܂őI (gꐔ : unsigned long)
	CMDID_MOVE_WORDNEXTEXTEND,
	///	O̒P̐擪Ɉړ (ړꐔ : unsigned long)
	CMDID_MOVE_WORDPREV,
	///	O̒P̐擪܂őI (gꐔ : unsigned long)
	CMDID_MOVE_WORDPREVEXTEND,

	///	1EփXN[
	CMDID_SCROLL_COLUMNNEXT,
	///	1񍶂փXN[
	CMDID_SCROLL_COLUMNPREV,
	///	ŏIsփXN[
	CMDID_SCROLL_END,
	///	Lbgɗ悤ɃXN[
	CMDID_SCROLL_ENSURECARETCENTERED,
	///	LbgɂȂ悤ɃXN[
	CMDID_SCROLL_ENSURECARETVISIBLE,
	///	擪sփXN[
	CMDID_SCROLL_HOME,
	///	1sփXN[
	CMDID_SCROLL_LINEDOWN,
	///	1sփXN[
	CMDID_SCROLL_LINEUP,
	///	1y[WփXN[
	CMDID_SCROLL_PAGEDOWN,
	///	1y[WփXN[
	CMDID_SCROLL_PAGEUP,
};

///	sCxg
enum LineOperationEvent {
	///	s쐬ꂽ
	LOE_CREATED,
	///	s폜ꂽ
	LOE_DELETED,
	///	sύXꂽ
	LOE_MODIFIED
};

///	CN^̃Cxg
enum IncrementalSearchEvent {
	///	Jn
	ISE_STARTED,
	///	~
	ISE_ABORTED,
	///	
	ISE_COMPLETED,
	///	񂪕ς蕶񂪌
	ISE_STRING_CHANGED,
	///	񂪕ς蕶񂪌Ȃ
	ISE_STRING_NOT_FOUND
};

///	CN^̏
enum IncrementalSearchState {
	///	͍sĂȂ
	ISS_NOTRUNNING,
	///	O (̖) 
	ISS_FORWARD,
	///	 (̐擪) 
	ISS_BACKWARD
};

///	Cfg̎
enum AutoIndentType {
	///	Ȃ
	AIT_NONE,
	///	O̍sɈv
	AIT_BLOCK,
	///	`̃X}[gCfg
	AIT_SMART
};

///	\eLXg̎
///	@see	TokenType
enum EmphaticTextType {
	ETT_START = TT_COUNT,
	///	ʏ̃eLXg
	ETT_NORMAL = ETT_START,
	///	Ï (F̂ݗL)
	ETT_SELECTION,
	///	ANeBuÏ (F̂ݗL)
	ETT_INACTIVE_SELECTION,
	/// CWP[^}[W
	ETT_INDICATOR_MARGIN,
	/// sԍ
	ETT_LINENUMBER,
	///	sԍ
	ETT_EMPHATIC_LINENUMBER,
	///	ʂ̈v
	ETT_MATCH_BRACKETS,
	///	s
	ETT_END_OF_LINE,
	///	t@C̏I[
	ETT_END_OF_FILE,
	///	N (AĝݗL)
	ETT_LINK,
	///	veLXg
	ETT_MATCHTEXT,
	ETT_COUNT
};

/// ɓ͂镶̕ϊ
enum NextCharConvert {
	/// ϊ
	NCC_NONE,
	/// ANZg
	NCC_GRAVE,
	/// sANZg
	NCC_ACUTE,
	/// Ȑ܃ANZg
	NCC_CIRCUMFLEX,
	/// @
	NCC_TILDE,
	/// EEg
	NCC_DIAERESIS,
	/// ZfB[
	NCC_CEDILLA,
	///	t
	NCC_SUPERSCRIPT,
	///	t
	NCC_SUBSCRIPT
};

/// ҏW̎
enum EditOperationType {
	/// 
	EOT_NONE,
	/// ^CsO
	EOT_TYPING,
	/// 폜
	EOT_DELETE,
	/// ㏑
	EOT_REPLACE,
	/// \t
	EOT_PASTE,
};

///	CmdEditConvertSel ̕ϊ[h
enum SelConvertType {
	///	啶
	SCT_UPPERCASE,
	///	啶珬
	SCT_LOWERCASE,
	///	Ls^CY (P̐擪啶)
	SCT_CAPITALIZE,
};

/// ܂Ԃ[h
enum WrapMode {
	/// ܂ԂȂ
	WPM_NONE,
	/// w蕝Ő܂Ԃ
	WPM_SPECIFIED,
	/// EBhEŐ܂Ԃ
	WPM_WINDOW
};

/// gAC̎
enum BorderType {
	/// 
	BT_NONE,
	/// ̉
	BT_UNDERLINE_SOLID,
	///	̉
	BT_UNDERLINE_BOLD,
	/// j̉
	BT_UNDERLINE_DASHED,
	///	j̉
	BT_UNDERLINE_BOLDDASHED,
	/// _̉
	BT_UNDERLINE_DOTTED,
	///	_̉
	BT_UNDERLINE_BOLDDOTTED,
	/// g̉
	BT_UNDERLINE_WAVED,
	///	̘g
	BT_BORDER_SOLID,
	///	j̘g
	BT_BORDER_DASHED,
	///	_̘g
	BT_BORDER_DOTTED,
};

/// ҏWP
struct TEditOperation {
	EditOperationType	type;	// ̎
	CCharPos			pos;	// sʃLbgړʒu

	void set(EditOperationType type_, const CCharPos& pos_) {
		type = type_;
		pos = pos_;
	}
};

///	sԍ̕\`
struct TLineNumberLayout {
	enum BorderStyle {LNBS_NONE, LNBS_SOLID, LNBS_DASHED, LNBS_DASHED_ROUNDED, LNBS_DOTTED};
	bool			bLeftAlign;				///	񂹂̏ꍇ trueBE񂹂̏ꍇ false
	bool			bShowLineNumbers;		///	sԍ\
	unsigned char	cMinimumDigits;			///	sԍ̍ŏ
	bool			bShowIndicatorMargin;	///	CWP[^}[W\
	unsigned short	nIMWidth;				///	CWP[^}[W̕
	unsigned short	nBorderWidth;			///	؂̑
	BorderStyle		borderStyle;			///	؂̃X^C

	TLineNumberLayout() : bLeftAlign(false), bShowLineNumbers(false), cMinimumDigits(4),
			bShowIndicatorMargin(false), nIMWidth(15), nBorderWidth(1), borderStyle(LNBS_SOLID) {
	}
};

/// ̐FAȂ
struct TTextFoundation {
	COLORREF	fgColor;		/// OiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
	COLORREF	bgColor;		/// wiF (-1 ɂƃeLXg̎ނɉăVXe肩I)
	COLORREF	borderColor;	/// g̐F (-1 ɂ fgColor Ɠ)
	bool		italic;			/// Α
	bool		bold;			/// 
	BorderType	border;			/// g

	TTextFoundation() {
		set(-1, -1);
	}
	void set(COLORREF clrFore, COLORREF clrBg, COLORREF clrBorder = -1,
			bool bItalic = false, bool bBold = false, BorderType btBorder = BT_NONE) {
		fgColor = clrFore;
		bgColor = clrBg;
		borderColor = clrBorder;
		italic = bItalic;
		bold = bBold;
		border = btBorder;
	}
};

///	g[N̕\@
union UTokenFoundation {
	std::map<TokenCookie, TTextFoundation>*	pmapTfs;	///	L[[hARg͂gB
														///	NbL[lŊeg[NɃANZX
	TTextFoundation*						ptf;		///	ȊȌꍇ͒AC
};

///	Sg[N̕\@
struct TTokenFoundations {
	UTokenFoundation	tfs[ETT_COUNT];			///	eg[N̏C
	bool				arrEnabled[ETT_COUNT];	///	eg[N̏CL

	TTokenFoundations() {
		for(std::size_t i = 0; i < ETT_COUNT; ++i) {
			if(i != TT_KEYWORD && i != TT_ANNOTATION)
				tfs[i].ptf = new TTextFoundation();
			else
				tfs[i].pmapTfs = new std::map<TokenCookie, TTextFoundation>();
			arrEnabled[i] = true;
		}
	}
	~TTokenFoundations() {
		for(std::size_t i = 0; i < ETT_COUNT; ++i) {
			if(i != TT_KEYWORD && i != TT_ANNOTATION)	delete tfs[i].ptf;
			else									delete tfs[i].pmapTfs;
		}
	}
	TTextFoundation& GetToken(int type, TokenCookie nCookie) throw(std::invalid_argument) {
		if(type < TT_WHITESPACE || type >= ETT_COUNT)
			throw std::invalid_argument("...");
		if(type != TT_KEYWORD && type != TT_ANNOTATION)
			return *tfs[type].ptf;

		std::map<TokenCookie, TTextFoundation>::iterator	it;

		it = tfs[type].pmapTfs->find(nCookie);
		if(it == tfs[type].pmapTfs->end())
			throw std::invalid_argument("...");
		return it->second;
	}
};

///	CEditView::GetAllLineParams Ŏgp
struct TAppDefinedLine {
	/// _s
	length_t	iLine;
	/// AvP[V`l
	DWORD		dwParam;
};


/// r[̎GȐݒ
typedef unsigned short	EditViewOption;
/// OLE hbOAhhbvg
const EditViewOption	EVO_USE_OLEDRAGDROP			= 0x0001;
///	ݍsɉ\
const EditViewOption	EVO_SHOW_CURRENTUNDERLINE	= 0x0002;
///	s}[N\
const EditViewOption	EVO_SHOW_BREAKARROWS		= 0x0004;
///	EOF }[N\
const EditViewOption	EVO_SHOW_EOFMARK			= 0x0008;
///	󔒗ޕ\
const EditViewOption	EVO_SHOW_WHITESPACE			= 0x0010;
/// Unicode 䕶\ ()
const EditViewOption	EVO_SHOW_UNICODECTRLCHARS	= 0x0020;
///	IɑĂs̔wih
const EditViewOption	EVO_PAINTBREAKCONTINUINGSEL	= 0x0040;
///	tHggpɕԊu1
const EditViewOption	EVO_MAKECLOSEBOLDCHARS		= 0x0080;
///	\P⊮ő啶ʂȂ
const EditViewOption	EVO_IGNORECASE				= 0x0100;
///	L[{[hŃLbgړłȂ̑OɃ}EXňړł悤ɂ
const EditViewOption	EVO_ACCEPTABLECARETBYMOUSE	= 0x0200;
///	g[NPʂŃZbg
const EditViewOption	EVO_RESETDIRECTIONBYTOKEN	= 0x0400;
///	ENbNŃLbgړ
const EditViewOption	EVO_RIGHTCLICKTOMOVECARET	= 0x0800;
///	ׂLbgg (ł͕2)
const EditViewOption	EVO_USE_THINCARET			= 0x1000;
///	Ctrl + NbNŋN\ȃNeLXgŃnhJ[\\
const EditViewOption	EVO_SHOW_HANDONLINK			= 0x2000;
///	Ctrl + NbNŋN\ȃNeLXgŃc[`bv|bvAbv
const EditViewOption	EVO_SHOW_HINTONLINK			= 0x4000;


///	CEditView ̐ݒ荀
struct TEditViewOption {
	///	Cfg̎
	AutoIndentType	aitAutoIndentType;
	///	Jnsԍ
	length_t		iStartLine;
	///	Jnsԍ
	length_t		iStartChar;
	///	X}[gCfgΊʌōls
	length_t		cRecognizingLines;
	///	^ȗ֕
	char_t			chTabAlternative;
	///	SpXy[X (U+3000) ̑֕
	char_t			chIdeographicSpaceAlternative;
	///	̑̋󔒗ޕ̑֕
	char_t			chWhitespaceAlternative;
	///	EOF }[N̕
	string_t		strEndOfFile;
	///	̑̐ݒ
	EditViewOption	evoMiscellaneous;
};


// IEditViewEventListener interface definition
/////////////////////////////////////////////////////////////////////////////

///	CEditView CX^X̃Cxgnh
interface IEditViewEventListener {
	///	fXgN^
	virtual ~IEditViewEventListener() {}
	/**
	 *	LbgO̒PꂪZkƂēWJ\ȏԂɂȂ
	 *	@param bReady		WJ\ȏԂɂȂƂ trueBWJ\ȏԂ甲Ƃ false
	 *	@param strAbbrev	ZkB<var>bReady</var>  false ̂Ƃ͋󕶎
	 *	@see				CEditView::GetPrecedingWord ACEditView::ExpandAbbreviation
	 */
	virtual void	OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) = 0;
	/**
	 *	уCWP[^}[W`ɌĂяo
	 *	@param iLine			_s
	 *	@param oDC				foCXReLXgB<strong>߂Oɑɖ߂</strong>
	 *	@param rectMargin		`͈
	 *	@param bBookmarked		̍sɃubN}[Nݒ肳Ă邩
	 *	@param dwParam			̍s̃AvP[V`l
	 *	@param bSingleEmphasis	̍sB̋\s
	 */
	virtual void	OnDrawIndicatorMargin(length_t iLine, Manah::Windows::GDI::CMinimalDC& oDC,
						const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) = 0;
	/**
	 *	CN^Cxg
	 *	@param event	Cxg̎ށB񋓎Q
	 *	@param pwsz		̕
	 */
	virtual void	OnIncrementalSearchEvent(IncrementalSearchEvent event, const char_t* pwsz) = 0;
	/**
	 *	URI NƂɌĂяo
	 *	@param strUri	URI
	 */
	virtual void	OnInvokeUriLink(const char_t* pwszUri) = 0;
	/**
	 *	s쐬A폜AύXꂽ
	 *	@param iLine	擪s (_s)
	 *	@param cLines	Ώۍs
	 */
	virtual void	OnLineOperationEvent(LineOperationEvent event, length_t iLine, length_t cLines) = 0;
	/**
	 *	t@CǂݍŁÃx̍s͂sOɌĂяoB
	 *	IuWFNg͂̃\bhĂяoAǂݍ񂾃t@C݂Ƃďi߂̂ŁA
	 *	̃nhŊJꂽt@CÃt@CJ肵Ă͂ȂB
	 *	͑OɎ͊ɋKACAEg}l[Wɋ\^̂Ɏgp
	 */
	virtual void	OnLoadFile() = 0;
	/**
	 *	Lbgړ
	 *	@param pos	ړ̃Lbgʒu
	 */
	virtual void	OnMoveCaret(const CCharPos& pos) = 0;
	/**
	 *	}EXJ[\ړ
	 *	@param pt	NCAgW
	 */
	virtual void	OnMoveCursor(const POINT& pt) = 0;
	/**
	 *	s`OɑOiFƔwiF₢킹
	 *	@param iLine			_s
	 *	@param bBookmarked		̍sɃubN}[Nݒ肳Ă邩
	 *	@param dwParam			̍s̃AvP[V`l
	 *	@param bSingleEmphasis	̍sB̋\s
	 *	@param clrFore			OiFB-1ԂƒʏʂF (Ăяoɂ-1ZbgĂ)
	 *	@param clrBack			wiFB-1ԂƒʏʂF (Ăяoɂ-1ZbgĂ)
	 */
	virtual void	OnQueryLineColor(length_t iLine, bool bBookmarked, DWORD dwParam,
						bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) = 0;
};


// CEditViewEventAdapter class definition
/////////////////////////////////////////////////////////////////////////////

///	IEditViewEventListener ̋
class CEditViewEventAdapter : virtual public IEditViewEventListener {
public:
	virtual ~CEditViewEventAdapter() {};
	virtual void	OnChangedAbbreviationExpansionReadyState(bool bReady, const string_t& strAbbrev) {}
	virtual void	OnDrawIndicatorMargin(length_t iLine, Manah::Windows::GDI::CMinimalDC& oDC,
						const RECT& rectMargin, bool bBookmarked, DWORD dwParam, bool bSingleEmphasis) {}
	virtual void	OnIncrementalSearchEvent(IncrementalSearchEvent event, const char_t* pwsz) {}
	virtual void	OnInvokeUriLink(const char_t* pwszUri) {}
	virtual void	OnLineOperationEvent(LineOperationEvent event, length_t iLine, length_t cLines) {}
	virtual void	OnLoadFile() {}
	virtual void	OnMoveCaret(const CCharPos& pos) {}
	virtual void	OnMoveCursor(const POINT& pt) {}
	virtual void	OnQueryLineColor(length_t iLine, bool bBookmarked, DWORD dwParam,
						bool bSingleEmphasis, COLORREF& clrFore, COLORREF& clrBack) {}
};


// CClipboardRing class definition
/////////////////////////////////////////////////////////////////////////////

///	1̃Nbv{[heLXg\\
struct TClipText {
	///	eLXg
	string_t	strText;
	///	`f[^
	bool		bBox;
};

///	Nbv{[hOCxg
interface IClipboardRingEventListener {
	///	fXgN^
	virtual ~IClipboardRingEventListener() {}
	///	eLXg̃XgύXꂽ
	virtual void	OnClipboardRingChanged() = 0;
	///	CClipboardRing::Add \bhŒǉ悤ƂeLXg傫߁A󂯓ꂪۂꂽ
	virtual void	OnClipboardRingDeniedAdding() = 0;
};

///	Nbv{[hO
class CClipboardRing : public Manah::CObject {
	// ^`
public:
	typedef unsigned char	size_type;

	// RXgN^
public:
	CClipboardRing();

	// \bh
public:
	void		Add(const string_t& strText, bool bBox);
	void		AddEventListener(IClipboardRingEventListener* pEventListener);
	void		Delete(size_type iText) throw(std::out_of_range);
	void		DeleteAll();
	size_type	GetActiveItem() const;
	size_type	GetCount() const;
	void		GetText(size_type iText, string_t& strText, bool& bBox) const throw(std::out_of_range);
	void		LimitCount(size_type nLimit);
	void		SetActiveItem(size_type iText) throw(std::out_of_range);

	// f[^o
private:
	std::list<TClipText>					m_listDatas;
	size_type								m_nLimit;
	unsigned long							m_nMaxByte;
	size_type								m_iActive;
	std::set<IClipboardRingEventListener*>	m_setEventListeners;
};


// CEditView class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	Ascension eLXgGfB^̃r[
 *
 *	<h3>KvpA</h3>
 *
 *	<ul>
 *		<li>OLE hbOAhhbvgpꍇ́A
 *	gݍ݃AvP[VXbh OleInitialize API ĂяoĂKvB</li>
 *		<li>c[`bvgꍇ InitCommonControlsEx ĂяoĂKvB</li>
 *		<li>̓\yуC^[tFCX͑S Unicode gp邽߁A
 *	 Windows NT n݂̂ƂȂB</li>
 *		<li>̃NX͌_ł̓XbhZ[tł<strong>Ȃ</strong>B</li>
 *		<li> Unicode 4.0 ̒`ɂ͏]ĂȂB</li>
 *	</ul>
 *
 *	eLXgGfB^ƂĎgꍇ CEditView ACEditDoc 𒼐ڃCX^XA
 *	CEditController gق悢
 *
 *	<h3>p</h3>
 *
 *	̃NXŎgpP̒`͈ȉ̂Ƃ:
 *	<dl>
 *		<dt>AJ[|Cg</dt><dd>IJn_BLbg</dd>
 *		<dt>ANeBu|Cg</dt><dd>II_BLbg</dd>
 *		<dt>P (Char)</dt><dd>Ch11P</dd>
 *		<dt>P (Column)</dt><dd>Œ蕝tHg̔p11P</dd>
 *		<dt>XN[W</dt><dd>XN[̍オ_</dd>
 *		<dt>NCAgW (Pos)</dt><dd>CEditView EBhE̍オ_</dd>
 *		<dt>r[W</dt><dd>NCAgW + (ѕ, 0)</dd>
 *	</dl>
 *
 *	<h3>Rs[RXgN^ɂ镡ɂ (To deriver)</h3>
 *
 *	CEditView ̑cNX͑SăRs[RXgN^ĂA
 *	̃NXłRs[RXgN^găr[𕡐邱Ƃo (
 *	cNXƓlEBhE͍쐬Ȃ)Bf[^oɑ
 *	̃NX͈ꕔ̃o𕡐ƕŋL
 *
 *	̓Rs[RXgN^̉EӂŁALf[^o<strong>L</strong>B
 *	LȂr[폜ĂLf[^͔jȂA
 *	Lr[폜ƁAL͂̃r[畡ꂽ̃r[ɈڂB
 *	čŌɎcr[폜ꂽƂALf[^͔j󂳂B
 *	̂߃Rs[RXgN^ł͕̃r[A
 *	̃r[IWĩr[LB܂A
 *	r[͎j󂳂ꂽƂɃIWiɒʒm
 *
 *	܂ALێr[͎ɑ΂ݒ̍XV𑼂̃r[ɒʒmƂڂB
 *	NCAgr[̖{IłȂݒ (tHgsԊuAAvP[V`sȂ)
 *	Lr[ɑ΂čsƁAIɕ̃r[ɂf̂ŁA
 *	NCAg͂֘ASẴr[ݒ肷Kv͖
 *
 *	CEditController NXŕsꍇ2̃r[͂̕[ɏ]B
 *	L̂͊{Iɍŏ̃r[ANX CEditController::GetPrimaryView
 *	\bhŊmɏLr[擾ł
 *
 *	<strong>Rs[RXgN^ɂĕꂽr[́A
 *	ɂŏqׂ悤ȕÅ֌W</strong>ƂƂɒӂȂ΂ȂȂ
 *
 *	<h3>`̓Ɖ</h3>
 *
 *	܂Ƃ܂sۂɑSĂ̒iKŕ`sĂƓ삪xȂ̂ŁA
 *	CEditView ͕`̓s߂ CEditView::Freeze \bhA
 *	邽߂ CEditView::Unfreeze \bh2pӂĂB
 *	ACEditView::InvalidateLine ACEditView::InvalidateLines
 *	͑ɂ͍ĕ`s킸A`̕KvȍsL^ĂA
 *	ƂɈxɕ`sB̂ CEditView ̂قƂǂ̑
 *	CWindow::InvalidateRect 𒼐ڌĂяôł͂ȂAL2̃\bhōĕ`s
 *
 *	֐̂߂ɓƂ̉s\bh͎̕A
 *	/s (J CEditView::_Unfreeze g)
 *
 *	@see	CEditDoc, CEditController
 */
class CEditView :
		public Manah::Windows::CView,
		public Armaiti::IUnknownImpl<Armaiti::NoRefCount>,
		virtual public IDropSource,
		virtual public IDropTarget {

	///	{^ǂ̂悤ȖړIŉĂ邩\
	enum LeftDownMode {
		LDM_NONE,				// ĂȂ
		LDM_SELECTION,			// `I
		LDM_BOXSELECTION,		// `I
		LDM_LINESELECTION,		// sI
		LDM_WORDSELECTION,		// PI
		LDM_DRAGANDDROP,		// vZX̃hbOAhhbv
		LDM_DRAGANDDROPSELF,	// vZX̃hbOAhhbv
		LDM_DRAGANDDROPBOXSELF	// vZX̃hbOAhhbv (`)
	};

	///	I̓ (LeftDownMode Ƃ͖֌W)
	enum SelectionTraits {
		ST_NORMAL					= 0x00,	// ɂȂAʏ
		ST_RECTANGLE				= 0x01,	// `I
		ST_PASTINGFROMCLIPBOARDRING	= 0x02,	// Nbv{[hO̐؂ւ
	};

	friend class CEditController;
	friend class CLineLayoutManager;
	friend class CEditPoint;
	friend class CBoundarySearcher;
	friend class CAutoCompleteWnd;

	// f[^o
private:
	static bool								m_bRegistered;			// EBhENX̓o^tO
	static CClipboardRing					m_oClipboardRing;		// Nbv{[hO
	static CTextSearcher					m_oTextSearcher;		// eLXg
	static std::map<string_t, string_t>		m_mapAbbreviations;		// Zk -> WJ̃̕}bv
	static length_t							m_cchMaxAbbreviation;	// ԒZk̕
	HMENU									m_hContextMenu;			// ReLXgj[
	HWND									m_hwndToolTip;			// c[`bv
	char_t*									m_pwszTipText;			// c[`bṽeLXg
	CBoundarySearcher*						m_pBoundarySearcher;	// eLXgĚ
	Armaiti::OLE::CDraggingTextDataObject*	m_pDragging;			// OLE hbOIuWFNg
	CKeyMacroPlayer*						m_pKeyMacroPlayer;		// L[}N̊Ǘ
	CAutoCompleteWnd*						m_pwndAutoComplete;		// ͕⊮EBhE
	std::set<IEditViewEventListener*>*		m_pEventListeners;		// CxgXi (̋L)
	std::set<CEditPoint*>					m_setEditPoints;		// ێĂҏW_
	CLineLayoutManager*						m_pLineLayoutManager;	// ܂ԂȂǂ̍sCAEg (̋L)
	TTokenFoundations*						m_pTokenFoundations;	// g[N̏C (̋L)

	/* LÂ̊Ǘ (NX̐Q) */
	CEditView*		m_pOriginalView;		//  (this łΎ)
	std::set<CEditView*>	m_setClones;	// ̕

	/* CAEg */
	struct TEditViewLayout {	// CAEg܂Ƃ߂邾̍\
		bool			bThinCaret;				// 1̃Lbggꍇ true
		unsigned int	nLineHeight;			// s̍ (ʁA)
		unsigned int	nCharHeight;			// ̍
		unsigned int	nCharWidth;				// p ()  (m_nLineHeight  API ŎIɎZo)
		int				nCharSpan;				// ̊Ԋu
		unsigned short	nTabWidth;				// ^u (pP)
		unsigned int	nLeftMargin;			// ]
		unsigned int	nTopMargin;				// ]
		unsigned int	nLeftTabWidth;			//  (sԍubN}[N\邽߂) ^uɕKvȒ
		unsigned int	nHScrollRatio;			// XN[1r[̉ɑ邩 (ʂ1)
		unsigned int	nVScrollRatio;			// XN[1sr[̉sɑ邩 (ʂ1)
		RECT			rectUpdate;				// OnPaint ŗLȍXV̈
		CCharPos		posHilightedBrackets[2];// \Ίʂ̈ʒu (ꍇ CCharPos(-1, -1))
		std::wstring	strFontFace;			// ̃tHg
		COLORREF		clrUnderline;			// ݍsɕ\鉺̐F
		COLORREF		clrIAUnderline;			// ANeBuɌݍsɕ\鉺̐F
		CLineLayout*	pAppDefinedSingleLine;	// AvP[V`s (Ps)
		length_t		iBoxSelectionAnchorLine;// `ĨAJ[|Cg̕\s
		length_t		iBoxSelectionActiveLine;// `ĨANeBu|Cg̕\s
		length_t		xBoxSelectionAnchor;	// `ĨAJ[|Cg̃r[ x W
		length_t		xBoxSelectionActive;	// `ĨANeBu|Cg̃r[ x W
		TLineNumberLayout	lineNumberLayout;	// sԍ̕\@

		TEditViewLayout() : bThinCaret(false),
				nLineHeight(12), nCharHeight(12), nCharWidth(7),
				nCharSpan(0), nTabWidth(4),
				nLeftMargin(5), nTopMargin(1), nHScrollRatio(1), nVScrollRatio(1),
				clrUnderline(-1), clrIAUnderline(-1), pAppDefinedSingleLine(0) {
					posHilightedBrackets[0] =
					posHilightedBrackets[1] = CCharPos(-1, -1);
		}
	} m_layoutInfo;

	/* [h */
	struct TEditViewModeState {
		SelectionTraits	selectionTraits;		// ݂̑I̓
		bool			bOvertype;				// ㏑[h
		bool			bRtlReading;			// E獶ɓǂނǂ
		bool			bResetDirByToken;		// g[NƂɕZbg邩ǂ
		bool			bShowUnicodeCtrls;		// Unicode 䕶\邩ǂ ()
		bool			bCaretExtenderByMouse;	// Lbg󂯎Ȃ̑OɃ}EXňړł
		bool			bRClickToMoveCaret;		// ENbNŃLbgړ
		bool			bShowHandOnLink;		// NeLXgŃnhJ[\\
		bool			bShowHintOnLink;		// NeLXgŃ|bvAbv\
		bool			bHighlightSearchText;	// ʂɈveLXg\
		WrapMode		wpmWrapMode;			// ݂̐܂Ԃ[h (WordWrapMode `Q)
		int				nWrapWidth;				// w蕝Ő܂ԂƂ1s̕\ (ϕ*)
		length_t		iStartLine;				// Jnsԍ
		length_t		iStartChar;				// Jnԍ
		bool			bUseOLEDragDrop;		// OLE hbOAhhbvgǂ
		AutoIndentType	aitAutoIndentType;		// Cfg̎
		length_t		cFindLimit;				// X}[gCfggpɉsO܂ł̊ʂɑΉ邩

		bool		bReadyToExpandAbbrev;		// ZkWJł

		IncrementalSearchState	incrementalSearchState;	// CN^̏
		CCharPos				posBeforeISearch;		// CN^n߂Öʒu
		string_t				strISearchText;			// CN^̕

		TEditViewModeState() : selectionTraits(ST_NORMAL), bOvertype(false), bRtlReading(false),
			bResetDirByToken(true), bShowUnicodeCtrls(false),
			bCaretExtenderByMouse(false), bRClickToMoveCaret(false),
			bShowHandOnLink(false), bShowHintOnLink(true), bHighlightSearchText(false),
			wpmWrapMode(WPM_NONE), nWrapWidth(100), iStartLine(1), iStartChar(1),
			bUseOLEDragDrop(true), aitAutoIndentType(AIT_BLOCK), cFindLimit(100),
			bReadyToExpandAbbrev(false), incrementalSearchState(ISS_NOTRUNNING) {
		}
	} m_modeState;

	/* ⊮ */
	struct TAutoComplete {
		length_t	iCurrentLine;		// ͌EBhE\̍s
		length_t	iStartWordStart;	// ͌EBhE\OɂP̐擪ʒu
		length_t	iStartChar;			// ͌EBhE\̃Lbg̕ʒu
	} m_AutoComplete;

	bool				m_bActiveIMEComposition;	// IME œ͒
	LeftDownMode		m_ldmLeftDown;				// LeftDownMode `Q
	NextCharConvert		m_nccNextCharConvert;		// NextCharConvert `Q
	TEditOperation		m_eoLast;					// OɍsҏW
	unsigned long		m_nFreezeCount;				// t[YJE^ (0ȊOłΕ`擀)
	std::set<length_t>	m_setInvalidLines;			// t[Yɍĕ`vꂽsB
													// InvalidateLine(s)  OnUpdate Ǘ

	/* ݈ʒu */
	CVisibleEditPoint*	m_pAnchorPoint;	// IJnʒu (AJ[|Cg)
	CVisibleEditPoint*	m_pActivePoint;	// IIʒu (ANeBu|CgALbgʒu)
	POINT			m_ptScroll;			// XN[o[̈ʒu (x:Ay:)B
										// ̒l m_nHScrollRatio  m_nVScrollRatio 悸
										// \Jnʒu (:ϕPʁA:\sP) 
	length_t		m_iFirstVisibleLine;// ݂̐擪s (_sB\s m_ptScroll.y)B
										// _s<->\sϊ̂߂̃LbV
										// cXN[ (OnVScroll)A܂Ԃ񂪕ωƂ (OnSize,
										// ModifyFontInfo)A\Jn_sO̍sҏWꂽƂ
										// (OnUpdate) XV <- !݂͎gĂȂ!

	/* \ */
	struct TEditViewFoundationInfo {
		bool		bDrawCurrentUnderline;	// ݍs̉`悷邩ǂ
		bool		bDrawBreakArrow;		// s̖`悷邩ǂ
		bool		bDrawEOF;				// [EOF]`悷邩ǂ
		bool		bDrawSpaces;			// 󔒂̑֕`悷邩ǂ
		bool		bIgnoreCaseOnHilite;	// \RgJn/I񌟍ɑ啶ʂȂ
		bool		bPaintBreakContinuingSelection;	///	IɑĂs̔wih邩ǂ
		bool		bDrawBoldCharsClosely;	// l߂ĕ`悷邩ǂ
		char_t		chTab;					// ^ȗ֕
		char_t		chIdeographicSpace;		// Sp󔒂̑֕
		char_t		chSpace;				// ̑̋󔒗ޕ̑֕
		string_t	strEndOfFile;			// [EOF] }[N̕

		TEditViewFoundationInfo();
		TEditViewFoundationInfo(const TEditViewFoundationInfo& rhs);
		~TEditViewFoundationInfo();
	} m_foundationInfo;

	/* GDI IuWFNg */
	struct TEditViewGDIObjects {
		Manah::Windows::GDI::CMinimalDC	oMemDC;	// EBhE DC Ɍ݊̂郁 DC (CEditView::Create 1񂾂쐬)
		HBITMAP	hMemLineBMP;	// 1s`̃rbg}bv (OnSize Ŕj/쐬)
		HBITMAP	hMemLeftTabBMP;	// т̃rbg}bv (SetLeftTabType AOnSize Ŕj/쐬)
		HPEN	hUnderlinePen;	// ݍs̉
		HPEN	hIAUnderlinePen;// ݍs̉ (ANeBu)
		HPEN	hLeftIndicatorPen;	// LTT_INDICATOR [hɍт`̂Ɏgp
		HPEN	hLineNumberPen;	// LTT_LINENUMBER [hɍт`̂Ɏgp
		HPEN	hColumnPen;		// TTT_COLUMNNUMBER [hɏт`̂Ɏgp
		HPEN	hWhiteSpacePen;	// 󔒗ޕ (̑փrbg}bv) `̂Ɏgp
		HPEN	hLineBreakPen;	// s}[N`̂Ɏgp
		HFONT	hNormalFont;	// ̖WtHgBvZɂgp
		HFONT	hBoldFont;		// `ɎgptHg
		HFONT	hItalicFont;	// C^bN̕`ɎgptHg
		HFONT	hBoldItalicFont;// C^bN̕`ɎgptHg

		TEditViewGDIObjects() : hMemLineBMP(0), hMemLeftTabBMP(0),
			hUnderlinePen(0), hIAUnderlinePen(0), hLeftIndicatorPen(0), hLineNumberPen(0), hColumnPen(0),
			hWhiteSpacePen(0), hLineBreakPen(0),
			hNormalFont(0), hBoldFont(0), hItalicFont(0), hBoldItalicFont(0) {
		}
		~TEditViewGDIObjects() {
			::DeleteObject(hMemLineBMP);
			::DeleteObject(hMemLeftTabBMP);
			::DeleteObject(hUnderlinePen);
			::DeleteObject(hIAUnderlinePen);
			::DeleteObject(hLeftIndicatorPen);
			::DeleteObject(hLineNumberPen);
			::DeleteObject(hColumnPen);
			::DeleteObject(hWhiteSpacePen);
			::DeleteObject(hLineBreakPen);
			::DeleteObject(hNormalFont);
			::DeleteObject(hBoldFont);
			::DeleteObject(hItalicFont);
			::DeleteObject(hBoldItalicFont);
		}
	} m_gdiObjects;

protected:
	static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK CandidateWordListProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// RXgN^
public:
	CEditView();
	CEditView(const CEditView& rhs);
	virtual ~CEditView();

	// Zq
private:
	/// gpȂ
	CEditView& operator =(const CEditView& rhs);

	// \bh
public:
	// 쐬
	virtual bool	Create(HWND hwndParent, const RECT* pRect,						// EBhE쐬
						DWORD dwStyle, DWORD dwExStyle) throw(runtime_error);

	// CxgXi
	void	AddEventListener(IEditViewEventListener* pEventListener);
	void	RemoveEventListener(IEditViewEventListener* pEventListener);

	// ̎擾
	void					GetAllLineParams(std::list<TAppDefinedLine>& listLines) const;
	void					GetCharSpaces(unsigned int* pnLineSpan, unsigned int* pnCharSpan) const;
	IncrementalSearchState	GetIncrementalSearchState() const;
	void					GetLineNumberLayout(TLineNumberLayout& layout) const;
	DWORD					GetLineParam(length_t iLine) const;				// AvP[V`l̎擾
	void					GetMargins(unsigned int* pnLeft, unsigned int* pnTop) const;
	void					GetOption(TEditViewOption& evo) const;			// GȐݒ̎擾
	unsigned short			GetTabWidth() const;							// ^u̎擾
	bool					HasRtlTextDirection() const;

	// ̐ݒ
	void	ModifyFontInfo(const LOGFONTW& lf, bool bRedraw = true);		// tHg̕ύX
	void	SetAppDefinedLine(length_t iLine);								// AvP[V`s̐ݒ
	void	SetCandidateWords(const std::set<std::wstring>& setWords);		// ͌PꃊXg̐ݒ
	void	SetCharSpaces(unsigned int nLineSpan, unsigned int nCharSpan);	// sÅԊu̕ύX
	void	SetTextDirection(bool bRtlReading);
	void	SetLineNumberLayout(const TLineNumberLayout& layout);
	void	SetLineParam(length_t iLine,									// AvP[V`l̐ݒ
				DWORD dwParam, DWORD dwMask = 0xFFFFFFFF);
	void	SetMargins(unsigned int nLeft, unsigned int nTop);				// ]̐ݒ
	void	SetTabWidth(unsigned short nTabWidth);							// ^u̐ݒ
	void	SetOption(TEditViewOption& evo);								// ̑̐ݒ

	// \ڂ̎擾
	CLexer*			GetLexer() const;
	TTextFoundation	GetTextFoundation(int type, TokenCookie nCookie,
						bool bRowValue = false) const throw(std::invalid_argument);

	// \ڂ̐ݒ
	void	SetTextFoundation(int type, TokenCookie nCookie, const TTextFoundation& tf) throw(std::invalid_argument);

	// Lbg
	void		BeginBoxSelect();
	void		EndBoxSelect();
	CCharPos	GetActivePoint() const;
	CCharPos	GetAnchorPoint() const;
	void		GetSel(CCharPos& posAnchor, CCharPos& posActive) const;			// I͈͂̎擾
	bool		HasSelection() const;											// I͈͂邩ǂ
	void		RecreateCaret();												// Lbg쐬
	void		SetSel(const CCharPos& posAnchor, const CCharPos& posActive,	// I͈͂̐ݒ
					bool bScroll = true, bool bRepaint = true);
	void		SetSelWithoutSelection(const CCharPos& pos,						// Lbgʒu̐ݒ
					bool bScroll = true, bool bRepaint = true);
	void		SetSelWithoutSelection(length_t iLine, length_t iChar,
					bool bScroll = true, bool bRepaint = true);

	// ƒu
	unsigned long	BookmarkAll();
	static bool		CanRegExpSearch();
	bool			FindNext();
	SearchFlag		GetSearchFlags() const;
	unsigned long	ReplaceAll(const string_t& strReplaceWith);
	bool			ReplaceAndFindNext(const string_t& strReplaceWith);
	void			RevokeSearchMarks();
	void			SetSearchFlags(SearchFlag sfFlags);
	void			SetSearchText(const string_t& strText);

	// eLXg
	static CClipboardRing&	GetClipboardRing();							// Nbv{[hO擾
	string_t				GetNearestWordFromCaret() const;			// Lbgt߂̒P擾
	string_t				GetNearestWordFromCursor() const;			// J[\t߂̒P擾
	string_t				GetPrecedingWord(length_t cchLimit) const;	// Lbg̒OɂP擾
	string_t				GetSelection() const;						// I͈͂̎̕擾

	// Zk
	static string_t	ExpandAbbreviation(const string_t& strAbbrev);
	static void		GetAbbreviationList(std::list<string_t>& listAbbrevs);
	static void		RegisterAbbreviation(const string_t& strAbbrev,
						const string_t& strExpanded) throw(std::invalid_argument);
	static void		RevokeAbbreviation(const string_t& strAbbrev);
	static void		RevokeAllAbbreviations();

	// ҏW_
	CEditPoint*	CreateEditPoint();

	// ubN}[N
	void	ClearBookmarks();													// ubN}[NSĉ
	void	GetBookmarkList(std::list<length_t>& listLines) const;				// ubN}[ÑXgԂ
	bool	HasBookmarkAt(length_t iLine) const throw(out_of_range);			// ubN}[Nݒ肳Ă邩Ԃ
	void	SetBookmark(length_t iLine, bool bOn = true) throw(out_of_range);	// ubN}[N̐ݒ/
	void	ToggleBookmark(length_t iLine) throw(out_of_range);					// ubN}[N̐ݒ/

	// c[`bv
	void	HideToolTip();
	void	ShowToolTip(const string_t& strText,
				unsigned long nTimeToWait = -1, unsigned long nTimeRemainsVisible = -1);

	// `̓A
	void	Freeze();
	bool	IsFreezed() const;
	void	Unfreeze();

	// R}h
	void	ExecCommand(CommandIdentifier cmd, LPARAM lParam = 0L);	// R}ḧꊇ
protected:
	/* ړƑI */
	void	CmdMoveCancelSelection();
	void	CmdMoveCharNext(bool bExtend = false, length_t cch = 1);
	void	CmdMoveCharPrev(bool bExtend = false, length_t cch = 1);
	void	CmdMoveEnd(bool bExtend = false);
	void	CmdMoveHome(bool bExtend = false);
	void	CmdMoveIncrementalSearch(IncrementalSearchState state);
	void	CmdMoveLineDown(bool bExtend = false, length_t cLines = 1);
	void	CmdMoveLineEnd(bool bExtend = false);
	void	CmdMoveLineHome(bool bExtend = false);
	void	CmdMoveLineUp(bool bExtend = false, length_t cLines = 1);
	void	CmdMoveMatchBracket(bool bExtend = false);
	void	CmdMoveNextBookmark();
	void	CmdMovePageDown(bool bExtend = false, length_t cPages = 1);
	void	CmdMovePageUp(bool bExtend = false, length_t cPages = 1);
	void	CmdMovePrevBookmark();
	void	CmdMoveRowCharNext();
	void	CmdMoveRowCharPrev();
	void	CmdMoveRowLineDown();
	void	CmdMoveRowLineEnd();
	void	CmdMoveRowLineHome();
	void	CmdMoveRowLineUp();
	void	CmdMoveRowWordEndNext();
	void	CmdMoveRowWordEndPrev();
	void	CmdMoveRowWordNext();
	void	CmdMoveRowWordPrev();
	void	CmdMoveSelectAll();
	void	CmdMoveSelectCurrentWord();
	void	CmdMoveWordEndNext(bool bExtend = false, length_t cWords = 1);
	void	CmdMoveWordEndPrev(bool bExtend = false, length_t cWords = 1);
	void	CmdMoveWordNext(bool bExtend = false, length_t cWords = 1);
	void	CmdMoveWordPrev(bool bExtend = false, length_t cWords = 1);
	/* ҏW */
	void	CmdEditChar(Manah::Text::CodePoint cp);
	void	CmdEditCharAnotherLine(bool bBelowLine = false);
	void	CmdEditBreak();
	void	CmdEditInsertPrevLine();
	void	CmdEditBackspace();
	void	CmdEditDelete();
	void	CmdEditDeleteLine();
	void	CmdEditDeleteToNextWord();
	void	CmdEditDeleteToPrevWord();
	void	CmdEditUndo();
	void	CmdEditRedo();
	void	CmdEditConvertSel(SelConvertType sct);
	void	CmdEditCut(bool bSendAlsoClipboardRing = true);
	void	CmdEditCopy(bool bSendAlsoClipboardRing = true);
	void	CmdEditPaste();
	void	CmdEditPasteFromClipboardRing();
	void	CmdEditSpaceIndent(bool bReverse = false, unsigned short nLevel = 1);
	void	CmdEditTabify(bool bRevoke = false);
	void	CmdEditTabIndent(bool bReverse = false, unsigned short nLevel = 1);
	void	CmdEditText(const char_t* pwszText);
	void	CmdEditCharToCodePoint();
	void	CmdEditCodePointToChar();
	void	CmdEditTransposeLines();
	void	CmdEditTransposeChars();
	void	CmdEditTransposeWords();
	void	CmdEditToggleOvertypeMode();
	void	CmdEditSetNextInputConvert(NextCharConvert n);
	void	CmdEditToggleIMEStatus();
	void	CmdEditRecomposeSelection();
	void	CmdEditOpenCandidateWindow();
	/* XN[ */
	void	CmdScrollColumnNext();
	void	CmdScrollColumnPrev();
	void	CmdScrollEnd();
	void	CmdScrollEnsureCaretCentered();
	void	CmdScrollEnsureCaretVisible();
	void	CmdScrollHome();
	void	CmdScrollLineDown();
	void	CmdScrollLineUp();
	void	CmdScrollPageDown();
	void	CmdScrollPageUp();
	/* L[}N */
public:
	void	CmdKeymacroPlay();									// L[}N̎s
	void	CmdKeymacroRecord();								// L[}N̋L^
	void	CmdKeymacroStop();									// L[}N̋L^~
	void	CmdKeymacroPause();									// L[}N̋L^ꎞ~/ĊJ
	void	CmdKeymacroLoad(const std::wstring& strPathName);	// L[}N̓ǂݍ
	void	CmdKeymacroSave(const std::wstring& strPathName);	// L[}N̕ۑ
	void	CmdKeymacroCancel();								// L[}N̋L^~
	/* ̑̓ */
	bool	SmartIndent(wchar_t ch);						// X}[gCfgs

	// [eBeB
	CCharPos	CharFromPos(const POINT& pt,					// NCAgWƃXN[ԂsƕvZ
					bool bIgnoreExtender, bool* bTruncated = 0) const;
	length_t	ColumnFromChar(const CCharPos& pos) const;						// ʒuԍ擾
	CCharPos	DisplayCharFromLogicalChar(const CCharPos& posLogical) const;	// _ʒu\ʒuɕϊ
	length_t	DisplayLineFromLogicalLine(length_t iLine) const;	// _s\sɕϊ
	length_t	GetDisplayLineCount() const;						// \sԂ
	void		GetDisplayLineOffsetIndex(length_t iDisplayLine,	// \s_sƃItZbgɕϊ
					length_t& iLogicalLine, length_t& iOffset) const;
	length_t	GetVisibleLineCount() const;					// EBhEƕ̍\\ȍsvZ
	length_t	GetVisibleCharCount() const;					// EBhEƕ̕\\1sɕvZ
	bool		IsOverSelection(const POINT& pt) const;							// ʒuI͈͏ォǂ
	bool		IsOverInvokableLink(const POINT& pt, char_t*& pwsz) const;
	CCharPos	LogicalCharFromDisplayChar(const CCharPos& posDisplay) const;	// \ʒu_ʒuɕϊ
	POINT		PosFromChar(const CCharPos& col) const;		// sƗAXN[ԂNCAgWvZ

	// Nbv{[h (ȊȎ HandleCommand gp)
	UINT	CanPaste() const;	// Nbv{[h̓ey[Xgł邩ǂԂ

	// hLgƂ̒ʐM
	CEditDoc*	GetDocument() const;	// hLgIuWFNgւ̃ANZX

	// [h
	KeyMacroState		GetKeyMacroState() const;				// L[}N̏ԂԂ
	static CEditView*	GetViewKeyMacroRecording();				// L[}NL^/ꎞ~̃r[Ԃ
	WrapMode			GetWrapMode() const;					// ܂Ԃ[hԂ
	bool				IsOvertypeMode() const;					// ㏑[hǂԂ
	void				SetOvertypeMode(bool bOvertype = true);	// ㏑[h̐ݒ
	void				SetWrapMode(WrapMode wpm);				// ܂Ԃ[h̐ݒ
	void				SetWrapWidth(int nWrapWidth);	// ܂Ԃ̐ݒ

	// IUnknown C^[tFCX
	IMPLEMENT_UNKNOWN()
	BEGIN_INTERFACE_TABLE()
		IMPLEMENTS_LEFTMOST_INTERFACE(IDropSource)
		IMPLEMENTS_INTERFACE(IDropTarget)
//		IMPLEMENTS_INTERFACE(IDispatch)
//		IMPLEMENTS_INTERFACE(IViewObjectEx)
//		IMPLEMENTS_INTERFACE(IViewObject2)
//		IMPLEMENTS_INTERFACE(IViewObject)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceObject)
//		IMPLEMENTS_INTERFACE(IOleWindow, IOleInPlaceObjectWindowless)
//		IMPLEMENTS_INTERFACE(IOleInPlaceActiveObject)
//		IMPLEMENTS_INTERFACE(IOleControl)
//		IMPLEMENTS_INTERFACE(IOleObject)
//		IMPLEMENTS_INTERFACE(IPersistStreamInit)
//		IMPLEMENTS_INTERFACE(ISupportErrorInfo)
	END_INTERFACE_TABLE()

	// IDropSource C^[tFCX
	STDMETHODIMP	QueryContinueDrag(BOOL fEscapePressed, DWORD grfKeyState);
	STDMETHODIMP	GiveFeedback(DWORD dwEffect);

	// IDropTarget C^[tFCX
	STDMETHODIMP	DragEnter(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragOver(DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);
	STDMETHODIMP	DragLeave();
	STDMETHODIMP	Drop(IDataObject* pDataObj, DWORD grfKeyState, POINTL pt, DWORD* pdwEffect);

	// J[eBeB (I͈̓eLXgwp)
protected:
	void	DeleteSel();														// I͈͂̍폜
	void	InsertText(const string_t& strText);								// Lbgʒuւ̑̕}
public:	// b...
	void	ReplaceSel(const string_t& strTextbool, bool bBoxPaste = false);	// I͈͂̒u

	// J[eBeB ()
protected:
	bool			CharIsInCommentOrQuotation(const CCharPos& pos) const;
	static length_t	IsMailAddress(const char_t* psz, length_t cch);
	static length_t	IsUrlString(const char_t* psz, length_t cch);
	unsigned char	IsInvalidCharacter(const char_t* psz, length_t cch) const;
				
	// J[eBeB (`)
protected:
	virtual int			DrawBreakMark(int x, int y, BreakType bt, COLORREF clrBack);	// s}[N̕`
	virtual void		DrawLeftTab(length_t iStart, length_t iEnd);			// т`
	virtual length_t	DrawLine(length_t iLine, int y,							// 1s`
							const string_t& strLine, BreakType bt, const CLineLayout* pLineInfo);
	HFONT				GetFontForRenderingToken(int type, TokenCookie nCookie) const;
	void				InvalidateLine(length_t iLine);							// ws`𖳌
	void				InvalidateLines(length_t iStart, length_t iEnd);		// wԍs`𖳌
private:
	void				_Unfreeze();

	// J[eBeB (ʒuvZ)
protected:
	string_t		CalculateSpacesReachingVirtualPoint(
						length_t iLine, unsigned long xVirtual) const;
	length_t		CharFromPixel(length_t iLine, unsigned long x,
						bool bIgnoreExtender, bool* pbTruncated = 0) const;
	unsigned int	GetAvgCharWidth() const;										// 1̕ϕԂ
	unsigned long	GetNextTabStop(unsigned long xView, bool bRtlReading) const;	// ̃^uʒuԂ
	static int		MakeCaretPosValid(const char_t* pwsz,							// LbgʒȕC
						length_t cch, length_t nCaretPos, bool bBackward);

	// J[eBeB (I͈͂ƃLbg)
protected:
	void						CheckMatchBrackets();
	const CVisibleEditPoint&	GetSelTopPoint() const;
	const CVisibleEditPoint&	GetSelBottomPoint() const;
	virtual void				OnMoveCaret();

	// J[eBeB (̑)
protected:
	virtual int		CompareString(const char_t* psz1,
						const char_t* psz2, length_t cch) const;
	static char_t	ConvertCharacter(char_t wch, NextCharConvert ncc);
	void			ExpandPrecedingWordAsAbbreviation();
	virtual bool	FindBracket(const CCharPos& pos, CCharPos& posFound, bool bRequireBody) const;
	unsigned int	GetLineNumberMaxDigit() const;
	void			InitializeWindow(bool bCopyConstructing);
	bool			IsAcceptableAsMacroKey(UINT nChar) const;
	void			ModifyScrollInfo(bool bHorizontal, bool bVertical);
	void			RecalcLeftTabWidth(int cy = -1);
	static bool		RegisterWindowClass();
	virtual void	UpdateGDIObjects();
	void			UpdateISearchState(bool bTextIsShortened);
	virtual void	ValidateCaretPos();
	void			ValidateIMEWindowPos();

	// J[eBeB (̑) ʂɌJ
public:
	virtual void	DrawBorder(int left, int top, int right, int bottom, BorderType bt, COLORREF clr);

protected:
	virtual LRESULT	DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);
	void			ReleaseEditPoint(CEditPoint& pt);

	// bZ[Wnh
protected:
	virtual void	OnChar(UINT nChar, UINT nFlags);						// WM_CHAR
	virtual bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);	// WM_COMMAND
	virtual bool	OnContextMenu(HWND hWnd, POINT pt);						// WM_CONTEXTMENU
	virtual void	OnDestroy();											// WM_DESTROY
	virtual void	OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_HSCROLL
	virtual bool	OnImeComposition(WPARAM wParam, LPARAM lParam);			// WM_IME_COMPOSITION
	virtual void	OnImeEndComposition();									// WM_IME_ENDCOMPOSITION
	virtual void	OnImeStartComposition();								// WM_IME_STARTCOMPOSITION
	virtual void	OnKeyDown(UINT nChar, UINT nFlags);						// WM_KEYDOWN
	virtual void	OnKillFocus(HWND hwndNew);								// WM_KILLFOCUS
	virtual void	OnLButtonDblClk(UINT nFlags, POINT pt);					// WM_LBUTTONDBLCLK
	virtual void	OnLButtonDown(UINT nFlags, POINT pt);					// WM_LBUTTONDOWN
	virtual void	OnLButtonUp(UINT nFlags, POINT pt);						// WM_LBUTTONUP
	virtual void	OnMouseMove(UINT nFlags, POINT pt);						// WM_MOUSEMOVE
	virtual bool	OnMouseWheel(UINT nFlags, short zDelta, POINT pt);		// WM_MOUSEWHEEL
	virtual bool	OnNotify(int idCtrl, LPNMHDR lpNMHDR);					// WM_NOTIFY
	virtual void	OnPaint();												// WM_PAINT
	virtual void	OnRButtonDown(UINT nFlags, POINT pt);					// WM_RBUTTONDOWN
	virtual bool	OnSetCursor(HWND hWnd, UINT nHitTest, UINT message);	// WM_SETCURSOR
	virtual void	OnSetFocus(HWND hwndOld);								// WM_SETFOCUS
	virtual void	OnSize(UINT nType, int cx, int cy);						// WM_SIZE
	virtual void	OnSysColorChange();										// WM_SYSCOLORCHANGE
	virtual void	OnTimer(UINT nIDEvent);									// WM_TIMER
	virtual void	OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar);	// WM_VSCROLL

	// WbZ[Wnh
	virtual void	OnDocumentSetup(LPARAM lHint = 0);								// hLgA[hꂽ
	virtual void	OnUpdate(Manah::CObject* pSender, LPARAM lParam, void* pHint);	// hLg̒ʐM
};

// CC֐̎
/////////////////////////////////////////////////////////////////////////////

/**
 *	xgXi̓o^
 *	@param pEventListener	Vo^CxgXi
 */
inline void CEditView::AddEventListener(IEditViewEventListener* pEventListener) {
	AssertValid();
	assert(pEventListener != 0);
	m_pEventListeners->insert(pEventListener);
}

/**
 *	u\tv삪\擾
 *	@return	\t\ȃNbv{[h`Bs̏ꍇ0
 */
inline UINT CEditView::CanPaste() const {
	AssertValid();

	if(GetDocument()->IsReadOnly())
		return 0;

	const UINT	nBoxClipFormat = ::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT);

	if(nBoxClipFormat != 0 && toBoolean(::IsClipboardFormatAvailable(nBoxClipFormat)))
		return nBoxClipFormat;
	if(toBoolean(::IsClipboardFormatAvailable(CF_UNICODETEXT)))
		return CF_UNICODETEXT;
	if(toBoolean(::IsClipboardFormatAvailable(CF_TEXT)))
		return CF_TEXT;

	return 0;
}

///	K\\ǂԂ
inline bool CEditView::CanRegExpSearch() {
	return m_oTextSearcher.IsRegExpAvailable();
}

/**
 *	ݎgpĂtHg (C^bNłȂ) 
 *	1`悷Ƃ̕ϕԂ
 */
inline unsigned int CEditView::GetAvgCharWidth() const {
	AssertValid();
	return m_layoutInfo.nCharWidth + m_layoutInfo.nCharSpan;
}

/**
 *	sԊuAԊu擾
 *	@param pnLineSpan	[out] sԊuBKvȂ null ł悢
 *	@param pnCharSpan	[out] ԊuBKvȂ null ł悢
 */
inline void CEditView::GetCharSpaces(unsigned int* pnLineSpan, unsigned int* pnCharSpan) const {
	AssertValid();
	if(pnLineSpan != 0)	*pnLineSpan = m_layoutInfo.nLineHeight - m_layoutInfo.nCharHeight;
	if(pnCharSpan != 0)	*pnCharSpan = m_layoutInfo.nCharSpan;
}

///	Nbv{[hOԂ
inline CClipboardRing& CEditView::GetClipboardRing() {
	return m_oClipboardRing;
}

/**
 *	w肵g[N`tHgԂ
 *	@param type		g[N̎
 *	@param nCookie	g[ÑNbL[l
 *	@return			tHg
 */
inline HFONT CEditView::GetFontForRenderingToken(int type, TokenCookie nCookie) const {
	AssertValid();

	const TTextFoundation&	tf = m_pTokenFoundations->GetToken(type, nCookie);
	if(m_pTokenFoundations->arrEnabled[type] && tf.bold)
		return tf.italic ? m_gdiObjects.hBoldItalicFont : m_gdiObjects.hBoldFont;
	else
		return (m_pTokenFoundations->arrEnabled[type] && tf.italic) ? m_gdiObjects.hItalicFont : m_gdiObjects.hNormalFont;
}

///	CN^̏ԂԂ
inline IncrementalSearchState CEditView::GetIncrementalSearchState() const {
	AssertValid();
	return m_modeState.incrementalSearchState;
}

///	݂̃L[}N̏ԂԂ
inline KeyMacroState CEditView::GetKeyMacroState() const {
	AssertValid();
	return m_pKeyMacroPlayer->GetState();
}

///	͊Ԃ
inline CLexer* CEditView::GetLexer() const {
	AssertValid();
	return m_pLineLayoutManager->GetLexer();
}

///	sԍ̕\@Ԃ
inline void CEditView::GetLineNumberLayout(TLineNumberLayout& layout) const {
	AssertValid();
	layout = m_layoutInfo.lineNumberLayout;
}

/**
 *	hLǧ݂̍ŏIsl10iŉɂȂ邩Ԃ
 *	@return	Kvȕ
 */
inline unsigned int CEditView::GetLineNumberMaxDigit() const {
	AssertValid();

	unsigned int	n = 1;
	length_t		cLines = GetDocument()->GetLineCount();

	while(cLines >= 10) {
		cLines /= 10;
		++n;
	}
	return n;
}

/**
 *	]擾
 *	@param pnLeft	[out] ]BKvȂ null ł悢
 *	@param pnTop	[out] ]BKvȂ null ł悢
 */
inline void CEditView::GetMargins(unsigned int* pnLeft, unsigned int* pnTop) const {
	AssertValid();
	if(pnLeft != 0)	*pnLeft = m_layoutInfo.nLeftMargin;
	if(pnTop != 0)	*pnTop = m_layoutInfo.nTopMargin;
}

/**
 *	̃^uʒuԂ
 *	@param xView		r[ x W - ]
 *	@param bRtlReading	E獶ɓǂޏꍇ ()
 */
inline unsigned long CEditView::GetNextTabStop(unsigned long xView, bool bRtlReading) const {
	AssertValid();
	if(!bRtlReading)
		return xView + m_layoutInfo.nTabWidth * GetAvgCharWidth()
			- xView % (m_layoutInfo.nTabWidth * GetAvgCharWidth());
	else
		return xView - xView % (m_layoutInfo.nTabWidth * GetAvgCharWidth());
}

///	GȐݒԂ
inline void CEditView::GetOption(TEditViewOption& evo) const {
	using namespace Manah::Text;

	AssertValid();

	evo.aitAutoIndentType = m_modeState.aitAutoIndentType;
	evo.chIdeographicSpaceAlternative = m_foundationInfo.chIdeographicSpace;
	evo.chTabAlternative = m_foundationInfo.chTab;
	evo.chWhitespaceAlternative = m_foundationInfo.chSpace;
	evo.cRecognizingLines = m_modeState.cFindLimit;
	evo.iStartChar = m_modeState.iStartChar;
	evo.iStartLine = m_modeState.iStartLine;
	evo.strEndOfFile = m_foundationInfo.strEndOfFile;

	EditViewOption&	misc = evo.evoMiscellaneous;
	misc = 0;
	if(m_foundationInfo.bDrawBreakArrow)				misc |= EVO_SHOW_BREAKARROWS;
	if(m_foundationInfo.bDrawCurrentUnderline)			misc |= EVO_SHOW_CURRENTUNDERLINE;
	if(m_foundationInfo.bDrawEOF)						misc |= EVO_SHOW_EOFMARK;
	if(m_foundationInfo.bDrawSpaces)					misc |= EVO_SHOW_WHITESPACE;
	if(m_foundationInfo.bIgnoreCaseOnHilite)			misc |= EVO_IGNORECASE;
	if(m_foundationInfo.bPaintBreakContinuingSelection)	misc |= EVO_PAINTBREAKCONTINUINGSEL;
	if(m_modeState.bShowUnicodeCtrls)					misc |= EVO_SHOW_UNICODECTRLCHARS;
	if(m_modeState.bUseOLEDragDrop)						misc |= EVO_USE_OLEDRAGDROP;
	if(m_layoutInfo.bThinCaret)							misc |= EVO_USE_THINCARET;
	if(m_modeState.bShowHandOnLink)						misc |= EVO_SHOW_HANDONLINK;
	if(m_modeState.bShowHintOnLink)						misc |= EVO_SHOW_HINTONLINK;
}

///	ݒ肳Ă錟Ԃ
inline SearchFlag CEditView::GetSearchFlags() const {
	AssertValid();
	return CEditView::m_oTextSearcher.GetFlags();
}

///	݂̃^uԂ
inline unsigned short CEditView::GetTabWidth() const {
	AssertValid();
	return m_layoutInfo.nTabWidth;
}

/**
 *	@brief	C̎擾
 *
 *	̃\bh CEditView ĂяoB
 *	̃\bh͗Ⴆ΃VXeݒŒ`ꂽFȂǂԂ߂ɁA
 *	HԂ̂ŁAڊYoɃANZXĂ͂ȂȂB
 *
 *	@param type				̎
 *	@param nCookie			L[[hRg̏ꍇ͌XʂNbL[l
 *	@param bRawValue		HɕԂꍇ true
 *	@return					C
 *	@throw invalid_argumet	<var>type</var>  <var>nCookie</var> sȂƂX[
 *	@see					SetTextFoundation
 */
inline TTextFoundation CEditView::GetTextFoundation(int type,
		TokenCookie nCookie, bool bRawValue /* = false */) const throw(std::invalid_argument) {
	AssertValid();
	if(type < TT_WHITESPACE || type >= ETT_COUNT)
		throw std::invalid_argument("Specified type is invalid.");

	TTextFoundation	tf = m_pTokenFoundations->GetToken(type, nCookie);

	if(bRawValue)
		return tf;

	// OiF̎
	if(tf.fgColor == -1) {
		if(type == ETT_NORMAL)					tf.fgColor = ::GetSysColor(COLOR_WINDOWTEXT);
		else if(type == ETT_SELECTION)			tf.fgColor = ::GetSysColor(COLOR_HIGHLIGHTTEXT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.fgColor = ::GetSysColor(COLOR_INACTIVECAPTIONTEXT);
		else if(type == ETT_INDICATOR_MARGIN)	tf.fgColor = ::GetSysColor(COLOR_3DSHADOW);
		else									tf.fgColor = (m_pTokenFoundations->tfs[ETT_NORMAL].ptf->fgColor != -1) ?
													m_pTokenFoundations->tfs[ETT_NORMAL].ptf->fgColor : ::GetSysColor(COLOR_WINDOWTEXT);
	}

	// wiF̎
	if(tf.bgColor == -1) {
		if(type == ETT_NORMAL)					tf.bgColor = ::GetSysColor(COLOR_WINDOW);
		else if(type == ETT_SELECTION)			tf.bgColor = ::GetSysColor(COLOR_HIGHLIGHT);
		else if(type == ETT_INACTIVE_SELECTION)	tf.bgColor = ::GetSysColor(COLOR_INACTIVECAPTION);
		else if(type == ETT_INDICATOR_MARGIN)	tf.bgColor = ::GetSysColor(COLOR_3DFACE);
		else									tf.bgColor = (m_pTokenFoundations->tfs[ETT_NORMAL].ptf->bgColor != -1) ?
													m_pTokenFoundations->tfs[ETT_NORMAL].ptf->bgColor : ::GetSysColor(COLOR_WINDOW);
	}

	// /gF̎
	if(tf.borderColor == -1)
		tf.borderColor = (type != ETT_LINK) ? tf.fgColor : GetTextFoundation(ETT_NORMAL, NullCookie).fgColor;

	return tf;
}

///	L[}NL^/ꎞ~̃r[Ԃ
inline CEditView* CEditView::GetViewKeyMacroRecording() {
	return CKeyMacroPlayer::Create()->GetActiveView();
}

/**
 *	NCAg̈ɕ\ł񐔂擾
 *	@return	\\ȗ
 */
inline length_t CEditView::GetVisibleCharCount() const {
	RECT	rect;
	GetClientRect(&rect);
	return (rect.right - rect.left == 0) ? 0 :
		(rect.right - rect.left - m_layoutInfo.nLeftMargin - m_layoutInfo.nLeftTabWidth) / GetAvgCharWidth();
}

/**
 *	NCAg̈ɕ\łs擾
 *	@return	\\ȍs
 */
inline length_t CEditView::GetVisibleLineCount() const {
	RECT	rect;
	GetClientRect(&rect);
	return (rect.bottom - rect.left == 0) ? 0:
		(rect.bottom - rect.top - m_layoutInfo.nTopMargin) / m_layoutInfo.nLineHeight;
}

///	܂Ԃ[hԂ
inline WrapMode CEditView::GetWrapMode() const {
	AssertValid();
	return m_modeState.wpmWrapMode;
}

///	E獶ɓǂރ[h̏ꍇ true Ԃ
inline bool CEditView::HasRtlTextDirection() const {
	AssertValid();
	return m_modeState.bRtlReading;
}

/**
 *	L[}NɕۑłL[ǂԂ
 *	@param nChar	zL[
 */
inline bool CEditView::IsAcceptableAsMacroKey(UINT nChar) const {
	switch(nChar) {
	case VK_LBUTTON:
	case VK_RBUTTON:
	case VK_CANCEL:
	case VK_MBUTTON:
	case VK_MENU:
	case VK_LWIN:
	case VK_RWIN:
	case VK_APPS:
	case VK_LMENU:
	case VK_RMENU:
		return false;
	}
	return true;
}

///	`擀
inline bool CEditView::IsFreezed() const {
	AssertValid();
	return m_nFreezeCount != 0;
}

/**
 *	݂̃R[hy[Wŕsȕ̒Ԃ
 *	@param psz	ׂ镶ւ̃|C^
 *	@param cch	<var>psz</var> ̒
 *	@return		sȕłȂꍇ0BsȒ U+10000 ̏ꍇ2BȊO1
 */
inline unsigned char CEditView::IsInvalidCharacter(const char_t* psz, length_t cch) const {
	assert(psz != 0);

	using namespace Manah::Text;

	if(cch == 0)
		return 0;
	else if(cch > 1
			&& IsUTF16HighSurrogate(psz[0])
			&& IsUTF16LowSurrogate(psz[1])) {
		BOOL	b = FALSE;
		::WideCharToMultiByte(GetDocument()->GetCodePage(), 0, psz, 2, 0, 0, 0, &b);
		return toBoolean(b) ? 1 : 0;
	} else {
		BOOL	b = FALSE;
		::WideCharToMultiByte(GetDocument()->GetCodePage(), 0, psz, 1, 0, 0, 0, &b);
		return toBoolean(b) ? 1 : 0;
	}
}

/**
 *	㏑[hǂԂ
 *	@see	CEditView::SetOvertypeMode
 */
inline bool CEditView::IsOvertypeMode() const {
	AssertValid();
	return m_modeState.bOvertype;
}

///	w肵ZkWJԂBo^ĂȂ΋󕶎Ԃ
inline string_t CEditView::ExpandAbbreviation(const string_t& strAbbrev) {
	std::map<string_t, string_t>::iterator	it = m_mapAbbreviations.find(strAbbrev);
	return (it != m_mapAbbreviations.end()) ? it->second : L"";
}

///	o^ĂZk̃XgԂ
inline void CEditView::GetAbbreviationList(std::list<string_t>& listAbbrevs) {
	for(std::map<string_t, string_t>::const_iterator it =
			m_mapAbbreviations.begin(); it != m_mapAbbreviations.end(); ++it)
		listAbbrevs.push_back(it->first);
}

/**
 *	Zko^B̂̂͏㏑
 *	@param strAbbrev				Zk
 *	@param strExpanded				WJ̕
 *	@throw std::invalid_argument	ꂩ̈󕶎̂ƂX[
 */
inline void CEditView::RegisterAbbreviation(const string_t& strAbbrev, const string_t& strExpanded) {
	std::map<string_t, string_t>::iterator	it = m_mapAbbreviations.find(strAbbrev);
	if(it != m_mapAbbreviations.end())
		m_mapAbbreviations.erase(it);
	m_mapAbbreviations.insert(std::make_pair(strAbbrev, strExpanded));
	m_cchMaxAbbreviation = std::max(strAbbrev.length(), m_cchMaxAbbreviation);
}

/**
 *	CxgXi̍폜
 *	@param pEventListener	폜CxgXi
 */
inline void CEditView::RemoveEventListener(IEditViewEventListener* pEventListener) {
	AssertValid();
	assert(pEventListener != 0);
	m_pEventListeners->erase(pEventListener);
}

///	w肵Zk폜
inline void CEditView::RevokeAbbreviation(const string_t& strAbbrev) {
	if(m_mapAbbreviations.erase(strAbbrev) != 0) {
		if(m_mapAbbreviations.empty())
			m_cchMaxAbbreviation = 0;
		else if(strAbbrev.length() == m_cchMaxAbbreviation) {
			for(std::map<string_t, string_t>::const_iterator it =
					m_mapAbbreviations.begin(); it != m_mapAbbreviations.end(); ++it)
				m_cchMaxAbbreviation = std::max(strAbbrev.length(), m_cchMaxAbbreviation);
		}
	}
}

///	o^ĂSĂ̒Zk폜
inline void CEditView::RevokeAllAbbreviations() {
	m_mapAbbreviations.clear();
}

///	v̋\
inline void CEditView::RevokeSearchMarks() {
	if(m_modeState.bHighlightSearchText) {
		m_modeState.bHighlightSearchText = false;
		if(IsWindowVisible() && m_pTokenFoundations->arrEnabled[ETT_MATCHTEXT])
			InvalidateRect(0);
	}
}

} // namespace Ascension

#endif /* _EDIT_VIEW_H_ */

/* [EOF] */