// EditViewMessageHandlers.cpp
// (c) 2004 exeal

/**
 *	@file	EditViewMessageHandlers.cpp
 *	CEditView NX̓AbZ[WnhW߂
 */

#include "StdAfx.h"
#include "EditView.h"
#include "EditPoint.h"
#include "EditController.h"
using namespace Ascension;
using Manah::Windows::GDI::CMinimalDC;


/// @see	CWindow::OnChar
void CEditView::OnChar(UINT nChar, UINT nFlags) {
	ExecCommand(CMDID_EDIT_CHAR, nChar);
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
}

/// @see	CWindow::OnCommand
bool CEditView::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case WM_UNDO:	// [ɖ߂]
		ExecCommand(CMDID_EDIT_UNDO, 0L);
		break;
	case WM_REDO:	// [蒼]
		ExecCommand(CMDID_EDIT_REDO, 0L);
		break;
	case WM_CUT:	// [؂]
		ExecCommand(CMDID_EDIT_CUT, 0L);
		break;
	case WM_COPY:	// [Rs[]
		ExecCommand(CMDID_EDIT_COPY, 0L);
		break;
	case WM_PASTE:	// [\t]
		ExecCommand(CMDID_EDIT_PASTE, 0L);
		break;
	case WM_CLEAR:	// [폜]
		ExecCommand(CMDID_EDIT_DELETE, 0L);
		break;
	case WM_SELECTALL:	// [ׂđI]
		ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		break;
	case ID_SHOWRTL:	// [E獶ɓǂ]
		SetTextDirection(!toBoolean(GetWindowLong(GWL_EXSTYLE) & WS_EX_RTLREADING));
		break;
	case ID_SHOWUNICODECONTROLCHARS:	// [Unicode 䕶̕\]
		m_modeState.bShowUnicodeCtrls = !m_modeState.bShowUnicodeCtrls;
		InvalidateRect(0);
		break;
	case ID_INSERT_LRM:		ExecCommand(CMDID_EDIT_CHAR, 0x200E);	break;
	case ID_INSERT_RLM:		ExecCommand(CMDID_EDIT_CHAR, 0x200F);	break;
	case ID_INSERT_ZWJ:		ExecCommand(CMDID_EDIT_CHAR, 0x200D);	break;
	case ID_INSERT_ZWNJ:	ExecCommand(CMDID_EDIT_CHAR, 0x200C);	break;
	case ID_INSERT_LRE:		ExecCommand(CMDID_EDIT_CHAR, 0x202A);	break;
	case ID_INSERT_RLE:		ExecCommand(CMDID_EDIT_CHAR, 0x202B);	break;
	case ID_INSERT_LRO:		ExecCommand(CMDID_EDIT_CHAR, 0x202D);	break;
	case ID_INSERT_RLO:		ExecCommand(CMDID_EDIT_CHAR, 0x202E);	break;
	case ID_INSERT_PDF:		ExecCommand(CMDID_EDIT_CHAR, 0x202C);	break;
	case ID_INSERT_WJ:		ExecCommand(CMDID_EDIT_CHAR, 0x2060);	break;
	case ID_INSERT_U2061:	ExecCommand(CMDID_EDIT_CHAR, 0x2061);	break;
	case ID_INSERT_U2062:	ExecCommand(CMDID_EDIT_CHAR, 0x2062);	break;
	case ID_INSERT_U2063:	ExecCommand(CMDID_EDIT_CHAR, 0x2063);	break;
/*	case ID_INSERT_NADS:	ExecCommand(CMDID_EDIT_CHAR, 0x206E);	break;
	case ID_INSERT_NODS:	ExecCommand(CMDID_EDIT_CHAR, 0x206F);	break;
	case ID_INSERT_ASS:		ExecCommand(CMDID_EDIT_CHAR, 0x206B);	break;
	case ID_INSERT_ISS:		ExecCommand(CMDID_EDIT_CHAR, 0x206A);	break;
	case ID_INSERT_AAFS:	ExecCommand(CMDID_EDIT_CHAR, 0x206D);	break;
	case ID_INSERT_IAFS:	ExecCommand(CMDID_EDIT_CHAR, 0x206C);	break;*/
	case ID_INSERT_RS:		ExecCommand(CMDID_EDIT_CHAR, 0x001E);	break;
	case ID_INSERT_US:		ExecCommand(CMDID_EDIT_CHAR, 0x001F);	break;
	case ID_INSERT_U0020:	ExecCommand(CMDID_EDIT_CHAR, 0x0020);	break;
	case ID_INSERT_NBSP:	ExecCommand(CMDID_EDIT_CHAR, 0x00A0);	break;
	case ID_INSERT_U1680:	ExecCommand(CMDID_EDIT_CHAR, 0x1680);	break;
	case ID_INSERT_MVS:		ExecCommand(CMDID_EDIT_CHAR, 0x180E);	break;
	case ID_INSERT_U2000:	ExecCommand(CMDID_EDIT_CHAR, 0x2000);	break;
	case ID_INSERT_U2001:	ExecCommand(CMDID_EDIT_CHAR, 0x2001);	break;
	case ID_INSERT_U2002:	ExecCommand(CMDID_EDIT_CHAR, 0x2002);	break;
	case ID_INSERT_U2003:	ExecCommand(CMDID_EDIT_CHAR, 0x2003);	break;
	case ID_INSERT_U2004:	ExecCommand(CMDID_EDIT_CHAR, 0x2004);	break;
	case ID_INSERT_U2005:	ExecCommand(CMDID_EDIT_CHAR, 0x2005);	break;
	case ID_INSERT_U2006:	ExecCommand(CMDID_EDIT_CHAR, 0x2006);	break;
	case ID_INSERT_U2007:	ExecCommand(CMDID_EDIT_CHAR, 0x2007);	break;
	case ID_INSERT_U2008:	ExecCommand(CMDID_EDIT_CHAR, 0x2008);	break;
	case ID_INSERT_U2009:	ExecCommand(CMDID_EDIT_CHAR, 0x2009);	break;
	case ID_INSERT_U200A:	ExecCommand(CMDID_EDIT_CHAR, 0x200A);	break;
	case ID_INSERT_ZWSP:	ExecCommand(CMDID_EDIT_CHAR, 0x200B);	break;
	case ID_INSERT_NNBSP:	ExecCommand(CMDID_EDIT_CHAR, 0x202F);	break;
	case ID_INSERT_MMSP:	ExecCommand(CMDID_EDIT_CHAR, 0x205F);	break;
	case ID_INSERT_U3000:	ExecCommand(CMDID_EDIT_CHAR, 0x3000);	break;
	case ID_INSERT_NEL:		ExecCommand(CMDID_EDIT_CHAR, 0x0085);	break;
	case ID_INSERT_LS:		ExecCommand(CMDID_EDIT_CHAR, 0x2028);	break;
	case ID_INSERT_PS:		ExecCommand(CMDID_EDIT_CHAR, 0x2029);	break;
	case ID_TOGGLEIMESTATUS:	// [IME J] / [IME ]
		ExecCommand(CMDID_EDIT_TOGGLEIMESTATUS, 0L);
		break;
	case ID_RECOMPOSITIONIME:	// [ĕϊ]
		ExecCommand(CMDID_EDIT_RECOMPOSESELECTION, 0L);
		break;
	default:
		if(GetParent() != 0)
			GetParent()->SendMessage(WM_COMMAND,
				MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
	}

	return CView::OnCommand(wID, wNotifyCode, hwndCtrl);
}

/// @see	CWindow::OnContextMenu
bool CEditView::OnContextMenu(HWND hWnd, POINT pt) {
	RECT	rect;

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(m_modeState.incrementalSearchState != ISS_NOTRUNNING)
		CmdMoveIncrementalSearch(ISS_NOTRUNNING);

	// L[{[hɂꍇ
	if(pt.x == 65535 && pt.y == 65535) {
		pt.x = pt.y = 1;	// K...
		ClientToScreen(&pt);
	}

	// XN[o[łΏȂ
	GetClientRect(&rect);
	ClientToScreen(&rect);
	if(!::PtInRect(&rect, pt))
		return false;

	const CEditDoc*	pDoc = GetDocument();
	const bool		bSelection = HasSelection();
	const bool		bReadOnly = GetDocument()->IsReadOnly();
	MENUITEMINFOW	mii;
	HMENU&			hMenu = (m_pOriginalView == this) ? m_hContextMenu : m_pOriginalView->m_hContextMenu;

	ZeroMemory(&mii, sizeof(MENUITEMINFOW));
	mii.cbSize = sizeof(MENUITEMINFOW);

	// j[ڂ̏C
	::EnableMenuItem(hMenu, WM_UNDO,
		MF_BYCOMMAND | (!bReadOnly && pDoc->GetUndoHistoryLength(false) != 0) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_REDO,
		MF_BYCOMMAND | (!bReadOnly && pDoc->GetUndoHistoryLength(true) != 0) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_CUT, MF_BYCOMMAND | (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_COPY, MF_BYCOMMAND | bSelection ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_PASTE, (!bReadOnly && CanPaste()) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, WM_CLEAR, (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED);
	::EnableMenuItem(hMenu, ID_SHOWUNICODECONTROLCHARS, MF_BYCOMMAND | MFS_GRAYED);
	::EnableMenuItem(hMenu, ID_SHOWRTL,
		MF_BYCOMMAND | MFS_GRAYED | (m_modeState.bRtlReading ? MFS_CHECKED : MFS_UNCHECKED));
	if(toBoolean(::ImmIsIME(::GetKeyboardLayout(::GetCurrentThreadId())))) {
		HIMC	hImc = ::ImmGetContext(m_hWnd);

		mii.fMask = MIIM_STRING;
		mii.dwTypeData = (::GetUserDefaultLangID() == 0x0411) ?
			(::ImmGetOpenStatus(hImc) ? L"IME (&L)" : L"IME J(&O)")
			: (::ImmGetOpenStatus(hImc) ? L"C&lose IME" : L"&Open IME");
		::SetMenuItemInfoW(hMenu, ID_TOGGLEIMESTATUS, false, &mii);
		::EnableMenuItem(hMenu, ID_RECOMPOSITIONIME, (!bReadOnly && bSelection) ? MFS_ENABLED : MFS_GRAYED);
		::ImmReleaseContext(m_hWnd, hImc);
	}
	::TrackPopupMenu(hMenu, TPM_LEFTALIGN, pt.x, pt.y, 0, m_hWnd, 0);
	return true;
}

/// @see	CWindow::OnDestroy
void CEditView::OnDestroy() {
	// D&D 
	RevokeDragDrop();

	// ]EBhE폜
	::DestroyWindow(m_hwndToolTip);
	m_pwndAutoComplete->DestroyWindow();

	CWindow::OnDestroy();
}

///	hLg[hɈxĂяo
///	@see	CView::OnDocumentSetup
void CEditView::OnDocumentSetup(LPARAM lHint /* = 0 */) {
	m_pAnchorPoint->MoveToPoint(CCharPos(0, 0));
	m_pActivePoint->MoveToPoint(CCharPos(0, 0));
	for(set<IEditViewEventListener*>::iterator it =
			m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnLoadFile();
	m_pLineLayoutManager->ReconstructAll();
	RecalcLeftTabWidth();
	ModifyScrollInfo(true, true);
	ValidateCaretPos();
	InvalidateRect(0);
}

/// @see	CWindow::OnHScroll
void CEditView::OnHScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	const int	nOrgPos = m_ptScroll.x;	// ̈ʒuۑ
	int			nMinPos, nMaxPos;		// őAŏʒu
	const int	cVisibleChars = GetVisibleCharCount();

	GetScrollRange(SB_HORZ, &nMinPos, &nMaxPos);

//	if(m_pwndAutoComplete->IsWindowVisible())
//		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(cVisibleChars > (nMaxPos - nMinPos) * static_cast<int>(m_layoutInfo.nHScrollRatio)) {
		m_ptScroll.x = 0;
		return;
	}

	switch(nSBCode) {
	case SB_LINELEFT:		// 1񕪍
		--m_ptScroll.x;	break;
	case SB_LINERIGHT:		// 1񕪉E
		++m_ptScroll.x;	break;
	case SB_PAGELEFT:		// 1y[W
		m_ptScroll.x -= GetVisibleCharCount();	break;
	case SB_PAGERIGHT:		// 1y[WE
		m_ptScroll.x += GetVisibleCharCount();	break;
	case SB_LEFT:			// [
		m_ptScroll.x = nMinPos;	break;
	case SB_RIGHT:			// E[
		m_ptScroll.x = nMaxPos;	break;
	case SB_THUMBTRACK:		// hbO or zC[
		m_ptScroll.x = GetScrollTrackPos(SB_HORZ);	break;	// 32rbglg
	case SB_SETPOS:			// IȃXN[
		m_ptScroll.x = nPos;	break;
	default:
		return;
	}

	// 
	if(m_ptScroll.x < nMinPos)
		m_ptScroll.x = nMinPos;
	else if(m_ptScroll.x > static_cast<long>(nMaxPos - GetVisibleCharCount() + 1))
		m_ptScroll.x = nMaxPos - GetVisibleCharCount() + 1;
	if(m_ptScroll.x == nOrgPos)	// XN[Ȃ
		return;

	// ĕ`Ȃ
	if(dif<long>(m_ptScroll.x, nOrgPos) < cVisibleChars) {	// XN[ʂ1y[Wȉ
		RECT		rectScroll;				// XN[Ώ
		const int	dx = (nOrgPos - m_ptScroll.x) * m_layoutInfo.nHScrollRatio * GetAvgCharWidth();
		RECT		rectUpdate;

		GetClientRect(&rectScroll);
		rectUpdate = rectScroll;
		rectScroll.left = m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;
		if(dx > 0) {
			rectScroll.left += dx;
			rectUpdate.left += m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin;
			rectUpdate.right = rectUpdate.left + dx;
		} else {
			rectScroll.right += dx;
			rectUpdate.left = rectUpdate.right + dx;
		}
		ScrollWindowEx(dx, 0, &rectScroll, &rectScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rectUpdate, false);
	} else
		InvalidateRect(0, false);

	HideToolTip();
	SetScrollPos(SB_HORZ, m_ptScroll.x);
	ValidateCaretPos();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
//	UpdateWindow();

	if(m_pwndAutoComplete->IsWindow())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/// @see	WM_IME_COMPOSITION
bool CEditView::OnImeComposition(WPARAM wParam, LPARAM lParam) {
	using namespace Manah::Text;

	if(lParam == 0 || toBoolean(lParam & GCS_RESULTSTR)) {	// m
		if(HIMC	hIMC = ::ImmGetContext(m_hWnd)) {
			const length_t	cch = ::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, 0, 0) / sizeof(WCHAR);

			if(cch != 0) {	// LZȂꍇ
				char_t*	pwszText = new wchar_t[cch + 1];
				::ImmGetCompositionStringW(hIMC, GCS_RESULTSTR, pwszText, cch * sizeof(WCHAR));
				pwszText[cch] = 0;
				if(m_modeState.incrementalSearchState != ISS_NOTRUNNING) {
					for(length_t i = 0; i < cch; ++i) {
						const CodePoint	cp = DecodeUTF16SurrogatePairToCodePoint(pwszText + i, cch - i);
						CmdEditChar(cp);
						if(cp > 0xFFFF)
							++i;
					}
				} else {
					ReplaceSel(pwszText);

					// ExecCommand ʂȂ̂łŃL[}NɋL^
					// (ExecCommand(CMDID_EDIT_CHAR) ͒x)
					if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING
							&& m_pKeyMacroPlayer->GetActiveView() == this) {
						TKeymacroCommand	kmc;
						kmc.cmd = CMDID_EDIT_CHAR;
						for(length_t i = 0; i < cch; ++i) {
							kmc.lParam = DecodeUTF16SurrogatePairToCodePoint(pwszText + i, cch - i);
							m_pKeyMacroPlayer->AddCommand(kmc);
							if(kmc.lParam > 0xFFFF)
								++i;
						}
					}
				}
				delete[] pwszText;
			}

			ValidateIMEWindowPos();
			::ImmReleaseContext(m_hWnd, hIMC);
		}
		return true;
	}
	return false;
}

///	@see	WM_IME_ENDCOMPOSITION
void CEditView::OnImeEndComposition() {
	ShowCaret();
	m_bActiveIMEComposition = false;
}

/// @see	WM_IME_STARTCOMPOSITION
void CEditView::OnImeStartComposition() {
	HIMC		hIMC = ::ImmGetContext(m_hWnd);
	LOGFONTW	lf;

	if(hIMC != 0) {
		::GetObject(m_gdiObjects.hNormalFont, sizeof(LOGFONTW), &lf);
		::ImmSetCompositionFontW(hIMC, &lf);	// IME ̐ݒɂĂ͔f邾낤
		HideCaret();
		::ImmReleaseContext(m_hWnd, hIMC);
	}
	m_bActiveIMEComposition = true;
	ValidateIMEWindowPos();

	m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/**
 *	@brief	WM_KEYDOWN ̏
 *
 *	̎ Ascension r[̊̃L[蓖Ăɏ]ďsB
 *	̊蓖Ă̓eLXgGfB^ƂēT^IȂ̂A
 *	AvP[VŃJX^}CYꍇ͋ŃI[o[ChƂ悢
 *	(ANZ[^gꍇ͂ɔłȂ̂ł̂܂܂ł悢Ȃ)B
 *	ȂA̎̓R}h̎sȊOɂ͉ĂȂ
 *
 *	̃L[蓖ĂɂĂ Ascension ̃}jA
 */
void CEditView::OnKeyDown(UINT nChar, UINT nFlags) {
	bool	bCtrl = toBoolean(::GetKeyState(VK_CONTROL) & 0x8000);
	bool	bShift = toBoolean(::GetKeyState(VK_SHIFT) & 0x8000);

	switch(nChar) {
	case VK_LEFT:	// []
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_WORDPREVEXTEND : CMDID_MOVE_WORDPREV, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_CHARPREVEXTEND : CMDID_MOVE_CHARPREV, 1);
		break;
	case VK_RIGHT:	// []
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_WORDNEXTEXTEND : CMDID_MOVE_WORDNEXT, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_CHARNEXTEXTEND : CMDID_MOVE_CHARNEXT, 1);
		break;
	case VK_UP:		// []
		if(bCtrl)	ExecCommand(CMDID_SCROLL_LINEUP, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEUPEXTEND : CMDID_MOVE_LINEUP, 1);
		break;
	case VK_DOWN:	// []
		if(bCtrl)	ExecCommand(CMDID_SCROLL_LINEDOWN, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEDOWNEXTEND : CMDID_MOVE_LINEDOWN, 1);
		break;
	case VK_HOME:	// [Home]
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_HOMEEXTEND : CMDID_MOVE_HOME);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEHOMEEXTEND : CMDID_MOVE_LINEHOME);
		break;
	case VK_END:	// [End]
		if(bCtrl)	ExecCommand(bShift ? CMDID_MOVE_ENDEXTEND : CMDID_MOVE_END);
		else		ExecCommand(bShift ? CMDID_MOVE_LINEENDEXTEND : CMDID_MOVE_LINEEND);
		break;
	case VK_NEXT:	// [PageDown]
		if(bCtrl)	ExecCommand(CMDID_SCROLL_PAGEDOWN, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_PAGEDOWNEXTEND : CMDID_MOVE_PAGEDOWN, 1);
		break;
	case VK_PRIOR:	// [PageUp]
		if(bCtrl)	ExecCommand(CMDID_SCROLL_PAGEUP, 1);
		else		ExecCommand(bShift ? CMDID_MOVE_PAGEUPEXTEND : CMDID_MOVE_PAGEUP, 1);
		break;
	case VK_RETURN:	// [Enter]
		ExecCommand(bCtrl ? CMDID_EDIT_INSERTPREVLINE : CMDID_EDIT_BREAK);
		break;
	case VK_DELETE:	// [Delete]
		if(bCtrl)	ExecCommand(CMDID_EDIT_DELETETONEXTWORD);
		else		ExecCommand(bShift ? CMDID_EDIT_DELETELINE : CMDID_EDIT_DELETE);
		break;
	case VK_BACK:	// [BackSpace]
		ExecCommand(bCtrl ? CMDID_EDIT_DELETETOPREVWORD: CMDID_EDIT_BACKSPACE);
		break;
	case VK_INSERT:	// [Insert]
		ExecCommand(CMDID_EDIT_TOGGLEOVERTYPEMODE);
		break;
	case VK_ESCAPE:	// [Esc]
		ExecCommand(CMDID_MOVE_CANCELSELECTION);
		break;
	}
}

///	@see	CWindow::OnKillFocus
void CEditView::OnKillFocus(HWND hwndNew) {
	if(m_pwndAutoComplete->IsWindowVisible()
			&& hwndNew != m_pwndAutoComplete->m_hWnd)
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(m_modeState.incrementalSearchState != ISS_NOTRUNNING)
		CmdMoveIncrementalSearch(ISS_NOTRUNNING);
	if(m_bActiveIMEComposition) {	// IME œ͒ł΂߂
		HIMC	hImc = ::ImmGetContext(m_hWnd);
		::ImmNotifyIME(hImc, NI_COMPOSITIONSTR, CPS_CANCEL, 0);
		::ImmReleaseContext(m_hWnd, hImc);
	}
	if(hwndNew != m_hWnd) {
		HideCaret();
		DestroyCaret();
	}
	InvalidateRect(0);
}
	
///	@see	CWindow::OnLButtonBblClk
void CEditView::OnLButtonDblClk(UINT nFlags, POINT pt) {
	// L[}NL^͖
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING && m_pKeyMacroPlayer->GetActiveView() == this)
		return;
	if(m_modeState.incrementalSearchState != ISS_NOTRUNNING)
		CmdMoveIncrementalSearch(ISS_NOTRUNNING);
	ExecCommand(CMDID_MOVE_SELECTCURRENTWORD, 0L);
}

///	@see	CWindow::OnLButtonDown
void CEditView::OnLButtonDown(UINT nFlags, POINT pt) {
	// L[}NL^͖
	if(m_pKeyMacroPlayer->GetState() == KMS_RECORDING
			&& m_pKeyMacroPlayer->GetActiveView() == this) {
		::MessageBeep(MB_OK);
		return;
	}

	CCharPos	pos;
	bool		bBoxDragging = false;
	char_t*		pwszUri = 0;

	// ͕⊮EBhEȂ
	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(m_modeState.incrementalSearchState != ISS_NOTRUNNING)
		CmdMoveIncrementalSearch(ISS_NOTRUNNING);

	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {	// 1sI
		if(toBoolean(nFlags & MK_CONTROL))	// SsI
			ExecCommand(CMDID_MOVE_SELECTALL, 0L);
		else {
			pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
			m_ldmLeftDown = LDM_LINESELECTION;
			SetSel(CCharPos(pos.m_iLine, 0), CCharPos(pos.m_iLine + 1, 0));
		}
		SetCapture();
		SetTimer(TIMERID_EXPANDLINESELECTION, 100, 0);
	} else if(m_modeState.bUseOLEDragDrop
			&& toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)
			&& HasSelection()
			&& IsOverSelection(pt)) {	// OLE hbOJn (`)
		const string_t	strSelection = GetSelection();
		set<CLIPFORMAT>	setClipFormats;

		bBoxDragging = true;
		setClipFormats.insert(CF_UNICODETEXT);
		setClipFormats.insert(::RegisterClipboardFormatW(RECTANGLE_TEXT_CLIP_FORMAT));
		m_pDragging->SetAvailableFormatSet(setClipFormats);
		m_pDragging->SetTextData(strSelection.c_str());
		m_ldmLeftDown = LDM_DRAGANDDROPBOXSELF;
		SetTimer(TIMERID_DRAGSCROLL, 100, 0);
		m_pDragging->DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		KillTimer(TIMERID_DRAGSCROLL);
		m_ldmLeftDown = LDM_NONE;	// OnLButtonUp ͌Ă΂Ȃ
	} else if(m_modeState.bUseOLEDragDrop
			&& HasSelection()
			&& IsOverSelection(pt)) {	// OLE hbOJn
		const string_t	strSelection = GetSelection();

		m_pDragging->SetTextData(strSelection.c_str());
		m_ldmLeftDown = LDM_DRAGANDDROPSELF;
		SetTimer(TIMERID_DRAGSCROLL, 50, 0);
		m_pDragging->DoDragDrop(DROPEFFECT_COPY | DROPEFFECT_MOVE);
		KillTimer(TIMERID_DRAGSCROLL);
		m_ldmLeftDown = LDM_NONE;	// OnLButtonUp ͌Ă΂Ȃ
	} else if(toBoolean(nFlags & MK_CONTROL)
			&& !m_pEventListeners->empty()
			&& IsOverInvokableLink(pt, pwszUri)) {
		for(set<IEditViewEventListener*>::iterator it =
				m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
			(*it)->OnInvokeUriLink(pwszUri);
		delete[] pwszUri;
	} else if(!toBoolean(nFlags & MK_SHIFT)
			&& toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// `IJn
		m_ldmLeftDown = LDM_BOXSELECTION;
		pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
		SetSelWithoutSelection(pos);
		BeginBoxSelect();
		OnMoveCaret();
		SetCapture();
		SetTimer(TIMERID_EXPANDSELECTION, 50, 0);
	} else {	// ̑B`IJnALbgړ
		m_ldmLeftDown = LDM_SELECTION;
		pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
		if(toBoolean(nFlags & MK_CONTROL)) {	// Ctrl -> ݂̒PI
			SetSelWithoutSelection(pos);
			ExecCommand(CMDID_MOVE_SELECTCURRENTWORD, 0L);
			m_ldmLeftDown = LDM_WORDSELECTION;
		} else if(toBoolean(nFlags & MK_SHIFT)) {	// Shift -> J[\ʒu܂őI
			if(toBoolean(::GetKeyState(VK_MENU) & 0x8000)) {	// Shift+Alt -> J[\ʒu܂ŋ`I
				m_ldmLeftDown = LDM_BOXSELECTION;
				BeginBoxSelect();
			}
			SetSel(*m_pAnchorPoint, pos);
		} else
			SetSelWithoutSelection(pos);
		SetCapture();
		SetTimer(TIMERID_EXPANDSELECTION, 50, 0);
	}

	if(!bBoxDragging && m_ldmLeftDown != LDM_BOXSELECTION) {
		m_modeState.selectionTraits = ST_NORMAL;
		InvalidateLine(m_pActivePoint->m_iLine);
	}
	SetFocus();
}

///	@see	CWindow::OnLButtonUp
void CEditView::OnLButtonUp(UINT nFlags, POINT pt) {
	if(m_ldmLeftDown == LDM_BOXSELECTION) {	// `II -> I͈͊m
		// ȂĂ悤ȋC
	}
	m_ldmLeftDown = LDM_NONE;
	KillTimer(TIMERID_EXPANDSELECTION);
	KillTimer(TIMERID_EXPANDLINESELECTION);
	ReleaseCapture();

	// I͈͊g咆ɉʊOŃ{^𗣂ƃLbgʒu܂ŃXN[ȂƂ̂
	m_pActivePoint->EnsureVisible();
}

///	@see	CWindow::OnMouseMove
void CEditView::OnMouseMove(UINT nFlags, POINT pt) {
	CCharPos	pos;	// J[\ʒu狁܂sƗ

	if(toBoolean(pt.x & 0x8000))	pt.x = 0;
	if(toBoolean(pt.y & 0x8000))	pt.y = 0;

	for(set<IEditViewEventListener*>::iterator it =
			m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
		(*it)->OnMoveCursor(pt);

	if(m_ldmLeftDown != LDM_NONE) {	// XN[
		if(pt.y < static_cast<long>(m_layoutInfo.nTopMargin + m_layoutInfo.nLineHeight / 2))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y > static_cast<long>(m_layoutInfo.nTopMargin
				+ m_layoutInfo.nLineHeight * GetVisibleLineCount()))
			OnVScroll(SB_LINEDOWN, 0, 0);
		if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))
			OnHScroll(SB_SETPOS, m_ptScroll.x - m_layoutInfo.nTabWidth, 0);
//		else if(pt.x >)
	}
	if(m_ldmLeftDown == LDM_SELECTION) {	// `I͈͂̊g/k
		pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
		SetSel(*m_pAnchorPoint, pos, false);
	} else if(m_ldmLeftDown == LDM_BOXSELECTION) {	// `I͈͂̊g/k
		pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
		SetSel(*m_pAnchorPoint, pos, false);
	} else if(m_ldmLeftDown == LDM_WORDSELECTION) {	// PI̊g/k
	} else if(m_ldmLeftDown == LDM_LINESELECTION ) {	// sI̊g/k
		pos = CharFromPos(pt, !m_modeState.bCaretExtenderByMouse);
		if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
			++pos.m_iLine;
			pos.m_iChar = 0;
		} else {	// ʏ̑I[hɈڍs
			KillTimer(TIMERID_EXPANDLINESELECTION);
			SetTimer(TIMERID_EXPANDSELECTION, 50, 0);
			m_ldmLeftDown = LDM_SELECTION;
		}
		SetSel(*m_pAnchorPoint, pos, false);
	} else if(m_ldmLeftDown == LDM_DRAGANDDROP) {	// IehbO
	}
}

///	@see	CWindow::OnMouseWheel
bool CEditView::OnMouseWheel(UINT nFlags, short zDelta, POINT pt) {
	UINT	nScrollLines;	// XN[s

	// VXeŐݒ肳Ăʂg
	if(!::SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &nScrollLines, 0))
		nScrollLines = 3;
	zDelta *= nScrollLines;
	SetScrollPos(SB_VERT, m_ptScroll.y - zDelta / WHEEL_DELTA, false);	// ɐݒ肵Ă (OnVScroll Q)
	OnVScroll(SB_THUMBTRACK, m_ptScroll.y - zDelta / WHEEL_DELTA, 0);

	return true;
}

///	LbgړɌĂяo
void CEditView::OnMoveCaret() {
	AssertValidAsWindow();

	// I`̍XV
	if(toBoolean(m_modeState.selectionTraits & ST_RECTANGLE)) {
		m_layoutInfo.iBoxSelectionActiveLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);
		m_layoutInfo.xBoxSelectionActive = PosFromChar(*m_pActivePoint).x
			+ m_ptScroll.x * m_layoutInfo.nHScrollRatio * GetAvgCharWidth() - m_layoutInfo.nLeftTabWidth + 1;
		InvalidateLines(m_pAnchorPoint->m_iLine, m_pActivePoint->m_iLine);
	}

	// ̑
	m_modeState.selectionTraits =	// Nbv{[h̐؂ւI
		static_cast<SelectionTraits>(~ST_PASTINGFROMCLIPBOARDRING & m_modeState.selectionTraits);
	ValidateCaretPos();
	CheckMatchBrackets();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
	for(set<IEditViewEventListener*>::iterator it =
			m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it) {
		if(m_modeState.bReadyToExpandAbbrev)
			(*it)->OnChangedAbbreviationExpansionReadyState(false, L"");
		(*it)->OnMoveCaret(*m_pActivePoint);
	}
	if(m_modeState.bReadyToExpandAbbrev)
		m_modeState.bReadyToExpandAbbrev = false;
}

///	@see	CWindow::OnNotify
bool CEditView::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	// c[`bṽeLXg
	if(lpNMHDR->hwndFrom == m_hwndToolTip && lpNMHDR->code == TTN_GETDISPINFO) {
		::SendMessageW(m_hwndToolTip, TTM_SETMAXTIPWIDTH, 0, 1000);	// sLɂ
		reinterpret_cast<LPNMTTDISPINFOW>(lpNMHDR)->lpszText = m_pwszTipText;
		return true;
	}
	return false;
}

///	@see	CWindow::OnPaint
void CEditView::OnPaint() {
	if(IsFreezed())	// ͖
		return;

	HDC				hDC;
	HBITMAP			hOldBMP;
	HPEN			hOldPen;
	PAINTSTRUCT		paint;
	RECT			rectLine, rectClient;
	const CEditDoc*	pDoc = GetDocument();
	CMinimalDC&		oDC = m_gdiObjects.oMemDC;

//	CTimer	tm(L"OnPaint");

	const length_t	cLines = pDoc->GetLineCount();			// _s
	const length_t	cDisplayLines = GetDisplayLineCount();	// \s
	const CCharPos	posTop = GetSelTopPoint();				// IJnʒu
	const CCharPos	posBottom = GetSelBottomPoint();		// IIʒu

	// 
	GetClientRect(&rectClient);
	::SetRect(&rectLine, 0, 0, rectClient.right, m_layoutInfo.nLineHeight);
	hDC = BeginPaint(&paint);
	m_layoutInfo.rectUpdate = paint.rcPaint;

	// 1s`
	hOldBMP = oDC.SelectObject(m_gdiObjects.hMemLineBMP);
	oDC.SetBkMode(OPAQUE);

	// `Jnʒu
	int				y = m_layoutInfo.nTopMargin;
	length_t		iLine;			// _s
	length_t		iDisplayLine;	// `Jn\s
	length_t		iOffset;
	LineIterator	itLine;
	CLineLayout*	pInfo = 0;
	length_t		iCurrentDisplayLine;	// Lbg\s (Iꍇ̂)
	
	if(m_layoutInfo.rectUpdate.top >= static_cast<long>(m_layoutInfo.nTopMargin))
		iDisplayLine = (m_layoutInfo.rectUpdate.top - m_layoutInfo.nTopMargin)
					/ m_layoutInfo.nLineHeight + m_ptScroll.y * m_layoutInfo.nVScrollRatio;
	else
		iDisplayLine = m_layoutInfo.rectUpdate.top / m_layoutInfo.nLineHeight + m_ptScroll.y * m_layoutInfo.nVScrollRatio;
	iDisplayLine = min(iDisplayLine, cDisplayLines - 1);
	if(iDisplayLine < cDisplayLines) {
		GetDisplayLineOffsetIndex(iDisplayLine, iLine, iOffset);
		y += (iDisplayLine - m_ptScroll.y * m_layoutInfo.nVScrollRatio) * m_layoutInfo.nLineHeight;
		y -= iOffset * m_layoutInfo.nLineHeight;
	}
	if(!HasSelection())
		iCurrentDisplayLine = DisplayLineFromLogicalLine(m_pActivePoint->m_iLine);

	// `JnsŏIs܂͕܂
	if(iLine < cLines) {
		itLine = GetDocument()->GetLineIterator(iLine);//CTimer otm(L"> Inn");
		for(; y < static_cast<int>(m_layoutInfo.rectUpdate.bottom)
				&& iLine < cLines; ++iLine, ++itLine) {
			// _s1s`
			pInfo = m_pLineLayoutManager->GetLine(iLine);
			y += DrawLine(iLine, y,
					itLine->GetLine(), itLine->GetBreakType(), pInfo) * m_layoutInfo.nLineHeight;

			// ݍsɉ
			if(m_foundationInfo.bDrawCurrentUnderline
					&& !HasSelection()
					&& iLine == iCurrentDisplayLine) {
				hOldPen = oDC.SelectObject((::GetFocus() == m_hWnd) ?
					m_gdiObjects.hUnderlinePen : m_gdiObjects.hIAUnderlinePen);
				oDC.MoveTo(m_layoutInfo.nLeftMargin, y - 1);
				oDC.LineTo(rectLine.right, y - 1);
				oDC.SelectObject(hOldPen);
			}
		}
	}

	// ȍ~
	if(m_layoutInfo.rectUpdate.bottom > y
			&& y > static_cast<int>(m_layoutInfo.nTopMargin + m_layoutInfo.nLineHeight - 1))
		oDC.FillSolidRect(0, y, rectClient.right,
			m_layoutInfo.rectUpdate.bottom - y, GetTextFoundation(ETT_NORMAL, NullCookie).bgColor);

	// ]̕`
	oDC.FillSolidRect(0, 0,
		rectClient.right, m_layoutInfo.nTopMargin, GetTextFoundation(ETT_NORMAL, NullCookie).bgColor);

	::BitBlt(hDC, m_layoutInfo.rectUpdate.left, m_layoutInfo.rectUpdate.top,
		m_layoutInfo.rectUpdate.right - m_layoutInfo.rectUpdate.left,
		m_layoutInfo.rectUpdate.bottom - m_layoutInfo.rectUpdate.top,
		oDC.GetSafeHdc(), m_layoutInfo.rectUpdate.left - m_layoutInfo.nLeftTabWidth,
		m_layoutInfo.rectUpdate.top, SRCCOPY);
	oDC.SelectObject(hOldBMP);

	// т̕`
	if(m_layoutInfo.rectUpdate.left < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {
		hOldBMP = oDC.SelectObject(m_gdiObjects.hMemLeftTabBMP);
		DrawLeftTab(iDisplayLine, min<length_t>(cLines - 1, iDisplayLine +
			(m_layoutInfo.rectUpdate.bottom - m_layoutInfo.rectUpdate.top) / m_layoutInfo.nLineHeight));
		::BitBlt(hDC, 0, 0, m_layoutInfo.nLeftTabWidth,
			rectClient.bottom - rectClient.top - 0, oDC.GetSafeHdc(), 0, 0, SRCCOPY);
		oDC.SelectObject(hOldBMP);
	}

	EndPaint(&paint);
}

///	@see	CWindow::OnRButtonDown
void CEditView::OnRButtonDown(UINT nFlags, POINT pt) {
	if(m_modeState.bRClickToMoveCaret && !IsOverSelection(pt))
		SetSelWithoutSelection(CharFromPos(pt, m_modeState.bCaretExtenderByMouse));
}

///	@see	CWindow::OnSetCursor
bool CEditView::OnSetCursor(HWND hWnd, UINT nHitTest, UINT message) {
	static length_t	iDetectedUriLineLast = -1;
	POINT			pt;	// J[\ʒu
	bool			bCursorChanged = false;

	::GetCursorPos(&pt);
	ScreenToClient(&pt);
	if(pt.x < static_cast<long>(m_layoutInfo.nLeftTabWidth)) {	// 
		::SetCursor(::LoadCursor(0, IDC_ARROW));
		return true;
	} else if(m_modeState.bUseOLEDragDrop && HasSelection()) {	// I͈ (hbO\ǂ)
		if(IsOverSelection(pt)) {
			::SetCursor(::LoadCursor(0, IDC_ARROW));
			bCursorChanged = true;
		}
	}

	// Ñ|bvAbvJ[\̌`ɕςꍇ
	if(m_modeState.bShowHintOnLink || m_modeState.bShowHandOnLink) {
		char_t*	pwszUri = 0;
		if(IsOverInvokableLink(pt, pwszUri)) {	// URI
			if(m_modeState.bShowHintOnLink) {	// |bvAbvo
				const length_t	iCursorDisplayLine = DisplayLineFromLogicalLine(CharFromPos(pt, true).m_iLine);
				if(iCursorDisplayLine != iDetectedUriLineLast) {
					// Ascension GfB^̎Ro͂2B
					// ɂē{ApȊO̖|WB
					// (pĂ̂)
					static const char_t*	pwszPromptJpn = L"Ctrl L[ȂNbNƃNN܂B\r\n";
					static const char_t*	pwszPromptEng = L"Click with pressed Ctrl key to invoke this link.\r\n";
					string_t				strPrompt = (::GetUserDefaultLangID() == 0x0411) ? pwszPromptJpn : pwszPromptEng;

					iDetectedUriLineLast = iCursorDisplayLine;
					ShowToolTip(strPrompt + pwszUri, 1000, 30000);
					delete[] pwszUri;
				}
			}
			if(m_modeState.bShowHandOnLink && !bCursorChanged) {	// J[\ς
				::SetCursor(::LoadCursor(0, IDC_HAND));
				bCursorChanged = true;
			}
		} else {
			iDetectedUriLineLast = -1;
			HideToolTip();
		}
	}

	return bCursorChanged;
}

///	@see	CWindow::OnSetFocus
void CEditView::OnSetFocus(HWND hwndOld) {
	// XN[ʒuɖ߂
	SetScrollPos(SB_HORZ, m_ptScroll.x, false);
	SetScrollPos(SB_VERT, m_ptScroll.y, true);
	InvalidateRect(0, true);

	if(hwndOld != m_hWnd) {
		// Lbg𕜊
		GetDocument()->GetController()->_OnViewGetFocus(*this);
		RecreateCaret();
		ValidateCaretPos();
	}
}

///	@see	CWindow::OnSize
void CEditView::OnSize(UINT nType, int cx, int cy) {
	HDC	hDC = GetDC();

	if(m_pwndAutoComplete->IsWindowVisible())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);

	// c[`bvɒʒm
	TOOLINFOW	ti;
	RECT		rectView;
	GetClientRect(&rectView);
	ZeroMemory(&ti, sizeof(TOOLINFOW));
	ti.cbSize = sizeof(TOOLINFOW);
	ti.hwnd = m_hWnd;
	ti.uId = 1;
	ti.rect = rectView;
	::SendMessageW(m_hwndToolTip, TTM_NEWTOOLRECT, 0, reinterpret_cast<LPARAM>(&ti));

	// TCY̕ύXɍ킹 m_hMemLineBMP ̍XV
	::DeleteObject(m_gdiObjects.hMemLineBMP);
	m_gdiObjects.hMemLineBMP						// т]̕ύXɖʓ|Ȃ̂ő傫߂̒lg
		= ::CreateCompatibleBitmap(hDC, cx, cy);	// ̑葼̕ύXɃrbg}bvKv͖
	ReleaseDC(hDC);
	if(cy != 0)	RecalcLeftTabWidth(cy);

	// ܂Ԃ̍XV
	if(m_modeState.wpmWrapMode == WPM_WINDOW)
		m_pLineLayoutManager->NotifyAll(LPL_FULL);

	// 擪s̍XV
	m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;
	OnVScroll(SB_THUMBTRACK, 0, 0);
	OnHScroll(SB_THUMBTRACK, 0, 0);

	ModifyScrollInfo(true, true);
}

///	@see	CWindow::OnSysColorChange
void CEditView::OnSysColorChange() {
	for(unsigned int i = 0; i < ETT_COUNT; ++i) {
		if(i != TT_KEYWORD && i != TT_ANNOTATION)
			SetTextFoundation(i, NullCookie, *(m_pTokenFoundations->tfs[i].ptf));
		else {
			map<TokenCookie, TTextFoundation>::const_iterator	it;
			const map<TokenCookie, TTextFoundation>*			pmapTfs = m_pTokenFoundations->tfs[i].pmapTfs;
			for(it = pmapTfs->begin(); it != pmapTfs->end(); ++it)
				SetTextFoundation(i, it->first, it->second);
		}
	}
	UpdateGDIObjects();
}

///	@see	CWindow::OnTimer
void CEditView::OnTimer(UINT nIDEvent) {
	if(nIDEvent == TIMERID_EXPANDSELECTION
			|| nIDEvent == TIMERID_EXPANDLINESELECTION) {	// I𒆂̎XN[
		POINT	pt;

		::GetCursorPos(&pt);
		ScreenToClient(&pt);
		if(m_ldmLeftDown == LDM_WORDSELECTION) {
		} else if(nIDEvent != TIMERID_EXPANDLINESELECTION)
			SetSel(*m_pAnchorPoint,
				CharFromPos(pt, !m_modeState.bCaretExtenderByMouse));
		else
			SetSel(*m_pAnchorPoint,
				CCharPos(CharFromPos(pt, !m_modeState.bCaretExtenderByMouse).m_iLine + 1, 0));
	} else if(nIDEvent == TIMERID_DRAGSCROLL) {	// hbO̎XN[
		POINT	pt;
		RECT	rect;

		::GetCursorPos(&pt);
		ScreenToClient(&pt);
		GetClientRect(&rect);

		if(pt.y >= rect.top &&
				pt.y <= rect.top + static_cast<long>(m_layoutInfo.nTopMargin)
				+ static_cast<long>(m_layoutInfo.nLineHeight / 2))
			OnVScroll(SB_LINEUP, 0, 0);
		else if(pt.y >= rect.bottom - static_cast<long>(m_layoutInfo.nLineHeight) && pt.y <= rect.bottom)
			OnVScroll(SB_LINEDOWN, 0, 0);
		else if(pt.x >= rect.left
				&& pt.x <= static_cast<long>(m_layoutInfo.nLeftTabWidth + m_layoutInfo.nLeftMargin))
			OnHScroll(SB_SETPOS, m_ptScroll.x - 3, 0);
		else if(pt.x >= rect.right - static_cast<long>(GetAvgCharWidth()) && pt.y <= rect.right)
			OnHScroll(SB_SETPOS, m_ptScroll.x + 3, 0);
	} else if(nIDEvent == TIMERID_LINEPARSE) {	// ͂̍sǂ݂
		// ...
	} else if(nIDEvent == TIMERID_CALLTIP) {	// c[`bv\
		KillTimer(TIMERID_CALLTIP);
		::SendMessageW(m_hwndToolTip, TTM_UPDATE, 0, 0L);
	}
}

/**
 *	@brief	hLgɑ΂ĕҏWsA
 *	CAEĝ߂̐ݒ肪ύXꂽ肷ƌĂяo
 *
 *	̃\bh̑1͏GȃZ}eBNXB
 *	܂ MFC ̎dlƂ͈قȂ Manah::CDocument::UpdateAllViews
 *	͑𒼐ڍsr[ɑ΂Ă CView::OnUpdate ĂяoB
 *	1ڑsIuWFNg\̂ MFC ƓA
 *	̃IuWFNg̓r[łȂĂ悭Ar[̐݌v҂ <var>pSender</var>
 *	̈ӖRɌ߂悤ɂĂB
 *
 *	܂AhLgł͂ȂCAEg}l[W̃\bhĂяoB
 *	̏ꍇAKvȂ̂̓NCAg̈Ŝ̍ĕ`ƍׂŁAɓƂ͖B
 *	 <var>pHint</var> ̓CAEg}l[Wւ̃|C^ɂȂB
 *
 *	ȉ͂̃\bhhLgĂяoꂽꍇ̘błB
 *
 *	Ascension::CEditView ɂ <var>pSender</var> ƂȂ肤̂
 *	ȉ̂ꂩ̃NXhNX̃CX^Xł
 *	(<var>udi.usSummary</var>  US_OPERATION_DELETE AUS_OPERATION_INSERT
 *	̏ꍇ)B pSender ł邩ɂÃ\bh͊U镑ςB
 *	ȉ͂̏ڍׂł:
 *
 *	<dl>
 *		<dt>CEditPoint</dt>
 *		<dd>Ascension GfB^̑唼̑ (I͈͂폜ƂsƂ)
 *			͂̃IuWFNgʂčs (m_pActivePoint ĝŎۂ
 *			CVisibleEditPoint ̃CX^Xł)B<var>pSender</var> 
 *			CEditPoint ̏ꍇAIuWFNg m_pActivePoint
 *			ȊÕ[U쐬Cӂ̕ҏW_ł邩ɂ苓͍XɕωB
 *			ANeBu|Cg̏ꍇA<strong>Lbg͓K؂ȈʒuɈړĂȂƂ݂Ȃ</strong>
 *			(Ⴆ CEditPoint::Delete ̎)AҏWɓĂ̂ɒʒms (CEditPoint::OnUpdateDocument)B
 *			<var>pSender</var> [U̕ҏW_łꍇ͏L̑ɉA
 *			m_pActivePoint  m_pAnchorPoint ɑ΂ĂʒmsB CEditPoint::EnsureVisible
 *			ĂяoɂLbg̉͍s<strong>Ȃ</strong>
 *		</dd>
 *		<dt>CEditDoc</dt>
 *		<dd>_ł̓AhD/hDsꍇ̂ <var>pSender</var> 
 *			CEditDoc CX^XɂȂB̏ꍇAe󂯂SĂ̕ҏW_ɒʒmsA
 *			tH[JXĂr[̃LbgK؂ȏꏊɈړ</dd>
 *		<dt>CEditView</dt>
 *		<dd><var>pSender</var>  CEditView ̃CX^XɂȂ̂
 *			CEditView ̃\bhɂҏWsꍇ݂̂łB
 *			̏ꍇ̋ CEditDoc Ɠł
 *		</dd>
 *	</dl>
 *
 *	݂̐݌vł <var>pSender</var> hLg̊O猈肳̂ CEditDoc::DeleteText A
 *	CEditDoc::InsertText \bhĂяoꍇłB̃\bhĂяoɎgꂽ1̂܂
 *	̃\bh̑1ƂȂBhLgύX鏈ꍇ͈ȏ̃Z}eBNXɓKĂȂ΂ȂȂB
 *	ȂȀꍇ̃\bh͍XV񂩂烌CAEgXVB
 *
 *	@param pSender	𒼐ڍsIuWFNg
 *	@param lParam	gpȂ
 *	@param pHint	hLgCAEg}l[Wւ̃|C^
 *	@see			CView::OnUpdate
 */
void CEditView::OnUpdate(CObject* pSender, LPARAM lParam, void* pHint) {//CTimer	tm(L"CEditView::OnUpdate");
	HWND	hwndActive = ::GetFocus();	// tH[JXEBhE
										// ̑ŃLbg𓮂Ȃ΂ȂȂꍇA
										// Lbg𓮂̂͑sr[ł͂ȂA
										// ̎_ŃtH[JXr[ł

	// CEditDoc::InsertText  CEditDoc::DeleteText 
	// pHint ɃhLgւ̃|C^nĂ
	// pView ̓hLgXVr[ł邪ɎgpȂ
	// (MFC ̎dlƂ͈قȂ this == pSender ̏ꍇł\bh͌Ăяo; Manah)
	if(pHint == GetDocument()) {
		TUpdateInfo		udi;
		length_t		cModifiedLines = 0;

		reinterpret_cast<CEditDoc*>(pHint)->GetModification(udi);

		if(udi.usSummary == US_OPERATION_INSERT) {	// } (udi.posBegin == udi.posEnd)
			if(m_pOriginalView != this)
				goto VIEW_IS_NOT_ORIGINAL;
			if(udi.posEnd.m_iLine == udi.posResult.m_iLine) {	// s܂܂ĂȂ
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINEANNOTATION)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				if(cModifiedLines != 0) {
					for(set<IEditViewEventListener*>::iterator it =
							m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
						(*it)->OnLineOperationEvent(LOE_MODIFIED, udi.posEnd.m_iLine, cModifiedLines);
				}
			} else {	// s
				m_pLineLayoutManager->InsertLines(udi.posEnd.m_iLine + 1, udi.posResult.m_iLine);
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINEANNOTATION)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				for(set<IEditViewEventListener*>::iterator it =
						m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it) {
					if(cModifiedLines != 0)
						(*it)->OnLineOperationEvent(LOE_MODIFIED, udi.posEnd.m_iLine, cModifiedLines);
					(*it)->OnLineOperationEvent(LOE_CREATED, udi.posEnd.m_iLine + 1,
						udi.posResult.m_iLine - udi.posEnd.m_iLine);
				}
				if(IsFreezed()) {	// ̕`҂s炷
					set<length_t>::iterator	it;
					for(it = m_setInvalidLines.begin(); it != m_setInvalidLines.end(); ++it) {
						if(*it >= udi.posEnd.m_iLine)
							*it += udi.posResult.m_iLine - udi.posEnd.m_iLine;
					}
				}
				cModifiedLines = GetVisibleLineCount() /*- (udi.posBegin.m_iLine - m_ptScroll.y) + 1*/;
			}
//			if(!m_bFreezed && GetKeyMacroState() == KMS_NONE)
//				OnMoveCaret();
		} else if(udi.usSummary == US_OPERATION_DELETE) {	// 폜
			if(m_pOriginalView != this)
				goto VIEW_IS_NOT_ORIGINAL;
			if(udi.posBegin.m_iLine == udi.posEnd.m_iLine) {	// s܂܂ĂȂ
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posEnd.m_iLine) >= LPL_MULTILINEANNOTATION)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posEnd.m_iLine);
				if(cModifiedLines != 0) {
					for(set<IEditViewEventListener*>::iterator it =
							m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
						(*it)->OnLineOperationEvent(LOE_MODIFIED, udi.posEnd.m_iLine, cModifiedLines);
				}
			} else {	// s
				m_pLineLayoutManager->DeleteLines(udi.posBegin.m_iLine + 1, udi.posEnd.m_iLine);
				if(m_pLineLayoutManager->GetLineParseLevel(udi.posBegin.m_iLine) >= LPL_MULTILINEANNOTATION)
					cModifiedLines = m_pLineLayoutManager->ModifyLine(udi.posBegin.m_iLine);
				for(set<IEditViewEventListener*>::iterator it =
						m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it) {
					if(cModifiedLines != 0)
						(*it)->OnLineOperationEvent(LOE_MODIFIED, udi.posBegin.m_iLine, cModifiedLines);
					(*it)->OnLineOperationEvent(LOE_DELETED,
						udi.posBegin.m_iLine + 1, udi.posEnd.m_iLine - udi.posBegin.m_iLine);
				}
				if(IsFreezed()) {	// ̕`҂s炷
					set<length_t>::iterator	it = m_setInvalidLines.begin();
					while(it != m_setInvalidLines.end()) {
						if(*it > udi.posBegin.m_iLine && *it <= udi.posEnd.m_iLine)
							it = m_setInvalidLines.erase(it);
						else {
							if(*it >= udi.posEnd.m_iLine)
								*it -= udi.posEnd.m_iLine - udi.posBegin.m_iLine;
							++it;
						}
					}
				}
			/*	if(m_hWnd == hwndActive && !m_bFreezed) {
					m_pAnchorPoint->MoveToPoint(udi.posResult);
					m_pActivePoint->MoveToPoint(udi.posResult);
					OnMoveCaret();
				}*/
				cModifiedLines = GetVisibleLineCount() /*- (udi.posBegin.m_iLine - m_ptScroll.y) + 1*/;
			}
//			if(!m_bFreezed && GetKeyMacroState() == KMS_NONE)
//				OnMoveCaret();
		} else if(udi.usSummary == US_SAVEDOCUMENT) {	// hLg̕ۑ
			InvalidateRect(0, false);
			return;
		} else if(udi.usSummary == US_BEGIN_UNDOGROUP) {
			Freeze();
			return;
		} else if(udi.usSummary == US_END_UNDOGROUP) {
			if(hwndActive == m_hWnd)
				SetSelWithoutSelection(udi.posResult, false, false);
//			else {
//				m_pAnchorPoint->MoveToPoint(udi.posResult);
//				m_pActivePoint->MoveToPoint(udi.posResult);
//			}
			ModifyScrollInfo(true, true);
			Unfreeze();
			if(m_pOriginalView == this) {
				OnMoveCaret();
				for_each(m_setClones.begin(), m_setClones.end(), mem_fun(CEditView::OnMoveCaret));
			} else {
				m_pOriginalView->OnMoveCaret();
				for_each(m_pOriginalView->m_setClones.begin(),
					m_pOriginalView->m_setClones.end(), mem_fun(CEditView::OnMoveCaret));
			}
			if(hwndActive == m_hWnd)
				m_pActivePoint->EnsureVisible();
			return;
		} else
			assert(false);

		// XN[ʒȕC
VIEW_IS_NOT_ORIGINAL:
		if(!IsFreezed())
			ModifyScrollInfo(true, true);
		if(udi.posBegin.m_iLine < m_iFirstVisibleLine)	// 擪s̍XV
			m_iFirstVisibleLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;

		// ҏW̉e󂯂ҏW_̏
		for(set<CEditPoint*>::iterator it = m_setEditPoints.begin(); it != m_setEditPoints.end(); ++it) {
			if((*it)->IsSynchronousWithOtherEdit())
				(*it)->OnUpdateDocument(udi);
		}

		m_pAnchorPoint->OnUpdateDocument(udi);
		m_pActivePoint->OnUpdateDocument(udi);
		if(m_pOriginalView != this) {
			InvalidateLine(m_pAnchorPoint->m_iLine);
			if(m_pAnchorPoint->m_iLine != m_pActivePoint->m_iLine) {
				if(!IsFreezed())
					UpdateWindow();
				InvalidateLine(m_pActivePoint->m_iLine);
			}
		}
		if((hwndActive == m_hWnd || hwndActive == CEditView::m_pwndAutoComplete->m_hWnd)
				&& !IsFreezed()
				&& (pSender == this
				|| pSender == m_pOriginalView
			/*	|| m_setClones.find(reinterpret_cast<CEditView*>(pSender)) != m_setClones.end()*/))
			SetSelWithoutSelection(udi.posResult, true, false);	// ̃\bḧvZ
		else
			OnMoveCaret();

		RecalcLeftTabWidth();
		if(m_pOriginalView == this) {
			if(cModifiedLines == 1) {
				InvalidateLine(udi.posBegin.m_iLine);
				UpdateWindow();	// sƂ݂͂̕
				for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it) {
					(*it)->InvalidateLine(udi.posBegin.m_iLine);
					(*it)->UpdateWindow();
				}
			} else {
				InvalidateLines(udi.posBegin.m_iLine, -1);
				for(set<CEditView*>::iterator it = m_setClones.begin(); it != m_setClones.end(); ++it)
					(*it)->InvalidateLines(udi.posBegin.m_iLine, -1);
			}
		}
	} else if(pHint == m_pLineLayoutManager) {	// CAEgݒ肪ύXꂽ
		if(!IsFreezed())
			ModifyScrollInfo(true, true);

		const length_t	iLine = LogicalCharFromDisplayChar(CCharPos(m_ptScroll.y, 0)).m_iLine;

		InvalidateLines(iLine, -1);
		if(m_pOriginalView == this) {
			OnMoveCaret();
			for_each(m_setClones.begin(), m_setClones.end(), mem_fun(CEditView::OnMoveCaret));
		} else {
			m_pOriginalView->OnMoveCaret();
			for_each(m_pOriginalView->m_setClones.begin(),
				m_pOriginalView->m_setClones.end(), mem_fun(CEditView::OnMoveCaret));
		}
	} else {	// !ɗ邱Ƃ͖!
		assert(false);
		m_pLineLayoutManager->ReconstructAll();
//		if(m_pEventListener != 0)
//			m_pEventListener->OnChangeLines(...);	// Q
		RecalcLeftTabWidth();
		InvalidateRect(0, false);	// Ƃ肠S
		ModifyScrollInfo(true, true);
	}

	if((m_hWnd == hwndActive || m_hWnd == CEditView::m_pwndAutoComplete->m_hWnd)
			&& !IsFreezed()
			&& m_pKeyMacroPlayer->GetState() != KMS_PLAYING) {
		ValidateCaretPos();
		for(set<IEditViewEventListener*>::iterator it =
				m_pEventListeners->begin(); it != m_pEventListeners->end(); ++it)
			(*it)->OnMoveCaret(*m_pActivePoint);
	}
}

///	@see	CWindow::OnVScroll
void CEditView::OnVScroll(UINT nSBCode, UINT nPos, HWND hwndScrollBar) {
	const int	nOrgPos = m_ptScroll.y;	// ̈ʒuۑ
	int			nMinPos, nMaxPos;		// őAŏʒu
	const int	cVisibleLines = GetVisibleLineCount();
	
	GetScrollRange(SB_VERT, &nMinPos, &nMaxPos);

//	if(m_pwndAutoComplete->IsWindowVisible())
//		m_pwndAutoComplete->ShowWindow(SW_HIDE);
	if(cVisibleLines > (nMaxPos - nMinPos) * static_cast<int>(m_layoutInfo.nVScrollRatio)) {
		m_ptScroll.y = 0;
//		DrawLeftTab(0, GetVisibleLineCount());
		return;
	}

	switch(nSBCode) {
	case SB_LINEUP:			// 1s
		--m_ptScroll.y;	break;
	case SB_LINEDOWN:		// 1s
		++m_ptScroll.y;	break;
	case SB_PAGEUP:			// 1y[W
		m_ptScroll.y -= GetVisibleLineCount() - 1;	break;
	case SB_PAGEDOWN:		// 1y[W
		m_ptScroll.y += GetVisibleLineCount() - 1;	break;
	case SB_TOP:			// [
		m_ptScroll.y = nMinPos;	break;
	case SB_BOTTOM:			// [
		m_ptScroll.y = nMaxPos;	break;
	case SB_THUMBTRACK:		// hbO or zC[
		m_ptScroll.y = GetScrollTrackPos(SB_VERT);	break;	// 32rbglg
	case SB_SETPOS:			// IȃXN[
		m_ptScroll.y = nPos;	break;
	default:
		return;
	}

	// 
	if(m_ptScroll.y < nMinPos)
		m_ptScroll.y = nMinPos;
	else if(m_ptScroll.y > static_cast<long>(nMaxPos - GetVisibleLineCount() + 1))
		m_ptScroll.y = nMaxPos - GetVisibleLineCount() + 1;
	if(m_ptScroll.y == nOrgPos)	// XN[Ȃ
		return;

	// 擪s̍XV
//	if(m_ptScroll.y - nOrgPos == 1)

	// ĕ`Ȃ
	if(dif<long>(m_ptScroll.y, nOrgPos) < cVisibleLines - 1) {	// XN[ʂ1y[Wȉ
		RECT		rectScroll;			// XN[Ώ
		const int	dy = (nOrgPos - m_ptScroll.y) * m_layoutInfo.nVScrollRatio * m_layoutInfo.nLineHeight;
		RECT		rectUpdate;

		GetClientRect(&rectScroll);
		rectUpdate = rectScroll;
		rectScroll.top = m_layoutInfo.nTopMargin;
		if(dy > 0) {
			rectUpdate.top += m_layoutInfo.nTopMargin;
			rectUpdate.bottom = rectUpdate.top + dy;
		} else
			rectUpdate.top = rectUpdate.bottom + dy;
		ScrollWindowEx(0, dy, &rectScroll, &rectScroll, 0, 0, SW_INVALIDATE);
		InvalidateRect(&rectUpdate, false);
	} else
		InvalidateRect(0, false);

	HideToolTip();
	SetScrollPos(SB_VERT, m_ptScroll.y);
	ValidateCaretPos();
	if(m_bActiveIMEComposition)
		ValidateIMEWindowPos();
	UpdateWindow();

	if(m_pwndAutoComplete->IsWindow())
		m_pwndAutoComplete->ShowWindow(SW_HIDE);
}

/* [EOF] */