// KeyMacroPlayer.h
// (c) 2003-2004 exeal

#ifndef _KEY_MACRO_PLAYER_H_
#define _KEY_MACRO_PLAYER_H_

#include "..\..\Manah\Object.h"
#include <list>
#include <fstream>


namespace Ascension {

class CEditView;
enum CommandIdentifier;


/// L[}N̏
enum KeyMacroState {
	/// 
	KMS_NONE,
	///	Đ
	KMS_PLAYING,
	/// L^
	KMS_RECORDING,
	/// L^ꎞ~
	KMS_PAUSING,
};

/// L[}N̓e
struct TKeymacroCommand {
	CommandIdentifier	cmd;	//	R}h
	LPARAM				lParam;	//	
};


// EMacroIsAlreadyRunning exception class definition and implementation
/////////////////////////////////////////////////////////////////////////////

///	L[}N̎sȂ̂ő̑͂łȂƂ\O
class EMacroIsAlreadyRunning : public std::logic_error {
	// RXgN^
public:
	EMacroIsAlreadyRunning()
			: std::logic_error("This operation can not be achieved when the macro is running.") {
	}
};


// CKeyMacroPlayer class definition
/////////////////////////////////////////////////////////////////////////////

///	L[}NǗNX
class CKeyMacroPlayer : public Manah::CObject {
	// RXgN^
private:
	CKeyMacroPlayer();
	CKeyMacroPlayer(const CKeyMacroPlayer& rhs);

	// Zq
private:
	operator =(const CKeyMacroPlayer& rhs);

	// \bh ()
public:
	void					AddCommand(const TKeymacroCommand& oCommand) throw(EMacroIsAlreadyRunning);
	void					CancelRecording();
	void					Clear() throw(EMacroIsAlreadyRunning);
	static CKeyMacroPlayer*	Create();
	bool					Load(const std::wstring& strPathName);
	void					Pause();
	void					Play(CEditView& oView) throw(EMacroIsAlreadyRunning);
	bool					Save(const std::wstring& strPathName) const;
	void					StartRecording(CEditView& oView) throw(EMacroIsAlreadyRunning);
	void					StopRecording();

	// \bh ()
public:
	CEditView*				GetActiveView() const {
		return m_pActiveView;
	}
	KeyMacroState			GetState() const {
		return m_kmsState;
	}

	// f[^o
private:
	KeyMacroState				m_kmsState;			// L[}N̏
	std::list<TKeymacroCommand>	m_listCommands;		// L^ĂR}h̃Xg
	std::list<TKeymacroCommand>	m_listRecording;	// L^̃R}h̃Xg
	CEditView*					m_pActiveView;		// L^AĐ̃r[
};

} // namespace Ascension

#endif /* _KEY_MACRO_PLAYER_H_ */

/* [EOF] */