// KeywordManager.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "KeywordManager.h"
#include <algorithm>	// binary_search

using namespace Ascension;
using namespace std;


namespace {
	bool _CompareKeyword(const char_t* psz1, const char_t* psz2) {
		return ::StrCmpW(psz1, psz2) < 0;
	}

	bool _CompareKeywordNoCase(const char_t* psz1, const char_t* psz2) {
		return ::StrCmpIW(psz1, psz2) < 0;
	}
}


// CKeywordManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CKeywordManager::CKeywordManager() {
}

///	Rs[RXgN^
CKeywordManager::CKeywordManager(const CKeywordManager& rhs) {
	vector<char_t*>::size_type	cWords = rhs.m_vecKeywords.size();

	m_vecKeywords.reserve(cWords);
	for(vector<char_t*>::size_type i = 0; i < cWords; ++i)
		m_vecKeywords.push_back(wcsdup(rhs.m_vecKeywords[i]));
}

///	fXgN^
CKeywordManager::~CKeywordManager() {
	Clear();
}

///	L[[h̒ǉBłɓ̂ƉȂ
void CKeywordManager::Add(const string_t& strKeyword) {
	AssertValid();

	char_t*	pszNew = 0;

	// ɕׂ
	for(vector<char_t*>::size_type i = 0; i < m_vecKeywords.size(); ++i) {
		if(m_vecKeywords[i] == strKeyword)
			return;
		else if(m_vecKeywords[i] > strKeyword) {
			vector<char_t*>::iterator	it = m_vecKeywords.begin();

			pszNew = new char_t[strKeyword.length() + 1];
			wcscpy(pszNew, strKeyword.c_str());
			m_vecKeywords.insert(it + i, pszNew);
			return;
		}
	}
	// Ōɒǉ
	pszNew = new char_t[strKeyword.length() + 1];
	wcscpy(pszNew, strKeyword.c_str());
	m_vecKeywords.push_back(pszNew);
}

///	L[[hSč폜
void CKeywordManager::Clear() {
	AssertValid();

	vector<char_t*>::iterator	it = m_vecKeywords.begin();
	while(it != m_vecKeywords.end()) {
		delete[] *it;
		it = m_vecKeywords.erase(it);
	}
}

///	<var>pszText</var> ̐擪ɈvL[[hA݂邩ǂԂ
bool CKeywordManager::Find(const char_t* pszText, length_t cch, bool bIgnoreCase) const {
	AssertValid();
	assert(pszText != 0);

	if(m_vecKeywords.size() == 0 || cch == 0)
		return false;

	char_t	chOrg = pszText[cch];	// XbhZ[tłȂ@
	const_cast<char_t*>(pszText)[cch] = 0;
	bool	bFound = binary_search(m_vecKeywords.begin(), m_vecKeywords.end(),
						pszText, bIgnoreCase ? _CompareKeywordNoCase : _CompareKeyword);
	const_cast<char_t*>(pszText)[cch] = chOrg;
	return bFound;
}

/* [EOF] */