// LineLayout.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "LineLayout.h"
#include "EditView.h"
#include "KeywordManager.h"

using namespace Ascension;
using namespace Manah;
using namespace Manah::Text;
using namespace std;
using Manah::Windows::GDI::CMinimalDC;
//using CLineLayoutManager::BidiClass;


// InsertLine AInsertLines ŉ͂郌xB
// hLg̓ǂݍݑxƂ̌̍ŏ̍s̓I[o[wbhƂ̃g[hɂȂ
//#ifdef _DEBUG
//#define MINIMAL_PARSE_LEVEL	LPL_TOKEN
//#else
#define MINIMAL_PARSE_LEVEL	LPL_MULTILINEANNOTATION
//#endif /* _DEBUG */

#ifdef _DEBUG
#include "..\..\Manah\Timer.h"
using Manah::Windows::CTimer;
using Manah::Windows::dout;
template<typename T>
void dumpArray(const T* arr, size_t c) {
	for(size_t i = 0; i < c; ++i)
		Manah::Windows::dout << arr[i] << L",";
	Manah::Windows::dout << L"\n";
}
#endif /* _DEBUG */


// CLineLayoutManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CLineLayoutManager::CLineLayoutManager(CEditView* pView)
		: m_pView(pView), m_pHead(0), m_pxMax(0), m_pMaxDisplayWidthLine(0), m_pLineCache(0) {
	m_pLexer = new CLexer(this);
}

///	fXgN^
CLineLayoutManager::~CLineLayoutManager() {
	DeleteAllLines();
	delete m_pLexer;
}

///	CAEgׂĔj
void CLineLayoutManager::DeleteAllLines() {
	AssertValid();

	CLineLayout*	pCurrent = m_pHead;
	CLineLayout*	pNext;

	while(pCurrent != 0) {
		pNext = pCurrent->m_pNext;
		delete pCurrent;
		pCurrent = pNext;
	}
	m_pHead = 0;
	m_pxMax = 0;
	m_pMaxDisplayWidthLine = 0;
	m_pLineCache = 0;
}

/**
 *	w肵s̃CAEg폜
 *	@param iLine			폜sԍ
 *	@exception out_of_range	<var>iLine</var> ݂Ȃsł΃X[
 */
void CLineLayoutManager::DeleteLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	if(pInfo->m_pNext == 0) {
		if(pInfo->m_pPrev == 0)
			m_pHead = 0;
		else
			pInfo->m_pPrev->m_pNext = 0;
		if(m_pView->m_modeState.wpmWrapMode == WPM_NONE && pInfo == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
	} else {
		CLineLayout*	pTemp = pInfo->m_pNext;
		if(pInfo->m_pPrev == 0) {
			pInfo->m_pNext->m_pPrev = 0;
			m_pHead = pInfo->m_pNext;
		} else {
			pInfo->m_pPrev->m_pNext = pInfo->m_pNext;
			pInfo->m_pNext->m_pPrev = pInfo->m_pPrev;
		}
		if(m_pView->m_modeState.wpmWrapMode == WPM_NONE && pInfo == m_pMaxDisplayWidthLine)
			ModifyMaxDisplayWidth();
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
		pInfo = pTemp;
	}

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pInfo->m_pPrev == 0 && pInfo->m_tcFromPrev == NullCookie)
		return;
	if(pInfo->m_pPrev != 0 && pInfo->m_pPrev->m_tcToNext == pInfo->m_tcFromPrev)
		return;
	while(true) {
		ParseLineMultilineCommentContinue(iLine, pInfo);
		if(pInfo->m_pNext == 0
				|| (pInfo->m_pNext->m_lplParseLevel < LPL_MULTILINEANNOTATION)
				|| pInfo->m_tcToNext == pInfo->m_pNext->m_tcFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		++iLine;
	}
}

/**
 *	̍s̃CAEg폜
 *	@param iStart	폜Jns
 *	@param iEnd		폜Is (̍s폜)
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::DeleteLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

	CLineLayout*	pInfo = GetLineInternal(iStart);
	CLineLayout*	pLast = GetLineInternal(iEnd);

	if(pInfo == 0 || pLast == 0)
		throw out_of_range("Specified lines are not found.");
	m_pLineCache = 0;

	CLineLayout*	pNext = 0;
	CLineLayout*	pBeginPrev = pInfo->m_pPrev;
	CLineLayout*	pEndNext = pLast->m_pNext;
	bool			bMaxIsDeleted = false;

	if(pInfo == m_pHead)
		m_pHead = pLast->m_pNext;

	while(true) {	// 폜
		pNext = pInfo->m_pNext;
		if(pInfo == m_pMaxDisplayWidthLine)
			bMaxIsDeleted = true;
		if(pInfo == m_pView->m_layoutInfo.pAppDefinedSingleLine)
			m_pView->m_layoutInfo.pAppDefinedSingleLine = 0;
		delete pInfo;
		if(pNext == pEndNext)
			break;
		pInfo = pNext;
	}

	if(pBeginPrev != 0)
		pBeginPrev->m_pNext = pEndNext;
	if(pEndNext != 0)
		pEndNext->m_pPrev = pBeginPrev;

	if(m_pView->m_modeState.wpmWrapMode == WPM_NONE && bMaxIsDeleted)
		ModifyMaxDisplayWidth();

	if(pEndNext == 0)
		return;
	pInfo = pEndNext;

	// 㑱̉e󂯂s`FbN (pInfo  iLine ͊ɍ폜̍swĂ)
	if(pInfo->m_pPrev == 0 && pInfo->m_tcFromPrev == NullCookie)
		return;
	if(pInfo->m_pPrev != 0 && pInfo->m_pPrev->m_tcToNext == pInfo->m_tcFromPrev)
		return;
	unsigned long	iLine = iStart;
	while(true) {
		ParseLineMultilineCommentContinue(iLine, pInfo);
		if(pInfo->m_pNext == 0
				|| (pInfo->m_pNext->m_lplParseLevel < LPL_MULTILINEANNOTATION)
				|| pInfo->m_tcToNext == pInfo->m_pNext->m_tcFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		++iLine;
	}
}
/*
///	w肵R[h|Cg̑oeLXgԂ
BidiClass CLineLayoutManager::GetBidiClass(unsigned long cp) {
	// bidi_class.pl 쐬
#if(ASCENSION_UNICODE_VERSION != 0x0400)
#error This method is based on old version of Unicode.
#endif
#include "Script\LineLayout_BidiClassList_4_0"
#define CHECK_BIDI_CLASS(klass)																	\
	if(binary_search(arr##klass, arr##klass + sizeof(arr##klass) / sizeof(unsigned long), cp))	\
		return BC_##klass

	switch(cp) {
	case 0x202A:	return BC_LRE;
	case 0x202B:	return BC_RLE;
	case 0x202C:	return BC_PDF;
	case 0x202D:	return BC_LRO;
	case 0x202E:	return BC_RLO;
	}
	CHECK_BIDI_CLASS(R);
	CHECK_BIDI_CLASS(AL);
	CHECK_BIDI_CLASS(EN);
	CHECK_BIDI_CLASS(ES);
	CHECK_BIDI_CLASS(ET);
	CHECK_BIDI_CLASS(AN);
	CHECK_BIDI_CLASS(CS);
	CHECK_BIDI_CLASS(NSM);
	CHECK_BIDI_CLASS(BN);
	CHECK_BIDI_CLASS(B);
	CHECK_BIDI_CLASS(S);
	CHECK_BIDI_CLASS(WS);
	CHECK_BIDI_CLASS(ON);
	return BC_L;
}*/

/**
 *	w肵s̃CAEgԂ
 *	@param iLine	s
 *	@return			CAEgB<var>iLine</var> Ȃ null
 */
CLineLayout* CLineLayoutManager::GetLine(length_t iLine) const {
	AssertValid();

	CLineLayout*	pInfo = GetLineInternal(iLine);
	if(pInfo != 0 && pInfo->m_lplParseLevel != LPL_FULL)	// łĂȂ
		const_cast<CLineLayoutManager*>(this)->ParseLineCharacterPositions(iLine, pInfo);
	assert(pInfo == 0 || pInfo->m_lplParseLevel == LPL_FULL);
	return pInfo;
}

///	GetLine ̓ (Ԃs͖͂̏ꍇ)
CLineLayout* CLineLayoutManager::GetLineInternal(length_t iLine) const {
	AssertValid();

	CLineLayout*	pInfo;
	length_t		iRest;
	bool			bForward;	// m_pNext ŌƂ^

	if(m_pLineCache == 0 || iLine <= dif(iLine, m_iLineCache)) {	// LbVgȂ or n_̕߂
		pInfo = m_pHead;
		iRest = iLine;
		bForward = true;
	} else {	// LbV_̕߂Ƃ
		pInfo = m_pLineCache;
		iRest = dif(m_iLineCache, iLine);
		bForward = m_iLineCache < iLine;
	}

	if(bForward) {
		while(pInfo != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pInfo;
				return pInfo;
			}
			pInfo = pInfo->m_pNext;
			--iRest;
		}
	} else {
		while(pInfo != 0) {
			if(iRest == 0) {
				m_iLineCache = iLine;
				m_pLineCache = pInfo;
				return pInfo;
			}
			pInfo = pInfo->m_pPrev;
			--iRest;
		}
	}
	return 0;
}

/**
 *	ws̉͂ǂ̒xIĂ邩Ԃ
 *	@param iLine	_s
 *	@return			̓x
 */
LineParseLevel CLineLayoutManager::GetLineParseLevel(length_t iLine) const throw(out_of_range) {
	AssertValid();

	CLineLayout*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	return pInfo->m_lplParseLevel;
}

///	ő\s̕\Ԃ
int CLineLayoutManager::GetMaxDisplayWidth() const {
	AssertValid();
	return m_pxMax;
}

/**
 *	w肵s̃CAEg쐬AXgɒǉ
 *	@param iLine	sԍ
 *	@exception		iLine }s\ȍsԍł <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLine(length_t iLine) throw(out_of_range) {
	AssertValid();
	if(iLine > m_pView->GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pInfo = 0;
	CLineLayout*	pPrev = 0;

	m_pLineCache = 0;

	// s̑}
	if(iLine == 0) {
		pInfo = new CLineLayout();
		pInfo->m_pNext = m_pHead;
		m_pHead->m_pPrev = pInfo;
		m_pHead = pInfo;
	} else {
		pPrev = GetLineInternal(iLine - 1);
		assert(pPrev != 0);
		pInfo = new CLineLayout();
		pInfo->m_pPrev = pPrev;
		pInfo->m_pNext = pPrev->m_pNext;
		if(pPrev->m_pNext != 0)
			pPrev->m_pNext->m_pPrev = pInfo;
		pPrev->m_pNext = pInfo;
		pInfo->m_tcFromPrev = pInfo->m_pPrev->m_tcToNext;
	}
	if(MINIMAL_PARSE_LEVEL <= LPL_MULTILINEANNOTATION)
		ParseLineMultilineCommentContinue(iLine, pInfo);
	else if(MINIMAL_PARSE_LEVEL == LPL_TOKEN)
		ParseLineTokens(iLine, pInfo);
	else if(MINIMAL_PARSE_LEVEL == LPL_FULL)
		ParseLineCharacterPositions(iLine, pInfo);
	else
		assert(false);

	if(pInfo->m_pNext == 0)
		return;
	pInfo = pInfo->m_pNext;
	++iLine;

	// 㑱̉e󂯂s`FbN
	while(true) {
		if(pInfo->m_pNext == 0
				|| (pInfo->m_pNext->m_lplParseLevel < LPL_MULTILINEANNOTATION)
				|| pInfo->m_tcToNext == pInfo->m_pNext->m_tcFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineMultilineCommentContinue(++iLine, pInfo);
	}
}

/**
 *	̍sCAEg쐬AXgɒǉ
 *	@param iStart	}Jns
 *	@param iEnd		}Is
 *	@exception		݂Ȃsw肵Ă <code>out_of_range</code>
 */
void CLineLayoutManager::InsertLines(length_t iStart, length_t iEnd) throw(out_of_range) {
	AssertValid();
	assert(iStart <= iEnd);

//	CTimer tm(L"InsertLines");
	if(iStart > m_pView->GetDocument()->GetLineCount())
		throw out_of_range("First argument is greater than document line count.");

	CLineLayout*	pBeginPrev = (iStart != 0) ? GetLineInternal(iStart - 1) : 0;
	CLineLayout*	pEndNext = GetLineInternal(iStart);
	CLineLayout*	pNewInfo = 0;
	CLineLayout*	pNewPrevInfo = 0;

	// s̑}
	for(length_t iLine = iStart; /* iLine <= iEnd */; ++iLine) {
		pNewInfo = new CLineLayout();
		if(iLine == iStart) {
			pNewInfo->m_pPrev = pBeginPrev;
			if(pBeginPrev == 0)
				m_pHead = pNewInfo;
			else
				pBeginPrev->m_pNext = pNewInfo;
		} else {
			pNewInfo->m_pPrev = pNewPrevInfo;
			pNewPrevInfo->m_pNext = pNewInfo;
		}
		if(iLine == iEnd) {
			pNewInfo->m_pNext = pEndNext;
			if(pEndNext != 0)
				pEndNext->m_pPrev = pNewInfo;
			break;
		}
		pNewPrevInfo = pNewInfo;
	}
	m_pLineCache = 0;

	// }s̏XV
	CLineLayout*	pInfo = GetLineInternal(iStart);
	for(length_t iLine = iStart; iLine <= iEnd; ++iLine, pInfo = pInfo->m_pNext) {
		if(MINIMAL_PARSE_LEVEL <= LPL_MULTILINEANNOTATION)
			ParseLineMultilineCommentContinue(iLine, pInfo);
		else if(MINIMAL_PARSE_LEVEL == LPL_TOKEN)
			ParseLineTokens(iLine, pInfo);
		else if(MINIMAL_PARSE_LEVEL == LPL_FULL)
			ParseLineCharacterPositions(iLine, pInfo);
		else
			assert(false);
	}

	// 㑱̉e󂯂s`FbN
	length_t	iLine_ = iEnd;
	pInfo = pEndNext;
	if(pInfo == 0)
		return;
	while(true) {
		if(pInfo->m_pNext == 0
				|| (pInfo->m_pNext->m_lplParseLevel < LPL_MULTILINEANNOTATION)
				|| pInfo->m_tcToNext == pInfo->m_pNext->m_tcFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineMultilineCommentContinue(++iLine_, pInfo);
	}
}


/**
 *	w肵s̃CAEgXV
 *	@param iLine	(_) sԍ
 *	@return			es
 *	@exception		iLine ݂Ȃsł <code>out_of_range</code>
 */
length_t CLineLayoutManager::ModifyLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	m_pLineCache = 0;

	// ܂Ԃƍs̕\ɂ
	LineIterator		it = m_pView->GetDocument()->GetLineIterator(iLine);
	const CEditDocLine*	pLineInfo = &(*it);
	const char_t*		pszLine = pLineInfo->GetLine().c_str();
	const length_t		cchLine = pLineInfo->GetLine().length();
	unsigned long		cxLine = 0;

	pInfo->m_vecWrappedOffsets.clear();
	pInfo->m_lplParseLevel = LPL_UNPARSED;

//	hOldFont = m_pView->m_gdiObjects.oMemDC.SelectObject(m_pView->m_gdiObjects.hNormalFont);

//	if(m_pView->m_modeState.wpmWrapMode == WPM_NONE)
		ParseLineCharacterPositions(iLine, pInfo);
/*	else {	// ܂Ԃ̌vZ
		unsigned long	cxWrap;
		unsigned int	cxChar;

		if(m_pView->m_modeState.wpmWrapMode == WPM_SPECIFIED)
			cxWrap = m_pView->m_modeState.nWrapWidth;
		else if(m_pView->m_modeState.wpmWrapMode == WPM_WINDOW) {
			RECT	rect;
			m_pView->GetClientRect(&rect);
			cxWrap = rect.right - rect.left
						- m_pView->m_layoutInfo.nLeftTabWidth - m_pView->m_layoutInfo.nLeftMargin;
		}
		for(unsigned long i = 0; i < cchLine; ++i) {
			if(*(pszLine + i) == L'\t')
				cxChar = m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth()
							- cxLine % (m_pView->m_layoutInfo.nTabWidth * m_pView->GetAvgCharWidth());
			else
				cxChar = m_pView->m_gdiObjects.oMemDC.GetTextExtent(pszLine + i, 1).cx;
			if(cxLine + cxChar > cxWrap) {	// ܂Ԃ
				pInfo->m_vecWrappedOffsets.push_back(i);
				cxLine = 0;
			}
			cxLine += cxChar;
		}
	}

	m_pView->m_gdiObjects.oMemDC.SelectObject(hOldFont);*/

	// 㑱s̕sRgɂ
	length_t	cModifiedLines = 1;
	while(true) {
		if(pInfo->m_pNext == 0
				|| (pInfo->m_pNext->m_lplParseLevel < LPL_MULTILINEANNOTATION)
				|| pInfo->m_tcToNext == pInfo->m_pNext->m_tcFromPrev) {	// e͂̍sŏI
			break;
		}
		pInfo = pInfo->m_pNext;
		ParseLineMultilineCommentContinue(iLine + cModifiedLines, pInfo);
		++cModifiedLines;
	}
	return cModifiedLines;
}

///	ő\sT
void CLineLayoutManager::ModifyMaxDisplayWidth() {
	AssertValid();

	m_pxMax = 0;
	for(CLineLayout* pInfo = m_pHead; pInfo != 0; pInfo = pInfo->m_pNext) {
		if(pInfo->m_cxPixel > m_pxMax) {
			m_pxMax = pInfo->m_cxPixel;
			m_pMaxDisplayWidthLine = pInfo;
		}
	}
}

/**
 *	SĂ̍sɑ΂Ďw肵x̉͂蒼Kv邱Ƃʒm
 *	@param lplDisable	̓x
 */
void CLineLayoutManager::NotifyAll(LineParseLevel lplDisable) {
	AssertValid();

	CLineLayout*	pLine = m_pHead;

	while(pLine != 0) {
		if(pLine->m_lplParseLevel >= lplDisable)
			pLine->m_lplParseLevel = static_cast<LineParseLevel>(lplDisable - 1);
		pLine = pLine->m_pNext;
	}
}

///	@see	ILexerEventListener::OnLexerAddedIdentifiedToken
void CLineLayoutManager::OnLexerAddedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	m_pView->m_pTokenFoundations->tfs[type].pmapTfs->insert(
		pair<TokenCookie, TTextFoundation>(nCookie, TTextFoundation()));
}

///	@see	ILexerEventListener::OnLexerChanged
void CLineLayoutManager::OnLexerChanged() {
	AssertValid();
	NotifyAll(MINIMAL_PARSE_LEVEL);
	m_pView->OnUpdate(this, 0, this);
}

///	@see	ILexerEventListener::OnLexerCleared
void CLineLayoutManager::OnLexerCleared() {
	AssertValid();
	m_pView->m_pTokenFoundations->tfs[TT_KEYWORD].pmapTfs->clear();
	m_pView->m_pTokenFoundations->tfs[TT_ANNOTATION].pmapTfs->clear();
	NotifyAll(MINIMAL_PARSE_LEVEL);
	m_pView->OnUpdate(this, 0, this);
}

///	@see	ILexerEventListener::OnLexerRemovedIdentifiedToken
void CLineLayoutManager::OnLexerRemovedIdentifiedToken(Ascension::TokenType type, TokenCookie nCookie) {
	AssertValid();
	map<TokenCookie, TTextFoundation>::iterator	itRemoved =
		m_pView->m_pTokenFoundations->tfs[type].pmapTfs->find(nCookie);
	m_pView->m_pTokenFoundations->tfs[type].pmapTfs->erase(itRemoved);
}

/**
 *	@brief	ws̉͂sB͍ς݂łΉȂ
 *
 *	CLineLayoutManager ̃NCAg GetLine
 *	gƂŉ͍ς݂̍s擾ł邪AGetLine
 *	ȊÕ\bh͍s͂sȂ̂ŁA
 *	̃\bhŗ\߉͂sƂŃI[owbhɘa邱Ƃł
 *
 *	@param iLine	_s
 */
void CLineLayoutManager::ParseLine(length_t iLine) throw(out_of_range) {
	AssertValid();

	CLineLayout*	pInfo = GetLineInternal(iLine);

	if(pInfo == 0)
		throw out_of_range("Specified line is not found.");
	if(pInfo->m_lplParseLevel < LPL_FULL)
		ParseLineCharacterPositions(iLine, pInfo);
}

/**
 *	ʒǔvZs
 *	@param iLine	_sԍ
 *	@param pInfo	s (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineCharacterPositions(length_t iLine, CLineLayout* pInfo /* = 0 */) {
	AssertValid();

	if(pInfo == 0)
		pInfo = GetLineInternal(iLine);

	// g[N؂oIĂȂ΂Ȃ
	if(pInfo->m_lplParseLevel < LPL_TOKEN)
		ParseLineTokens(iLine, pInfo);

	const length_t	cchLine = m_pView->GetDocument()->GetLineLength(iLine);

	if(cchLine == 0) {
		pInfo->m_cxPixel = 0;
		pInfo->m_vecCaretPos.clear();
		pInfo->m_vecCaretPos.push_back(0);
		pInfo->m_lplParseLevel = LPL_FULL;
		return;
	}

	const string_t&	strLine = m_pView->GetDocument()->GetLine(iLine);
	const char_t*	pwszLine = strLine.c_str();
	CMinimalDC&		oDC = m_pView->m_gdiObjects.oMemDC;
	HFONT			hOldFont = oDC.SelectObject(m_pView->m_gdiObjects.hNormalFont);
	size_t			iToken = 0;
	GCP_RESULTSW	gcpr;
	int*			arrCaretPos = new int[cchLine + 1];
	unsigned int*	arrOrder = new unsigned int[cchLine + 1];
	char*			arrClass = new char[cchLine + 1];
	length_t		nOffset = 0;	// s̈ʒu

	arrCaretPos[0] = 0;
	oDC.SetTextCharacterExtra(m_pView->m_layoutInfo.nCharSpan);
	ZeroMemory(&gcpr, sizeof(GCP_RESULTSW));
	gcpr.lStructSize = sizeof(GCP_RESULTSW);

	length_t	iStart = 0;
	length_t	iEnd = 0;

	while(iEnd < cchLine) {	// g[NƂ̃[v
		const length_t	cchToken = (iToken < pInfo->m_cTokens - 1) ?
							pInfo->m_ppTokens[iToken + 1]->GetIndex() - iEnd : cchLine - iEnd;
		CTokenLayout*	pToken = pInfo->m_ppTokens[iToken];

		iStart = iEnd;
		iEnd = /*m_pView->m_modeState.bResetDirByToken ?*/ (iStart + cchToken) /*: cchLine*/;
		TTextFoundation&	tf = m_pView->GetTextFoundation(pToken->GetType(), pToken->GetCookie());

		// ԊuƃtHg̐ݒ
		if(m_pView->m_pTokenFoundations->arrEnabled[pToken->GetType()]
				&& tf.bold && m_pView->m_foundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_pView->m_layoutInfo.nCharSpan - 1);
		oDC.SelectObject(m_pView->GetFontForRenderingToken(pToken->GetType(), pToken->GetCookie()));

		// R[h|Cg̏oƕނ𓾂
		gcpr.nGlyphs = iEnd - iStart;
		gcpr.lpClass = arrClass + iStart;
		gcpr.lpOrder = arrOrder + iStart;
		oDC.GetCharacterPlacement(pwszLine + iStart, iEnd - iStart,
			0, &gcpr, GCP_DIACRITIC | GCP_DISPLAYZWG | GCP_GLYPHSHAPE | GCP_REORDER);
//		dumpArray(arrOrder, gcpr.nGlyphs);

		// \AĂȂʒu𒲂ׂ
		TSubstringDirection	oDir = {0, 0, false};
		pToken->m_pDirectionList = new DirectionList();
		pToken->m_pDirectionList->push_back(oDir);
		for(length_t iChar = pToken->GetIndex() + 1;
				iChar < pToken->GetIndex() + cchToken; ++iChar) {
			if(arrOrder[iChar] - arrOrder[iChar - 1] != 1
					&& arrOrder[iChar - 1] - arrOrder[iChar] != 1
					&& arrOrder[iChar] != arrOrder[iChar - 1]) {
				oDir.iStartChar = iChar - pToken->GetIndex();
				pToken->m_pDirectionList->push_back(oDir);
			}
		}

		// ̕߂
		list<CDirectionMarker>	listMarkers;
		DirectionList::iterator itDirs = pToken->m_pDirectionList->begin();
		CDirectionMarker		oMarker;
		while(itDirs != pToken->m_pDirectionList->end()) {
			DirectionList::iterator	itNext = itDirs;

			++itNext;
			const length_t	iDirStart = pToken->GetIndex() + itDirs->iStartChar;
			length_t		cch = (itNext != pToken->m_pDirectionList->end()) ?
				(itNext->iStartChar - itDirs->iStartChar) : (cchToken - itDirs->iStartChar);
			if(cch > 2) {
				if(arrOrder[iDirStart + 1] - arrOrder[iDirStart] == 1)	// LTR
					itDirs->bRightToLeft = false;
				else if(arrOrder[iDirStart] - arrOrder[iDirStart + 1] == 1)	// RTL
					itDirs->bRightToLeft = true;
				else if(arrOrder[iDirStart] == arrOrder[iDirStart + 1])
					itDirs->bRightToLeft =
						arrClass[iDirStart] == GCPCLASS_ARABIC
						|| arrClass[iDirStart] == GCPCLASS_HEBREW;
				else {	// 蓾
//					Manah::Windows::dout << arrOrder[iDirStart] << ","
//						<< arrOrder[iDirStart + 1] << "\n";
					assert(false);
				}
			} else if(cch == 2) {	// 2̏ꍇ͏sAȂł͕s\ȏꍇ
				const bool	bRtl0 =
					arrClass[iDirStart] == GCPCLASS_ARABIC || arrClass[iDirStart] == GCPCLASS_HEBREW;
				const bool	bRtl1 =
					arrClass[iDirStart + 1] == GCPCLASS_ARABIC || arrClass[iDirStart + 1] == GCPCLASS_HEBREW;

				if((bRtl0 && !bRtl1) || (!bRtl0 && bRtl1)) {
					oDir.iStartChar = itDirs->iStartChar + 1;
					pToken->m_pDirectionList->insert(itNext, oDir);
					cch = 1;
				}
				itDirs->bRightToLeft = bRtl0;
			} else	// 1̏ꍇ arrClass ̕ނg
				itDirs->bRightToLeft =
					arrClass[iDirStart] == GCPCLASS_ARABIC
					|| arrClass[iDirStart] == GCPCLASS_HEBREW;

			CDirectionMarker*	pLastAddedMarker = listMarkers.empty() ? 0 : &(*(--listMarkers.end()));
			if(pLastAddedMarker == 0 || itDirs->bRightToLeft != pLastAddedMarker->m_pDir->bRightToLeft) {
				oMarker.m_pDir = &(*itDirs);
				oMarker.m_iOrder = arrOrder[iDirStart];
				oMarker.m_cch = cch;
				listMarkers.push_back(oMarker);
				++itDirs;
			} else {	// ̕1OƓȂ獡Xg폜
				pLastAddedMarker->m_cch += cch;
				itDirs = pToken->m_pDirectionList->erase(itDirs);
			}
		}

		// ȏ񂩂l߂Ă
		pToken->m_nLeftEdge = nOffset;
		listMarkers.sort();
		for(list<CDirectionMarker>::const_iterator it
				= listMarkers.begin(); it != listMarkers.end(); ++it) {
			const length_t	iStart = pToken->GetIndex() + it->m_pDir->iStartChar;
			const length_t	cch = it->m_cch;
			length_t		iLastTab = iStart;
			length_t		cchSubstring;
			SIZE			size;
			bool			bIsLast = ++it == listMarkers.end();

			--it;
			if(!it->m_pDir->bRightToLeft)	// LTR ̏ꍇA`Jnʒu
				it->m_pDir->nLeadEdge = nOffset;
			while(true) {	// g[Ñ^u͕ʈ
				length_t	iTab = strLine.find(L'\t', iLastTab);

				if(iTab >= iStart + cch)	// ȂƂɂ
					iTab = wstring::npos;

				// ^u܂
				if(iTab == wstring::npos || iTab - iLastTab != 0) {
					cchSubstring = (iTab != wstring::npos) ?
									iTab - iLastTab : iStart + cch - iLastTab;
//					if(iLastTab + cchSubstring == cchLine)
//						++cchSubstring;
//					const int	dxLastOrg = arrCaretPos[iLastTab + cchSubstring];
					oDC.GetTextExtentExPoint(pwszLine + iLastTab,
						cchSubstring, 0, 0, arrCaretPos + iLastTab + 1, &size);
//					if(!bIsLast)
//						arrCaretPos[iLastTab + cchSubstring] = dxLastOrg;
					arrCaretPos[iLastTab] = nOffset;
					for(length_t i = iLastTab; i < iLastTab + cchSubstring; ++i)
						arrCaretPos[i + 1] += nOffset;
					nOffset += size.cx;
					if(iTab == wstring::npos)
						break;
				}

				// ^u
				nOffset = m_pView->GetNextTabStop(nOffset, m_pView->m_modeState.bRtlReading);
				arrCaretPos[iTab + 1] = nOffset;
				iLastTab = iTab + 1;

				if(iLastTab == iStart + cch)
					break;
			}
			if(it->m_pDir->bRightToLeft)	// RTL ̏ꍇA`Jnʒu
				it->m_pDir->nLeadEdge = nOffset;

			// RTL ̌̕vZʂt܂ɂ
			if(it->m_pDir->bRightToLeft) {
				const length_t	iStart = pToken->GetIndex() + it->m_pDir->iStartChar;
				const int		nSubstringLeft = arrCaretPos[iStart];
				const length_t	iEnd = iStart + it->m_cch + (bIsLast ? 1 : 0);

				for(length_t i = iStart; i < iEnd; ++i)
					arrCaretPos[i] = arrCaretPos[iStart + it->m_cch]
										- arrCaretPos[i] + nSubstringLeft;
			}
		}

		// S LTR ̏ꍇ
		if(pToken->m_pDirectionList->size() == 1
				&& !pToken->m_pDirectionList->begin()->bRightToLeft) {
			delete pToken->m_pDirectionList;
			pToken->m_pDirectionList = 0;
		}

		// n
		if(m_pView->m_pTokenFoundations->arrEnabled[pToken->GetType()]
				&& tf.bold && m_pView->m_foundationInfo.bDrawBoldCharsClosely)
			oDC.SetTextCharacterExtra(m_pView->m_layoutInfo.nCharSpan);
		pToken->m_nTextWidth = nOffset - pToken->m_nLeftEdge;

		// ̃g[N
		++iToken;
	}

	pInfo->m_cxPixel = nOffset;
	pInfo->m_vecCaretPos.assign(arrCaretPos, arrCaretPos + cchLine + 1);
	delete[] arrCaretPos;
	delete[] arrOrder;
	delete[] arrClass;
	oDC.SelectObject(hOldFont);

	// ő\̌vZ (ł͂Ȃ...)
	if(pInfo == m_pMaxDisplayWidthLine) {
		ModifyMaxDisplayWidth();
		m_pView->m_pOriginalView->ModifyScrollInfo(true, false);
	} else if(pInfo->m_cxPixel > m_pxMax) {
		m_pxMax = pInfo->m_cxPixel;
		m_pMaxDisplayWidthLine = pInfo;
		m_pView->m_pOriginalView->ModifyScrollInfo(true, false);
	}

	pInfo->m_lplParseLevel = LPL_FULL;
}

/**
 *	s̐擪A̕sRg
 *	@param iLine	_sԍ
 *	@param pInfo	s (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineMultilineCommentContinue(length_t iLine, CLineLayout* pInfo /* = 0 */) {
	AssertValid();

	if(pInfo == 0)
		pInfo = GetLineInternal(iLine);

	// O̍s̕sRgI󋵂g
	if(pInfo->m_pPrev == 0)
		pInfo->m_tcFromPrev = NullCookie;
	else {
		// O̍s͂Ȃ΍ċAIɉ͂
		CLineLayout*	pLine = pInfo;
		
		// ܂͂łŏ̍s܂Ŗ߂
		while(true) {
			if(pLine->m_pPrev == 0) {	// 擪s
				pLine->m_tcFromPrev = NullCookie;
				break;
			} else if(pLine->m_pPrev->m_lplParseLevel >= LPL_MULTILINEANNOTATION) {	// ͍ς݂̍sɓ
				pLine->m_tcFromPrev = pLine->m_pPrev->m_tcToNext;
				break;
			}
			pLine = pLine->m_pPrev;
			--iLine;
		}

		// ͂Ȑ擪s pInfo ܂ł
		const CEditDoc*	pDocument = m_pView->GetDocument();
		while(true) {
			pLine->m_tcToNext = m_pLexer->ParseMultilineAnnotation(pDocument->GetLine(iLine), pLine->m_tcFromPrev);
			pLine->m_lplParseLevel = LPL_MULTILINEANNOTATION;
			if(pLine == pInfo)	// ŏɉ͂悤ƂĂs
				break;
			pLine = pLine->m_pNext;
			++iLine;
			pLine->m_tcFromPrev = pLine->m_pPrev->m_tcToNext;
		}
	}
}

/**
 *	g[N؂os
 *	@param iLine	_sԍ
 *	@param pInfo	s (ȗƍsԍ擾)
 */
void CLineLayoutManager::ParseLineTokens(length_t iLine, CLineLayout* pInfo /* = 0 */) {
	AssertValid();

	if(pInfo == 0)
		pInfo = GetLineInternal(iLine);

	// O̍s畡sRgĂ邩ǂĂȂ΂Ȃ
	if(pInfo->m_pPrev != 0 && (pInfo->m_pPrev->m_lplParseLevel < LPL_MULTILINEANNOTATION))
		ParseLineMultilineCommentContinue(iLine - 1, pInfo->m_pPrev);
	pInfo->m_tcFromPrev = (pInfo->m_pPrev != 0) ? pInfo->m_pPrev->m_tcToNext : NullCookie;

	const string_t&	strLine = m_pView->GetDocument()->GetLine(iLine);

	if(pInfo->m_ppTokens != 0) {
		for(size_t i = 0; i < pInfo->m_cTokens; ++i)
			delete pInfo->m_ppTokens[i];
		delete[] pInfo->m_ppTokens;
		pInfo->m_ppTokens = 0;
	}
	if(strLine.empty()) {
		pInfo->m_cTokens = 0;
		pInfo->m_tcToNext = pInfo->m_tcFromPrev;
		pInfo->m_lplParseLevel = LPL_TOKEN;
		return;
	}

	TokenCookie	nCookie = pInfo->m_tcFromPrev;
	TokenList	listTokens = m_pLexer->Parse(strLine, nCookie);

	pInfo->m_cTokens = listTokens.size();
	pInfo->m_ppTokens = new CTokenLayout*[pInfo->m_cTokens];

	size_t	iToken = 0;
	for(TokenList::const_iterator it = listTokens.begin(); it != listTokens.end(); ++it, ++iToken)
		pInfo->m_ppTokens[iToken] = new CTokenLayout(*it);
	pInfo->m_tcToNext = nCookie;
	pInfo->m_lplParseLevel = LPL_TOKEN;
}

void CLineLayoutManager::ReconstructAll() {
	AssertValid();
	DeleteAllLines();
	InsertLines(0, m_pView->GetDocument()->GetLineCount() - 1);
}

/* [EOF] */