// LineLayout.h
// (c) 2003-2004 exeal

#ifndef _LINE_LAYOUT_H_
#define _LINE_LAYOUT_H_
#include "Lexer.h"
#include <list>
#include <vector>


namespace Ascension {

class CEditView;

///	s̉̓x (CLineLayoutInfo Q)
typedef char LineParseLevel;
///	S͂ĂȂ
const LineParseLevel	LPL_UNPARSED			= 0;
///	O̍sւ̕sߌp܂ŉ͍ς
const LineParseLevel	LPL_MULTILINEANNOTATION	= 1;
///	g[N܂ŉ͍ς
const LineParseLevel	LPL_TOKEN				= 2;
///	ʒuƌꏇ܂ (܂Ԃ܂ <- ) ͍ς
const LineParseLevel	LPL_FULL				= 3;


// CTokenInfo class definition
/////////////////////////////////////////////////////////////////////////////

///	s̕\
struct TSubstringDirection {
	length_t	iStartChar;	// g[N擪̑Έʒu
	length_t	nLeadEdge;	// [ (LTR) /E[ (RTL) ̈ʒu
	bool		bRightToLeft;
};
typedef std::list<TSubstringDirection>	DirectionList;

///	g[ÑCAEg
class CTokenLayout : public CToken {
	friend class CLineLayout;
	friend class CLineLayoutManager;

	// RXgN^
private:
	CTokenLayout(const CToken& base) : CToken(base), m_pDirectionList(0) {
	}
public:
	~CTokenLayout() {
		delete m_pDirectionList;
	}

	// \bh
public:
	const DirectionList*	GetDirectionList() const;
	int						GetLeftEdge() const;
	int						GetTextWidth() const;

	// f[^o
private:
	int				m_nLeftEdge;		// g[N̍[̈ʒu
	int				m_nTextWidth;		// g[N̕
	DirectionList*	m_pDirectionList;	// eLXgωʒũXg (S LTR ł null)
};


// CLineLayout class definition
/////////////////////////////////////////////////////////////////////////////

///	܂Ԃʒu̔z
typedef std::vector<length_t>	WrappedOffsets;

/**
 *	@brief	es̃CAEgۑ
 *
 *	CLineLayoutManager::GetLine() 擾łA_s̃CAEgێB
 *	O̍sƂ̊Ԃ̕sRǧpAg[ÑXgAẽLbgʒuA
 *	ubN}[NsA܂Ԃɕ`悷̂ɕKvȕȂǂƂĎB
 *
 *	eȏ CLineLayoutManager NXsB
 *	s͂̏󋵂 LineParseLevel 񋓂Ɏ4iKB
 *	̒iKɕĂ̂͌̂߂łB CEditView
 *	ANZXƂɂ͈ʒu܂ŊSɉ͍ς݂ł邱Ƃۏ؂B
 *	NCAg̉͒iKlKv̂ CLineLayoutManager::NotifyAll
 *	\bhĂяoƂłBႦ΃r[̃tHgωƂA
 *	SẲ͂蒼Kv͖B̏ꍇALPL_FULL
 *	w肵ă\bhĂяoΈʒu񂾂𖳌ɂ邱Ƃł
 */
class CLineLayout : public Manah::Windows::CSmallObject<> {
	friend class CLineLayoutManager;

	// RXgN^
private:
	CLineLayout() : m_pNext(0), m_pPrev(0),
			m_tcFromPrev(NullCookie), m_tcToNext(NullCookie),
			m_bBookmarked(false), m_cxPixel(0), m_dwParam(0),
			m_lplParseLevel(LPL_UNPARSED), m_ppTokens(0) {
	}
	~CLineLayout() {
		if(m_ppTokens != 0) {
			for(std::size_t i = 0; i < m_cTokens; ++i)
				delete m_ppTokens[i];
			delete[] m_ppTokens;
		}
	}

	// \bh
public:
	int						GetCaretPosition(length_t iChar) const;
	int						GetCharacterLeadPosition(const CTokenLayout& oToken, length_t iChar) const;
	TokenCookie				GetMultilineCommentStatus(bool bToNextLine) const;
	std::size_t				GetTokenCount() const;
	CTokenLayout** const	GetTokenList() const;
	DWORD					GetUserDefinedValue() const;
	const WrappedOffsets&	GetWrappedPoints() const;
	bool					IsBookmarked() const;
	void					SetBookmark(bool bMark = true);
	void					SetUserDefinedValue(DWORD dwValue);

	// f[^o
private:
	CLineLayout*	m_pNext;				// O̍s
	CLineLayout*	m_pPrev;				// ̍s
	TokenCookie		m_tcFromPrev;			// O̕sRgIĂȂ΂̎
	TokenCookie		m_tcToNext;				// sRg̍sɑĂ΂̎
	WrappedOffsets	m_vecWrappedOffsets;	// ܂Ԃꂽ\s̊e擪ʒu (܂Ԃꍇ̂ݗL)
											// vf \s - 1
	int				m_cxPixel;				// ܂Ԃɕ`悷̂ɕKvȕ̕ (܂ԂȂꍇ̂ݗL)
	DWORD			m_dwParam;				// AvP[V`̒l

	bool				m_bBookmarked;		// ubN}[Ns
	LineParseLevel		m_lplParseLevel;	// s̉̓x
	CTokenLayout**		m_ppTokens;			// g[ÑXg
	std::size_t			m_cTokens;			// g[N̐
	std::vector<int>	m_vecCaretPos;		// e̍[̈ʒu
};


// CLineLayoutManager class definition
/////////////////////////////////////////////////////////////////////////////

/**
 *	@brief	sCAEg̊Ǘ
 *
 *	CEditView NX̃CAEgsPʂŊǗACEditView NXł
 *	s̍폜A}AXV󂯂āACAEgXVĂB
 *
 *	̂߂ɂ̃NX̃\bh͕Kvȏ̑sȂB
 *	Ⴆ΂sɕsRgJn񂪑}ꂽꍇACEditView
 *	NX͂̍s̃CAEgXV邽߂ ModifyLine
 *	ĂяoA̍sւ̉e͖ (C̕Kvȍs͕Ԃ)B
 *	êsXV邩ǂf̂ CEditView NX̎dłB
 *
 *	GfB^̕ɂ͊֘A CEditView CX^X͂̃IuWFNgL
 */
class CLineLayoutManager :
		public Manah::CObject,
		virtual public ILexerEventListener {
private:
/*	///	oeLXg
	enum BidiClass {
		BC_L, BC_LRE, BC_LRO, BC_R, BC_AL, BC_RLE, BC_RLO,
		BC_PDF, BC_EN, BC_ES, BC_ET, BC_AN, BC_CS, BC_NSM,
		BC_BN, BC_B, BC_S, BC_WS, BC_ON,
	};*/

	///
	class CDirectionMarker {
	public:
		TSubstringDirection*	m_pDir;
		unsigned int			m_iOrder;
		length_t				m_cch;

		bool	operator <(const CDirectionMarker& rhs) const {
			return m_iOrder < rhs.m_iOrder;
		}
	};

	// RXgN^
public:
	CLineLayoutManager(CEditView* pView);
	virtual ~CLineLayoutManager();

	// \bh
public:
	void			DeleteAllLines();
	void			DeleteLine(length_t iLine) throw(out_of_range);
	void			DeleteLines(length_t iStart, length_t iEnd) throw(out_of_range);
	CLexer*			GetLexer() const;
	CLineLayout*	GetLine(length_t iLine) const;
	LineParseLevel	GetLineParseLevel(length_t iLine) const throw(out_of_range);
	int				GetMaxDisplayWidth() const;
	void			InsertLine(length_t iLine) throw(out_of_range);
	void			InsertLines(length_t iStart, length_t iEnd) throw(out_of_range);
	length_t		ModifyLine(length_t iLine) throw(out_of_range);
	void			NotifyAll(LineParseLevel lplDisable);
	void			ParseLine(length_t iLine) throw(out_of_range);
	void			ReconstructAll();
protected:
//	static BidiClass	GetBidiClass(unsigned long cp);
	CLineLayout*		GetLineInternal(length_t iLine) const;
	void				ModifyMaxDisplayWidth();
	void				ParseLineCharacterPositions(length_t iLine, CLineLayout* pInfo = 0);
	void				ParseLineMultilineCommentContinue(length_t iLine, CLineLayout* pInfo = 0);
	void				ParseLineTokens(length_t iLine, CLineLayout* pInfo = 0);

	// ILexerEventListener \bh
public:
	void	OnLexerAddedIdentifiedToken(TokenType type, TokenCookie nCookie);
	void	OnLexerChanged();
	void	OnLexerCleared();
	void	OnLexerRemovedIdentifiedToken(TokenType type, TokenCookie nCookie);

	// f[^o
private:
	CEditView*		m_pView;				// r[
	CLexer*			m_pLexer;				// ͊
	CLineLayout*	m_pHead;				// 擪
	int				m_pxMax;				// ő\
	CLineLayout*	m_pMaxDisplayWidthLine;	// ő\s

	mutable length_t		m_iLineCache;	// ŌɃANZXsԍƗvf
	mutable CLineLayout*	m_pLineCache;	// s̒ǉƍ폜s\bhgpƖɂȂ
};


// inline method implementations
/////////////////////////////////////////////////////////////////////////////

///	g[N̍[̈ʒuԂ
inline int CTokenLayout::GetLeftEdge() const {
	return m_nLeftEdge;
}

///	g[N̕`敝Ԃ
inline int CTokenLayout::GetTextWidth() const {
	return m_nTextWidth;
}

///	̕XgԂ (SĂ̕ LTR ł null)
inline const DirectionList* CTokenLayout::GetDirectionList() const {
	return m_pDirectionList;
}

/**
 *	w肵ʒũ̕LbgʒuԂ (̃\bh͋E`FbNȂ)
 *	@param iChar	ʒu
 *	@return			Lbgʒu
 */
inline int CLineLayout::GetCaretPosition(length_t iChar) const {
	return m_vecCaretPos[iChar];
}

/**
 *	w肵ʒu̕̕`JnʒuԂ (̃\bh͋E`FbNȂ)
 *	@param oToken	g[N
 *	@param iChar	g[NJnʒȗΈʒu
 *	@return			`Jnʒu
 */
inline int CLineLayout::GetCharacterLeadPosition(const CTokenLayout& oToken, length_t iChar) const {
	DirectionList::const_iterator	it;
	const DirectionList*			pDirs = oToken.m_pDirectionList;

	if(pDirs != 0) {
		for(it = pDirs->begin(); it != pDirs->end(); ++it) {
			if(it->iStartChar < iChar)
				continue;
			else if(it->iStartChar == iChar)
				return it->nLeadEdge;
			else if(it->iStartChar > iChar)
				break;
		}
	}
	return m_vecCaretPos[oToken.GetIndex() + iChar];
}

/**
 *	sRǧpԂԂ
 *	@param bToNextLine	̂ւ̌p󋵂擾ꍇ trueB
 *						O̍šp󋵂擾ꍇ false
 *	@return				p
 */
inline TokenCookie CLineLayout::GetMultilineCommentStatus(bool bToNextLine) const {
	return bToNextLine ? m_tcToNext : m_tcFromPrev;
}

///	g[N̑Ԃ
inline std::size_t CLineLayout::GetTokenCount() const {
	return m_cTokens;
}

///	g[ÑXgԂ
inline CTokenLayout** const CLineLayout::GetTokenList() const {
	return m_ppTokens;
}

///	sɐݒ肳ꂽ[U`lԂ
inline DWORD CLineLayout::GetUserDefinedValue() const {
	return m_dwParam;
}

///	܂Ԃʒu̔zԂ
inline const std::vector<length_t>& CLineLayout::GetWrappedPoints() const {
	return m_vecWrappedOffsets;
}

///	ubN}[NsԂ
inline bool	CLineLayout::IsBookmarked() const {
	return m_bBookmarked;
}

///	ubN}[N̐ݒ
inline void CLineLayout::SetBookmark(bool bMark /* = true */) {
	m_bBookmarked = bMark;
}

///	[U`l̐ݒ
inline void CLineLayout::SetUserDefinedValue(DWORD dwValue) {
	m_dwParam = dwValue;
}

///	͊Ԃ
inline CLexer* CLineLayoutManager::GetLexer() const {
	AssertValid();
	return m_pLexer;
}


} // namespace Ascension


#endif /* _LINE_LAYOUT_H_ */

/* [EOF] */