// BookmarkDlg.cpp
// (c) 2003 exeal

#include "StdAfx.h"
#include "resource.h"
#include "BookmarkDlg.h"
#include "AlphaView.h"
#include "..\Manah\ListCtrl.h"

using Alpha::CBookmarkDlg;
using Alpha::CAlphaApp;
using namespace Ascension;


// CBookmarkDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CBookmarkDlg::CBookmarkDlg(const CAlphaApp& app) : m_app(app) {
}

/**
 *	w肵ʒu̍ڏ𓾂
 *	@param iItem		ڂ̈ʒu
 *	@param strFileName	[out] t@C
 *	@param iLine		[out] sԍ (0x[X)
 */
void CBookmarkDlg::GetItemInfo(unsigned long iItem, wstring& strFileName, length_t& iLine) const {
	AssertValid();

	CListCtrl	oList;
	wchar_t		wszLocation[300];
	wchar_t*	pwszDelimiter = 0;

	oList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	assert(static_cast<long>(iItem) < oList.GetItemCount());
	oList.GetItemText(iItem, 1, wszLocation, 300);
	oList.Detach();

	pwszDelimiter = wcsrchr(wszLocation, L'(');
	assert(pwszDelimiter != 0);
	strFileName.assign(wszLocation, pwszDelimiter - wszLocation);
	iLine = wcstoul(pwszDelimiter + 1, 0, 10);
	--iLine;
}

///	[폜] {^̏
void CBookmarkDlg::OnBtnDelete() {
	HWND		hwndBookmarksListView = GetDlgItem(IDC_LIST_BOOKMARKS);
	int			iSel;
	wstring		strFileName;
	length_t	iLine;
	CAlphaView*	pView;

	iSel = ListView_GetSelectionMark(hwndBookmarksListView);

	if(iSel == -1)	// I
		return;

	GetItemInfo(iSel, strFileName, iLine);
	if(m_mapTabIndex.find(strFileName) == m_mapTabIndex.end())
		return;
	if(CAlphaEditController* pEditor = m_app.GetTab(m_mapTabIndex[strFileName])->GetTextEditor()) {
		pView = pEditor->GetActiveView();
		pView->SetBookmark(iLine, false);
		ListView_DeleteItem(hwndBookmarksListView, iSel);

		if(ListView_GetItemCount(hwndBookmarksListView) != 0) {
			ListView_SetItemState(hwndBookmarksListView, 0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		} else {
			::EnableWindow(GetDlgItem(IDOK), false);
			::EnableWindow(GetDlgItem(IDC_BTN_DELETE), false);
		}
	}
}

///	ubN}[NXg̍XV
void CBookmarkDlg::UpdateList() {
	CListCtrl						oList;
	list<length_t>					listLines;
	list<length_t>::const_iterator	it;
	char_t							wszLocation[300];
	int								iItem = 0;

	m_mapTabIndex.clear();
	oList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	oList.DeleteAllItems();

	if(IsDlgButtonChecked(IDC_CHK_SHOWALLFILES) == BST_CHECKED) {	// SẴhLgꍇ
		for(unsigned int iTab = 0; iTab < m_app.GetTabCount(); ++iTab) {
			if(CAlphaEditController* pEditor = m_app.GetTab(iTab)->GetTextEditor()) {
				const CAlphaView*	pView = pEditor->GetActiveView();
				const wstring		strFileName = pView->GetDocument()->GetTitle();

				pView->GetBookmarkList(listLines);
				for(it = listLines.begin(); it != listLines.end(); ++it, ++iItem) {
					string_t	strLine = pView->GetDocument()->GetLine(*it).substr(0, 100);
					for(size_t i = 0; i < strLine.length(); ++i) {
						if(strLine[i] == L'\t')
							strLine[i] = L' ';
					}
					iItem = oList.InsertItem(iItem, strLine.c_str());
					swprintf(wszLocation, L"%s(%lu)", strFileName.c_str(), *it + 1);
					oList.SetItemText(iItem, 1, wszLocation);
				}
				m_mapTabIndex[strFileName] = iTab;
			}
		}
	} else if(CAlphaEditController* pEditor = m_app.GetActiveTab()->GetTextEditor()) {
		// ANeBuȃhLgΏۂɂꍇ
		const CAlphaView*	pView = pEditor->GetActiveView();
		const wstring		strFileName = pView->GetDocument()->GetTitle();

		pView->GetBookmarkList(listLines);
		for(it = listLines.begin(); it != listLines.end(); ++it, ++iItem) {
			string_t	strLine = pView->GetDocument()->GetLine(*it).substr(0, 100);
			for(size_t i = 0; i < strLine.length(); ++i) {
				if(strLine[i] == L'\t')
					strLine[i] = L' ';
			}
			iItem = oList.InsertItem(iItem, strLine.c_str());
			swprintf(wszLocation, L"%s(%lu)", strFileName.c_str(), *it + 1);
			oList.SetItemText(iItem, 1, wszLocation);
		}
		m_mapTabIndex[strFileName] = m_app.GetActiveTabIndex();
	}

	if(oList.GetItemCount() != 0) {
		oList.SetItemState(0, LVIS_FOCUSED | LVIS_SELECTED, LVIS_FOCUSED | LVIS_SELECTED);
		::EnableWindow(GetDlgItem(IDOK), true);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), true);
	} else {
		::EnableWindow(GetDlgItem(IDOK), false);
		::EnableWindow(GetDlgItem(IDC_BTN_DELETE), false);
	}
	oList.Detach();
}

///	@see	CDialog::OnCommand
bool CBookmarkDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	CAlphaView*	pView = 0;
	CCharPos	posBegin, posEnd;

	switch(wID) {
	case IDC_BTN_ADD:	// [ǉ]
		if(CAlphaEditController* pEditor = m_app.GetActiveTab()->GetTextEditor()) {
			pView = pEditor->GetActiveView();
			pView->GetSel(posBegin, posEnd);
			pView->SetBookmark(posEnd.m_iLine, true);
			UpdateList();
		}
		break;
	case IDC_BTN_DELETE:	// [폜]
		OnBtnDelete();
		break;
	case IDC_BTN_UPDATE:	// [XV]
	case IDC_CHK_SHOWALLFILES:	// [JĂSẴhLg\]
		UpdateList();
		break;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CBookmarkDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	CListCtrl	oList;

	oList.Attach(GetDlgItem(IDC_LIST_BOOKMARKS));
	oList.ModifyStyleEx(WS_EX_NOPARENTNOTIFY, 0);
	oList.SetExtendedStyle(LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP);
	oList.InsertColumn(0, L"s", LVCFMT_LEFT, 279, -1);
	oList.InsertColumn(1, L"ʒu", LVCFMT_LEFT, 100, -1);
	oList.Detach();
	UpdateList();

	return true;
}

///	@see	CDialog::OnNotify
bool CBookmarkDlg::OnNotify(int idCtrl, LPNMHDR lpNMHDR) {
	if(idCtrl == IDC_LIST_BOOKMARKS && lpNMHDR->code == NM_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnNotify(idCtrl, lpNMHDR);
}

///	@see	CDialog::OnOK
void CBookmarkDlg::OnOK() {
	int				iSel;
	unsigned int	iTab;
	wstring			strFileName;
	length_t		iLine;
	CAlphaView*		pView;

	iSel = ListView_GetSelectionMark(GetDlgItem(IDC_LIST_BOOKMARKS));

	if(iSel == -1)	// I
		return;

	GetItemInfo(iSel, strFileName, iLine);
	if(m_mapTabIndex.find(strFileName) == m_mapTabIndex.end())
		return;
	iTab = m_mapTabIndex[strFileName];
	if(CAlphaEditController* pEditor = m_app.GetTab(iTab)->GetTextEditor()) {
		pView = pEditor->GetActiveView();
		pView->SetSelWithoutSelection(CCharPos(iLine, 0));
		const_cast<CAlphaApp&>(m_app).SetActiveTab(iTab);
		GetParent()->SetActiveWindow();

		if(IsDlgButtonChecked(IDC_CHK_AUTOCLOSE) == BST_CHECKED)	// [Iɕ]
			CDialog::OnOK();
	}
}

/* [EOF] */