// CodePagesDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CodePagesDlg.h"
#include "Alpha.h"
using Alpha::CCodePagesDlg;
using namespace Manah::Text;


// CCodePagesDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CCodePagesDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_CODEPAGES && wNotifyCode == LBN_DBLCLK) {
		OnOK();
		return true;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CCodePagesDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	HWND							hwndCPList;
	set<CodePage>					setCPs;
	set<CodePage>::const_iterator	it;
	const wchar_t*					pwszCpName;
	wchar_t							wszCp[100];

	hwndCPList = GetDlgItem(IDC_LIST_CODEPAGES);
	CEncoder::EnumCodePages(setCPs);
	for(it = setCPs.begin(); it != setCPs.end(); ++it) {
		pwszCpName = CAlphaApp::GetCodePageName(*it);
		if(pwszCpName != 0) {
			swprintf(wszCp, L"%s [%lu]", pwszCpName, *it);
			const int	iItem = ::SendMessageW(hwndCPList, LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(wszCp));
			::SendMessageW(hwndCPList, LB_SETITEMDATA, iItem, *it);
		}
	}
	const int	cItems = ::SendMessageW(hwndCPList, LB_GETCOUNT, 0, 0L);
	for(int i = 0; i < cItems; ++i) {
		if(m_nCodePage == ::SendMessageW(hwndCPList, LB_GETITEMDATA, i, 0L)) {
			::SendMessageW(hwndCPList, LB_SETCURSEL, i, 0L);
			break;
		}
	}

	return true;
}

///	@see	CDialog::OnOK
void CCodePagesDlg::OnOK() {
	HWND	hwndCPList = GetDlgItem(IDC_LIST_CODEPAGES);
	m_nCodePage = ::SendMessageW(hwndCPList, LB_GETITEMDATA,
					::SendMessageW(hwndCPList, LB_GETCURSEL, 0, 0L), 0L);

	CDialog::OnOK();
}

/* [EOF] */