// CommandManager.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "CommandManager.h"
#include "Alpha.h"
#include "FindDlg.h"
#include "GotoLineDlg.h"
#include "BookmarkDlg.h"
#include "Ascension\KeymacroPlayer.h"
using namespace Alpha;
using namespace Ascension;


// CCommandManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CCommandManager::CCommandManager(CAlphaApp& app) : m_app(app),
		m_hImageListEnabled(0), m_hImageListDisabled(0), m_nLastCommandId(0) {
}

///	fXgN^
CCommandManager::~CCommandManager() {
	if(m_hImageListEnabled != 0)	::ImageList_Destroy(m_hImageListEnabled);
	if(m_hImageListDisabled != 0)	::ImageList_Destroy(m_hImageListDisabled);
}

/**
 *	ACR[hăC[WXg쐬BȑÕC[WXg͔j
 *	@param strDirectory	ACRۑĂfBNg
 *	@return				
 */
bool CCommandManager::CreateImageList(const wstring& strDirectory) {
	if(m_hImageListEnabled != 0) {
		::ImageList_Destroy(m_hImageListEnabled);
		::ImageList_Destroy(m_hImageListDisabled);
	}
	m_mapIconIndecies.clear();

	m_hImageListEnabled = ::ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
	m_hImageListDisabled = ::ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 0);
	if(m_hImageListEnabled == 0 || m_hImageListDisabled == 0)
		return false;

	wchar_t				wszPath[MAX_PATH];
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind;

	wcscpy(wszPath, strDirectory.c_str());
	::PathAppendW(wszPath, L"*.bmp");
	hFind = ::FindFirstFileW(wszPath, &wfd);

	if(hFind == INVALID_HANDLE_VALUE)
		return 0;

	HBITMAP	hIcon = 0;

	do {
		unsigned long	id;
		wchar_t			wszFileTitle[MAX_PATH];

		wcscpy(wszFileTitle, ::PathFindFileNameW(wfd.cFileName));
		::PathFindExtensionW(wszFileTitle)[0] = 0;
		id = wcstoul(wszFileTitle, 0, 10);
		if(id < COMMAND_START || id > COMMAND_END)
			continue;
		wcscpy(wszFileTitle, strDirectory.c_str());
		::PathAppendW(wszFileTitle, wfd.cFileName);
		hIcon = static_cast<HBITMAP>(::LoadImage(m_app.m_hInstance,
			wszFileTitle, IMAGE_BITMAP, 16, 16, LR_CREATEDIBSECTION | LR_LOADFROMFILE));
		if(hIcon != 0) {
			int	i = ::ImageList_AddMasked(m_hImageListEnabled, hIcon, CCommandManager::m_clrIconMask);
			if(i != -1) {
				m_mapIconIndecies[static_cast<CommandId>(id)] = i;

				HDC		hSrcDC = ::CreateCompatibleDC(0);
				HBITMAP	hOldBmp = static_cast<HBITMAP>(::SelectObject(hSrcDC, hIcon));
				HDC		hDestDC = ::CreateCompatibleDC(hSrcDC);
				HBITMAP	hDestBmp = ::CreateCompatibleBitmap(hSrcDC, 16, 16);
				HBITMAP	hOldBmp2 = static_cast<HBITMAP>(::SelectObject(hDestDC, hDestBmp));
				const COLORREF	clrMask = ::GetPixel(hSrcDC, 15, 0);

				// ZsAɂ (x)
				// ͉摜Ƃ悭Ȃ̂œKȎgB
				// ̐F̉% ƂlƂƂ炵Ȃ邩
				for(int x = 0; x < 16; ++x) {
					for(int y = 0; y < 16; ++y) {
						const COLORREF	clrOrg = ::GetPixel(hSrcDC, x, y);
						if(clrOrg == clrMask)
							::SetPixel(hDestDC, x, y, CCommandManager::m_clrIconMask);
						else {
							const ulong	elm = (GetRValue(clrOrg) + GetGValue(clrOrg) + GetBValue(clrOrg)) / 3;
							const uchar	r = (elm + 10 > 0xFF) ? 0xFF : static_cast<uchar>(elm + 10);
							const uchar g = (elm > 10) ? static_cast<uchar>(elm - 10) : 0;
							const uchar b = (elm > 20) ? static_cast<uchar>(elm - 20) : 0;
							::SetPixel(hDestDC, x, y, RGB(r, g, b));
						}
					}
				}
				::SelectObject(hDestDC, hOldBmp2);
				::ImageList_AddMasked(m_hImageListDisabled, hDestBmp, CCommandManager::m_clrIconMask);
				::SelectObject(hSrcDC, hOldBmp);
				::DeleteDC(hDestDC);
				::DeleteObject(hDestBmp);
				::DeleteDC(hSrcDC);
			}
			::DeleteObject(hIcon);
		}
	} while(toBoolean(::FindNextFileW(hFind, &wfd)));
	::FindClose(hFind);

	::ImageList_SetBkColor(m_hImageListEnabled, CLR_NONE);
	::ImageList_SetBkColor(m_hImageListDisabled, CLR_NONE);

	return true;
}

/**
 *	R}hs
 *	@param id			R}h ID
 *	@param bUserContext	R}h̃ReLXg
 */
void CCommandManager::ExecuteCommand(CommandId id, bool bUserContext) {
	if(!IsEnabled(id, bUserContext))
		return;

	CAlphaEditController*	pEditor = m_app.GetActiveTab()->GetTextEditor();

	if(pEditor == 0)	// _ł͉Ȃ
		return;

	CAlphaDoc*	pDoc = pEditor->GetDocument();
	CAlphaView*	pView = pEditor->GetActiveView();

	switch(id) {
	case CMD_FILE_NEW:				m_app.OnFileNew(::GetACP());	break;
	case CMD_FILE_NEWWITHFORMAT:	m_app.OnFileNewWithFormat();	break;
	case CMD_FILE_OPEN:				m_app.OnFileOpen();				break;
	case CMD_FILE_CLOSE:			m_app.OnFileClose(true);		break;
	case CMD_FILE_CLOSEALL:			m_app.OnFileCloseAll(false);	break;
	case CMD_FILE_SAVE:				m_app.OnFileSave();				break;
	case CMD_FILE_SAVEAS:
		if(m_app.OnFileSaveAs())
			m_app.ApplyDocumentType(m_app.m_iActiveTab);
		break;
	case CMD_FILE_SAVEALL:				m_app.OnFileSaveAll();						break;
	case CMD_FILE_REOPEN:				m_app.OnFileReopen();						break;
	case CMD_FILE_REOPENWITHCODEPAGE:	m_app.OnFileReopenWithCodepage();			break;
	case CMD_FILE_EXIT:					m_app.m_pMainWindow->SendMessage(WM_CLOSE);	break;
	case CMD_FILE_PROPERTY:				m_app.OnFileProperty();						break;
	case CMD_FILE_RENAME:
	case CMD_FILE_MOVE:
	case CMD_FILE_COPY:
	case CMD_FILE_DELETE:				m_app.OnFileOperation(id);					break;
	case CMD_FILE_SENDMAIL:				
		pDoc->SendCurrentFile(toBoolean(m_app.GetProfileInt(L"File", L"sendMailAsAttachment", 1)));
		break;
	case CMD_FILE_CLOSEOTHERS:			m_app.OnFileCloseAll(true);	break;

	case CMD_EDIT_DELETE:					pView->ExecCommand(CMDID_EDIT_DELETE);					break;
	case CMD_EDIT_BACKSPACE:				pView->ExecCommand(CMDID_EDIT_BACKSPACE);				break;
	case CMD_EDIT_DELETETONEXTWORD:			pView->ExecCommand(CMDID_EDIT_DELETETONEXTWORD);		break;
	case CMD_EDIT_DELETETOPREVWORD:			pView->ExecCommand(CMDID_EDIT_DELETETOPREVWORD);		break;
	case CMD_EDIT_DELETELINE:				pView->ExecCommand(CMDID_EDIT_DELETELINE);				break;
	case CMD_EDIT_INSERTPREVLINE:			pView->ExecCommand(CMDID_EDIT_INSERTPREVLINE);			break;
	case CMD_EDIT_BREAK:					pView->ExecCommand(CMDID_EDIT_BREAK);					break;
	case CMD_EDIT_UNDO:						pView->ExecCommand(CMDID_EDIT_UNDO);					break;
	case CMD_EDIT_REDO:						pView->ExecCommand(CMDID_EDIT_REDO);					break;
	case CMD_EDIT_CUT:						pView->ExecCommand(CMDID_EDIT_CUT, true);				break;
	case CMD_EDIT_COPY:						pView->ExecCommand(CMDID_EDIT_COPY, true);				break;
	case CMD_EDIT_PASTE:					pView->ExecCommand(CMDID_EDIT_PASTE);					break;
	case CMD_EDIT_PASTEFROMCLIPBOARDRING:	pView->ExecCommand(CMDID_EDIT_PASTEFROMCLIPBOARDRING);	break;
	case CMD_EDIT_INSERTTAB:				pView->ExecCommand(CMDID_EDIT_CHAR, L'\t');				break;
	case CMD_EDIT_DELETETAB:				pView->ExecCommand(CMDID_EDIT_TABUNINDENT, 1);			break;
	case CMD_EDIT_TABIFY:					pView->ExecCommand(CMDID_EDIT_TABIFY);					break;
	case CMD_EDIT_UNTABIFY:					pView->ExecCommand(CMDID_EDIT_UNTABIFY);				break;
	case CMD_EDIT_CHARTOCODEPOINT:			pView->ExecCommand(CMDID_EDIT_CHARTOCODEPOINT);			break;
	case CMD_EDIT_CODEPOINTTOCHAR:			pView->ExecCommand(CMDID_EDIT_CODEPOINTTOCHAR);			break;
	case CMD_EDIT_MAKENEXTGRAVE:		pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_GRAVE);		break;
	case CMD_EDIT_MAKENEXTACUTE:		pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_ACUTE);		break;
	case CMD_EDIT_MAKENEXTCIRCUMFLEX:	pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_CIRCUMFLEX);	break;
	case CMD_EDIT_MAKENEXTTILDE:		pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_TILDE);		break;
	case CMD_EDIT_MAKENEXTDIAERESIS:	pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_DIAERESIS);	break;
	case CMD_EDIT_MAKENEXTCEDILLA:		pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_CEDILLA);	break;
	case CMD_EDIT_MAKENEXTSUPER:		pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_SUPERSCRIPT);break;
	case CMD_EDIT_MAKENEXTSUB:			pView->ExecCommand(CMDID_EDIT_SETNEXTINPUTCONVERT, NCC_SUBSCRIPT);	break;
	case CMD_EDIT_RECOMPOSE:			pView->ExecCommand(CMDID_EDIT_RECOMPOSESELECTION);	break;
	case CMD_EDIT_TOGGLEOVERTYPEMODE:	pView->ExecCommand(CMDID_EDIT_TOGGLEOVERTYPEMODE);	break;
	case CMD_EDIT_OPENCANDIDATEWINDOW:	pView->ExecCommand(CMDID_EDIT_OPENCANDIDATEWINDOW);	break;
	case CMD_EDIT_HOME:			pView->ExecCommand(CMDID_MOVE_HOME);			break;
	case CMD_EDIT_END:			pView->ExecCommand(CMDID_MOVE_END);				break;
	case CMD_EDIT_LINEHOME:		pView->ExecCommand(CMDID_MOVE_LINEHOME);		break;
	case CMD_EDIT_LINEEND:		pView->ExecCommand(CMDID_MOVE_LINEEND);			break;
	case CMD_EDIT_CHARNEXT:		pView->ExecCommand(CMDID_MOVE_CHARNEXT, 1);		break;
	case CMD_EDIT_CHARPREV:		pView->ExecCommand(CMDID_MOVE_CHARPREV, 1);		break;
	case CMD_EDIT_WORDENDNEXT:	pView->ExecCommand(CMDID_MOVE_WORDENDNEXT, 1);	break;
	case CMD_EDIT_WORDENDPREV:	pView->ExecCommand(CMDID_MOVE_WORDENDPREV, 1);	break;
	case CMD_EDIT_WORDNEXT:		pView->ExecCommand(CMDID_MOVE_WORDNEXT, 1);		break;
	case CMD_EDIT_WORDPREV:		pView->ExecCommand(CMDID_MOVE_WORDPREV, 1);		break;
	case CMD_EDIT_LINEDOWN:		pView->ExecCommand(CMDID_MOVE_LINEDOWN, 1);		break;
	case CMD_EDIT_LINEUP:		pView->ExecCommand(CMDID_MOVE_LINEUP, 1);		break;
	case CMD_EDIT_PAGEDOWN:		pView->ExecCommand(CMDID_MOVE_PAGEDOWN, 1);		break;
	case CMD_EDIT_PAGEUP:		pView->ExecCommand(CMDID_MOVE_PAGEUP, 1);		break;
	case CMD_EDIT_HOMEEXTEND:			pView->ExecCommand(CMDID_MOVE_HOMEEXTEND);			break;
	case CMD_EDIT_ENDEXTEND:			pView->ExecCommand(CMDID_MOVE_ENDEXTEND);			break;
	case CMD_EDIT_LINEHOMEEXTEND:		pView->ExecCommand(CMDID_MOVE_LINEHOMEEXTEND);		break;
	case CMD_EDIT_LINEENDEXTEND:		pView->ExecCommand(CMDID_MOVE_LINEENDEXTEND);		break;
	case CMD_EDIT_CHARNEXTEXTEND:		pView->ExecCommand(CMDID_MOVE_CHARNEXTEXTEND);		break;
	case CMD_EDIT_CHARPREVEXTEND:		pView->ExecCommand(CMDID_MOVE_CHARPREVEXTEND);		break;
	case CMD_EDIT_WORDENDNEXTEXTEND:	pView->ExecCommand(CMDID_MOVE_WORDENDNEXTEXTEND);	break;
	case CMD_EDIT_WORDENDPREVEXTEND:	pView->ExecCommand(CMDID_MOVE_WORDENDPREVEXTEND);	break;
	case CMD_EDIT_WORDNEXTEXTEND:		pView->ExecCommand(CMDID_MOVE_WORDNEXTEXTEND);		break;
	case CMD_EDIT_WORDPREVEXTEND:		pView->ExecCommand(CMDID_MOVE_WORDPREVEXTEND);		break;
	case CMD_EDIT_LINEDOWNEXTEND:		pView->ExecCommand(CMDID_MOVE_LINEDOWNEXTEND);		break;
	case CMD_EDIT_LINEUPEXTEND:			pView->ExecCommand(CMDID_MOVE_LINEUPEXTEND);		break;
	case CMD_EDIT_PAGEDOWNEXTEND:		pView->ExecCommand(CMDID_MOVE_PAGEDOWNEXTEND);		break;
	case CMD_EDIT_PAGEUPEXTEND:			pView->ExecCommand(CMDID_MOVE_PAGEUPEXTEND);		break;
	case CMD_EDIT_SELECTALL:			pView->ExecCommand(CMDID_MOVE_SELECTALL);			break;
	case CMD_EDIT_SELECTCURRENTWORD:	pView->ExecCommand(CMDID_MOVE_SELECTCURRENTWORD);	break;
	case CMD_EDIT_CANCELSELECTION:		pView->ExecCommand(CMDID_MOVE_CANCELSELECTION);		break;
	case CMD_EDIT_SCROLLHOME:			pView->ExecCommand(CMDID_SCROLL_HOME);					break;
	case CMD_EDIT_SCROLLEND:			pView->ExecCommand(CMDID_SCROLL_END);					break;
	case CMD_EDIT_SCROLLLINEDOWN:		pView->ExecCommand(CMDID_SCROLL_LINEDOWN);				break;
	case CMD_EDIT_SCROLLLINEUP:			pView->ExecCommand(CMDID_SCROLL_LINEUP);				break;
	case CMD_EDIT_SCROLLPAGEDOWN:		pView->ExecCommand(CMDID_SCROLL_PAGEDOWN);				break;
	case CMD_EDIT_SCROLLPAGEUP:			pView->ExecCommand(CMDID_SCROLL_PAGEUP);				break;
	case CMD_EDIT_SCROLLCOLUMNNEXT:		pView->ExecCommand(CMDID_SCROLL_COLUMNNEXT);			break;
	case CMD_EDIT_SCROLLCOLUMNPREV:		pView->ExecCommand(CMDID_SCROLL_COLUMNPREV);			break;
	case CMD_EDIT_ENSURECARETCENTER:	pView->ExecCommand(CMDID_SCROLL_ENSURECARETCENTERED);	break;
	case CMD_EDIT_ENSURECARETVISIBLE:	pView->ExecCommand(CMDID_SCROLL_ENSURECARETVISIBLE);	break;
	case CMD_EDIT_ROWCHARNEXT:			pView->ExecCommand(CMDID_MOVE_ROWCHARNEXT);		break;
	case CMD_EDIT_ROWCHARPREV:			pView->ExecCommand(CMDID_MOVE_ROWCHARPREV);		break;
	case CMD_EDIT_ROWLINEDOWN:			pView->ExecCommand(CMDID_MOVE_ROWLINEDOWN);		break;
	case CMD_EDIT_ROWLINEEND:			pView->ExecCommand(CMDID_MOVE_ROWLINEEND);		break;
	case CMD_EDIT_ROWLINEHOME:			pView->ExecCommand(CMDID_MOVE_ROWLINEHOME);		break;
	case CMD_EDIT_ROWLINEUP:			pView->ExecCommand(CMDID_MOVE_ROWLINEUP);		break;
	case CMD_EDIT_ROWWORDENDNEXT:		pView->ExecCommand(CMDID_MOVE_ROWWORDENDNEXT);	break;
	case CMD_EDIT_ROWWORDENDPREV:		pView->ExecCommand(CMDID_MOVE_ROWWORDENDPREV);	break;
	case CMD_EDIT_ROWWORDNEXT:			pView->ExecCommand(CMDID_MOVE_ROWWORDNEXT);		break;
	case CMD_EDIT_ROWWORDPREV:			pView->ExecCommand(CMDID_MOVE_ROWWORDPREV);		break;
	case CMD_EDIT_CHARFROMABOVELINE:	pView->ExecCommand(CMDID_EDIT_CHARABOVELINE);	break;
	case CMD_EDIT_CHARFROMBELOWLINE:	pView->ExecCommand(CMDID_EDIT_CHARBELOWLINE);	break;
	case CMD_EDIT_TRANSPOSELINES:		pView->ExecCommand(CMDID_EDIT_TRANSPOSELINES);	break;
	case CMD_EDIT_TRANSPOSECHARS:		pView->ExecCommand(CMDID_EDIT_TRANSPOSECHARS);	break;
	case CMD_EDIT_TRANSPOSEWORDS:		pView->ExecCommand(CMDID_EDIT_TRANSPOSEWORDS);	break;

	case CMD_SEARCH_FIND:			m_app.OnFindFind();											break;
	case CMD_SEARCH_FINDNEXT:		m_app.OnFindFindNext(false, m_app.m_bShowMessageBoxOnFind);	break;
	case CMD_SEARCH_FINDPREV:		m_app.OnFindFindNext(true, m_app.m_bShowMessageBoxOnFind);	break;
//	case CMD_SEARCH_REPLACE:		m_app.OnFindReplace();										break;
	case CMD_SEARCH_REPLACEANDNEXT:	m_app.OnFindReplaceAndNext();								break;
	case CMD_SEARCH_REPLACEALL:		m_app.OnFindReplaceAll();									break;
	case CMD_SEARCH_BOOKMARKALL:	m_app.OnFindBookmarkAll();									break;
	case CMD_SEARCH_REVOKEMARK:		pView->RevokeSearchMarks();									break;
	case CMD_SEARCH_GOTOLINE:
		if(!m_app.m_pdlgGotoLine->IsWindow())	m_app.m_pdlgGotoLine->DoModeless();
		else									m_app.m_pdlgGotoLine->EndDialog(IDCANCEL);
		break;
	case CMD_SEARCH_TOGGLEBOOKMARK:		m_app.OnFindToggleBookmark();					break;
	case CMD_SEARCH_NEXTBOOKMARK:		pView->ExecCommand(CMDID_MOVE_BOOKMARKNEXT);	break;
	case CMD_SEARCH_PREVBOOKMARK:		pView->ExecCommand(CMDID_MOVE_BOOKMARKPREV);	break;
	case CMD_SEARCH_CLEARBOOKMARKS:		pView->ClearBookmarks();						break;
	case CMD_SEARCH_MANAGEBOOKMARKS:
		if(!m_app.m_pdlgBookmark->IsWindow())	m_app.m_pdlgBookmark->DoModeless();
		else									m_app.m_pdlgBookmark->EndDialog(IDCANCEL);
		break;
	case CMD_SEARCH_GOTOMATCHBRACKET:		pView->ExecCommand(CMDID_MOVE_MATCHBRACKET);				break;
	case CMD_SEARCH_EXTENDTOMATCHBRACKET:	pView->ExecCommand(CMDID_MOVE_MATCHBRACKETEXTEND);			break;
	case CMD_SEARCH_INCREMENTALSEARCH:		pView->ExecCommand(CMDID_MOVE_INCREMENTALSEARCH, true);		break;
	case CMD_SEARCH_INCREMENTALSEARCHR:		pView->ExecCommand(CMDID_MOVE_INCREMENTALSEARCH, false);	break;

	case CMD_VIEW_TOOLBAR:
		::ShowWindow(m_app.m_hRebar, ::IsWindowVisible(m_app.m_hRebar) ? SW_HIDE : SW_SHOW);
		m_app.OnSize(SIZE_RESTORED, -1, -1);
		break;
	case CMD_VIEW_STATUSBAR:
		::ShowWindow(m_app.m_hStatusBar, ::IsWindowVisible(m_app.m_hStatusBar) ? SW_HIDE : SW_SHOW);
		m_app.OnSize(SIZE_RESTORED, -1, -1);
		break;
/*	case CMD_VIEW_NOWRAP:				pView->SetWrapMode(WPM_NONE);				break;
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:	pView->SetWrapMode(WPM_SPECIFIED);			break;
	case CMD_VIEW_WRAPBYWINDOWWIDTH:	pView->SetWrapMode(WPM_WINDOW);				break;*/
	case CMD_VIEW_REFRESH:				m_app.GetActiveTab()->RefreshWindow();		break;
	case CMD_VIEW_SPLIT:
		pEditor->SplitView(pDoc->GetController()->IsSplit() ? 0 : -1);
		break;
	case CMD_VIEW_NEXTTAB:
		if(m_app.GetTabCount() > 1) {
			unsigned int	iTab = m_app.GetActiveTabIndex();
			iTab = (iTab + 1 != m_app.GetTabCount()) ? iTab + 1 : 0;
			m_app.SetActiveTab(iTab);
		}
		break;
	case CMD_VIEW_PREVTAB:
		if(m_app.GetTabCount() > 1) {
			unsigned int	iTab = m_app.GetActiveTabIndex();
			iTab = (iTab != 0) ? iTab - 1 : m_app.GetTabCount() - 1;
			m_app.SetActiveTab(iTab);
		}
		break;
	case CMD_VIEW_TABBAR:
		m_app.m_wndTab.ShowWindow(m_app.m_wndTab.IsWindowVisible() ? SW_HIDE : SW_SHOW);
		m_app.OnSize(SIZE_RESTORED, -1, -1);
		break;
	case CMD_VIEW_TOPMOSTALWAYS:
		m_app.m_pMainWindow->SetWindowPos(
			toBoolean(m_app.m_pMainWindow->GetExStyle() & WS_EX_TOPMOST) ? HWND_NOTOPMOST : HWND_TOPMOST,
			0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE);
		break;

	case CMD_MACRO_RECORD:			pView->CmdKeymacroRecord();						break;
	case CMD_MACRO_PLAY:			pView->CmdKeymacroPlay();						break;
	case CMD_MACRO_STOP:			pView->CmdKeymacroStop();						break;
	case CMD_MACRO_ABORT:			pView->CmdKeymacroCancel();						break;
	case CMD_MACRO_PAUSERESTART:	pView->CmdKeymacroPause();						break;
	case CMD_MACRO_SAVEAS:			pView->CmdKeymacroSave(IDS_KEYMACROFILENAME);	break;
	case CMD_MACRO_LIST:			break;

	case CMD_TOOL_COMMONOPTION:		break;
	case CMD_TOOL_DOCTYPEOPTION:	break;
	case CMD_TOOL_FONT:				m_app.OnToolFont();				break;
	case CMD_TOOL_EXECUTE:			m_app.OnToolExecute();			break;
	case CMD_TOOL_EXECUTECOMMAND:	m_app.OnToolExecuteCommand();	break;

	case CMD_HELP_ABOUT:	m_app.OnHelpAbout();	break;

	default:
		if(id >= CMD_FILE_MRULIST_START && id < CMD_FILE_MRULIST_END) {	// [ŋߎgt@C]
			if(!m_app.OpenFile(m_app.m_pMRUManager->GetFilePathAt(id - CMD_FILE_MRULIST_START)))
				m_app.m_pMRUManager->Remove(id - CMD_FILE_MRULIST_START);
		} else if(id >= CMD_FILE_DOCTYPELIST_START && id < CMD_FILE_DOCTYPELIST_END) {	// [VK]
			m_app.OnFileNew(::GetACP());
			m_app.ApplyDocumentType(m_app.m_iActiveTab,
				m_app.m_oDocTypeManager.GetAt(id - CMD_FILE_DOCTYPELIST_START).strName);
		} else if(id >= CMD_TOOL_DOCTYPELIST_START && id < CMD_TOOL_DOCTYPELIST_END)	// [Kp^Cv]
			m_app.ApplyDocumentType(m_app.m_iActiveTab,
				m_app.m_oDocTypeManager.GetAt(id - CMD_TOOL_DOCTYPELIST_START).strName);
		else if(id >= CMD_EDIT_PLUGINLIST_START && id < CMD_EDIT_PLUGINLIST_END) {	// [XNvg]
			try {
				m_app.m_pScriptMacroManager->Execute(id - CMD_EDIT_PLUGINLIST_START);
			} catch(out_of_range&) {
				// 
			} catch(CScriptMacroManager::EFailedToOpenScript& e) {
				m_app.MessageBox(MSG_FAILEDTOOPENMACROSCRIPT,
					MB_ICONHAND, CMessageArguments() % e.m_strFileName);
			} catch(CScriptMacroManager::EInvalidLanguage& e) {
				m_app.MessageBox(MSG_ILLEGALSCRIPTLANGUAGENAME,
					MB_ICONEXCLAMATION, CMessageArguments() % e.m_strLanguage);
			}
			m_app.GetActiveTab()->RefreshWindow();
		}
		m_nLastCommandId = 0;	// 芸...
	}
	m_nLastCommandId = id;
}

/**
 *	R}h̖OԂ
 *	@param id	R}h ID
 *	@return		ǐ̍O
 */
wstring CCommandManager::GetCaption(CommandId id) const {
	wchar_t		wsz[100];
	wchar_t*	pwsz = 0;

	m_app.LoadString(id, wsz, 100);
	pwsz = wcschr(wsz, L'\n');
	if(pwsz != 0)
		*pwsz = 0;
	return wsz;
}

/**
 *	R}h̐Ԃ
 *	@param id	R}h ID
 *	@return		
 */
wstring CCommandManager::GetDescription(CommandId id) const {
	wchar_t		wsz[100];
	wchar_t*	pwsz = 0;

	m_app.LoadString(id, wsz, 100);
	pwsz = wcschr(wsz, L'\n');
	if(pwsz == 0)
		return L"";
	return pwsz + 1;
}

/**
 *	R}h`FbNԂɂ邩Ԃ
 *	@param id	R}h ID
 *	@return		`FbNĂ true
 */
bool CCommandManager::IsChecked(CommandId id) const {
	const CAlphaEditController*	pEditor = m_app.GetActiveTab()->GetTextEditor();

	if(pEditor == 0)	// ̂Ƃ̓eLXgGfB^ȊOɂ͑ΉĂȂ
		return false;

	const CAlphaDoc*	pDoc = pEditor->GetDocument();
	const CAlphaView*	pView = pEditor->GetActiveView();
	const bool			bModified = pDoc->IsModified();
	const bool			bReadOnly = pDoc->IsReadOnly();
	const bool			bHasSelection = pView->HasSelection();
	const KeyMacroState	kms = pView->GetKeyMacroState();

	switch(id) {
	case CMD_SEARCH_FIND:
		return m_app.m_pdlgSearch->IsWindowVisible();
//	case CMD_SEARCH_REPLACE:
//		return m_app.m_pdlgSearch->IsWindowVisible() && !m_app.m_dlgFind.m_bType;
	case CMD_SEARCH_GOTOLINE:
		return m_app.m_pdlgGotoLine->IsWindowVisible();
	case CMD_SEARCH_MANAGEBOOKMARKS:
		return m_app.m_pdlgBookmark->IsWindowVisible();

	case CMD_VIEW_TOOLBAR:
		return toBoolean(::IsWindowVisible(m_app.m_hRebar));
	case CMD_VIEW_STATUSBAR:
		return toBoolean(::IsWindowVisible(m_app.m_hStatusBar));
	case CMD_VIEW_WRAPNO:
		return pView->GetWrapMode() == WPM_NONE;
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:
		return pView->GetWrapMode() == WPM_SPECIFIED;
	case CMD_VIEW_WRAPBYWINDOWWIDTH:
		return pView->GetWrapMode() == WPM_WINDOW;
	case CMD_VIEW_SPLIT:
		return pDoc->GetController()->IsSplit();
	case CMD_VIEW_TABBAR:
		return m_app.m_wndTab.IsWindowVisible();
	case CMD_VIEW_TOPMOSTALWAYS:
		return toBoolean(m_app.m_pMainWindow->GetExStyle() & WS_EX_TOPMOST);

	case CMD_MACRO_RECORD:
		return kms == KMS_PAUSING || kms == KMS_RECORDING;
	case CMD_MACRO_PLAY:
		return kms == KMS_PLAYING;
	case CMD_MACRO_PAUSERESTART:
		return kms == KMS_PAUSING;

	default:
		return false;
	}
}

/**
 *	R}hL (gp\) Ԃ
 *	@param id			R}h ID
 *	@param bUserContext	R}h̃ReLXg
 *	@return				Lł true
 */
bool CCommandManager::IsEnabled(CommandId id, bool bUserContext) const {
	if(m_app.m_pScriptMacroManager->IsExecuting()
			&& (bUserContext || (id >= CMD_MACRO_RECORD && id < CMD_MACRO_RECORD + 1000)))
		return false;
	const CAlphaEditController*	pEditor = m_app.GetActiveTab()->GetTextEditor();

	if(pEditor == 0)	// ̂Ƃ̓eLXgGfB^ȊOɂ͑ΉĂȂ
		return false;

	const CAlphaDoc*	pDoc = pEditor->GetDocument();
	const CAlphaView*	pView = pEditor->GetActiveView();
	const bool			bModified = pDoc->IsModified();
	const bool			bReadOnly = pDoc->IsReadOnly();
	const bool			bHasSelection = pView->HasSelection();
	const KeyMacroState	kms = pView->GetKeyMacroState();

	switch(id) {
	case CMD_FILE_SAVE:
		return bModified && !bReadOnly;
	case CMD_FILE_SAVEALL:
		for(size_t i = 0; i < m_app.m_vecDocuments.size(); ++i) {
			if(CAlphaEditController* pEditor = m_app.m_vecDocuments[i]->GetTextEditor())
				if(pEditor->GetDocument()->IsModified())
					return true;
		}
		return false;
	case CMD_FILE_REOPEN:
		return !pDoc->GetPathName().empty();
	case CMD_FILE_REOPENWITHCODEPAGE:
		return !pDoc->GetPathName().empty();
	case CMD_FILE_RENAME:
		return !bReadOnly && !pDoc->GetPathName().empty();
	case CMD_FILE_COPY:
		return !pDoc->GetPathName().empty();
	case CMD_FILE_MOVE:
	case CMD_FILE_DELETE:
		return !bReadOnly && !pDoc->GetPathName().empty();
	case CMD_FILE_SENDMAIL:
		return !pDoc->GetPathName().empty()
			|| !toBoolean(GetProfileInt(L"File", L"sendMailAsAttachment", 1));
	case CMD_FILE_CLOSEOTHERS:
		return m_app.m_vecDocuments.size() > 1;

	case CMD_EDIT_DELETE:
	case CMD_EDIT_BACKSPACE:
	case CMD_EDIT_DELETETONEXTWORD:
	case CMD_EDIT_DELETETOPREVWORD:
	case CMD_EDIT_DELETELINE:
	case CMD_EDIT_INSERTPREVLINE:
	case CMD_EDIT_BREAK:
		return !bReadOnly;
	case CMD_EDIT_UNDO:
		return !bReadOnly && pDoc->GetUndoHistoryLength() != 0;
	case CMD_EDIT_REDO:
		return !bReadOnly && pDoc->GetUndoHistoryLength(true) != 0;
	case CMD_EDIT_CUT:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_COPY:
		return bHasSelection;
	case CMD_EDIT_PASTE:
		return !bReadOnly && pView->CanPaste() != 0;
	case CMD_EDIT_PASTEFROMCLIPBOARDRING:
		return !bReadOnly && pView->GetClipboardRing().GetCount() != 0;
	case CMD_EDIT_INSERTTAB:
	case CMD_EDIT_DELETETAB:
		return !bReadOnly;
	case CMD_EDIT_TABIFY:
	case CMD_EDIT_UNTABIFY:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_CHARTOCODEPOINT:
	case CMD_EDIT_CODEPOINTTOCHAR:
	case CMD_EDIT_MAKENEXTGRAVE:
	case CMD_EDIT_MAKENEXTACUTE:
	case CMD_EDIT_MAKENEXTCIRCUMFLEX:
	case CMD_EDIT_MAKENEXTTILDE:
	case CMD_EDIT_MAKENEXTDIAERESIS:
	case CMD_EDIT_MAKENEXTCEDILLA:
		return !bReadOnly;
	case CMD_EDIT_RECOMPOSE:
		return !bReadOnly && bHasSelection;
	case CMD_EDIT_OPENCANDIDATEWINDOW:
		return !bReadOnly;

	case CMD_SEARCH_FINDNEXT:
	case CMD_SEARCH_FINDPREV:
		return m_app.m_pdlgSearch->IsWindow() &&
			::GetWindowTextLengthW(m_app.m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT)) != 0;
	case CMD_SEARCH_REPLACEANDNEXT:
	case CMD_SEARCH_REPLACEALL:
		return !bReadOnly && m_app.m_pdlgSearch->IsWindow() &&
			(::GetWindowTextLengthW(m_app.m_pdlgSearch->GetDlgItem(IDC_COMBO_FINDWHAT)) != 0);
	case CMD_SEARCH_REVOKEMARK:
		return false;

	case CMD_VIEW_WRAPNO:
	case CMD_VIEW_WRAPBYSPECIFIEDWIDTH:
	case CMD_VIEW_WRAPBYWINDOWWIDTH:
		return false;
	case CMD_VIEW_NEXTTAB:
	case CMD_VIEW_PREVTAB:
		return m_app.m_vecDocuments.size() > 1;

	case CMD_MACRO_RECORD:
		return !bReadOnly && kms == KMS_NONE;
	case CMD_MACRO_PLAY:
		return !bReadOnly && kms == KMS_NONE;
	case CMD_MACRO_STOP:
	case CMD_MACRO_ABORT:
		return kms == KMS_RECORDING;
	case CMD_MACRO_PAUSERESTART:
		return kms == KMS_PAUSING || kms == KMS_RECORDING;
	case CMD_MACRO_SAVEAS:
		return kms == KMS_NONE;

	case CMD_TOOL_COMMONOPTION:
	case CMD_TOOL_DOCTYPEOPTION:
		return false;

	default:
		return true;
	}
}

/* [EOF] */