// CommandManager.h
// (c) 2004 exeal

#ifndef _COMMAND_MANAGER_H_
#define _COMMAND_MANAGER_H_

#include "AlphaInterfaces.h"
#include <map>


namespace Alpha {

// CCommandManager class definition
/////////////////////////////////////////////////////////////////////////////

class CAlphaApp;

///	Alpha ̑SR}hǗ
class CCommandManager {
	// RXgN^
public:
	CCommandManager(CAlphaApp& app);
	~CCommandManager();

	// \bh
public:
	bool		CreateImageList(const wstring& strDirectory);
	void		ExecuteCommand(CommandId id, bool bUserContext);
	wstring		GetCaption(CommandId id) const;
	wstring		GetDescription(CommandId id) const;
	size_t		GetIconIndex(CommandId id) const;
	HIMAGELIST	GetImageList(bool bEnabled) const;
	CommandId	GetLastCommand() const;
	bool		IsChecked(CommandId id) const;
	bool		IsEnabled(CommandId id, bool bUserContext) const;

	// f[^o
private:
	CAlphaApp&				m_app;
	HIMAGELIST				m_hImageListEnabled;
	HIMAGELIST				m_hImageListDisabled;
	map<CommandId, size_t>	m_mapIconIndecies;
	CommandId				m_nLastCommandId;
	static const COLORREF	m_clrIconMask = RGB(0xFF, 0x00, 0xFF);
};

/**
 *	R}hɑΉACR̃C[WXg̈ʒuԂ
 *	@param id	R}h ID
 *	@return		CfbNXBACRꍇ -1
 */
inline size_t CCommandManager::GetIconIndex(CommandId id) const {
	map<CommandId, size_t>::const_iterator	it;
	return (m_mapIconIndecies.end() == (it = m_mapIconIndecies.find(id))) ? -1 : it->second;
}

/**
 *	C[WXgԂBԂꂽC[WXgjҏWĂ͂ȂȂ
 *	@param bEnabled	p\ł邱Ƃ\ACR܂ރC[WXg擾ꍇ true
 *	@return			C[WXg
 */
inline HIMAGELIST CCommandManager::GetImageList(bool bEnabled) const {
	return bEnabled ? m_hImageListEnabled : m_hImageListDisabled;
}

///	ŌɎsR}h̎ʒlԂ
inline CommandId CCommandManager::GetLastCommand() const {
	return m_nLastCommandId;
}

} // namespace Alpha

#endif /* _COMMAND_MANAGER_H_ */

/* [EOF] */