// EventHandlerScript.cpp
// (c) 2004 exeal

#include "StdAfx.h"
#include "EventHandlerScript.h"
#include "Ambient.h"
#include "AlphaScriptHost.h"
#include "..\Manah\Encoder.h"
using Manah::Text::CEncoder;
using namespace Alpha;


// CEventHandlerScript class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CEventHandlerScript::CEventHandlerScript(HWND hWnd, CAlphaApp& app)
		: m_hWnd(hWnd), m_pScriptEngine(0), m_pScriptHost(0), m_app(app) {
	assert(::IsWindow(m_hWnd));
}

///	fXgN^
CEventHandlerScript::~CEventHandlerScript() {
	if(m_pScriptEngine != 0) {
		m_pScriptEngine->Close();
		m_pScriptEngine->Release();
		m_pScriptHost->Release();
	}
}

/**
 *	CxgnhĂяo
 *	@param pwszHandlerName	nh
 *	@param pDispParams		
 *	@return					IDispatch::Invoke Ɠ
 */
HRESULT CEventHandlerScript::Invoke(const OLECHAR* pwszHandlerName, DISPPARAMS* pDispParams) {
	if(pwszHandlerName == 0 || pDispParams == 0)
		return E_INVALIDARG;
	if(m_pScriptEngine == 0)
		return E_UNEXPECTED;

	// ݂̃XbhXNvgGW쐬XbhŖ
	// GUI XbhɈϏ
	if(::GetCurrentThreadId() != ::GetWindowThreadProcessId(m_hWnd, 0)) {
		pair<const OLECHAR*, DISPPARAMS*>	invocation;
		invocation.first = pwszHandlerName;
		invocation.second = pDispParams;
		::SendMessageW(m_hWnd, WM_EVENTHANDLER, 0, reinterpret_cast<LPARAM>(&invocation));
		return S_OK;
	}

	HRESULT			hr;
	IDispatch*		pHandler = 0;
	DISPID			dispid;
	VARIANT			varResult;
	EXCEPINFO		exception;
	unsigned int	iArgErr;

	if(FAILED(hr = m_pScriptEngine->GetScriptDispatch(0, &pHandler)))
		return hr;
	if(FAILED(hr = pHandler->GetIDsOfNames(IID_NULL,
			const_cast<OLECHAR**>(&pwszHandlerName), 1, LOCALE_USER_DEFAULT, &dispid)))
		return hr;
	::VariantInit(&varResult);
	ZeroMemory(&exception, sizeof(EXCEPINFO));
	hr = pHandler->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT,
			DISPATCH_METHOD, pDispParams, &varResult, &exception, &iArgErr);
	::VariantClear(&varResult);
	pHandler->Release();

	return hr;
}

/**
 *	XNvgt@Cǂݍ݁A͂
 *	@param pwszFileName	t@C (ChJ[hL)
 *	@return				
 */
bool CEventHandlerScript::LoadScript(const wchar_t* pwszFileName) {
	assert(pwszFileName != 0);
	
	WIN32_FIND_DATAW	wfd;
	HANDLE				hFind;
	wchar_t				wszFilePath[MAX_PATH];

	// t@CT
	hFind = ::FindFirstFileW(pwszFileName, &wfd);
	if(hFind == INVALID_HANDLE_VALUE)
		return false;
	::FindClose(hFind);
	wcscpy(wszFilePath, pwszFileName);
	wcscpy(::PathFindFileNameW(wszFilePath), wfd.cFileName);

	HANDLE		hFile;
	HGLOBAL		hGlobal = 0;
	char*		psz = 0;
	wchar_t*	pwszSource = 0;
	DWORD		dwRead = 0;

	// XNvgǂݍ
	hFile = ::CreateFileW(wszFilePath, GENERIC_READ,
		FILE_SHARE_READ | FILE_SHARE_WRITE, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if(hFile == INVALID_HANDLE_VALUE)
		return false;
	hGlobal = ::GlobalAlloc(GMEM_MOVEABLE, wfd.nFileSizeLow);
	psz = static_cast<char*>(::GlobalLock(hGlobal));
	if(wfd.nFileSizeLow != 0)
		::ReadFile(hFile, psz, wfd.nFileSizeLow, &dwRead, 0);
	::CloseHandle(hFile);
	if(dwRead == 0) {
		::GlobalUnlock(hGlobal);
		::GlobalFree(hGlobal);
		return false;
	}

	// UTF-8  UTF-16 ɕϊ
	if(dwRead != 0) {
		CEncoder*	pEncoder = CEncoder::Create(CP_UTF8);
		pwszSource = new wchar_t[dwRead + 1];
		const size_t	cch = pEncoder->ConvertToUnicode(pwszSource, dwRead, psz, dwRead);
		pwszSource[cch] = 0;
		delete pEncoder;
	} else
		pwszSource = L"";
	::GlobalUnlock(hGlobal);
	::GlobalFree(hGlobal);

	// XNvgGWN
	HRESULT	hr;
	CLSID	clsidEngine;

	CAlphaScriptHost::FindScriptEngine(wfd.cFileName, clsidEngine);
	if(clsidEngine == CLSID_NULL) {	// gq猾GWłȂ
		delete[] pwszSource;		// Ƀ}b`t@Cgقǂ
		return false;
	}
	hr = ::CoCreateInstance(clsidEngine, 0, CLSCTX_ALL,
		IID_IActiveScript, reinterpret_cast<void**>(&m_pScriptEngine));
	if(FAILED(hr)) {
		delete[] pwszSource;
		return false;
	}

	// p[T̎擾
	CAlphaScriptHost*	pScriptHost = new CAlphaScriptHost(m_hWnd, m_pScriptEngine, true);
	IActiveScriptParse*	pParser = 0;

	pScriptHost->SetSecurityLevel(true, SSSL_ALLOW);
	pScriptHost->SetSecurityLevel(false, SSSL_ALLOW);
	pScriptHost->SetScriptPath(wszFilePath);
	hr = pScriptHost->QueryInterface(IID_IActiveScriptSite, reinterpret_cast<void**>(&m_pScriptHost));
	hr = m_pScriptEngine->SetScriptSite(pScriptHost);	// ̃\bhĂяoXbhzXgXbh
//	hr = m_pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = m_pScriptEngine->QueryInterface(
			IID_IActiveScriptParse, reinterpret_cast<void**>(&pParser));

	// gbvxIuWFNg̗p
	Ambient::CApplication*	pApp;
	m_app.GetAutomation(&pApp, 0);
	pScriptHost->AddTopLevelObject(OLESTR("Ambient"), pApp, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	pScriptHost->AddTopLevelObject(OLESTR("Alpha"), pApp, SCRIPTITEM_GLOBALMEMBERS | SCRIPTITEM_ISVISIBLE);
	pScriptHost->AddTopLevelObject(OLESTR("WScript"), new Ambient::CScriptHost(pScriptHost), SCRIPTITEM_ISVISIBLE);

	set<pair<wstring, CEnumImpl*> >	enums;
	pApp->GetEnumerations(enums);
	for(set<pair<wstring, CEnumImpl*> >::iterator it = enums.begin(); it != enums.end(); ++it) {
		pScriptHost->AddTopLevelObject(it->first.c_str(), it->second, SCRIPTITEM_ISVISIBLE);
		it->second->Release();
	}

	// 
	if(SUCCEEDED(hr)) {
		VARIANT		varResult;
		EXCEPINFO	exception;

		ZeroMemory(&exception, sizeof(EXCEPINFO));
		hr = pParser->InitNew();
		hr = pParser->ParseScriptText(pwszSource,
			0, 0, 0, 0, 0, SCRIPTTEXT_ISVISIBLE, &varResult, &exception);
		pParser->Release();
	}
	delete[] pwszSource;
	m_pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);
	pApp->Release();

	if(SUCCEEDED(hr))
		return true;
	else {
		if(m_pScriptEngine != 0)	m_pScriptEngine->Release(), m_pScriptEngine = 0;
		if(m_pScriptHost != 0)		m_pScriptHost->Release(), m_pScriptHost = 0;
		return false;
	}
}

/* [EOF] */