// FindDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "FindDlg.h"
#include "Alpha.h"
#include <algorithm>	// std::find
using Alpha::CAlphaApp;
using Alpha::CFindDlg;
using Alpha::CSearchOptionDlg;


// CFindDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param app	AvP[V
 */
CFindDlg::CFindDlg(const CAlphaApp& app) : m_app(app) {
}

/**
 *	ɕǉ
 *	@param strText		ǉ镶
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::AddToHistory(const string_t& strText, bool bIsReplace) {
	AssertValid();

	list<string_t>&				listTarget = bIsReplace ? m_listReplaceWith : m_listFindWhat;
	list<string_t>::iterator	it;

	it = find(listTarget.begin(), listTarget.end(), strText);
	if(it != listTarget.end())
		listTarget.erase(it);
	listTarget.push_front(strText);

	if(IsWindow()) {
		UpdateHistory(bIsReplace);
		SendDlgItemMessage(bIsReplace ? IDC_COMBO_REPLACEWITH : IDC_COMBO_FINDWHAT, CB_SETCURSEL, 0, 0L);
	}
}

/**
 *	폜
 *	@param bIsReplace	ûƂ^
 */
void CFindDlg::ClearHistory(bool bIsReplace) {
	AssertValid();
	(bIsReplace ? m_listReplaceWith : m_listFindWhat).clear();
	if(IsWindow())
		UpdateHistory(bIsReplace);
}

///	擾
void CFindDlg::GetHistory(list<string_t>& listFindWhat, list<string_t>& listReplaceWith) const {
	AssertValid();
	listFindWhat = m_listFindWhat;
	listReplaceWith = m_listReplaceWith;
}

///	ݒ
void CFindDlg::SetHistory(const list<string_t>& listFindWhat, const list<string_t>& listReplaceWith) {
	AssertValid();

	// d`FbNȂRs[
	m_listFindWhat.clear();
	for(list<string_t>::const_iterator it = listFindWhat.begin(); it != listFindWhat.end(); ++it) {
		if(m_listFindWhat.end() == find(m_listFindWhat.begin(), m_listFindWhat.end(), *it))
			m_listFindWhat.push_back(*it);
	}
	m_listReplaceWith.clear();
	for(list<string_t>::const_iterator it = listReplaceWith.begin(); it != listReplaceWith.end(); ++it) {
		if(m_listReplaceWith.end() == find(m_listReplaceWith.begin(), m_listReplaceWith.end(), *it))
			m_listReplaceWith.push_back(*it);
	}

	if(IsWindow()) {
		UpdateHistory(false);
		UpdateHistory(true);
	}
}

/**	
 *	XgR{{bNXɔf
 *	@param	bIsReplace	ûƂ^
 */
void CFindDlg::UpdateHistory(bool bIsReplace) {
	AssertValidAsWindow();

	list<string_t>::const_iterator	it;
	HWND							hwndReplaceWithCombobox = GetDlgItem(IDC_COMBO_REPLACEWITH);

	if(!bIsReplace) {	// []
		SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_RESETCONTENT, 0, 0L);
		for(it = m_listFindWhat.begin(); it != m_listFindWhat.end(); ++it)
			SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
	} else{	// [u]
		if(::IsWindow(hwndReplaceWithCombobox)) {
			::SendMessage(hwndReplaceWithCombobox, CB_RESETCONTENT, 0, 0L);
			for(it = m_listReplaceWith.begin(); it != m_listReplaceWith.end(); ++it)
				::SendMessageW(hwndReplaceWithCombobox, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(it->c_str()));
		}
	}
}

///	̍XV
void CFindDlg::UpdateOptions() {
	AssertValidAsWindow();

	IAlphaTab*				pActiveTab = m_app.GetActiveTab();
	CAlphaEditController*	pActiveEditor;
	CAlphaView*				pActiveView;
	Ascension::SearchFlag	flags;

	if(pActiveTab == 0
			|| 0 == (pActiveEditor = pActiveTab->GetTextEditor())
			|| 0 == (pActiveView = pActiveEditor->GetActiveView()))
		return;

	flags = pActiveView->GetSearchFlags();
	flags &= ~(SF_MATCHCASE_MASK | /*SF_ONLYIDENTIFIERS |*/ SF_WHOLEWORD | SF_REGEXP);
//	if(IsDlgButtonChecked(IDC_CHK_ONLYIDENTIFIERS) == BST_CHECKED)
//		flags |= SF_ONLYIDENTIFIERS;
	if(IsDlgButtonChecked(IDC_CHK_WHOLEWORD) == BST_CHECKED)
		flags |= SF_WHOLEWORD;
	if(IsDlgButtonChecked(IDC_CHK_USEREGEXP) == BST_CHECKED)
		flags |= SF_REGEXP;
	switch(SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_GETCURSEL, 0, 0L)) {
	case 0:	flags |= SF_MATCH_CASE;			break;
	case 1:	flags |= SF_IGNORE_CASE_ASCII;	break;
	case 2:	flags |= SF_IGNORE_CASE_SIMPLE;	break;
	case 3:	flags |= SF_IGNORE_CASE_FULL;	break;
	}
	pActiveView->SetSearchFlags(flags);
}

///	@see	CDialog::OnActivate
void CFindDlg::OnActivate(UINT nState, HWND hwndPrevious, bool bMinimize) {
	if(nState == WA_INACTIVE)
		UpdateOptions();
	else if(IAlphaTab* pTab = m_app.GetActiveTab()) {
		if(CAlphaEditController* pEditor = pTab->GetTextEditor()) {
			CAlphaView*			pView = pEditor->GetActiveView();
			const bool			bHasFindText = ::GetWindowTextLengthW(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0;
			const SearchFlag	sfFlags = pView->GetSearchFlags();

			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bHasFindText);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bHasFindText);
			::EnableWindow(GetDlgItem(IDC_RADIO_SELECTION), false/*pView->HasSelection()*/);

			CheckDlg2StateButton(IDC_CHK_WHOLEWORD, toBoolean(sfFlags & SF_WHOLEWORD));
			CheckDlg2StateButton(IDC_CHK_USEREGEXP, toBoolean(sfFlags & SF_REGEXP));

			if((sfFlags & SF_IGNORE_CASE_FULL) == SF_IGNORE_CASE_ASCII)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 1, 0L);
			else if((sfFlags & SF_IGNORE_CASE_FULL) == SF_IGNORE_CASE_SIMPLE)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 2, 0L);
			else if((sfFlags & SF_IGNORE_CASE_FULL) == SF_IGNORE_CASE_FULL)
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 3, 0L);
			else
				SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_SETCURSEL, 0, 0L);
			CheckRadioButton(IDC_RADIO_SELECTION, IDC_RADIO_WHOLEFILE, IDC_RADIO_WHOLEFILE);
		}
	}
}

///	@see	CDialog::OnCancel
void CFindDlg::OnCancel() {
	OnClose();
}

///	@see	CDialog::OnClose
void CFindDlg::OnClose() {
	GetParent()->SendMessage(WM_COMMAND, CMD_SEARCH_FIND, reinterpret_cast<LPARAM>(this));
//	CDialog::OnClose();
}

///	@see	CDialog::OnCommand
bool CFindDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	switch(wID) {
	case CMD_SEARCH_FINDNEXT:		// []
	case CMD_SEARCH_FINDPREV:		// [O]
	case CMD_SEARCH_BOOKMARKALL:	// [ׂă}[N]
	case CMD_SEARCH_REPLACEALL:		// [ׂĒu]
	case CMD_SEARCH_REPLACEANDNEXT:	// [u]
		GetParent()->SendMessage(WM_COMMAND,
			MAKEWPARAM(wID, wNotifyCode), reinterpret_cast<LPARAM>(hwndCtrl));
		return true;
	case IDC_COMBO_FINDWHAT:
		if(wNotifyCode == CBN_EDITCHANGE || wNotifyCode == CBN_SELCHANGE) {
			const bool	bEnable = (wNotifyCode == CBN_EDITCHANGE) ?
				::GetWindowTextLength(GetDlgItem(IDC_COMBO_FINDWHAT)) != 0 : true;
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDNEXT), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_FINDPREV), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_BOOKMARKALL), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEANDNEXT), bEnable);
			::EnableWindow(GetDlgItem(CMD_SEARCH_REPLACEALL), bEnable);
		}
		break;
	case IDC_BTN_BROWSE: {	// [gIvV...] {^
		if(CAlphaEditController* pEditor = m_app.GetActiveTab()->GetTextEditor()) {
			CSearchOptionDlg	dlg(*pEditor->GetActiveView());
			dlg.Create(::GetModuleHandle(0), IDD_DLG_SEARCHOPTIONS, m_hWnd);
			dlg.DoModal();
		}
		}
		break;
	}
	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CFindDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	ModifyStyleEx(0, WS_EX_LAYERED);
	SetLayeredWindowAttributes(0, 220, LWA_ALPHA);

	SendDlgItemMessage(IDC_COMBO_FINDWHAT, CB_LIMITTEXT, 255, 0L);
	SendDlgItemMessage(IDC_COMBO_REPLACEWITH, CB_LIMITTEXT, 255, 0L);

	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_MATCHCASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_IGNOREASCIICASE).c_str()));
	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDINGSIMPLE).c_str()));
//	SendDlgItemMessage(IDC_COMBO_CASEFOLDING, CB_ADDSTRING, 0,
//		reinterpret_cast<LPARAM>(m_app.LoadString(MSG_CASEFOLDINGFULL).c_str()));

	UpdateHistory(false);
	UpdateHistory(true);
	OnCommand(IDC_COMBO_FINDWHAT, CBN_EDITCHANGE, GetDlgItem(IDC_COMBO_FINDWHAT));

	return true;
}


// CSearchOptionDlg class implementation
/////////////////////////////////////////////////////////////////////////////

/**
 *	RXgN^
 *	@param view	ݒr[
 */
CSearchOptionDlg::CSearchOptionDlg(Alpha::CAlphaView& view) : m_view(view) {
}

///	@see	CDialog::OnInitDialog
bool CSearchOptionDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	SearchFlag				stdSearchFlags = m_view.GetSearchFlags();
//	JapaneseFuzzySearchFlag	jpnFuzzyFlags = m_view.GetJapaneseFuzzySearchFlags();
#define CHECK_STD_OPTION(id, flag)	\
	CheckDlgButton(id, toBoolean(stdSearchFlags & flag) ? BST_CHECKED : BST_UNCHECKED)
#define CHECK_FUZZY_OPTION(id, flag)	\
	CheckDlgButton(id, toBoolean(jpnFuzzySearchFlags & flag) ? BST_CHECKED : BST_UNCHECKED)

	CHECK_STD_OPTION(IDC_CHK_IGNORE_SYMBOLS, SF_IGNORE_SYMBOLS);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_CONTROLS, SF_IGNORE_CONTROLS);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_PUNCTUATIONS, SF_IGNORE_PUNCTUATIONS);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_DIACRITICS, SF_IGNORE_DIACRITICS);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_VOWELS, SF_IGNORE_VOWELS);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_KASHIDA, SF_IGNORE_KASHIDA);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_WHITESPACES, SF_IGNORE_WHITESPACES);
	
	CHECK_STD_OPTION(IDC_CHK_IGNORE_WIDTH, SF_IGNORE_WIDTH);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_DIGITTYPE, SF_IGNORE_DIGITTYPE);
	CHECK_STD_OPTION(IDC_CHK_IGNORE_ALEFHAMZA, SF_IGNORE_ALEFHAMZA);
/*
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_KANATYPE, JFSF_KANATYPE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_YOUONSOKUON, JFSF_YOUON_SOKUON);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDS, JFSF_MINUS_PROLONGEDMARK_DASH);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_REPITATIONS, JFSF_ITERATIONMARK);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_UNSTABLEKANJIS, JFSF_UNUNIFIEDKANJI);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_LEGACYKANAGLYPHS, JFSF_LEGACY_MODERN_KANAFIGURE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDVOWELS, JFSF_PROLONGEDMARK_VOWEL);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_ZIZU, JFSF_DI_JI_DU_ZU);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_BAHA, JFSF_BA_VA_HA_FA);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_TIDI, JFSF_TSI_THI_TI_DHI_JI);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_HYUBYU, JFSF_HYU_FYU_BYU_VYU);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_SEZE, JFSF_SE_SYE_ZE_JE);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_AYAFOLLOWINGIE, JFSF_A_YA_FOLLOWING_I_E);
	CHECK_FUZZY_OPTION(IDC_CHK_IGNORE_KIKUFOLLOWEDBYS, JFSF_KI_KU_FOLLOWEDBY_S);
*/
	return true;

#undef CHECK_STANDARD_OPTION
#undef CHECK_FUZZY_OPTION
}

///	@see	CDialog::OnOK
void CSearchOptionDlg::OnOK() {
	SearchFlag				stdSearchFlags = m_view.GetSearchFlags();
//	JapaneseFuzzySearchFlag	jpnFuzzySarchFlags = 0;

#define GET_STD_OPTION(id, flag)	\
	if(IsDlgButtonChecked(id) == BST_CHECKED)	stdSearchFlags |= flag;
#define GET_FUZZY_OPTION(id, flag)	\
	if(IsDlgButtonChecked(id) == BST_CHECKED)	jpnFuzzySearchFlags |= flag;

	stdSearchFlags &= ~(SF_IGNORE_SYMBOLS
		| SF_IGNORE_CONTROLS | SF_IGNORE_PUNCTUATIONS | SF_IGNORE_DIACRITICS
		| SF_IGNORE_VOWELS | SF_IGNORE_KASHIDA | SF_IGNORE_WHITESPACES
		| SF_IGNORE_WIDTH | SF_IGNORE_DIGITTYPE | SF_IGNORE_ALEFHAMZA);

	GET_STD_OPTION(IDC_CHK_IGNORE_SYMBOLS, SF_IGNORE_SYMBOLS);
	GET_STD_OPTION(IDC_CHK_IGNORE_CONTROLS, SF_IGNORE_CONTROLS);
	GET_STD_OPTION(IDC_CHK_IGNORE_PUNCTUATIONS, SF_IGNORE_PUNCTUATIONS);
	GET_STD_OPTION(IDC_CHK_IGNORE_DIACRITICS, SF_IGNORE_DIACRITICS);
	GET_STD_OPTION(IDC_CHK_IGNORE_VOWELS, SF_IGNORE_VOWELS);
	GET_STD_OPTION(IDC_CHK_IGNORE_KASHIDA, SF_IGNORE_KASHIDA);
	GET_STD_OPTION(IDC_CHK_IGNORE_WHITESPACES, SF_IGNORE_WHITESPACES);
	
	GET_STD_OPTION(IDC_CHK_IGNORE_WIDTH, SF_IGNORE_WIDTH);
	GET_STD_OPTION(IDC_CHK_IGNORE_DIGITTYPE, SF_IGNORE_DIGITTYPE);
	GET_STD_OPTION(IDC_CHK_IGNORE_ALEFHAMZA, SF_IGNORE_ALEFHAMZA);

	m_view.SetSearchFlags(stdSearchFlags);
/*
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_KANATYPE, JFSF_KANATYPE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_YOUONSOKUON, JFSF_YOUON_SOKUON);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDS, JFSF_MINUS_PROLONGEDMARK_DASH);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_REPITATIONS, JFSF_ITERATIONMARK);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_UNSTABLEKANJIS, JFSF_UNUNIFIEDKANJI);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_LEGACYKANAGLYPHS, JFSF_LEGACY_MODERN_KANAFIGURE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_PRELONGEDVOWELS, JFSF_PROLONGEDMARK_VOWEL);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_ZIZU, JFSF_DI_JI_DU_ZU);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_BAHA, JFSF_BA_VA_HA_FA);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_TIDI, JFSF_TSI_THI_TI_DHI_JI);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_HYUBYU, JFSF_HYU_FYU_BYU_VYU);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_SEZE, JFSF_SE_SYE_ZE_JE);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_AYAFOLLOWINGIE, JFSF_A_YA_FOLLOWING_I_E);
	GET_FUZZY_OPTION(IDC_CHK_IGNORE_KIKUFOLLOWEDBYS, JFSF_KI_KU_FOLLOWEDBY_S);

	m_view.SetJapaneseFuzzySearchFlags(jpnFuzzySearchFlags);
*/
	CDialog::OnOK();

#undef GET_STD_OPTION
#undef GET_FUZZY_OPTION
}


/* [EOF] */