// FindDlg.h
// (c) 2003-2004 exeal

#ifndef _FIND_DLG_H_
#define _FIND_DLG_H_
#include "..\Manah\Dialog.h"
#include "Ascension\TextSearcher.h"
#include <list>
using Manah::Windows::Controls::CDialog;
using namespace Ascension;


// CFindDlg class definition
/////////////////////////////////////////////////////////////////////////////

namespace Alpha {

class CAlphaApp;
class CAlphaView;

/**
 *	@brief	[ƒu] _CAOB
 *
 *	̃NX̓C^[tFCXŌ̂߂̋@\͎ĂȂ
 */
class CFindDlg : public CDialog {
	// RXgN^
public:
	CFindDlg(const CAlphaApp& app);

	// \bh
public:
	void		AddToHistory(const string_t& strText, bool bIsReplace);
	void		ClearHistory(bool bIsReplace);
	string_t	GetFindText() const;
	void		GetHistory(list<string_t>& listFindWhat, list<string_t>& listReplaceWith) const;
	string_t	GetReplaceText() const;
	void		SetHistory(const list<string_t>& listFindWhat, const list<string_t>& listReplaceWith);
	void		UpdateOptions();
protected:
	void	UpdateHistory(bool bIsReplace);

	// bZ[Wnh
protected:
	void	OnActivate(UINT nState, HWND hwndPrevious, bool bMinimized);	// WM_ACTIVATE
	void	OnCancel();														// IDCANCEL
	void	OnClose();														// WM_CLOSE
	bool	OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl);			// WM_COMMAND
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);				// WM_INITDIALOG

	//f[^o
public:
	list<string_t>	m_listFindWhat;		// 񗚗
	list<string_t>	m_listReplaceWith;	// u񗚗
private:
	const CAlphaApp&	m_app;
};


// CSearchOptionDlg class definition
/////////////////////////////////////////////////////////////////////////////

///	[̊gIvV] _CAO
class CSearchOptionDlg : public CDialog {
	// RXgN^
public:
	CSearchOptionDlg(CAlphaView& view);

	// bZ[Wnh
protected:
	bool	OnInitDialog(HWND hwndFocus, LPARAM lInitParam);	// WM_INITDIALOG
	void	OnOK();												// IDOK

	// f[^o
private:
	CAlphaView&	m_view;
};


///	Ԃ
inline string_t CFindDlg::GetFindText() const {
	AssertValidAsWindow();
	char_t	wsz[256];
	GetDlgItemText(IDC_COMBO_FINDWHAT, wsz, 256);
	return wsz;
}

///	uԂ
inline string_t CFindDlg::GetReplaceText() const {
	AssertValidAsWindow();
	char_t	wsz[256];
	GetDlgItemText(IDC_COMBO_REPLACEWITH, wsz, 256);
	return wsz;
}

} // namespace Alpha

#endif /* _FIND_DLG_H_ */

/* [EOF] */