// KeyboardMap.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "KeyboardMap.h"
#include "..\Manah\File.h"
using namespace Alpha;

const wchar_t* CKeyboardMap::m_arrKeyName[0x0100] = {	// L[̖O (蓖ĕs\ȃL[ null)
	/* 0x00 */	0,	0,	0,	L"Esc",	L"NbN",	0,	0,	0,
				L"BackSpace",	L"Tab",	0,	0,	L"Delete",	L"Enter",	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				L"Esc",	0,	0,	0,	0,	0,	0,	0,
	/* 0x20 */	L"Space",	L"PageUp",	L"PageDown",	L"End",	L"Home",	L"",	L"",	L"",
				L"",	0,	0,	0,	0,	L"Insert",	0,	0,
				L"0",	L"1",	L"2",	L"3",	L"4",	L"5",	L"6",	L"7",
				L"8",	L"9",	0,	0,	0,	0,	0,	0,
	/* 0x40 */	0,	L"A",	L"B",	L"C",	L"D",	L"E",	L"F",	L"G",
				L"H",	L"I",	L"J",	L"K",	L"L",	L"M",	L"N",	L"O",
				L"P",	L"Q",	L"R",	L"S",	L"T",	L"U",	L"V",	L"W",
				L"X",	L"Y",	L"Z",	0,	0,	0,	0,	0,
	/* 0x60 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	L"numpad *",	L"numpad +",	L"|",	L"numpad -",	L"numpad .",	L"numpad /",
				L"F1",	L"F2",	L"F3",	L"F4",	L"F5",	L"F6",	L"F7",	L"F8",
				L"F9",	L"F10",	L"F11",	L"F12",	L"F13",	L"F14",	L"F15",	L"F16",
	/* 0x80 */	L"F17",	L"F18",	L"F19",	L"F20",	L"F21",	L"F22",	L"F23",	L"F24",
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
	/* 0xA0 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	L":",	L";",	L",",	L"-",	L".",	L"/",
	/* 0xC0 */	L"@",	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	L"[",	L"\\",	L"]",	L"^",	0,
	/* 0xE0 */	0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0,
				0,	0,	0,	0,	0,	0,	0,	0
};


// CKeyboardMap class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CKeyboardMap::CKeyboardMap() {
	Reset();
	m_bDirty = false;
}

/**
 *	݂̃IuWFNg̏ԂANZ[^e[u쐬AԂ
 *	@return	쐬ꂽANZ[^e[uBĂяo폜KvB
 *			R}h1o^ĂȂƂ null
 */
HACCEL CKeyboardMap::CreateAcceleratorTable() const {
	if(m_cCommands == 0)
		return 0;

	HACCEL	hAccel = 0;
	LPACCEL	pAccels = new ACCEL[m_cCommands];

	size_t	c = 0;
	for(VirtualKey i = 0; i < 0x0100; ++i) {
		for(KeyModifier j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] != 0) {
				(pAccels + c)->cmd = m_arrCommands[j][i];
				(pAccels + c)->key = i;
				(pAccels + c)->fVirt = FNOINVERT | FVIRTKEY;
				if(toBoolean(j & KM_ALT))
					(pAccels + c)->fVirt |= FALT;
				if(toBoolean(j & KM_CTRL))
					(pAccels + c)->fVirt |= FCONTROL;
				if(toBoolean(j & KM_SHIFT))
					(pAccels + c)->fVirt |= FSHIFT;
				++c;
			}
		}
	}
	assert(c == m_cCommands);
	hAccel = ::CreateAcceleratorTable(pAccels, m_cCommands);

	delete[] pAccels;
	return hAccel;
}

/**
 *	L[R}h ID 擾
 *	@param Key				zL[
 *	@param km				CL[
 *	@return					蓖ĂĂR}h IDB蓖ĂĂȂƂ0
 *	@exception out_of_range	<var>key</var> sȂƂX[
 */
CommandId CKeyboardMap::GetCommandID(VirtualKey key, KeyModifier km) const throw(out_of_range) {
	if(key >= 0x0100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	return m_arrCommands[km][key];
}

/**
 *	蓖ĂĂL[ƏCL[Ԃ
 *	@param nCommand	R}h ID
 *	@param key		zL[
 *	@param km		CL[
 *	@return			R}ho^Ăΐ^
 */
bool CKeyboardMap::GetKeyBind(CommandId nCommand, VirtualKey& key, KeyModifier& km) const {
	for(VirtualKey i = 0; i < 0x0100; ++i) {
		for(KeyModifier j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] == nCommand) {
				key = i;
				km = static_cast<KeyModifier>(j);
				return true;
			}
		}
	}
	return false;
}

/**
 *	L[̖OԂ
 *	@param key				zL[
 *	@return					L[BΉL[ꍇ null
 *	@exception out_of_range	<var>key</var> sȂƂX[
 */
const wchar_t* CKeyboardMap::GetKeyName(VirtualKey key) throw(out_of_range) {
	if(key >= 0x100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	return m_arrKeyName[key];
}

/**
 *	R}hɊ蓖ĂĂL[̕\擾
 *	@param nCommand	R}h
 *	@return			"Ctrl+N" Ȃǂ̕\Bo^ĂȂ΋󕶎
 */
wstring CKeyboardMap::GetKeyString(CommandId nCommand) const {
	wstring	strCand = L"THIS LONG PRESET STRING IS DUMMY";

	for(VirtualKey i = 0; i < 0x0100; ++i) {
		for(KeyModifier j = 0; j < 8; ++j) {
			if(m_arrCommands[j][i] == nCommand) {
				wstring	str;
				str.reserve(30);
				if(toBoolean(j & KM_CTRL))
					str += L"Ctrl+";
				if(toBoolean(j & KM_SHIFT))
					str += L"Shift+";
				if(toBoolean(j & KM_ALT))
					str += L"Alt+";
				str += m_arrKeyName[i];
				if(str.length() < strCand.length())
					strCand = str;
			}
		}
	}
	return (strCand.length() < 30) ? strCand : L"";
}

///	@see	ISerializable::IsDirty
bool CKeyboardMap::IsDirty() const {
	return m_bDirty;
}

///	@see	ISerializable::Load
bool CKeyboardMap::Load(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	Reset();

	try {
		CFile		oFile(pwszPathName, CFile::modeRead);
		CommandId	nCommand;
		VirtualKey	key;
		KeyModifier	modifier;

		while(true) {
			if(sizeof(CommandId) != oFile.Read(&nCommand, sizeof(CommandId)))
				break;
			if(sizeof(VirtualKey) != oFile.Read(&key, sizeof(VirtualKey)))
				break;
			if(sizeof(KeyModifier) != oFile.Read(&modifier, sizeof(KeyModifier)))
				break;
			SetOneCommand(key, modifier, nCommand);
		}
		oFile.Close();
	} catch(CFileException& /*e*/) {
		return false;
	} catch(out_of_range&) {
		return false;
	}

	m_bDirty = false;
	return true;
}

///	o^Sĉ
void CKeyboardMap::Reset() {
	m_bDirty = true;
	m_cCommands = 0;
	memset(m_arrCommands, 0, sizeof(CommandId) * 0x0100 * 8);
}

///	@see	ISerializable::Save
bool CKeyboardMap::Save(const wchar_t* pwszPathName) {
	assert(pwszPathName != 0);

	using namespace Manah::Windows::IO;

	try {
		CFile	oFile(pwszPathName, CFile::modeWrite | CFile::modeCreate | CFile::shareExclusive);
		for(VirtualKey key = 0x0000; key < 0x0100; ++key) {
			for(KeyModifier modifier = 0; modifier < 8; ++modifier) {
				if(m_arrCommands[modifier][key] != 0) {	// R}h
					oFile.Write(&m_arrCommands[modifier][key], sizeof(CommandId));
					oFile.Write(&key, sizeof(VirtualKey));
					oFile.Write(&modifier, sizeof(KeyModifier));
				}
			}
		}
		oFile.Close();
	} catch(CFileException& /*e*/) {
		return false;
	}

	m_bDirty = false;
	return true;
}

/**
 *	1̃R}ho^
 *	@param key			zL[
 *	@param km			CL[
 *	@param nCommand		R}h ID
 *	@throw out_of_range	<var>key</var> 256ȏ̂ƂX[
 */
void CKeyboardMap::SetOneCommand(VirtualKey key, KeyModifier km, CommandId nCommand) throw(out_of_range) {
	if(key >= 0x0100)
		throw out_of_range("The first argument is invalid as virutal key code.");
	if(nCommand != 0 && m_arrCommands[km][key] == 0)
		++m_cCommands;
	else if(nCommand == 0 && m_arrCommands[km][key] != 0)
		--m_cCommands;
	m_arrCommands[km][key] = nCommand;
	m_bDirty = true;
}

/* [EOF] */