// KeyboardMap.h
// (c) 2003-2004 exeal

#ifndef _KEYBOARD_MAP_H_
#define _KEYBOARD_MAP_H_

#include "AlphaInterfaces.h"


// CKeyboardMap class definition
/////////////////////////////////////////////////////////////////////////////

namespace Alpha {

interface ISerializable;

///	zL[R[ȟ^
typedef WORD	VirtualKey;	// typeof(ACCEL::key)

///	zL[̏CL[
typedef unsigned char	KeyModifier;
const KeyModifier	KM_SHIFT	= 0x01;
const KeyModifier	KM_CTRL		= 0x02;
const KeyModifier	KM_ALT		= 0x04;

///	L[oCh̊Ǘ
class CKeyboardMap : public ISerializable {
	// RXgN^
public:
	CKeyboardMap();

	// \bh
public:
	HACCEL		CreateAcceleratorTable() const;
	CommandId	GetCommandID(VirtualKey key, KeyModifier km) const throw(out_of_range);
	bool		GetKeyBind(CommandId nCommand, VirtualKey& key, KeyModifier& km) const;
	wstring		GetKeyString(CommandId nCommand) const;
	void		Reset();
	void		SetOneCommand(VirtualKey kKey, KeyModifier km, CommandId nCommand) throw(out_of_range);

	static const wchar_t*	GetKeyName(VirtualKey sVKey) throw(out_of_range);

	// ISerializable \bh
	bool	IsDirty() const;
	bool	Load(const wchar_t* pwszPathName);
	bool	Save(const wchar_t* pwszPathName);

	// f[^o
private:
	CommandId				m_arrCommands[8][0x0100];	// (CL[) * (zL[R[h) ŃR}h ID i[B
														// 0łΉo^ĂȂ
	size_t					m_cCommands;				// ۂɓo^ꂽR}h̐
	static const wchar_t*	m_arrKeyName[0x0100];
	bool					m_bDirty;
};

}

#endif /* _KEYBOARD_MAP_H_ */

/* [EOF] */