// ScriptMacroManager.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "ScriptMacroManager.h"
#include "Alpha.h"				// CAlphaApp
#include "AlphaScriptHost.h"	// CAlphaScriptHost
#include "Ambient.h"			// CApplication
#include "SelectLanguageDlg.h"
#include "..\Manah\Text.h"
using namespace Alpha;
using namespace Manah;
using namespace Manah::Text;


namespace {
	struct TScriptStartupInfo {
		CScriptMacroManager*	pThis;
		wchar_t*				pwszSource;
		vector<wstring>			vecArgs;
		CAlphaApp*				pApplication;
		wstring					strLanguageName;
		wstring					strScriptPath;
		bool					bFailedToLoadEngine;
		HANDLE					hInitializeEvent;
		CSelectLanguageDlg		dlgSelectLanguage;
	};
}


// CScriptMacroManager class implementation
/////////////////////////////////////////////////////////////////////////////

///	RXgN^
CScriptMacroManager::CScriptMacroManager(CAlphaApp& app)
		: m_app(app), m_bExecuting(false), m_ppMacros(0), m_cMacros(0) {
	m_oSAXHandler.m_pThis = this;
}

///	fXgN^
CScriptMacroManager::~CScriptMacroManager() {
	if(m_ppMacros != 0) {
		for(size_t i = 0; i < m_cMacros; ++i)
			delete m_ppMacros[i];
		delete[] m_ppMacros;
	}
}

/**
 *	vOCs
 *	@param i					vOC̔ԍ
 *	@param args					XNvgɓn
 *	@throw out_of_range			<var>i</var> ȂƂX[
 *	@throw EFailedToOpenScript	XNvgt@CJȂꍇX[
 *	@throw EInvalidLanguage		ꖼȂꍇX[
 */
void CScriptMacroManager::Execute(size_t i, const vector<wstring>& args)
		throw(out_of_range, EFailedToOpenScript, EInvalidLanguage) {
	using namespace Manah::Windows::IO;

	if(i >= m_cMacros)
		throw out_of_range("Invalid index.");

	const TMacroInfo*	pInfo = m_ppMacros[i];
	wchar_t*			pwszSource = 0;
	wchar_t				wszFilePath[MAX_PATH];
	CFile				oFile;
	DWORD				dwFileSize;
	wchar_t*			pwszTitle;
	CEncoder*			pEncoder;
	char*				pszSource;

	wcscpy(wszFilePath, m_strFilePath.c_str());
	pwszTitle = wcsrchr(wszFilePath, L'\\');
	wcscpy(pwszTitle + 1, pInfo->strScriptPath.c_str());
	if(!toBoolean(::PathFileExistsW(wszFilePath)))
		throw EFailedToOpenScript(wszFilePath);
	try {
		oFile.Open(wszFilePath, CFile::modeRead | CFile::shareDenyNone);
	} catch(CFileException& /* e */) {
		throw EFailedToOpenScript(wszFilePath);
	}
	pEncoder = CEncoder::Create(CP_UTF8);	// XNvg UTF-8
	dwFileSize = oFile.GetFileSize(0);
	pszSource = new char[dwFileSize];
	dwFileSize = oFile.Read(pszSource, dwFileSize);
	oFile.Close();
	pwszSource = new wchar_t[dwFileSize + 1];
	dwFileSize = pEncoder->ConvertToUnicode(pwszSource, dwFileSize, pszSource, dwFileSize);
	delete pEncoder;
	*(pwszSource + dwFileSize) = 0;
	delete[] pszSource;

	TScriptStartupInfo*	pStartupInfo = new TScriptStartupInfo;
	pStartupInfo->pThis = this;
	pStartupInfo->pwszSource = pwszSource;
	pStartupInfo->vecArgs = args;
	pStartupInfo->pApplication = &m_app;
	pStartupInfo->bFailedToLoadEngine = false;
	pStartupInfo->strLanguageName = pInfo->strLanguage;
	pStartupInfo->strScriptPath = wszFilePath;
	pStartupInfo->hInitializeEvent = ::CreateEventW(0, false, false, 0);
	pStartupInfo->dlgSelectLanguage.Create(::GetModuleHandle(0),
		IDD_DLG_SELECTLANGUAGE, m_app.GetMainWindow()->m_hWnd);
	m_bExecuting = true;
	if(-1L == ::_beginthread(CScriptMacroManager::ScriptThreadProc, 0, pStartupInfo)) {
		delete pStartupInfo;
		delete[] pwszSource;
		return;
	}
	::WaitForSingleObject(pStartupInfo->hInitializeEvent, INFINITE);
	if(pStartupInfo->bFailedToLoadEngine)	// XNvgGW[hłȂ
		throw EInvalidLanguage(pInfo->strLanguage);
}

///	vOČԂ
size_t CScriptMacroManager::GetCount() const {
	return m_cMacros;
}

/**
 *	vOC̐Ԃ
 *	@param i			vOC̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
wstring CScriptMacroManager::GetDescription(size_t i) const throw(out_of_range) {
	if(i >= m_cMacros)
		throw out_of_range("Specified plugin not found.");
	return m_ppMacros[i]->strDescription;
}

/**
 *	vOC̖OԂ
 *	@param i			vOC̔ԍ
 *	@throw out_of_range	<var>i</var> ȂƂX[
 */
wstring CScriptMacroManager::GetName(size_t i) const throw(out_of_range) {
	if(i >= m_cMacros)
		throw out_of_range("Specified plugin not found.");
	return m_ppMacros[i]->strName;
}

/**
 *	t@C}N[h
 *	@param pwszFilePath	vOCt@C
 *	@return				
 */
bool CScriptMacroManager::Load(const wchar_t* pwszFilePath) throw(EFailedToParseXml) {
	assert(pwszFilePath != 0);

	CComPtr<ISAXXMLReader>	pXMLReader;
	HRESULT					hr;

	if(m_ppMacros != 0) {
		for(size_t i = 0; i < m_cMacros; ++i)
			delete m_ppMacros;
		delete[] m_ppMacros;
		m_ppMacros = 0;
	}

	m_strFilePath = pwszFilePath;
	hr = ::CoCreateInstance(__uuidof(SAXXMLReader), 0,
		CLSCTX_ALL, __uuidof(ISAXXMLReader), reinterpret_cast<void**>(&pXMLReader));
	if(SUCCEEDED(hr)) {
		pXMLReader->putContentHandler(&m_oSAXHandler);
		pXMLReader->putErrorHandler(&m_oSAXHandler);
		hr = pXMLReader->parseURL(const_cast<wchar_t*>(pwszFilePath));
		if(FAILED(hr))
			return false;
	} else
		throw EFailedToParseXml();

	return true;
}

void __cdecl CScriptMacroManager::ScriptThreadProc(void* p) {
	TScriptStartupInfo*	pInfo = static_cast<TScriptStartupInfo*>(p);
	CLSID							clsidLanguageEngine;
	CComPtr<IActiveScript>			pScriptEngine;			// XNvgGW
	CComPtr<IActiveScriptParse>		pScriptParser;			// p[T
	CComPtr<CAlphaScriptHost>		pScriptHost;			// XNvgzXg
	CComPtr<Ambient::CScriptHost>	pAutomationScriptHost;	// ActiveX 
	CComPtr<Ambient::CApplication>	pApplication;			// ŏʃIuWFNg
	long							nResult = 0;
	HRESULT							hr;

	::CoInitializeEx(0, COINIT_MULTITHREADED);	// MTA ɓ
	pInfo->pApplication->GetAutomation(&pApplication, 0);

	// ꖼXNvgGW[h
	wstring	strLanguage = pInfo->strLanguageName;
	if(strLanguage.empty()) {
		CAlphaScriptHost::FindScriptEngine(pInfo->strScriptPath.c_str(), clsidLanguageEngine);
		if(clsidLanguageEngine == IID_NULL) {
			if(pInfo->dlgSelectLanguage.DoModal() != IDOK)
				goto EndThread;
			strLanguage = pInfo->dlgSelectLanguage.GetSelectedLanguage();
			if(FAILED(::CLSIDFromProgID(strLanguage.c_str(), &clsidLanguageEngine))) {
				pInfo->bFailedToLoadEngine = true;
				::SetEvent(pInfo->hInitializeEvent);
				goto EndThread;
			}
		}
	} else if(FAILED(::CLSIDFromProgID(strLanguage.c_str(), &clsidLanguageEngine))) {
		pInfo->bFailedToLoadEngine = true;
		::SetEvent(pInfo->hInitializeEvent);
		goto EndThread;
	}
	if(FAILED(pScriptEngine.CreateInstance(clsidLanguageEngine))) {
		pInfo->bFailedToLoadEngine = true;
		::SetEvent(pInfo->hInitializeEvent);
		goto EndThread;
	}
	::SetEvent(pInfo->hInitializeEvent);

	// XNvgs̏
	pScriptHost = new CAlphaScriptHost(pInfo->pThis->m_app.GetMainWindow()->m_hWnd, pScriptEngine, true);
	pAutomationScriptHost = new Ambient::CScriptHost(pScriptHost);
	pScriptHost->SetScriptPath(pInfo->strScriptPath.c_str());
	pScriptHost->SetSecurityLevel(true,
		static_cast<ScriptSiteSecurityLevel>(
		pInfo->pThis->m_app.GetProfileInt(L"Script", L"securityLevelForSafeObject", 0)));
	pScriptHost->SetSecurityLevel(false,
		static_cast<ScriptSiteSecurityLevel>(
		pInfo->pThis->m_app.GetProfileInt(L"Script", L"securityLevelForUnsafeObject", 1)));
	hr = pScriptEngine->SetScriptSite(pScriptHost);

	const DWORD	dwItemTraits = SCRIPTITEM_ISPERSISTENT | SCRIPTITEM_ISVISIBLE;
	pScriptHost->AddTopLevelObject(OLESTR("Ambient"), pApplication, dwItemTraits | SCRIPTITEM_GLOBALMEMBERS);
	pScriptHost->AddTopLevelObject(OLESTR("Alpha"), pApplication, dwItemTraits | SCRIPTITEM_GLOBALMEMBERS);
	pScriptHost->AddTopLevelObject(OLESTR("WScript"), pAutomationScriptHost, dwItemTraits);

	{	// ̃x瓦邽߂̃ubN
		set<pair<wstring, CEnumImpl*> >	enums;
		pApplication->GetEnumerations(enums);
		for(set<pair<wstring, CEnumImpl*> >::iterator it = enums.begin(); it != enums.end(); ++it) {
			pScriptHost->AddTopLevelObject(it->first.c_str(), it->second, dwItemTraits);
			it->second->Release();
		}
	}
	pScriptEngine->QueryInterface(IID_IActiveScriptParse, reinterpret_cast<void**>(&pScriptParser));
	hr = pScriptEngine->SetScriptState(SCRIPTSTATE_INITIALIZED);
	hr = pScriptParser->InitNew();

	// s
	if(SUCCEEDED(pScriptParser->ParseScriptText(
			pInfo->pwszSource, 0, 0, 0, 0, 0, SCRIPTTEXT_ISPERSISTENT | SCRIPTTEXT_ISVISIBLE, 0, 0))) {
		CComPtr<IDispatch>	pTopLevel;
		hr = pScriptEngine->SetScriptState(SCRIPTSTATE_STARTED);
		hr = pScriptEngine->SetScriptState(SCRIPTSTATE_CONNECTED);
		if(SUCCEEDED(pScriptEngine->GetScriptDispatch(0, &pTopLevel))) {
			DISPID		dispid;
			OLECHAR*	pwszRoutineName = OLESTR("main");
			if(SUCCEEDED(pTopLevel->GetIDsOfNames(IID_NULL, &pwszRoutineName, 1, LOCALE_USER_DEFAULT, &dispid))) {
				DISPPARAMS	params;
				VARIANT		varResult;
				VARIANTARG	varArg;
				EXCEPINFO	exception;
				UINT		iArgErr;

				::VariantInit(&varArg);
				varArg.vt = VT_DISPATCH;
				varArg.pdispVal = new Ambient::CArguments(pInfo->vecArgs);
				varArg.pdispVal->AddRef();
				params.cArgs = 1;
				params.cNamedArgs = 0;
				params.rgdispidNamedArgs = 0;
				params.rgvarg = &varArg;
				::VariantInit(&varResult);
				pTopLevel->Invoke(dispid, IID_NULL, LOCALE_USER_DEFAULT,
					DISPATCH_METHOD, &params, &varResult, &exception, &iArgErr);
				varArg.pdispVal->Release();

				::VariantChangeType(&varResult, &varResult, 0, VT_I4);
				nResult = varResult.lVal;
				::VariantClear(&varResult);
			}
		}
	}

EndThread:
	// n
	if(pScriptEngine != 0)
		pScriptEngine->Close();
	pInfo->pThis->m_bExecuting = false;
	pInfo->pApplication->GetMainWindow()->SendMessage(WM_ENDSCRIPTMACRO);
	delete[] pInfo->pwszSource;
	delete pInfo;
	::CoUninitialize();
}


// CSAXReadHandler class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	ISAXContentHandler::characters
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::characters(wchar_t* pwchChars, int cchChars) {
	if(m_nReadingPhase == 1)	// <description>
		m_listWork.begin()->strDescription.append(pwchChars, cchChars);
	return S_OK;
}

///	@see	ISAXContentHandler::endDocument
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endDocument() {
	assert(m_pThis->m_ppMacros == 0);
	m_pThis->m_cMacros = m_listWork.size();
	if(m_listWork.empty())
		return S_OK;

	m_pThis->m_ppMacros = new TMacroInfo*[m_pThis->m_cMacros];

	TMacroInfo**	pp = m_pThis->m_ppMacros;
	for(list<TMacroInfo>::reverse_iterator it = m_listWork.rbegin(); it != m_listWork.rend(); ++it, ++pp)
		*pp = new TMacroInfo(*it);
	m_listWork.clear();
	return S_OK;
}

///	@see	ISAXContentHandler::endElement
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endElement(wchar_t* pwchNamespaceUri,
		int cchNamespaceUri, wchar_t* pwchLocalName, int cchLocalName, wchar_t* pwchQName, int cchQName) {
	if(wcsncmp(pwchLocalName, L"description", cchLocalName) == 0
			|| wcsncmp(pwchLocalName, L"script", cchLocalName) == 0)
		m_nReadingPhase = 0;
	return S_OK;
}

///	@see	ISAXContentHandler::endPrefixMapping
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::endPrefixMapping(wchar_t* pwchPrefix, int cchPrefix) {
	return S_OK;
}

///	@see	ISAXErrorHandler::error
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::error(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	ss;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	ss << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pThis->m_app.GetMainWindow()->MessageBox(L"Alpha", ss.str().c_str(), MB_ICONEXCLAMATION);
	return S_OK;
}

///	@see	ISAXErrorHandler::fatalError
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::fatalError(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	wostringstream	ss;
	int	iLine, iChar;
	pLocator->getLineNumber(&iLine);
	pLocator->getColumnNumber(&iChar);
	ss << L"[" << iLine << L", " << iChar << L"] " << pwchErrorMessage;
	m_pThis->m_app.GetMainWindow()->MessageBox(L"Alpha", ss.str().c_str(), MB_ICONEXCLAMATION);
	return S_OK;
}

///	@see	ISAXErrorHandler::ignorableWarning
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::ignorableWarning(
		ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode) {
	return S_OK;
}

///	@see	ISAXContentHandler::ignorableWhitespace
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::ignorableWhitespace(wchar_t* pwchChars, int cchChars) {
	return S_OK;
}

///	@see	ISAXContentHandler::processingInstruction
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::processingInstruction(
		wchar_t* pwchTarget, int cchTarget, wchar_t* pwchData, int cchData) {
	return S_OK;
}

///	@see	ISAXContentHandler::putDocumentLocator
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::putDocumentLocator(ISAXLocator* pLocator) {
	return S_OK;
}

///	@see	ISAXContentHandler::skippedEntity
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::skippedEntity(wchar_t* pwchName, int cchName) {
	return S_OK;
}

///	@see	ISAXContentHandler::startDocument
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startDocument() {
	return S_OK;
}

///	@see	ISAXContentHandler::startElement
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
	   wchar_t* pwchLocalName, int cchLocalName, wchar_t* pwchQName, int cchQName, ISAXAttributes* pAttributes) {
	wchar_t*	pwszValue = 0;
	int			cchValue;
		
	if(wcsncmp(pwchLocalName, L"macro", cchLocalName) == 0) {	// macro vf name 擾
		m_nReadingPhase = 0;
		TMacroInfo	pi;
		if(SUCCEEDED(pAttributes->getValueFromName(L"", 0, L"name", 4, &pwszValue, &cchValue)))
			pi.strName.assign(pwszValue, cchValue);
		m_listWork.push_front(pi);
	} else if(wcsncmp(pwchLocalName, L"script", cchLocalName) == 0) {	// script vf language Asrc 擾
		m_nReadingPhase = 2;
		if(SUCCEEDED(pAttributes->getValueFromName(L"", 0, L"language", 8, &pwszValue, &cchValue)))
			m_listWork.begin()->strLanguage.assign(pwszValue, cchValue);
		if(SUCCEEDED(pAttributes->getValueFromName(L"", 0, L"src", 3, &pwszValue, &cchValue))) {
			wstring&	str = m_listWork.begin()->strScriptPath;
			str.assign(pwszValue, cchValue);
			// XbVobNXbVɕύXĂ
			for(int i = 0; i < cchValue; ++i) {
				if(str[i] == L'/')
					str[i] = L'\\';
			}
		}
	} else if(wcsncmp(pwchLocalName, L"description", cchLocalName) == 0)
		m_nReadingPhase = 1;
	return S_OK;
}

///	@see	ISAXContentHandler::startPrefixMapping
STDMETHODIMP CScriptMacroManager::CSAXReadHandler::startPrefixMapping(
		wchar_t* pwchPrefix, int cchPrefix, wchar_t* pwchUri, int cchUri) {
	return S_OK;
}

/* [EOF] */