// ScriptMacroManager.h
// (c) 2003-2004 exeal

#ifndef _SCRIPT_MACRO_MANAGER_H_
#define _SCRIPT_MACRO_MANAGER_H_

#include <vector>
#include <list>
#include "..\Armaiti\UnknownImpl.h"
using namespace Armaiti;
#define _COM_NO_STANDARD_GUIDS_
#include "msxml3.tlh"
using namespace MSXML2;


namespace Alpha {

class CAlphaApp;


// CScriptMacroManager class definition
/////////////////////////////////////////////////////////////////////////////


///	vOC̊Ǘ
class CScriptMacroManager {
	// oNX
public:
	///	XNvgt@CJȂƂO
	class EFailedToOpenScript : public runtime_error {
	public:
		EFailedToOpenScript(const wstring& strFileName) :
			runtime_error("Specified script file is not found."), m_strFileName(strFileName) {
		}
		const wstring	m_strFileName;
	};
	///	XNvǧꖼȂƂO
	class EInvalidLanguage : public runtime_error {
	public:
		EInvalidLanguage(const wstring& strLanguage) :
			runtime_error("Specified language is invalid or not supported"), m_strLanguage(strLanguage) {
		}
		const wstring	m_strLanguage;
	};
	///	XML ̉͂ɎsƂO
	class EFailedToParseXml : public runtime_error {
	public:
		EFailedToParseXml() : runtime_error("Failed to load SAX parser.") {
		}
	};

	// RXgN^
public:
	CScriptMacroManager(CAlphaApp& app);
	~CScriptMacroManager();

	// \bh
public:
	void	Execute(size_t i, const vector<wstring>& args = vector<wstring>())
				throw(out_of_range, EFailedToOpenScript, EInvalidLanguage);
	size_t	GetCount() const;
	wstring	GetDescription(size_t i) const throw(out_of_range);
	wstring	GetName(size_t i) const throw(out_of_range);
	bool	IsExecuting() const;
	bool	Load(const wchar_t* pwszFilePath) throw(EFailedToParseXml);
private:
	static void __cdecl	ScriptThreadProc(void* p);

	// f[^o
private:
	CAlphaApp&	m_app;
	wstring		m_strFilePath;
	bool		m_bExecuting;

	struct TMacroInfo {
		wstring	strName;
		wstring	strDescription;
		wstring	strScriptPath;
		wstring	strLanguage;
		UINT	nCodePage;
	};
	TMacroInfo**	m_ppMacros;
	size_t			m_cMacros;

	// NX
private:
	class CSAXReadHandler :
			public IUnknownImpl<NoRefCount>,
			virtual public ISAXContentHandler,
			virtual public ISAXErrorHandler {
		// \bh
	public:
		// IUnknown C^[tFCX
		IMPLEMENT_UNKNOWN()
		STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {
			VERIFY_POINTER(ppvObject);
			if(riid == IID_IUnknown || riid == __uuidof(ISAXContentHandler))
				*ppvObject = static_cast<ISAXContentHandler*>(this);
			else if(riid == __uuidof(ISAXErrorHandler))
				*ppvObject = static_cast<ISAXErrorHandler*>(this);
			else
				return (*ppvObject = 0), E_NOINTERFACE;
			reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();
			return S_OK;
		}
//		BEGIN_INTERFACE_TABLE()
//			IMPLEMENTS_LEFTMOST_INTERFACE(ISAXContentHandler)
//			IMPLEMENTS_INTERFACE(ISAXErrorHandler)
//		END_INTERFACE_TABLE()

		// ISAXContentHandler C^[tFCX
		STDMETHODIMP	putDocumentLocator(ISAXLocator* pLocator);
		STDMETHODIMP	startDocument();
		STDMETHODIMP	endDocument();
		STDMETHODIMP	startPrefixMapping(wchar_t* pwchPrefix,
							int cchPrefix, wchar_t* pwchUri, int cchUri);
		STDMETHODIMP	endPrefixMapping(wchar_t* pwchPrefix, int cchPrefix);
		STDMETHODIMP	startElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
							wchar_t* pwchLocalName, int cchLocalName,
							wchar_t* pwchQName, int cchQName, ISAXAttributes* pAttributes);
		STDMETHODIMP	endElement(wchar_t* pwchNamespaceUri, int cchNamespaceUri,
							wchar_t* pwchLocalName, int cchLocalName,
							wchar_t* pwchQName, int cchQName);
		STDMETHODIMP	characters(wchar_t* pwchChars, int cchChars);
		STDMETHODIMP	ignorableWhitespace(wchar_t* pwchChars, int cchChars);
		STDMETHODIMP	processingInstruction (wchar_t* pwchTarget, int cchTarget,
							wchar_t* pwchData, int cchData);
		STDMETHODIMP	skippedEntity(wchar_t* pwchName, int cchName);

		// ISAXErrorHandler C^[tFCX
		STDMETHODIMP	error(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	fatalError(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);
		STDMETHODIMP	ignorableWarning(ISAXLocator* pLocator, wchar_t* pwchErrorMessage, HRESULT hrErrorCode);

		// f[^o
	public:
		int						m_nReadingPhase;	// 0-plugin, 1-description, 2-script
		list<TMacroInfo>		m_listWork;
		CScriptMacroManager*	m_pThis;
	} m_oSAXHandler;

	friend class CSAXReadHandler;
};

inline bool CScriptMacroManager::IsExecuting() const {
	return m_bExecuting;
}

} /* namespace Alpha */

#endif /* _SCRIPT_MACRO_MANAGER_H_ */

/* [EOF] */