// SelectLanguageDlg.cpp
// (c) 2003-2004 exeal

#include "StdAfx.h"
#include "resource.h"
#include "SelectLanguageDlg.h"
#include "..\Armaiti\ComGeneric.h"	// CComPtr
using Alpha::CSelectLanguageDlg;


// CSelectLanguageDlg class implementation
/////////////////////////////////////////////////////////////////////////////

///	@see	CDialog::OnCommand
bool CSelectLanguageDlg::OnCommand(WORD wID, WORD wNotifyCode, HWND hwndCtrl) {
	if(wID == IDC_LIST_SCRIPTENGINES && wNotifyCode == LBN_DBLCLK) {
		OnOK();
		return true;
	}

	return CDialog::OnCommand(wID, wNotifyCode, hwndCtrl);
}

///	@see	CDialog::OnInitDialog
bool CSelectLanguageDlg::OnInitDialog(HWND hwndFocus, LPARAM lInitParam) {
	CDialog::OnInitDialog(hwndFocus, lInitParam);

	using Armaiti::CComPtr;

	CComPtr<ICatInformation>	pCatInfo;
	static const CATID			CATID_ActiveScript = {
		0xf0b7a1a1, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};
	static const CATID			CATID_ActiveScriptParse = {
		0xf0b7a1a2, 0x9847, 0x11cf, {0x8f, 0x20, 0x00, 0x80, 0x5f, 0x2c, 0xd0, 0x64}};

	// R|[lgJeS痘p\ȃXNvg񋓂
	if(SUCCEEDED(pCatInfo.CreateInstance(CLSID_StdComponentCategoriesMgr))) {
		CComPtr<IEnumCLSID>	pCLSIDEnumerator;
		CATID				arrImpls[1] = {CATID_ActiveScript};
		CATID				arrReqs[1] = {CATID_ActiveScriptParse};
		CLSID				clsid;
		OLECHAR*			pwszLanguageName;

		if(SUCCEEDED(pCatInfo->EnumClassesOfCategories(1, arrImpls, 1, arrReqs, &pCLSIDEnumerator))) {
			for(pCLSIDEnumerator->Reset(); pCLSIDEnumerator->Next(1, &clsid, 0) == S_OK; ) {
				if(SUCCEEDED(::ProgIDFromCLSID(clsid, &pwszLanguageName))) {
					SendDlgItemMessage(IDC_LIST_SCRIPTENGINES,
						LB_ADDSTRING, 0, reinterpret_cast<LPARAM>(pwszLanguageName));
					::CoTaskMemFree(pwszLanguageName);
				}
			}
		}
	}

	if(SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETCOUNT, 0, 0L) == 0)
		::EnableWindow(GetDlgItem(IDOK), false);
	else
		SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_SETCURSEL, 0, 0L);

	return true;
}

///	@see	CDialog::OnOK
void CSelectLanguageDlg::OnOK() {
	wchar_t*	pwszSelection = 0;
	int			iSelection = SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETCURSEL, 0, 0L);
	size_t		cchSelection = SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETTEXTLEN, iSelection, 0L);

	pwszSelection = new wchar_t[cchSelection + 1];
	SendDlgItemMessage(IDC_LIST_SCRIPTENGINES, LB_GETTEXT, iSelection, reinterpret_cast<LPARAM>(pwszSelection));
	m_strSelectedLanguage = pwszSelection;
	delete[] pwszSelection;

	CDialog::OnOK();
}

/* [EOF] */