// UnknownImpl.h
// (c) 2002-2004 exeal

#ifndef _UNKNOWN_IMPL_H_
#define _UNKNOWN_IMPL_H_

#include "ComGeneric.h"


namespace Armaiti {

// IUnknownImpl ̂߂3̃|V[NX
/////////////////////////////////////////////////////////////////////////////

/// QƃJEggpȂ
class NoRefCount {
public:
	NoRefCount() {}
	ULONG AddRef() {return 2;}
	ULONG Release() {return 1;}
private:
	NoRefCount(const NoRefCount&);
	operator =(NoRefCount&);
};

/// PȎQƃJEggp
class SingleThreadedRefCount {
public:
	SingleThreadedRefCount() : m_cRef(0) {}
	ULONG AddRef() {return ++m_cRef;}
	ULONG Release() {return --m_cRef;}
private:
	LONG	m_cRef;
	SingleThreadedRefCount(const SingleThreadedRefCount&);
	operator =(const SingleThreadedRefCount&);
};

/// QƃJEg̑XbhZ[t
class MultiThreadedRefCount {
public:
	MultiThreadedRefCount() : m_cRef(0) {}
	ULONG AddRef() {return ::InterlockedIncrement(&m_cRef);}
	ULONG Release() {return ::InterlockedDecrement(&m_cRef);}
private:
	LONG	m_cRef;
	MultiThreadedRefCount(const MultiThreadedRefCount&);
	operator =(const MultiThreadedRefCount&);
};


// IUnknownImpl class definitions and implementations
/////////////////////////////////////////////////////////////////////////////

/**
 *	IUnknown ̎
 *	@param RefCountPolicy	QƃJEgǗ|V[
 */
template<class RefCountPolicy>
class IUnknownImpl {
	// RXgN^
public:
	///	RXgN^
	IUnknownImpl() {/* do nothing */}
	///	fXgN^
	virtual ~IUnknownImpl() {/* do nothing */}
private:
	IUnknownImpl(const IUnknownImpl&);

	// Zq
private:
	operator =(const IUnknownImpl&);

	// f[^o
protected:
	RefCountPolicy	m_rc;
};

#define IMPLEMENT_UNKNOWN()				\
	STDMETHODIMP_(ULONG)	AddRef() {	\
		return m_rc.AddRef();			\
	}									\
	STDMETHODIMP_(ULONG)	Release() {	\
		LONG	cRef = m_rc.Release();	\
		if(cRef == 0)					\
			delete this;				\
		return cRef;					\
	}

#define BEGIN_INTERFACE_TABLE()										\
	STDMETHODIMP	QueryInterface(REFIID riid, void** ppvObject) {	\
		if(ppvObject == 0)											\
			return E_POINTER;

#define END_INTERFACE_TABLE()								\
		else												\
			return (*ppvObject = 0), E_NOINTERFACE;			\
		reinterpret_cast<IUnknown*>(*ppvObject)->AddRef();	\
		return S_OK;										\
	}

#define IMPLEMENTS_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName)				\
			*ppvObject = static_cast<InterfaceName*>(this);

#define IMPLEMENTS_LEFTMOST_INTERFACE(InterfaceName)					\
		else if(riid == IID_##InterfaceName || riid == IID_IUnknown)	\
			*ppvObject = static_cast<InterfaceName*>(this);


// ISupportErrorInfoImpl class definition and implementation
/////////////////////////////////////////////////////////////////////////////

/// ISupportErrorInfo ̕WIȎ
template<const IID* piid>
class ISupportErrorInfoImpl : public ISupportErrorInfo {
	STDMETHODIMP	InterfaceSupportsErrorInfo(REFIID riid) {
		return (riid == *piid) ? S_OK : S_FALSE;
	}
};

} // namespace Armaiti

#endif /* _UNKNOWN_IMPL_H_ */

/* [EOF] */