// ComboBox.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _COMBO_BOX_H_
#define _COMBO_BOX_H_

#include "Window.h"


// CComboBox class definition
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {
namespace Controls {

class CComboBox : public CWindow {

	// \bh
public:
	/* 쐬 */
	bool	Create(bool bSubClass, DWORD dwStyle, const LPRECT lpRect, HWND hwndParent, UINT nID);
	bool	CreateEx(bool bSubClass, DWORD dwExStyle, DWORD dwStyle, LPRECT lpRect, HWND hwndParent, UINT id);
	int		InitStorage(int nItems, UINT nBytes);

	/* ʓIȑ */
	int		GetCount() const;
	int		GetCurSel() const;
	int		SetCurSel(int nSelect);
	DWORD	GetEditSel() const;
	bool	SetEditSel(int nStartChar, int nEndChar);
	int		SetItemData(int nIndex, DWORD dwItemData);
	int		SetItemDataPtr(int nIndex, const void* pItemData);
	DWORD	GetItemData(int nIndex) const;
	void*	GetItemDataPtr(int nIndex) const;
	int		GetTopIndex() const;
	int		SetTopIndex(int nIndex);
	UINT	GetHorizontalExtent() const;
	void	SetHorizontalExtent(UINT nExtent);
	int		GetDroppedWidth() const;
	int		SetDroppedWidth(UINT nWidth);
	void	Clear();
	void	Copy();
	void	Cut();
	void	Paste();
	bool	LimitText(int nMaxChars);
	int		GetItemHeight(int nIndex) const;
	int		SetItemHeight(int nIndex, UINT cyItemHeight);
	int		GetLBText(int nIndex, TCHAR* lpszText) const;
	int		GetLBTextLen(int nIndex) const;
	void	ShowDropDown(bool bShow = true);
	void	GetDroppedControlRect(LPRECT lpRect) const;
	bool	GetDroppedState() const;
	bool	GetExtendedUI() const;
	int		SetExtendedUI(bool bExtended = true);
	LCID	GetLocale() const;
	LCID	SetLocale(LCID lcid);

	/* 񑀍 */
	int		AddString(const TCHAR* lpszText);
	int		DeleteString(UINT nIndex);
	int		InsertString(int nIndex, const TCHAR* lpszText);
	void	ResetContent();
	int		Dir(UINT nAttributes, const TCHAR* lpszFileSpec);
	int		FindString(int nStartAfter, const TCHAR* lpszText) const;
	int		FindStringExact(int nIndexStart, const TCHAR* lpszText) const;
	int		SelectString(int nStartAfter, const TCHAR* lpszText);

	// I[o[Ch
	bool	Attach(HWND hWnd, bool bSubClass = false);
protected:
	virtual LRESULT			DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK	WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
};


// CComboBox class implementation
/////////////////////////////////////////////////////////////////////////////

inline int CComboBox::AddString(const TCHAR* lpszText) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpszText)));
}

inline bool CComboBox::Attach(HWND hWnd, bool bSubClass /* = false */) {
	AssertValid();

	if(IsWindow() || !::IsWindow(hWnd) || m_OldProc != 0)
		return false;
	m_hWnd = hWnd;

	if(bSubClass) {
		m_OldProc = reinterpret_cast<WNDPROC>(
			SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(CComboBox::WndProc)));
		assert(m_OldProc != CComboBox::WndProc);
		m_lOldUserData = GetWindowLong(GWL_USERDATA);
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline void CComboBox::Clear() {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, WM_CLEAR, 0, 0L);
}

inline void CComboBox::Copy() {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, WM_COPY, 0, 0L);
}

inline bool CComboBox::Create(bool bSubClass, DWORD dwStyle, const LPRECT lpRect, HWND hwndParent, UINT nID) {
	AssertValid();

	m_hWnd = ::CreateWindow(_T("COMBOBOX"), _T("ComboBoxWindow"), dwStyle,
		lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(nID), reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(
			GWL_WNDPROC, reinterpret_cast<LPARAM>(CComboBox::WndProc)));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline bool CComboBox::CreateEx(bool bSubClass,
		DWORD dwExStyle, DWORD dwStyle, const LPRECT lpRect, HWND hwndParent, UINT nID) {
	AssertValid();

	m_hWnd = ::CreateWindowEx(dwExStyle, _T("COMBOBOX"), _T("ComboBoxWindow"), dwStyle,
		lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(nID),
		reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0);
	if(m_hWnd == 0)
		return false;
	if(bSubClass) {
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(
			GWL_WNDPROC, reinterpret_cast<LPARAM>(CComboBox::WndProc)));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline void CComboBox::Cut() {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, WM_CUT, 0, 0L);
}

inline int CComboBox::DeleteString(UINT nIndex) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_DELETESTRING, nIndex, 0L));
}

inline int CComboBox::Dir(UINT nAttributes, const TCHAR* lpszFileSpec) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_DIR, nAttributes, reinterpret_cast<LPARAM>(lpszFileSpec)));
}

inline LRESULT CComboBox::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	if(PreTranslateMessage(message, wParam, lParam))
		return false;
	return CWindow::DispatchEvent(message, wParam, lParam);
}

inline int CComboBox::FindString(int nStartAfter, const TCHAR* lpszText) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd,
		CB_FINDSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::FindStringExact(int nIndexStart, const TCHAR* lpszText) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd,
		CB_FINDSTRINGEXACT, nIndexStart, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::GetCount() const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0L));
}

inline int CComboBox::GetCurSel() const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0L));
}

inline void CComboBox::GetDroppedControlRect(LPRECT lpRect) const {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, CB_GETDROPPEDCONTROLRECT, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline bool CComboBox::GetDroppedState() const {
	AssertValidAsWindow();
	return (::SendMessage(m_hWnd, CB_GETDROPPEDSTATE, 0, 0L) != 0);
}

inline int CComboBox::GetDroppedWidth() const {
	AssertValidAsWindow();
	return (::SendMessage(m_hWnd, CB_GETDROPPEDWIDTH, 0, 0L) != 0);
}

inline DWORD CComboBox::GetEditSel() const {
	AssertValidAsWindow();

	WORD	wStart, wEnd;

	::SendMessage(m_hWnd, CB_GETEDITSEL, reinterpret_cast<WPARAM>(&wStart), reinterpret_cast<LPARAM>(&wEnd));
	return (wStart | (wEnd << 16));
}

inline bool CComboBox::GetExtendedUI() const {
	AssertValidAsWindow();
	return (::SendMessage(m_hWnd, CB_GETEXTENDEDUI, 0, 0L) != 0);
}

inline UINT CComboBox::GetHorizontalExtent() const {
	AssertValidAsWindow();
	return static_cast<UINT>(::SendMessage(m_hWnd, CB_GETHORIZONTALEXTENT, 0, 0L));
}

inline DWORD CComboBox::GetItemData(int nIndex) const {
	AssertValidAsWindow();
	return static_cast<DWORD>(::SendMessage(m_hWnd, CB_GETITEMDATA, nIndex, 0L));
}

inline void* CComboBox::GetItemDataPtr(int nIndex) const {
	AssertValidAsWindow();
	return reinterpret_cast<void*>(::SendMessage(m_hWnd, CB_GETITEMDATA, nIndex, 0L));
}

inline int CComboBox::GetItemHeight(int nIndex) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETITEMHEIGHT, nIndex, 0L));
}

inline int CComboBox::GetLBText(int nIndex, TCHAR* lpszText) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETLBTEXT, nIndex, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::GetLBTextLen(int nIndex) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETLBTEXTLEN, nIndex, 0L));
}

inline LCID CComboBox::GetLocale() const {
	AssertValidAsWindow();
	return static_cast<LCID>(::SendMessage(m_hWnd, CB_GETLOCALE, 0, 0L));
}

inline int CComboBox::GetTopIndex() const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_GETTOPINDEX, 0, 0L));
}

inline int CComboBox::InitStorage(int nItems, UINT nBytes) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_INITSTORAGE, nItems, nBytes));
}

inline int CComboBox::InsertString(int nIndex, const TCHAR* lpszText) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_INSERTSTRING, nIndex, reinterpret_cast<LPARAM>(lpszText)));
}

inline bool CComboBox::LimitText(int nMaxChars) {
	AssertValidAsWindow();
	return (::SendMessage(m_hWnd, CB_LIMITTEXT, nMaxChars, 0L) != 0);
}

inline void CComboBox::Paste() {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, WM_PASTE, 0, 0L);
}

inline void CComboBox::ResetContent() {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, CB_RESETCONTENT, 0, 0L);
}

inline int CComboBox::SelectString(int nStartAfter, const TCHAR* lpszText) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SELECTSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszText)));
}

inline int CComboBox::SetCurSel(int nSelect) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETCURSEL, nSelect, 0L));
}

inline int CComboBox::SetDroppedWidth(UINT nWidth) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETDROPPEDWIDTH, nWidth, 0L));
}

inline bool CComboBox::SetEditSel(int nStartChar, int nEndChar) {
	AssertValidAsWindow();
	return (::SendMessage(m_hWnd, CB_SETEDITSEL, nStartChar, nEndChar) != 0);
}

inline int CComboBox::SetExtendedUI(bool bExtended /* = true */) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETEXTENDEDUI, bExtended, 0L));
}

inline void CComboBox::SetHorizontalExtent(UINT nExtent) {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, CB_SETHORIZONTALEXTENT, nExtent, 0L);
}

inline int CComboBox::SetItemData(int nIndex, DWORD dwItemData) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETITEMDATA, nIndex, dwItemData));
}

inline int CComboBox::SetItemDataPtr(int nIndex, const void* pItemData) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETITEMDATA, nIndex, reinterpret_cast<LPARAM>(pItemData)));
}

inline int CComboBox::SetItemHeight(int nIndex, UINT cyItemHeight) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETITEMHEIGHT, nIndex, cyItemHeight));
}

inline LCID CComboBox::SetLocale(LCID lcid) {
	AssertValidAsWindow();
	return static_cast<LCID>(::SendMessage(m_hWnd, CB_SETLOCALE, lcid, 0L));
}

inline int CComboBox::SetTopIndex(int nIndex) {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, CB_SETTOPINDEX, nIndex, 0L));
}

inline void CComboBox::ShowDropDown(bool bShow /* = true */) {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, CB_SHOWDROPDOWN, bShow, 0L);
}

LRESULT CALLBACK CComboBox::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	CComboBox*	pComboBox = 0;

	if(message == WM_MATTACH) {
		pComboBox = reinterpret_cast<CComboBox*>(lParam);
		pComboBox->SetWindowLong(GWL_USERDATA, lParam);
		assert(hWnd == pComboBox->m_hWnd);
		return pComboBox->DispatchEvent(WM_MATTACH, 0, 0L);
	} else {
		pComboBox = reinterpret_cast<CComboBox*>(::GetWindowLong(hWnd, GWL_USERDATA));
		return (pComboBox != 0) ? pComboBox->DispatchEvent(message, wParam, lParam) : false;
	}
}

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _COMBO_BOX_H_ */

/* [EOF] */