// DC.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _DC_H_
#define _DC_H_

#include "Object.h"

namespace Manah {
namespace Windows {
namespace GDI {

// CMinimalDC class definition
/////////////////////////////////////////////////////////////////////////////

class CMinimalDC : public CObject {
	// f[^o
private:
	HDC	m_hDC;

	// RXgN^
public:
	CMinimalDC();
	virtual ~CMinimalDC();

	// \bh
public:
	/* 쐬 */
	virtual bool		CreateCompatibleDC(HDC hDC);
	virtual bool		DeleteDC();
	static CMinimalDC*	FromHandle(HDC hDC);
	bool				Attach(HDC hDC);
	HDC					Detach();
	HBITMAP				GetCurrentBitmap() const;
	HBRUSH				GetCurrentBrush() const;
	HFONT				GetCurrentFont() const;
	HPALETTE			GetCurrentPalette() const;
	HPEN				GetCurrentPen() const;
	HWND				GetWindow() const;

	/* foCXReLXg */
	HDC				GetSafeHdc() const;
	virtual int		SaveDC();
	virtual bool	RestoreDC(int nSavedDC);
	int				GetDeviceCaps(int iIndex) const;

	/* `c[ */
	POINT	GetBrushOrg() const;
	POINT	SetBrushOrg(int x, int y);
	POINT	SetBrushOrg(POINT pt);
	int		EnumObjects(int nObjectType, GOBJENUMPROC lpObjectFunc, LPARAM lpData);

	/* I */
	HBITMAP			SelectObject(HBITMAP hBitmap);
	HBRUSH			SelectObject(HBRUSH hBrush);
	virtual HFONT	SelectObject(HFONT hFont);
	HPEN			SelectObject(HPEN hPen);
	HGDIOBJ			SelectStockObject(int nObject);

	/* Fƃpbg */
	COLORREF	GetNearestColor(COLORREF clr) const;
	HPALETTE	SelectPalette(HPALETTE hPalette, bool bForceBackground);
	UINT		RealizePalette();
	void		UpdateColors();

	/*  */
	COLORREF	GetBkColor() const;
	COLORREF	SetBkColor(COLORREF clr);
	int			GetBkMode() const;
	int			SetBkMode(int nBkMode);
	int			GetPolyFillMode() const;
	int			SetPolyFillMode(int nPolyFillMode);
	int			GetROP2() const;
	int			SetROP2(int nDrawMode);
	int			GetStretchBltMode() const;
	int			SetStretchBltMode(int nStretchMode);
	COLORREF	GetTextColor() const;
	COLORREF	SetTextColor(COLORREF clr);
	bool		GetColorAdjustment(LPCOLORADJUSTMENT lpColorAdjust) const;
	bool		SetColorAdjustment(const LPCOLORADJUSTMENT lpColorAdjust);

	/* ̈ */
	bool	FillRgn(HRGN hRgn, HBRUSH hBrush);
	bool	FrameRgn(HRGN hRgn, HBRUSH hBrush, int nWidth, int nHeight);
	bool	InvertRgn(HRGN hRgn);
	bool	PaintRgn(HRGN hRgn);

	/* o */
	POINT	GetCurrentPosition() const;
	POINT	MoveTo(int x, int y);
	POINT	MoveTo(POINT pt);
	bool	LineTo(int x, int y);
	bool	LineTo(POINT pt);
	bool	Arc(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	bool	Arc(LPRECT lpRect, POINT ptStart, POINT ptEnd);
	bool	ArcTo(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	bool	ArcTo(LPRECT lpRect, POINT ptStart, POINT ptEnd);
	bool	AngleArc(int x, int y, int nRadius, float fStartAngle, float fSweepAngle);
	int		GetArcDirection() const;
	int		SetArcDirection(int nArcDirection);
	bool	PolyDraw(const POINT* lpPoints, const BYTE* lpTypes, int nCount);
	bool	Polyline(LPPOINT lpPoints, int nCount);
	bool	PolyPolyline(const POINT* lpPoints, const DWORD* lpPolyPoints, int nCount);
	bool	PolylineTo(const POINT* lpPoints, int nCount);
	bool	PolyBezier(const POINT* lpPoints, int nCount);
	bool	PolyBezierTo(const POINT* lpPoints, int nCount);

	/* P` */
	void	FillRect(const RECT* lpRect, HBRUSH hBrush);
	void	FrameRect(const RECT* lpRect, HBRUSH hBrush);
	void	InvertRect(const RECT* lpRect);
	bool	DrawIcon(int x, int y, HICON hIcon);
	bool	DrawIcon(POINT pt, HICON hIcon);
//	void	DrawDragIcon(const RECT* lpRect, SIZE size,
//				const RECT* lpRectLast, SIZE sizeLast, HBRUSH hBrush, HBRUSH hLastBrush);
	void	FillSolidRect(const RECT* lpRect, COLORREF clr);
	void	FillSolidRect(int x, int y, int cx, int cy, COLORREF clr);
//	void	Draw3dRect(const RECT* lpRect, COLORREF clrTopLeft, COLORREF clrRightBottom);
//	void	Draw3dRect(int x, int y, int cx, int cy, COLORREF clrTopLeft, COLORREF clrRightBottom);
	bool	DrawEdge(RECT* lpRect, UINT nEdge, UINT grfFlags);
	bool	DrawFrameControl(RECT* lpRect, UINT nType, UINT nState);

	/* ȉ~Ƒp` */
	bool	Chord(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	bool	Chord(const RECT* lpRect, POINT ptStart, POINT ptEnd);
	void	DrawFocusRect(const RECT* lpRect);
	bool	Ellipse(int x1, int y1, int x2, int y2);
	bool	Ellipse(const RECT* lpRect);
	bool	Pie(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4);
	bool	Pie(const RECT* lpRect, POINT ptStart, POINT ptEnd);
	bool	Polygon(const POINT* lpPoints, int nCount);
	bool	PolyPolygon(const POINT* lpPoints, const int* lpPolyCounts, int nCount);
	bool	Rectangle(int x1, int y1, int x2, int y2);
	bool	Rectangle(const RECT* lpRect);
	bool	RoundRect(int x1, int y1, int x2, int y2, int x3, int y3);
	bool	RoundRect(const RECT* lpRect, POINT pt);

	/* rbg}bv */
	bool		PatBlt(int x, int y, int nWidth, int nHeight, DWORD dwRop);
	bool		BitBlt(int x, int y, int nWidth, int nHeight, HDC hSrcDC, int xSrc, int ySrc, DWORD dwRop);
	bool		StretchBlt(int x, int y, int nWidth, int nHeight,
					HDC hSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop);
	COLORREF	GetPixel(int x, int y) const;
	COLORREF	GetPixel(POINT pt) const;
	COLORREF	SetPixel(int x, int y, COLORREF clr);
	COLORREF	SetPixel(POINT pt, COLORREF clr);
	bool		SetPixelV(int x, int y, COLORREF clr);
	bool		SetPixelV(POINT pt, COLORREF clr);
	bool		FloodFill(int x, int y, COLORREF clr);
	bool		ExtFloodFill(int x, int y, COLORREF clr, UINT nFillType);
	bool		MaskBlt(int x, int y, int nWidth, int nHeight,
					HDC hDC, int xSrc, int ySrc, HBITMAP hBitmap, int xMask, int yMask, DWORD dwRop);
	bool		PlgBlt(const POINT* lpPoint, HDC hDC,
					int xSrc, int ySrc, int nWidth, int nHeight, HBITMAP hBitmap, int xMask, int yMask);

	/* eLXg */
	virtual bool	TextOut(int x, int y, const TCHAR* lpszText, int cchText);
	virtual bool	ExtTextOut(int x, int y, UINT nOptions, const RECT* lpRect,
						const TCHAR* lpszText, UINT cchText, const int* lpDxWidths);
	virtual SIZE	TabbedTextOut(int x, int y, const TCHAR* lpszText,
						int cchText, int nTabPositions, int* lpnTabStopPositions, int nTabOrigin);
	virtual int		DrawText(const TCHAR* lpszText, int cchText, RECT* lpRect, UINT nFormat);
	SIZE			GetTextExtent(const TCHAR* lpszText, int cchText) const;
	bool			GetTextExtentPointI(LPWORD pgiln, int cgi, LPSIZE lpSize) const;
	bool			GetTextExtentExPoint(const TCHAR* pgiln, int cgi,
						int nMaxExtent, LPINT lpnFit, LPINT alpDx, LPSIZE lpSize) const;
	bool			GetTextExtentExPointI(LPWORD pgiln, int cgi,
						int nMaxExtent, LPINT lpnFit, LPINT alpDx, LPSIZE lpSize) const;
	SIZE			GetTabbedTextExtent(const TCHAR* lpszText,
						int cchText, int nTabPositions, int* lpnTabStopPositions) const;
	SIZE			GetCharacterPlacement(const TCHAR* lpszText, int nCount,
						int nMaxExtent, LPGCP_RESULTS lpResults, DWORD dwFlags) const;
	virtual bool	GrayString(HBRUSH hBrush, GRAYSTRINGPROC lpfnOutput,
						LPARAM lpData, int cchText, int x, int y, int nWidth, int nHeight);
	UINT			GetTextAlign() const;
	UINT			SetTextAlign(UINT nFlags);
	int				GetTextFace(int cchFaceName, TCHAR* lpszFaceName) const;
	bool			GetTextMetrics(LPTEXTMETRIC lpMetrics) const;
	int				SetTextJustification(int nBreakExtra, int nBreakCount);
	int				GetTextCharacterExtra() const;
	int				SetTextCharacterExtra(int nCharExtra);

	/* tHg */
	DWORD			GetFontData(DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const;
	DWORD			GetFontLanguageInfo() const;
	DWORD			GetFontUnicodeRanges(LPGLYPHSET lpGlyphset) const;	// Windows 2000/XP only
	DWORD			GetKerningPairs(DWORD dwPairs, LPKERNINGPAIR lpkrnpair) const;
	UINT			GetOutlineTextMetrics(UINT cbData, LPOUTLINETEXTMETRIC lpotm) const;
	DWORD			GetGlyphOutline(UINT nChar, UINT nFormat,
						LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpData, const MAT2* lpmat2) const;
	bool			GetCharABCWidths(UINT nFirstChar, UINT nLastChar, LPABC lpabc) const;
	bool			GetCharABCWidths(UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpabcf) const;
	bool			GetCharWidth(UINT nFirstChar, UINT nLastChar, int* lpBuffer) const;
	bool			GetCharWidth(UINT nFirstChar, UINT nLastChar, float* lpBuffer) const;
	DWORD			SetMapperFlags(DWORD dwFlag);

	/* XN[ */
	bool			ScrollDC(int dx, int dy,
						const RECT* lpScrollRect, const RECT* lpClipRect, HRGN hUpdateRgn, RECT* lpUpdateRect);

	/* \ */
	void			AssertValidAsDC() const;
};


// CDC class definition
/////////////////////////////////////////////////////////////////////////////

class CDC : public CMinimalDC {
};


// CMinimalDC class implementation
/////////////////////////////////////////////////////////////////////////////

inline CMinimalDC::CMinimalDC() : m_hDC(0) {
}

inline CMinimalDC::~CMinimalDC() {
	if(m_hDC != 0)
		::DeleteDC(Detach());
}

inline bool CMinimalDC::AngleArc(int x, int y, int nRadius, float fStartAngle, float fSweepAngle) {
	AssertValid();
	assert(m_hDC != 0);
	return toBoolean(::AngleArc(m_hDC, x, y, nRadius, fStartAngle, fSweepAngle));
}

inline bool CMinimalDC::Arc(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
	AssertValid();
	assert(m_hDC != 0);
	return toBoolean(::Arc(m_hDC, x1, y1, x2, y2, x3, y3, x4, y4));
}

inline bool CMinimalDC::Arc(LPRECT lpRect, POINT ptStart, POINT ptEnd) {
	AssertValid();
	assert(m_hDC != 0);
	return toBoolean(::Arc(m_hDC, lpRect->left, lpRect->top,
		lpRect->right, lpRect->bottom, ptStart.x, ptStart.y, ptEnd.x, ptEnd.y));
}

inline bool CMinimalDC::ArcTo(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
	AssertValid();
	assert(m_hDC != 0);
	return toBoolean(::ArcTo(m_hDC, x1, y1, x2, y2, x3, y3, x4, y4));
}

inline bool CMinimalDC::ArcTo(LPRECT lpRect, POINT ptStart, POINT ptEnd) {
	AssertValid();
	assert(m_hDC != 0);
	return toBoolean(::ArcTo(m_hDC, lpRect->left, lpRect->top,
		lpRect->right, lpRect->bottom, ptStart.x, ptStart.y, ptEnd.x, ptEnd.y));
}

inline void CMinimalDC::AssertValidAsDC() const {
	AssertValid();
	assert(m_hDC != 0);
}

inline bool CMinimalDC::Attach(HDC hDC) {
	AssertValid();
	assert(m_hDC == 0);

	if(hDC == 0)
		return false;
	m_hDC = hDC;
	return true;
}

inline bool CMinimalDC::BitBlt(int x, int y, int nWidth, int nHeight, HDC hSrcDC, int xSrc, int ySrc, DWORD dwRop) {
	AssertValidAsDC();
	return toBoolean(::BitBlt(m_hDC, x, y, nWidth, nHeight, hSrcDC, xSrc, ySrc, dwRop));
}

inline bool CMinimalDC::Chord(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
	AssertValidAsDC();
	return toBoolean(::Chord(m_hDC, x1, y1, x2, y2, x3, y3, x4, y4));
}

inline bool CMinimalDC::Chord(const RECT* lpRect, POINT ptStart, POINT ptEnd) {
	AssertValidAsDC();
	return toBoolean(::Chord(m_hDC, lpRect->left, lpRect->top,
		lpRect->right, lpRect->bottom, ptStart.x, ptStart.y, ptEnd.x, ptEnd.y));
}

inline bool CMinimalDC::CreateCompatibleDC(HDC hDC) {
	AssertValid();
	assert(m_hDC == 0);

	m_hDC = ::CreateCompatibleDC(hDC);
	return m_hDC != 0;
}

inline bool CMinimalDC::DeleteDC() {
	AssertValid();

	if(m_hDC == 0)
		return false;
	return toBoolean(::DeleteDC(Detach()));
}

inline HDC CMinimalDC::Detach() {
	AssertValid();

	HDC	hDC = m_hDC;

	m_hDC = 0;
	return hDC;
}

inline bool CMinimalDC::DrawEdge(RECT* lpRect, UINT nEdge, UINT grfFlags) {
	AssertValidAsDC();
	return toBoolean(::DrawEdge(m_hDC, lpRect, nEdge, grfFlags));
}

inline void CMinimalDC::DrawFocusRect(const RECT* lpRect) {
	AssertValidAsDC();
	::DrawFocusRect(m_hDC, lpRect);
}

inline bool CMinimalDC::DrawFrameControl(RECT* lpRect, UINT nType, UINT nState) {
	AssertValidAsDC();
	return toBoolean(::DrawFrameControl(m_hDC, lpRect, nType, nState));
}

inline bool CMinimalDC::DrawIcon(int x, int y, HICON hIcon) {
	AssertValidAsDC();
	return toBoolean(::DrawIcon(m_hDC, x, y, hIcon));
}

inline bool CMinimalDC::DrawIcon(POINT pt, HICON hIcon) {
	AssertValidAsDC();
	return toBoolean(::DrawIcon(m_hDC, pt.x, pt.y, hIcon));
}

inline int CMinimalDC::DrawText(const TCHAR* lpszText, int cchText, RECT* lpRect, UINT nFormat) {
	AssertValidAsDC();
	return ::DrawText(m_hDC, lpszText, cchText, lpRect, nFormat);
}

inline bool CMinimalDC::Ellipse(int x1, int y1, int x2, int y2) {
	AssertValidAsDC();
	return toBoolean(::Ellipse(m_hDC, x1, y1, x2, y2));
}

inline bool CMinimalDC::Ellipse(const RECT* lpRect) {
	AssertValidAsDC();
	return toBoolean(::Ellipse(m_hDC, lpRect->left, lpRect->top, lpRect->right, lpRect->bottom));
}

inline int CMinimalDC::EnumObjects(int nObjectType, GOBJENUMPROC lpObjectFunc, LPARAM lpData) {
	AssertValidAsDC();
	return ::EnumObjects(m_hDC, nObjectType, lpObjectFunc, lpData);
}

inline bool CMinimalDC::ExtFloodFill(int x, int y, COLORREF clr, UINT nFillType) {
	AssertValidAsDC();
	return toBoolean(::ExtFloodFill(m_hDC, x, y, clr, nFillType));
}

inline bool CMinimalDC::ExtTextOut(int x, int y, UINT nOptions,
		const RECT* lpRect, const TCHAR* lpszText, UINT cchText, const int* lpDxWidths) {
	AssertValidAsDC();
	return toBoolean(::ExtTextOut(m_hDC, x, y, nOptions, lpRect, lpszText, cchText, lpDxWidths));
}

inline bool CMinimalDC::FillRgn(HRGN hRgn, HBRUSH hBrush) {
	AssertValidAsDC();
	return toBoolean(::FillRgn(m_hDC, hRgn, hBrush));
}

inline void CMinimalDC::FillSolidRect(const RECT* lpRect, COLORREF clr) {
	AssertValidAsDC();

	COLORREF	clrOrg = GetBkColor();

	SetBkColor(clr);
	ExtTextOut(0, 0, ETO_OPAQUE, lpRect, _T(""), 0, 0);
	SetBkColor(clrOrg);
}

inline void CMinimalDC::FillSolidRect(int x, int y, int cx, int cy, COLORREF clr) {
	AssertValidAsDC();
	
	COLORREF	clrOrg = GetBkColor();
	RECT		rect;

	::SetRect(&rect, x, y, x + cx, y + cy);
	SetBkColor(clr);
	ExtTextOut(0, 0, ETO_OPAQUE, &rect, _T(""), 0, 0);
	SetBkColor(clrOrg);
}

inline bool CMinimalDC::FloodFill(int x, int y, COLORREF clr) {
	AssertValidAsDC();
	return toBoolean(::FloodFill(m_hDC, x, y, clr));
}

inline bool CMinimalDC::FrameRgn(HRGN hRgn, HBRUSH hBrush, int nWidth, int nHeight) {
	AssertValidAsDC();
	return toBoolean(::FrameRgn(m_hDC, hRgn, hBrush, nWidth, nHeight));
}

inline CMinimalDC* CMinimalDC::FromHandle(HDC hDC) {
	static CMinimalDC	oDC;

	oDC.m_hDC = hDC;
	return &oDC;
}

inline int CMinimalDC::GetArcDirection() const {
	AssertValidAsDC();
	return ::GetArcDirection(m_hDC);
}

inline void CMinimalDC::FillRect(const RECT* lpRect, HBRUSH hBrush) {
	AssertValidAsDC();
	::FillRect(m_hDC, lpRect, hBrush);
}

inline void CMinimalDC::FrameRect(const RECT* lpRect, HBRUSH hBrush) {
	AssertValidAsDC();
	::FrameRect(m_hDC, lpRect, hBrush);
}

inline COLORREF CMinimalDC::GetBkColor() const {
	AssertValidAsDC();
	return ::GetBkColor(m_hDC);
}

inline int CMinimalDC::GetBkMode() const {
	AssertValidAsDC();
	return ::GetBkMode(m_hDC);
}

inline POINT CMinimalDC::GetBrushOrg() const {
	AssertValidAsDC();

	POINT	pt;
	::GetBrushOrgEx(m_hDC, &pt);
	return pt;
}

inline SIZE CMinimalDC::GetCharacterPlacement(const TCHAR* lpszText,
		int nCount, int nMaxExtent, LPGCP_RESULTS lpResults, DWORD dwFlags) const {
	AssertValidAsDC();
	DWORD	dw = ::GetCharacterPlacement(m_hDC, lpszText, nCount, nMaxExtent, lpResults, dwFlags);
	SIZE	size = {LOWORD(dw), HIWORD(dw)};
	return size;
}

inline bool CMinimalDC::GetCharABCWidths(UINT nFirstChar, UINT nLastChar, LPABC lpabc) const {
	AssertValidAsDC();
	return toBoolean(::GetCharABCWidths(m_hDC, nFirstChar, nLastChar, lpabc));
}

inline bool CMinimalDC::GetCharABCWidths(UINT nFirstChar, UINT nLastChar, LPABCFLOAT lpabcf) const {
	AssertValidAsDC();
	return toBoolean(::GetCharABCWidthsFloat(m_hDC, nFirstChar, nLastChar, lpabcf));
}

inline bool CMinimalDC::GetCharWidth(UINT nFirstChar, UINT nLastChar, int* lpBuffer) const {
	AssertValidAsDC();
	return toBoolean(::GetCharWidth32(m_hDC, nFirstChar, nLastChar, lpBuffer));
}

inline bool CMinimalDC::GetCharWidth(UINT nFirstChar, UINT nLastChar, float* lpBuffer) const {
	AssertValidAsDC();
	return toBoolean(::GetCharWidthFloat(m_hDC, nFirstChar, nLastChar, lpBuffer));
}

inline bool CMinimalDC::GetColorAdjustment(LPCOLORADJUSTMENT lpColorAdjust) const {
	AssertValidAsDC();
	return toBoolean(::GetColorAdjustment(m_hDC, lpColorAdjust));
}

inline HBITMAP CMinimalDC::GetCurrentBitmap() const {
	AssertValidAsDC();
	return reinterpret_cast<HBITMAP>(::GetCurrentObject(m_hDC, OBJ_BITMAP));
}

inline HBRUSH CMinimalDC::GetCurrentBrush() const {
	AssertValidAsDC();
	return reinterpret_cast<HBRUSH>(::GetCurrentObject(m_hDC, OBJ_BRUSH));
}

inline HFONT CMinimalDC::GetCurrentFont() const {
	AssertValidAsDC();
	return reinterpret_cast<HFONT>(::GetCurrentObject(m_hDC, OBJ_FONT));
}

inline HPALETTE CMinimalDC::GetCurrentPalette() const {
	AssertValidAsDC();
	return reinterpret_cast<HPALETTE>(::GetCurrentObject(m_hDC, OBJ_PAL));
}

inline HPEN CMinimalDC::GetCurrentPen() const {
	AssertValidAsDC();
	return reinterpret_cast<HPEN>(::GetCurrentObject(m_hDC, OBJ_PEN));
}

inline POINT CMinimalDC::GetCurrentPosition() const {
	AssertValidAsDC();

	POINT	pt;
	::GetCurrentPositionEx(m_hDC, &pt);
	return pt;
}

inline int CMinimalDC::GetDeviceCaps(int iIndex) const {
	AssertValidAsDC();
	return ::GetDeviceCaps(m_hDC, iIndex);
}

inline DWORD CMinimalDC::GetFontData(DWORD dwTable, DWORD dwOffset, LPVOID lpData, DWORD cbData) const {
	AssertValidAsDC();
	return ::GetFontData(m_hDC, dwTable, dwOffset, lpData, cbData);
}

inline DWORD CMinimalDC::GetFontLanguageInfo() const {
	AssertValidAsDC();
	return ::GetFontLanguageInfo(m_hDC);
}

inline DWORD CMinimalDC::GetFontUnicodeRanges(LPGLYPHSET lpGlyphset) const {
	AssertValidAsDC();
	return ::GetFontUnicodeRanges(m_hDC, lpGlyphset);
}

inline DWORD CMinimalDC::GetGlyphOutline(UINT nChar, UINT nFormat,
		LPGLYPHMETRICS lpgm, DWORD cbBuffer, LPVOID lpData, const MAT2* lpmat2) const {
	AssertValidAsDC();
	return ::GetGlyphOutline(m_hDC, nChar, nFormat, lpgm, cbBuffer, lpData, lpmat2);
}

inline DWORD CMinimalDC::GetKerningPairs(DWORD dwPairs, LPKERNINGPAIR lpkrnpair) const {
	AssertValidAsDC();
	return ::GetKerningPairs(m_hDC, dwPairs, lpkrnpair);
}

inline COLORREF CMinimalDC::GetNearestColor(COLORREF clr) const {
	AssertValidAsDC();
	return ::GetNearestColor(m_hDC, clr);
}

inline UINT CMinimalDC::GetOutlineTextMetrics(UINT cbData, LPOUTLINETEXTMETRIC lpotm) const {
	AssertValidAsDC();
	return ::GetOutlineTextMetrics(m_hDC, cbData, lpotm);
}

inline COLORREF CMinimalDC::GetPixel(int x, int y) const {
	AssertValidAsDC();
	return ::GetPixel(m_hDC, x, y);
}

inline COLORREF CMinimalDC::GetPixel(POINT pt) const {
	AssertValidAsDC();
	return ::GetPixel(m_hDC, pt.x, pt.y);
}

inline int CMinimalDC::GetPolyFillMode() const {
	AssertValidAsDC();
	return ::GetPolyFillMode(m_hDC);
}

inline int CMinimalDC::GetROP2() const {
	AssertValidAsDC();
	return ::GetROP2(m_hDC);
}

inline HDC CMinimalDC::GetSafeHdc() const {
	return (this == 0) ? 0 : m_hDC;
}

inline int CMinimalDC::GetStretchBltMode() const {
	AssertValidAsDC();
	return ::GetStretchBltMode(m_hDC);
}

inline SIZE CMinimalDC::GetTabbedTextExtent(const TCHAR* lpszText,
		int cchText, int nTabPositions, int* lpnTabStopPositions) const {
	AssertValidAsDC();

	SIZE	size;
	DWORD	dw = ::GetTabbedTextExtent(m_hDC, lpszText, cchText, nTabPositions, lpnTabStopPositions);

	size.cx = LOWORD(dw);
	size.cy = HIWORD(dw);
	return size;
}

inline UINT CMinimalDC::GetTextAlign() const {
	AssertValidAsDC();
	return ::GetTextAlign(m_hDC);
}

inline int CMinimalDC::GetTextCharacterExtra() const {
	AssertValidAsDC();
	return ::GetTextCharacterExtra(m_hDC);
}

inline COLORREF CMinimalDC::GetTextColor() const {
	AssertValidAsDC();
	return ::GetTextColor(m_hDC);
}

inline SIZE CMinimalDC::GetTextExtent(const TCHAR* lpszText, int cchText) const {
	AssertValidAsDC();

	SIZE	size;

	::GetTextExtentPoint32(m_hDC, lpszText, cchText, &size);
	return size;
}

inline bool CMinimalDC::GetTextExtentExPoint(const TCHAR* pgiln,
		int cgi, int nMaxExtent, LPINT lpnFit, LPINT alpDx, LPSIZE lpSize) const {
	AssertValidAsDC();
	return toBoolean(::GetTextExtentExPoint(m_hDC, pgiln, cgi, nMaxExtent, lpnFit, alpDx, lpSize));
}

inline bool CMinimalDC::GetTextExtentExPointI(LPWORD pgiln,
		int cgi, int nMaxExtent, LPINT lpnFit, LPINT alpDx, LPSIZE lpSize) const {
	AssertValidAsDC();
	return toBoolean(::GetTextExtentExPointI(m_hDC, pgiln, cgi, nMaxExtent, lpnFit, alpDx, lpSize));
}

inline bool CMinimalDC::GetTextExtentPointI(LPWORD pgiln, int cgi, LPSIZE lpSize) const {
	AssertValidAsDC();
	return toBoolean(::GetTextExtentPointI(m_hDC, pgiln, cgi, lpSize));
}

inline int CMinimalDC::GetTextFace(int cchFaceName, TCHAR* lpszFaceName) const {
	AssertValidAsDC();
	return ::GetTextFace(m_hDC, cchFaceName, lpszFaceName);
}

inline bool CMinimalDC::GetTextMetrics(LPTEXTMETRIC lpMetrics) const {
	AssertValidAsDC();
	return toBoolean(::GetTextMetrics(m_hDC, lpMetrics));
}

inline HWND CMinimalDC::GetWindow() const {
	AssertValidAsDC();
	return ::WindowFromDC(m_hDC);
}

inline bool CMinimalDC::GrayString(HBRUSH hBrush,
		GRAYSTRINGPROC lpfnOutput, LPARAM lpData, int cchText, int x, int y, int nWidth, int nHeight) {
	AssertValidAsDC();
	return toBoolean(::GrayString(m_hDC, hBrush, lpfnOutput, lpData, cchText, x, y, nWidth, nHeight));
}

inline void CMinimalDC::InvertRect(const RECT* lpRect) {
	AssertValidAsDC();
	::InvertRect(m_hDC, lpRect);
}

inline bool CMinimalDC::InvertRgn(HRGN hRgn) {
	AssertValidAsDC();
	return toBoolean(::InvertRgn(m_hDC, hRgn));
}

inline bool CMinimalDC::LineTo(int x, int y) {
	AssertValidAsDC();
	return toBoolean(::LineTo(m_hDC, x, y));
}

inline bool CMinimalDC::LineTo(POINT pt) {
	AssertValidAsDC();
	return toBoolean(::LineTo(m_hDC, pt.x, pt.y));
}

inline bool CMinimalDC::MaskBlt(int x, int y, int nWidth, int nHeight,
		HDC hDC, int xSrc, int ySrc, HBITMAP hBitmap, int xMask, int yMask, DWORD dwRop) {
	AssertValidAsDC();
	return toBoolean(::MaskBlt(m_hDC, x, y, nWidth, nHeight, hDC, xSrc, ySrc, hBitmap, xMask, yMask, dwRop));
}

inline POINT CMinimalDC::MoveTo(int x, int y) {
	AssertValidAsDC();

	POINT	pt;
	::MoveToEx(m_hDC, x, y, &pt);
	return pt;
}

inline POINT CMinimalDC::MoveTo(POINT pt) {
	AssertValidAsDC();

	POINT	pt_;
	::MoveToEx(m_hDC, pt.x, pt.y, &pt_);
	return pt_;
}

inline bool CMinimalDC::PaintRgn(HRGN hRgn) {
	AssertValidAsDC();
	return toBoolean(::PaintRgn(m_hDC, hRgn));
}

inline bool CMinimalDC::PatBlt(int x, int y, int nWidth, int nHeight, DWORD dwRop) {
	AssertValidAsDC();
	return toBoolean(::PatBlt(m_hDC, x, y, nWidth, nHeight, dwRop));
}

inline bool CMinimalDC::Pie(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
	AssertValidAsDC();
	return toBoolean(::Pie(m_hDC, x1, y1, x2, y2, x3, y3, x4, y4));
}

inline bool CMinimalDC::Pie(const RECT* lpRect, POINT ptStart, POINT ptEnd) {
	AssertValidAsDC();
	return toBoolean(::Pie(m_hDC, lpRect->left, lpRect->top,
		lpRect->right, lpRect->bottom, ptStart.x, ptStart.y, ptEnd.x, ptEnd.y));
}

inline bool CMinimalDC::PlgBlt(const POINT* lpPoint, HDC hDC,
		int xSrc, int ySrc, int nWidth, int nHeight, HBITMAP hBitmap, int xMask, int yMask) {
	AssertValidAsDC();
	return toBoolean(::PlgBlt(m_hDC, lpPoint, hDC, xSrc, ySrc, nWidth, nHeight, hBitmap, xMask, yMask));
}

inline bool CMinimalDC::PolyBezier(const POINT* lpPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolyBezier(m_hDC, lpPoints, nCount));
}

inline bool CMinimalDC::PolyBezierTo(const POINT* lpPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolyBezierTo(m_hDC, lpPoints, nCount));
}

inline bool CMinimalDC::PolyDraw(const POINT* lpPoints, const BYTE* lpTypes, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolyDraw(m_hDC, lpPoints, lpTypes, nCount));
}

inline bool CMinimalDC::Polygon(const POINT* lpPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::Polygon(m_hDC, lpPoints, nCount));
}

inline bool CMinimalDC::Polyline(LPPOINT lpPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::Polyline(m_hDC, lpPoints, nCount));
}

inline bool CMinimalDC::PolylineTo(const POINT* lpPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolylineTo(m_hDC, lpPoints, nCount));
}

inline bool CMinimalDC::PolyPolygon(const POINT* lpPoints, const int* lpPolyCounts, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolyPolygon(m_hDC, lpPoints, lpPolyCounts, nCount));
}

inline bool CMinimalDC::PolyPolyline(const POINT* lpPoints, const DWORD *lpPolyPoints, int nCount) {
	AssertValidAsDC();
	return toBoolean(::PolyPolyline(m_hDC, lpPoints, lpPolyPoints, nCount));
}

inline UINT CMinimalDC::RealizePalette() {
	AssertValidAsDC();
	return ::RealizePalette(m_hDC);
}

inline bool CMinimalDC::Rectangle(int x1, int y1, int x2, int y2) {
	AssertValidAsDC();
	return toBoolean(::Rectangle(m_hDC, x1, y1, x2, y2));
}

inline bool CMinimalDC::Rectangle(const RECT* lpRect) {
	AssertValidAsDC();
	return toBoolean(::Rectangle(m_hDC, lpRect->left, lpRect->top, lpRect->right, lpRect->bottom));
}

inline bool CMinimalDC::RestoreDC(int nSavedDC) {
	AssertValidAsDC();
	return toBoolean(::RestoreDC(m_hDC, nSavedDC));
}

inline bool CMinimalDC::RoundRect(int x1, int y1, int x2, int y2, int x3, int y3) {
	AssertValidAsDC();
	return toBoolean(::RoundRect(m_hDC, x1, y1, x2, y2, x3, y3));
}

inline bool CMinimalDC::RoundRect(const RECT* lpRect, POINT pt) {
	AssertValidAsDC();
	return toBoolean(::RoundRect(m_hDC, lpRect->left, lpRect->top, lpRect->right, lpRect->bottom, pt.x, pt.y));
}

inline int CMinimalDC::SaveDC() {
	AssertValidAsDC();
	return ::SaveDC(m_hDC);
}

inline bool CMinimalDC::ScrollDC(int dx, int dy,
		const RECT* lpScrollRect, const RECT* lpClipRect, HRGN hUpdateRgn, RECT* lpUpdateRect) {
	AssertValidAsDC();
	return toBoolean(::ScrollDC(m_hDC, dx, dy, lpScrollRect, lpClipRect, hUpdateRgn, lpUpdateRect));
}

inline HBITMAP CMinimalDC::SelectObject(HBITMAP hBitmap) {
	AssertValidAsDC();
	return reinterpret_cast<HBITMAP>(::SelectObject(m_hDC, hBitmap));
}

inline HBRUSH CMinimalDC::SelectObject(HBRUSH hBrush) {
	AssertValidAsDC();
	return reinterpret_cast<HBRUSH>(::SelectObject(m_hDC, hBrush));
}

inline HFONT CMinimalDC::SelectObject(HFONT hFont) {
	AssertValidAsDC();
	return reinterpret_cast<HFONT>(::SelectObject(m_hDC, hFont));
}

inline HPEN CMinimalDC::SelectObject(HPEN hPen) {
	AssertValidAsDC();
	return reinterpret_cast<HPEN>(::SelectObject(m_hDC, hPen));
}

inline HPALETTE CMinimalDC::SelectPalette(HPALETTE hPalette, bool bForceBackground) {
	AssertValidAsDC();
	return ::SelectPalette(m_hDC, hPalette, bForceBackground);
}

inline HGDIOBJ CMinimalDC::SelectStockObject(int nObject) {
	AssertValidAsDC();
	return ::SelectObject(m_hDC, ::GetStockObject(nObject));
}

inline int CMinimalDC::SetArcDirection(int nArcDirection) {
	AssertValidAsDC();
	return ::SetArcDirection(m_hDC, nArcDirection);
}

inline COLORREF CMinimalDC::SetBkColor(COLORREF clr) {
	AssertValidAsDC();
	return ::SetBkColor(m_hDC, clr);
}

inline int CMinimalDC::SetBkMode(int nBkMode) {
	AssertValidAsDC();
	return ::SetBkMode(m_hDC, nBkMode);
}

inline POINT CMinimalDC::SetBrushOrg(int x, int y) {
	AssertValidAsDC();

	POINT	pt;
	::SetBrushOrgEx(m_hDC, x, y, &pt);
	return pt;
}

inline POINT CMinimalDC::SetBrushOrg(POINT pt) {
	AssertValidAsDC();

	POINT	pt_;
	::SetBrushOrgEx(m_hDC, pt.x, pt.y, &pt_);
	return pt_;
}

inline bool CMinimalDC::SetColorAdjustment(const LPCOLORADJUSTMENT lpColorAdjust) {
	AssertValidAsDC();
	return toBoolean(::SetColorAdjustment(m_hDC, lpColorAdjust));
}

inline DWORD CMinimalDC::SetMapperFlags(DWORD dwFlag) {
	AssertValidAsDC();
	return ::SetMapperFlags(m_hDC, dwFlag);
}

inline COLORREF CMinimalDC::SetPixel(int x, int y, COLORREF clr) {
	AssertValidAsDC();
	return ::SetPixel(m_hDC, x, y, clr);
}

inline COLORREF CMinimalDC::SetPixel(POINT pt, COLORREF clr) {
	AssertValidAsDC();
	return ::SetPixel(m_hDC, pt.x, pt.y, clr);
}

inline bool CMinimalDC::SetPixelV(int x, int y, COLORREF clr) {
	AssertValidAsDC();
	return toBoolean(::SetPixelV(m_hDC, x, y, clr));
}

inline bool CMinimalDC::SetPixelV(POINT pt, COLORREF clr) {
	AssertValidAsDC();
	return toBoolean(::SetPixelV(m_hDC, pt.x, pt.y, clr));
}

inline int CMinimalDC::SetPolyFillMode(int nPolyFillMode) {
	AssertValidAsDC();
	return ::SetPolyFillMode(m_hDC, nPolyFillMode);
}

inline int CMinimalDC::SetROP2(int nDrawMode) {
	AssertValidAsDC();
	return ::SetROP2(m_hDC, nDrawMode);
}

inline int CMinimalDC::SetStretchBltMode(int nStretchMode) {
	AssertValidAsDC();
	return ::SetStretchBltMode(m_hDC, nStretchMode);
}

inline UINT CMinimalDC::SetTextAlign(UINT nFlags) {
	AssertValidAsDC();
	return ::SetTextAlign(m_hDC, nFlags);
}

inline int CMinimalDC::SetTextCharacterExtra(int nCharExtra) {
	AssertValidAsDC();
	return ::SetTextCharacterExtra(m_hDC, nCharExtra);
}

inline COLORREF CMinimalDC::SetTextColor(COLORREF clr) {
	AssertValidAsDC();
	return ::SetTextColor(m_hDC, clr);
}

inline int CMinimalDC::SetTextJustification(int nBreakExtra, int nBreakCount) {
	AssertValidAsDC();
	return ::SetTextJustification(m_hDC, nBreakExtra, nBreakExtra);
}

inline bool CMinimalDC::StretchBlt(int x, int y, int nWidth, int nHeight,
		HDC hSrcDC, int xSrc, int ySrc, int nSrcWidth, int nSrcHeight, DWORD dwRop) {
	AssertValidAsDC();
	return toBoolean(::StretchBlt(m_hDC,
		x, y, nWidth, nHeight, hSrcDC, xSrc, ySrc, nSrcWidth, nSrcHeight, dwRop));
}

inline SIZE CMinimalDC::TabbedTextOut(int x, int y,
		const TCHAR* lpszText, int cchText, int nTabPositions, int* lpnTabStopPositions, int nTabOrigin) {
	AssertValidAsDC();
	SIZE	size;
	long	n = ::TabbedTextOut(m_hDC, x, y,
		lpszText, cchText, nTabPositions, lpnTabStopPositions, nTabOrigin);

	size.cx = LOWORD(n);
	size.cy = HIWORD(n);
	return size;
}

inline bool CMinimalDC::TextOut(int x, int y, const TCHAR* lpszText, int cchText) {
	AssertValidAsDC();
	return toBoolean(::TextOut(m_hDC, x, y, lpszText, cchText));
}

inline void CMinimalDC::UpdateColors() {
	AssertValidAsDC();
	::UpdateColors(m_hDC);
}


// CDC class implementation
/////////////////////////////////////////////////////////////////////////////


} /* namespace GDI */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _DC_H_ */

/* [EOF] */