// Edit.h
/////////////////////////////////////////////////////////////////////////////

#ifndef __EDIT_H__
#define __EDIT_H__

#include "Window.h"


// CEdit class definition
/////////////////////////////////////////////////////////////////////////////

namespace Manah {
namespace Windows {
namespace Controls {

class CEdit : public CWindow {
	// RXgN^
public:
	CEdit();
	CEdit(const CEdit& rhs);
	virtual ~CEdit();

public:
	// MFC CNȃ\bh
	bool	Create(bool bSubClass, DWORD dwStyle, LPRECT lpRect, HWND hwndParent, UINT id);
	bool	CreateEx(bool nSubClass, DWORD dwExStyle, DWORD dwStyle, LPRECT lpRect, HWND hwndParent, UINT id);
	bool	CanUndo() const;
	int		GetLineCount() const;
	bool	GetModify() const;
	void	SetModify(bool bModified = true);
	void	GetRect(LPRECT lpRect) const;
	DWORD	GetSel() const;
	void	GetSel(int& nStartChar, int& nEndChar) const;
	HLOCAL	GetHandle() const;
	void	SetHandle(HLOCAL hBuffer);
	void	SetMargins(UINT nLeft, UINT nRight);
	DWORD	GetMargins() const;
	UINT	GetLimitText() const;
	void	SetLimitText(UINT nMax);
	POINT	PosFromChar(UINT nChar) const;
	int		CharFromPos(POINT pt) const;
	int		GetLine(int nIndex, LPTSTR lpszBuffer) const;
	int		GetLine(int nIndex, LPTSTR lpszBuffer, int nMaxLength) const;
	TCHAR	GetPasswordChar() const;
	int		GetFirstVisibleLine() const;
	void	EmptyUndoBuffer();
	bool	FmtLines(bool bAddEOL);
	void	LimitText(int nChars = 0);
	int		LineFromChar(int nIndex = -1) const;
	int		LineIndex(int nIndex = -1) const;
	int		LineLength(int nLine = -1) const;
	void	LineScroll(int nLines, int nChars = 0);
	void	ReplaceSel(LPCTSTR lpszNewText, bool nCanUndo = false);
	void	SetPasswordChar(TCHAR ch);
	void	SetRect(LPCRECT lpRect);
	void	SetRectNP(LPCRECT lpRect);
	void	SetSel(DWORD dwSelection, bool bNoScroll = false);
	void	SetSel(int nStartChar, int nEndChar, bool bNoScroll = false);
	void	SetTabStops();
	bool	SetTabStops(const int& cxEachStop);
	bool	SetTabStops(int nTabStop, LPINT rgTabStops);
	void	SetReadOnly(bool bReadOnly = true);

	// ǉ\bh
	void	AdjustOtherWindow(HWND hWnd);
	bool	CanPaste() const;
	void	EnableContextMenu(bool bEnable = true);
	void	EnableIMEContext(bool bEnable = true);
	void	EnableSubmit(bool bEnable = true);
	void	LimitInputChar(const TCHAR* lpszAcceptChars);
	UINT	GetSelCount() const;
	LPCTSTR	GetSelection() const;
	bool	IsReadOnly() const;
	bool	ScrollCaret();
	void	SetFont(HFONT hFont, bool bReDraw = true);

	// I[o[Ch
	bool	Attach(HWND hWnd, bool bSubClass = false);
protected:
	virtual LRESULT	DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam);
	static LRESULT CALLBACK	WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

	// f[^o
private:
	bool	m_bEnableContextMenu;
	HIMC	m_hIMEContext;
	TCHAR*	m_pszAcceptChars;
	bool	m_bReturnToCommand;
};


// CEdit class implementation
/////////////////////////////////////////////////////////////////////////////

inline CEdit::CEdit() : m_bEnableContextMenu(true), m_hIMEContext(0), m_pszAcceptChars(0), m_bReturnToCommand(false) {
}

inline CEdit::CEdit(const CEdit& rhs) : Manah::Windows::Controls::CWindow(rhs) {
	m_bEnableContextMenu = rhs.m_bEnableContextMenu;
	m_hIMEContext = 0;
	m_pszAcceptChars = wcsdup(rhs.m_pszAcceptChars);
	m_bReturnToCommand = rhs.m_bReturnToCommand;
}

inline CEdit::~CEdit() {
	if(m_hIMEContext != 0)
		::ImmAssociateContext(m_hWnd, m_hIMEContext);
	if(m_pszAcceptChars != 0)
		delete[] m_pszAcceptChars;
}

inline bool CEdit::Attach(HWND hWnd, bool bSubClass /* = false */) {
	AssertValid();

	if(IsWindow() || !::IsWindow(hWnd) || m_OldProc != 0)
		return false;
	m_hWnd = hWnd;

	if(bSubClass){
		m_OldProc = reinterpret_cast<WNDPROC>(SetWindowLong(
			GWL_WNDPROC, reinterpret_cast<LPARAM>(CEdit::WndProc)));
		assert(m_OldProc != CEdit::WndProc);
		m_lOldUserData = GetWindowLong(GWL_USERDATA);
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline bool CEdit::Create(bool bSubClass, DWORD dwStyle, LPRECT lpRect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindow(
		_T("Edit"), _T("EditWindow"), dwStyle,
		lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(id),
		reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
		m_OldProc =
			reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(CEdit::WndProc)));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline bool CEdit::CreateEx(bool bSubClass, DWORD dwExStyle, DWORD dwStyle, LPRECT lpRect, HWND hwndParent, UINT id) {
	AssertValid();

	m_hWnd = ::CreateWindowEx(dwExStyle,
		_T("Edit"), _T("EditWindow"), dwStyle,
		lpRect->left, lpRect->top, lpRect->right - lpRect->left, lpRect->bottom - lpRect->top,
		hwndParent, reinterpret_cast<HMENU>(id),
		reinterpret_cast<HINSTANCE>(::GetWindowLong(hwndParent, GWL_HINSTANCE)), 0L);
	if(m_hWnd == 0)
		return false;
	if(bSubClass){
		m_OldProc =
			reinterpret_cast<WNDPROC>(SetWindowLong(GWL_WNDPROC, reinterpret_cast<LPARAM>(CEdit::WndProc)));
		SendMessage(WM_MATTACH, 0, reinterpret_cast<LPARAM>(this));
	}

	return true;
}

inline bool CEdit::CanUndo() const {
	return toBoolean(::SendMessage(m_hWnd, EM_CANUNDO, 0, 0));
}

inline bool CEdit::CanPaste() const {
	return ((IsClipboardFormatAvailable(CF_TEXT)
		|| IsClipboardFormatAvailable(CF_OEMTEXT)) && (!IsReadOnly()));
}

inline LRESULT CEdit::DispatchEvent(UINT message, WPARAM wParam, LPARAM lParam) {
	if(PreTranslateMessage(message, wParam, lParam))
		return false;

	switch(message){
	case WM_CHAR:
		if(m_pszAcceptChars != 0){
			if(_tcschr(m_pszAcceptChars, static_cast<TCHAR>(wParam)) == 0){
				::MessageBeep(MB_OK);
				return false;
			}
		}
		break;
	case WM_CONTEXTMENU:
		if(!m_bEnableContextMenu)
			return false;
		break;
	case WM_KEYDOWN:
		if(static_cast<int>(wParam) == VK_RETURN && m_bReturnToCommand){
			::SendMessage(::GetParent(m_hWnd),
				WM_COMMAND, MAKEWPARAM(GetDlgCtrlID(), IDOK), reinterpret_cast<LPARAM>(m_hWnd));
			return true;
		}
		break;
	}

	return CWindow::DispatchEvent(message, wParam, lParam);
}

inline void CEdit::EnableContextMenu(bool bEnable /* = true */) {
	m_bEnableContextMenu = bEnable;
}

inline void CEdit::EnableIMEContext(bool bEnable /* = true */) {
	AssertValidAsWindow();

	if(bEnable){
		if(m_hIMEContext != 0)
			::ImmAssociateContext(m_hWnd, m_hIMEContext);
		else
			return;
	}else{
		if(m_hIMEContext != 0)
			return;
		else
			m_hIMEContext = ::ImmAssociateContext(m_hWnd, 0);
	}
}

inline void CEdit::EnableSubmit(bool bEnable /* = true */) {
	m_bReturnToCommand = bEnable;
}

inline int CEdit::GetLineCount() const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_GETLINECOUNT, 0, 0));
}

inline bool CEdit::GetModify() const {
	return toBoolean(::SendMessage(m_hWnd, EM_GETMODIFY, 0, 0));
}

inline void CEdit::SetModify(bool bModified /* = true */) {
	::SendMessage(m_hWnd, EM_SETMODIFY, bModified, 0);
}

inline void CEdit::GetRect(LPRECT lpRect) const {
	::SendMessage(m_hWnd, EM_GETRECT, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline DWORD CEdit::GetSel() const {
	return static_cast<DWORD>(::SendMessage(m_hWnd, EM_GETSEL, 0, 0));
}

inline void CEdit::GetSel(int& nStartChar, int& nEndChar) const {
	::SendMessage(m_hWnd, EM_GETSEL, nStartChar, nEndChar);
}

inline HLOCAL CEdit::GetHandle() const {
	return reinterpret_cast<HGLOBAL>(::SendMessage(m_hWnd, EM_GETHANDLE, 0, 0));
}

inline void CEdit::SetHandle(HLOCAL hBuffer) {
	::SendMessage(m_hWnd, EM_SETHANDLE, reinterpret_cast<WPARAM>(hBuffer), 0);
}

inline void CEdit::SetMargins(UINT nLeft, UINT nRight) {
	::SendMessage(m_hWnd, EM_SETMARGINS, EC_LEFTMARGIN | EC_RIGHTMARGIN, MAKELONG(nLeft, nRight));
}

inline DWORD CEdit::GetMargins() const {
	return static_cast<DWORD>(::SendMessage(m_hWnd, EM_GETMARGINS, 0, 0));
}

inline void CEdit::SetLimitText(UINT nMax) {
	::SendMessage(m_hWnd, EM_SETLIMITTEXT, nMax, 0);
}

inline UINT CEdit::GetLimitText() const {
	return static_cast<UINT>(::SendMessage(m_hWnd, EM_GETLIMITTEXT, 0, 0));
}

inline POINT CEdit::PosFromChar(UINT nChar) const {
	DWORD dw;
	POINT point;

	dw =  ::SendMessage(m_hWnd, EM_POSFROMCHAR, nChar, 0);
	point.x = LOWORD(dw);
	point.y = HIWORD(dw);

	return point;
}

inline int CEdit::CharFromPos(POINT pt) const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_CHARFROMPOS, 0, MAKELPARAM(pt.x, pt.y)));
}

inline int CEdit::GetLine(int nIndex, LPTSTR lpszBuffer) const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_GETLINE, nIndex, reinterpret_cast<LPARAM>(lpszBuffer)));
}

inline int CEdit::GetLine(int nIndex, LPTSTR lpszBuffer, int nMaxLength) const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_GETLINE, nIndex, reinterpret_cast<LPARAM>(lpszBuffer)));
}

inline TCHAR CEdit::GetPasswordChar() const {
	return static_cast<TCHAR>(::SendMessage(m_hWnd, EM_GETPASSWORDCHAR, 0, 0));
}

inline int CEdit::GetFirstVisibleLine() const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_GETFIRSTVISIBLELINE, 0, 0));
}

inline void CEdit::EmptyUndoBuffer() {
	::SendMessage(m_hWnd, EM_EMPTYUNDOBUFFER, 0, 0);
}

inline bool CEdit::FmtLines(bool bAddEOL) {
	return toBoolean(::SendMessage(m_hWnd, EM_FMTLINES, bAddEOL, 0));
}

inline void CEdit::LimitText(int nChars /* = 0 */) {
	::SendMessage(m_hWnd, EM_LIMITTEXT, nChars, 0);
}

inline void CEdit::LimitInputChar(const TCHAR* lpszAcceptChars) {
	if(m_pszAcceptChars != 0)
		delete[] m_pszAcceptChars;
	if(lpszAcceptChars == 0)
		m_pszAcceptChars = 0;
	else {
		m_pszAcceptChars = new TCHAR[_tcslen(lpszAcceptChars) + 1];
		_tcscpy(m_pszAcceptChars, lpszAcceptChars);
	}
}

inline int CEdit::LineFromChar(int nIndex /* = -1 */) const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_LINEFROMCHAR, nIndex, 0));
}

inline int CEdit::LineIndex(int nIndex /* = -1 */) const {
	return static_cast<int>(::SendMessage(m_hWnd, EM_LINEINDEX, nIndex, 0));
}

inline int CEdit::LineLength(int nLine /* = -1 */) const {
	return static_cast<int>(
		::SendMessage(m_hWnd, EM_LINELENGTH, ::SendMessage(m_hWnd, EM_LINEINDEX, nLine, 0L), 0L));
}

inline void CEdit::LineScroll(int nLines, int nChars /* = 0 */) {
	::SendMessage(m_hWnd, EM_LINESCROLL, nChars, nLines);
}

inline void CEdit::ReplaceSel(LPCTSTR lpszNewText, bool bCanUndo /* = false */) {
	::SendMessage(m_hWnd, EM_REPLACESEL, bCanUndo, reinterpret_cast<LPARAM>(lpszNewText));
}

inline void CEdit::SetPasswordChar(TCHAR ch) {
	::SendMessage(m_hWnd, EM_SETPASSWORDCHAR, ch, 0);
}

inline void CEdit::SetRect(LPCRECT lpRect) {
	::SendMessage(m_hWnd, EM_SETRECT, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline void CEdit::SetRectNP(LPCRECT lpRect) {
	::SendMessage(m_hWnd, EM_SETRECTNP, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline void CEdit::SetSel(DWORD dwSelection, bool bNoScroll /* = false */) {
	::SendMessage(m_hWnd, EM_SETSEL, LOWORD(dwSelection), HIWORD(dwSelection));
}

inline void CEdit::SetSel(int nStartChar, int nEndChar, bool bNoScroll /* = false */) {
	::SendMessage(m_hWnd, EM_SETSEL, nStartChar, nEndChar);
}

inline void CEdit::SetTabStops() {
	::SendMessage(m_hWnd, EM_SETTABSTOPS, 32, 0);
}

inline bool CEdit::SetTabStops(const int& cxEachStop) {
	return toBoolean(::SendMessage(m_hWnd, EM_SETTABSTOPS, cxEachStop, 0));
}

inline bool CEdit::SetTabStops(int nTabStops, LPINT rgTabStops) {
	return toBoolean(::SendMessage(m_hWnd, EM_SETTABSTOPS, nTabStops, reinterpret_cast<LPARAM>(rgTabStops)));
}

inline void CEdit::SetReadOnly(bool bReadOnly /* = true */) {
	::SendMessage(m_hWnd, EM_SETREADONLY, bReadOnly, 0);
}

inline void CEdit::AdjustOtherWindow(HWND hWnd) {
	DWORD	dwSelection;
	POINT	point;
	RECT	rect;

	dwSelection = GetSel();
	point = PosFromChar(LOWORD(dwSelection));
	::ClientToScreen(m_hWnd, &point);
	::GetWindowRect(hWnd, &rect);

	if(::PtInRect(&rect, point)) {
		if(point.y > rect.bottom - rect.top)
			::OffsetRect(&rect, 0, point.y - rect.bottom - 20);
		else if(point.y + rect.bottom - rect.top < ::GetSystemMetrics(SM_CYSCREEN))
			::OffsetRect(&rect, 0, 40 + point.y - rect.top);
		::MoveWindow(hWnd, rect.left, rect.top, rect.right, rect.bottom, true);
	}
}

inline bool CEdit::IsReadOnly() const {
	return toBoolean(::GetWindowLong(m_hWnd, GWL_STYLE) & ES_READONLY);
}

inline UINT CEdit::GetSelCount() const {
	DWORD dwSel;

	dwSel = ::SendMessage(m_hWnd, EM_GETSEL, 0, 0L);
	return HIWORD(dwSel) - LOWORD(dwSel);
}

inline LPCTSTR CEdit::GetSelection() const {
	int				nTextLength;
	UINT			nSelLength;
	DWORD			dwSel;
	static TCHAR	szWholeText[64 * 1024];

	dwSel = ::SendMessage(m_hWnd, EM_GETSEL, 0, 0L);
	nSelLength = HIWORD(dwSel) - LOWORD(dwSel);
	nTextLength = ::GetWindowTextLength(m_hWnd);
	::GetWindowText(m_hWnd, szWholeText, nTextLength + 1);
	memmove(szWholeText, szWholeText + LOWORD(dwSel), sizeof(_TCHAR) * nSelLength);
	*(szWholeText + nSelLength) = '\0';

	return szWholeText;
}

inline bool CEdit::ScrollCaret() {
	return toBoolean(::SendMessage(m_hWnd, EM_SCROLLCARET, 0, 0L));
}

inline void CEdit::SetFont(HFONT hFont, bool bRedraw /* = true */) {
	::SendMessage(m_hWnd, WM_SETFONT, reinterpret_cast<WPARAM>(hFont), bRedraw);
}

inline LRESULT CALLBACK CEdit::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	CEdit*	pEdit = 0;

	if(message == WM_MATTACH) {
		pEdit = reinterpret_cast<CEdit*>(lParam);
		pEdit->SetWindowLong(GWL_USERDATA, lParam);
		assert(hWnd == pEdit->m_hWnd);
		return pEdit->DispatchEvent(WM_MATTACH, 0, 0L);
	} else {
		pEdit = reinterpret_cast<CEdit*>(::GetWindowLong(hWnd, GWL_USERDATA));
		return (pEdit != 0) ? pEdit->DispatchEvent(message, wParam, lParam) : false;
	}
}

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* __EDIT_H__ */

/* EOF */