// ToolTipCtrl.h
/////////////////////////////////////////////////////////////////////////////

#ifndef _TOOL_TIP_CTRL_H_
#define _TOOL_TIP_CTRL_H_

#include "Window.h"

namespace Manah {
namespace Windows {
namespace Controls {

// CToolTipCtrl class definition
/////////////////////////////////////////////////////////////////////////////

class CToolTipCtrl : public CWindow {
	// \bh
public:
	/* 쐬 */
	bool		Create(HWND hwndParent, HINSTANCE hInstance, DWORD dwStyle = 0);

	/*  */
	void		GetText(TCHAR* lpszText, HWND hWnd, UINT nIDTool = 0) const;
	bool		GetToolInfo(LPTOOLINFO lpToolInfo, HWND hWnd, UINT nIDTool = 0) const;
	void		SetToolInfo(LPTOOLINFO lpToolInfo);
	int			GetToolCount() const;
	int			GetDelayTime(DWORD dwDuration) const;
	void		SetDelayTime(UINT nDelay);
	void		SetDelayTime(DWORD dwDuration, int iTime);
	void		GetMargin(LPRECT lpRect) const;
	void		SetMargin(LPRECT lpRect);
	int			GetMaxTipWidth() const;
	int			SetMaxTipWidth(int nWidth);
	COLORREF	GetTipBkColor() const;
	void		SetTipBkColor(COLORREF clr);
	COLORREF	GetTipTextColor() const;
	void		SetTipTextColor(COLORREF clr);

	/*  */
	bool		Activate(bool bActive);
	bool		AddTool(HWND hWnd, const TCHAR* lpszText, HWND hwndCtrl);
	bool		AddTool(
		HWND hWnd, const TCHAR* lpszText = LPSTR_TEXTCALLBACK,
		LPRECT lpRectTool = 0, UINT nIDTool = 0);
	void		DeleteTool(HWND hWnd, UINT nIDTool = 0);
	void		DeleteTool(HWND hWnd, HWND hwndCtrl);
	bool		HitTest(HWND hWnd, POINT pt, LPTOOLINFO lpToolInfo) const;
	void		RelayEvent(LPMSG lpMsg);
	void		SetToolRect(HWND hWnd, UINT nIDTool, LPRECT lpRect);
	void		UpdateTipText(const TCHAR* lpszText, HWND hWnd, UINT nIDTool = 0);
	void		UpdateTipText(const TCHAR* lpszText, HWND hWnd, HWND hwndCtrl);
	void		Update();
	void		Pop();
};


// CToolTipCtrl class implementation
/////////////////////////////////////////////////////////////////////////////

inline bool CToolTipCtrl::Activate(bool bActive) {
	return toBoolean(SendMessage(TTM_ACTIVATE, bActive));
}

inline bool CToolTipCtrl::AddTool(HWND hWnd, const TCHAR* lpszText, HWND hwndCtrl) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.hwnd = hWnd;
	ti.hinst = reinterpret_cast<HINSTANCE>(::GetWindowLong(hWnd, GWL_HINSTANCE));
	ti.uFlags = TTF_IDISHWND | TTF_SUBCLASS;
	ti.uId = reinterpret_cast<UINT>(hwndCtrl);
	ti.lpszText = const_cast<TCHAR*>(lpszText);

	return toBoolean(SendMessage(TTM_ADDTOOL, 0, reinterpret_cast<LPARAM>(&ti)));
}

inline bool CToolTipCtrl::AddTool(
	HWND hWnd, const TCHAR* lpszText /* = LPSTR_TEXTCALLBACK */,
	LPRECT lpRect /* = 0 */, UINT nIDTool /* = 0 */) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.hwnd = hWnd;
	ti.hinst = reinterpret_cast<HINSTANCE>(::GetWindowLong(hWnd, GWL_HINSTANCE));
	ti.uFlags = TTF_SUBCLASS;
	ti.uId = nIDTool;
	if(lpRect != 0)
		ti.rect = *lpRect;
	else
		::GetWindowRect(::GetDlgItem(hWnd, nIDTool), &ti.rect);
	ti.lpszText = const_cast<TCHAR*>(lpszText);

	return toBoolean(SendMessage(TTM_ADDTOOL, 0, reinterpret_cast<LPARAM>(&ti)));
}

inline bool CToolTipCtrl::Create(HWND hwndParent, HINSTANCE hInstance, DWORD dwStyle /* = 0 */) {
	AssertValid();

	m_hWnd = ::CreateWindow(TOOLTIPS_CLASS, 0, dwStyle, 
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, 
        0, 0, hInstance, 0);

	return (m_hWnd != 0);
}

inline void CToolTipCtrl::DeleteTool(HWND hWnd, UINT nIDTool /* = 0 */) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.hwnd = hWnd;
	ti.uId = nIDTool;

	SendMessage(TTM_DELTOOL, 0, reinterpret_cast<LPARAM>(&ti));
}

inline void CToolTipCtrl::DeleteTool(HWND hWnd, HWND hwndCtrl) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = TTF_IDISHWND;
	ti.hwnd = hWnd;
	ti.uId = reinterpret_cast<unsigned int>(hwndCtrl);

	SendMessage(TTM_DELTOOL, 0, reinterpret_cast<LPARAM>(&ti));
}

inline int CToolTipCtrl::GetDelayTime(DWORD dwDuration) const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, TTM_GETDELAYTIME, dwDuration, 0L));
}

inline void CToolTipCtrl::GetMargin(LPRECT lpRect) const {
	AssertValidAsWindow();
	::SendMessage(m_hWnd, TTM_GETMARGIN, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline int CToolTipCtrl::GetMaxTipWidth() const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, TTM_GETMAXTIPWIDTH, 0, 0L));
}

inline void CToolTipCtrl::GetText(TCHAR* lpszText, HWND hWnd, UINT nIDTool /* = 0 */) const {
	AssertValidAsWindow();

	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.hwnd = hWnd;
	ti.uId = nIDTool;
	ti.lpszText = lpszText;

	::SendMessage(m_hWnd, TTM_GETTEXT, 0, reinterpret_cast<LPARAM>(&ti));
}

inline COLORREF CToolTipCtrl::GetTipBkColor() const {
	AssertValidAsWindow();
	return static_cast<COLORREF>(::SendMessage(m_hWnd, TTM_GETTIPBKCOLOR, 0, 0L));
}

inline COLORREF CToolTipCtrl::GetTipTextColor() const {
	AssertValidAsWindow();
	return static_cast<COLORREF>(::SendMessage(m_hWnd, TTM_GETTIPTEXTCOLOR, 0, 0L));
}

inline int CToolTipCtrl::GetToolCount() const {
	AssertValidAsWindow();
	return static_cast<int>(::SendMessage(m_hWnd, TTM_GETTOOLCOUNT, 0, 0L));
}

inline bool CToolTipCtrl::GetToolInfo(LPTOOLINFO lpToolInfo, HWND hWnd, UINT nIDTool /* = 0 */) const {
	AssertValidAsWindow();
	assert(lpToolInfo != 0);

	ZeroMemory(lpToolInfo, sizeof(TOOLINFO));
	lpToolInfo->cbSize = sizeof(TOOLINFO);
	lpToolInfo->uId = nIDTool;
	lpToolInfo->hwnd = hWnd;

	return toBoolean(::SendMessage(m_hWnd, TTM_GETTOOLINFO, 0, reinterpret_cast<LPARAM>(lpToolInfo)));
}

inline bool CToolTipCtrl::HitTest(HWND hWnd, POINT pt, LPTOOLINFO lpToolInfo) const {
	AssertValidAsWindow();
	assert(lpToolInfo != 0);

	TTHITTESTINFO tthi;

	tthi.hwnd = hWnd;
	tthi.pt = pt;
	tthi.ti = *lpToolInfo;

	return toBoolean(::SendMessage(m_hWnd, TTM_HITTEST, 0, reinterpret_cast<LPARAM>(&tthi)));
}

inline void CToolTipCtrl::Pop() {
	SendMessage(TTM_POP);
}

inline void CToolTipCtrl::RelayEvent(LPMSG lpMsg) {
	SendMessage(TTM_RELAYEVENT, 0, reinterpret_cast<LPARAM>(lpMsg));
}

inline void CToolTipCtrl::SetDelayTime(UINT nDelay) {
	SendMessage(TTM_SETDELAYTIME, TTDT_AUTOPOP, nDelay);
}

inline void CToolTipCtrl::SetDelayTime(DWORD dwDuration, int iTime) {
	SendMessage(TTM_SETDELAYTIME, dwDuration, iTime);
}

inline void CToolTipCtrl::SetMargin(LPRECT lpRect) {
	SendMessage(TTM_SETMARGIN, 0, reinterpret_cast<LPARAM>(lpRect));
}

inline int CToolTipCtrl::SetMaxTipWidth(int nWidth) {
	return static_cast<int>(SendMessage(TTM_SETMAXTIPWIDTH, 0, nWidth));
}

inline void CToolTipCtrl::SetTipBkColor(COLORREF clr) {
	SendMessage(TTM_SETTIPBKCOLOR, clr);
}

inline void CToolTipCtrl::SetTipTextColor(COLORREF clr) {
	SendMessage(TTM_SETTIPTEXTCOLOR, clr);
}

inline void CToolTipCtrl::SetToolInfo(LPTOOLINFO lpToolInfo) {
	SendMessage(TTM_SETTOOLINFO, 0, reinterpret_cast<LPARAM>(lpToolInfo));
}

inline void CToolTipCtrl::SetToolRect(HWND hWnd, UINT nIDTool, LPRECT lpRect) {
	assert(lpRect != 0);

	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.uId = nIDTool;
	ti.hwnd = hWnd;

	SendMessage(TTM_GETTOOLINFO, 0, reinterpret_cast<LPARAM>(&ti));
	ti.rect = *lpRect;
	SendMessage(TTM_SETTOOLINFO, 0, reinterpret_cast<LPARAM>(&ti));
}

inline void CToolTipCtrl::Update() {
	SendMessage(TTM_UPDATE);
}

inline void CToolTipCtrl::UpdateTipText(const TCHAR* lpszText, HWND hWnd, UINT nIDTool /* = 0 */) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.hinst = reinterpret_cast<HINSTANCE>(::GetWindowLong(hWnd, GWL_HINSTANCE));
	ti.uId = nIDTool;
	ti.hwnd = hWnd;
	ti.lpszText = const_cast<TCHAR*>(lpszText);

	SendMessage(TTM_UPDATETIPTEXT, 0, reinterpret_cast<LPARAM>(&ti));
}

inline void CToolTipCtrl::UpdateTipText(const TCHAR* lpszText, HWND hWnd, HWND hwndCtrl) {
	TOOLINFO ti;

	ZeroMemory(&ti, sizeof(TOOLINFO));
	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = TTF_IDISHWND;
	ti.hinst = reinterpret_cast<HINSTANCE>(::GetWindowLong(hWnd, GWL_HINSTANCE));
	ti.uId = reinterpret_cast<unsigned int>(hwndCtrl);
	ti.hwnd = hWnd;
	ti.lpszText = const_cast<TCHAR*>(lpszText);

	SendMessage(TTM_UPDATETIPTEXT, 0, reinterpret_cast<LPARAM>(&ti));
}

} /* namespace Controls */
} /* namespace Windows */
} /* namespace Manah */

#endif /* _TOOL_TIP_CTRL_H_ */

/* [EOF] */