#ifndef ALTBASE_H
#define ALTBASE_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altBase.h 663 2007-11-16 22:18:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altBase.h
 * \brief   Base Class
 * \date    2007
 * \author  NEKO SYSTEM
 */

/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define ALT_NEW new (__FILE__, __LINE__)

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  base class
///
class altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altBase();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altBase();

  ///
  /// \brief  new operator
  ///
  /// \param  nSize [I ] memory size
  ///
  /// \return pointer of memory
  ///
  LIBALT_API void * operator new(altUInt nSize);

  ///
  /// \brief  delete operator
  ///
  /// \param  pPtr  [I ] pointer of memory
  ///
  LIBALT_API void operator delete(void * pPtr);

  ///
  /// \brief  new operator
  ///
  /// \param  nSize       [I ] memory size
  /// \param  szFileName  [I ] file name
  /// \param  nLine       [I ] line numnber
  ///
  /// \return pointer of memory
  ///
  LIBALT_API void * operator new(altUInt nSize, const altChar * szFileName, const altUInt nLine);

  ///
  /// \brief  delete operator
  ///
  /// \param  pPtr        [I ] pointer of memory
  /// \param  szFileName  [I ] file name
  /// \param  nLine       [I ] line numnber
  ///
  LIBALT_API void operator delete(void * pPtr, const altChar * szFileName, const altUInt nLine);
};

#endif

