#ifndef ALTDBCONNECTIONPTR_H
#define ALTDBCONNECTIONPTR_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBConnectionPtr.h 327 2007-09-13 01:22:22Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBConnectionPtr.h
 * \brief   DB Connection Pointer Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnection.h>
#include <altDB/altDBManager.h>

class altDBManager;
/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DB Connection Pointer
///
class altDBConnectionPtr : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDBConnectionPtr();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBConnectionPtr();

  ///
  /// \brief  Set Pointer
  ///
  /// \param  pDBConnection   [I ] Pointer of DB Connection
  /// \param  pDBManager      [I ] Pointer of DB Manager
  ///
  LIBALT_API alt_t Set(altDBConnection * pDBConnection, altDBManager * pDBManager);

  ///
  /// \brief  operator ->
  ///
  /// \return Pointer of DB Connection
  ///
  LIBALT_API altDBConnection * operator -> () const;

private:
  altDBConnection *   m_pDBConnection;
  altDBManager *      m_pDBManager;
};

#endif //ALTDBCONNECTIONPTR_H
