#ifndef ALTDBMANAGER_H
#define ALTDBMANAGER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBManager.h 327 2007-09-13 01:22:22Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBManager.h
 * \brief   DB Connection Manager Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBConnectionPtr.h>
#include <altBase/altSyncThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
///
/// \brief  Data Base Type
///
enum altDBTypes {
  ALT_DB_TYPE_MYSQL = 0,    ///< MySQL
};

typedef std::vector<altDBConnection *> altDBConnectionContainer;

class altDBConnectionPtr;
/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  DB Connection Manager
///
class altDBManager : public altBase, private altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  /// \param  nDBType   [I ] DB Type
  ///
  altDBManager(const altDBTypes nDBType);

  ///
  /// \brief  Destructor
  ///
  ~altDBManager();

  ///
  /// \brief  Initialize
  ///
  /// \param  sHost     [I ] DB Host Name
  /// \param  nPort     [I ] DB Port Number
  /// \param  sDB       [I ] DB Name
  /// \param  sUser     [I ] DB User ID
  /// \param  sPasswd   [I ] DB Password
  /// \param  sCharset  [I ] DB Character Set
  /// \param  nPool     [I ] DB Connection Pool Count
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  alt_t Init(const altStr & sHost, const altInt nPort, const altStr & sDB, const altStr & sUser, const altStr & sPasswd, const altStr & sCharset, const altUInt nPool);

  ///
  /// \brief  Get DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  alt_t GetDBConnection(altDBConnectionPtr & pDBConnection);

  ///
  /// \brief  Release DB Connection
  ///
  /// \param  pDBConneection  [IO] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  alt_t ReleaseDBConnection(altDBConnection * & pDBConnection);

private:
  ///
  /// \brief  Get DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  alt_t GetDBConnection(altDBConnection * & pDBConnection);

  ///
  /// \brief  Create DB Connection
  ///
  /// \param  pDBConnection [ O] DB Connection
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_NOMEM     Out of memory
  /// \return ALT_E_ERROR     Error
  ///
  alt_t CreateDBConnection(altDBConnection * & pDBConnection);


  altDBTypes                m_nDBType;        ///< DB Type
  altDBConnectionContainer  m_oConnections;   ///< DB Connection Container
};

#endif //ALTDBMANAGER_H
