#ifndef ALTDBRESULTSET_H
#define ALTDBRESULTSET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altDBResultSet.h 320 2007-09-04 11:49:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altDBResultSet.h
 * \brief   DB Result Set Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altDBRow.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::vector<altDBRow> altResultContainer; ///< DB Record Container

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  Result Set
///
class altDBResultSet : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altDBResultSet();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altDBResultSet();

  ///
  /// \brief  Add Row
  ///
  /// \param  oRow  [I ] Row Data
  ///
  /// \return ALT_S_SUCCESS
  ///
  LIBALT_API alt_t Add(const altDBRow & oRow);

  ///
  /// \brief  Get Size
  ///
  /// \return Row Count
  ///
  LIBALT_API altUInt Size() const;

  ///
  /// \brief  [] operator
  ///
  /// \param  nIndex [I ] index
  ///
  /// \return Row Data of index position
  ///
  LIBALT_API const altDBRow & operator [](const altUInt nIndex) const ALT_THROWS (alt_t);

private:
  altResultContainer  m_oResultData;  ///< DB Result Set Data
};

#endif //ALTDBRESULTSET_H

