#ifndef ALTSQL_H
#define ALTSQL_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSQL.h 330 2007-09-14 09:53:43Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSQL.h
 * \brief   SQL Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altStr.h>
#include <altBase/altStatus.h>
#include <altBase/altLog.h>
#include <altBase/altBase.h>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SQL
///
class altSQL : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSQL();

  ///
  /// \brief  Copy Constructor
  ///
  /// \param  oSQL  [I ] SQL
  ///
  LIBALT_API altSQL(const altSQL & oSQL);

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSQL();

  ///
  /// \brief  Set SQL
  ///
  /// \param  sSQL      [I ] SQL
  /// \param  sSQLName  [I ] SQL Name
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t SetSQL(const altStr & sSQL, const altStr & sSQLName);

  ///
  /// \brief  Get SQL
  ///
  /// \return SQL
  ///
  LIBALT_API const altStr & GetSQL() const;

  ///
  /// \brief  Get SQL Name
  ///
  /// \return SQL Name
  ///
  LIBALT_API const altStr & GetSQLName() const;

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  sValue    [I ] Value
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t Set(const altStr & sVarName, const altStr & sValue);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetChar(const altStr & sVarName, const altChar nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetUChar(const altStr & sVarName, const altUChar nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetByte(const altStr & sVarName, const altByte nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetShort(const altStr & sVarName, const altShort nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetUShort(const altStr & sVarName, const altUShort nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetInt(const altStr & sVarName, const altInt nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetUInt(const altStr & sVarName, const altUInt nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetLong(const altStr & sVarName, const altLong nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetULong(const altStr & sVarName, const altULong nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  dwVal     [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetDWORD(const altStr & sVarName, const DWORD dwVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetLongLong(const altStr & sVarName, const altLongLong nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  nVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetULongLong(const altStr & sVarName, const altULongLong nVal);

  ///
  /// \brief  Set Value
  ///
  /// \param  sVarName  [I ] Variable Name
  /// \param  sVal      [I ] Value
  ///
  /// \param  ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetStr(const altStr & sVarName, const altStr & sVal);

private:
  altStr  m_sSQL;     ///< SQL
  altStr  m_sSQLName; ///< SQL Name
};

#endif // ALTSQL_H

