#ifndef ALTSQLLOADER_H
#define ALTSQLLOADER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altSQLLoader.h 326 2007-09-12 10:52:48Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altSQLLoader.h
 * \brief   SQL Loader Class
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altDB/altSQL.h>
#include <altDB/altDBConnection.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
/// \return altSQLLoader Instance
///
#define aiSQLLoader altSQLLoader::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
typedef std::map<altStr, altChar *> altSQLContainer;

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  SQL Loader
///
class altSQLLoader : public altSingleton<altSQLLoader>
{
friend class altSingleton<altSQLLoader>;
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altSQLLoader();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altSQLLoader();

public:
  ///
  /// \brief  Set Directory
  ///
  /// \param  sDir  [I ] Directory Path
  ///
  /// \return ALT_S_SUCCESS   Success
  ///
  LIBALT_API alt_t SetDir(const altStr & sDir);

  ///
  /// \brief  Get SQL
  ///
  /// \param  sFilePath   [I ] File Path
  /// \param  oSQL        [ O] SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQL(const altStr & sFilePath, altSQL & oSQL);

  ///
  /// \brief  Get Prepared Statement SQL
  ///
  /// \param  sFilePath     [I ] File Path
  /// \param  oDBConnection [I ] DB Connection
  /// \param  pStmt         [ O] Prepared Statement SQL
  ///
  /// \return ALT_S_SUCCESS   Success
  /// \return ALT_E_ERROR     Error
  ///
  LIBALT_API alt_t GetSQL(const altStr & sFilePath, altDBConnection & oDBConnection, altPreparedStatement * & pStmt);

private:
  altSQLContainer m_oSQLContainer;  ///< SQL Container
  altStr          m_sBaseDir;       ///< SQL Base Directory
};
#endif  //ALTSQLLOADER_H
