#ifndef ALTIME_H
#define ALTIME_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altIME.h 789 2008-01-17 06:44:05Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altIME.h
 * \brief   IME Control
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altDX/altIMEComponent.h>
#include <altBase/altStr.h>
#include <altBase/altWStr.h>
#include <altBase/altLog.h>
#include <altBase/altSingleton.h>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get Instance
///
#define aiIME altIME::GetInstance()

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  IME Control
///
class altIME : public altSingleton<altIME>
{
friend class altSingleton<altIME>;
private:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altIME();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API ~altIME();

public:
  ///
  /// \brief  Initialize
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Init();

  ///
  /// \brief  Set IME Mode
  ///
  /// \param  bIMEMode      [I ] IME mode
  /// \param  bImEOpenMode  [I ] IME open mode
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t SetIMEMode(const altBool bIMEMode, const BOOL bIMEOpenMode);

  ///
  /// \brief  Get IME Mode
  ///
  /// \return true    ON
  /// \return false   OFF
  ///
  LIBALT_API altBool GetIMEMode();

  ///
  /// \brief  Set IME data
  ///
  /// \param  sData [I ] IME Data
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t SetIMEData(const altWStr & sData);

  ///
  /// \brief  Get IME Data
  ///
  /// \return IME Data
  ///
  LIBALT_API altWStr GetIMEData();

  ///
  /// \brief  Get IME Back Data
  ///
  /// \return IME Back Data
  ///
  LIBALT_API altWStr GetIMEDataBack();

  ///
  /// \brief  Clear IME Data
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t ClearIMEData();

  ///
  /// \brief  Set IME component
  ///
  /// \param  pIMEComponent [I ] Pointer of IME component
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t SetIMEComponent(altIMEComponent * pIMEComponent);

  ///
  /// \brief  Window Procedure
  ///
  /// \param  hwnd    [I ] Window handle
  /// \param  msg     [I ] message
  /// \param  wParam  [I ] parameter
  /// \param  lParam  [I ] parameter
  ///
  LIBALT_API LRESULT WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);

  ///
  /// \brief  Check East Asian languages that are not
  ///
  /// \param  HKL [I ] Keyboard layout handle
  ///
  /// \return true  East Asian languages
  /// \return false Not East Asian languages
  ///
  LIBALT_API altBool IsEastAsianLanguages(HKL hKL);

  ///
  /// \brief  Get altIME Instance
  ///
  /// \return altIME Instance
  ///
  LIBALT_API static altIME & GetInstance();

  ///
  /// \brief  Delte Instance
  ///
  LIBALT_API static void DeleteInstance();

  altLong             m_nCursorPosition;  ///< Cursor position

private:
  altBool             m_bIMEMode;         ///< IME mode(on/off) flag
  altWStr             m_sIMEData;         ///< IME data buffer
  altWStr             m_sIMEDataBack;
  altIMEComponent *   m_pIMEComponent;    ///< IME Component
};

#endif
#endif
