#ifndef ALTIMECOMPONENT_H
#define ALTIMECOMPONENT_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altIMEComponent.h 773 2007-12-19 22:00:50Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altIMEComponent.h
 * \brief   IME Control Component
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_WIN
#include <altBase/altWStr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  IME Control Component
///
class altIMEComponent : public altBase
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altIMEComponent();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altIMEComponent();

  ///
  /// \brief  Input IME word
  ///
  /// \param  sData [I ] IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t InputIMEWord(const altWStr & sData) = 0;

  ///
  /// \brief  Send IME word
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API virtual alt_t SendIMEWord(const altWStr & sData) = 0;
};

#endif
#endif
